from pathlib import Path
from datetime import datetime
from allytools.units import Length, LengthUnit
from scanner3d.scanners.ScannersDB import ScannersDB
from scanner3d.test.tests.major_frames import MajorFrames
from scanner3d.test.tests.album_radial import AlbumRadial
from scanner3d.test.tests.album_sparse_grid import AlbumSparceGrid
from scanner3d.test.test_suit import TestSuite
from scanner3d.test.tests.ray_matrix import RayMatrix
from zempy.bridge.zempy_session import zempy_session
from scanner3d.zemod.zemod import ZeMod
from scanner3d.test.log_setup import LoggerSetup


if __name__ == "__main__":
    today = datetime.now().strftime("%Y%m%d")
    scanner = ScannersDB.Spider2ProB
    camera = scanner.cameras[0]
    camera_name = scanner.name
    output_root = Path(__file__).parent / "output" / f"{camera_name}_{today}"
    output_root.mkdir(parents=True, exist_ok=True)
    timestamp = datetime.now().strftime("%Y-%m-%d_%H-%M-%S")
    full_log_path = output_root / f"full_test_log_{timestamp}.log"
    log = LoggerSetup.configure(__name__, log_file=full_log_path)
    zmx_path = camera.objective.zmx_file
    tests = TestSuite(
        [
            MajorFrames(n_samples=5),
            AlbumRadial(dr_mm=Length(500,LengthUnit.UM), dz_mm=Length(5)),
            AlbumSparceGrid(divider=500, dz_mm=Length(5)),
            #RayMatrix(),
        ]
    )
    try:
        with zempy_session(zmx_path) as (_zs, s):
            zemod = ZeMod.from_optical_system(optical_system=s)
            tests.run(zemod=zemod, camera=camera, output_root=output_root)
        failed = []
        for t in tests:
            if t.success:
                mark = "✔"
            else:
                mark ="✖"
                failed.append(t.test_name)
            log.info(f"{mark} {t.test_name} elapsed time {t.elapsed:.2f} s")
        if failed:
            log.error("Failed tests: " + ", ".join(failed))
        log.info("Full log saved to: %s", full_log_path)
    except Exception:
        log.exception("Unexpected error during test run")
