from __future__ import annotations
from dataclasses import dataclass
from enum import Enum
from typing import Optional
from allytools.units import Length
from scanner3d.zemod.enums.enums import ZeModFieldTypes, ZeModFieldNormalizationType



class WavelengthCriteria(Enum):
    Primary = "Primary"

class FocusDistanceCriteria(Enum):
    BestFocus = "Best focus position from camera"
    AverageFocus = "Avarage between zmin and zmax"

@dataclass
class TestSettings:
    field_type: ZeModFieldTypes = ZeModFieldTypes.RealImageHeight
    filed_normalization : ZeModFieldNormalizationType = ZeModFieldNormalizationType.Rectangular
    focus_distance_criteria: Optional[FocusDistanceCriteria] =None
    wavelength_criteria: Optional[WavelengthCriteria] = None
    test_field_number: Optional[int] = None
    test_grid_index: Optional[int] = None
    edge_field_x: Optional[float] = None
    edge_field_y: Optional[float] = None

