from zempy.zosapi.systemdata.enums.field_type import FieldType
from zempy.zosapi.tools.raytrace.enums.rays_type import RaysType
from zempy.zosapi.systemdata.enums.field_normalization_type import FieldNormalizationType
from zempy.zosapi.analysis.fftpsf.enums.fft_psf_type import FftPsfType
from zempy.zosapi.analysis.fftpsf.enums.psf_sampling import PsfSampling
from zempy.zosapi.analysis.fftpsf.enums.psf_rotation import PsfRotation
from enum import Enum
from typing import Type, cast


def clone_enum(name: str, native_enum: Type[Enum]) -> Type[Enum]:
    """
    Create a bridge Enum whose members mirror the native enum.
    Each member's value *is* the native enum member.
    """
    # Build mapping: {"Name": native_enum.Name}
    mapping = {member.name: member for member in native_enum}

    # Create enum dynamically
    cls = Enum(name, mapping)

    # Attach helpers
    @property
    def native(self):
        return self.value

    def __int__(self):
        return int(self.value)

    setattr(cls, "native", native)
    setattr(cls, "__int__", __int__)

    return cls


ZeModFieldTypes = clone_enum("ZeModFieldTypes", FieldType) # type: ignore[assignment]
ZeModRayType    = clone_enum("ZeModRayType", RaysType) # type: ignore[assignment]
ZeModFieldNormalizationType = clone_enum("ZeModFieldNormalizationType", FieldNormalizationType) # type: ignore[assignment]
ZeModPsfRotation = clone_enum("ZeModFieldPsfRotation", PsfRotation) # type: ignore[assignment]
ZeModPsfSampling = clone_enum("ZeModPsfSampling", PsfSampling) # type: ignore[assignment]
ZeModFftPsfType = clone_enum("ZeModFftPsfType", FftPsfType) # type: ignore[assignment]
