from __future__ import annotations
from dataclasses import dataclass
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from zempy.zosapi.analysis.data.protocols.iar_data_grid import IAR_DataGrid
    from scanner3d.zemod.iar.i_data_grid import IDataGrid


@dataclass(slots=True)
class GridMeta:
    min_x: float
    min_y: float
    dx: float
    dy: float
    description: str = ""
    x_label: str = ""
    y_label: str = ""
    value_label: str = ""

    @classmethod
    def from_zempy(cls, dg: "IAR_DataGrid") -> "GridMeta":
        return cls(
            min_x=float(dg.MinX),
            min_y=float(dg.MinY),
            dx=float(dg.Dx),
            dy=float(dg.Dy),
            description=str(dg.Description),
            x_label=str(dg.XLabel),
            y_label=str(dg.YLabel),
            value_label=str(dg.ValueLabel),
        )

    @classmethod
    def from_grid(cls, grid: "IDataGrid") -> "GridMeta":
        """Build metadata snapshot from any IDataGrid implementation."""
        return cls(
            min_x=grid.min_x,
            min_y=grid.min_y,
            dx=grid.dx,
            dy=grid.dy,
            description=getattr(grid, "description", ""),
            x_label=getattr(grid, "x_label", ""),
            y_label=getattr(grid, "y_label", ""),
            value_label=getattr(grid, "value_label", ""),
        )
