from __future__ import annotations
from typing import Protocol
import numpy as np
from numpy.typing import NDArray


class IGridMeta(Protocol):
    """
    Geometry + labels for a rectilinear 2D grid.

    Implementors MUST provide:
      - min_x, min_y
      - dx, dy
      - description, x_label, y_label, value_label
      - shape (ny, nx)
    All other attributes are derived by default.
    """

    # --- primitives that MUST be implemented ---

    @property
    def min_x(self) -> float: ...
    @property
    def min_y(self) -> float: ...
    @property
    def dx(self) -> float: ...
    @property
    def dy(self) -> float: ...

    @property
    def description(self) -> str: ...
    @property
    def x_label(self) -> str: ...
    @property
    def y_label(self) -> str: ...
    @property
    def value_label(self) -> str: ...

