from __future__ import annotations
from typing import TYPE_CHECKING
from scanner3d.zemod.core.native_adapter import NativeAdapter
from scanner3d.zemod.iar.zemod_data_grid import ZeModDataGrid
from datetime import datetime, timedelta
if TYPE_CHECKING:
    from zempy.zosapi.analysis.iar.protocols.iar_ import IAR_



class ZeModIAR(NativeAdapter["IAR_"]):
    __slots__ = ()

    def get_data_grid(self,index: int) -> ZeModDataGrid:
        return ZeModDataGrid(self.native.GetDataGrid(index))

    def get_first_grid(self):
        return self.get_data_grid(0)

    @property
    def description(self)->str:
        return self.native.MetaData.FeatureDescription

    @property
    def date_iso(self)->str:
        return self.native.MetaData.DateISO

    @property
    def lens_file(self)->str:
        return self.native.MetaData.LensFile