# Generated by Django 4.2.10 on 2024-04-02 10:54

from django.db import migrations, models


def update_chat_model(apps, schema_editor):
    ChatModelOptions = apps.get_model("database", "ChatModelOptions")
    for chat_model_option in ChatModelOptions.objects.filter(chat_model="mistral-7b-instruct-v0.1.Q4_0.gguf"):
        chat_model_option.chat_model = "NousResearch/Hermes-2-Pro-Mistral-7B-GGUF"
        chat_model_option.save()


def reverse_update_chat_model(apps, schema_editor):
    ChatModelOptions = apps.get_model("database", "ChatModelOptions")
    for chat_model_option in ChatModelOptions.objects.filter(chat_model="NousResearch/Hermes-2-Pro-Mistral-7B-GGUF"):
        chat_model_option.chat_model = "mistral-7b-instruct-v0.1.Q4_0.gguf"
        chat_model_option.save()


class Migration(migrations.Migration):
    dependencies = [
        ("database", "0033_rename_tuning_agent_personality"),
    ]

    operations = [
        migrations.AlterField(
            model_name="chatmodeloptions",
            name="chat_model",
            field=models.CharField(default="NousResearch/Hermes-2-Pro-Mistral-7B-GGUF", max_length=200),
        ),
        migrations.RunPython(update_chat_model, reverse_code=reverse_update_chat_model),
    ]
