# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/defaults.ipynb.

# %% auto 0
__all__ = ['setup_mpl', 'notebook', 'setup_np', 'setup_pd', 'setup_torch']

# %% ../nbs/defaults.ipynb 3
def setup_mpl(pyplot_instance=None): 
    """Default setup for matplotlib."""
    if pyplot_instance is None:
        if "plt" not in globals():
            try:
                import matplotlib.pyplot as plt
                globals()["plt"] = plt
            except ImportError:
                raise ImportError("matplotlib is not installed") 
    else:
        plt = pyplot_instance
    
    plt.rcParams["image.cmap"] = "inferno"

# %% ../nbs/defaults.ipynb 4
def notebook():
    """Default setup for jupyter notebooks"""
    from IPython.core.display import display, HTML
    display(HTML("<style>.container { width:100% !important; }</style>"))

# %% ../nbs/defaults.ipynb 5
def setup_np(numpy_instance=None):
    """Default setup for NumPy"""
    global np
    if numpy_instance is None: 
        if "np" not in globals():
            try:
                import numpy as np
            except ImportError:
                raise ImportError("NumPy is not installed") 
    else:
        np = numpy_instance
    np.set_printoptions(precision=4, linewidth=120)    

# %% ../nbs/defaults.ipynb 6
def setup_pd(pandas_instance=None):
    """Default setup for pandas"""
    global pd
    if pandas_instance is None:
        if "pd" not in globals():
            try:
                import pandas as pd
            except ImportError:
                raise ImportError("pandas is not installed") 
    else:
        pd = pandas_instance
    
    pd.set_option("display.max_rows", 1000)
    pd.set_option("display.max_columns", 1000)

# %% ../nbs/defaults.ipynb 7
def setup_torch(torch_instance=None):
    """Default setup for PyTorch"""
    if torch_instance is None:
        if "torch" not in globals():
            try:
                import torch
                global torch
            except ImportError:
                raise ImportError("torch is not installed") 
    else:
        torch = torch_instance
    
    torch.set_printoptions(precision=4, linewidth=120)
