# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/utils.ipynb.

# %% auto 0
__all__ = ['console', 'print_ts', 'pmu', 'NS', 'vprint', 'sprint', 'mem_usage']

# %% ../nbs/utils.ipynb 3
from typing import Literal
import psutil
import rich
import time
import multiprocessing
import tracemalloc
import pandas as pd
import numpy as np
import datetime

# %% ../nbs/utils.ipynb 4
def pmu(
    description: str = None,  # Optional, use to give descriptive log for the memory usage at a particular point in the code.
    mode: Literal["both", "cpu", "gpu"] = "both",  # Specify which memory to print. Options are "cpu", "gpu", or "both" (the default).
):
    """Print memory usage
    
    
    """
    if description:
       print(description) 
    
    if mode in ("cpu", "both"):
        main_process = psutil.Process()
        child_processes = main_process.children(recursive=True)
        total_memory_usage = main_process.memory_info().rss
        for child in child_processes:
            total_memory_usage += child.memory_info().rss
        print(f"CPU Memory usage: {total_memory_usage / 1024 ** 2:.2f} MB")
        
    if mode in ("gpu", "both"):
        try:
            from pynvml import nvmlInit, nvmlDeviceGetHandleByIndex, nvmlDeviceGetMemoryInfo
        except ImportError as e:
            e.args += "Checking gpu memory is only supported for Nvidia devices and requires the pynvml library to be installed"
            raise e

        nvmlInit()
        handle = nvmlDeviceGetHandleByIndex(0)
        info = nvmlDeviceGetMemoryInfo(handle)
        print("GPU Memory Usage:")
        print(f"Total: {info.total / 1024**2:.2f} MiB")
        print(f"Used: {info.used / 1024**2:.2f} MiB")
        print(f"Free: {info.free / 1024**2:.2f} MiB")

# %% ../nbs/utils.ipynb 5
class NS:
    """Class to store state of variables in the global namespace
    
    Useful for tracking changes to the global namespace at various points in the code.
    Particularly useful for use in a Jupyter notebook.
    """
    def __init__(self):
        self.initial_variables = copy.copy(globals())

    def __call__(self):
        current_variables = copy.copy(globals())

        added = set(current_variables) - set(self.initial_variables)
        removed = set(self.initial_variables) - set(current_variables)
        modified = {
            key for key in (set(current_variables) & set(self.initial_variables))
            if current_variables[key] != self.initial_variables[key]
        }

        print("Added variables:")
        print(added)
        print("\nRemoved variables:")
        print(removed)
        print("\nModified variables:")
        print(modified)

# %% ../nbs/utils.ipynb 6
def vprint(message):
    """Give functions has a verbose: bool parameter, and add vprint statements to print messages only when verbose is True"""
    import inspect
    local_vars = inspect.currentframe().f_back.f_locals
    if local_vars.get("verbose", False):
        print(message)

# %% ../nbs/utils.ipynb 8
console = Console()
print_ts = time.time()

def sprint(*args, **kwargs) -> None:
    global print_ts
    now = time.time()
    proc = multiprocessing.current_process().name
    if proc == "MainProcess":
        proc = f"[bold]{proc:<16}[/bold]"
    else:
        proc = f"{proc:>16}"
    console.print(f"{proc} [[green bold]{now - print_ts:>5.2f}s[/]]", *args, **kwargs)
    print_ts = now
    
def mem_usage() -> str:
    current, peak = tracemalloc.get_traced_memory()
    return f"Memory usage: {current//1024//1024} MB; peak: {peak//1024//1024} MB"
