#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
from os import path
from setuptools import setup, find_packages, Command

import database_deadlock

CURRENT_DIR = os.path.abspath(os.path.dirname(__file__))

this_directory = path.abspath(path.dirname(__file__))
try:
    with open(path.join(this_directory, 'README.md'), encoding='utf-8') as f:
        long_description = f.read()
except TypeError:
    with open(path.join(this_directory, 'README.md')) as f:
        long_description = f.read()

def get_reqs(*fns):
    lst = []
    for fn in fns:
        for package in open(os.path.join(CURRENT_DIR, fn)).readlines():
            package = package.strip()
            if not package:
                continue
            lst.append(package.strip())
    return lst

setup(
    name='django-deadlock',
    version=database_deadlock.__version__,
    description='Provides a Django admin view listing deadlocks.',
    long_description=long_description,
    long_description_content_type='text/markdown',
    author='Chris Spencer',
    author_email='chrisspen@gmail.com',
    url='http://gitlab.com/chrisspen/django-deadlock',
    packages=find_packages(),
    package_data={
        'database_deadlock': [
            'sql/*.*',
        ],
    },
    # https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Development Status :: 4 - Beta',
        # 'Development Status :: 5 - Production/Stable',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: PL/SQL',
    ],
    install_requires=get_reqs('requirements-min-django.txt', 'requirements.txt'),
    tests_require=get_reqs('requirements-test.txt'),
)
