# This file is part of the faebryk project
# SPDX-License-Identifier: MIT

import faebryk.library._F as F
from faebryk.core.moduleinterface import ModuleInterface
from faebryk.libs.library import L
from faebryk.libs.units import P


class CAN_TTL(ModuleInterface):
    rx: F.ElectricLogic
    tx: F.ElectricLogic

    speed = L.p_field(units=P.bps)

    @L.rt_field
    def single_electric_reference(self):
        return F.has_single_electric_reference_defined(
            F.ElectricLogic.connect_all_module_references(self)
        )

    def __preinit__(self) -> None:
        self.speed.add(F.is_bus_parameter())
