# CLI Usage Guide

## Quick Start

### 1. Activate Virtual Environment

**Windows PowerShell:**
```powershell
.\venv\Scripts\Activate.ps1
```

If you get an execution policy error:
```powershell
.\venv\Scripts\activate.bat
```

**Windows Command Prompt:**
```cmd
venv\Scripts\activate.bat
```

### 2. Use the CLI

Once activated, the `rispec` command is available:

```bash
rispec --help
```

## Commands

### `rispec analyze <repo_path>`

Analyze repository structure and dependencies.

**Options:**
- `--top-n <number>`: Number of top modules to show (default: 10)
- `--json`: Output results as JSON

**Examples:**
```bash
# Basic analysis
rispec analyze ./my-project

# Show top 5 modules
rispec analyze ./my-project --top-n 5

# Get JSON output
rispec analyze ./my-project --json

# Combined options
rispec analyze ./my-project --top-n 5 --json
```

### `rispec config`

Show current configuration settings.

**Options:**
- `--interactive`, `-i`: Open interactive configuration menu

**Examples:**
```bash
# Show current configuration
rispec config

# Open interactive configuration menu
rispec config --interactive
# or
rispec config -i
```

**Output includes:**
- Data directory
- Max repository LOC threshold
- Indexing timeout
- Max patch size
- OpenAI model
- API key status

**Interactive Configuration Menu:**

When you run `rispec config --interactive`, you'll see a menu with options:

1. **Set OpenAI API Key** - Securely enter your OpenAI API key (input is hidden)
2. **Select OpenAI Model** - Choose from available models:
   - gpt-5.1
   - gpt-4-turbo-preview
   - gpt-4
   - gpt-4-32k
   - gpt-3.5-turbo
   - gpt-3.5-turbo-16k
3. **Show full configuration** - Display all current settings
4. **Exit** - Save and exit

All changes are automatically saved to the `.env` file in your project directory.

### `rispec --help`

Show help message and available commands.

### `rispec --version`

Show version information.

## Alternative Invocation Methods

### Method 1: Direct Command (After Installation)

```bash
# Activate venv first
.\venv\Scripts\activate

# Then use rispec directly
rispec analyze <repo_path>
```

### Method 2: Python Module (No Activation Needed)

```bash
# Windows PowerShell
.\venv\Scripts\python.exe -m rispec.cli analyze <repo_path>
.\venv\Scripts\python.exe -m rispec.cli config
```

### Method 3: Direct Python Execution

```bash
.\venv\Scripts\python.exe rispec/cli.py analyze <repo_path>
```

**Note:** Method 1 is recommended as it's the cleanest and most user-friendly.

## Troubleshooting

### "ModuleNotFoundError: No module named 'click'"

**Problem:** You're using the system Python instead of the virtual environment.

**Solution:**
1. Activate the virtual environment first:
   ```powershell
   .\venv\Scripts\activate
   ```
2. Or use the virtual environment's Python directly:
   ```powershell
   .\venv\Scripts\python.exe -m rispec.cli --help
   ```

### "No module named 'rispec'"

**Problem:** The package isn't installed or Python can't find it.

**Solution:**
1. Install the package in development mode:
   ```bash
   pip install -e .
   ```
2. Or use the module syntax:
   ```bash
   python -m rispec.cli --help
   ```

### "rispec: command not found"

**Problem:** The virtual environment isn't activated or the package isn't installed.

**Solution:**
1. Activate the virtual environment
2. Install the package: `pip install -e .`
3. Verify installation: `rispec --version`

## Examples

### Analyze the RiSpec project itself

```bash
rispec analyze rispec
```

### Analyze with JSON output for scripting

```bash
rispec analyze ./my-project --json > analysis.json
```

### Check configuration before running analysis

```bash
rispec config
rispec analyze ./my-project
```

## Integration with Scripts

The `--json` flag makes it easy to integrate with other tools:

```bash
# PowerShell example
$result = rispec analyze ./my-project --json | ConvertFrom-Json
Write-Host "Found $($result.total_files) files"
```

```bash
# Bash example
result=$(rispec analyze ./my-project --json)
echo "$result" | jq '.total_files'
```

