"""Setup script for RiSpec."""

from setuptools import setup, find_packages
from pathlib import Path

# Read README for long description
readme_file = Path(__file__).parent / "README.md"
long_description = readme_file.read_text(encoding="utf-8") if readme_file.exists() else ""

setup(
    name="rispec",
    version="0.1.0",
    author="Aleksander",
    author_email="arisilia@ritech.co",
    description="AI-assisted change-management tool for senior engineers working on large, single-repo legacy codebases",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/techdebtgpt/RiSpec",
    license="Apache-2.0",
    packages=find_packages(exclude=["tests", "tests.*", "specs", "specs.*", "docs", "docs.*"]),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Software Development :: Quality Assurance",
        "License :: OSI Approved :: Apache Software License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
    ],
    python_requires=">=3.8",
    install_requires=[
        "click>=8.1.7",
        "openai>=1.12.0",
        "python-dotenv>=1.0.0",
    ],
    extras_require={
        "dev": [
            "pytest>=7.4.4",
            "pytest-cov>=4.1.0",
            "pytest-mock>=3.12.0",
        ],
    },
    entry_points={
        "console_scripts": [
            "rispec=rispec.cli:cli",
        ],
    },
    include_package_data=True,
    zip_safe=False,
)
