# akeyless-uam-api
UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.6
- Package version: 0.0.9
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.akeyless-security.com](https://www.akeyless-security.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import akeyless_uam_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import akeyless_uam_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import akeyless_uam_api
from akeyless_uam_api.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = akeyless_uam_api.DefaultApi()
akeyless_create_account_creds = 'akeyless_create_account_creds_example' # str | Temporary credentials for accessing the endpoint
name = 'name_example' # str | The customer name
customer_address = 'customer_address_example' # str | The customer address

try:
    # Create new account.
    api_response = api_instance.create_account(akeyless_create_account_creds, name, customer_address)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->create_account: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://$HOST*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**create_account**](docs/DefaultApi.md#create_account) | **POST** /account | Create new account.
*DefaultApi* | [**create_item**](docs/DefaultApi.md#create_item) | **POST** /item | Add a new item to the account.
*DefaultApi* | [**create_role**](docs/DefaultApi.md#create_role) | **POST** /role | Add a new role to the account.
*DefaultApi* | [**create_role_item_assoc**](docs/DefaultApi.md#create_role_item_assoc) | **POST** /role-item-assoc | Add an association between a role and an item.
*DefaultApi* | [**create_role_user_assoc**](docs/DefaultApi.md#create_role_user_assoc) | **POST** /role-user-assoc | Add an association between a role and a user.
*DefaultApi* | [**create_user**](docs/DefaultApi.md#create_user) | **POST** /user | Add a new user to the account.
*DefaultApi* | [**delete_item**](docs/DefaultApi.md#delete_item) | **DELETE** /item/{item_name} | Deleting an existing item from the account.
*DefaultApi* | [**delete_role**](docs/DefaultApi.md#delete_role) | **DELETE** /role/{role_name} | Deleting an existing role from the account.
*DefaultApi* | [**delete_role_item_assoc**](docs/DefaultApi.md#delete_role_item_assoc) | **DELETE** /role-item-assoc | Deleting an association between a role and an item.
*DefaultApi* | [**delete_role_user_assoc**](docs/DefaultApi.md#delete_role_user_assoc) | **DELETE** /role-user-assoc | Deleting an association between a role and an user.
*DefaultApi* | [**delete_user**](docs/DefaultApi.md#delete_user) | **DELETE** /user/{user_name} | Deleting an existing user from the account.
*DefaultApi* | [**get_account_details**](docs/DefaultApi.md#get_account_details) | **GET** /account/ | Get account details.
*DefaultApi* | [**get_account_roles**](docs/DefaultApi.md#get_account_roles) | **GET** /roles | Get All the existing roles in the account.
*DefaultApi* | [**get_account_users**](docs/DefaultApi.md#get_account_users) | **GET** /users | Get All the existing users in the account.
*DefaultApi* | [**get_dynamic_secret_mq_access**](docs/DefaultApi.md#get_dynamic_secret_mq_access) | **GET** /dynamic-secret-mq-access | Get a signed request to receive messages from a Message Queue of a Dynamic Secret.
*DefaultApi* | [**get_item**](docs/DefaultApi.md#get_item) | **GET** /item/{item_name} | Get item details.
*DefaultApi* | [**get_item_derivation_creds**](docs/DefaultApi.md#get_item_derivation_creds) | **GET** /derivation-creds | Get temporary access credentials to KFM instances for item&#39;s fragments derivation.
*DefaultApi* | [**get_role**](docs/DefaultApi.md#get_role) | **GET** /role/{role_name} | Get role details.
*DefaultApi* | [**get_rsa_key_decrypt_creds**](docs/DefaultApi.md#get_rsa_key_decrypt_creds) | **GET** /rsa-decrypt-creds | Get temporary access credentials to KFM instances for RSA key fragments decryption.
*DefaultApi* | [**get_secret_access_creds**](docs/DefaultApi.md#get_secret_access_creds) | **GET** /secret-access-creds | 
*DefaultApi* | [**get_status**](docs/DefaultApi.md#get_status) | **GET** /status | 
*DefaultApi* | [**get_upload_rsa_key_creds**](docs/DefaultApi.md#get_upload_rsa_key_creds) | **GET** /upload-rsa-key-creds | Get temporary access credentials to upload RSA private key fragments into KFMs instances.
*DefaultApi* | [**get_upload_secret_creds**](docs/DefaultApi.md#get_upload_secret_creds) | **GET** /upload-secret-creds | Get temporary access credentials to KFM instances to produce the derived protection key of the secret.
*DefaultApi* | [**get_user**](docs/DefaultApi.md#get_user) | **GET** /user/{user_name} | Get user details.
*DefaultApi* | [**get_user_items**](docs/DefaultApi.md#get_user_items) | **GET** /items | Get All the items associated with the user.
*DefaultApi* | [**prepare_dynamic_secret_value**](docs/DefaultApi.md#prepare_dynamic_secret_value) | **GET** /prepare-dynamic-secret-value | Get a signed request to receive messages from a Message Queue of a Dynamic Secret.
*DefaultApi* | [**update_item**](docs/DefaultApi.md#update_item) | **PUT** /item/{item_name} | Updating an existing item in the account
*DefaultApi* | [**update_role**](docs/DefaultApi.md#update_role) | **PUT** /role/{role_name} | Updating an existing role in the account
*DefaultApi* | [**update_user**](docs/DefaultApi.md#update_user) | **PUT** /user/{user_name} | Updating an existing user in the account


## Documentation For Models

 - [Algorithm](docs/Algorithm.md)
 - [AuthStatusReplyObj](docs/AuthStatusReplyObj.md)
 - [AzureADAccessRole](docs/AzureADAccessRole.md)
 - [CreateAccountCredsParams](docs/CreateAccountCredsParams.md)
 - [CreateAccountReplyObj](docs/CreateAccountReplyObj.md)
 - [CreatePolicyReplyObj](docs/CreatePolicyReplyObj.md)
 - [CreateUserReplyObj](docs/CreateUserReplyObj.md)
 - [CredentialsReplyObj](docs/CredentialsReplyObj.md)
 - [DerivationCredsReplyObj](docs/DerivationCredsReplyObj.md)
 - [DerivedFragmentReplyObj](docs/DerivedFragmentReplyObj.md)
 - [DynamicSecretMQAccessReplyObj](docs/DynamicSecretMQAccessReplyObj.md)
 - [DynamicSecretMessageQueueInfo](docs/DynamicSecretMessageQueueInfo.md)
 - [ErrorReplyObj](docs/ErrorReplyObj.md)
 - [FragmentType](docs/FragmentType.md)
 - [GetAccountDetailsReplyObj](docs/GetAccountDetailsReplyObj.md)
 - [GetAccountRolesReplyObj](docs/GetAccountRolesReplyObj.md)
 - [GetAccountUsersReplyObj](docs/GetAccountUsersReplyObj.md)
 - [GetFragmentDetailsReplyObj](docs/GetFragmentDetailsReplyObj.md)
 - [GetItemReplyObj](docs/GetItemReplyObj.md)
 - [GetPoliciesReplyObj](docs/GetPoliciesReplyObj.md)
 - [GetPolicyReplyObj](docs/GetPolicyReplyObj.md)
 - [GetRoleReplyObj](docs/GetRoleReplyObj.md)
 - [GetUserItemsReplyObj](docs/GetUserItemsReplyObj.md)
 - [GetUserReplyObj](docs/GetUserReplyObj.md)
 - [KFMStatusReplyObj](docs/KFMStatusReplyObj.md)
 - [OAuth2AccessRole](docs/OAuth2AccessRole.md)
 - [OAuth2CustomClaim](docs/OAuth2CustomClaim.md)
 - [PolicyParams](docs/PolicyParams.md)
 - [PolicyRules](docs/PolicyRules.md)
 - [PolicyRulesType](docs/PolicyRulesType.md)
 - [PolicyType](docs/PolicyType.md)
 - [PrepareDynamicSecretValueReplyObj](docs/PrepareDynamicSecretValueReplyObj.md)
 - [PublicSigningKeyReplyObj](docs/PublicSigningKeyReplyObj.md)
 - [RSADecryptCredsReplyObj](docs/RSADecryptCredsReplyObj.md)
 - [RSAFragmentDecryptReplyObj](docs/RSAFragmentDecryptReplyObj.md)
 - [SecretAccessCredsReplyObj](docs/SecretAccessCredsReplyObj.md)
 - [SetUAMPolicyCredsParams](docs/SetUAMPolicyCredsParams.md)
 - [SystemUserCredentialsReplyObj](docs/SystemUserCredentialsReplyObj.md)
 - [TimeReplyObj](docs/TimeReplyObj.md)
 - [UAMStatusReplyObj](docs/UAMStatusReplyObj.md)
 - [UpdatePolicyMode](docs/UpdatePolicyMode.md)
 - [UploadRSAFragmentReplyObj](docs/UploadRSAFragmentReplyObj.md)
 - [UploadRSAKeyCredsReplyObj](docs/UploadRSAKeyCredsReplyObj.md)
 - [UserAccessPolicyInfo](docs/UserAccessPolicyInfo.md)
 - [ValidateClientCredsReplyObj](docs/ValidateClientCredsReplyObj.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

refael@akeyless-security.com

