# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 1.0.6
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from akeyless_uam_api.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_account(self, akeyless_create_account_creds, name, customer_address, **kwargs):  # noqa: E501
        """Create new account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_account(akeyless_create_account_creds, name, customer_address, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_create_account_creds: Temporary credentials for accessing the endpoint (required)
        :param str name: The customer name (required)
        :param str customer_address: The customer address (required)
        :return: CreateAccountReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_account_with_http_info(akeyless_create_account_creds, name, customer_address, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_with_http_info(akeyless_create_account_creds, name, customer_address, **kwargs)  # noqa: E501
            return data

    def create_account_with_http_info(self, akeyless_create_account_creds, name, customer_address, **kwargs):  # noqa: E501
        """Create new account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_account_with_http_info(akeyless_create_account_creds, name, customer_address, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_create_account_creds: Temporary credentials for accessing the endpoint (required)
        :param str name: The customer name (required)
        :param str customer_address: The customer address (required)
        :return: CreateAccountReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_create_account_creds', 'name', 'customer_address']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_create_account_creds' is set
        if ('akeyless_create_account_creds' not in params or
                params['akeyless_create_account_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_create_account_creds` when calling `create_account`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_account`")  # noqa: E501
        # verify the required parameter 'customer_address' is set
        if ('customer_address' not in params or
                params['customer_address'] is None):
            raise ValueError("Missing the required parameter `customer_address` when calling `create_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'customer_address' in params:
            query_params.append(('customer_address', params['customer_address']))  # noqa: E501

        header_params = {}
        if 'akeyless_create_account_creds' in params:
            header_params['Akeyless-CreateAccountCreds'] = params['akeyless_create_account_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/account', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateAccountReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_item(self, akeyless_uam_user_creds, item_name, item_type, user_metadata, split_level, **kwargs):  # noqa: E501
        """Add a new item to the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_item(akeyless_uam_user_creds, item_name, item_type, user_metadata, split_level, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name to be created (required)
        :param str item_type: The type of the item to be created Types available are: [AES128GCM, AES256GCM, AES128SIV, AES256SIV] (required)
        :param str user_metadata: User metadata about the item. (required)
        :param int split_level: The splitting level represent the number of fragments that the item will be split into. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int size: The length of the item to be created.
        :param str customer_fragment_id: The customer fragment ID associated with this item (if any).
        :param str upload_rsa_key_creds: The credentials to upload an RSA key. this parameter relevant only in case of item of RSA Key. in this case all the item's creation parameters should be correlated with the parameters in the UploadRSAKeyCreds.
        :param str upload_secret_creds: The credentials to upload a secret. this parameter relevant only in case of create a new secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret.
        :param str secret_enc_val: The encrypted secret value. this parameter relevant only in case of create a new secret. This parameter should contain the encrypted secret that is encrypted using the protection key.
        :param str protection_key_name: The name of the key that will be used to encrypt a dynamic secret. If not provided, the account default secret key will be used. This parameter relevant only in case of create a new dynamic secret.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_item_with_http_info(akeyless_uam_user_creds, item_name, item_type, user_metadata, split_level, **kwargs)  # noqa: E501
        else:
            (data) = self.create_item_with_http_info(akeyless_uam_user_creds, item_name, item_type, user_metadata, split_level, **kwargs)  # noqa: E501
            return data

    def create_item_with_http_info(self, akeyless_uam_user_creds, item_name, item_type, user_metadata, split_level, **kwargs):  # noqa: E501
        """Add a new item to the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_item_with_http_info(akeyless_uam_user_creds, item_name, item_type, user_metadata, split_level, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name to be created (required)
        :param str item_type: The type of the item to be created Types available are: [AES128GCM, AES256GCM, AES128SIV, AES256SIV] (required)
        :param str user_metadata: User metadata about the item. (required)
        :param int split_level: The splitting level represent the number of fragments that the item will be split into. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int size: The length of the item to be created.
        :param str customer_fragment_id: The customer fragment ID associated with this item (if any).
        :param str upload_rsa_key_creds: The credentials to upload an RSA key. this parameter relevant only in case of item of RSA Key. in this case all the item's creation parameters should be correlated with the parameters in the UploadRSAKeyCreds.
        :param str upload_secret_creds: The credentials to upload a secret. this parameter relevant only in case of create a new secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret.
        :param str secret_enc_val: The encrypted secret value. this parameter relevant only in case of create a new secret. This parameter should contain the encrypted secret that is encrypted using the protection key.
        :param str protection_key_name: The name of the key that will be used to encrypt a dynamic secret. If not provided, the account default secret key will be used. This parameter relevant only in case of create a new dynamic secret.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'item_name', 'item_type', 'user_metadata', 'split_level', 'akeyless_request_id', 'akeyless_client_id', 'size', 'customer_fragment_id', 'upload_rsa_key_creds', 'upload_secret_creds', 'secret_enc_val', 'protection_key_name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `create_item`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `create_item`")  # noqa: E501
        # verify the required parameter 'item_type' is set
        if ('item_type' not in params or
                params['item_type'] is None):
            raise ValueError("Missing the required parameter `item_type` when calling `create_item`")  # noqa: E501
        # verify the required parameter 'user_metadata' is set
        if ('user_metadata' not in params or
                params['user_metadata'] is None):
            raise ValueError("Missing the required parameter `user_metadata` when calling `create_item`")  # noqa: E501
        # verify the required parameter 'split_level' is set
        if ('split_level' not in params or
                params['split_level'] is None):
            raise ValueError("Missing the required parameter `split_level` when calling `create_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_type' in params:
            query_params.append(('item_type', params['item_type']))  # noqa: E501
        if 'user_metadata' in params:
            query_params.append(('user_metadata', params['user_metadata']))  # noqa: E501
        if 'split_level' in params:
            query_params.append(('split_level', params['split_level']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'customer_fragment_id' in params:
            query_params.append(('customer_fragment_id', params['customer_fragment_id']))  # noqa: E501
        if 'upload_rsa_key_creds' in params:
            query_params.append(('upload_rsa_key_creds', params['upload_rsa_key_creds']))  # noqa: E501
        if 'upload_secret_creds' in params:
            query_params.append(('upload_secret_creds', params['upload_secret_creds']))  # noqa: E501
        if 'secret_enc_val' in params:
            query_params.append(('secret_enc_val', params['secret_enc_val']))  # noqa: E501
        if 'protection_key_name' in params:
            query_params.append(('protection_key_name', params['protection_key_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/item', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_role(self, akeyless_uam_user_creds, new_role_name, **kwargs):  # noqa: E501
        """Add a new role to the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_role(akeyless_uam_user_creds, new_role_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_role_name: The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str role_action: The role action.
        :param str comment: Comments
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_role_with_http_info(akeyless_uam_user_creds, new_role_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_role_with_http_info(akeyless_uam_user_creds, new_role_name, **kwargs)  # noqa: E501
            return data

    def create_role_with_http_info(self, akeyless_uam_user_creds, new_role_name, **kwargs):  # noqa: E501
        """Add a new role to the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_role_with_http_info(akeyless_uam_user_creds, new_role_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_role_name: The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str role_action: The role action.
        :param str comment: Comments
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'new_role_name', 'akeyless_request_id', 'akeyless_client_id', 'role_action', 'comment']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `create_role`")  # noqa: E501
        # verify the required parameter 'new_role_name' is set
        if ('new_role_name' not in params or
                params['new_role_name'] is None):
            raise ValueError("Missing the required parameter `new_role_name` when calling `create_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'new_role_name' in params:
            query_params.append(('new_role_name', params['new_role_name']))  # noqa: E501
        if 'role_action' in params:
            query_params.append(('role_action', params['role_action']))  # noqa: E501
        if 'comment' in params:
            query_params.append(('comment', params['comment']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_role_item_assoc(self, akeyless_uam_user_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Add an association between a role and an item.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_role_item_assoc(akeyless_uam_user_creds, role_name, associated_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The item or user name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_role_item_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_role_item_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, **kwargs)  # noqa: E501
            return data

    def create_role_item_assoc_with_http_info(self, akeyless_uam_user_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Add an association between a role and an item.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_role_item_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The item or user name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'role_name', 'associated_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_role_item_assoc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `create_role_item_assoc`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `create_role_item_assoc`")  # noqa: E501
        # verify the required parameter 'associated_name' is set
        if ('associated_name' not in params or
                params['associated_name'] is None):
            raise ValueError("Missing the required parameter `associated_name` when calling `create_role_item_assoc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role_name' in params:
            query_params.append(('role_name', params['role_name']))  # noqa: E501
        if 'associated_name' in params:
            query_params.append(('associated_name', params['associated_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role-item-assoc', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_role_user_assoc(self, akeyless_uam_user_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Add an association between a role and a user.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_role_user_assoc(akeyless_uam_user_creds, role_name, associated_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The item or user name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_role_user_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_role_user_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, **kwargs)  # noqa: E501
            return data

    def create_role_user_assoc_with_http_info(self, akeyless_uam_user_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Add an association between a role and a user.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_role_user_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The item or user name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'role_name', 'associated_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_role_user_assoc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `create_role_user_assoc`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `create_role_user_assoc`")  # noqa: E501
        # verify the required parameter 'associated_name' is set
        if ('associated_name' not in params or
                params['associated_name'] is None):
            raise ValueError("Missing the required parameter `associated_name` when calling `create_role_user_assoc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role_name' in params:
            query_params.append(('role_name', params['role_name']))  # noqa: E501
        if 'associated_name' in params:
            query_params.append(('associated_name', params['associated_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role-user-assoc', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_user(self, akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, **kwargs):  # noqa: E501
        """Add a new user to the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_user(akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_set_user_access_policy_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_user_name: The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CreateUserReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_user_with_http_info(akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_user_with_http_info(akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, **kwargs)  # noqa: E501
            return data

    def create_user_with_http_info(self, akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, **kwargs):  # noqa: E501
        """Add a new user to the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_user_with_http_info(akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_set_user_access_policy_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_user_name: The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CreateUserReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'akeyless_set_user_access_policy_creds', 'new_user_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `create_user`")  # noqa: E501
        # verify the required parameter 'akeyless_set_user_access_policy_creds' is set
        if ('akeyless_set_user_access_policy_creds' not in params or
                params['akeyless_set_user_access_policy_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_set_user_access_policy_creds` when calling `create_user`")  # noqa: E501
        # verify the required parameter 'new_user_name' is set
        if ('new_user_name' not in params or
                params['new_user_name'] is None):
            raise ValueError("Missing the required parameter `new_user_name` when calling `create_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'new_user_name' in params:
            query_params.append(('new_user_name', params['new_user_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501
        if 'akeyless_set_user_access_policy_creds' in params:
            header_params['Akeyless-SetUserAccessPolicyCreds'] = params['akeyless_set_user_access_policy_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/user', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateUserReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_item(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """Deleting an existing item from the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_item(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Item name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_item_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_item_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
            return data

    def delete_item_with_http_info(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """Deleting an existing item from the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_item_with_http_info(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Item name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `delete_item`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `delete_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_name' in params:
            path_params['item_name'] = params['item_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/item/{item_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role(self, akeyless_uam_user_creds, role_name, **kwargs):  # noqa: E501
        """Deleting an existing role from the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_role(akeyless_uam_user_creds, role_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_role_with_http_info(akeyless_uam_user_creds, role_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_with_http_info(akeyless_uam_user_creds, role_name, **kwargs)  # noqa: E501
            return data

    def delete_role_with_http_info(self, akeyless_uam_user_creds, role_name, **kwargs):  # noqa: E501
        """Deleting an existing role from the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_role_with_http_info(akeyless_uam_user_creds, role_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'role_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `delete_role`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `delete_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['role_name'] = params['role_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role/{role_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role_item_assoc(self, akeyless_uam_user_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Deleting an association between a role and an item.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_role_item_assoc(akeyless_uam_user_creds, role_name, associated_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The item or user name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_role_item_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_item_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, **kwargs)  # noqa: E501
            return data

    def delete_role_item_assoc_with_http_info(self, akeyless_uam_user_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Deleting an association between a role and an item.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_role_item_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The item or user name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'role_name', 'associated_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role_item_assoc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `delete_role_item_assoc`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `delete_role_item_assoc`")  # noqa: E501
        # verify the required parameter 'associated_name' is set
        if ('associated_name' not in params or
                params['associated_name'] is None):
            raise ValueError("Missing the required parameter `associated_name` when calling `delete_role_item_assoc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role_name' in params:
            query_params.append(('role_name', params['role_name']))  # noqa: E501
        if 'associated_name' in params:
            query_params.append(('associated_name', params['associated_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role-item-assoc', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role_user_assoc(self, akeyless_uam_user_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Deleting an association between a role and an user.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_role_user_assoc(akeyless_uam_user_creds, role_name, associated_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The item or user name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_role_user_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_user_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, **kwargs)  # noqa: E501
            return data

    def delete_role_user_assoc_with_http_info(self, akeyless_uam_user_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Deleting an association between a role and an user.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_role_user_assoc_with_http_info(akeyless_uam_user_creds, role_name, associated_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The item or user name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'role_name', 'associated_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role_user_assoc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `delete_role_user_assoc`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `delete_role_user_assoc`")  # noqa: E501
        # verify the required parameter 'associated_name' is set
        if ('associated_name' not in params or
                params['associated_name'] is None):
            raise ValueError("Missing the required parameter `associated_name` when calling `delete_role_user_assoc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role_name' in params:
            query_params.append(('role_name', params['role_name']))  # noqa: E501
        if 'associated_name' in params:
            query_params.append(('associated_name', params['associated_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role-user-assoc', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_user(self, akeyless_uam_user_creds, user_name, **kwargs):  # noqa: E501
        """Deleting an existing user from the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_user(akeyless_uam_user_creds, user_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str user_name: User name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_user_with_http_info(akeyless_uam_user_creds, user_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_user_with_http_info(akeyless_uam_user_creds, user_name, **kwargs)  # noqa: E501
            return data

    def delete_user_with_http_info(self, akeyless_uam_user_creds, user_name, **kwargs):  # noqa: E501
        """Deleting an existing user from the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_user_with_http_info(akeyless_uam_user_creds, user_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str user_name: User name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'user_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `delete_user`")  # noqa: E501
        # verify the required parameter 'user_name' is set
        if ('user_name' not in params or
                params['user_name'] is None):
            raise ValueError("Missing the required parameter `user_name` when calling `delete_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_name' in params:
            path_params['user_name'] = params['user_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/user/{user_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_details(self, akeyless_uam_user_creds, **kwargs):  # noqa: E501
        """Get account details.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_account_details(akeyless_uam_user_creds, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountDetailsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_account_details_with_http_info(akeyless_uam_user_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_details_with_http_info(akeyless_uam_user_creds, **kwargs)  # noqa: E501
            return data

    def get_account_details_with_http_info(self, akeyless_uam_user_creds, **kwargs):  # noqa: E501
        """Get account details.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_account_details_with_http_info(akeyless_uam_user_creds, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountDetailsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_account_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/account/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccountDetailsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_roles(self, akeyless_uam_user_creds, **kwargs):  # noqa: E501
        """Get All the existing roles in the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_account_roles(akeyless_uam_user_creds, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountRolesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_account_roles_with_http_info(akeyless_uam_user_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_roles_with_http_info(akeyless_uam_user_creds, **kwargs)  # noqa: E501
            return data

    def get_account_roles_with_http_info(self, akeyless_uam_user_creds, **kwargs):  # noqa: E501
        """Get All the existing roles in the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_account_roles_with_http_info(akeyless_uam_user_creds, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountRolesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_account_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccountRolesReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_users(self, akeyless_uam_user_creds, **kwargs):  # noqa: E501
        """Get All the existing users in the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_account_users(akeyless_uam_user_creds, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountUsersReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_account_users_with_http_info(akeyless_uam_user_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_users_with_http_info(akeyless_uam_user_creds, **kwargs)  # noqa: E501
            return data

    def get_account_users_with_http_info(self, akeyless_uam_user_creds, **kwargs):  # noqa: E501
        """Get All the existing users in the account.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_account_users_with_http_info(akeyless_uam_user_creds, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountUsersReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_account_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccountUsersReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dynamic_secret_mq_access(self, item_name, **kwargs):  # noqa: E501
        """Get a signed request to receive messages from a Message Queue of a Dynamic Secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_dynamic_secret_mq_access(item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str item_name: The dynamic secret item name (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DynamicSecretMQAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_dynamic_secret_mq_access_with_http_info(item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dynamic_secret_mq_access_with_http_info(item_name, **kwargs)  # noqa: E501
            return data

    def get_dynamic_secret_mq_access_with_http_info(self, item_name, **kwargs):  # noqa: E501
        """Get a signed request to receive messages from a Message Queue of a Dynamic Secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_dynamic_secret_mq_access_with_http_info(item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str item_name: The dynamic secret item name (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DynamicSecretMQAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_name', 'creds_expiry']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dynamic_secret_mq_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_dynamic_secret_mq_access`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_dynamic_secret_mq_access`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_dynamic_secret_mq_access`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/dynamic-secret-mq-access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicSecretMQAccessReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """Get item details.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_item(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Item name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version (for item attributes that are unique to each version). If it is empty, the item attributes of the latest version will be returned
        :return: GetItemReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_item_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_item_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
            return data

    def get_item_with_http_info(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """Get item details.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_item_with_http_info(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Item name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version (for item attributes that are unique to each version). If it is empty, the item attributes of the latest version will be returned
        :return: GetItemReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id', 'item_version']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_item`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_name' in params:
            path_params['item_name'] = params['item_name']  # noqa: E501

        query_params = []
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/item/{item_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetItemReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_derivation_creds(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for item&#39;s fragments derivation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_item_derivation_creds(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name for derivation (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version. If it is empty, the derivation credentials will be returned for the latest item version
        :param str restricted_derivation_data: In case not empty, the derivation credentials will be restricted only to this derivation data
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DerivationCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_item_derivation_creds_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_item_derivation_creds_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
            return data

    def get_item_derivation_creds_with_http_info(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for item&#39;s fragments derivation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_item_derivation_creds_with_http_info(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name for derivation (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version. If it is empty, the derivation credentials will be returned for the latest item version
        :param str restricted_derivation_data: In case not empty, the derivation credentials will be restricted only to this derivation data
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DerivationCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id', 'item_version', 'restricted_derivation_data', 'creds_expiry']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_derivation_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_item_derivation_creds`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_item_derivation_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_item_derivation_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_item_derivation_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501
        if 'restricted_derivation_data' in params:
            query_params.append(('restricted_derivation_data', params['restricted_derivation_data']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/derivation-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DerivationCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role(self, akeyless_uam_user_creds, role_name, **kwargs):  # noqa: E501
        """Get role details.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_role(akeyless_uam_user_creds, role_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetRoleReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_role_with_http_info(akeyless_uam_user_creds, role_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_role_with_http_info(akeyless_uam_user_creds, role_name, **kwargs)  # noqa: E501
            return data

    def get_role_with_http_info(self, akeyless_uam_user_creds, role_name, **kwargs):  # noqa: E501
        """Get role details.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_role_with_http_info(akeyless_uam_user_creds, role_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetRoleReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'role_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_role`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['role_name'] = params['role_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role/{role_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetRoleReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rsa_key_decrypt_creds(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for RSA key fragments decryption.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_rsa_key_decrypt_creds(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name for decrypt operation (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version. If it is empty, the RSA decrypt credentials will be returned for the latest item version
        :param str restricted_cipher: In case not empty, the RSA decrypt credentials will be restricted only to this cipher
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: RSADecryptCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_rsa_key_decrypt_creds_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rsa_key_decrypt_creds_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
            return data

    def get_rsa_key_decrypt_creds_with_http_info(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for RSA key fragments decryption.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_rsa_key_decrypt_creds_with_http_info(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name for decrypt operation (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version. If it is empty, the RSA decrypt credentials will be returned for the latest item version
        :param str restricted_cipher: In case not empty, the RSA decrypt credentials will be restricted only to this cipher
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: RSADecryptCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id', 'item_version', 'restricted_cipher', 'creds_expiry']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rsa_key_decrypt_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_rsa_key_decrypt_creds`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_rsa_key_decrypt_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_rsa_key_decrypt_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_rsa_key_decrypt_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501
        if 'restricted_cipher' in params:
            query_params.append(('restricted_cipher', params['restricted_cipher']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/rsa-decrypt-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RSADecryptCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_secret_access_creds(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """get_secret_access_creds  # noqa: E501

        Get temporary access credentials to KFM instances for secret protection key derivation and the encrypted secret value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_secret_access_creds(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The secret item name (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The secret item version. If it is empty, the credentials will be returned for the latest secret item version
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SecretAccessCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_secret_access_creds_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_secret_access_creds_with_http_info(akeyless_uam_user_creds, item_name, **kwargs)  # noqa: E501
            return data

    def get_secret_access_creds_with_http_info(self, akeyless_uam_user_creds, item_name, **kwargs):  # noqa: E501
        """get_secret_access_creds  # noqa: E501

        Get temporary access credentials to KFM instances for secret protection key derivation and the encrypted secret value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_secret_access_creds_with_http_info(akeyless_uam_user_creds, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The secret item name (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The secret item version. If it is empty, the credentials will be returned for the latest secret item version
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SecretAccessCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id', 'item_version', 'creds_expiry']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secret_access_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_secret_access_creds`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_secret_access_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_secret_access_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_secret_access_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/secret-access-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecretAccessCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_status(self, **kwargs):  # noqa: E501
        """get_status  # noqa: E501

        Get UAM server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_status(async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: UAMStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_status  # noqa: E501

        Get UAM server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_status_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: UAMStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UAMStatusReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_upload_rsa_key_creds(self, akeyless_uam_user_creds, item_name, item_type, public_value, split_level, **kwargs):  # noqa: E501
        """Get temporary access credentials to upload RSA private key fragments into KFMs instances.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_upload_rsa_key_creds(akeyless_uam_user_creds, item_name, item_type, public_value, split_level, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The RSA key name. (required)
        :param str item_type: The RSA key type Types available are: [KEY_RSA1024, KEY_RSA2048] (required)
        :param str public_value: The value of the RSA public key . (required)
        :param int split_level: The splitting level represent the number of fragments that the key will be split into. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str certificates: The certificates associated with the RSA key.
        :param str user_metadata: User metadata about the key.
        :param str customer_fragment_id: The customer fragment ID associated with this item (if any).
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: UploadRSAKeyCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_upload_rsa_key_creds_with_http_info(akeyless_uam_user_creds, item_name, item_type, public_value, split_level, **kwargs)  # noqa: E501
        else:
            (data) = self.get_upload_rsa_key_creds_with_http_info(akeyless_uam_user_creds, item_name, item_type, public_value, split_level, **kwargs)  # noqa: E501
            return data

    def get_upload_rsa_key_creds_with_http_info(self, akeyless_uam_user_creds, item_name, item_type, public_value, split_level, **kwargs):  # noqa: E501
        """Get temporary access credentials to upload RSA private key fragments into KFMs instances.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_upload_rsa_key_creds_with_http_info(akeyless_uam_user_creds, item_name, item_type, public_value, split_level, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The RSA key name. (required)
        :param str item_type: The RSA key type Types available are: [KEY_RSA1024, KEY_RSA2048] (required)
        :param str public_value: The value of the RSA public key . (required)
        :param int split_level: The splitting level represent the number of fragments that the key will be split into. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str certificates: The certificates associated with the RSA key.
        :param str user_metadata: User metadata about the key.
        :param str customer_fragment_id: The customer fragment ID associated with this item (if any).
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: UploadRSAKeyCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'item_name', 'item_type', 'public_value', 'split_level', 'akeyless_request_id', 'akeyless_client_id', 'certificates', 'user_metadata', 'customer_fragment_id', 'creds_expiry']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upload_rsa_key_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_upload_rsa_key_creds`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_upload_rsa_key_creds`")  # noqa: E501
        # verify the required parameter 'item_type' is set
        if ('item_type' not in params or
                params['item_type'] is None):
            raise ValueError("Missing the required parameter `item_type` when calling `get_upload_rsa_key_creds`")  # noqa: E501
        # verify the required parameter 'public_value' is set
        if ('public_value' not in params or
                params['public_value'] is None):
            raise ValueError("Missing the required parameter `public_value` when calling `get_upload_rsa_key_creds`")  # noqa: E501
        # verify the required parameter 'split_level' is set
        if ('split_level' not in params or
                params['split_level'] is None):
            raise ValueError("Missing the required parameter `split_level` when calling `get_upload_rsa_key_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_upload_rsa_key_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_upload_rsa_key_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_type' in params:
            query_params.append(('item_type', params['item_type']))  # noqa: E501
        if 'public_value' in params:
            query_params.append(('public_value', params['public_value']))  # noqa: E501
        if 'certificates' in params:
            query_params.append(('certificates', params['certificates']))  # noqa: E501
        if 'user_metadata' in params:
            query_params.append(('user_metadata', params['user_metadata']))  # noqa: E501
        if 'split_level' in params:
            query_params.append(('split_level', params['split_level']))  # noqa: E501
        if 'customer_fragment_id' in params:
            query_params.append(('customer_fragment_id', params['customer_fragment_id']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/upload-rsa-key-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UploadRSAKeyCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_upload_secret_creds(self, akeyless_uam_user_creds, secret_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances to produce the derived protection key of the secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_upload_secret_creds(akeyless_uam_user_creds, secret_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str secret_name: The secret name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str protection_key_name: The name of the key that will be used to encrypt the secret. If not provided, the account default secret key will be used.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DerivationCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_upload_secret_creds_with_http_info(akeyless_uam_user_creds, secret_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_upload_secret_creds_with_http_info(akeyless_uam_user_creds, secret_name, **kwargs)  # noqa: E501
            return data

    def get_upload_secret_creds_with_http_info(self, akeyless_uam_user_creds, secret_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances to produce the derived protection key of the secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_upload_secret_creds_with_http_info(akeyless_uam_user_creds, secret_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str secret_name: The secret name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str protection_key_name: The name of the key that will be used to encrypt the secret. If not provided, the account default secret key will be used.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DerivationCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'secret_name', 'akeyless_request_id', 'akeyless_client_id', 'protection_key_name', 'creds_expiry']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upload_secret_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_upload_secret_creds`")  # noqa: E501
        # verify the required parameter 'secret_name' is set
        if ('secret_name' not in params or
                params['secret_name'] is None):
            raise ValueError("Missing the required parameter `secret_name` when calling `get_upload_secret_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_upload_secret_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_upload_secret_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'secret_name' in params:
            query_params.append(('secret_name', params['secret_name']))  # noqa: E501
        if 'protection_key_name' in params:
            query_params.append(('protection_key_name', params['protection_key_name']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/upload-secret-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DerivationCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user(self, akeyless_uam_user_creds, user_name, **kwargs):  # noqa: E501
        """Get user details.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_user(akeyless_uam_user_creds, user_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str user_name: User name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetUserReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_user_with_http_info(akeyless_uam_user_creds, user_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_with_http_info(akeyless_uam_user_creds, user_name, **kwargs)  # noqa: E501
            return data

    def get_user_with_http_info(self, akeyless_uam_user_creds, user_name, **kwargs):  # noqa: E501
        """Get user details.  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_user_with_http_info(akeyless_uam_user_creds, user_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str user_name: User name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetUserReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'user_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_user`")  # noqa: E501
        # verify the required parameter 'user_name' is set
        if ('user_name' not in params or
                params['user_name'] is None):
            raise ValueError("Missing the required parameter `user_name` when calling `get_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_name' in params:
            path_params['user_name'] = params['user_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/user/{user_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetUserReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_items(self, akeyless_uam_user_creds, **kwargs):  # noqa: E501
        """Get All the items associated with the user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_user_items(akeyless_uam_user_creds, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str item_types: The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \"AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,USER_SECRET\"
        :return: GetUserItemsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_user_items_with_http_info(akeyless_uam_user_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_items_with_http_info(akeyless_uam_user_creds, **kwargs)  # noqa: E501
            return data

    def get_user_items_with_http_info(self, akeyless_uam_user_creds, **kwargs):  # noqa: E501
        """Get All the items associated with the user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_user_items_with_http_info(akeyless_uam_user_creds, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str item_types: The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \"AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,USER_SECRET\"
        :return: GetUserItemsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'akeyless_request_id', 'akeyless_client_id', 'item_types']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `get_user_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_types' in params:
            query_params.append(('item_types', params['item_types']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/items', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetUserItemsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def prepare_dynamic_secret_value(self, item_name, preparation_data, **kwargs):  # noqa: E501
        """Get a signed request to receive messages from a Message Queue of a Dynamic Secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.prepare_dynamic_secret_value(item_name, preparation_data, async=True)
        >>> result = thread.get()

        :param async bool
        :param str item_name: The dynamic secret item name (required)
        :param str preparation_data: A data about the dynamic secret value preparation request (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: PrepareDynamicSecretValueReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.prepare_dynamic_secret_value_with_http_info(item_name, preparation_data, **kwargs)  # noqa: E501
        else:
            (data) = self.prepare_dynamic_secret_value_with_http_info(item_name, preparation_data, **kwargs)  # noqa: E501
            return data

    def prepare_dynamic_secret_value_with_http_info(self, item_name, preparation_data, **kwargs):  # noqa: E501
        """Get a signed request to receive messages from a Message Queue of a Dynamic Secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.prepare_dynamic_secret_value_with_http_info(item_name, preparation_data, async=True)
        >>> result = thread.get()

        :param async bool
        :param str item_name: The dynamic secret item name (required)
        :param str preparation_data: A data about the dynamic secret value preparation request (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: PrepareDynamicSecretValueReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_name', 'preparation_data', 'creds_expiry']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method prepare_dynamic_secret_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `prepare_dynamic_secret_value`")  # noqa: E501
        # verify the required parameter 'preparation_data' is set
        if ('preparation_data' not in params or
                params['preparation_data'] is None):
            raise ValueError("Missing the required parameter `preparation_data` when calling `prepare_dynamic_secret_value`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `prepare_dynamic_secret_value`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `prepare_dynamic_secret_value`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'preparation_data' in params:
            query_params.append(('preparation_data', params['preparation_data']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/prepare-dynamic-secret-value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrepareDynamicSecretValueReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_item(self, akeyless_uam_user_creds, new_item_name, item_name, **kwargs):  # noqa: E501
        """Updating an existing item in the account  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_item(akeyless_uam_user_creds, new_item_name, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_item_name: The new item name that will replace the existing one (required)
        :param str item_name: Item name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str user_metadata: User metadata about the item.
        :param int item_version: The item version to be updated. this parameter relevant only when updating a version-dependent attribute of the item (for example a secret encrypted value in case of secret item).  If it is empty, the item attributes of the latest version will be updated.
        :param str upload_secret_creds: The credentials to upload a secret. this parameter relevant only when updating a secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret.
        :param str secret_enc_val: The encrypted secret value. this parameter relevant only when updating a secret. This parameter should contain the encrypted secret that is encrypted using the protection key.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_item_with_http_info(akeyless_uam_user_creds, new_item_name, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_item_with_http_info(akeyless_uam_user_creds, new_item_name, item_name, **kwargs)  # noqa: E501
            return data

    def update_item_with_http_info(self, akeyless_uam_user_creds, new_item_name, item_name, **kwargs):  # noqa: E501
        """Updating an existing item in the account  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_item_with_http_info(akeyless_uam_user_creds, new_item_name, item_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_item_name: The new item name that will replace the existing one (required)
        :param str item_name: Item name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str user_metadata: User metadata about the item.
        :param int item_version: The item version to be updated. this parameter relevant only when updating a version-dependent attribute of the item (for example a secret encrypted value in case of secret item).  If it is empty, the item attributes of the latest version will be updated.
        :param str upload_secret_creds: The credentials to upload a secret. this parameter relevant only when updating a secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret.
        :param str secret_enc_val: The encrypted secret value. this parameter relevant only when updating a secret. This parameter should contain the encrypted secret that is encrypted using the protection key.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'new_item_name', 'item_name', 'akeyless_request_id', 'akeyless_client_id', 'user_metadata', 'item_version', 'upload_secret_creds', 'secret_enc_val']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `update_item`")  # noqa: E501
        # verify the required parameter 'new_item_name' is set
        if ('new_item_name' not in params or
                params['new_item_name'] is None):
            raise ValueError("Missing the required parameter `new_item_name` when calling `update_item`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `update_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_name' in params:
            path_params['item_name'] = params['item_name']  # noqa: E501

        query_params = []
        if 'new_item_name' in params:
            query_params.append(('new_item_name', params['new_item_name']))  # noqa: E501
        if 'user_metadata' in params:
            query_params.append(('user_metadata', params['user_metadata']))  # noqa: E501
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501
        if 'upload_secret_creds' in params:
            query_params.append(('upload_secret_creds', params['upload_secret_creds']))  # noqa: E501
        if 'secret_enc_val' in params:
            query_params.append(('secret_enc_val', params['secret_enc_val']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/item/{item_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_role(self, akeyless_uam_user_creds, new_role_name, role_name, **kwargs):  # noqa: E501
        """Updating an existing role in the account  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_role(akeyless_uam_user_creds, new_role_name, role_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_role_name: The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str role_action: The role action.
        :param str comment: Comments
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_role_with_http_info(akeyless_uam_user_creds, new_role_name, role_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_role_with_http_info(akeyless_uam_user_creds, new_role_name, role_name, **kwargs)  # noqa: E501
            return data

    def update_role_with_http_info(self, akeyless_uam_user_creds, new_role_name, role_name, **kwargs):  # noqa: E501
        """Updating an existing role in the account  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_role_with_http_info(akeyless_uam_user_creds, new_role_name, role_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_role_name: The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str role_action: The role action.
        :param str comment: Comments
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'new_role_name', 'role_name', 'akeyless_request_id', 'akeyless_client_id', 'role_action', 'comment']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `update_role`")  # noqa: E501
        # verify the required parameter 'new_role_name' is set
        if ('new_role_name' not in params or
                params['new_role_name'] is None):
            raise ValueError("Missing the required parameter `new_role_name` when calling `update_role`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `update_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['role_name'] = params['role_name']  # noqa: E501

        query_params = []
        if 'new_role_name' in params:
            query_params.append(('new_role_name', params['new_role_name']))  # noqa: E501
        if 'role_action' in params:
            query_params.append(('role_action', params['role_action']))  # noqa: E501
        if 'comment' in params:
            query_params.append(('comment', params['comment']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role/{role_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user(self, akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, user_name, **kwargs):  # noqa: E501
        """Updating an existing user in the account  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_user(akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, user_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_set_user_access_policy_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_user_name: The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
        :param str user_name: User name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_user_with_http_info(akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, user_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_user_with_http_info(akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, user_name, **kwargs)  # noqa: E501
            return data

    def update_user_with_http_info(self, akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, user_name, **kwargs):  # noqa: E501
        """Updating an existing user in the account  # noqa: E501

        This endpoint is accessible only by the account admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_user_with_http_info(akeyless_uam_user_creds, akeyless_set_user_access_policy_creds, new_user_name, user_name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_uam_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_set_user_access_policy_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_user_name: The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
        :param str user_name: User name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_user_creds', 'akeyless_set_user_access_policy_creds', 'new_user_name', 'user_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_user_creds' is set
        if ('akeyless_uam_user_creds' not in params or
                params['akeyless_uam_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_user_creds` when calling `update_user`")  # noqa: E501
        # verify the required parameter 'akeyless_set_user_access_policy_creds' is set
        if ('akeyless_set_user_access_policy_creds' not in params or
                params['akeyless_set_user_access_policy_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_set_user_access_policy_creds` when calling `update_user`")  # noqa: E501
        # verify the required parameter 'new_user_name' is set
        if ('new_user_name' not in params or
                params['new_user_name'] is None):
            raise ValueError("Missing the required parameter `new_user_name` when calling `update_user`")  # noqa: E501
        # verify the required parameter 'user_name' is set
        if ('user_name' not in params or
                params['user_name'] is None):
            raise ValueError("Missing the required parameter `user_name` when calling `update_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_name' in params:
            path_params['user_name'] = params['user_name']  # noqa: E501

        query_params = []
        if 'new_user_name' in params:
            query_params.append(('new_user_name', params['new_user_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_user_creds' in params:
            header_params['AkeylessUAM-UserCreds'] = params['akeyless_uam_user_creds']  # noqa: E501
        if 'akeyless_set_user_access_policy_creds' in params:
            header_params['Akeyless-SetUserAccessPolicyCreds'] = params['akeyless_set_user_access_policy_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/user/{user_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
