# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 1.0.6
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_uam_api.models.dynamic_secret_message_queue_info import DynamicSecretMessageQueueInfo  # noqa: F401,E501


class DynamicSecretMQAccessReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'mq_info': 'DynamicSecretMessageQueueInfo',
        'receive_messages_signed_request': 'str'
    }

    attribute_map = {
        'mq_info': 'mq_info',
        'receive_messages_signed_request': 'receive_messages_signed_request'
    }

    def __init__(self, mq_info=None, receive_messages_signed_request=None):  # noqa: E501
        """DynamicSecretMQAccessReplyObj - a model defined in Swagger"""  # noqa: E501

        self._mq_info = None
        self._receive_messages_signed_request = None
        self.discriminator = None

        if mq_info is not None:
            self.mq_info = mq_info
        if receive_messages_signed_request is not None:
            self.receive_messages_signed_request = receive_messages_signed_request

    @property
    def mq_info(self):
        """Gets the mq_info of this DynamicSecretMQAccessReplyObj.  # noqa: E501


        :return: The mq_info of this DynamicSecretMQAccessReplyObj.  # noqa: E501
        :rtype: DynamicSecretMessageQueueInfo
        """
        return self._mq_info

    @mq_info.setter
    def mq_info(self, mq_info):
        """Sets the mq_info of this DynamicSecretMQAccessReplyObj.


        :param mq_info: The mq_info of this DynamicSecretMQAccessReplyObj.  # noqa: E501
        :type: DynamicSecretMessageQueueInfo
        """

        self._mq_info = mq_info

    @property
    def receive_messages_signed_request(self):
        """Gets the receive_messages_signed_request of this DynamicSecretMQAccessReplyObj.  # noqa: E501

        A signed request to receive messages from the Message Queue  # noqa: E501

        :return: The receive_messages_signed_request of this DynamicSecretMQAccessReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._receive_messages_signed_request

    @receive_messages_signed_request.setter
    def receive_messages_signed_request(self, receive_messages_signed_request):
        """Sets the receive_messages_signed_request of this DynamicSecretMQAccessReplyObj.

        A signed request to receive messages from the Message Queue  # noqa: E501

        :param receive_messages_signed_request: The receive_messages_signed_request of this DynamicSecretMQAccessReplyObj.  # noqa: E501
        :type: str
        """

        self._receive_messages_signed_request = receive_messages_signed_request

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DynamicSecretMQAccessReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
