# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 1.0.6
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_uam_api.models.derivation_creds_reply_obj import DerivationCredsReplyObj  # noqa: F401,E501


class PrepareDynamicSecretValueReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'derivation_creds': 'DerivationCredsReplyObj',
        'value_id': 'str'
    }

    attribute_map = {
        'derivation_creds': 'derivation_creds',
        'value_id': 'value_id'
    }

    def __init__(self, derivation_creds=None, value_id=None):  # noqa: E501
        """PrepareDynamicSecretValueReplyObj - a model defined in Swagger"""  # noqa: E501

        self._derivation_creds = None
        self._value_id = None
        self.discriminator = None

        if derivation_creds is not None:
            self.derivation_creds = derivation_creds
        if value_id is not None:
            self.value_id = value_id

    @property
    def derivation_creds(self):
        """Gets the derivation_creds of this PrepareDynamicSecretValueReplyObj.  # noqa: E501


        :return: The derivation_creds of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :rtype: DerivationCredsReplyObj
        """
        return self._derivation_creds

    @derivation_creds.setter
    def derivation_creds(self, derivation_creds):
        """Sets the derivation_creds of this PrepareDynamicSecretValueReplyObj.


        :param derivation_creds: The derivation_creds of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :type: DerivationCredsReplyObj
        """

        self._derivation_creds = derivation_creds

    @property
    def value_id(self):
        """Gets the value_id of this PrepareDynamicSecretValueReplyObj.  # noqa: E501

        The ID of the new dynamic secret value to be pull  # noqa: E501

        :return: The value_id of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._value_id

    @value_id.setter
    def value_id(self, value_id):
        """Sets the value_id of this PrepareDynamicSecretValueReplyObj.

        The ID of the new dynamic secret value to be pull  # noqa: E501

        :param value_id: The value_id of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :type: str
        """

        self._value_id = value_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PrepareDynamicSecretValueReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
