# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 1.0.6
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SecretAccessCredsReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'kf_ms_hosts_dns_map': 'dict(str, str)',
        'credential': 'str',
        'customer_fragment_id': 'str',
        'expiry': 'int',
        'item_size': 'int',
        'item_type': 'str',
        'item_version': 'int',
        'restricted_dd': 'str',
        'secret_enc_val': 'str',
        'secret_id': 'int',
        'secret_name': 'str',
        'secret_type': 'str',
        'secret_version': 'int'
    }

    attribute_map = {
        'kf_ms_hosts_dns_map': 'KFMsHostsDNSMap',
        'credential': 'credential',
        'customer_fragment_id': 'customer_fragment_id',
        'expiry': 'expiry',
        'item_size': 'item_size',
        'item_type': 'item_type',
        'item_version': 'item_version',
        'restricted_dd': 'restricted_dd',
        'secret_enc_val': 'secret_enc_val',
        'secret_id': 'secret_id',
        'secret_name': 'secret_name',
        'secret_type': 'secret_type',
        'secret_version': 'secret_version'
    }

    def __init__(self, kf_ms_hosts_dns_map=None, credential=None, customer_fragment_id=None, expiry=None, item_size=None, item_type=None, item_version=None, restricted_dd=None, secret_enc_val=None, secret_id=None, secret_name=None, secret_type=None, secret_version=None):  # noqa: E501
        """SecretAccessCredsReplyObj - a model defined in Swagger"""  # noqa: E501

        self._kf_ms_hosts_dns_map = None
        self._credential = None
        self._customer_fragment_id = None
        self._expiry = None
        self._item_size = None
        self._item_type = None
        self._item_version = None
        self._restricted_dd = None
        self._secret_enc_val = None
        self._secret_id = None
        self._secret_name = None
        self._secret_type = None
        self._secret_version = None
        self.discriminator = None

        if kf_ms_hosts_dns_map is not None:
            self.kf_ms_hosts_dns_map = kf_ms_hosts_dns_map
        if credential is not None:
            self.credential = credential
        if customer_fragment_id is not None:
            self.customer_fragment_id = customer_fragment_id
        if expiry is not None:
            self.expiry = expiry
        if item_size is not None:
            self.item_size = item_size
        if item_type is not None:
            self.item_type = item_type
        if item_version is not None:
            self.item_version = item_version
        if restricted_dd is not None:
            self.restricted_dd = restricted_dd
        if secret_enc_val is not None:
            self.secret_enc_val = secret_enc_val
        if secret_id is not None:
            self.secret_id = secret_id
        if secret_name is not None:
            self.secret_name = secret_name
        if secret_type is not None:
            self.secret_type = secret_type
        if secret_version is not None:
            self.secret_version = secret_version

    @property
    def kf_ms_hosts_dns_map(self):
        """Gets the kf_ms_hosts_dns_map of this SecretAccessCredsReplyObj.  # noqa: E501

        Mapping between the serial number of the key fragments and the KFMs hosts DNS in which they are stored.  # noqa: E501

        :return: The kf_ms_hosts_dns_map of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._kf_ms_hosts_dns_map

    @kf_ms_hosts_dns_map.setter
    def kf_ms_hosts_dns_map(self, kf_ms_hosts_dns_map):
        """Sets the kf_ms_hosts_dns_map of this SecretAccessCredsReplyObj.

        Mapping between the serial number of the key fragments and the KFMs hosts DNS in which they are stored.  # noqa: E501

        :param kf_ms_hosts_dns_map: The kf_ms_hosts_dns_map of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: dict(str, str)
        """

        self._kf_ms_hosts_dns_map = kf_ms_hosts_dns_map

    @property
    def credential(self):
        """Gets the credential of this SecretAccessCredsReplyObj.  # noqa: E501

        Temporary credentials string (JWT format)  # noqa: E501

        :return: The credential of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._credential

    @credential.setter
    def credential(self, credential):
        """Sets the credential of this SecretAccessCredsReplyObj.

        Temporary credentials string (JWT format)  # noqa: E501

        :param credential: The credential of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._credential = credential

    @property
    def customer_fragment_id(self):
        """Gets the customer_fragment_id of this SecretAccessCredsReplyObj.  # noqa: E501

        The customer fragment ID associated with this key (if any).  # noqa: E501

        :return: The customer_fragment_id of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._customer_fragment_id

    @customer_fragment_id.setter
    def customer_fragment_id(self, customer_fragment_id):
        """Sets the customer_fragment_id of this SecretAccessCredsReplyObj.

        The customer fragment ID associated with this key (if any).  # noqa: E501

        :param customer_fragment_id: The customer_fragment_id of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._customer_fragment_id = customer_fragment_id

    @property
    def expiry(self):
        """Gets the expiry of this SecretAccessCredsReplyObj.  # noqa: E501

        Credentials expiration date  # noqa: E501

        :return: The expiry of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._expiry

    @expiry.setter
    def expiry(self, expiry):
        """Sets the expiry of this SecretAccessCredsReplyObj.

        Credentials expiration date  # noqa: E501

        :param expiry: The expiry of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._expiry = expiry

    @property
    def item_size(self):
        """Gets the item_size of this SecretAccessCredsReplyObj.  # noqa: E501


        :return: The item_size of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._item_size

    @item_size.setter
    def item_size(self, item_size):
        """Sets the item_size of this SecretAccessCredsReplyObj.


        :param item_size: The item_size of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._item_size = item_size

    @property
    def item_type(self):
        """Gets the item_type of this SecretAccessCredsReplyObj.  # noqa: E501


        :return: The item_type of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._item_type

    @item_type.setter
    def item_type(self, item_type):
        """Sets the item_type of this SecretAccessCredsReplyObj.


        :param item_type: The item_type of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._item_type = item_type

    @property
    def item_version(self):
        """Gets the item_version of this SecretAccessCredsReplyObj.  # noqa: E501

        The version, type and size of the key that the fragments belong to  # noqa: E501

        :return: The item_version of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._item_version

    @item_version.setter
    def item_version(self, item_version):
        """Sets the item_version of this SecretAccessCredsReplyObj.

        The version, type and size of the key that the fragments belong to  # noqa: E501

        :param item_version: The item_version of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._item_version = item_version

    @property
    def restricted_dd(self):
        """Gets the restricted_dd of this SecretAccessCredsReplyObj.  # noqa: E501

        In case not empty, the derivation operation will be restricted to this derivation data  # noqa: E501

        :return: The restricted_dd of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._restricted_dd

    @restricted_dd.setter
    def restricted_dd(self, restricted_dd):
        """Sets the restricted_dd of this SecretAccessCredsReplyObj.

        In case not empty, the derivation operation will be restricted to this derivation data  # noqa: E501

        :param restricted_dd: The restricted_dd of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._restricted_dd = restricted_dd

    @property
    def secret_enc_val(self):
        """Gets the secret_enc_val of this SecretAccessCredsReplyObj.  # noqa: E501

        The encrypted secret value.  # noqa: E501

        :return: The secret_enc_val of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._secret_enc_val

    @secret_enc_val.setter
    def secret_enc_val(self, secret_enc_val):
        """Sets the secret_enc_val of this SecretAccessCredsReplyObj.

        The encrypted secret value.  # noqa: E501

        :param secret_enc_val: The secret_enc_val of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._secret_enc_val = secret_enc_val

    @property
    def secret_id(self):
        """Gets the secret_id of this SecretAccessCredsReplyObj.  # noqa: E501


        :return: The secret_id of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """Sets the secret_id of this SecretAccessCredsReplyObj.


        :param secret_id: The secret_id of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._secret_id = secret_id

    @property
    def secret_name(self):
        """Gets the secret_name of this SecretAccessCredsReplyObj.  # noqa: E501

        The name, id, version and type of the secret item  # noqa: E501

        :return: The secret_name of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._secret_name

    @secret_name.setter
    def secret_name(self, secret_name):
        """Sets the secret_name of this SecretAccessCredsReplyObj.

        The name, id, version and type of the secret item  # noqa: E501

        :param secret_name: The secret_name of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._secret_name = secret_name

    @property
    def secret_type(self):
        """Gets the secret_type of this SecretAccessCredsReplyObj.  # noqa: E501


        :return: The secret_type of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._secret_type

    @secret_type.setter
    def secret_type(self, secret_type):
        """Sets the secret_type of this SecretAccessCredsReplyObj.


        :param secret_type: The secret_type of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._secret_type = secret_type

    @property
    def secret_version(self):
        """Gets the secret_version of this SecretAccessCredsReplyObj.  # noqa: E501


        :return: The secret_version of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._secret_version

    @secret_version.setter
    def secret_version(self, secret_version):
        """Sets the secret_version of this SecretAccessCredsReplyObj.


        :param secret_version: The secret_version of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._secret_version = secret_version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecretAccessCredsReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
