# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 1.0.6
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class UAMStatusReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auth_dns': 'str',
        'kfm_instances': 'str',
        'version': 'str'
    }

    attribute_map = {
        'auth_dns': 'auth_dns',
        'kfm_instances': 'kfm_instances',
        'version': 'version'
    }

    def __init__(self, auth_dns=None, kfm_instances=None, version=None):  # noqa: E501
        """UAMStatusReplyObj - a model defined in Swagger"""  # noqa: E501

        self._auth_dns = None
        self._kfm_instances = None
        self._version = None
        self.discriminator = None

        if auth_dns is not None:
            self.auth_dns = auth_dns
        if kfm_instances is not None:
            self.kfm_instances = kfm_instances
        if version is not None:
            self.version = version

    @property
    def auth_dns(self):
        """Gets the auth_dns of this UAMStatusReplyObj.  # noqa: E501

        The DNS of the Auth server  # noqa: E501

        :return: The auth_dns of this UAMStatusReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._auth_dns

    @auth_dns.setter
    def auth_dns(self, auth_dns):
        """Sets the auth_dns of this UAMStatusReplyObj.

        The DNS of the Auth server  # noqa: E501

        :param auth_dns: The auth_dns of this UAMStatusReplyObj.  # noqa: E501
        :type: str
        """

        self._auth_dns = auth_dns

    @property
    def kfm_instances(self):
        """Gets the kfm_instances of this UAMStatusReplyObj.  # noqa: E501

        The IDs of the KFM instances the UAM server works with  # noqa: E501

        :return: The kfm_instances of this UAMStatusReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._kfm_instances

    @kfm_instances.setter
    def kfm_instances(self, kfm_instances):
        """Sets the kfm_instances of this UAMStatusReplyObj.

        The IDs of the KFM instances the UAM server works with  # noqa: E501

        :param kfm_instances: The kfm_instances of this UAMStatusReplyObj.  # noqa: E501
        :type: str
        """

        self._kfm_instances = kfm_instances

    @property
    def version(self):
        """Gets the version of this UAMStatusReplyObj.  # noqa: E501

        Current UAM version  # noqa: E501

        :return: The version of this UAMStatusReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this UAMStatusReplyObj.

        Current UAM version  # noqa: E501

        :param version: The version of this UAMStatusReplyObj.  # noqa: E501
        :type: str
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UAMStatusReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
