# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 1.0.6
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import unittest

import akeyless_uam_api
from akeyless_uam_api.api.default_api import DefaultApi  # noqa: E501
from akeyless_uam_api.rest import ApiException


class TestDefaultApi(unittest.TestCase):
    """DefaultApi unit test stubs"""

    def setUp(self):
        self.api = akeyless_uam_api.api.default_api.DefaultApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_create_account(self):
        """Test case for create_account

        Create new account.  # noqa: E501
        """
        pass

    def test_create_item(self):
        """Test case for create_item

        Add a new item to the account.  # noqa: E501
        """
        pass

    def test_create_role(self):
        """Test case for create_role

        Add a new role to the account.  # noqa: E501
        """
        pass

    def test_create_role_item_assoc(self):
        """Test case for create_role_item_assoc

        Add an association between a role and an item.  # noqa: E501
        """
        pass

    def test_create_role_user_assoc(self):
        """Test case for create_role_user_assoc

        Add an association between a role and a user.  # noqa: E501
        """
        pass

    def test_create_user(self):
        """Test case for create_user

        Add a new user to the account.  # noqa: E501
        """
        pass

    def test_delete_item(self):
        """Test case for delete_item

        Deleting an existing item from the account.  # noqa: E501
        """
        pass

    def test_delete_role(self):
        """Test case for delete_role

        Deleting an existing role from the account.  # noqa: E501
        """
        pass

    def test_delete_role_item_assoc(self):
        """Test case for delete_role_item_assoc

        Deleting an association between a role and an item.  # noqa: E501
        """
        pass

    def test_delete_role_user_assoc(self):
        """Test case for delete_role_user_assoc

        Deleting an association between a role and an user.  # noqa: E501
        """
        pass

    def test_delete_user(self):
        """Test case for delete_user

        Deleting an existing user from the account.  # noqa: E501
        """
        pass

    def test_get_account_details(self):
        """Test case for get_account_details

        Get account details.  # noqa: E501
        """
        pass

    def test_get_account_roles(self):
        """Test case for get_account_roles

        Get All the existing roles in the account.  # noqa: E501
        """
        pass

    def test_get_account_users(self):
        """Test case for get_account_users

        Get All the existing users in the account.  # noqa: E501
        """
        pass

    def test_get_dynamic_secret_mq_access(self):
        """Test case for get_dynamic_secret_mq_access

        Get a signed request to receive messages from a Message Queue of a Dynamic Secret.  # noqa: E501
        """
        pass

    def test_get_item(self):
        """Test case for get_item

        Get item details.  # noqa: E501
        """
        pass

    def test_get_item_derivation_creds(self):
        """Test case for get_item_derivation_creds

        Get temporary access credentials to KFM instances for item's fragments derivation.  # noqa: E501
        """
        pass

    def test_get_role(self):
        """Test case for get_role

        Get role details.  # noqa: E501
        """
        pass

    def test_get_rsa_key_decrypt_creds(self):
        """Test case for get_rsa_key_decrypt_creds

        Get temporary access credentials to KFM instances for RSA key fragments decryption.  # noqa: E501
        """
        pass

    def test_get_secret_access_creds(self):
        """Test case for get_secret_access_creds

        """
        pass

    def test_get_status(self):
        """Test case for get_status

        """
        pass

    def test_get_upload_rsa_key_creds(self):
        """Test case for get_upload_rsa_key_creds

        Get temporary access credentials to upload RSA private key fragments into KFMs instances.  # noqa: E501
        """
        pass

    def test_get_upload_secret_creds(self):
        """Test case for get_upload_secret_creds

        Get temporary access credentials to KFM instances to produce the derived protection key of the secret.  # noqa: E501
        """
        pass

    def test_get_user(self):
        """Test case for get_user

        Get user details.  # noqa: E501
        """
        pass

    def test_get_user_items(self):
        """Test case for get_user_items

        Get All the items associated with the user.  # noqa: E501
        """
        pass

    def test_prepare_dynamic_secret_value(self):
        """Test case for prepare_dynamic_secret_value

        Get a signed request to receive messages from a Message Queue of a Dynamic Secret.  # noqa: E501
        """
        pass

    def test_update_item(self):
        """Test case for update_item

        Updating an existing item in the account  # noqa: E501
        """
        pass

    def test_update_role(self):
        """Test case for update_role

        Updating an existing role in the account  # noqa: E501
        """
        pass

    def test_update_user(self):
        """Test case for update_user

        Updating an existing user in the account  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
