# Code of Conduct

## Our Pledge

We are committed to providing a welcoming and inspiring community for all. We pledge to make participation in our project a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation.

## Our Standards

### Positive Behavior

Examples of behavior that contributes to creating a positive environment include:

- **Being respectful and inclusive** in language and actions
- **Using welcoming and inclusive language** that is appropriate for a diverse audience
- **Being constructive** when giving feedback or criticism
- **Focusing on what is best** for the community and the project
- **Showing empathy** towards other community members
- **Being patient** with newcomers and those learning
- **Collaborating effectively** with team members and contributors
- **Acknowledging contributions** from others appropriately
- **Being open to different viewpoints** and experiences
- **Helping others** when possible

### Unacceptable Behavior

The following behaviors are considered harassment and are unacceptable:

- **Harassment of any kind**, including but not limited to:
  - Offensive comments related to gender, gender identity and expression, sexual orientation, disability, mental illness, neuro(a)typicality, physical appearance, body size, age, race, ethnicity, nationality, language, or religion
  - Unwelcome sexual attention or advances
  - Threats of violence or intimidation
  - Deliberate intimidation, stalking, or following
  - Harassing photography or recording
  - Sustained disruption of discussions or events
  - Inappropriate physical contact
  - Unwelcome sexual attention
  - Advocating for, or encouraging, any of the above behavior

- **Trolling, insulting/derogatory comments, and personal or political attacks**
- **Public or private harassment**
- **Publishing others' private information** without explicit permission
- **Other conduct** which could reasonably be considered inappropriate in a professional setting

## Enforcement

### Reporting Violations

If you experience or witness unacceptable behavior, or have any other concerns, please report it by contacting the project maintainers:

- **Primary Contact**: [Gaurab Chhetri](mailto:contact@gaurabchhetri.com.np)
- **GitHub Issues**: Create a private issue or contact us directly
- **Alternative Contact**: Use the project's communication channels

All complaints will be reviewed and investigated promptly and fairly.

### Enforcement Guidelines

Project maintainers are responsible for clarifying and enforcing our standards of acceptable behavior and will take appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive, or harmful.

Project maintainers have the right and responsibility to:

- **Remove, edit, or reject** comments, commits, code, wiki edits, issues, and other contributions that are not aligned with this Code of Conduct
- **Temporarily or permanently ban** contributors for behaviors they deem inappropriate, threatening, offensive, or harmful
- **Take other appropriate action** as necessary

### Enforcement Process

1. **Initial Response**
   - Acknowledge receipt of the report within 24 hours
   - Gather information about the incident
   - Determine if the behavior violates this Code of Conduct

2. **Investigation**
   - Conduct a fair and impartial investigation
   - Interview relevant parties if necessary
   - Document findings

3. **Resolution**
   - Take appropriate action based on findings
   - Communicate resolution to all parties involved
   - Follow up to ensure the issue is resolved

### Consequences

The consequences for violating this Code of Conduct may include:

- **Warning**: A private, written warning providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate
- **Temporary Ban**: A temporary ban from any sort of interaction or public communication with the community for a specified period of time
- **Permanent Ban**: A permanent ban from any sort of public interaction within the community

## Scope

This Code of Conduct applies within all project spaces, and also applies when an individual is officially representing the project or its community in public spaces. Examples of representing the project or community include:

- Using an official project e-mail address
- Posting via an official social media account
- Acting as an appointed representative at an online or offline event
- Contributing to project repositories
- Participating in project discussions and communications

## Community Guidelines

### Communication

- **Be respectful** in all interactions
- **Use clear and constructive language**
- **Ask questions** when you need clarification
- **Provide helpful feedback** when appropriate
- **Be patient** with newcomers and those learning

### Collaboration

- **Work together** towards common goals
- **Share knowledge** and help others learn
- **Be open to feedback** and different perspectives
- **Respect different approaches** to problem-solving
- **Acknowledge contributions** from others

### Technical Discussions

- **Focus on the code and ideas**, not the person
- **Provide constructive criticism** with suggestions for improvement
- **Be specific** about issues and solutions
- **Ask questions** to understand different approaches
- **Respect different coding styles** and preferences

## Diversity and Inclusion

We are committed to creating an inclusive environment that welcomes and respects people from all backgrounds. We believe that diversity makes our community stronger and our project better.

### Our Commitment

- **Welcoming environment** for people of all backgrounds
- **Equal opportunities** for participation and contribution
- **Respectful treatment** of all community members
- **Inclusive language** and communication
- **Accessibility** in our tools and processes

### How You Can Help

- **Use inclusive language** in your communications
- **Be welcoming** to newcomers and those from different backgrounds
- **Challenge bias** when you see it
- **Amplify voices** that might otherwise be unheard
- **Learn about** different perspectives and experiences

## Privacy

We respect your privacy and are committed to protecting it. When reporting violations or concerns:

- **Reports are confidential** and will be handled with discretion
- **Information is shared** only with those who need to know
- **Retaliation is not tolerated** for reporting violations
- **Your identity** will be protected to the extent possible

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org), version 2.1, available at [https://www.contributor-covenant.org/version/2/1/code_of_conduct.html](https://www.contributor-covenant.org/version/2/1/code_of_conduct.html).

Community Impact Guidelines were inspired by [Mozilla's code of conduct enforcement ladder](https://github.com/mozilla/diversity).

For answers to common questions about this code of conduct, see the FAQ at [https://www.contributor-covenant.org/faq](https://www.contributor-covenant.org/faq). Translations are available at [https://www.contributor-covenant.org/translations](https://www.contributor-covenant.org/translations).

## Contact Information

- **Project Maintainer**: [Gaurab Chhetri](mailto:contact@gaurabchhetri.com.np)
- **GitHub Repository**: [https://github.com/gauravfs-14/lit-mcp](https://github.com/gauravfs-14/lit-mcp)
- **Issues**: [https://github.com/gauravfs-14/lit-mcp/issues](https://github.com/gauravfs-14/lit-mcp/issues)

## Updates

This Code of Conduct may be updated from time to time. When significant changes are made, we will:

- **Announce updates** through project communication channels
- **Provide a summary** of changes
- **Give community members** time to review and provide feedback
- **Update the version** and date at the bottom of this document

---

**Version**: 1.1  
**Last Updated**: January 2025  
**Effective Date**: January 2025
