"""
WikiPathways_search

Text search across community-curated pathways (disease, metabolic, signaling). Use to discover re...
"""

from typing import Any, Optional, Callable
from ._shared_client import get_shared_client


def WikiPathways_search(
    query: str,
    organism: Optional[str] = None,
    *,
    stream_callback: Optional[Callable[[str], None]] = None,
    use_cache: bool = False,
    validate: bool = True,
) -> dict[str, Any]:
    """
    Text search across community-curated pathways (disease, metabolic, signaling). Use to discover re...

    Parameters
    ----------
    query : str
        Free-text query (keywords, gene symbols, processes), e.g., 'p53', 'glycolysis'.
    organism : str
        Organism filter (scientific name), e.g., 'Homo sapiens'.
    stream_callback : Callable, optional
        Callback for streaming output
    use_cache : bool, default False
        Enable caching
    validate : bool, default True
        Validate parameters

    Returns
    -------
    dict[str, Any]
    """
    # Handle mutable defaults to avoid B006 linting error

    return get_shared_client().run_one_function(
        {
            "name": "WikiPathways_search",
            "arguments": {"query": query, "organism": organism},
        },
        stream_callback=stream_callback,
        use_cache=use_cache,
        validate=validate,
    )


__all__ = ["WikiPathways_search"]
