"""Add service connectors [0b06faa59c93].

Revision ID: 0b06faa59c93
Revises: 0.39.1
Create Date: 2023-05-10 23:19:18.775302

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "0b06faa59c93"
down_revision = "0.39.1"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "service_connector",
        sa.Column("connector_type", sa.TEXT(), nullable=True),
        sa.Column("auth_method", sa.TEXT(), nullable=True),
        sa.Column("resource_id", sa.TEXT(), nullable=True),
        sa.Column(
            "workspace_id", sqlmodel.sql.sqltypes.GUID(), nullable=False
        ),
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("is_shared", sa.Boolean(), nullable=False),
        sa.Column(
            "description", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("resource_types", sa.LargeBinary(), nullable=False),
        sa.Column("supports_instances", sa.Boolean(), nullable=False),
        sa.Column("configuration", sa.LargeBinary(), nullable=True),
        sa.Column("secret_id", sqlmodel.sql.sqltypes.GUID(), nullable=True),
        sa.Column("expires_at", sa.DateTime(), nullable=True),
        sa.Column("expiration_seconds", sa.Integer(), nullable=True),
        sa.Column("labels", sa.LargeBinary(), nullable=True),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name="fk_service_connector_user_id_user",
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["workspace_id"],
            ["workspace.id"],
            name="fk_service_connector_workspace_id_workspace",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("flavor", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "connector_type",
                sqlmodel.sql.sqltypes.AutoString(),
                nullable=True,
            )
        )
        batch_op.add_column(
            sa.Column(
                "connector_resource_type",
                sqlmodel.sql.sqltypes.AutoString(),
                nullable=True,
            )
        )
        batch_op.add_column(
            sa.Column(
                "connector_resource_id_attr",
                sqlmodel.sql.sqltypes.AutoString(),
                nullable=True,
            )
        )

    with op.batch_alter_table("stack_component", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "connector_id", sqlmodel.sql.sqltypes.GUID(), nullable=True
            )
        )
        batch_op.add_column(
            sa.Column(
                "connector_resource_id",
                sqlmodel.sql.sqltypes.AutoString(),
                nullable=True,
            )
        )
        batch_op.create_foreign_key(
            "fk_stack_component_connector_id_service_connector",
            "service_connector",
            ["connector_id"],
            ["id"],
            ondelete="SET NULL",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("stack_component", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_stack_component_connector_id_service_connector",
            type_="foreignkey",
        )
        batch_op.drop_column("connector_resource_id")
        batch_op.drop_column("connector_id")

    with op.batch_alter_table("flavor", schema=None) as batch_op:
        batch_op.drop_column("connector_resource_type")
        batch_op.drop_column("connector_type")
        batch_op.drop_column("connector_resource_id_attr")

    op.drop_table("service_connector")
    # ### end Alembic commands ###
