"""rename model_config to model_version [14d687c8fa1c].

Revision ID: 14d687c8fa1c
Revises: 0.47.0
Create Date: 2023-11-10 15:54:05.572744

"""

import sqlalchemy as sa
from alembic import op
from sqlmodel import Session

# revision identifiers, used by Alembic.
revision = "14d687c8fa1c"
down_revision = "0.47.0"
branch_labels = None
depends_on = None

update_stmts = [
    sa.text(
        """
        UPDATE pipeline_deployment
        SET pipeline_configuration = REPLACE(
            pipeline_configuration,
            :source_field,
            :target_field
        )
        WHERE pipeline_configuration IS NOT NULL
        """
    ),
    sa.text(
        """
        UPDATE pipeline_deployment
        SET step_configurations = REPLACE(
            step_configurations,
            :source_field,
            :target_field
        )
        WHERE step_configurations IS NOT NULL
        """
    ),
    sa.text(
        """
        UPDATE step_run
        SET step_configuration = REPLACE(
            step_configuration,
            :source_field,
            :target_field
        )
        WHERE step_configuration IS NOT NULL
        """
    ),
]


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "model_versions_artifacts", schema=None
    ) as batch_op:
        batch_op.alter_column(
            "is_model_object",
            new_column_name="is_model_artifact",
            existing_type=sa.BOOLEAN(),
        )
        batch_op.alter_column(
            "is_deployment",
            new_column_name="is_endpoint_artifact",
            existing_type=sa.BOOLEAN(),
        )

    connection = op.get_bind()
    session = Session(bind=connection)

    for source_field, target_field in [
        ('"model_config"', '"model_version"'),
    ]:
        for update_stmt in update_stmts:
            session.execute(
                update_stmt,
                params=dict(
                    source_field=source_field,
                    target_field=target_field,
                ),
            )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "model_versions_artifacts", schema=None
    ) as batch_op:
        batch_op.alter_column(
            "is_model_artifact",
            new_column_name="is_model_object",
            existing_type=sa.BOOLEAN(),
        )
        batch_op.alter_column(
            "is_endpoint_artifact",
            new_column_name="is_deployment",
            existing_type=sa.BOOLEAN(),
        )

    connection = op.get_bind()
    session = Session(bind=connection)

    for source_field, target_field in [
        ("model_version", "model_config"),
    ]:
        for update_stmt in update_stmts:
            session.execute(
                update_stmt,
                params=dict(
                    source_field=source_field,
                    target_field=target_field,
                ),
            )

    # ### end Alembic commands ###
