"""Update Size of Flavor Config Schema [248dfd320b68].

Revision ID: 248dfd320b68
Revises: 7e4a481d17f7
Create Date: 2022-12-16 11:41:54.029991

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "248dfd320b68"
down_revision = "7e4a481d17f7"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("flavor", schema=None) as batch_op:
        batch_op.alter_column(
            "config_schema",
            existing_type=sa.VARCHAR(length=4096),
            type_=sa.TEXT(),
            nullable=False,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("flavor", schema=None) as batch_op:
        batch_op.alter_column(
            "config_schema",
            existing_type=sa.TEXT(),
            type_=sa.VARCHAR(length=4096),
            nullable=True,
        )

    # ### end Alembic commands ###
