"""Add environment info to runs [3c5a367730c2].

Revision ID: 3c5a367730c2
Revises: 0.31.0
Create Date: 2023-01-05 07:51:36.525401

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "3c5a367730c2"
down_revision = "0.31.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("client_environment", sa.TEXT(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("orchestrator_environment", sa.TEXT(), nullable=True)
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_run", schema=None) as batch_op:
        batch_op.drop_column("client_environment")
        batch_op.drop_column("orchestrator_environment")

    # ### end Alembic commands ###
