"""Add build template deployment ID [76a7b9451ccd].

Revision ID: 76a7b9451ccd
Revises: 0.55.3
Create Date: 2023-11-10 15:00:51.057119

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "76a7b9451ccd"
down_revision = "0.55.3"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_build", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "template_deployment_id",
                sqlmodel.sql.sqltypes.GUID(),
                nullable=True,
            )
        )
        batch_op.create_foreign_key(
            "fk_pipeline_build_template_deployment_id_pipeline_deployment",
            "pipeline_deployment",
            ["template_deployment_id"],
            ["id"],
            ondelete="SET NULL",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_build", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_pipeline_build_template_deployment_id_pipeline_deployment",
            type_="foreignkey",
        )
        batch_op.drop_column("template_deployment_id")

    # ### end Alembic commands ###
