"""Increase length on flavor config schema [c1b18cec3a48].

Revision ID: c1b18cec3a48
Revises: alembic_start
Create Date: 2022-10-19 17:12:19.481776

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "c1b18cec3a48"
down_revision = "alembic_start"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("flavorschema", schema=None) as batch_op:
        batch_op.alter_column(
            "config_schema",
            existing_type=sa.VARCHAR(),
            type_=sqlmodel.sql.sqltypes.AutoString(4096),
            nullable=True,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("flavorschema", schema=None) as batch_op:
        batch_op.alter_column(
            "config_schema",
            existing_type=sa.VARCHAR(),
            type_=sqlmodel.sql.sqltypes.AutoString(),
            nullable=False,
        )

    # ### end Alembic commands ###
