"""Update build filtering [d26471b6fe8f].

Revision ID: d26471b6fe8f
Revises: 4c41c0ca42db
Create Date: 2023-03-07 17:31:39.243348

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "d26471b6fe8f"
down_revision = "4c41c0ca42db"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_build", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "zenml_version",
                sqlmodel.sql.sqltypes.AutoString(),
                nullable=True,
            )
        )
        batch_op.add_column(
            sa.Column("contains_code", sa.Boolean(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "python_version",
                sqlmodel.sql.sqltypes.AutoString(),
                nullable=True,
            )
        )
        batch_op.add_column(
            sa.Column(
                "checksum", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )
    op.execute("UPDATE pipeline_build SET contains_code = 1")
    with op.batch_alter_table("pipeline_build", schema=None) as batch_op:
        batch_op.alter_column(
            "contains_code",
            nullable=False,
            existing_type=sa.Boolean(),
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipeline_build", schema=None) as batch_op:
        batch_op.drop_column("zenml_version")
        batch_op.drop_column("checksum")
        batch_op.drop_column("python_version")
        batch_op.drop_column("contains_code")

    # ### end Alembic commands ###
