from ..models import State, Chamber, District, simple_numbered_districts

SD = State(
    name="South Dakota",
    abbr="SD",
    capital="Pierre",
    capital_tz="America/Chicago",
    fips="46",
    unicameral=False,
    legislature_name="South Dakota State Legislature",
    legislature_organization_id="ocd-organization/7b114895-6d62-4b8d-b391-b170fa9011d2",
    executive_name="Office of the Governor",
    executive_organization_id="ocd-organization/c6e0fb4e-6cf7-4025-896c-f8cec8ad8cda",
    division_id="ocd-division/country:us/state:sd",
    jurisdiction_id="ocd-jurisdiction/country:us/state:sd/government",
    url="http://www.sdlegislature.gov/",
    lower=Chamber(
        chamber_type="lower",
        name="House",
        organization_id="ocd-organization/2432bd5a-3c3f-4784-b1f5-c6134171162b",
        num_seats=70,
        title="Representative",
        districts=[
            District("1", "lower", "ocd-division/country:us/state:sd/sldl:1", 2),
            District("2", "lower", "ocd-division/country:us/state:sd/sldl:2", 2),
            District("3", "lower", "ocd-division/country:us/state:sd/sldl:3", 2),
            District("4", "lower", "ocd-division/country:us/state:sd/sldl:4", 2),
            District("5", "lower", "ocd-division/country:us/state:sd/sldl:5", 2),
            District("6", "lower", "ocd-division/country:us/state:sd/sldl:6", 2),
            District("7", "lower", "ocd-division/country:us/state:sd/sldl:7", 2),
            District("8", "lower", "ocd-division/country:us/state:sd/sldl:8", 2),
            District("9", "lower", "ocd-division/country:us/state:sd/sldl:9", 2),
            District("10", "lower", "ocd-division/country:us/state:sd/sldl:10", 2),
            District("11", "lower", "ocd-division/country:us/state:sd/sldl:11", 2),
            District("12", "lower", "ocd-division/country:us/state:sd/sldl:12", 2),
            District("13", "lower", "ocd-division/country:us/state:sd/sldl:13", 2),
            District("14", "lower", "ocd-division/country:us/state:sd/sldl:14", 2),
            District("15", "lower", "ocd-division/country:us/state:sd/sldl:15", 2),
            District("16", "lower", "ocd-division/country:us/state:sd/sldl:16", 2),
            District("17", "lower", "ocd-division/country:us/state:sd/sldl:17", 2),
            District("18", "lower", "ocd-division/country:us/state:sd/sldl:18", 2),
            District("19", "lower", "ocd-division/country:us/state:sd/sldl:19", 2),
            District("20", "lower", "ocd-division/country:us/state:sd/sldl:20", 2),
            District("21", "lower", "ocd-division/country:us/state:sd/sldl:21", 2),
            District("22", "lower", "ocd-division/country:us/state:sd/sldl:22", 2),
            District("23", "lower", "ocd-division/country:us/state:sd/sldl:23", 2),
            District("24", "lower", "ocd-division/country:us/state:sd/sldl:24", 2),
            District("25", "lower", "ocd-division/country:us/state:sd/sldl:25", 2),
            District("26A", "lower", "ocd-division/country:us/state:sd/sldl:26a", 1),
            District("26B", "lower", "ocd-division/country:us/state:sd/sldl:26b", 1),
            District("27", "lower", "ocd-division/country:us/state:sd/sldl:27", 2),
            District("28A", "lower", "ocd-division/country:us/state:sd/sldl:28a", 1),
            District("28B", "lower", "ocd-division/country:us/state:sd/sldl:28b", 1),
            District("29", "lower", "ocd-division/country:us/state:sd/sldl:29", 2),
            District("30", "lower", "ocd-division/country:us/state:sd/sldl:30", 2),
            District("31", "lower", "ocd-division/country:us/state:sd/sldl:31", 2),
            District("32", "lower", "ocd-division/country:us/state:sd/sldl:32", 2),
            District("33", "lower", "ocd-division/country:us/state:sd/sldl:33", 2),
            District("34", "lower", "ocd-division/country:us/state:sd/sldl:34", 2),
            District("35", "lower", "ocd-division/country:us/state:sd/sldl:35", 2),
        ],
    ),
    upper=Chamber(
        chamber_type="upper",
        name="Senate",
        organization_id="ocd-organization/5a7260e0-bd1e-4f37-949f-ebb386e8bacc",
        num_seats=35,
        title="Senator",
        districts=simple_numbered_districts(
            "ocd-division/country:us/state:sd", "upper", 35
        ),
    ),
)
