from ..models import State, Chamber, District

WV = State(
    name="West Virginia",
    abbr="WV",
    capital="Charleston",
    capital_tz="America/New_York",
    fips="54",
    unicameral=False,
    legislature_name="West Virginia Legislature",
    legislature_organization_id="ocd-organization/237dc1a5-2314-433e-887e-d63a970cf67d",
    executive_name="Office of the Governor",
    executive_organization_id="ocd-organization/193c7d7d-3161-5a34-a7b1-df72b553b7f3",
    division_id="ocd-division/country:us/state:wv",
    jurisdiction_id="ocd-jurisdiction/country:us/state:wv/government",
    url="http://www.legis.state.wv.us/",
    lower=Chamber(
        chamber_type="lower",
        name="House",
        organization_id="ocd-organization/3fcd7789-fa25-4d8b-a4b9-7c0d1d0f8bc4",
        num_seats=100,
        title="Delegate",
        districts=[
            District("1", "lower", "ocd-division/country:us/state:wv/sldl:1", 2),
            District("2", "lower", "ocd-division/country:us/state:wv/sldl:2", 1),
            District("3", "lower", "ocd-division/country:us/state:wv/sldl:3", 2),
            District("4", "lower", "ocd-division/country:us/state:wv/sldl:4", 2),
            District("5", "lower", "ocd-division/country:us/state:wv/sldl:5", 1),
            District("6", "lower", "ocd-division/country:us/state:wv/sldl:6", 1),
            District("7", "lower", "ocd-division/country:us/state:wv/sldl:7", 1),
            District("8", "lower", "ocd-division/country:us/state:wv/sldl:8", 1),
            District("9", "lower", "ocd-division/country:us/state:wv/sldl:9", 1),
            District("10", "lower", "ocd-division/country:us/state:wv/sldl:10", 3),
            District("11", "lower", "ocd-division/country:us/state:wv/sldl:11", 1),
            District("12", "lower", "ocd-division/country:us/state:wv/sldl:12", 1),
            District("13", "lower", "ocd-division/country:us/state:wv/sldl:13", 2),
            District("14", "lower", "ocd-division/country:us/state:wv/sldl:14", 1),
            District("15", "lower", "ocd-division/country:us/state:wv/sldl:15", 1),
            District("16", "lower", "ocd-division/country:us/state:wv/sldl:16", 3),
            District("17", "lower", "ocd-division/country:us/state:wv/sldl:17", 2),
            District("18", "lower", "ocd-division/country:us/state:wv/sldl:18", 1),
            District("19", "lower", "ocd-division/country:us/state:wv/sldl:19", 2),
            District("20", "lower", "ocd-division/country:us/state:wv/sldl:20", 1),
            District("21", "lower", "ocd-division/country:us/state:wv/sldl:21", 1),
            District("22", "lower", "ocd-division/country:us/state:wv/sldl:22", 2),
            District("23", "lower", "ocd-division/country:us/state:wv/sldl:23", 1),
            District("24", "lower", "ocd-division/country:us/state:wv/sldl:24", 2),
            District("25", "lower", "ocd-division/country:us/state:wv/sldl:25", 1),
            District("26", "lower", "ocd-division/country:us/state:wv/sldl:26", 1),
            District("27", "lower", "ocd-division/country:us/state:wv/sldl:27", 3),
            District("28", "lower", "ocd-division/country:us/state:wv/sldl:28", 2),
            District("29", "lower", "ocd-division/country:us/state:wv/sldl:29", 1),
            District("30", "lower", "ocd-division/country:us/state:wv/sldl:30", 1),
            District("31", "lower", "ocd-division/country:us/state:wv/sldl:31", 1),
            District("32", "lower", "ocd-division/country:us/state:wv/sldl:32", 3),
            District("33", "lower", "ocd-division/country:us/state:wv/sldl:33", 1),
            District("34", "lower", "ocd-division/country:us/state:wv/sldl:34", 1),
            District("35", "lower", "ocd-division/country:us/state:wv/sldl:35", 4),
            District("36", "lower", "ocd-division/country:us/state:wv/sldl:36", 3),
            District("37", "lower", "ocd-division/country:us/state:wv/sldl:37", 1),
            District("38", "lower", "ocd-division/country:us/state:wv/sldl:38", 1),
            District("39", "lower", "ocd-division/country:us/state:wv/sldl:39", 1),
            District("40", "lower", "ocd-division/country:us/state:wv/sldl:40", 1),
            District("41", "lower", "ocd-division/country:us/state:wv/sldl:41", 1),
            District("42", "lower", "ocd-division/country:us/state:wv/sldl:42", 2),
            District("43", "lower", "ocd-division/country:us/state:wv/sldl:43", 2),
            District("44", "lower", "ocd-division/country:us/state:wv/sldl:44", 1),
            District("45", "lower", "ocd-division/country:us/state:wv/sldl:45", 1),
            District("46", "lower", "ocd-division/country:us/state:wv/sldl:46", 1),
            District("47", "lower", "ocd-division/country:us/state:wv/sldl:47", 1),
            District("48", "lower", "ocd-division/country:us/state:wv/sldl:48", 4),
            District("49", "lower", "ocd-division/country:us/state:wv/sldl:49", 1),
            District("50", "lower", "ocd-division/country:us/state:wv/sldl:50", 3),
            District("51", "lower", "ocd-division/country:us/state:wv/sldl:51", 5),
            District("52", "lower", "ocd-division/country:us/state:wv/sldl:52", 1),
            District("53", "lower", "ocd-division/country:us/state:wv/sldl:53", 1),
            District("54", "lower", "ocd-division/country:us/state:wv/sldl:54", 1),
            District("55", "lower", "ocd-division/country:us/state:wv/sldl:55", 1),
            District("56", "lower", "ocd-division/country:us/state:wv/sldl:56", 1),
            District("57", "lower", "ocd-division/country:us/state:wv/sldl:57", 1),
            District("58", "lower", "ocd-division/country:us/state:wv/sldl:58", 1),
            District("59", "lower", "ocd-division/country:us/state:wv/sldl:59", 1),
            District("60", "lower", "ocd-division/country:us/state:wv/sldl:60", 1),
            District("61", "lower", "ocd-division/country:us/state:wv/sldl:61", 1),
            District("62", "lower", "ocd-division/country:us/state:wv/sldl:62", 1),
            District("63", "lower", "ocd-division/country:us/state:wv/sldl:63", 1),
            District("64", "lower", "ocd-division/country:us/state:wv/sldl:64", 1),
            District("65", "lower", "ocd-division/country:us/state:wv/sldl:65", 1),
            District("66", "lower", "ocd-division/country:us/state:wv/sldl:66", 1),
            District("67", "lower", "ocd-division/country:us/state:wv/sldl:67", 1),
        ],
    ),
    upper=Chamber(
        chamber_type="upper",
        name="Senate",
        organization_id="ocd-organization/660bc141-f4cb-4d98-b334-b12b637776ba",
        num_seats=34,
        title="Senator",
        districts=[
            District("1", "upper", "ocd-division/country:us/state:wv/sldu:1", 2),
            District("2", "upper", "ocd-division/country:us/state:wv/sldu:2", 2),
            District("3", "upper", "ocd-division/country:us/state:wv/sldu:3", 2),
            District("4", "upper", "ocd-division/country:us/state:wv/sldu:4", 2),
            District("5", "upper", "ocd-division/country:us/state:wv/sldu:5", 2),
            District("6", "upper", "ocd-division/country:us/state:wv/sldu:6", 2),
            District("7", "upper", "ocd-division/country:us/state:wv/sldu:7", 2),
            District("8", "upper", "ocd-division/country:us/state:wv/sldu:8", 2),
            District("9", "upper", "ocd-division/country:us/state:wv/sldu:9", 2),
            District("10", "upper", "ocd-division/country:us/state:wv/sldu:10", 2),
            District("11", "upper", "ocd-division/country:us/state:wv/sldu:11", 2),
            District("12", "upper", "ocd-division/country:us/state:wv/sldu:12", 2),
            District("13", "upper", "ocd-division/country:us/state:wv/sldu:13", 2),
            District("14", "upper", "ocd-division/country:us/state:wv/sldu:14", 2),
            District("15", "upper", "ocd-division/country:us/state:wv/sldu:15", 2),
            District("16", "upper", "ocd-division/country:us/state:wv/sldu:16", 2),
            District("17", "upper", "ocd-division/country:us/state:wv/sldu:17", 2),
        ],
    ),
)
