# generated by datamodel-codegen:
#   filename:  openapi-spec.json
#   timestamp: 2025-09-01T13:47:36+00:00
#   version:   0.25.9

from __future__ import annotations

from enum import Enum
from typing import Annotated, Any, Mapping, Sequence
from uuid import UUID

from pydantic import AwareDatetime, BaseModel, Field


class ContentType(Enum):
    text_markdown = 'text/markdown'
    text_plain = 'text/plain'
    text_javascript = 'text/javascript'
    text_typescript = 'text/typescript'
    application_json = 'application/json'
    text_html = 'text/html'
    text_css = 'text/css'
    text_x_python = 'text/x-python'
    text_x_java_source = 'text/x-java-source'
    text_x_c__src = 'text/x-c++src'
    text_x_csrc = 'text/x-csrc'
    application_xml = 'application/xml'
    application_yaml = 'application/yaml'
    text_csv = 'text/csv'
    image_jpeg = 'image/jpeg'
    image_png = 'image/png'
    image_gif = 'image/gif'
    image_webp = 'image/webp'
    image_bmp = 'image/bmp'
    image_svg_xml = 'image/svg+xml'
    application_pdf = 'application/pdf'
    application_zip = 'application/zip'
    audio_mpeg = 'audio/mpeg'
    video_mp4 = 'video/mp4'
    video_x_msvideo = 'video/x-msvideo'
    video_quicktime = 'video/quicktime'
    application_octet_stream = 'application/octet-stream'


class WriteFileRequest(BaseModel):
    path: Annotated[str, Field(examples=['src/app.py'], min_length=1)]
    content: Annotated[str, Field(examples=["print('Hello World')"], max_length=10485760)]
    contentType: Annotated[
        ContentType | None,
        Field(
            None,
            description='MIME type of the file content. Must be one of the supported types.',
            examples=['text/x-python'],
        ),
    ]
    isBase64: bool = False


class EditFileRequest(BaseModel):
    oldString: Annotated[str, Field(max_length=100000, min_length=1)]
    newString: Annotated[str, Field(max_length=100000)]


class AppendFileRequest(BaseModel):
    content: Annotated[str, Field(max_length=10485760, min_length=1)]


class OverwriteFileRequest(BaseModel):
    content: Annotated[str, Field(max_length=10485760)]
    isBase64: bool = False


class FileMetadata(BaseModel):
    id: UUID | None = None
    path: str | None = None
    version: Annotated[int | None, Field(None, ge=1)]
    mimeType: str | None = None
    size: Annotated[int | None, Field(None, ge=0)]
    createdAt: AwareDatetime | None = None
    updatedAt: AwareDatetime | None = None


class FileOperationResponse(BaseModel):
    success: Annotated[bool, Field(examples=[True])]
    data: FileMetadata
    operation: Annotated[str, Field(examples=['write_file'])]
    message: Annotated[str, Field(examples=['File created successfully, version 1'])]


class Data(BaseModel):
    id: UUID | None = None
    path: str | None = None
    content: str | None = None
    version: int | None = None
    mimeType: str | None = None
    size: int | None = None
    createdAt: AwareDatetime | None = None
    updatedAt: AwareDatetime | None = None


class FileContentResponse(BaseModel):
    success: Annotated[bool, Field(examples=[True])]
    data: Data
    operation: Annotated[str, Field(examples=['read_file'])]
    message: Annotated[str, Field(examples=['File read successfully'])]


class FileMetadataResponse(BaseModel):
    success: Annotated[bool, Field(examples=[True])]
    data: FileMetadata
    operation: Annotated[str, Field(examples=['get_file_metadata'])]
    message: Annotated[str, Field(examples=['File metadata retrieved successfully'])]


class File(BaseModel):
    path: str | None = None
    mimeType: str | None = None


class Version(BaseModel):
    version: int | None = None
    size: int | None = None
    createdAt: AwareDatetime | None = None
    updatedAt: AwareDatetime | None = None


class Data1(BaseModel):
    file: File | None = None
    versions: Sequence[Version] | None = None
    total: Annotated[int | None, Field(None, ge=0)]
    limit: Annotated[int | None, Field(None, ge=1)]
    offset: Annotated[int | None, Field(None, ge=0)]


class FileVersionsResponse(BaseModel):
    success: Annotated[bool, Field(examples=[True])]
    data: Data1
    operation: Annotated[str, Field(examples=['get_file_versions'])]
    message: Annotated[str, Field(examples=['File versions retrieved successfully'])]


class Data2(BaseModel):
    files: Sequence[FileMetadata] | None = None
    total: Annotated[int | None, Field(None, ge=0)]
    limit: Annotated[int | None, Field(None, ge=1)]
    offset: Annotated[int | None, Field(None, ge=0)]


class FileListResponse(BaseModel):
    success: Annotated[bool, Field(examples=[True])]
    data: Data2
    operation: Annotated[str, Field(examples=['list_files'])]
    message: Annotated[str, Field(examples=['Files listed successfully'])]


class Error(BaseModel):
    code: str
    message: str


class ErrorResponse(BaseModel):
    success: Annotated[bool, Field(examples=[False])]
    error: Error
    operation: str | None = None
    details: Mapping[str, Any] | None = None


class Status(Enum):
    ok = 'ok'


class HealthResponse(BaseModel):
    status: Annotated[Status, Field(examples=['ok'])]
    timestamp: AwareDatetime
    message: Annotated[str, Field(examples=['OpenFiles API'])]
    version: Annotated[str, Field(examples=['1.0.0'])]
