"""Generated by Django 4.1.7 on 2023-02-26 21:49."""

from django.db import migrations, models


def ensure_fit_to_has_valid_choices(apps, _schema_editor):
    """Ensure fit_to has valid choices before adding constraint."""
    bookmark_model = apps.get_model("codex", "bookmark")
    choices = {"", "SCREEN", "WIDTH", "HEIGHT", "ORIG"}
    bookmark_model.objects.exclude(fit_to__in=choices).update(fit_to="")


class Migration(migrations.Migration):
    """Add bookmark choices to database."""

    dependencies = [
        ("codex", "0020_remove_search_tables"),
    ]

    operations = [
        migrations.RunPython(ensure_fit_to_has_valid_choices),
        migrations.AlterField(
            model_name="bookmark",
            name="fit_to",
            field=models.CharField(
                blank=True,
                choices=[
                    ("SCREEN", "Screen"),
                    ("WIDTH", "Width"),
                    ("HEIGHT", "Height"),
                    ("ORIG", "Orig"),
                ],
                default="",
                max_length=6,
            ),
        ),
        migrations.AddField(
            model_name="bookmark",
            name="read_in_reverse",
            field=models.BooleanField(default=None, null=True),
        ),
    ]
