// The Python bindings have unsafe methods so if you derive Deserialize,
// Rust assumes that you may not be upholding invariants, and therefore
// Deserialize (which is a safe trait) may not be safe to implement for the type.
// We know that the Python bindings are safe with arbitrary values, so we can suppress this warning.
#![allow(clippy::unsafe_derive_deserialize)]

mod block_record;
mod bytes;
mod chia_protocol;
mod classgroup;
mod coin;
mod coin_spend;
mod coin_state;
mod end_of_sub_slot_bundle;
mod fee_estimate;
mod foliage;
mod full_node_protocol;
mod fullblock;
mod header_block;
mod peer_info;
mod pool_target;
mod pos_quality;
mod pot_iterations;
mod program;
mod proof_of_space;
mod reward_chain_block;
mod slots;
mod spend_bundle;
mod sub_epoch_summary;
mod unfinished_block;
mod unfinished_header_block;
mod vdf;
mod wallet_protocol;
mod weight_proof;

#[cfg(feature = "py-bindings")]
mod lazy_node;

// export shorter names
pub use crate::block_record::*;
pub use crate::bytes::*;
pub use crate::chia_protocol::*;
pub use crate::classgroup::*;
pub use crate::coin::*;
pub use crate::coin_spend::*;
pub use crate::coin_state::*;
pub use crate::end_of_sub_slot_bundle::*;
pub use crate::fee_estimate::*;
pub use crate::foliage::*;
pub use crate::full_node_protocol::*;
pub use crate::fullblock::*;
pub use crate::header_block::*;
pub use crate::peer_info::*;
pub use crate::pool_target::*;
pub use crate::pos_quality::*;
pub use crate::pot_iterations::*;
pub use crate::program::*;
pub use crate::proof_of_space::*;
pub use crate::reward_chain_block::*;
pub use crate::slots::*;
pub use crate::spend_bundle::*;
pub use crate::sub_epoch_summary::*;
pub use crate::unfinished_block::*;
pub use crate::unfinished_header_block::*;
pub use crate::vdf::*;
pub use crate::wallet_protocol::*;
pub use crate::weight_proof::*;

#[cfg(feature = "py-bindings")]
pub use crate::lazy_node::*;
