
#
# this file is generated by generate_type_stubs.py
#

from typing import Optional, Sequence, Union, Any, ClassVar, final
from .sized_bytes import bytes32, bytes100
from .sized_ints import uint8, uint16, uint32, uint64, uint128, int8, int16, int32, int64
from typing_extensions import Self

ReadableBuffer = Union[bytes, bytearray, memoryview]

class _Unspec:
    pass

def solution_generator(spends: Sequence[tuple[Coin, bytes, bytes]]) -> bytes: ...
def solution_generator_backrefs(spends: Sequence[tuple[Coin, bytes, bytes]]) -> bytes: ...

def is_canonical_serialization(buf: bytes) -> bool: ...

def compute_merkle_set_root(values: Sequence[bytes]) -> bytes: ...

def supports_fast_forward(spend: CoinSpend) -> bool : ...
def fast_forward_singleton(spend: CoinSpend, new_coin: Coin, new_parent: Coin) -> bytes: ...

def run_block_generator(
    program: ReadableBuffer, block_refs: list[ReadableBuffer], max_cost: int, flags: int, signature: G2Element, bls_cache: Optional[BLSCache], constants: ConsensusConstants
) -> tuple[Optional[int], Optional[SpendBundleConditions]]: ...

def run_block_generator2(
    program: ReadableBuffer, block_refs: list[ReadableBuffer], max_cost: int, flags: int, signature: G2Element, bls_cache: Optional[BLSCache], constants: ConsensusConstants
) -> tuple[Optional[int], Optional[SpendBundleConditions]]: ...

def additions_and_removals(
    program: ReadableBuffer, block_refs: list[ReadableBuffer], flags: int, constants: ConsensusConstants
) -> tuple[list[tuple[Coin, Optional[bytes]]], list[tuple[bytes32, Coin]]]: ...

def confirm_included_already_hashed(
    root: bytes32,
    item: bytes32,
    proof: bytes,
) -> bool: ...

def confirm_not_included_already_hashed(
    root: bytes32,
    item: bytes32,
    proof: bytes,
) -> bool: ...

def validate_clvm_and_signature(
    new_spend: SpendBundle,
    max_cost: int,
    constants: ConsensusConstants,
    peak_height: int,
) -> tuple[SpendBundleConditions, list[tuple[bytes32, GTElement]], float]: ...

def compute_puzzle_fingerprint(puzzle: Program, solution: Program, *, max_cost: int, flags: int) -> tuple[int, bytes]: ...

def get_conditions_from_spendbundle(
    spend_bundle: SpendBundle,
    max_cost: int,
    constants: ConsensusConstants,
    height: int,
) -> SpendBundleConditions: ...

def get_spends_for_trusted_block(
    constants: ConsensusConstants,
    generator: Program,
    block_refs: list[ReadableBuffer],
    flags: int,
) -> dict[str, Any]: ...

def get_spends_for_trusted_block_with_conditions(
    constants: ConsensusConstants,
    generator: Program,
    block_refs: list[ReadableBuffer],
    flags: int,
) -> list[dict[str, Any]]: ...

def get_flags_for_height_and_constants(
    height: int,
    constants: ConsensusConstants
) -> int: ...

def calculate_ip_iters(
    constants: ConsensusConstants,
    sub_slot_iters: uint64,
    signage_point_index: uint8,
    required_iters: uint64,
) -> uint64: ...

def calculate_sp_iters(
    constants: ConsensusConstants,
    sub_slot_iters: uint64,
    signage_point_index: uint8,
) -> uint64: ...

def calculate_sp_interval_iters(
    constants: ConsensusConstants,
    sub_slot_iters: uint64,
) -> uint64: ...

def is_overflow_block(
    constants: ConsensusConstants,
    signage_point_index: uint8,
) -> bool: ...

def expected_plot_size(
    k: int
) -> int: ...


NO_UNKNOWN_CONDS: int = ...
STRICT_ARGS_COUNT: int = ...
LIMIT_HEAP: int = ...
ENABLE_KECCAK_OPS_OUTSIDE_GUARD: int = ...
MEMPOOL_MODE: int = ...
DONT_VALIDATE_SIGNATURE: int = ...
COST_CONDITIONS: int = ...

ELIGIBLE_FOR_DEDUP: int = ...
ELIGIBLE_FOR_FF: int = ...

NO_UNKNOWN_OPS: int = ...

def run_chia_program(
    program: bytes, args: bytes, max_cost: int, flags: int
) -> tuple[int, LazyNode]: ...

@final
class LazyNode:
    pair: Optional[tuple[LazyNode, LazyNode]]
    atom: Optional[bytes]

def serialized_length(program: ReadableBuffer) -> int: ...
def tree_hash(blob: ReadableBuffer) -> bytes32: ...
def get_puzzle_and_solution_for_coin(program: ReadableBuffer, args: ReadableBuffer, max_cost: int, find_parent: bytes32, find_amount: int, find_ph: bytes32, flags: int) -> tuple[bytes, bytes]: ...
def get_puzzle_and_solution_for_coin2(generator: Program, block_refs: list[ReadableBuffer], max_cost: int, find_coin: Coin, flags: int) -> tuple[Program, Program]: ...

@final
class BLSCache:
    def __init__(self, cache_size: Optional[int] = 50000) -> None: ...
    def len(self) -> int: ...
    def aggregate_verify(self, pks: list[G1Element], msgs: list[bytes], sig: G2Element) -> bool: ...
    def items(self) -> list[tuple[bytes, GTElement]]: ...
    def update(self, other: Sequence[tuple[bytes, GTElement]]) -> None: ...
    def evict(self, pks: list[G1Element], msgs: list[bytes]) -> None: ...

@final
class AugSchemeMPL:
    @staticmethod
    def sign(pk: PrivateKey, msg: bytes, prepend_pk: Optional[G1Element] = None) -> G2Element: ...
    @staticmethod
    def aggregate(sigs: Sequence[G2Element]) -> G2Element: ...
    @staticmethod
    def verify(pk: G1Element, msg: bytes, sig: G2Element) -> bool: ...
    @staticmethod
    def aggregate_verify(pks: Sequence[G1Element], msgs: Sequence[bytes], sig: G2Element) -> bool: ...
    @staticmethod
    def key_gen(seed: bytes) -> PrivateKey: ...
    @staticmethod
    def g2_from_message(msg: bytes) -> G2Element: ...
    @staticmethod
    def derive_child_sk(sk: PrivateKey, index: int) -> PrivateKey: ...
    @staticmethod
    def derive_child_sk_unhardened(sk: PrivateKey, index: int) -> PrivateKey: ...
    @staticmethod
    def derive_child_pk_unhardened(pk: G1Element, index: int) -> G1Element: ...

@final
class BlockBuilder:
    def add_spend_bundles(self, bundles: Sequence[SpendBundle], cost: uint64, constants: ConsensusConstants) -> tuple[bool, bool]: ...
    def cost(self) -> uint64: ...
    def finalize(self, constants: ConsensusConstants) -> tuple[bytes, G2Element, uint64]: ...

@final
class MerkleSet:
    def get_root(self) -> bytes32: ...
    def is_included_already_hashed(self, included_leaf: bytes32) -> tuple[bool, bytes]: ...
    def __init__(
        self,
        leafs: list[bytes32],
    ) -> None: ...

@final
class PlotSize:
    @staticmethod
    def make_v1(s: int) -> PlotSize: ...
    @staticmethod
    def make_v2(s: int) -> PlotSize: ...

    size_v1: Optional[uint8]
    size_v2: Optional[uint8]

@final
class G1Element:
    SIZE: ClassVar[int] = ...
    def __new__(cls) -> G1Element: ...
    def get_fingerprint(self) -> int: ...
    def verify(self, signature: G2Element, msg: bytes) -> bool: ...
    def pair(self, other: G2Element) -> GTElement: ...
    @staticmethod
    def generator() -> G1Element: ...
    def __str__(self) -> str: ...
    def __add__(self, other: G1Element) -> G1Element: ...
    def __iadd__(self, other: G1Element) -> G1Element: ...
    def derive_unhardened(self, idx: int) -> G1Element: ...
    def __init__(
        self
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> str: ...
    @classmethod
    def from_json_dict(cls, json_dict: Union[str, bytes]) -> Self: ...

@final
class G2Element:
    SIZE: ClassVar[int] = ...
    def __new__(cls) -> G2Element: ...
    def pair(self, other: G1Element) -> GTElement: ...
    @staticmethod
    def generator() -> G2Element: ...
    def __str__(self) -> str: ...
    def __add__(self, other: G2Element) -> G2Element: ...
    def __iadd__(self, other: G2Element) -> G2Element: ...
    def __init__(
        self
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> str: ...
    @classmethod
    def from_json_dict(cls, json_dict: Union[str, bytes]) -> Self: ...

@final
class GTElement:
    SIZE: ClassVar[int] = ...
    def __str__(self) -> str: ...
    def __mul__(self, rhs: GTElement) -> GTElement: ...
    def __imul__(self, rhs: GTElement) -> GTElement : ...
    def __init__(
        self
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> str: ...
    @classmethod
    def from_json_dict(cls, json_dict: str) -> Self: ...

@final
class PrivateKey:
    PRIVATE_KEY_SIZE: ClassVar[int] = ...
    def sign(self, msg: bytes, final_pk: Optional[G1Element] = None) -> G2Element: ...
    def get_g1(self) -> G1Element: ...
    def __str__(self) -> str: ...
    def public_key(self) -> G1Element: ...
    def derive_hardened(self, idx: int) -> PrivateKey: ...
    def derive_unhardened(self, idx: int) -> PrivateKey: ...
    @staticmethod
    def from_seed(seed: bytes) -> PrivateKey: ...
    def __init__(
        self
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> str: ...
    @classmethod
    def from_json_dict(cls, json_dict: str) -> Self: ...

@final
class SpendConditions:
    coin_id: bytes32
    parent_id: bytes32
    puzzle_hash: bytes32
    coin_amount: int
    height_relative: Optional[int]
    seconds_relative: Optional[int]
    before_height_relative: Optional[int]
    before_seconds_relative: Optional[int]
    birth_height: Optional[int]
    birth_seconds: Optional[int]
    create_coin: list[tuple[bytes32, int, Optional[bytes]]]
    agg_sig_me: list[tuple[G1Element, bytes]]
    agg_sig_parent: list[tuple[G1Element, bytes]]
    agg_sig_puzzle: list[tuple[G1Element, bytes]]
    agg_sig_amount: list[tuple[G1Element, bytes]]
    agg_sig_puzzle_amount: list[tuple[G1Element, bytes]]
    agg_sig_parent_amount: list[tuple[G1Element, bytes]]
    agg_sig_parent_puzzle: list[tuple[G1Element, bytes]]
    flags: int
    execution_cost: int
    condition_cost: int
    def __init__(
        self,
        coin_id: bytes,
        parent_id: bytes,
        puzzle_hash: bytes,
        coin_amount: int,
        height_relative: Optional[int],
        seconds_relative: Optional[int],
        before_height_relative: Optional[int],
        before_seconds_relative: Optional[int],
        birth_height: Optional[int],
        birth_seconds: Optional[int],
        create_coin: Sequence[tuple[bytes32, int, Optional[bytes]]],
        agg_sig_me: Sequence[tuple[G1Element, bytes]],
        agg_sig_parent: Sequence[tuple[G1Element, bytes]],
        agg_sig_puzzle: Sequence[tuple[G1Element, bytes]],
        agg_sig_amount: Sequence[tuple[G1Element, bytes]],
        agg_sig_puzzle_amount: Sequence[tuple[G1Element, bytes]],
        agg_sig_parent_amount: Sequence[tuple[G1Element, bytes]],
        agg_sig_parent_puzzle: Sequence[tuple[G1Element, bytes]],
        flags: int,
        execution_cost: int,
        condition_cost: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_id: Union[ bytes32, _Unspec] = _Unspec(),
        parent_id: Union[ bytes32, _Unspec] = _Unspec(),
        puzzle_hash: Union[ bytes32, _Unspec] = _Unspec(),
        coin_amount: Union[ int, _Unspec] = _Unspec(),
        height_relative: Union[ Optional[int], _Unspec] = _Unspec(),
        seconds_relative: Union[ Optional[int], _Unspec] = _Unspec(),
        before_height_relative: Union[ Optional[int], _Unspec] = _Unspec(),
        before_seconds_relative: Union[ Optional[int], _Unspec] = _Unspec(),
        birth_height: Union[ Optional[int], _Unspec] = _Unspec(),
        birth_seconds: Union[ Optional[int], _Unspec] = _Unspec(),
        create_coin: Union[ list[tuple[bytes32, int, Optional[bytes]]], _Unspec] = _Unspec(),
        agg_sig_me: Union[ list[tuple[G1Element, bytes]], _Unspec] = _Unspec(),
        agg_sig_parent: Union[ list[tuple[G1Element, bytes]], _Unspec] = _Unspec(),
        agg_sig_puzzle: Union[ list[tuple[G1Element, bytes]], _Unspec] = _Unspec(),
        agg_sig_amount: Union[ list[tuple[G1Element, bytes]], _Unspec] = _Unspec(),
        agg_sig_puzzle_amount: Union[ list[tuple[G1Element, bytes]], _Unspec] = _Unspec(),
        agg_sig_parent_amount: Union[ list[tuple[G1Element, bytes]], _Unspec] = _Unspec(),
        agg_sig_parent_puzzle: Union[ list[tuple[G1Element, bytes]], _Unspec] = _Unspec(),
        flags: Union[ int, _Unspec] = _Unspec(),
        execution_cost: Union[ int, _Unspec] = _Unspec(),
        condition_cost: Union[ int, _Unspec] = _Unspec()) -> SpendConditions: ...

@final
class SpendBundleConditions:
    spends: list[SpendConditions]
    reserve_fee: int
    height_absolute: int
    seconds_absolute: int
    before_height_absolute: Optional[int]
    before_seconds_absolute: Optional[int]
    agg_sig_unsafe: list[tuple[G1Element, bytes]]
    cost: int
    removal_amount: int
    addition_amount: int
    validated_signature: bool
    execution_cost: int
    condition_cost: int
    def __init__(
        self,
        spends: Sequence[SpendConditions],
        reserve_fee: int,
        height_absolute: int,
        seconds_absolute: int,
        before_height_absolute: Optional[int],
        before_seconds_absolute: Optional[int],
        agg_sig_unsafe: Sequence[tuple[G1Element, bytes]],
        cost: int,
        removal_amount: int,
        addition_amount: int,
        validated_signature: bool,
        execution_cost: int,
        condition_cost: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, spends: Union[ list[SpendConditions], _Unspec] = _Unspec(),
        reserve_fee: Union[ int, _Unspec] = _Unspec(),
        height_absolute: Union[ int, _Unspec] = _Unspec(),
        seconds_absolute: Union[ int, _Unspec] = _Unspec(),
        before_height_absolute: Union[ Optional[int], _Unspec] = _Unspec(),
        before_seconds_absolute: Union[ Optional[int], _Unspec] = _Unspec(),
        agg_sig_unsafe: Union[ list[tuple[G1Element, bytes]], _Unspec] = _Unspec(),
        cost: Union[ int, _Unspec] = _Unspec(),
        removal_amount: Union[ int, _Unspec] = _Unspec(),
        addition_amount: Union[ int, _Unspec] = _Unspec(),
        validated_signature: Union[ bool, _Unspec] = _Unspec(),
        execution_cost: Union[ int, _Unspec] = _Unspec(),
        condition_cost: Union[ int, _Unspec] = _Unspec()) -> SpendBundleConditions: ...

@final
class BlockRecord:
    header_hash: bytes32
    prev_hash: bytes32
    height: uint32
    weight: uint128
    total_iters: uint128
    signage_point_index: uint8
    challenge_vdf_output: ClassgroupElement
    infused_challenge_vdf_output: Optional[ClassgroupElement]
    reward_infusion_new_challenge: bytes32
    challenge_block_info_hash: bytes32
    sub_slot_iters: uint64
    pool_puzzle_hash: bytes32
    farmer_puzzle_hash: bytes32
    required_iters: uint64
    deficit: uint8
    overflow: bool
    prev_transaction_block_height: uint32
    timestamp: Optional[uint64]
    prev_transaction_block_hash: Optional[bytes32]
    fees: Optional[uint64]
    reward_claims_incorporated: Optional[list[Coin]]
    finished_challenge_slot_hashes: Optional[list[bytes32]]
    finished_infused_challenge_slot_hashes: Optional[list[bytes32]]
    finished_reward_slot_hashes: Optional[list[bytes32]]
    sub_epoch_summary_included: Optional[SubEpochSummary]
    is_transaction_block: bool
    first_in_sub_slot: bool
    def is_challenge_block(self, constants: ConsensusConstants) -> bool: ...
    def ip_sub_slot_total_iters(self, constants: ConsensusConstants) -> uint128: ...
    def sp_iters(self, constants: ConsensusConstants) -> uint64: ...
    def ip_iters(self, constants: ConsensusConstants) -> uint64: ...
    def sp_sub_slot_total_iters(self, constants: ConsensusConstants) -> uint128: ...
    def sp_total_iters(self, constants: ConsensusConstants) -> uint128: ...
    def __init__(
        self,
        header_hash: bytes,
        prev_hash: bytes,
        height: uint32,
        weight: uint128,
        total_iters: uint128,
        signage_point_index: uint8,
        challenge_vdf_output: ClassgroupElement,
        infused_challenge_vdf_output: Optional[ClassgroupElement],
        reward_infusion_new_challenge: bytes,
        challenge_block_info_hash: bytes,
        sub_slot_iters: uint64,
        pool_puzzle_hash: bytes,
        farmer_puzzle_hash: bytes,
        required_iters: uint64,
        deficit: uint8,
        overflow: bool,
        prev_transaction_block_height: uint32,
        timestamp: Optional[uint64],
        prev_transaction_block_hash: Optional[bytes32],
        fees: Optional[uint64],
        reward_claims_incorporated: Optional[Sequence[Coin]],
        finished_challenge_slot_hashes: Optional[Sequence[bytes32]],
        finished_infused_challenge_slot_hashes: Optional[Sequence[bytes32]],
        finished_reward_slot_hashes: Optional[Sequence[bytes32]],
        sub_epoch_summary_included: Optional[SubEpochSummary]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        prev_hash: Union[ bytes32, _Unspec] = _Unspec(),
        height: Union[ uint32, _Unspec] = _Unspec(),
        weight: Union[ uint128, _Unspec] = _Unspec(),
        total_iters: Union[ uint128, _Unspec] = _Unspec(),
        signage_point_index: Union[ uint8, _Unspec] = _Unspec(),
        challenge_vdf_output: Union[ ClassgroupElement, _Unspec] = _Unspec(),
        infused_challenge_vdf_output: Union[ Optional[ClassgroupElement], _Unspec] = _Unspec(),
        reward_infusion_new_challenge: Union[ bytes32, _Unspec] = _Unspec(),
        challenge_block_info_hash: Union[ bytes32, _Unspec] = _Unspec(),
        sub_slot_iters: Union[ uint64, _Unspec] = _Unspec(),
        pool_puzzle_hash: Union[ bytes32, _Unspec] = _Unspec(),
        farmer_puzzle_hash: Union[ bytes32, _Unspec] = _Unspec(),
        required_iters: Union[ uint64, _Unspec] = _Unspec(),
        deficit: Union[ uint8, _Unspec] = _Unspec(),
        overflow: Union[ bool, _Unspec] = _Unspec(),
        prev_transaction_block_height: Union[ uint32, _Unspec] = _Unspec(),
        timestamp: Union[ Optional[uint64], _Unspec] = _Unspec(),
        prev_transaction_block_hash: Union[ Optional[bytes32], _Unspec] = _Unspec(),
        fees: Union[ Optional[uint64], _Unspec] = _Unspec(),
        reward_claims_incorporated: Union[ Optional[list[Coin]], _Unspec] = _Unspec(),
        finished_challenge_slot_hashes: Union[ Optional[list[bytes32]], _Unspec] = _Unspec(),
        finished_infused_challenge_slot_hashes: Union[ Optional[list[bytes32]], _Unspec] = _Unspec(),
        finished_reward_slot_hashes: Union[ Optional[list[bytes32]], _Unspec] = _Unspec(),
        sub_epoch_summary_included: Union[ Optional[SubEpochSummary], _Unspec] = _Unspec()) -> BlockRecord: ...

@final
class Message:
    msg_type: int
    id: Optional[uint16]
    data: bytes
    def __init__(
        self,
        msg_type: int,
        id: Optional[uint16],
        data: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, msg_type: Union[ int, _Unspec] = _Unspec(),
        id: Union[ Optional[uint16], _Unspec] = _Unspec(),
        data: Union[ bytes, _Unspec] = _Unspec()) -> Message: ...

@final
class Handshake:
    network_id: str
    protocol_version: str
    software_version: str
    server_port: uint16
    node_type: int
    capabilities: list[tuple[uint16, str]]
    def __init__(
        self,
        network_id: str,
        protocol_version: str,
        software_version: str,
        server_port: uint16,
        node_type: int,
        capabilities: Sequence[tuple[uint16, str]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, network_id: Union[ str, _Unspec] = _Unspec(),
        protocol_version: Union[ str, _Unspec] = _Unspec(),
        software_version: Union[ str, _Unspec] = _Unspec(),
        server_port: Union[ uint16, _Unspec] = _Unspec(),
        node_type: Union[ int, _Unspec] = _Unspec(),
        capabilities: Union[ list[tuple[uint16, str]], _Unspec] = _Unspec()) -> Handshake: ...

@final
class ClassgroupElement:
    data: bytes100
    @staticmethod
    def create(bytes) -> ClassgroupElement: ...
    @staticmethod
    def get_default_element() -> ClassgroupElement: ...
    @staticmethod
    def get_size() -> int: ...
    def __init__(
        self,
        data: bytes100
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, data: Union[ bytes100, _Unspec] = _Unspec()) -> ClassgroupElement: ...

@final
class Coin:
    parent_coin_info: bytes32
    puzzle_hash: bytes32
    amount: uint64
    def name(self) -> bytes32: ...
    def __init__(
        self,
        parent_coin_info: bytes,
        puzzle_hash: bytes,
        amount: uint64
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, parent_coin_info: Union[ bytes32, _Unspec] = _Unspec(),
        puzzle_hash: Union[ bytes32, _Unspec] = _Unspec(),
        amount: Union[ uint64, _Unspec] = _Unspec()) -> Coin: ...

@final
class CoinSpend:
    coin: Coin
    puzzle_reveal: Program
    solution: Program
    def __init__(
        self,
        coin: Coin,
        puzzle_reveal: Program,
        solution: Program
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin: Union[ Coin, _Unspec] = _Unspec(),
        puzzle_reveal: Union[ Program, _Unspec] = _Unspec(),
        solution: Union[ Program, _Unspec] = _Unspec()) -> CoinSpend: ...

@final
class CoinState:
    coin: Coin
    spent_height: Optional[uint32]
    created_height: Optional[uint32]
    def __init__(
        self,
        coin: Coin,
        spent_height: Optional[uint32],
        created_height: Optional[uint32]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin: Union[ Coin, _Unspec] = _Unspec(),
        spent_height: Union[ Optional[uint32], _Unspec] = _Unspec(),
        created_height: Union[ Optional[uint32], _Unspec] = _Unspec()) -> CoinState: ...

@final
class EndOfSubSlotBundle:
    challenge_chain: ChallengeChainSubSlot
    infused_challenge_chain: Optional[InfusedChallengeChainSubSlot]
    reward_chain: RewardChainSubSlot
    proofs: SubSlotProofs
    def __init__(
        self,
        challenge_chain: ChallengeChainSubSlot,
        infused_challenge_chain: Optional[InfusedChallengeChainSubSlot],
        reward_chain: RewardChainSubSlot,
        proofs: SubSlotProofs
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, challenge_chain: Union[ ChallengeChainSubSlot, _Unspec] = _Unspec(),
        infused_challenge_chain: Union[ Optional[InfusedChallengeChainSubSlot], _Unspec] = _Unspec(),
        reward_chain: Union[ RewardChainSubSlot, _Unspec] = _Unspec(),
        proofs: Union[ SubSlotProofs, _Unspec] = _Unspec()) -> EndOfSubSlotBundle: ...

@final
class FeeRate:
    mojos_per_clvm_cost: uint64
    def __init__(
        self,
        mojos_per_clvm_cost: uint64
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, mojos_per_clvm_cost: Union[ uint64, _Unspec] = _Unspec()) -> FeeRate: ...

@final
class FeeEstimate:
    error: Optional[str]
    time_target: uint64
    estimated_fee_rate: FeeRate
    def __init__(
        self,
        error: Optional[str],
        time_target: uint64,
        estimated_fee_rate: FeeRate
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, error: Union[ Optional[str], _Unspec] = _Unspec(),
        time_target: Union[ uint64, _Unspec] = _Unspec(),
        estimated_fee_rate: Union[ FeeRate, _Unspec] = _Unspec()) -> FeeEstimate: ...

@final
class FeeEstimateGroup:
    error: Optional[str]
    estimates: list[FeeEstimate]
    def __init__(
        self,
        error: Optional[str],
        estimates: Sequence[FeeEstimate]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, error: Union[ Optional[str], _Unspec] = _Unspec(),
        estimates: Union[ list[FeeEstimate], _Unspec] = _Unspec()) -> FeeEstimateGroup: ...

@final
class TransactionsInfo:
    generator_root: bytes32
    generator_refs_root: bytes32
    aggregated_signature: G2Element
    fees: uint64
    cost: uint64
    reward_claims_incorporated: list[Coin]
    def __init__(
        self,
        generator_root: bytes,
        generator_refs_root: bytes,
        aggregated_signature: G2Element,
        fees: uint64,
        cost: uint64,
        reward_claims_incorporated: Sequence[Coin]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, generator_root: Union[ bytes32, _Unspec] = _Unspec(),
        generator_refs_root: Union[ bytes32, _Unspec] = _Unspec(),
        aggregated_signature: Union[ G2Element, _Unspec] = _Unspec(),
        fees: Union[ uint64, _Unspec] = _Unspec(),
        cost: Union[ uint64, _Unspec] = _Unspec(),
        reward_claims_incorporated: Union[ list[Coin], _Unspec] = _Unspec()) -> TransactionsInfo: ...

@final
class FoliageTransactionBlock:
    prev_transaction_block_hash: bytes32
    timestamp: uint64
    filter_hash: bytes32
    additions_root: bytes32
    removals_root: bytes32
    transactions_info_hash: bytes32
    def __init__(
        self,
        prev_transaction_block_hash: bytes,
        timestamp: uint64,
        filter_hash: bytes,
        additions_root: bytes,
        removals_root: bytes,
        transactions_info_hash: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, prev_transaction_block_hash: Union[ bytes32, _Unspec] = _Unspec(),
        timestamp: Union[ uint64, _Unspec] = _Unspec(),
        filter_hash: Union[ bytes32, _Unspec] = _Unspec(),
        additions_root: Union[ bytes32, _Unspec] = _Unspec(),
        removals_root: Union[ bytes32, _Unspec] = _Unspec(),
        transactions_info_hash: Union[ bytes32, _Unspec] = _Unspec()) -> FoliageTransactionBlock: ...

@final
class FoliageBlockData:
    unfinished_reward_block_hash: bytes32
    pool_target: PoolTarget
    pool_signature: Optional[G2Element]
    farmer_reward_puzzle_hash: bytes32
    extension_data: bytes32
    def __init__(
        self,
        unfinished_reward_block_hash: bytes,
        pool_target: PoolTarget,
        pool_signature: Optional[G2Element],
        farmer_reward_puzzle_hash: bytes,
        extension_data: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, unfinished_reward_block_hash: Union[ bytes32, _Unspec] = _Unspec(),
        pool_target: Union[ PoolTarget, _Unspec] = _Unspec(),
        pool_signature: Union[ Optional[G2Element], _Unspec] = _Unspec(),
        farmer_reward_puzzle_hash: Union[ bytes32, _Unspec] = _Unspec(),
        extension_data: Union[ bytes32, _Unspec] = _Unspec()) -> FoliageBlockData: ...

@final
class Foliage:
    prev_block_hash: bytes32
    reward_block_hash: bytes32
    foliage_block_data: FoliageBlockData
    foliage_block_data_signature: G2Element
    foliage_transaction_block_hash: Optional[bytes32]
    foliage_transaction_block_signature: Optional[G2Element]
    def __init__(
        self,
        prev_block_hash: bytes,
        reward_block_hash: bytes,
        foliage_block_data: FoliageBlockData,
        foliage_block_data_signature: G2Element,
        foliage_transaction_block_hash: Optional[bytes32],
        foliage_transaction_block_signature: Optional[G2Element]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, prev_block_hash: Union[ bytes32, _Unspec] = _Unspec(),
        reward_block_hash: Union[ bytes32, _Unspec] = _Unspec(),
        foliage_block_data: Union[ FoliageBlockData, _Unspec] = _Unspec(),
        foliage_block_data_signature: Union[ G2Element, _Unspec] = _Unspec(),
        foliage_transaction_block_hash: Union[ Optional[bytes32], _Unspec] = _Unspec(),
        foliage_transaction_block_signature: Union[ Optional[G2Element], _Unspec] = _Unspec()) -> Foliage: ...

@final
class NewPeak:
    header_hash: bytes32
    height: uint32
    weight: uint128
    fork_point_with_previous_peak: uint32
    unfinished_reward_block_hash: bytes32
    def __init__(
        self,
        header_hash: bytes,
        height: uint32,
        weight: uint128,
        fork_point_with_previous_peak: uint32,
        unfinished_reward_block_hash: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        height: Union[ uint32, _Unspec] = _Unspec(),
        weight: Union[ uint128, _Unspec] = _Unspec(),
        fork_point_with_previous_peak: Union[ uint32, _Unspec] = _Unspec(),
        unfinished_reward_block_hash: Union[ bytes32, _Unspec] = _Unspec()) -> NewPeak: ...

@final
class NewTransaction:
    transaction_id: bytes32
    cost: uint64
    fees: uint64
    def __init__(
        self,
        transaction_id: bytes,
        cost: uint64,
        fees: uint64
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, transaction_id: Union[ bytes32, _Unspec] = _Unspec(),
        cost: Union[ uint64, _Unspec] = _Unspec(),
        fees: Union[ uint64, _Unspec] = _Unspec()) -> NewTransaction: ...

@final
class RequestTransaction:
    transaction_id: bytes32
    def __init__(
        self,
        transaction_id: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, transaction_id: Union[ bytes32, _Unspec] = _Unspec()) -> RequestTransaction: ...

@final
class RespondTransaction:
    transaction: SpendBundle
    def __init__(
        self,
        transaction: SpendBundle
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, transaction: Union[ SpendBundle, _Unspec] = _Unspec()) -> RespondTransaction: ...

@final
class RequestProofOfWeight:
    total_number_of_blocks: uint32
    tip: bytes32
    def __init__(
        self,
        total_number_of_blocks: uint32,
        tip: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, total_number_of_blocks: Union[ uint32, _Unspec] = _Unspec(),
        tip: Union[ bytes32, _Unspec] = _Unspec()) -> RequestProofOfWeight: ...

@final
class RespondProofOfWeight:
    wp: WeightProof
    tip: bytes32
    def __init__(
        self,
        wp: WeightProof,
        tip: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, wp: Union[ WeightProof, _Unspec] = _Unspec(),
        tip: Union[ bytes32, _Unspec] = _Unspec()) -> RespondProofOfWeight: ...

@final
class RequestBlock:
    height: uint32
    include_transaction_block: bool
    def __init__(
        self,
        height: uint32,
        include_transaction_block: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        include_transaction_block: Union[ bool, _Unspec] = _Unspec()) -> RequestBlock: ...

@final
class RejectBlock:
    height: uint32
    def __init__(
        self,
        height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec()) -> RejectBlock: ...

@final
class RequestBlocks:
    start_height: uint32
    end_height: uint32
    include_transaction_block: bool
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32,
        include_transaction_block: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec(),
        include_transaction_block: Union[ bool, _Unspec] = _Unspec()) -> RequestBlocks: ...

@final
class RespondBlocks:
    start_height: uint32
    end_height: uint32
    blocks: list[FullBlock]
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32,
        blocks: Sequence[FullBlock]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec(),
        blocks: Union[ list[FullBlock], _Unspec] = _Unspec()) -> RespondBlocks: ...

@final
class RejectBlocks:
    start_height: uint32
    end_height: uint32
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec()) -> RejectBlocks: ...

@final
class RespondBlock:
    block: FullBlock
    def __init__(
        self,
        block: FullBlock
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, block: Union[ FullBlock, _Unspec] = _Unspec()) -> RespondBlock: ...

@final
class NewUnfinishedBlock:
    unfinished_reward_hash: bytes32
    def __init__(
        self,
        unfinished_reward_hash: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, unfinished_reward_hash: Union[ bytes32, _Unspec] = _Unspec()) -> NewUnfinishedBlock: ...

@final
class RequestUnfinishedBlock:
    unfinished_reward_hash: bytes32
    def __init__(
        self,
        unfinished_reward_hash: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, unfinished_reward_hash: Union[ bytes32, _Unspec] = _Unspec()) -> RequestUnfinishedBlock: ...

@final
class RespondUnfinishedBlock:
    unfinished_block: UnfinishedBlock
    def __init__(
        self,
        unfinished_block: UnfinishedBlock
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, unfinished_block: Union[ UnfinishedBlock, _Unspec] = _Unspec()) -> RespondUnfinishedBlock: ...

@final
class NewSignagePointOrEndOfSubSlot:
    prev_challenge_hash: Optional[bytes32]
    challenge_hash: bytes32
    index_from_challenge: uint8
    last_rc_infusion: bytes32
    def __init__(
        self,
        prev_challenge_hash: Optional[bytes32],
        challenge_hash: bytes,
        index_from_challenge: uint8,
        last_rc_infusion: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, prev_challenge_hash: Union[ Optional[bytes32], _Unspec] = _Unspec(),
        challenge_hash: Union[ bytes32, _Unspec] = _Unspec(),
        index_from_challenge: Union[ uint8, _Unspec] = _Unspec(),
        last_rc_infusion: Union[ bytes32, _Unspec] = _Unspec()) -> NewSignagePointOrEndOfSubSlot: ...

@final
class RequestSignagePointOrEndOfSubSlot:
    challenge_hash: bytes32
    index_from_challenge: uint8
    last_rc_infusion: bytes32
    def __init__(
        self,
        challenge_hash: bytes,
        index_from_challenge: uint8,
        last_rc_infusion: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, challenge_hash: Union[ bytes32, _Unspec] = _Unspec(),
        index_from_challenge: Union[ uint8, _Unspec] = _Unspec(),
        last_rc_infusion: Union[ bytes32, _Unspec] = _Unspec()) -> RequestSignagePointOrEndOfSubSlot: ...

@final
class RespondSignagePoint:
    index_from_challenge: uint8
    challenge_chain_vdf: VDFInfo
    challenge_chain_proof: VDFProof
    reward_chain_vdf: VDFInfo
    reward_chain_proof: VDFProof
    def __init__(
        self,
        index_from_challenge: uint8,
        challenge_chain_vdf: VDFInfo,
        challenge_chain_proof: VDFProof,
        reward_chain_vdf: VDFInfo,
        reward_chain_proof: VDFProof
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, index_from_challenge: Union[ uint8, _Unspec] = _Unspec(),
        challenge_chain_vdf: Union[ VDFInfo, _Unspec] = _Unspec(),
        challenge_chain_proof: Union[ VDFProof, _Unspec] = _Unspec(),
        reward_chain_vdf: Union[ VDFInfo, _Unspec] = _Unspec(),
        reward_chain_proof: Union[ VDFProof, _Unspec] = _Unspec()) -> RespondSignagePoint: ...

@final
class RespondEndOfSubSlot:
    end_of_slot_bundle: EndOfSubSlotBundle
    def __init__(
        self,
        end_of_slot_bundle: EndOfSubSlotBundle
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, end_of_slot_bundle: Union[ EndOfSubSlotBundle, _Unspec] = _Unspec()) -> RespondEndOfSubSlot: ...

@final
class RequestMempoolTransactions:
    filter: bytes
    def __init__(
        self,
        filter: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, filter: Union[ bytes, _Unspec] = _Unspec()) -> RequestMempoolTransactions: ...

@final
class NewCompactVDF:
    height: uint32
    header_hash: bytes32
    field_vdf: uint8
    vdf_info: VDFInfo
    def __init__(
        self,
        height: uint32,
        header_hash: bytes,
        field_vdf: uint8,
        vdf_info: VDFInfo
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        field_vdf: Union[ uint8, _Unspec] = _Unspec(),
        vdf_info: Union[ VDFInfo, _Unspec] = _Unspec()) -> NewCompactVDF: ...

@final
class RequestCompactVDF:
    height: uint32
    header_hash: bytes32
    field_vdf: uint8
    vdf_info: VDFInfo
    def __init__(
        self,
        height: uint32,
        header_hash: bytes,
        field_vdf: uint8,
        vdf_info: VDFInfo
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        field_vdf: Union[ uint8, _Unspec] = _Unspec(),
        vdf_info: Union[ VDFInfo, _Unspec] = _Unspec()) -> RequestCompactVDF: ...

@final
class RespondCompactVDF:
    height: uint32
    header_hash: bytes32
    field_vdf: uint8
    vdf_info: VDFInfo
    vdf_proof: VDFProof
    def __init__(
        self,
        height: uint32,
        header_hash: bytes,
        field_vdf: uint8,
        vdf_info: VDFInfo,
        vdf_proof: VDFProof
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        field_vdf: Union[ uint8, _Unspec] = _Unspec(),
        vdf_info: Union[ VDFInfo, _Unspec] = _Unspec(),
        vdf_proof: Union[ VDFProof, _Unspec] = _Unspec()) -> RespondCompactVDF: ...

@final
class RequestPeers:
    def __init__(
        self
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...

@final
class RespondPeers:
    peer_list: list[TimestampedPeerInfo]
    def __init__(
        self,
        peer_list: Sequence[TimestampedPeerInfo]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, peer_list: Union[ list[TimestampedPeerInfo], _Unspec] = _Unspec()) -> RespondPeers: ...

@final
class NewUnfinishedBlock2:
    unfinished_reward_hash: bytes32
    foliage_hash: Optional[bytes32]
    def __init__(
        self,
        unfinished_reward_hash: bytes,
        foliage_hash: Optional[bytes32]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, unfinished_reward_hash: Union[ bytes32, _Unspec] = _Unspec(),
        foliage_hash: Union[ Optional[bytes32], _Unspec] = _Unspec()) -> NewUnfinishedBlock2: ...

@final
class RequestUnfinishedBlock2:
    unfinished_reward_hash: bytes32
    foliage_hash: Optional[bytes32]
    def __init__(
        self,
        unfinished_reward_hash: bytes,
        foliage_hash: Optional[bytes32]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, unfinished_reward_hash: Union[ bytes32, _Unspec] = _Unspec(),
        foliage_hash: Union[ Optional[bytes32], _Unspec] = _Unspec()) -> RequestUnfinishedBlock2: ...

@final
class FullBlock:
    finished_sub_slots: list[EndOfSubSlotBundle]
    reward_chain_block: RewardChainBlock
    challenge_chain_sp_proof: Optional[VDFProof]
    challenge_chain_ip_proof: VDFProof
    reward_chain_sp_proof: Optional[VDFProof]
    reward_chain_ip_proof: VDFProof
    infused_challenge_chain_ip_proof: Optional[VDFProof]
    foliage: Foliage
    foliage_transaction_block: Optional[FoliageTransactionBlock]
    transactions_info: Optional[TransactionsInfo]
    transactions_generator: Optional[Program]
    transactions_generator_ref_list: list[uint32]
    prev_header_hash: bytes32
    header_hash: bytes32
    def is_transaction_block(self) -> bool: ...
    total_iters: uint128
    height: uint32
    weight: uint128
    def get_included_reward_coins(self) -> list[Coin]: ...
    def is_fully_compactified(self) -> bool: ...
    def __init__(
        self,
        finished_sub_slots: Sequence[EndOfSubSlotBundle],
        reward_chain_block: RewardChainBlock,
        challenge_chain_sp_proof: Optional[VDFProof],
        challenge_chain_ip_proof: VDFProof,
        reward_chain_sp_proof: Optional[VDFProof],
        reward_chain_ip_proof: VDFProof,
        infused_challenge_chain_ip_proof: Optional[VDFProof],
        foliage: Foliage,
        foliage_transaction_block: Optional[FoliageTransactionBlock],
        transactions_info: Optional[TransactionsInfo],
        transactions_generator: Optional[Program],
        transactions_generator_ref_list: Sequence[uint32]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, finished_sub_slots: Union[ list[EndOfSubSlotBundle], _Unspec] = _Unspec(),
        reward_chain_block: Union[ RewardChainBlock, _Unspec] = _Unspec(),
        challenge_chain_sp_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        challenge_chain_ip_proof: Union[ VDFProof, _Unspec] = _Unspec(),
        reward_chain_sp_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        reward_chain_ip_proof: Union[ VDFProof, _Unspec] = _Unspec(),
        infused_challenge_chain_ip_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        foliage: Union[ Foliage, _Unspec] = _Unspec(),
        foliage_transaction_block: Union[ Optional[FoliageTransactionBlock], _Unspec] = _Unspec(),
        transactions_info: Union[ Optional[TransactionsInfo], _Unspec] = _Unspec(),
        transactions_generator: Union[ Optional[Program], _Unspec] = _Unspec(),
        transactions_generator_ref_list: Union[ list[uint32], _Unspec] = _Unspec()) -> FullBlock: ...

@final
class HeaderBlock:
    finished_sub_slots: list[EndOfSubSlotBundle]
    reward_chain_block: RewardChainBlock
    challenge_chain_sp_proof: Optional[VDFProof]
    challenge_chain_ip_proof: VDFProof
    reward_chain_sp_proof: Optional[VDFProof]
    reward_chain_ip_proof: VDFProof
    infused_challenge_chain_ip_proof: Optional[VDFProof]
    foliage: Foliage
    foliage_transaction_block: Optional[FoliageTransactionBlock]
    transactions_filter: bytes
    transactions_info: Optional[TransactionsInfo]
    prev_header_hash: bytes32
    prev_hash: bytes32
    height: uint32
    weight: uint128
    header_hash: bytes32
    total_iters: uint128
    log_string: str
    is_transaction_block: bool
    first_in_sub_slot: bool
    def __init__(
        self,
        finished_sub_slots: Sequence[EndOfSubSlotBundle],
        reward_chain_block: RewardChainBlock,
        challenge_chain_sp_proof: Optional[VDFProof],
        challenge_chain_ip_proof: VDFProof,
        reward_chain_sp_proof: Optional[VDFProof],
        reward_chain_ip_proof: VDFProof,
        infused_challenge_chain_ip_proof: Optional[VDFProof],
        foliage: Foliage,
        foliage_transaction_block: Optional[FoliageTransactionBlock],
        transactions_filter: bytes,
        transactions_info: Optional[TransactionsInfo]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, finished_sub_slots: Union[ list[EndOfSubSlotBundle], _Unspec] = _Unspec(),
        reward_chain_block: Union[ RewardChainBlock, _Unspec] = _Unspec(),
        challenge_chain_sp_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        challenge_chain_ip_proof: Union[ VDFProof, _Unspec] = _Unspec(),
        reward_chain_sp_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        reward_chain_ip_proof: Union[ VDFProof, _Unspec] = _Unspec(),
        infused_challenge_chain_ip_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        foliage: Union[ Foliage, _Unspec] = _Unspec(),
        foliage_transaction_block: Union[ Optional[FoliageTransactionBlock], _Unspec] = _Unspec(),
        transactions_filter: Union[ bytes, _Unspec] = _Unspec(),
        transactions_info: Union[ Optional[TransactionsInfo], _Unspec] = _Unspec()) -> HeaderBlock: ...

@final
class TimestampedPeerInfo:
    host: str
    port: uint16
    timestamp: uint64
    def __init__(
        self,
        host: str,
        port: uint16,
        timestamp: uint64
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, host: Union[ str, _Unspec] = _Unspec(),
        port: Union[ uint16, _Unspec] = _Unspec(),
        timestamp: Union[ uint64, _Unspec] = _Unspec()) -> TimestampedPeerInfo: ...

@final
class PoolTarget:
    puzzle_hash: bytes32
    max_height: uint32
    def __init__(
        self,
        puzzle_hash: bytes,
        max_height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, puzzle_hash: Union[ bytes32, _Unspec] = _Unspec(),
        max_height: Union[ uint32, _Unspec] = _Unspec()) -> PoolTarget: ...


class Program:
    a0: bytes
    def get_tree_hash(self) -> bytes32: ...
    @staticmethod
    def default() -> Program: ...
    @staticmethod
    def fromhex(h: str) -> Program: ...
    @staticmethod
    def to(o: object) -> Program: ...
    def run_rust(self, max_cost: int, flags: int, args: object) -> tuple[int, LazyNode]: ...
    def uncurry_rust(self) -> tuple[LazyNode, LazyNode]: ...
    def __init__(
        self,
        a0: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> str: ...
    @classmethod
    def from_json_dict(cls, json_dict: str) -> Self: ...

@final
class ProofOfSpace:
    challenge: bytes32
    pool_public_key: Optional[G1Element]
    pool_contract_puzzle_hash: Optional[bytes32]
    plot_public_key: G1Element
    version_and_size: uint8
    proof: bytes
    def size(self) -> PlotSize: ...
    def __init__(
        self,
        challenge: bytes,
        pool_public_key: Optional[G1Element],
        pool_contract_puzzle_hash: Optional[bytes32],
        plot_public_key: G1Element,
        version_and_size: uint8,
        proof: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, challenge: Union[ bytes32, _Unspec] = _Unspec(),
        pool_public_key: Union[ Optional[G1Element], _Unspec] = _Unspec(),
        pool_contract_puzzle_hash: Union[ Optional[bytes32], _Unspec] = _Unspec(),
        plot_public_key: Union[ G1Element, _Unspec] = _Unspec(),
        version_and_size: Union[ uint8, _Unspec] = _Unspec(),
        proof: Union[ bytes, _Unspec] = _Unspec()) -> ProofOfSpace: ...

@final
class RewardChainBlockUnfinished:
    total_iters: uint128
    signage_point_index: uint8
    pos_ss_cc_challenge_hash: bytes32
    proof_of_space: ProofOfSpace
    challenge_chain_sp_vdf: Optional[VDFInfo]
    challenge_chain_sp_signature: G2Element
    reward_chain_sp_vdf: Optional[VDFInfo]
    reward_chain_sp_signature: G2Element
    def __init__(
        self,
        total_iters: uint128,
        signage_point_index: uint8,
        pos_ss_cc_challenge_hash: bytes,
        proof_of_space: ProofOfSpace,
        challenge_chain_sp_vdf: Optional[VDFInfo],
        challenge_chain_sp_signature: G2Element,
        reward_chain_sp_vdf: Optional[VDFInfo],
        reward_chain_sp_signature: G2Element
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, total_iters: Union[ uint128, _Unspec] = _Unspec(),
        signage_point_index: Union[ uint8, _Unspec] = _Unspec(),
        pos_ss_cc_challenge_hash: Union[ bytes32, _Unspec] = _Unspec(),
        proof_of_space: Union[ ProofOfSpace, _Unspec] = _Unspec(),
        challenge_chain_sp_vdf: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        challenge_chain_sp_signature: Union[ G2Element, _Unspec] = _Unspec(),
        reward_chain_sp_vdf: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        reward_chain_sp_signature: Union[ G2Element, _Unspec] = _Unspec()) -> RewardChainBlockUnfinished: ...

@final
class RewardChainBlock:
    weight: uint128
    height: uint32
    total_iters: uint128
    signage_point_index: uint8
    pos_ss_cc_challenge_hash: bytes32
    proof_of_space: ProofOfSpace
    challenge_chain_sp_vdf: Optional[VDFInfo]
    challenge_chain_sp_signature: G2Element
    challenge_chain_ip_vdf: VDFInfo
    reward_chain_sp_vdf: Optional[VDFInfo]
    reward_chain_sp_signature: G2Element
    reward_chain_ip_vdf: VDFInfo
    infused_challenge_chain_ip_vdf: Optional[VDFInfo]
    is_transaction_block: bool
    def get_unfinished(self) -> RewardChainBlockUnfinished: ...
    def __init__(
        self,
        weight: uint128,
        height: uint32,
        total_iters: uint128,
        signage_point_index: uint8,
        pos_ss_cc_challenge_hash: bytes,
        proof_of_space: ProofOfSpace,
        challenge_chain_sp_vdf: Optional[VDFInfo],
        challenge_chain_sp_signature: G2Element,
        challenge_chain_ip_vdf: VDFInfo,
        reward_chain_sp_vdf: Optional[VDFInfo],
        reward_chain_sp_signature: G2Element,
        reward_chain_ip_vdf: VDFInfo,
        infused_challenge_chain_ip_vdf: Optional[VDFInfo],
        is_transaction_block: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, weight: Union[ uint128, _Unspec] = _Unspec(),
        height: Union[ uint32, _Unspec] = _Unspec(),
        total_iters: Union[ uint128, _Unspec] = _Unspec(),
        signage_point_index: Union[ uint8, _Unspec] = _Unspec(),
        pos_ss_cc_challenge_hash: Union[ bytes32, _Unspec] = _Unspec(),
        proof_of_space: Union[ ProofOfSpace, _Unspec] = _Unspec(),
        challenge_chain_sp_vdf: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        challenge_chain_sp_signature: Union[ G2Element, _Unspec] = _Unspec(),
        challenge_chain_ip_vdf: Union[ VDFInfo, _Unspec] = _Unspec(),
        reward_chain_sp_vdf: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        reward_chain_sp_signature: Union[ G2Element, _Unspec] = _Unspec(),
        reward_chain_ip_vdf: Union[ VDFInfo, _Unspec] = _Unspec(),
        infused_challenge_chain_ip_vdf: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        is_transaction_block: Union[ bool, _Unspec] = _Unspec()) -> RewardChainBlock: ...

@final
class ChallengeBlockInfo:
    proof_of_space: ProofOfSpace
    challenge_chain_sp_vdf: Optional[VDFInfo]
    challenge_chain_sp_signature: G2Element
    challenge_chain_ip_vdf: VDFInfo
    def __init__(
        self,
        proof_of_space: ProofOfSpace,
        challenge_chain_sp_vdf: Optional[VDFInfo],
        challenge_chain_sp_signature: G2Element,
        challenge_chain_ip_vdf: VDFInfo
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, proof_of_space: Union[ ProofOfSpace, _Unspec] = _Unspec(),
        challenge_chain_sp_vdf: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        challenge_chain_sp_signature: Union[ G2Element, _Unspec] = _Unspec(),
        challenge_chain_ip_vdf: Union[ VDFInfo, _Unspec] = _Unspec()) -> ChallengeBlockInfo: ...

@final
class ChallengeChainSubSlot:
    challenge_chain_end_of_slot_vdf: VDFInfo
    infused_challenge_chain_sub_slot_hash: Optional[bytes32]
    subepoch_summary_hash: Optional[bytes32]
    new_sub_slot_iters: Optional[uint64]
    new_difficulty: Optional[uint64]
    def __init__(
        self,
        challenge_chain_end_of_slot_vdf: VDFInfo,
        infused_challenge_chain_sub_slot_hash: Optional[bytes32],
        subepoch_summary_hash: Optional[bytes32],
        new_sub_slot_iters: Optional[uint64],
        new_difficulty: Optional[uint64]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, challenge_chain_end_of_slot_vdf: Union[ VDFInfo, _Unspec] = _Unspec(),
        infused_challenge_chain_sub_slot_hash: Union[ Optional[bytes32], _Unspec] = _Unspec(),
        subepoch_summary_hash: Union[ Optional[bytes32], _Unspec] = _Unspec(),
        new_sub_slot_iters: Union[ Optional[uint64], _Unspec] = _Unspec(),
        new_difficulty: Union[ Optional[uint64], _Unspec] = _Unspec()) -> ChallengeChainSubSlot: ...

@final
class InfusedChallengeChainSubSlot:
    infused_challenge_chain_end_of_slot_vdf: VDFInfo
    def __init__(
        self,
        infused_challenge_chain_end_of_slot_vdf: VDFInfo
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, infused_challenge_chain_end_of_slot_vdf: Union[ VDFInfo, _Unspec] = _Unspec()) -> InfusedChallengeChainSubSlot: ...

@final
class RewardChainSubSlot:
    end_of_slot_vdf: VDFInfo
    challenge_chain_sub_slot_hash: bytes32
    infused_challenge_chain_sub_slot_hash: Optional[bytes32]
    deficit: uint8
    def __init__(
        self,
        end_of_slot_vdf: VDFInfo,
        challenge_chain_sub_slot_hash: bytes,
        infused_challenge_chain_sub_slot_hash: Optional[bytes32],
        deficit: uint8
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, end_of_slot_vdf: Union[ VDFInfo, _Unspec] = _Unspec(),
        challenge_chain_sub_slot_hash: Union[ bytes32, _Unspec] = _Unspec(),
        infused_challenge_chain_sub_slot_hash: Union[ Optional[bytes32], _Unspec] = _Unspec(),
        deficit: Union[ uint8, _Unspec] = _Unspec()) -> RewardChainSubSlot: ...

@final
class SubSlotProofs:
    challenge_chain_slot_proof: VDFProof
    infused_challenge_chain_slot_proof: Optional[VDFProof]
    reward_chain_slot_proof: VDFProof
    def __init__(
        self,
        challenge_chain_slot_proof: VDFProof,
        infused_challenge_chain_slot_proof: Optional[VDFProof],
        reward_chain_slot_proof: VDFProof
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, challenge_chain_slot_proof: Union[ VDFProof, _Unspec] = _Unspec(),
        infused_challenge_chain_slot_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        reward_chain_slot_proof: Union[ VDFProof, _Unspec] = _Unspec()) -> SubSlotProofs: ...


class SpendBundle:
    coin_spends: list[CoinSpend]
    aggregated_signature: G2Element
    @classmethod
    def aggregate(cls, spend_bundles: list[SpendBundle]) -> Self: ...
    def name(self) -> bytes32: ...
    def removals(self) -> list[Coin]: ...
    def additions(self) -> list[Coin]: ...
    def __init__(
        self,
        coin_spends: Sequence[CoinSpend],
        aggregated_signature: G2Element
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_spends: Union[ list[CoinSpend], _Unspec] = _Unspec(),
        aggregated_signature: Union[ G2Element, _Unspec] = _Unspec()) -> SpendBundle: ...

@final
class SubEpochSummary:
    prev_subepoch_summary_hash: bytes32
    reward_chain_hash: bytes32
    num_blocks_overflow: uint8
    new_difficulty: Optional[uint64]
    new_sub_slot_iters: Optional[uint64]
    def __init__(
        self,
        prev_subepoch_summary_hash: bytes,
        reward_chain_hash: bytes,
        num_blocks_overflow: uint8,
        new_difficulty: Optional[uint64],
        new_sub_slot_iters: Optional[uint64]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, prev_subepoch_summary_hash: Union[ bytes32, _Unspec] = _Unspec(),
        reward_chain_hash: Union[ bytes32, _Unspec] = _Unspec(),
        num_blocks_overflow: Union[ uint8, _Unspec] = _Unspec(),
        new_difficulty: Union[ Optional[uint64], _Unspec] = _Unspec(),
        new_sub_slot_iters: Union[ Optional[uint64], _Unspec] = _Unspec()) -> SubEpochSummary: ...

@final
class UnfinishedBlock:
    finished_sub_slots: list[EndOfSubSlotBundle]
    reward_chain_block: RewardChainBlockUnfinished
    challenge_chain_sp_proof: Optional[VDFProof]
    reward_chain_sp_proof: Optional[VDFProof]
    foliage: Foliage
    foliage_transaction_block: Optional[FoliageTransactionBlock]
    transactions_info: Optional[TransactionsInfo]
    transactions_generator: Optional[Program]
    transactions_generator_ref_list: list[uint32]
    prev_header_hash: bytes32
    partial_hash: bytes32
    def is_transaction_block(self) -> bool: ...
    total_iters: uint128
    def __init__(
        self,
        finished_sub_slots: Sequence[EndOfSubSlotBundle],
        reward_chain_block: RewardChainBlockUnfinished,
        challenge_chain_sp_proof: Optional[VDFProof],
        reward_chain_sp_proof: Optional[VDFProof],
        foliage: Foliage,
        foliage_transaction_block: Optional[FoliageTransactionBlock],
        transactions_info: Optional[TransactionsInfo],
        transactions_generator: Optional[Program],
        transactions_generator_ref_list: Sequence[uint32]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, finished_sub_slots: Union[ list[EndOfSubSlotBundle], _Unspec] = _Unspec(),
        reward_chain_block: Union[ RewardChainBlockUnfinished, _Unspec] = _Unspec(),
        challenge_chain_sp_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        reward_chain_sp_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        foliage: Union[ Foliage, _Unspec] = _Unspec(),
        foliage_transaction_block: Union[ Optional[FoliageTransactionBlock], _Unspec] = _Unspec(),
        transactions_info: Union[ Optional[TransactionsInfo], _Unspec] = _Unspec(),
        transactions_generator: Union[ Optional[Program], _Unspec] = _Unspec(),
        transactions_generator_ref_list: Union[ list[uint32], _Unspec] = _Unspec()) -> UnfinishedBlock: ...

@final
class UnfinishedHeaderBlock:
    finished_sub_slots: list[EndOfSubSlotBundle]
    reward_chain_block: RewardChainBlockUnfinished
    challenge_chain_sp_proof: Optional[VDFProof]
    reward_chain_sp_proof: Optional[VDFProof]
    foliage: Foliage
    foliage_transaction_block: Optional[FoliageTransactionBlock]
    transactions_filter: bytes
    prev_header_hash: bytes32
    header_hash: bytes32
    total_iters: uint128
    def __init__(
        self,
        finished_sub_slots: Sequence[EndOfSubSlotBundle],
        reward_chain_block: RewardChainBlockUnfinished,
        challenge_chain_sp_proof: Optional[VDFProof],
        reward_chain_sp_proof: Optional[VDFProof],
        foliage: Foliage,
        foliage_transaction_block: Optional[FoliageTransactionBlock],
        transactions_filter: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, finished_sub_slots: Union[ list[EndOfSubSlotBundle], _Unspec] = _Unspec(),
        reward_chain_block: Union[ RewardChainBlockUnfinished, _Unspec] = _Unspec(),
        challenge_chain_sp_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        reward_chain_sp_proof: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        foliage: Union[ Foliage, _Unspec] = _Unspec(),
        foliage_transaction_block: Union[ Optional[FoliageTransactionBlock], _Unspec] = _Unspec(),
        transactions_filter: Union[ bytes, _Unspec] = _Unspec()) -> UnfinishedHeaderBlock: ...

@final
class VDFInfo:
    challenge: bytes32
    number_of_iterations: uint64
    output: ClassgroupElement
    def __init__(
        self,
        challenge: bytes,
        number_of_iterations: uint64,
        output: ClassgroupElement
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, challenge: Union[ bytes32, _Unspec] = _Unspec(),
        number_of_iterations: Union[ uint64, _Unspec] = _Unspec(),
        output: Union[ ClassgroupElement, _Unspec] = _Unspec()) -> VDFInfo: ...

@final
class VDFProof:
    witness_type: uint8
    witness: bytes
    normalized_to_identity: bool
    def __init__(
        self,
        witness_type: uint8,
        witness: bytes,
        normalized_to_identity: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, witness_type: Union[ uint8, _Unspec] = _Unspec(),
        witness: Union[ bytes, _Unspec] = _Unspec(),
        normalized_to_identity: Union[ bool, _Unspec] = _Unspec()) -> VDFProof: ...

@final
class RequestPuzzleSolution:
    coin_name: bytes32
    height: uint32
    def __init__(
        self,
        coin_name: bytes,
        height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_name: Union[ bytes32, _Unspec] = _Unspec(),
        height: Union[ uint32, _Unspec] = _Unspec()) -> RequestPuzzleSolution: ...

@final
class PuzzleSolutionResponse:
    coin_name: bytes32
    height: uint32
    puzzle: Program
    solution: Program
    def __init__(
        self,
        coin_name: bytes,
        height: uint32,
        puzzle: Program,
        solution: Program
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_name: Union[ bytes32, _Unspec] = _Unspec(),
        height: Union[ uint32, _Unspec] = _Unspec(),
        puzzle: Union[ Program, _Unspec] = _Unspec(),
        solution: Union[ Program, _Unspec] = _Unspec()) -> PuzzleSolutionResponse: ...

@final
class RespondPuzzleSolution:
    response: PuzzleSolutionResponse
    def __init__(
        self,
        response: PuzzleSolutionResponse
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, response: Union[ PuzzleSolutionResponse, _Unspec] = _Unspec()) -> RespondPuzzleSolution: ...

@final
class RejectPuzzleSolution:
    coin_name: bytes32
    height: uint32
    def __init__(
        self,
        coin_name: bytes,
        height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_name: Union[ bytes32, _Unspec] = _Unspec(),
        height: Union[ uint32, _Unspec] = _Unspec()) -> RejectPuzzleSolution: ...

@final
class SendTransaction:
    transaction: SpendBundle
    def __init__(
        self,
        transaction: SpendBundle
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, transaction: Union[ SpendBundle, _Unspec] = _Unspec()) -> SendTransaction: ...

@final
class TransactionAck:
    txid: bytes32
    status: uint8
    error: Optional[str]
    def __init__(
        self,
        txid: bytes,
        status: uint8,
        error: Optional[str]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, txid: Union[ bytes32, _Unspec] = _Unspec(),
        status: Union[ uint8, _Unspec] = _Unspec(),
        error: Union[ Optional[str], _Unspec] = _Unspec()) -> TransactionAck: ...

@final
class NewPeakWallet:
    header_hash: bytes32
    height: uint32
    weight: uint128
    fork_point_with_previous_peak: uint32
    def __init__(
        self,
        header_hash: bytes,
        height: uint32,
        weight: uint128,
        fork_point_with_previous_peak: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        height: Union[ uint32, _Unspec] = _Unspec(),
        weight: Union[ uint128, _Unspec] = _Unspec(),
        fork_point_with_previous_peak: Union[ uint32, _Unspec] = _Unspec()) -> NewPeakWallet: ...

@final
class RequestBlockHeader:
    height: uint32
    def __init__(
        self,
        height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec()) -> RequestBlockHeader: ...

@final
class RespondBlockHeader:
    header_block: HeaderBlock
    def __init__(
        self,
        header_block: HeaderBlock
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, header_block: Union[ HeaderBlock, _Unspec] = _Unspec()) -> RespondBlockHeader: ...

@final
class RejectHeaderRequest:
    height: uint32
    def __init__(
        self,
        height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec()) -> RejectHeaderRequest: ...

@final
class RequestRemovals:
    height: uint32
    header_hash: bytes32
    coin_names: Optional[list[bytes32]]
    def __init__(
        self,
        height: uint32,
        header_hash: bytes,
        coin_names: Optional[Sequence[bytes32]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        coin_names: Union[ Optional[list[bytes32]], _Unspec] = _Unspec()) -> RequestRemovals: ...

@final
class RespondRemovals:
    height: uint32
    header_hash: bytes32
    coins: list[tuple[bytes32, Optional[Coin]]]
    proofs: Optional[list[tuple[bytes32, bytes]]]
    def __init__(
        self,
        height: uint32,
        header_hash: bytes,
        coins: Sequence[tuple[bytes32, Optional[Coin]]],
        proofs: Optional[Sequence[tuple[bytes32, bytes]]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        coins: Union[ list[tuple[bytes32, Optional[Coin]]], _Unspec] = _Unspec(),
        proofs: Union[ Optional[list[tuple[bytes32, bytes]]], _Unspec] = _Unspec()) -> RespondRemovals: ...

@final
class RejectRemovalsRequest:
    height: uint32
    header_hash: bytes32
    def __init__(
        self,
        height: uint32,
        header_hash: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec()) -> RejectRemovalsRequest: ...

@final
class RequestAdditions:
    height: uint32
    header_hash: Optional[bytes32]
    puzzle_hashes: Optional[list[bytes32]]
    def __init__(
        self,
        height: uint32,
        header_hash: Optional[bytes32],
        puzzle_hashes: Optional[Sequence[bytes32]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ Optional[bytes32], _Unspec] = _Unspec(),
        puzzle_hashes: Union[ Optional[list[bytes32]], _Unspec] = _Unspec()) -> RequestAdditions: ...

@final
class RespondAdditions:
    height: uint32
    header_hash: bytes32
    coins: list[tuple[bytes32, list[Coin]]]
    proofs: Optional[list[tuple[bytes32, bytes, Optional[bytes]]]]
    def __init__(
        self,
        height: uint32,
        header_hash: bytes,
        coins: Sequence[tuple[bytes32, Sequence[Coin]]],
        proofs: Optional[Sequence[tuple[bytes32, bytes, Optional[bytes]]]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        coins: Union[ list[tuple[bytes32, list[Coin]]], _Unspec] = _Unspec(),
        proofs: Union[ Optional[list[tuple[bytes32, bytes, Optional[bytes]]]], _Unspec] = _Unspec()) -> RespondAdditions: ...

@final
class RejectAdditionsRequest:
    height: uint32
    header_hash: bytes32
    def __init__(
        self,
        height: uint32,
        header_hash: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec()) -> RejectAdditionsRequest: ...

@final
class RespondBlockHeaders:
    start_height: uint32
    end_height: uint32
    header_blocks: list[HeaderBlock]
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32,
        header_blocks: Sequence[HeaderBlock]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec(),
        header_blocks: Union[ list[HeaderBlock], _Unspec] = _Unspec()) -> RespondBlockHeaders: ...

@final
class RejectBlockHeaders:
    start_height: uint32
    end_height: uint32
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec()) -> RejectBlockHeaders: ...

@final
class RequestBlockHeaders:
    start_height: uint32
    end_height: uint32
    return_filter: bool
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32,
        return_filter: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec(),
        return_filter: Union[ bool, _Unspec] = _Unspec()) -> RequestBlockHeaders: ...

@final
class RequestHeaderBlocks:
    start_height: uint32
    end_height: uint32
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec()) -> RequestHeaderBlocks: ...

@final
class RejectHeaderBlocks:
    start_height: uint32
    end_height: uint32
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec()) -> RejectHeaderBlocks: ...

@final
class RespondHeaderBlocks:
    start_height: uint32
    end_height: uint32
    header_blocks: list[HeaderBlock]
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32,
        header_blocks: Sequence[HeaderBlock]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec(),
        header_blocks: Union[ list[HeaderBlock], _Unspec] = _Unspec()) -> RespondHeaderBlocks: ...

@final
class RegisterForPhUpdates:
    puzzle_hashes: list[bytes32]
    min_height: uint32
    def __init__(
        self,
        puzzle_hashes: Sequence[bytes32],
        min_height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, puzzle_hashes: Union[ list[bytes32], _Unspec] = _Unspec(),
        min_height: Union[ uint32, _Unspec] = _Unspec()) -> RegisterForPhUpdates: ...

@final
class RespondToPhUpdates:
    puzzle_hashes: list[bytes32]
    min_height: uint32
    coin_states: list[CoinState]
    def __init__(
        self,
        puzzle_hashes: Sequence[bytes32],
        min_height: uint32,
        coin_states: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, puzzle_hashes: Union[ list[bytes32], _Unspec] = _Unspec(),
        min_height: Union[ uint32, _Unspec] = _Unspec(),
        coin_states: Union[ list[CoinState], _Unspec] = _Unspec()) -> RespondToPhUpdates: ...

@final
class RegisterForCoinUpdates:
    coin_ids: list[bytes32]
    min_height: uint32
    def __init__(
        self,
        coin_ids: Sequence[bytes32],
        min_height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_ids: Union[ list[bytes32], _Unspec] = _Unspec(),
        min_height: Union[ uint32, _Unspec] = _Unspec()) -> RegisterForCoinUpdates: ...

@final
class RespondToCoinUpdates:
    coin_ids: list[bytes32]
    min_height: uint32
    coin_states: list[CoinState]
    def __init__(
        self,
        coin_ids: Sequence[bytes32],
        min_height: uint32,
        coin_states: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_ids: Union[ list[bytes32], _Unspec] = _Unspec(),
        min_height: Union[ uint32, _Unspec] = _Unspec(),
        coin_states: Union[ list[CoinState], _Unspec] = _Unspec()) -> RespondToCoinUpdates: ...

@final
class CoinStateUpdate:
    height: uint32
    fork_height: uint32
    peak_hash: bytes32
    items: list[CoinState]
    def __init__(
        self,
        height: uint32,
        fork_height: uint32,
        peak_hash: bytes,
        items: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, height: Union[ uint32, _Unspec] = _Unspec(),
        fork_height: Union[ uint32, _Unspec] = _Unspec(),
        peak_hash: Union[ bytes32, _Unspec] = _Unspec(),
        items: Union[ list[CoinState], _Unspec] = _Unspec()) -> CoinStateUpdate: ...

@final
class RequestChildren:
    coin_name: bytes32
    def __init__(
        self,
        coin_name: bytes
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_name: Union[ bytes32, _Unspec] = _Unspec()) -> RequestChildren: ...

@final
class RespondChildren:
    coin_states: list[CoinState]
    def __init__(
        self,
        coin_states: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_states: Union[ list[CoinState], _Unspec] = _Unspec()) -> RespondChildren: ...

@final
class RequestSesInfo:
    start_height: uint32
    end_height: uint32
    def __init__(
        self,
        start_height: uint32,
        end_height: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, start_height: Union[ uint32, _Unspec] = _Unspec(),
        end_height: Union[ uint32, _Unspec] = _Unspec()) -> RequestSesInfo: ...

@final
class RespondSesInfo:
    reward_chain_hash: list[bytes32]
    heights: list[list[uint32]]
    def __init__(
        self,
        reward_chain_hash: Sequence[bytes32],
        heights: Sequence[Sequence[uint32]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, reward_chain_hash: Union[ list[bytes32], _Unspec] = _Unspec(),
        heights: Union[ list[list[uint32]], _Unspec] = _Unspec()) -> RespondSesInfo: ...

@final
class RequestFeeEstimates:
    time_targets: list[uint64]
    def __init__(
        self,
        time_targets: Sequence[uint64]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, time_targets: Union[ list[uint64], _Unspec] = _Unspec()) -> RequestFeeEstimates: ...

@final
class RespondFeeEstimates:
    estimates: FeeEstimateGroup
    def __init__(
        self,
        estimates: FeeEstimateGroup
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, estimates: Union[ FeeEstimateGroup, _Unspec] = _Unspec()) -> RespondFeeEstimates: ...

@final
class RequestRemovePuzzleSubscriptions:
    puzzle_hashes: Optional[list[bytes32]]
    def __init__(
        self,
        puzzle_hashes: Optional[Sequence[bytes32]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, puzzle_hashes: Union[ Optional[list[bytes32]], _Unspec] = _Unspec()) -> RequestRemovePuzzleSubscriptions: ...

@final
class RespondRemovePuzzleSubscriptions:
    puzzle_hashes: list[bytes32]
    def __init__(
        self,
        puzzle_hashes: Sequence[bytes32]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, puzzle_hashes: Union[ list[bytes32], _Unspec] = _Unspec()) -> RespondRemovePuzzleSubscriptions: ...

@final
class RequestRemoveCoinSubscriptions:
    coin_ids: Optional[list[bytes32]]
    def __init__(
        self,
        coin_ids: Optional[Sequence[bytes32]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_ids: Union[ Optional[list[bytes32]], _Unspec] = _Unspec()) -> RequestRemoveCoinSubscriptions: ...

@final
class RespondRemoveCoinSubscriptions:
    coin_ids: list[bytes32]
    def __init__(
        self,
        coin_ids: Sequence[bytes32]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_ids: Union[ list[bytes32], _Unspec] = _Unspec()) -> RespondRemoveCoinSubscriptions: ...

@final
class CoinStateFilters:
    include_spent: bool
    include_unspent: bool
    include_hinted: bool
    min_amount: uint64
    def __init__(
        self,
        include_spent: bool,
        include_unspent: bool,
        include_hinted: bool,
        min_amount: uint64
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, include_spent: Union[ bool, _Unspec] = _Unspec(),
        include_unspent: Union[ bool, _Unspec] = _Unspec(),
        include_hinted: Union[ bool, _Unspec] = _Unspec(),
        min_amount: Union[ uint64, _Unspec] = _Unspec()) -> CoinStateFilters: ...

@final
class RequestPuzzleState:
    puzzle_hashes: list[bytes32]
    previous_height: Optional[uint32]
    header_hash: bytes32
    filters: CoinStateFilters
    subscribe_when_finished: bool
    def __init__(
        self,
        puzzle_hashes: Sequence[bytes32],
        previous_height: Optional[uint32],
        header_hash: bytes,
        filters: CoinStateFilters,
        subscribe_when_finished: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, puzzle_hashes: Union[ list[bytes32], _Unspec] = _Unspec(),
        previous_height: Union[ Optional[uint32], _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        filters: Union[ CoinStateFilters, _Unspec] = _Unspec(),
        subscribe_when_finished: Union[ bool, _Unspec] = _Unspec()) -> RequestPuzzleState: ...

@final
class RespondPuzzleState:
    puzzle_hashes: list[bytes32]
    height: uint32
    header_hash: bytes32
    is_finished: bool
    coin_states: list[CoinState]
    def __init__(
        self,
        puzzle_hashes: Sequence[bytes32],
        height: uint32,
        header_hash: bytes,
        is_finished: bool,
        coin_states: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, puzzle_hashes: Union[ list[bytes32], _Unspec] = _Unspec(),
        height: Union[ uint32, _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        is_finished: Union[ bool, _Unspec] = _Unspec(),
        coin_states: Union[ list[CoinState], _Unspec] = _Unspec()) -> RespondPuzzleState: ...

@final
class RejectPuzzleState:
    reason: int
    def __init__(
        self,
        reason: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, reason: Union[ int, _Unspec] = _Unspec()) -> RejectPuzzleState: ...

@final
class RequestCoinState:
    coin_ids: list[bytes32]
    previous_height: Optional[uint32]
    header_hash: bytes32
    subscribe: bool
    def __init__(
        self,
        coin_ids: Sequence[bytes32],
        previous_height: Optional[uint32],
        header_hash: bytes,
        subscribe: bool
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_ids: Union[ list[bytes32], _Unspec] = _Unspec(),
        previous_height: Union[ Optional[uint32], _Unspec] = _Unspec(),
        header_hash: Union[ bytes32, _Unspec] = _Unspec(),
        subscribe: Union[ bool, _Unspec] = _Unspec()) -> RequestCoinState: ...

@final
class RespondCoinState:
    coin_ids: list[bytes32]
    coin_states: list[CoinState]
    def __init__(
        self,
        coin_ids: Sequence[bytes32],
        coin_states: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, coin_ids: Union[ list[bytes32], _Unspec] = _Unspec(),
        coin_states: Union[ list[CoinState], _Unspec] = _Unspec()) -> RespondCoinState: ...

@final
class RejectCoinState:
    reason: int
    def __init__(
        self,
        reason: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, reason: Union[ int, _Unspec] = _Unspec()) -> RejectCoinState: ...

@final
class RemovedMempoolItem:
    transaction_id: bytes32
    reason: int
    def __init__(
        self,
        transaction_id: bytes,
        reason: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, transaction_id: Union[ bytes32, _Unspec] = _Unspec(),
        reason: Union[ int, _Unspec] = _Unspec()) -> RemovedMempoolItem: ...

@final
class MempoolItemsAdded:
    transaction_ids: list[bytes32]
    def __init__(
        self,
        transaction_ids: Sequence[bytes32]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, transaction_ids: Union[ list[bytes32], _Unspec] = _Unspec()) -> MempoolItemsAdded: ...

@final
class MempoolItemsRemoved:
    removed_items: list[RemovedMempoolItem]
    def __init__(
        self,
        removed_items: Sequence[RemovedMempoolItem]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, removed_items: Union[ list[RemovedMempoolItem], _Unspec] = _Unspec()) -> MempoolItemsRemoved: ...

@final
class RequestCostInfo:
    def __init__(
        self
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...

@final
class RespondCostInfo:
    max_transaction_cost: uint64
    max_block_cost: uint64
    max_mempool_cost: uint64
    mempool_cost: uint64
    mempool_fee: uint64
    bump_fee_per_cost: uint8
    def __init__(
        self,
        max_transaction_cost: uint64,
        max_block_cost: uint64,
        max_mempool_cost: uint64,
        mempool_cost: uint64,
        mempool_fee: uint64,
        bump_fee_per_cost: uint8
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, max_transaction_cost: Union[ uint64, _Unspec] = _Unspec(),
        max_block_cost: Union[ uint64, _Unspec] = _Unspec(),
        max_mempool_cost: Union[ uint64, _Unspec] = _Unspec(),
        mempool_cost: Union[ uint64, _Unspec] = _Unspec(),
        mempool_fee: Union[ uint64, _Unspec] = _Unspec(),
        bump_fee_per_cost: Union[ uint8, _Unspec] = _Unspec()) -> RespondCostInfo: ...

@final
class SubEpochData:
    reward_chain_hash: bytes32
    num_blocks_overflow: uint8
    new_sub_slot_iters: Optional[uint64]
    new_difficulty: Optional[uint64]
    def __init__(
        self,
        reward_chain_hash: bytes,
        num_blocks_overflow: uint8,
        new_sub_slot_iters: Optional[uint64],
        new_difficulty: Optional[uint64]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, reward_chain_hash: Union[ bytes32, _Unspec] = _Unspec(),
        num_blocks_overflow: Union[ uint8, _Unspec] = _Unspec(),
        new_sub_slot_iters: Union[ Optional[uint64], _Unspec] = _Unspec(),
        new_difficulty: Union[ Optional[uint64], _Unspec] = _Unspec()) -> SubEpochData: ...

@final
class SubSlotData:
    proof_of_space: Optional[ProofOfSpace]
    cc_signage_point: Optional[VDFProof]
    cc_infusion_point: Optional[VDFProof]
    icc_infusion_point: Optional[VDFProof]
    cc_sp_vdf_info: Optional[VDFInfo]
    signage_point_index: Optional[uint8]
    cc_slot_end: Optional[VDFProof]
    icc_slot_end: Optional[VDFProof]
    cc_slot_end_info: Optional[VDFInfo]
    icc_slot_end_info: Optional[VDFInfo]
    cc_ip_vdf_info: Optional[VDFInfo]
    icc_ip_vdf_info: Optional[VDFInfo]
    total_iters: Optional[uint128]
    def is_end_of_slot(self) -> bool: ...
    def is_challenge(self) -> bool: ...
    def __init__(
        self,
        proof_of_space: Optional[ProofOfSpace],
        cc_signage_point: Optional[VDFProof],
        cc_infusion_point: Optional[VDFProof],
        icc_infusion_point: Optional[VDFProof],
        cc_sp_vdf_info: Optional[VDFInfo],
        signage_point_index: Optional[uint8],
        cc_slot_end: Optional[VDFProof],
        icc_slot_end: Optional[VDFProof],
        cc_slot_end_info: Optional[VDFInfo],
        icc_slot_end_info: Optional[VDFInfo],
        cc_ip_vdf_info: Optional[VDFInfo],
        icc_ip_vdf_info: Optional[VDFInfo],
        total_iters: Optional[uint128]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, proof_of_space: Union[ Optional[ProofOfSpace], _Unspec] = _Unspec(),
        cc_signage_point: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        cc_infusion_point: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        icc_infusion_point: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        cc_sp_vdf_info: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        signage_point_index: Union[ Optional[uint8], _Unspec] = _Unspec(),
        cc_slot_end: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        icc_slot_end: Union[ Optional[VDFProof], _Unspec] = _Unspec(),
        cc_slot_end_info: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        icc_slot_end_info: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        cc_ip_vdf_info: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        icc_ip_vdf_info: Union[ Optional[VDFInfo], _Unspec] = _Unspec(),
        total_iters: Union[ Optional[uint128], _Unspec] = _Unspec()) -> SubSlotData: ...

@final
class SubEpochChallengeSegment:
    sub_epoch_n: uint32
    sub_slots: list[SubSlotData]
    rc_slot_end_info: Optional[VDFInfo]
    def __init__(
        self,
        sub_epoch_n: uint32,
        sub_slots: Sequence[SubSlotData],
        rc_slot_end_info: Optional[VDFInfo]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, sub_epoch_n: Union[ uint32, _Unspec] = _Unspec(),
        sub_slots: Union[ list[SubSlotData], _Unspec] = _Unspec(),
        rc_slot_end_info: Union[ Optional[VDFInfo], _Unspec] = _Unspec()) -> SubEpochChallengeSegment: ...

@final
class SubEpochSegments:
    challenge_segments: list[SubEpochChallengeSegment]
    def __init__(
        self,
        challenge_segments: Sequence[SubEpochChallengeSegment]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, challenge_segments: Union[ list[SubEpochChallengeSegment], _Unspec] = _Unspec()) -> SubEpochSegments: ...

@final
class RecentChainData:
    recent_chain_data: list[HeaderBlock]
    def __init__(
        self,
        recent_chain_data: Sequence[HeaderBlock]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, recent_chain_data: Union[ list[HeaderBlock], _Unspec] = _Unspec()) -> RecentChainData: ...

@final
class ProofBlockHeader:
    finished_sub_slots: list[EndOfSubSlotBundle]
    reward_chain_block: RewardChainBlock
    def __init__(
        self,
        finished_sub_slots: Sequence[EndOfSubSlotBundle],
        reward_chain_block: RewardChainBlock
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, finished_sub_slots: Union[ list[EndOfSubSlotBundle], _Unspec] = _Unspec(),
        reward_chain_block: Union[ RewardChainBlock, _Unspec] = _Unspec()) -> ProofBlockHeader: ...

@final
class WeightProof:
    sub_epochs: list[SubEpochData]
    sub_epoch_segments: list[SubEpochChallengeSegment]
    recent_chain_data: list[HeaderBlock]
    def __init__(
        self,
        sub_epochs: Sequence[SubEpochData],
        sub_epoch_segments: Sequence[SubEpochChallengeSegment],
        recent_chain_data: Sequence[HeaderBlock]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, sub_epochs: Union[ list[SubEpochData], _Unspec] = _Unspec(),
        sub_epoch_segments: Union[ list[SubEpochChallengeSegment], _Unspec] = _Unspec(),
        recent_chain_data: Union[ list[HeaderBlock], _Unspec] = _Unspec()) -> WeightProof: ...

@final
class ConsensusConstants:
    SLOT_BLOCKS_TARGET: uint32
    MIN_BLOCKS_PER_CHALLENGE_BLOCK: uint8
    MAX_SUB_SLOT_BLOCKS: uint32
    NUM_SPS_SUB_SLOT: uint8
    SUB_SLOT_ITERS_STARTING: uint64
    DIFFICULTY_CONSTANT_FACTOR: uint128
    DIFFICULTY_STARTING: uint64
    DIFFICULTY_CHANGE_MAX_FACTOR: uint32
    SUB_EPOCH_BLOCKS: uint32
    EPOCH_BLOCKS: uint32
    SIGNIFICANT_BITS: uint8
    DISCRIMINANT_SIZE_BITS: uint16
    NUMBER_ZERO_BITS_PLOT_FILTER_V1: uint8
    NUMBER_ZERO_BITS_PLOT_FILTER_V2: uint8
    MIN_PLOT_SIZE_V1: uint8
    MAX_PLOT_SIZE_V1: uint8
    MIN_PLOT_SIZE_V2: uint8
    MAX_PLOT_SIZE_V2: uint8
    SUB_SLOT_TIME_TARGET: uint16
    NUM_SP_INTERVALS_EXTRA: uint8
    MAX_FUTURE_TIME2: uint32
    NUMBER_OF_TIMESTAMPS: uint8
    GENESIS_CHALLENGE: bytes32
    AGG_SIG_ME_ADDITIONAL_DATA: bytes32
    AGG_SIG_PARENT_ADDITIONAL_DATA: bytes32
    AGG_SIG_PUZZLE_ADDITIONAL_DATA: bytes32
    AGG_SIG_AMOUNT_ADDITIONAL_DATA: bytes32
    AGG_SIG_PUZZLE_AMOUNT_ADDITIONAL_DATA: bytes32
    AGG_SIG_PARENT_AMOUNT_ADDITIONAL_DATA: bytes32
    AGG_SIG_PARENT_PUZZLE_ADDITIONAL_DATA: bytes32
    GENESIS_PRE_FARM_POOL_PUZZLE_HASH: bytes32
    GENESIS_PRE_FARM_FARMER_PUZZLE_HASH: bytes32
    MAX_VDF_WITNESS_SIZE: uint8
    MEMPOOL_BLOCK_BUFFER: uint8
    MAX_COIN_AMOUNT: uint64
    MAX_BLOCK_COST_CLVM: uint64
    COST_PER_BYTE: uint64
    WEIGHT_PROOF_THRESHOLD: uint8
    WEIGHT_PROOF_RECENT_BLOCKS: uint32
    MAX_BLOCK_COUNT_PER_REQUESTS: uint32
    BLOCKS_CACHE_SIZE: uint32
    MAX_GENERATOR_SIZE: uint32
    MAX_GENERATOR_REF_LIST_SIZE: uint32
    POOL_SUB_SLOT_ITERS: uint64
    HARD_FORK_HEIGHT: uint32
    HARD_FORK2_HEIGHT: uint32
    PLOT_V1_PHASE_OUT: uint32
    PLOT_FILTER_128_HEIGHT: uint32
    PLOT_FILTER_64_HEIGHT: uint32
    PLOT_FILTER_32_HEIGHT: uint32
    PLOT_DIFFICULTY_INITIAL: uint8
    PLOT_DIFFICULTY_4_HEIGHT: uint32
    PLOT_DIFFICULTY_5_HEIGHT: uint32
    PLOT_DIFFICULTY_6_HEIGHT: uint32
    PLOT_DIFFICULTY_7_HEIGHT: uint32
    PLOT_DIFFICULTY_8_HEIGHT: uint32
    def __init__(
        self,
        SLOT_BLOCKS_TARGET: uint32,
        MIN_BLOCKS_PER_CHALLENGE_BLOCK: uint8,
        MAX_SUB_SLOT_BLOCKS: uint32,
        NUM_SPS_SUB_SLOT: uint8,
        SUB_SLOT_ITERS_STARTING: uint64,
        DIFFICULTY_CONSTANT_FACTOR: uint128,
        DIFFICULTY_STARTING: uint64,
        DIFFICULTY_CHANGE_MAX_FACTOR: uint32,
        SUB_EPOCH_BLOCKS: uint32,
        EPOCH_BLOCKS: uint32,
        SIGNIFICANT_BITS: uint8,
        DISCRIMINANT_SIZE_BITS: uint16,
        NUMBER_ZERO_BITS_PLOT_FILTER_V1: uint8,
        NUMBER_ZERO_BITS_PLOT_FILTER_V2: uint8,
        MIN_PLOT_SIZE_V1: uint8,
        MAX_PLOT_SIZE_V1: uint8,
        MIN_PLOT_SIZE_V2: uint8,
        MAX_PLOT_SIZE_V2: uint8,
        SUB_SLOT_TIME_TARGET: uint16,
        NUM_SP_INTERVALS_EXTRA: uint8,
        MAX_FUTURE_TIME2: uint32,
        NUMBER_OF_TIMESTAMPS: uint8,
        GENESIS_CHALLENGE: bytes,
        AGG_SIG_ME_ADDITIONAL_DATA: bytes,
        AGG_SIG_PARENT_ADDITIONAL_DATA: bytes,
        AGG_SIG_PUZZLE_ADDITIONAL_DATA: bytes,
        AGG_SIG_AMOUNT_ADDITIONAL_DATA: bytes,
        AGG_SIG_PUZZLE_AMOUNT_ADDITIONAL_DATA: bytes,
        AGG_SIG_PARENT_AMOUNT_ADDITIONAL_DATA: bytes,
        AGG_SIG_PARENT_PUZZLE_ADDITIONAL_DATA: bytes,
        GENESIS_PRE_FARM_POOL_PUZZLE_HASH: bytes,
        GENESIS_PRE_FARM_FARMER_PUZZLE_HASH: bytes,
        MAX_VDF_WITNESS_SIZE: uint8,
        MEMPOOL_BLOCK_BUFFER: uint8,
        MAX_COIN_AMOUNT: uint64,
        MAX_BLOCK_COST_CLVM: uint64,
        COST_PER_BYTE: uint64,
        WEIGHT_PROOF_THRESHOLD: uint8,
        WEIGHT_PROOF_RECENT_BLOCKS: uint32,
        MAX_BLOCK_COUNT_PER_REQUESTS: uint32,
        BLOCKS_CACHE_SIZE: uint32,
        MAX_GENERATOR_SIZE: uint32,
        MAX_GENERATOR_REF_LIST_SIZE: uint32,
        POOL_SUB_SLOT_ITERS: uint64,
        HARD_FORK_HEIGHT: uint32,
        HARD_FORK2_HEIGHT: uint32,
        PLOT_V1_PHASE_OUT: uint32,
        PLOT_FILTER_128_HEIGHT: uint32,
        PLOT_FILTER_64_HEIGHT: uint32,
        PLOT_FILTER_32_HEIGHT: uint32,
        PLOT_DIFFICULTY_INITIAL: uint8,
        PLOT_DIFFICULTY_4_HEIGHT: uint32,
        PLOT_DIFFICULTY_5_HEIGHT: uint32,
        PLOT_DIFFICULTY_6_HEIGHT: uint32,
        PLOT_DIFFICULTY_7_HEIGHT: uint32,
        PLOT_DIFFICULTY_8_HEIGHT: uint32
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __deepcopy__(self, memo: object) -> Self: ...
    def __copy__(self) -> Self: ...
    @classmethod
    def from_bytes(cls, blob: bytes) -> Self: ...
    @classmethod
    def from_bytes_unchecked(cls, blob: bytes) -> Self: ...
    @classmethod
    def parse_rust(cls, blob: ReadableBuffer, trusted: bool = False) -> tuple[Self, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def stream_to_bytes(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_json_dict(cls, json_dict: dict[str, Any]) -> Self: ...
    def replace(self, *, SLOT_BLOCKS_TARGET: Union[ uint32, _Unspec] = _Unspec(),
        MIN_BLOCKS_PER_CHALLENGE_BLOCK: Union[ uint8, _Unspec] = _Unspec(),
        MAX_SUB_SLOT_BLOCKS: Union[ uint32, _Unspec] = _Unspec(),
        NUM_SPS_SUB_SLOT: Union[ uint8, _Unspec] = _Unspec(),
        SUB_SLOT_ITERS_STARTING: Union[ uint64, _Unspec] = _Unspec(),
        DIFFICULTY_CONSTANT_FACTOR: Union[ uint128, _Unspec] = _Unspec(),
        DIFFICULTY_STARTING: Union[ uint64, _Unspec] = _Unspec(),
        DIFFICULTY_CHANGE_MAX_FACTOR: Union[ uint32, _Unspec] = _Unspec(),
        SUB_EPOCH_BLOCKS: Union[ uint32, _Unspec] = _Unspec(),
        EPOCH_BLOCKS: Union[ uint32, _Unspec] = _Unspec(),
        SIGNIFICANT_BITS: Union[ uint8, _Unspec] = _Unspec(),
        DISCRIMINANT_SIZE_BITS: Union[ uint16, _Unspec] = _Unspec(),
        NUMBER_ZERO_BITS_PLOT_FILTER_V1: Union[ uint8, _Unspec] = _Unspec(),
        NUMBER_ZERO_BITS_PLOT_FILTER_V2: Union[ uint8, _Unspec] = _Unspec(),
        MIN_PLOT_SIZE_V1: Union[ uint8, _Unspec] = _Unspec(),
        MAX_PLOT_SIZE_V1: Union[ uint8, _Unspec] = _Unspec(),
        MIN_PLOT_SIZE_V2: Union[ uint8, _Unspec] = _Unspec(),
        MAX_PLOT_SIZE_V2: Union[ uint8, _Unspec] = _Unspec(),
        SUB_SLOT_TIME_TARGET: Union[ uint16, _Unspec] = _Unspec(),
        NUM_SP_INTERVALS_EXTRA: Union[ uint8, _Unspec] = _Unspec(),
        MAX_FUTURE_TIME2: Union[ uint32, _Unspec] = _Unspec(),
        NUMBER_OF_TIMESTAMPS: Union[ uint8, _Unspec] = _Unspec(),
        GENESIS_CHALLENGE: Union[ bytes32, _Unspec] = _Unspec(),
        AGG_SIG_ME_ADDITIONAL_DATA: Union[ bytes32, _Unspec] = _Unspec(),
        AGG_SIG_PARENT_ADDITIONAL_DATA: Union[ bytes32, _Unspec] = _Unspec(),
        AGG_SIG_PUZZLE_ADDITIONAL_DATA: Union[ bytes32, _Unspec] = _Unspec(),
        AGG_SIG_AMOUNT_ADDITIONAL_DATA: Union[ bytes32, _Unspec] = _Unspec(),
        AGG_SIG_PUZZLE_AMOUNT_ADDITIONAL_DATA: Union[ bytes32, _Unspec] = _Unspec(),
        AGG_SIG_PARENT_AMOUNT_ADDITIONAL_DATA: Union[ bytes32, _Unspec] = _Unspec(),
        AGG_SIG_PARENT_PUZZLE_ADDITIONAL_DATA: Union[ bytes32, _Unspec] = _Unspec(),
        GENESIS_PRE_FARM_POOL_PUZZLE_HASH: Union[ bytes32, _Unspec] = _Unspec(),
        GENESIS_PRE_FARM_FARMER_PUZZLE_HASH: Union[ bytes32, _Unspec] = _Unspec(),
        MAX_VDF_WITNESS_SIZE: Union[ uint8, _Unspec] = _Unspec(),
        MEMPOOL_BLOCK_BUFFER: Union[ uint8, _Unspec] = _Unspec(),
        MAX_COIN_AMOUNT: Union[ uint64, _Unspec] = _Unspec(),
        MAX_BLOCK_COST_CLVM: Union[ uint64, _Unspec] = _Unspec(),
        COST_PER_BYTE: Union[ uint64, _Unspec] = _Unspec(),
        WEIGHT_PROOF_THRESHOLD: Union[ uint8, _Unspec] = _Unspec(),
        WEIGHT_PROOF_RECENT_BLOCKS: Union[ uint32, _Unspec] = _Unspec(),
        MAX_BLOCK_COUNT_PER_REQUESTS: Union[ uint32, _Unspec] = _Unspec(),
        BLOCKS_CACHE_SIZE: Union[ uint32, _Unspec] = _Unspec(),
        MAX_GENERATOR_SIZE: Union[ uint32, _Unspec] = _Unspec(),
        MAX_GENERATOR_REF_LIST_SIZE: Union[ uint32, _Unspec] = _Unspec(),
        POOL_SUB_SLOT_ITERS: Union[ uint64, _Unspec] = _Unspec(),
        HARD_FORK_HEIGHT: Union[ uint32, _Unspec] = _Unspec(),
        HARD_FORK2_HEIGHT: Union[ uint32, _Unspec] = _Unspec(),
        PLOT_V1_PHASE_OUT: Union[ uint32, _Unspec] = _Unspec(),
        PLOT_FILTER_128_HEIGHT: Union[ uint32, _Unspec] = _Unspec(),
        PLOT_FILTER_64_HEIGHT: Union[ uint32, _Unspec] = _Unspec(),
        PLOT_FILTER_32_HEIGHT: Union[ uint32, _Unspec] = _Unspec(),
        PLOT_DIFFICULTY_INITIAL: Union[ uint8, _Unspec] = _Unspec(),
        PLOT_DIFFICULTY_4_HEIGHT: Union[ uint32, _Unspec] = _Unspec(),
        PLOT_DIFFICULTY_5_HEIGHT: Union[ uint32, _Unspec] = _Unspec(),
        PLOT_DIFFICULTY_6_HEIGHT: Union[ uint32, _Unspec] = _Unspec(),
        PLOT_DIFFICULTY_7_HEIGHT: Union[ uint32, _Unspec] = _Unspec(),
        PLOT_DIFFICULTY_8_HEIGHT: Union[ uint32, _Unspec] = _Unspec()) -> ConsensusConstants: ...
