import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HelmProviderConfig {
    /**
     * Debug indicates whether or not Helm is running in Debug mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#debug HelmProvider#debug}
     *
     * @stability stable
     */
    readonly debug?: boolean | cdktf.IResolvable;
    /**
     * The backend storage driver. Values are: configmap, secret, memory, sql.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#helm_driver HelmProvider#helm_driver}
     *
     * @stability stable
     */
    readonly helmDriver?: string;
    /**
     * The path to the helm plugins directory.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#plugins_path HelmProvider#plugins_path}
     *
     * @stability stable
     */
    readonly pluginsPath?: string;
    /**
     * The path to the registry config file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#registry_config_path HelmProvider#registry_config_path}
     *
     * @stability stable
     */
    readonly registryConfigPath?: string;
    /**
     * The path to the file containing cached repository indexes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#repository_cache HelmProvider#repository_cache}
     *
     * @stability stable
     */
    readonly repositoryCache?: string;
    /**
     * The path to the file containing repository names and URLs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#repository_config_path HelmProvider#repository_config_path}
     *
     * @stability stable
     */
    readonly repositoryConfigPath?: string;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#alias HelmProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * experiments block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#experiments HelmProvider#experiments}
     *
     * @stability stable
     */
    readonly experiments?: HelmProviderExperiments;
    /**
     * kubernetes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#kubernetes HelmProvider#kubernetes}
     *
     * @stability stable
     */
    readonly kubernetes?: HelmProviderKubernetes;
}
/**
 * @stability stable
 */
export interface HelmProviderExperiments {
    /**
     * Enable full diff by storing the rendered manifest in the state.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#manifest HelmProvider#manifest}
     *
     * @stability stable
     */
    readonly manifest?: boolean | cdktf.IResolvable;
}
export declare function helmProviderExperimentsToTerraform(struct?: HelmProviderExperiments): any;
/**
 * @stability stable
 */
export interface HelmProviderKubernetesExec {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#api_version HelmProvider#api_version}.
     *
     * @stability stable
     */
    readonly apiVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#args HelmProvider#args}.
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#command HelmProvider#command}.
     *
     * @stability stable
     */
    readonly command: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#env HelmProvider#env}.
     *
     * @stability stable
     */
    readonly env?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare function helmProviderKubernetesExecToTerraform(struct?: HelmProviderKubernetesExec): any;
/**
 * @stability stable
 */
export interface HelmProviderKubernetes {
    /**
     * PEM-encoded client certificate for TLS authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#client_certificate HelmProvider#client_certificate}
     *
     * @stability stable
     */
    readonly clientCertificate?: string;
    /**
     * PEM-encoded client certificate key for TLS authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#client_key HelmProvider#client_key}
     *
     * @stability stable
     */
    readonly clientKey?: string;
    /**
     * PEM-encoded root certificates bundle for TLS authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#cluster_ca_certificate HelmProvider#cluster_ca_certificate}
     *
     * @stability stable
     */
    readonly clusterCaCertificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#config_context HelmProvider#config_context}.
     *
     * @stability stable
     */
    readonly configContext?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#config_context_auth_info HelmProvider#config_context_auth_info}.
     *
     * @stability stable
     */
    readonly configContextAuthInfo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#config_context_cluster HelmProvider#config_context_cluster}.
     *
     * @stability stable
     */
    readonly configContextCluster?: string;
    /**
     * Path to the kube config file. Can be set with KUBE_CONFIG_PATH.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#config_path HelmProvider#config_path}
     *
     * @stability stable
     */
    readonly configPath?: string;
    /**
     * A list of paths to kube config files. Can be set with KUBE_CONFIG_PATHS environment variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#config_paths HelmProvider#config_paths}
     *
     * @stability stable
     */
    readonly configPaths?: string[];
    /**
     * The hostname (in form of URI) of Kubernetes master.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#host HelmProvider#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * Whether server should be accessed without verifying the TLS certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#insecure HelmProvider#insecure}
     *
     * @stability stable
     */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
     * The password to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#password HelmProvider#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Token to authenticate an service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#token HelmProvider#token}
     *
     * @stability stable
     */
    readonly token?: string;
    /**
     * The username to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#username HelmProvider#username}
     *
     * @stability stable
     */
    readonly username?: string;
    /**
     * exec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm#exec HelmProvider#exec}
     *
     * @stability stable
     */
    readonly exec?: HelmProviderKubernetesExec;
}
export declare function helmProviderKubernetesToTerraform(struct?: HelmProviderKubernetes): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/helm helm}.
 *
 * @stability stable
 */
export declare class HelmProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/helm helm} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: HelmProviderConfig);
    private _debug?;
    /**
     * @stability stable
     */
    get debug(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set debug(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDebug(): void;
    /**
     * @stability stable
     */
    get debugInput(): boolean | cdktf.IResolvable | undefined;
    private _helmDriver?;
    /**
     * @stability stable
     */
    get helmDriver(): string | undefined;
    /**
     * @stability stable
     */
    set helmDriver(value: string | undefined);
    /**
     * @stability stable
     */
    resetHelmDriver(): void;
    /**
     * @stability stable
     */
    get helmDriverInput(): string | undefined;
    private _pluginsPath?;
    /**
     * @stability stable
     */
    get pluginsPath(): string | undefined;
    /**
     * @stability stable
     */
    set pluginsPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetPluginsPath(): void;
    /**
     * @stability stable
     */
    get pluginsPathInput(): string | undefined;
    private _registryConfigPath?;
    /**
     * @stability stable
     */
    get registryConfigPath(): string | undefined;
    /**
     * @stability stable
     */
    set registryConfigPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegistryConfigPath(): void;
    /**
     * @stability stable
     */
    get registryConfigPathInput(): string | undefined;
    private _repositoryCache?;
    /**
     * @stability stable
     */
    get repositoryCache(): string | undefined;
    /**
     * @stability stable
     */
    set repositoryCache(value: string | undefined);
    /**
     * @stability stable
     */
    resetRepositoryCache(): void;
    /**
     * @stability stable
     */
    get repositoryCacheInput(): string | undefined;
    private _repositoryConfigPath?;
    /**
     * @stability stable
     */
    get repositoryConfigPath(): string | undefined;
    /**
     * @stability stable
     */
    set repositoryConfigPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetRepositoryConfigPath(): void;
    /**
     * @stability stable
     */
    get repositoryConfigPathInput(): string | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    private _experiments?;
    /**
     * @stability stable
     */
    get experiments(): HelmProviderExperiments | undefined;
    /**
     * @stability stable
     */
    set experiments(value: HelmProviderExperiments | undefined);
    /**
     * @stability stable
     */
    resetExperiments(): void;
    /**
     * @stability stable
     */
    get experimentsInput(): HelmProviderExperiments | undefined;
    private _kubernetes?;
    /**
     * @stability stable
     */
    get kubernetes(): HelmProviderKubernetes | undefined;
    /**
     * @stability stable
     */
    set kubernetes(value: HelmProviderKubernetes | undefined);
    /**
     * @stability stable
     */
    resetKubernetes(): void;
    /**
     * @stability stable
     */
    get kubernetesInput(): HelmProviderKubernetes | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
