import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ReleaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * If set, installation process purges chart on fail. The wait flag will be set automatically if atomic is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#atomic Release#atomic}
     *
     * @stability stable
     */
    readonly atomic?: boolean | cdktf.IResolvable;
    /**
     * Chart name to be installed. A path may be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#chart Release#chart}
     *
     * @stability stable
     */
    readonly chart: string;
    /**
     * Allow deletion of new resources created in this upgrade when upgrade fails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#cleanup_on_fail Release#cleanup_on_fail}
     *
     * @stability stable
     */
    readonly cleanupOnFail?: boolean | cdktf.IResolvable;
    /**
     * Create the namespace if it does not exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#create_namespace Release#create_namespace}
     *
     * @stability stable
     */
    readonly createNamespace?: boolean | cdktf.IResolvable;
    /**
     * Run helm dependency update before installing the chart.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#dependency_update Release#dependency_update}
     *
     * @stability stable
     */
    readonly dependencyUpdate?: boolean | cdktf.IResolvable;
    /**
     * Add a custom description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#description Release#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#devel Release#devel}
     *
     * @stability stable
     */
    readonly devel?: boolean | cdktf.IResolvable;
    /**
     * Prevent CRD hooks from, running, but run other hooks.  See helm install --no-crd-hook.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#disable_crd_hooks Release#disable_crd_hooks}
     *
     * @stability stable
     */
    readonly disableCrdHooks?: boolean | cdktf.IResolvable;
    /**
     * If set, the installation process will not validate rendered templates against the Kubernetes OpenAPI Schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#disable_openapi_validation Release#disable_openapi_validation}
     *
     * @stability stable
     */
    readonly disableOpenapiValidation?: boolean | cdktf.IResolvable;
    /**
     * Prevent hooks from running.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#disable_webhooks Release#disable_webhooks}
     *
     * @stability stable
     */
    readonly disableWebhooks?: boolean | cdktf.IResolvable;
    /**
     * Force resource update through delete/recreate if needed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#force_update Release#force_update}
     *
     * @stability stable
     */
    readonly forceUpdate?: boolean | cdktf.IResolvable;
    /**
     * Location of public keys used for verification. Used only if `verify` is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#keyring Release#keyring}
     *
     * @stability stable
     */
    readonly keyring?: string;
    /**
     * Run helm lint when planning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#lint Release#lint}
     *
     * @stability stable
     */
    readonly lint?: boolean | cdktf.IResolvable;
    /**
     * Limit the maximum number of revisions saved per release. Use 0 for no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#max_history Release#max_history}
     *
     * @stability stable
     */
    readonly maxHistory?: number;
    /**
     * Release name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#name Release#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Namespace to install the release into.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#namespace Release#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * Perform pods restart during upgrade/rollback.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#recreate_pods Release#recreate_pods}
     *
     * @stability stable
     */
    readonly recreatePods?: boolean | cdktf.IResolvable;
    /**
     * If set, render subchart notes along with the parent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#render_subchart_notes Release#render_subchart_notes}
     *
     * @stability stable
     */
    readonly renderSubchartNotes?: boolean | cdktf.IResolvable;
    /**
     * Re-use the given name, even if that name is already used. This is unsafe in production.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#replace Release#replace}
     *
     * @stability stable
     */
    readonly replace?: boolean | cdktf.IResolvable;
    /**
     * Repository where to locate the requested chart. If is a URL the chart is installed without installing the repository.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#repository Release#repository}
     *
     * @stability stable
     */
    readonly repository?: string;
    /**
     * The Repositories CA File.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#repository_ca_file Release#repository_ca_file}
     *
     * @stability stable
     */
    readonly repositoryCaFile?: string;
    /**
     * The repositories cert file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#repository_cert_file Release#repository_cert_file}
     *
     * @stability stable
     */
    readonly repositoryCertFile?: string;
    /**
     * The repositories cert key file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#repository_key_file Release#repository_key_file}
     *
     * @stability stable
     */
    readonly repositoryKeyFile?: string;
    /**
     * Password for HTTP basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#repository_password Release#repository_password}
     *
     * @stability stable
     */
    readonly repositoryPassword?: string;
    /**
     * Username for HTTP basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#repository_username Release#repository_username}
     *
     * @stability stable
     */
    readonly repositoryUsername?: string;
    /**
     * When upgrading, reset the values to the ones built into the chart.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#reset_values Release#reset_values}
     *
     * @stability stable
     */
    readonly resetValues?: boolean | cdktf.IResolvable;
    /**
     * When upgrading, reuse the last release's values and merge in any overrides. If 'reset_values' is specified, this is ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#reuse_values Release#reuse_values}
     *
     * @stability stable
     */
    readonly reuseValues?: boolean | cdktf.IResolvable;
    /**
     * If set, no CRDs will be installed. By default, CRDs are installed if not already present.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#skip_crds Release#skip_crds}
     *
     * @stability stable
     */
    readonly skipCrds?: boolean | cdktf.IResolvable;
    /**
     * Time in seconds to wait for any individual kubernetes operation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#timeout Release#timeout}
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * List of values in raw yaml format to pass to helm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#values Release#values}
     *
     * @stability stable
     */
    readonly values?: string[];
    /**
     * Verify the package before installing it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#verify Release#verify}
     *
     * @stability stable
     */
    readonly verify?: boolean | cdktf.IResolvable;
    /**
     * Specify the exact chart version to install. If this is not specified, the latest version is installed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#version Release#version}
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * Will wait until all resources are in a ready state before marking the release as successful.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#wait Release#wait}
     *
     * @stability stable
     */
    readonly wait?: boolean | cdktf.IResolvable;
    /**
     * If wait is enabled, will wait until all Jobs have been completed before marking the release as successful.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#wait_for_jobs Release#wait_for_jobs}
     *
     * @stability stable
     */
    readonly waitForJobs?: boolean | cdktf.IResolvable;
    /**
     * postrender block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#postrender Release#postrender}
     *
     * @stability stable
     */
    readonly postrender?: ReleasePostrender;
    /**
     * set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#set Release#set}
     *
     * @stability stable
     */
    readonly set?: ReleaseSet[];
    /**
     * set_sensitive block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#set_sensitive Release#set_sensitive}
     *
     * @stability stable
     */
    readonly setSensitive?: ReleaseSetSensitive[];
}
/**
 * @stability stable
 */
export declare class ReleaseMetadata extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get appVersion(): string;
    /**
     * @stability stable
     */
    get chart(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    get revision(): number;
    /**
     * @stability stable
     */
    get values(): string;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export interface ReleasePostrender {
    /**
     * The command binary path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#binary_path Release#binary_path}
     *
     * @stability stable
     */
    readonly binaryPath: string;
}
export declare function releasePostrenderToTerraform(struct?: ReleasePostrenderOutputReference | ReleasePostrender): any;
/**
 * @stability stable
 */
export declare class ReleasePostrenderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ReleasePostrender | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ReleasePostrender | undefined);
    private _binaryPath?;
    /**
     * @stability stable
     */
    get binaryPath(): string;
    /**
     * @stability stable
     */
    set binaryPath(value: string);
    /**
     * @stability stable
     */
    get binaryPathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ReleaseSet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#name Release#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#type Release#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#value Release#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function releaseSetToTerraform(struct?: ReleaseSet): any;
/**
 * @stability stable
 */
export interface ReleaseSetSensitive {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#name Release#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#type Release#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/r/release.html#value Release#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function releaseSetSensitiveToTerraform(struct?: ReleaseSetSensitive): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/helm/r/release.html helm_release}.
 *
 * @stability stable
 */
export declare class Release extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/helm/r/release.html helm_release} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ReleaseConfig);
    private _atomic?;
    /**
     * @stability stable
     */
    get atomic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set atomic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAtomic(): void;
    /**
     * @stability stable
     */
    get atomicInput(): boolean | cdktf.IResolvable | undefined;
    private _chart?;
    /**
     * @stability stable
     */
    get chart(): string;
    /**
     * @stability stable
     */
    set chart(value: string);
    /**
     * @stability stable
     */
    get chartInput(): string | undefined;
    private _cleanupOnFail?;
    /**
     * @stability stable
     */
    get cleanupOnFail(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set cleanupOnFail(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCleanupOnFail(): void;
    /**
     * @stability stable
     */
    get cleanupOnFailInput(): boolean | cdktf.IResolvable | undefined;
    private _createNamespace?;
    /**
     * @stability stable
     */
    get createNamespace(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set createNamespace(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCreateNamespace(): void;
    /**
     * @stability stable
     */
    get createNamespaceInput(): boolean | cdktf.IResolvable | undefined;
    private _dependencyUpdate?;
    /**
     * @stability stable
     */
    get dependencyUpdate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dependencyUpdate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDependencyUpdate(): void;
    /**
     * @stability stable
     */
    get dependencyUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _devel?;
    /**
     * @stability stable
     */
    get devel(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set devel(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDevel(): void;
    /**
     * @stability stable
     */
    get develInput(): boolean | cdktf.IResolvable | undefined;
    private _disableCrdHooks?;
    /**
     * @stability stable
     */
    get disableCrdHooks(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableCrdHooks(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableCrdHooks(): void;
    /**
     * @stability stable
     */
    get disableCrdHooksInput(): boolean | cdktf.IResolvable | undefined;
    private _disableOpenapiValidation?;
    /**
     * @stability stable
     */
    get disableOpenapiValidation(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableOpenapiValidation(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableOpenapiValidation(): void;
    /**
     * @stability stable
     */
    get disableOpenapiValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _disableWebhooks?;
    /**
     * @stability stable
     */
    get disableWebhooks(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableWebhooks(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableWebhooks(): void;
    /**
     * @stability stable
     */
    get disableWebhooksInput(): boolean | cdktf.IResolvable | undefined;
    private _forceUpdate?;
    /**
     * @stability stable
     */
    get forceUpdate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forceUpdate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForceUpdate(): void;
    /**
     * @stability stable
     */
    get forceUpdateInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyring?;
    /**
     * @stability stable
     */
    get keyring(): string;
    /**
     * @stability stable
     */
    set keyring(value: string);
    /**
     * @stability stable
     */
    resetKeyring(): void;
    /**
     * @stability stable
     */
    get keyringInput(): string | undefined;
    private _lint?;
    /**
     * @stability stable
     */
    get lint(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set lint(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLint(): void;
    /**
     * @stability stable
     */
    get lintInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get manifest(): string;
    private _maxHistory?;
    /**
     * @stability stable
     */
    get maxHistory(): number;
    /**
     * @stability stable
     */
    set maxHistory(value: number);
    /**
     * @stability stable
     */
    resetMaxHistory(): void;
    /**
     * @stability stable
     */
    get maxHistoryInput(): number | undefined;
    /**
     * @stability stable
     */
    metadata(index: string): ReleaseMetadata;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    set namespace(value: string);
    /**
     * @stability stable
     */
    resetNamespace(): void;
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
    private _recreatePods?;
    /**
     * @stability stable
     */
    get recreatePods(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set recreatePods(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRecreatePods(): void;
    /**
     * @stability stable
     */
    get recreatePodsInput(): boolean | cdktf.IResolvable | undefined;
    private _renderSubchartNotes?;
    /**
     * @stability stable
     */
    get renderSubchartNotes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set renderSubchartNotes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRenderSubchartNotes(): void;
    /**
     * @stability stable
     */
    get renderSubchartNotesInput(): boolean | cdktf.IResolvable | undefined;
    private _replace?;
    /**
     * @stability stable
     */
    get replace(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set replace(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReplace(): void;
    /**
     * @stability stable
     */
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
    private _repository?;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    resetRepository(): void;
    /**
     * @stability stable
     */
    get repositoryInput(): string | undefined;
    private _repositoryCaFile?;
    /**
     * @stability stable
     */
    get repositoryCaFile(): string;
    /**
     * @stability stable
     */
    set repositoryCaFile(value: string);
    /**
     * @stability stable
     */
    resetRepositoryCaFile(): void;
    /**
     * @stability stable
     */
    get repositoryCaFileInput(): string | undefined;
    private _repositoryCertFile?;
    /**
     * @stability stable
     */
    get repositoryCertFile(): string;
    /**
     * @stability stable
     */
    set repositoryCertFile(value: string);
    /**
     * @stability stable
     */
    resetRepositoryCertFile(): void;
    /**
     * @stability stable
     */
    get repositoryCertFileInput(): string | undefined;
    private _repositoryKeyFile?;
    /**
     * @stability stable
     */
    get repositoryKeyFile(): string;
    /**
     * @stability stable
     */
    set repositoryKeyFile(value: string);
    /**
     * @stability stable
     */
    resetRepositoryKeyFile(): void;
    /**
     * @stability stable
     */
    get repositoryKeyFileInput(): string | undefined;
    private _repositoryPassword?;
    /**
     * @stability stable
     */
    get repositoryPassword(): string;
    /**
     * @stability stable
     */
    set repositoryPassword(value: string);
    /**
     * @stability stable
     */
    resetRepositoryPassword(): void;
    /**
     * @stability stable
     */
    get repositoryPasswordInput(): string | undefined;
    private _repositoryUsername?;
    /**
     * @stability stable
     */
    get repositoryUsername(): string;
    /**
     * @stability stable
     */
    set repositoryUsername(value: string);
    /**
     * @stability stable
     */
    resetRepositoryUsername(): void;
    /**
     * @stability stable
     */
    get repositoryUsernameInput(): string | undefined;
    private _resetValues?;
    /**
     * @stability stable
     */
    get resetValues(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set resetValues(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetResetValues(): void;
    /**
     * @stability stable
     */
    get resetValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _reuseValues?;
    /**
     * @stability stable
     */
    get reuseValues(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set reuseValues(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReuseValues(): void;
    /**
     * @stability stable
     */
    get reuseValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _skipCrds?;
    /**
     * @stability stable
     */
    get skipCrds(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipCrds(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipCrds(): void;
    /**
     * @stability stable
     */
    get skipCrdsInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number;
    /**
     * @stability stable
     */
    set timeout(value: number);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    resetTfValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
    private _verify?;
    /**
     * @stability stable
     */
    get verify(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set verify(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVerify(): void;
    /**
     * @stability stable
     */
    get verifyInput(): boolean | cdktf.IResolvable | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _wait?;
    /**
     * @stability stable
     */
    get wait(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set wait(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWait(): void;
    /**
     * @stability stable
     */
    get waitInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForJobs?;
    /**
     * @stability stable
     */
    get waitForJobs(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set waitForJobs(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWaitForJobs(): void;
    /**
     * @stability stable
     */
    get waitForJobsInput(): boolean | cdktf.IResolvable | undefined;
    private _postrender;
    /**
     * @stability stable
     */
    get postrender(): ReleasePostrenderOutputReference;
    /**
     * @stability stable
     */
    putPostrender(value: ReleasePostrender): void;
    /**
     * @stability stable
     */
    resetPostrender(): void;
    /**
     * @stability stable
     */
    get postrenderInput(): ReleasePostrender | undefined;
    private _set?;
    /**
     * @stability stable
     */
    get set(): ReleaseSet[];
    /**
     * @stability stable
     */
    set set(value: ReleaseSet[]);
    /**
     * @stability stable
     */
    resetSet(): void;
    /**
     * @stability stable
     */
    get setInput(): ReleaseSet[] | undefined;
    private _setSensitive?;
    /**
     * @stability stable
     */
    get setSensitive(): ReleaseSetSensitive[];
    /**
     * @stability stable
     */
    set setSensitive(value: ReleaseSetSensitive[]);
    /**
     * @stability stable
     */
    resetSetSensitive(): void;
    /**
     * @stability stable
     */
    get setSensitiveInput(): ReleaseSetSensitive[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
