# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))

from datetime import date

import sphinx_rtd_theme

# -- Project information -----------------------------------------------------

project = "TISTOS for HLT"
copyright = (
    f'2024-{date.today().strftime("%Y")}, LHCb Collaboration'
    if date.today().strftime("%Y") != "2024"
    else f"2024, LHCb Collaboration"
)
author = "Jamie Gooding"


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx_rtd_theme",
    "sphinx.ext.autodoc",
    "sphinx.ext.napoleon",
    "sphinx.ext.viewcode",
    "sphinx.ext.mathjax",
    "sphinx.ext.intersphinx",
    "sphinx.ext.autosectionlabel",
]

mathjax_path = (
    "https://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML"
)

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

numfig = True

"""
# Intersphinx
intersphinx_mapping = {
    'allen': ('https://allen-doc.docs.cern.ch/', None),
    'davinci': ('https://lhcb-davinci.docs.cern.ch/', None),
    'lbap': ('https://lhcb-ap.docs.cern.ch/', None),
    'moore': ('https://lhcbdoc.web.cern.ch/lhcbdoc/moore/master/', None),
    'starterkit': ('https://lhcb.github.io/starterkit-lessons/', None),
}
"""

# Autosectionlabel
autosectionlabel_prefix_document = True

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

html_context = {
    # Show the "Edit on GitLab" link instead of "View Source"
    "display_gitlab": True,
    "gitlab_host": "gitlab.cern.ch",
    "gitlab_user": "lhcb-rta",
    "gitlab_repo": "triggercalib",
    "gitlab_version": "master/source/",
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]
html_css_files = [
    "custom.css",
]
