# mypy-boto3-dynamodbstreams

[![PyPI - mypy-boto3-dynamodbstreams](https://img.shields.io/pypi/v/mypy-boto3-dynamodbstreams.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodbstreams)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dynamodbstreams.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodbstreams)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DynamoDBStreams 1.17.1](https://boto3.amazonaws.com/v1/documentation/api/1.17.1/reference/services/dynamodbstreams.html#DynamoDBStreams) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-dynamodbstreams](#mypy-boto3-dynamodbstreams)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `DynamoDBStreams` service.

```bash
python -m pip install boto3-stubs[dynamodbstreams]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[dynamodbstreams]` in your environment: `python -m pip install 'boto3-stubs[dynamodbstreams]'`

Both type checking and auto-complete should work for `DynamoDBStreams` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[dynamodbstreams]` in your environment: `python -m pip install 'boto3-stubs[dynamodbstreams]'`

Both type checking and auto-complete should work for `DynamoDBStreams` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[dynamodbstreams]` in your environment: `python -m pip install 'boto3-stubs[dynamodbstreams]'`
- Run `mypy` as usual

Type checking should work for `DynamoDBStreams` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[dynamodbstreams]` in your environment: `python -m pip install 'boto3-stubs[dynamodbstreams]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DynamoDBStreams` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`DynamoDBStreamsClient` provides annotations for `boto3.client("dynamodbstreams")`.

```python
import boto3

from mypy_boto3_dynamodbstreams import DynamoDBStreamsClient

client: DynamoDBStreamsClient = boto3.client("dynamodbstreams")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DynamoDBStreamsClient = session.client("dynamodbstreams")
```








### Typed dictionations

`mypy_boto3_dynamodbstreams.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_dynamodbstreams.type_defs import (
    AttributeValueTypeDef,
    DescribeStreamOutputTypeDef,
    GetRecordsOutputTypeDef,
    GetShardIteratorOutputTypeDef,
    IdentityTypeDef,
    KeySchemaElementTypeDef,
    ListStreamsOutputTypeDef,
    RecordTypeDef,
    ResponseMetadata,
    SequenceNumberRangeTypeDef,
    ShardTypeDef,
    StreamDescriptionTypeDef,
    StreamRecordTypeDef,
    StreamTypeDef,
)

def get_structure() -> IdentityTypeDef:
    return {
      ...
    }
```
