#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2015-2017:
#   Frederic Mohier, frederic.mohier@alignak.net
#
# This file is part of (WebUI).
#
# (WebUI) is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# (WebUI) is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with (WebUI).  If not, see <http://www.gnu.org/licenses/>.

"""
    Plugin Currently
"""

from logging import getLogger

from bottle import request

from alignak_webui import _
from alignak_webui.utils.plugin import Plugin

# pylint: disable=invalid-name
logger = getLogger(__name__)


class PluginCurrently(Plugin):
    """ Currently plugin """

    def __init__(self, app, cfg_filenames=None):
        """
        Currently plugin
        """
        self.name = 'Currently'
        self.backend_endpoint = None

        self.pages = {
            'get_currently': {
                'name': 'Currently',
                'route': '/currently',
                'view': 'currently'
            }
        }

        super(PluginCurrently, self).__init__(app, cfg_filenames)

    def get_currently(self):  # pylint:disable=no-self-use
        """
        Display currently page
        """
        user = request.environ['beaker.session']['current_user']
        datamgr = request.app.datamgr

        # Get the stored panels
        currently_panels = datamgr.get_user_preferences(user, 'currently_panels', None)

        # Get the stored graphs
        currently_graphs = datamgr.get_user_preferences(user, 'currently_graphs', None)

        # Live state stored queuers
        # hosts_states_queue = datamgr.get_user_preferences(user, 'hosts_states_queue', [])
        # services_states_queue = datamgr.get_user_preferences(user, 'services_states_queue', [])
        ls_history = datamgr.get_livesynthesis({'history': 'yes'})
        history = {
            u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'_realm': u'5894fb076376e9ab7e669699', u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0,
            u'_links': {u'self': {u'href': u'livesynthesis/5894fba46376e9aea4223220', u'title': u'Livesynthesi'}, u'parent': {u'href': u'/', u'title': u'home'}, u'collection': {u'href': u'livesynthesis?max_results=50', u'title': u'livesynthesis'}},
            u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11,
            u'_updated': u'Fri, 03 Feb 2017 21:52:36 GMT',
            u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0,
            u'_created': u'Thu, 01 Jan 1970 00:00:00 GMT', u'_id': u'5894fba46376e9aea4223220', u'_etag': u'8e532225a05c63fd55d4fe566401219298b2f500',
            u'history': [
                {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:32:17 GMT'},
                {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:31:17 GMT'},
                {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:30:17 GMT'},
                {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:29:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:28:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:27:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:26:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 1, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:25:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 1, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:24:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:23:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:22:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:21:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:20:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:19:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:18:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:17:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:16:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:15:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:14:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:13:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:12:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:11:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:10:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:09:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:08:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:07:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:06:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:05:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:04:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 1, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:03:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 1, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:02:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 1, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:01:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 1, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 11:00:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 1, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:59:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:58:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:57:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:56:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:55:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:54:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:53:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:52:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:51:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:50:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:49:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:48:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:47:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 82, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:46:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 1, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:45:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 1, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:44:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 1, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:43:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 1, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:42:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 1, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 81, u'hosts_unreachable_hard': 0, u'services_critical_soft': 0, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:41:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 1, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 79, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:40:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 1, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 79, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:39:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:38:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:37:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 1, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:36:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 79, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:35:17 GMT'}, {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 79, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 12, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:34:17 GMT'},
                {u'services_acknowledged': 5, u'services_unreachable_soft': 0, u'hosts_up_soft': 0, u'services_warning_hard': 0, u'services_flapping': 0, u'hosts_down_soft': 0, u'services_warning_soft': 0, u'hosts_acknowledged': 0, u'hosts_down_hard': 0, u'hosts_flapping': 0, u'services_total': 111, u'hosts_in_downtime': 1, u'hosts_business_impact': 0, u'services_unreachable_hard': 8, u'services_ok_hard': 80, u'hosts_unreachable_hard': 0, u'services_critical_soft': 2, u'services_business_impact': 0, u'hosts_unreachable_soft': 0, u'services_critical_hard': 11, u'hosts_up_hard': 4, u'hosts_total': 5, u'services_unknown_soft': 0, u'services_ok_soft': 0, u'services_unknown_hard': 5, u'services_in_downtime': 0, u'_created': u'Mon, 06 Feb 2017 10:33:17 GMT'}
            ]
        }
        for ls in ls_history:
            logger.warning("ls: %s", ls)

        hosts_states_queue = lv['hosts_synthesis']
        logger.warning("Hosts state queue: %s", hosts_states_queue)
        services_states_queue = lv['services_synthesis']

        return {
            'currently_panels': currently_panels,
            'currently_graphs': currently_graphs,
            'hosts_states_queue': hosts_states_queue,
            'services_states_queue': services_states_queue,
            'title': request.query.get('title', _('Keep an eye'))
        }
