# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GcpOrgVpcPeeringConnectionArgs', 'GcpOrgVpcPeeringConnection']

@pulumi.input_type
class GcpOrgVpcPeeringConnectionArgs:
    def __init__(__self__, *,
                 gcp_project_id: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str],
                 organization_vpc_id: pulumi.Input[_builtins.str],
                 peer_vpc: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a GcpOrgVpcPeeringConnection resource.
        :param pulumi.Input[_builtins.str] gcp_project_id: Google Cloud project ID. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: Identifier of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: Identifier of the organization VPC.
        :param pulumi.Input[_builtins.str] peer_vpc: Google Cloud VPC network name. Changing this property forces recreation of the resource.
        """
        pulumi.set(__self__, "gcp_project_id", gcp_project_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "organization_vpc_id", organization_vpc_id)
        pulumi.set(__self__, "peer_vpc", peer_vpc)

    @_builtins.property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Google Cloud project ID. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "gcp_project_id")

    @gcp_project_id.setter
    def gcp_project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gcp_project_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationVpcId")
    def organization_vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the organization VPC.
        """
        return pulumi.get(self, "organization_vpc_id")

    @organization_vpc_id.setter
    def organization_vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="peerVpc")
    def peer_vpc(self) -> pulumi.Input[_builtins.str]:
        """
        Google Cloud VPC network name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_vpc")

    @peer_vpc.setter
    def peer_vpc(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_vpc", value)


@pulumi.input_type
class _GcpOrgVpcPeeringConnectionState:
    def __init__(__self__, *,
                 gcp_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_vpc: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GcpOrgVpcPeeringConnection resources.
        :param pulumi.Input[_builtins.str] gcp_project_id: Google Cloud project ID. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: Identifier of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: Identifier of the organization VPC.
        :param pulumi.Input[_builtins.str] peer_vpc: Google Cloud VPC network name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] self_link: Computed Google Cloud network peering link.
        :param pulumi.Input[_builtins.str] state: State of the peering connection.
        """
        if gcp_project_id is not None:
            pulumi.set(__self__, "gcp_project_id", gcp_project_id)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if organization_vpc_id is not None:
            pulumi.set(__self__, "organization_vpc_id", organization_vpc_id)
        if peer_vpc is not None:
            pulumi.set(__self__, "peer_vpc", peer_vpc)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Google Cloud project ID. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "gcp_project_id")

    @gcp_project_id.setter
    def gcp_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_project_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationVpcId")
    def organization_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the organization VPC.
        """
        return pulumi.get(self, "organization_vpc_id")

    @organization_vpc_id.setter
    def organization_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="peerVpc")
    def peer_vpc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Google Cloud VPC network name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_vpc")

    @peer_vpc.setter
    def peer_vpc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_vpc", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Computed Google Cloud network peering link.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the peering connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("aiven:index/gcpOrgVpcPeeringConnection:GcpOrgVpcPeeringConnection")
class GcpOrgVpcPeeringConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gcp_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_vpc: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages a Google Cloud VPC peering connection.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_vpc = aiven.OrganizationVpc("example_vpc",
            organization_id=example_aiven_organization["id"],
            cloud_name="google-europe-west10",
            network_cidr="10.0.0.0/24")
        example = aiven.GcpOrgVpcPeeringConnection("example",
            organization_id=example_vpc.organization_id,
            organization_vpc_id=example_vpc.organization_vpc_id,
            gcp_project_id="my-gcp-project-123",
            peer_vpc="my-vpc-network")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/gcpOrgVpcPeeringConnection:GcpOrgVpcPeeringConnection example ORGANIZATION_ID/ORGANIZATION_VPC_ID/GCP_PROJECT_ID/VPC_NAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gcp_project_id: Google Cloud project ID. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: Identifier of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: Identifier of the organization VPC.
        :param pulumi.Input[_builtins.str] peer_vpc: Google Cloud VPC network name. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpOrgVpcPeeringConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages a Google Cloud VPC peering connection.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_vpc = aiven.OrganizationVpc("example_vpc",
            organization_id=example_aiven_organization["id"],
            cloud_name="google-europe-west10",
            network_cidr="10.0.0.0/24")
        example = aiven.GcpOrgVpcPeeringConnection("example",
            organization_id=example_vpc.organization_id,
            organization_vpc_id=example_vpc.organization_vpc_id,
            gcp_project_id="my-gcp-project-123",
            peer_vpc="my-vpc-network")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/gcpOrgVpcPeeringConnection:GcpOrgVpcPeeringConnection example ORGANIZATION_ID/ORGANIZATION_VPC_ID/GCP_PROJECT_ID/VPC_NAME
        ```

        :param str resource_name: The name of the resource.
        :param GcpOrgVpcPeeringConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpOrgVpcPeeringConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gcp_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_vpc: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpOrgVpcPeeringConnectionArgs.__new__(GcpOrgVpcPeeringConnectionArgs)

            if gcp_project_id is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_project_id'")
            __props__.__dict__["gcp_project_id"] = gcp_project_id
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if organization_vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_vpc_id'")
            __props__.__dict__["organization_vpc_id"] = organization_vpc_id
            if peer_vpc is None and not opts.urn:
                raise TypeError("Missing required property 'peer_vpc'")
            __props__.__dict__["peer_vpc"] = peer_vpc
            __props__.__dict__["self_link"] = None
            __props__.__dict__["state"] = None
        super(GcpOrgVpcPeeringConnection, __self__).__init__(
            'aiven:index/gcpOrgVpcPeeringConnection:GcpOrgVpcPeeringConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gcp_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            peer_vpc: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'GcpOrgVpcPeeringConnection':
        """
        Get an existing GcpOrgVpcPeeringConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gcp_project_id: Google Cloud project ID. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: Identifier of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: Identifier of the organization VPC.
        :param pulumi.Input[_builtins.str] peer_vpc: Google Cloud VPC network name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] self_link: Computed Google Cloud network peering link.
        :param pulumi.Input[_builtins.str] state: State of the peering connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpOrgVpcPeeringConnectionState.__new__(_GcpOrgVpcPeeringConnectionState)

        __props__.__dict__["gcp_project_id"] = gcp_project_id
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["organization_vpc_id"] = organization_vpc_id
        __props__.__dict__["peer_vpc"] = peer_vpc
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["state"] = state
        return GcpOrgVpcPeeringConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Google Cloud project ID. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "gcp_project_id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the organization.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="organizationVpcId")
    def organization_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the organization VPC.
        """
        return pulumi.get(self, "organization_vpc_id")

    @_builtins.property
    @pulumi.getter(name="peerVpc")
    def peer_vpc(self) -> pulumi.Output[_builtins.str]:
        """
        Google Cloud VPC network name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_vpc")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        Computed Google Cloud network peering link.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the peering connection.
        """
        return pulumi.get(self, "state")

