# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetExternalIdentityResult',
    'AwaitableGetExternalIdentityResult',
    'get_external_identity',
    'get_external_identity_output',
]

@pulumi.output_type
class GetExternalIdentityResult:
    """
    A collection of values returned by getExternalIdentity.
    """
    def __init__(__self__, external_service_name=None, external_user_id=None, id=None, internal_user_id=None, organization_id=None):
        if external_service_name and not isinstance(external_service_name, str):
            raise TypeError("Expected argument 'external_service_name' to be a str")
        pulumi.set(__self__, "external_service_name", external_service_name)
        if external_user_id and not isinstance(external_user_id, str):
            raise TypeError("Expected argument 'external_user_id' to be a str")
        pulumi.set(__self__, "external_user_id", external_user_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_user_id and not isinstance(internal_user_id, str):
            raise TypeError("Expected argument 'internal_user_id' to be a str")
        pulumi.set(__self__, "internal_user_id", internal_user_id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)

    @_builtins.property
    @pulumi.getter(name="externalServiceName")
    def external_service_name(self) -> _builtins.str:
        """
        The name of the external service. The possible value is `github`.
        """
        return pulumi.get(self, "external_service_name")

    @_builtins.property
    @pulumi.getter(name="externalUserId")
    def external_user_id(self) -> _builtins.str:
        """
        The user's ID on the external service. For GitHub, this is their GitHub username.
        """
        return pulumi.get(self, "external_user_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internalUserId")
    def internal_user_id(self) -> _builtins.str:
        """
        The Aiven user ID.
        """
        return pulumi.get(self, "internal_user_id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The ID of the Aiven organization that the user is part of.
        """
        return pulumi.get(self, "organization_id")


class AwaitableGetExternalIdentityResult(GetExternalIdentityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalIdentityResult(
            external_service_name=self.external_service_name,
            external_user_id=self.external_user_id,
            id=self.id,
            internal_user_id=self.internal_user_id,
            organization_id=self.organization_id)


def get_external_identity(external_service_name: Optional[_builtins.str] = None,
                          external_user_id: Optional[_builtins.str] = None,
                          internal_user_id: Optional[_builtins.str] = None,
                          organization_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalIdentityResult:
    """
    Links external usernames to Aiven users, ensuring that requesters and approvers are correctly identified for Aiven for Apache Kafka® Governance approval workflows.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.


    :param _builtins.str external_service_name: The name of the external service. The possible value is `github`.
    :param _builtins.str external_user_id: The user's ID on the external service. For GitHub, this is their GitHub username.
    :param _builtins.str internal_user_id: The Aiven user ID.
    :param _builtins.str organization_id: The ID of the Aiven organization that the user is part of.
    """
    __args__ = dict()
    __args__['externalServiceName'] = external_service_name
    __args__['externalUserId'] = external_user_id
    __args__['internalUserId'] = internal_user_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getExternalIdentity:getExternalIdentity', __args__, opts=opts, typ=GetExternalIdentityResult).value

    return AwaitableGetExternalIdentityResult(
        external_service_name=pulumi.get(__ret__, 'external_service_name'),
        external_user_id=pulumi.get(__ret__, 'external_user_id'),
        id=pulumi.get(__ret__, 'id'),
        internal_user_id=pulumi.get(__ret__, 'internal_user_id'),
        organization_id=pulumi.get(__ret__, 'organization_id'))
def get_external_identity_output(external_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                 external_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 internal_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalIdentityResult]:
    """
    Links external usernames to Aiven users, ensuring that requesters and approvers are correctly identified for Aiven for Apache Kafka® Governance approval workflows.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.


    :param _builtins.str external_service_name: The name of the external service. The possible value is `github`.
    :param _builtins.str external_user_id: The user's ID on the external service. For GitHub, this is their GitHub username.
    :param _builtins.str internal_user_id: The Aiven user ID.
    :param _builtins.str organization_id: The ID of the Aiven organization that the user is part of.
    """
    __args__ = dict()
    __args__['externalServiceName'] = external_service_name
    __args__['externalUserId'] = external_user_id
    __args__['internalUserId'] = internal_user_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getExternalIdentity:getExternalIdentity', __args__, opts=opts, typ=GetExternalIdentityResult)
    return __ret__.apply(lambda __response__: GetExternalIdentityResult(
        external_service_name=pulumi.get(__response__, 'external_service_name'),
        external_user_id=pulumi.get(__response__, 'external_user_id'),
        id=pulumi.get(__response__, 'id'),
        internal_user_id=pulumi.get(__response__, 'internal_user_id'),
        organization_id=pulumi.get(__response__, 'organization_id')))
