# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetOpenSearchAclRuleResult',
    'AwaitableGetOpenSearchAclRuleResult',
    'get_open_search_acl_rule',
    'get_open_search_acl_rule_output',
]

@pulumi.output_type
class GetOpenSearchAclRuleResult:
    """
    A collection of values returned by getOpenSearchAclRule.
    """
    def __init__(__self__, id=None, index=None, permission=None, project=None, service_name=None, username=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if index and not isinstance(index, str):
            raise TypeError("Expected argument 'index' to be a str")
        pulumi.set(__self__, "index", index)
        if permission and not isinstance(permission, str):
            raise TypeError("Expected argument 'permission' to be a str")
        pulumi.set(__self__, "permission", permission)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.str:
        """
        The index pattern for this ACL rule. Maximum length: `249`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        The permissions for this ACL rule. The possible values are `admin`, `deny`, `read`, `readwrite` and `write`.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username for the OpenSearch user this ACL rule applies to. Maximum length: `40`. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")


class AwaitableGetOpenSearchAclRuleResult(GetOpenSearchAclRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpenSearchAclRuleResult(
            id=self.id,
            index=self.index,
            permission=self.permission,
            project=self.project,
            service_name=self.service_name,
            username=self.username)


def get_open_search_acl_rule(index: Optional[_builtins.str] = None,
                             permission: Optional[_builtins.str] = None,
                             project: Optional[_builtins.str] = None,
                             service_name: Optional[_builtins.str] = None,
                             username: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpenSearchAclRuleResult:
    """
    Gets information about an Aiven for OpenSearch® ACL rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    os_acl_rule = aiven.get_open_search_acl_rule(project=example_project["project"],
        service_name=example_opensearch["serviceName"],
        username="documentation-user-1",
        index="index5")
    ```


    :param _builtins.str index: The index pattern for this ACL rule. Maximum length: `249`. Changing this property forces recreation of the resource.
    :param _builtins.str permission: The permissions for this ACL rule. The possible values are `admin`, `deny`, `read`, `readwrite` and `write`.
    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str username: The username for the OpenSearch user this ACL rule applies to. Maximum length: `40`. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['index'] = index
    __args__['permission'] = permission
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getOpenSearchAclRule:getOpenSearchAclRule', __args__, opts=opts, typ=GetOpenSearchAclRuleResult).value

    return AwaitableGetOpenSearchAclRuleResult(
        id=pulumi.get(__ret__, 'id'),
        index=pulumi.get(__ret__, 'index'),
        permission=pulumi.get(__ret__, 'permission'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'),
        username=pulumi.get(__ret__, 'username'))
def get_open_search_acl_rule_output(index: Optional[pulumi.Input[_builtins.str]] = None,
                                    permission: Optional[pulumi.Input[_builtins.str]] = None,
                                    project: Optional[pulumi.Input[_builtins.str]] = None,
                                    service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    username: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOpenSearchAclRuleResult]:
    """
    Gets information about an Aiven for OpenSearch® ACL rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    os_acl_rule = aiven.get_open_search_acl_rule(project=example_project["project"],
        service_name=example_opensearch["serviceName"],
        username="documentation-user-1",
        index="index5")
    ```


    :param _builtins.str index: The index pattern for this ACL rule. Maximum length: `249`. Changing this property forces recreation of the resource.
    :param _builtins.str permission: The permissions for this ACL rule. The possible values are `admin`, `deny`, `read`, `readwrite` and `write`.
    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str username: The username for the OpenSearch user this ACL rule applies to. Maximum length: `40`. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['index'] = index
    __args__['permission'] = permission
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getOpenSearchAclRule:getOpenSearchAclRule', __args__, opts=opts, typ=GetOpenSearchAclRuleResult)
    return __ret__.apply(lambda __response__: GetOpenSearchAclRuleResult(
        id=pulumi.get(__response__, 'id'),
        index=pulumi.get(__response__, 'index'),
        permission=pulumi.get(__response__, 'permission'),
        project=pulumi.get(__response__, 'project'),
        service_name=pulumi.get(__response__, 'service_name'),
        username=pulumi.get(__response__, 'username')))
