# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaConnectorArgs', 'KafkaConnector']

@pulumi.input_type
class KafkaConnectorArgs:
    def __init__(__self__, *,
                 config: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 connector_name: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a KafkaConnector resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: The Kafka connector configuration parameters.
        :param pulumi.Input[_builtins.str] connector_name: The Kafka connector name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "connector_name", connector_name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        The Kafka connector configuration parameters.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Kafka connector name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "connector_name")

    @connector_name.setter
    def connector_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connector_name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _KafkaConnectorState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 connector_name: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_author: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_class: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_doc_url: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_title: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_type: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaConnectorTaskArgs']]]] = None):
        """
        Input properties used for looking up and filtering KafkaConnector resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: The Kafka connector configuration parameters.
        :param pulumi.Input[_builtins.str] connector_name: The Kafka connector name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] plugin_author: The Kafka connector author.
        :param pulumi.Input[_builtins.str] plugin_class: The Kafka connector Java class.
        :param pulumi.Input[_builtins.str] plugin_doc_url: The Kafka connector documentation URL.
        :param pulumi.Input[_builtins.str] plugin_title: The Kafka connector title.
        :param pulumi.Input[_builtins.str] plugin_type: The Kafka connector type.
        :param pulumi.Input[_builtins.str] plugin_version: The version of the Kafka connector.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaConnectorTaskArgs']]] tasks: List of tasks of a connector.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if connector_name is not None:
            pulumi.set(__self__, "connector_name", connector_name)
        if plugin_author is not None:
            pulumi.set(__self__, "plugin_author", plugin_author)
        if plugin_class is not None:
            pulumi.set(__self__, "plugin_class", plugin_class)
        if plugin_doc_url is not None:
            pulumi.set(__self__, "plugin_doc_url", plugin_doc_url)
        if plugin_title is not None:
            pulumi.set(__self__, "plugin_title", plugin_title)
        if plugin_type is not None:
            pulumi.set(__self__, "plugin_type", plugin_type)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The Kafka connector configuration parameters.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kafka connector name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "connector_name")

    @connector_name.setter
    def connector_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_name", value)

    @_builtins.property
    @pulumi.getter(name="pluginAuthor")
    def plugin_author(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kafka connector author.
        """
        return pulumi.get(self, "plugin_author")

    @plugin_author.setter
    def plugin_author(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_author", value)

    @_builtins.property
    @pulumi.getter(name="pluginClass")
    def plugin_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kafka connector Java class.
        """
        return pulumi.get(self, "plugin_class")

    @plugin_class.setter
    def plugin_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_class", value)

    @_builtins.property
    @pulumi.getter(name="pluginDocUrl")
    def plugin_doc_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kafka connector documentation URL.
        """
        return pulumi.get(self, "plugin_doc_url")

    @plugin_doc_url.setter
    def plugin_doc_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_doc_url", value)

    @_builtins.property
    @pulumi.getter(name="pluginTitle")
    def plugin_title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kafka connector title.
        """
        return pulumi.get(self, "plugin_title")

    @plugin_title.setter
    def plugin_title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_title", value)

    @_builtins.property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kafka connector type.
        """
        return pulumi.get(self, "plugin_type")

    @plugin_type.setter
    def plugin_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_type", value)

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the Kafka connector.
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaConnectorTaskArgs']]]]:
        """
        List of tasks of a connector.
        """
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaConnectorTaskArgs']]]]):
        pulumi.set(self, "tasks", value)


@pulumi.type_token("aiven:index/kafkaConnector:KafkaConnector")
class KafkaConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 connector_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Aiven for Apache Kafka® [connectors](https://aiven.io/docs/products/kafka/kafka-connect/concepts/list-of-connector-plugins).
        Source connectors let you import data from an external system into a Kafka topic. Sink connectors let you export data from a topic to an external system.

        You can use connectors with any Aiven for Apache Kafka® service that is integrated with an Aiven for Apache Kafka® Connect service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        kafka_os_connector = aiven.KafkaConnector("kafka-os-connector",
            project=example_project["project"],
            service_name=example_kafka["serviceName"],
            connector_name="kafka-opensearch-connector",
            config={
                "name": "kafka-opensearch-connector",
                "topics": example_topic["topicName"],
                "connector.class": "io.aiven.kafka.connect.opensearch.OpensearchSinkConnector",
                "type.name": "os-connector",
                "connection.url": example_os["serviceUri"],
                "connection.username": example_os["serviceUsername"],
                "connection.password": example_os["servicePassword"],
            })
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/kafkaConnector:KafkaConnector kafka-os-connector PROJECT/SERVICE_NAME/CONNECTOR_NAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: The Kafka connector configuration parameters.
        :param pulumi.Input[_builtins.str] connector_name: The Kafka connector name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Aiven for Apache Kafka® [connectors](https://aiven.io/docs/products/kafka/kafka-connect/concepts/list-of-connector-plugins).
        Source connectors let you import data from an external system into a Kafka topic. Sink connectors let you export data from a topic to an external system.

        You can use connectors with any Aiven for Apache Kafka® service that is integrated with an Aiven for Apache Kafka® Connect service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        kafka_os_connector = aiven.KafkaConnector("kafka-os-connector",
            project=example_project["project"],
            service_name=example_kafka["serviceName"],
            connector_name="kafka-opensearch-connector",
            config={
                "name": "kafka-opensearch-connector",
                "topics": example_topic["topicName"],
                "connector.class": "io.aiven.kafka.connect.opensearch.OpensearchSinkConnector",
                "type.name": "os-connector",
                "connection.url": example_os["serviceUri"],
                "connection.username": example_os["serviceUsername"],
                "connection.password": example_os["servicePassword"],
            })
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/kafkaConnector:KafkaConnector kafka-os-connector PROJECT/SERVICE_NAME/CONNECTOR_NAME
        ```

        :param str resource_name: The name of the resource.
        :param KafkaConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 connector_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaConnectorArgs.__new__(KafkaConnectorArgs)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if connector_name is None and not opts.urn:
                raise TypeError("Missing required property 'connector_name'")
            __props__.__dict__["connector_name"] = connector_name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["plugin_author"] = None
            __props__.__dict__["plugin_class"] = None
            __props__.__dict__["plugin_doc_url"] = None
            __props__.__dict__["plugin_title"] = None
            __props__.__dict__["plugin_type"] = None
            __props__.__dict__["plugin_version"] = None
            __props__.__dict__["tasks"] = None
        super(KafkaConnector, __self__).__init__(
            'aiven:index/kafkaConnector:KafkaConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            connector_name: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_author: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_class: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_doc_url: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_title: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_type: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaConnectorTaskArgs', 'KafkaConnectorTaskArgsDict']]]]] = None) -> 'KafkaConnector':
        """
        Get an existing KafkaConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: The Kafka connector configuration parameters.
        :param pulumi.Input[_builtins.str] connector_name: The Kafka connector name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] plugin_author: The Kafka connector author.
        :param pulumi.Input[_builtins.str] plugin_class: The Kafka connector Java class.
        :param pulumi.Input[_builtins.str] plugin_doc_url: The Kafka connector documentation URL.
        :param pulumi.Input[_builtins.str] plugin_title: The Kafka connector title.
        :param pulumi.Input[_builtins.str] plugin_type: The Kafka connector type.
        :param pulumi.Input[_builtins.str] plugin_version: The version of the Kafka connector.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaConnectorTaskArgs', 'KafkaConnectorTaskArgsDict']]]] tasks: List of tasks of a connector.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaConnectorState.__new__(_KafkaConnectorState)

        __props__.__dict__["config"] = config
        __props__.__dict__["connector_name"] = connector_name
        __props__.__dict__["plugin_author"] = plugin_author
        __props__.__dict__["plugin_class"] = plugin_class
        __props__.__dict__["plugin_doc_url"] = plugin_doc_url
        __props__.__dict__["plugin_title"] = plugin_title
        __props__.__dict__["plugin_type"] = plugin_type
        __props__.__dict__["plugin_version"] = plugin_version
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["tasks"] = tasks
        return KafkaConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The Kafka connector configuration parameters.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Kafka connector name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "connector_name")

    @_builtins.property
    @pulumi.getter(name="pluginAuthor")
    def plugin_author(self) -> pulumi.Output[_builtins.str]:
        """
        The Kafka connector author.
        """
        return pulumi.get(self, "plugin_author")

    @_builtins.property
    @pulumi.getter(name="pluginClass")
    def plugin_class(self) -> pulumi.Output[_builtins.str]:
        """
        The Kafka connector Java class.
        """
        return pulumi.get(self, "plugin_class")

    @_builtins.property
    @pulumi.getter(name="pluginDocUrl")
    def plugin_doc_url(self) -> pulumi.Output[_builtins.str]:
        """
        The Kafka connector documentation URL.
        """
        return pulumi.get(self, "plugin_doc_url")

    @_builtins.property
    @pulumi.getter(name="pluginTitle")
    def plugin_title(self) -> pulumi.Output[_builtins.str]:
        """
        The Kafka connector title.
        """
        return pulumi.get(self, "plugin_title")

    @_builtins.property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Kafka connector type.
        """
        return pulumi.get(self, "plugin_type")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the Kafka connector.
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> pulumi.Output[Sequence['outputs.KafkaConnectorTask']]:
        """
        List of tasks of a connector.
        """
        return pulumi.get(self, "tasks")

