# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.request import TeaRequest
from Tea.exceptions import TeaException
from Tea.core import TeaCore
from typing import Dict

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_tea_fileform.client import Client as FileFormClient
from alibabacloud_tea_xml.client import Client as XMLClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_gpdb20160503 import models as gpdb_20160503_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient
from alibabacloud_tea_fileform import models as file_form_models


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-beijing': 'gpdb.aliyuncs.com',
            'cn-hangzhou': 'gpdb.aliyuncs.com',
            'cn-shanghai': 'gpdb.aliyuncs.com',
            'cn-shenzhen': 'gpdb.aliyuncs.com',
            'cn-hongkong': 'gpdb.aliyuncs.com',
            'ap-southeast-1': 'gpdb.aliyuncs.com',
            'us-west-1': 'gpdb.aliyuncs.com',
            'us-east-1': 'gpdb.aliyuncs.com',
            'cn-hangzhou-finance': 'gpdb.aliyuncs.com',
            'cn-shanghai-finance-1': 'gpdb.aliyuncs.com',
            'cn-shenzhen-finance-1': 'gpdb.aliyuncs.com',
            'cn-qingdao': 'gpdb.aliyuncs.com',
            'cn-north-2-gov-1': 'gpdb.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('gpdb', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def _post_ossobject(
        self,
        bucket_name: str,
        data: dict,
    ) -> dict:
        _request = TeaRequest()
        form = UtilClient.assert_as_map(data)
        boundary = FileFormClient.get_boundary()
        host = UtilClient.assert_as_string(form.get('host'))
        _request.protocol = 'HTTPS'
        _request.method = 'POST'
        _request.pathname = f'/'
        _request.headers = {
            'host': host,
            'date': UtilClient.get_date_utcstring(),
            'user-agent': UtilClient.get_user_agent('')
        }
        _request.headers['content-type'] = f'multipart/form-data; boundary={boundary}'
        _request.body = FileFormClient.to_file_form(form, boundary)
        _last_request = _request
        _response = TeaCore.do_action(_request)
        resp_map = None
        body_str = UtilClient.read_as_string(_response.body)
        if UtilClient.is_4xx(_response.status_code) or UtilClient.is_5xx(_response.status_code):
            resp_map = XMLClient.parse_xml(body_str, None)
            err = UtilClient.assert_as_map(resp_map.get('Error'))
            raise TeaException({
                'code': err.get('Code'),
                'message': err.get('Message'),
                'data': {
                    'httpCode': _response.status_code,
                    'requestId': err.get('RequestId'),
                    'hostId': err.get('HostId')
                }
            })
        resp_map = XMLClient.parse_xml(body_str, None)
        return TeaCore.merge(resp_map)

    async def _post_ossobject_async(
        self,
        bucket_name: str,
        data: dict,
    ) -> dict:
        _request = TeaRequest()
        form = UtilClient.assert_as_map(data)
        boundary = FileFormClient.get_boundary()
        host = UtilClient.assert_as_string(form.get('host'))
        _request.protocol = 'HTTPS'
        _request.method = 'POST'
        _request.pathname = f'/'
        _request.headers = {
            'host': host,
            'date': UtilClient.get_date_utcstring(),
            'user-agent': UtilClient.get_user_agent('')
        }
        _request.headers['content-type'] = f'multipart/form-data; boundary={boundary}'
        _request.body = FileFormClient.to_file_form(form, boundary)
        _last_request = _request
        _response = await TeaCore.async_do_action(_request)
        resp_map = None
        body_str = await UtilClient.read_as_string_async(_response.body)
        if UtilClient.is_4xx(_response.status_code) or UtilClient.is_5xx(_response.status_code):
            resp_map = XMLClient.parse_xml(body_str, None)
            err = UtilClient.assert_as_map(resp_map.get('Error'))
            raise TeaException({
                'code': err.get('Code'),
                'message': err.get('Message'),
                'data': {
                    'httpCode': _response.status_code,
                    'requestId': err.get('RequestId'),
                    'hostId': err.get('HostId')
                }
            })
        resp_map = XMLClient.parse_xml(body_str, None)
        return TeaCore.merge(resp_map)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def allocate_instance_public_connection_with_options(
        self,
        request: gpdb_20160503_models.AllocateInstancePublicConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.AllocateInstancePublicConnectionResponse:
        """
        @summary Allocates a public endpoint for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to apply for a public endpoint for an AnalyticDB for PostgreSQL instance. Both the primary and instance endpoints of an AnalyticDB for PostgreSQL instance can be public endpoints. For more information, see [Endpoints of an instance and its primary coordinator node](https://help.aliyun.com/document_detail/204879.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AllocateInstancePublicConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateInstancePublicConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_type):
            query['AddressType'] = request.address_type
        if not UtilClient.is_unset(request.connection_string_prefix):
            query['ConnectionStringPrefix'] = request.connection_string_prefix
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateInstancePublicConnection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.AllocateInstancePublicConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_instance_public_connection_with_options_async(
        self,
        request: gpdb_20160503_models.AllocateInstancePublicConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.AllocateInstancePublicConnectionResponse:
        """
        @summary Allocates a public endpoint for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to apply for a public endpoint for an AnalyticDB for PostgreSQL instance. Both the primary and instance endpoints of an AnalyticDB for PostgreSQL instance can be public endpoints. For more information, see [Endpoints of an instance and its primary coordinator node](https://help.aliyun.com/document_detail/204879.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AllocateInstancePublicConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateInstancePublicConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_type):
            query['AddressType'] = request.address_type
        if not UtilClient.is_unset(request.connection_string_prefix):
            query['ConnectionStringPrefix'] = request.connection_string_prefix
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateInstancePublicConnection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.AllocateInstancePublicConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_instance_public_connection(
        self,
        request: gpdb_20160503_models.AllocateInstancePublicConnectionRequest,
    ) -> gpdb_20160503_models.AllocateInstancePublicConnectionResponse:
        """
        @summary Allocates a public endpoint for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to apply for a public endpoint for an AnalyticDB for PostgreSQL instance. Both the primary and instance endpoints of an AnalyticDB for PostgreSQL instance can be public endpoints. For more information, see [Endpoints of an instance and its primary coordinator node](https://help.aliyun.com/document_detail/204879.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AllocateInstancePublicConnectionRequest
        @return: AllocateInstancePublicConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_instance_public_connection_with_options(request, runtime)

    async def allocate_instance_public_connection_async(
        self,
        request: gpdb_20160503_models.AllocateInstancePublicConnectionRequest,
    ) -> gpdb_20160503_models.AllocateInstancePublicConnectionResponse:
        """
        @summary Allocates a public endpoint for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to apply for a public endpoint for an AnalyticDB for PostgreSQL instance. Both the primary and instance endpoints of an AnalyticDB for PostgreSQL instance can be public endpoints. For more information, see [Endpoints of an instance and its primary coordinator node](https://help.aliyun.com/document_detail/204879.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AllocateInstancePublicConnectionRequest
        @return: AllocateInstancePublicConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_instance_public_connection_with_options_async(request, runtime)

    def bind_dbresource_group_with_role_with_options(
        self,
        tmp_req: gpdb_20160503_models.BindDBResourceGroupWithRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.BindDBResourceGroupWithRoleResponse:
        """
        @summary Binds a resource group to a database role.
        
        @param tmp_req: BindDBResourceGroupWithRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindDBResourceGroupWithRoleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.BindDBResourceGroupWithRoleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.role_list):
            request.role_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.role_list, 'RoleList', 'simple')
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        if not UtilClient.is_unset(request.role_list_shrink):
            query['RoleList'] = request.role_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindDBResourceGroupWithRole',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.BindDBResourceGroupWithRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def bind_dbresource_group_with_role_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.BindDBResourceGroupWithRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.BindDBResourceGroupWithRoleResponse:
        """
        @summary Binds a resource group to a database role.
        
        @param tmp_req: BindDBResourceGroupWithRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindDBResourceGroupWithRoleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.BindDBResourceGroupWithRoleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.role_list):
            request.role_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.role_list, 'RoleList', 'simple')
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        if not UtilClient.is_unset(request.role_list_shrink):
            query['RoleList'] = request.role_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindDBResourceGroupWithRole',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.BindDBResourceGroupWithRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def bind_dbresource_group_with_role(
        self,
        request: gpdb_20160503_models.BindDBResourceGroupWithRoleRequest,
    ) -> gpdb_20160503_models.BindDBResourceGroupWithRoleResponse:
        """
        @summary Binds a resource group to a database role.
        
        @param request: BindDBResourceGroupWithRoleRequest
        @return: BindDBResourceGroupWithRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.bind_dbresource_group_with_role_with_options(request, runtime)

    async def bind_dbresource_group_with_role_async(
        self,
        request: gpdb_20160503_models.BindDBResourceGroupWithRoleRequest,
    ) -> gpdb_20160503_models.BindDBResourceGroupWithRoleResponse:
        """
        @summary Binds a resource group to a database role.
        
        @param request: BindDBResourceGroupWithRoleRequest
        @return: BindDBResourceGroupWithRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.bind_dbresource_group_with_role_with_options_async(request, runtime)

    def cancel_create_index_job_with_options(
        self,
        request: gpdb_20160503_models.CancelCreateIndexJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CancelCreateIndexJobResponse:
        """
        @summary 取消创建索引任务
        
        @param request: CancelCreateIndexJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCreateIndexJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCreateIndexJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CancelCreateIndexJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_create_index_job_with_options_async(
        self,
        request: gpdb_20160503_models.CancelCreateIndexJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CancelCreateIndexJobResponse:
        """
        @summary 取消创建索引任务
        
        @param request: CancelCreateIndexJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCreateIndexJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCreateIndexJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CancelCreateIndexJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_create_index_job(
        self,
        request: gpdb_20160503_models.CancelCreateIndexJobRequest,
    ) -> gpdb_20160503_models.CancelCreateIndexJobResponse:
        """
        @summary 取消创建索引任务
        
        @param request: CancelCreateIndexJobRequest
        @return: CancelCreateIndexJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_create_index_job_with_options(request, runtime)

    async def cancel_create_index_job_async(
        self,
        request: gpdb_20160503_models.CancelCreateIndexJobRequest,
    ) -> gpdb_20160503_models.CancelCreateIndexJobResponse:
        """
        @summary 取消创建索引任务
        
        @param request: CancelCreateIndexJobRequest
        @return: CancelCreateIndexJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_create_index_job_with_options_async(request, runtime)

    def cancel_upload_document_job_with_options(
        self,
        request: gpdb_20160503_models.CancelUploadDocumentJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CancelUploadDocumentJobResponse:
        """
        @summary Cancels an asynchronous document upload job based on the job ID.
        
        @description This operation is related to the UploadDocumentAsync operation. You can call this operation to cancel a document upload job.
        >  If the canceling operation is complete, failed, or is canceled, you cannot call the operation again. The canceling operation only interrupts the document upload job. To remove the uploaded data, you must manually remove it or call the DeleteCollectionData operation. You can also call the document upload operation to overwrite the data by using the same FileName parameter.
        
        @param request: CancelUploadDocumentJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelUploadDocumentJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        body = {}
        if not UtilClient.is_unset(request.collection):
            body['Collection'] = request.collection
        if not UtilClient.is_unset(request.job_id):
            body['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            body['NamespacePassword'] = request.namespace_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CancelUploadDocumentJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CancelUploadDocumentJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_upload_document_job_with_options_async(
        self,
        request: gpdb_20160503_models.CancelUploadDocumentJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CancelUploadDocumentJobResponse:
        """
        @summary Cancels an asynchronous document upload job based on the job ID.
        
        @description This operation is related to the UploadDocumentAsync operation. You can call this operation to cancel a document upload job.
        >  If the canceling operation is complete, failed, or is canceled, you cannot call the operation again. The canceling operation only interrupts the document upload job. To remove the uploaded data, you must manually remove it or call the DeleteCollectionData operation. You can also call the document upload operation to overwrite the data by using the same FileName parameter.
        
        @param request: CancelUploadDocumentJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelUploadDocumentJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        body = {}
        if not UtilClient.is_unset(request.collection):
            body['Collection'] = request.collection
        if not UtilClient.is_unset(request.job_id):
            body['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            body['NamespacePassword'] = request.namespace_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CancelUploadDocumentJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CancelUploadDocumentJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_upload_document_job(
        self,
        request: gpdb_20160503_models.CancelUploadDocumentJobRequest,
    ) -> gpdb_20160503_models.CancelUploadDocumentJobResponse:
        """
        @summary Cancels an asynchronous document upload job based on the job ID.
        
        @description This operation is related to the UploadDocumentAsync operation. You can call this operation to cancel a document upload job.
        >  If the canceling operation is complete, failed, or is canceled, you cannot call the operation again. The canceling operation only interrupts the document upload job. To remove the uploaded data, you must manually remove it or call the DeleteCollectionData operation. You can also call the document upload operation to overwrite the data by using the same FileName parameter.
        
        @param request: CancelUploadDocumentJobRequest
        @return: CancelUploadDocumentJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_upload_document_job_with_options(request, runtime)

    async def cancel_upload_document_job_async(
        self,
        request: gpdb_20160503_models.CancelUploadDocumentJobRequest,
    ) -> gpdb_20160503_models.CancelUploadDocumentJobResponse:
        """
        @summary Cancels an asynchronous document upload job based on the job ID.
        
        @description This operation is related to the UploadDocumentAsync operation. You can call this operation to cancel a document upload job.
        >  If the canceling operation is complete, failed, or is canceled, you cannot call the operation again. The canceling operation only interrupts the document upload job. To remove the uploaded data, you must manually remove it or call the DeleteCollectionData operation. You can also call the document upload operation to overwrite the data by using the same FileName parameter.
        
        @param request: CancelUploadDocumentJobRequest
        @return: CancelUploadDocumentJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_upload_document_job_with_options_async(request, runtime)

    def cancel_upsert_collection_data_job_with_options(
        self,
        request: gpdb_20160503_models.CancelUpsertCollectionDataJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CancelUpsertCollectionDataJobResponse:
        """
        @summary Cancels an asynchronous vector data upload job by using a job ID.
        
        @description This operation is related to the `UpsertCollectionDataAsync` operation. You can call this operation to cancel an upload job.
        >  If the canceling operation is complete, failed, or is canceled, you cannot call the operation again. The canceling operation only interrupts the upload job. To remove the uploaded data, you must manually remove it or call the DeleteCollectionData operation.
        
        @param request: CancelUpsertCollectionDataJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelUpsertCollectionDataJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        body = {}
        if not UtilClient.is_unset(request.collection):
            body['Collection'] = request.collection
        if not UtilClient.is_unset(request.job_id):
            body['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            body['NamespacePassword'] = request.namespace_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CancelUpsertCollectionDataJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CancelUpsertCollectionDataJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_upsert_collection_data_job_with_options_async(
        self,
        request: gpdb_20160503_models.CancelUpsertCollectionDataJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CancelUpsertCollectionDataJobResponse:
        """
        @summary Cancels an asynchronous vector data upload job by using a job ID.
        
        @description This operation is related to the `UpsertCollectionDataAsync` operation. You can call this operation to cancel an upload job.
        >  If the canceling operation is complete, failed, or is canceled, you cannot call the operation again. The canceling operation only interrupts the upload job. To remove the uploaded data, you must manually remove it or call the DeleteCollectionData operation.
        
        @param request: CancelUpsertCollectionDataJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelUpsertCollectionDataJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        body = {}
        if not UtilClient.is_unset(request.collection):
            body['Collection'] = request.collection
        if not UtilClient.is_unset(request.job_id):
            body['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            body['NamespacePassword'] = request.namespace_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CancelUpsertCollectionDataJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CancelUpsertCollectionDataJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_upsert_collection_data_job(
        self,
        request: gpdb_20160503_models.CancelUpsertCollectionDataJobRequest,
    ) -> gpdb_20160503_models.CancelUpsertCollectionDataJobResponse:
        """
        @summary Cancels an asynchronous vector data upload job by using a job ID.
        
        @description This operation is related to the `UpsertCollectionDataAsync` operation. You can call this operation to cancel an upload job.
        >  If the canceling operation is complete, failed, or is canceled, you cannot call the operation again. The canceling operation only interrupts the upload job. To remove the uploaded data, you must manually remove it or call the DeleteCollectionData operation.
        
        @param request: CancelUpsertCollectionDataJobRequest
        @return: CancelUpsertCollectionDataJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_upsert_collection_data_job_with_options(request, runtime)

    async def cancel_upsert_collection_data_job_async(
        self,
        request: gpdb_20160503_models.CancelUpsertCollectionDataJobRequest,
    ) -> gpdb_20160503_models.CancelUpsertCollectionDataJobResponse:
        """
        @summary Cancels an asynchronous vector data upload job by using a job ID.
        
        @description This operation is related to the `UpsertCollectionDataAsync` operation. You can call this operation to cancel an upload job.
        >  If the canceling operation is complete, failed, or is canceled, you cannot call the operation again. The canceling operation only interrupts the upload job. To remove the uploaded data, you must manually remove it or call the DeleteCollectionData operation.
        
        @param request: CancelUpsertCollectionDataJobRequest
        @return: CancelUpsertCollectionDataJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_upsert_collection_data_job_with_options_async(request, runtime)

    def check_hadoop_data_source_with_options(
        self,
        request: gpdb_20160503_models.CheckHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CheckHadoopDataSourceResponse:
        """
        @summary Checks the configurations of a Hadoop data source.
        
        @param request: CheckHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_dir):
            query['CheckDir'] = request.check_dir
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CheckHadoopDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_hadoop_data_source_with_options_async(
        self,
        request: gpdb_20160503_models.CheckHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CheckHadoopDataSourceResponse:
        """
        @summary Checks the configurations of a Hadoop data source.
        
        @param request: CheckHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_dir):
            query['CheckDir'] = request.check_dir
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CheckHadoopDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_hadoop_data_source(
        self,
        request: gpdb_20160503_models.CheckHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.CheckHadoopDataSourceResponse:
        """
        @summary Checks the configurations of a Hadoop data source.
        
        @param request: CheckHadoopDataSourceRequest
        @return: CheckHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_hadoop_data_source_with_options(request, runtime)

    async def check_hadoop_data_source_async(
        self,
        request: gpdb_20160503_models.CheckHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.CheckHadoopDataSourceResponse:
        """
        @summary Checks the configurations of a Hadoop data source.
        
        @param request: CheckHadoopDataSourceRequest
        @return: CheckHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_hadoop_data_source_with_options_async(request, runtime)

    def check_hadoop_net_connection_with_options(
        self,
        request: gpdb_20160503_models.CheckHadoopNetConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CheckHadoopNetConnectionResponse:
        """
        @summary Check Hadoop Cluster Network Connectivity
        
        @param request: CheckHadoopNetConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckHadoopNetConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.emr_instance_id):
            query['EmrInstanceId'] = request.emr_instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckHadoopNetConnection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CheckHadoopNetConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_hadoop_net_connection_with_options_async(
        self,
        request: gpdb_20160503_models.CheckHadoopNetConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CheckHadoopNetConnectionResponse:
        """
        @summary Check Hadoop Cluster Network Connectivity
        
        @param request: CheckHadoopNetConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckHadoopNetConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.emr_instance_id):
            query['EmrInstanceId'] = request.emr_instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckHadoopNetConnection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CheckHadoopNetConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_hadoop_net_connection(
        self,
        request: gpdb_20160503_models.CheckHadoopNetConnectionRequest,
    ) -> gpdb_20160503_models.CheckHadoopNetConnectionResponse:
        """
        @summary Check Hadoop Cluster Network Connectivity
        
        @param request: CheckHadoopNetConnectionRequest
        @return: CheckHadoopNetConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_hadoop_net_connection_with_options(request, runtime)

    async def check_hadoop_net_connection_async(
        self,
        request: gpdb_20160503_models.CheckHadoopNetConnectionRequest,
    ) -> gpdb_20160503_models.CheckHadoopNetConnectionResponse:
        """
        @summary Check Hadoop Cluster Network Connectivity
        
        @param request: CheckHadoopNetConnectionRequest
        @return: CheckHadoopNetConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_hadoop_net_connection_with_options_async(request, runtime)

    def check_jdbcsource_net_connection_with_options(
        self,
        request: gpdb_20160503_models.CheckJDBCSourceNetConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CheckJDBCSourceNetConnectionResponse:
        """
        @summary Check the network connectivity of the JDBC connection string
        
        @param request: CheckJDBCSourceNetConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckJDBCSourceNetConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.jdbc_connection_string):
            query['JdbcConnectionString'] = request.jdbc_connection_string
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckJDBCSourceNetConnection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CheckJDBCSourceNetConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_jdbcsource_net_connection_with_options_async(
        self,
        request: gpdb_20160503_models.CheckJDBCSourceNetConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CheckJDBCSourceNetConnectionResponse:
        """
        @summary Check the network connectivity of the JDBC connection string
        
        @param request: CheckJDBCSourceNetConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckJDBCSourceNetConnectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.jdbc_connection_string):
            query['JdbcConnectionString'] = request.jdbc_connection_string
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckJDBCSourceNetConnection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CheckJDBCSourceNetConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_jdbcsource_net_connection(
        self,
        request: gpdb_20160503_models.CheckJDBCSourceNetConnectionRequest,
    ) -> gpdb_20160503_models.CheckJDBCSourceNetConnectionResponse:
        """
        @summary Check the network connectivity of the JDBC connection string
        
        @param request: CheckJDBCSourceNetConnectionRequest
        @return: CheckJDBCSourceNetConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_jdbcsource_net_connection_with_options(request, runtime)

    async def check_jdbcsource_net_connection_async(
        self,
        request: gpdb_20160503_models.CheckJDBCSourceNetConnectionRequest,
    ) -> gpdb_20160503_models.CheckJDBCSourceNetConnectionResponse:
        """
        @summary Check the network connectivity of the JDBC connection string
        
        @param request: CheckJDBCSourceNetConnectionRequest
        @return: CheckJDBCSourceNetConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_jdbcsource_net_connection_with_options_async(request, runtime)

    def check_service_linked_role_with_options(
        self,
        request: gpdb_20160503_models.CheckServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CheckServiceLinkedRoleResponse:
        """
        @summary Queries whether a service-linked role is created.
        
        @param request: CheckServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckServiceLinkedRole',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CheckServiceLinkedRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_service_linked_role_with_options_async(
        self,
        request: gpdb_20160503_models.CheckServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CheckServiceLinkedRoleResponse:
        """
        @summary Queries whether a service-linked role is created.
        
        @param request: CheckServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckServiceLinkedRole',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CheckServiceLinkedRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_service_linked_role(
        self,
        request: gpdb_20160503_models.CheckServiceLinkedRoleRequest,
    ) -> gpdb_20160503_models.CheckServiceLinkedRoleResponse:
        """
        @summary Queries whether a service-linked role is created.
        
        @param request: CheckServiceLinkedRoleRequest
        @return: CheckServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_service_linked_role_with_options(request, runtime)

    async def check_service_linked_role_async(
        self,
        request: gpdb_20160503_models.CheckServiceLinkedRoleRequest,
    ) -> gpdb_20160503_models.CheckServiceLinkedRoleResponse:
        """
        @summary Queries whether a service-linked role is created.
        
        @param request: CheckServiceLinkedRoleRequest
        @return: CheckServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_service_linked_role_with_options_async(request, runtime)

    def clone_dbinstance_with_options(
        self,
        request: gpdb_20160503_models.CloneDBInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CloneDBInstanceResponse:
        """
        @summary 恢复数据至指定实例
        
        @param request: CloneDBInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloneDBInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.src_db_instance_name):
            query['SrcDbInstanceName'] = request.src_db_instance_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloneDBInstance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CloneDBInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def clone_dbinstance_with_options_async(
        self,
        request: gpdb_20160503_models.CloneDBInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CloneDBInstanceResponse:
        """
        @summary 恢复数据至指定实例
        
        @param request: CloneDBInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloneDBInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.src_db_instance_name):
            query['SrcDbInstanceName'] = request.src_db_instance_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloneDBInstance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CloneDBInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def clone_dbinstance(
        self,
        request: gpdb_20160503_models.CloneDBInstanceRequest,
    ) -> gpdb_20160503_models.CloneDBInstanceResponse:
        """
        @summary 恢复数据至指定实例
        
        @param request: CloneDBInstanceRequest
        @return: CloneDBInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.clone_dbinstance_with_options(request, runtime)

    async def clone_dbinstance_async(
        self,
        request: gpdb_20160503_models.CloneDBInstanceRequest,
    ) -> gpdb_20160503_models.CloneDBInstanceResponse:
        """
        @summary 恢复数据至指定实例
        
        @param request: CloneDBInstanceRequest
        @return: CloneDBInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.clone_dbinstance_with_options_async(request, runtime)

    def create_account_with_options(
        self,
        request: gpdb_20160503_models.CreateAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateAccountResponse:
        """
        @summary Creates an initial account for an AnalyticDB for PostgreSQL instance.
        
        @description    Before you can use an AnalyticDB for PostgreSQL instance, you must create an initial account for the instance.
        You can call this operation to create only initial accounts. For information about how to create other types of accounts, see [Create a database account](https://help.aliyun.com/document_detail/50206.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_description):
            query['AccountDescription'] = request.account_description
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.account_type):
            query['AccountType'] = request.account_type
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database_name):
            query['DatabaseName'] = request.database_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAccount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateAccountResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_account_with_options_async(
        self,
        request: gpdb_20160503_models.CreateAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateAccountResponse:
        """
        @summary Creates an initial account for an AnalyticDB for PostgreSQL instance.
        
        @description    Before you can use an AnalyticDB for PostgreSQL instance, you must create an initial account for the instance.
        You can call this operation to create only initial accounts. For information about how to create other types of accounts, see [Create a database account](https://help.aliyun.com/document_detail/50206.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_description):
            query['AccountDescription'] = request.account_description
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.account_type):
            query['AccountType'] = request.account_type
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database_name):
            query['DatabaseName'] = request.database_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAccount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateAccountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_account(
        self,
        request: gpdb_20160503_models.CreateAccountRequest,
    ) -> gpdb_20160503_models.CreateAccountResponse:
        """
        @summary Creates an initial account for an AnalyticDB for PostgreSQL instance.
        
        @description    Before you can use an AnalyticDB for PostgreSQL instance, you must create an initial account for the instance.
        You can call this operation to create only initial accounts. For information about how to create other types of accounts, see [Create a database account](https://help.aliyun.com/document_detail/50206.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateAccountRequest
        @return: CreateAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_account_with_options(request, runtime)

    async def create_account_async(
        self,
        request: gpdb_20160503_models.CreateAccountRequest,
    ) -> gpdb_20160503_models.CreateAccountResponse:
        """
        @summary Creates an initial account for an AnalyticDB for PostgreSQL instance.
        
        @description    Before you can use an AnalyticDB for PostgreSQL instance, you must create an initial account for the instance.
        You can call this operation to create only initial accounts. For information about how to create other types of accounts, see [Create a database account](https://help.aliyun.com/document_detail/50206.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateAccountRequest
        @return: CreateAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_account_with_options_async(request, runtime)

    def create_backup_with_options(
        self,
        request: gpdb_20160503_models.CreateBackupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateBackupResponse:
        """
        @summary 创建备份
        
        @param request: CreateBackupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBackupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBackup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateBackupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_backup_with_options_async(
        self,
        request: gpdb_20160503_models.CreateBackupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateBackupResponse:
        """
        @summary 创建备份
        
        @param request: CreateBackupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBackupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBackup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateBackupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_backup(
        self,
        request: gpdb_20160503_models.CreateBackupRequest,
    ) -> gpdb_20160503_models.CreateBackupResponse:
        """
        @summary 创建备份
        
        @param request: CreateBackupRequest
        @return: CreateBackupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_backup_with_options(request, runtime)

    async def create_backup_async(
        self,
        request: gpdb_20160503_models.CreateBackupRequest,
    ) -> gpdb_20160503_models.CreateBackupResponse:
        """
        @summary 创建备份
        
        @param request: CreateBackupRequest
        @return: CreateBackupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_backup_with_options_async(request, runtime)

    def create_collection_with_options(
        self,
        tmp_req: gpdb_20160503_models.CreateCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateCollectionResponse:
        """
        @summary Creates a vector collection.
        
        @param tmp_req: CreateCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCollectionResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.CreateCollectionShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sparse_vector_index_config):
            request.sparse_vector_index_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sparse_vector_index_config, 'SparseVectorIndexConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dimension):
            query['Dimension'] = request.dimension
        if not UtilClient.is_unset(request.external_storage):
            query['ExternalStorage'] = request.external_storage
        if not UtilClient.is_unset(request.full_text_retrieval_fields):
            query['FullTextRetrievalFields'] = request.full_text_retrieval_fields
        if not UtilClient.is_unset(request.hnsw_ef_construction):
            query['HnswEfConstruction'] = request.hnsw_ef_construction
        if not UtilClient.is_unset(request.hnsw_m):
            query['HnswM'] = request.hnsw_m
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.metadata):
            query['Metadata'] = request.metadata
        if not UtilClient.is_unset(request.metadata_indices):
            query['MetadataIndices'] = request.metadata_indices
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parser):
            query['Parser'] = request.parser
        if not UtilClient.is_unset(request.pq_enable):
            query['PqEnable'] = request.pq_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sparse_vector_index_config_shrink):
            query['SparseVectorIndexConfig'] = request.sparse_vector_index_config_shrink
        if not UtilClient.is_unset(request.support_sparse):
            query['SupportSparse'] = request.support_sparse
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateCollectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_collection_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.CreateCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateCollectionResponse:
        """
        @summary Creates a vector collection.
        
        @param tmp_req: CreateCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCollectionResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.CreateCollectionShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sparse_vector_index_config):
            request.sparse_vector_index_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sparse_vector_index_config, 'SparseVectorIndexConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dimension):
            query['Dimension'] = request.dimension
        if not UtilClient.is_unset(request.external_storage):
            query['ExternalStorage'] = request.external_storage
        if not UtilClient.is_unset(request.full_text_retrieval_fields):
            query['FullTextRetrievalFields'] = request.full_text_retrieval_fields
        if not UtilClient.is_unset(request.hnsw_ef_construction):
            query['HnswEfConstruction'] = request.hnsw_ef_construction
        if not UtilClient.is_unset(request.hnsw_m):
            query['HnswM'] = request.hnsw_m
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.metadata):
            query['Metadata'] = request.metadata
        if not UtilClient.is_unset(request.metadata_indices):
            query['MetadataIndices'] = request.metadata_indices
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parser):
            query['Parser'] = request.parser
        if not UtilClient.is_unset(request.pq_enable):
            query['PqEnable'] = request.pq_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.sparse_vector_index_config_shrink):
            query['SparseVectorIndexConfig'] = request.sparse_vector_index_config_shrink
        if not UtilClient.is_unset(request.support_sparse):
            query['SupportSparse'] = request.support_sparse
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateCollectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_collection(
        self,
        request: gpdb_20160503_models.CreateCollectionRequest,
    ) -> gpdb_20160503_models.CreateCollectionResponse:
        """
        @summary Creates a vector collection.
        
        @param request: CreateCollectionRequest
        @return: CreateCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_collection_with_options(request, runtime)

    async def create_collection_async(
        self,
        request: gpdb_20160503_models.CreateCollectionRequest,
    ) -> gpdb_20160503_models.CreateCollectionResponse:
        """
        @summary Creates a vector collection.
        
        @param request: CreateCollectionRequest
        @return: CreateCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_collection_with_options_async(request, runtime)

    def create_dbinstance_with_options(
        self,
        request: gpdb_20160503_models.CreateDBInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateDBInstanceResponse:
        """
        @summary Create Instance
        
        @description Before using this interface, please make sure you have fully understood the [billing method](https://help.aliyun.com/document_detail/35406.html) and <props="china">[pricing](https://www.aliyun.com/price/product#/gpdb/detail/GreenplumPost)<props="intl">[pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing) of the AnalyticDB for PostgreSQL product.
        
        @param request: CreateDBInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ainode_spec_infos):
            query['AINodeSpecInfos'] = request.ainode_spec_infos
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.cache_storage_size):
            query['CacheStorageSize'] = request.cache_storage_size
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.create_sample_data):
            query['CreateSampleData'] = request.create_sample_data
        if not UtilClient.is_unset(request.dbinstance_category):
            query['DBInstanceCategory'] = request.dbinstance_category
        if not UtilClient.is_unset(request.dbinstance_class):
            query['DBInstanceClass'] = request.dbinstance_class
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_group_count):
            query['DBInstanceGroupCount'] = request.dbinstance_group_count
        if not UtilClient.is_unset(request.dbinstance_mode):
            query['DBInstanceMode'] = request.dbinstance_mode
        if not UtilClient.is_unset(request.deploy_mode):
            query['DeployMode'] = request.deploy_mode
        if not UtilClient.is_unset(request.enable_ssl):
            query['EnableSSL'] = request.enable_ssl
        if not UtilClient.is_unset(request.encryption_key):
            query['EncryptionKey'] = request.encryption_key
        if not UtilClient.is_unset(request.encryption_type):
            query['EncryptionType'] = request.encryption_type
        if not UtilClient.is_unset(request.engine):
            query['Engine'] = request.engine
        if not UtilClient.is_unset(request.engine_version):
            query['EngineVersion'] = request.engine_version
        if not UtilClient.is_unset(request.idle_time):
            query['IdleTime'] = request.idle_time
        if not UtilClient.is_unset(request.instance_network_type):
            query['InstanceNetworkType'] = request.instance_network_type
        if not UtilClient.is_unset(request.instance_spec):
            query['InstanceSpec'] = request.instance_spec
        if not UtilClient.is_unset(request.master_aispec):
            query['MasterAISpec'] = request.master_aispec
        if not UtilClient.is_unset(request.master_cu):
            query['MasterCU'] = request.master_cu
        if not UtilClient.is_unset(request.master_node_num):
            query['MasterNodeNum'] = request.master_node_num
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.prod_type):
            query['ProdType'] = request.prod_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        if not UtilClient.is_unset(request.seg_disk_performance_level):
            query['SegDiskPerformanceLevel'] = request.seg_disk_performance_level
        if not UtilClient.is_unset(request.seg_node_num):
            query['SegNodeNum'] = request.seg_node_num
        if not UtilClient.is_unset(request.seg_storage_type):
            query['SegStorageType'] = request.seg_storage_type
        if not UtilClient.is_unset(request.serverless_mode):
            query['ServerlessMode'] = request.serverless_mode
        if not UtilClient.is_unset(request.serverless_resource):
            query['ServerlessResource'] = request.serverless_resource
        if not UtilClient.is_unset(request.src_db_instance_name):
            query['SrcDbInstanceName'] = request.src_db_instance_name
        if not UtilClient.is_unset(request.standby_vswitch_id):
            query['StandbyVSwitchId'] = request.standby_vswitch_id
        if not UtilClient.is_unset(request.standby_zone_id):
            query['StandbyZoneId'] = request.standby_zone_id
        if not UtilClient.is_unset(request.storage_size):
            query['StorageSize'] = request.storage_size
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        if not UtilClient.is_unset(request.vpcid):
            query['VPCId'] = request.vpcid
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vector_configuration_status):
            query['VectorConfigurationStatus'] = request.vector_configuration_status
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBInstance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateDBInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dbinstance_with_options_async(
        self,
        request: gpdb_20160503_models.CreateDBInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateDBInstanceResponse:
        """
        @summary Create Instance
        
        @description Before using this interface, please make sure you have fully understood the [billing method](https://help.aliyun.com/document_detail/35406.html) and <props="china">[pricing](https://www.aliyun.com/price/product#/gpdb/detail/GreenplumPost)<props="intl">[pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing) of the AnalyticDB for PostgreSQL product.
        
        @param request: CreateDBInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ainode_spec_infos):
            query['AINodeSpecInfos'] = request.ainode_spec_infos
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.cache_storage_size):
            query['CacheStorageSize'] = request.cache_storage_size
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.create_sample_data):
            query['CreateSampleData'] = request.create_sample_data
        if not UtilClient.is_unset(request.dbinstance_category):
            query['DBInstanceCategory'] = request.dbinstance_category
        if not UtilClient.is_unset(request.dbinstance_class):
            query['DBInstanceClass'] = request.dbinstance_class
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_group_count):
            query['DBInstanceGroupCount'] = request.dbinstance_group_count
        if not UtilClient.is_unset(request.dbinstance_mode):
            query['DBInstanceMode'] = request.dbinstance_mode
        if not UtilClient.is_unset(request.deploy_mode):
            query['DeployMode'] = request.deploy_mode
        if not UtilClient.is_unset(request.enable_ssl):
            query['EnableSSL'] = request.enable_ssl
        if not UtilClient.is_unset(request.encryption_key):
            query['EncryptionKey'] = request.encryption_key
        if not UtilClient.is_unset(request.encryption_type):
            query['EncryptionType'] = request.encryption_type
        if not UtilClient.is_unset(request.engine):
            query['Engine'] = request.engine
        if not UtilClient.is_unset(request.engine_version):
            query['EngineVersion'] = request.engine_version
        if not UtilClient.is_unset(request.idle_time):
            query['IdleTime'] = request.idle_time
        if not UtilClient.is_unset(request.instance_network_type):
            query['InstanceNetworkType'] = request.instance_network_type
        if not UtilClient.is_unset(request.instance_spec):
            query['InstanceSpec'] = request.instance_spec
        if not UtilClient.is_unset(request.master_aispec):
            query['MasterAISpec'] = request.master_aispec
        if not UtilClient.is_unset(request.master_cu):
            query['MasterCU'] = request.master_cu
        if not UtilClient.is_unset(request.master_node_num):
            query['MasterNodeNum'] = request.master_node_num
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.prod_type):
            query['ProdType'] = request.prod_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        if not UtilClient.is_unset(request.seg_disk_performance_level):
            query['SegDiskPerformanceLevel'] = request.seg_disk_performance_level
        if not UtilClient.is_unset(request.seg_node_num):
            query['SegNodeNum'] = request.seg_node_num
        if not UtilClient.is_unset(request.seg_storage_type):
            query['SegStorageType'] = request.seg_storage_type
        if not UtilClient.is_unset(request.serverless_mode):
            query['ServerlessMode'] = request.serverless_mode
        if not UtilClient.is_unset(request.serverless_resource):
            query['ServerlessResource'] = request.serverless_resource
        if not UtilClient.is_unset(request.src_db_instance_name):
            query['SrcDbInstanceName'] = request.src_db_instance_name
        if not UtilClient.is_unset(request.standby_vswitch_id):
            query['StandbyVSwitchId'] = request.standby_vswitch_id
        if not UtilClient.is_unset(request.standby_zone_id):
            query['StandbyZoneId'] = request.standby_zone_id
        if not UtilClient.is_unset(request.storage_size):
            query['StorageSize'] = request.storage_size
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        if not UtilClient.is_unset(request.vpcid):
            query['VPCId'] = request.vpcid
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vector_configuration_status):
            query['VectorConfigurationStatus'] = request.vector_configuration_status
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBInstance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateDBInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dbinstance(
        self,
        request: gpdb_20160503_models.CreateDBInstanceRequest,
    ) -> gpdb_20160503_models.CreateDBInstanceResponse:
        """
        @summary Create Instance
        
        @description Before using this interface, please make sure you have fully understood the [billing method](https://help.aliyun.com/document_detail/35406.html) and <props="china">[pricing](https://www.aliyun.com/price/product#/gpdb/detail/GreenplumPost)<props="intl">[pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing) of the AnalyticDB for PostgreSQL product.
        
        @param request: CreateDBInstanceRequest
        @return: CreateDBInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dbinstance_with_options(request, runtime)

    async def create_dbinstance_async(
        self,
        request: gpdb_20160503_models.CreateDBInstanceRequest,
    ) -> gpdb_20160503_models.CreateDBInstanceResponse:
        """
        @summary Create Instance
        
        @description Before using this interface, please make sure you have fully understood the [billing method](https://help.aliyun.com/document_detail/35406.html) and <props="china">[pricing](https://www.aliyun.com/price/product#/gpdb/detail/GreenplumPost)<props="intl">[pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing) of the AnalyticDB for PostgreSQL product.
        
        @param request: CreateDBInstanceRequest
        @return: CreateDBInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dbinstance_with_options_async(request, runtime)

    def create_dbinstance_plan_with_options(
        self,
        request: gpdb_20160503_models.CreateDBInstancePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateDBInstancePlanResponse:
        """
        @summary Creates a plan for an AnalyticDB for PostgreSQL instance.
        
        @description    The plan management feature is supported only for pay-as-you-go instances.
        When you change the compute node specifications or change the number of compute nodes, transient connections may occur. We recommend that you perform these operations during off-peak hours.
        Before you call this operation, make sure that you are familiar with the billing of AnalyticDB for PostgreSQL. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        
        @param request: CreateDBInstancePlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBInstancePlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.plan_config):
            query['PlanConfig'] = request.plan_config
        if not UtilClient.is_unset(request.plan_desc):
            query['PlanDesc'] = request.plan_desc
        if not UtilClient.is_unset(request.plan_end_date):
            query['PlanEndDate'] = request.plan_end_date
        if not UtilClient.is_unset(request.plan_name):
            query['PlanName'] = request.plan_name
        if not UtilClient.is_unset(request.plan_schedule_type):
            query['PlanScheduleType'] = request.plan_schedule_type
        if not UtilClient.is_unset(request.plan_start_date):
            query['PlanStartDate'] = request.plan_start_date
        if not UtilClient.is_unset(request.plan_type):
            query['PlanType'] = request.plan_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBInstancePlan',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateDBInstancePlanResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dbinstance_plan_with_options_async(
        self,
        request: gpdb_20160503_models.CreateDBInstancePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateDBInstancePlanResponse:
        """
        @summary Creates a plan for an AnalyticDB for PostgreSQL instance.
        
        @description    The plan management feature is supported only for pay-as-you-go instances.
        When you change the compute node specifications or change the number of compute nodes, transient connections may occur. We recommend that you perform these operations during off-peak hours.
        Before you call this operation, make sure that you are familiar with the billing of AnalyticDB for PostgreSQL. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        
        @param request: CreateDBInstancePlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBInstancePlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.plan_config):
            query['PlanConfig'] = request.plan_config
        if not UtilClient.is_unset(request.plan_desc):
            query['PlanDesc'] = request.plan_desc
        if not UtilClient.is_unset(request.plan_end_date):
            query['PlanEndDate'] = request.plan_end_date
        if not UtilClient.is_unset(request.plan_name):
            query['PlanName'] = request.plan_name
        if not UtilClient.is_unset(request.plan_schedule_type):
            query['PlanScheduleType'] = request.plan_schedule_type
        if not UtilClient.is_unset(request.plan_start_date):
            query['PlanStartDate'] = request.plan_start_date
        if not UtilClient.is_unset(request.plan_type):
            query['PlanType'] = request.plan_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBInstancePlan',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateDBInstancePlanResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dbinstance_plan(
        self,
        request: gpdb_20160503_models.CreateDBInstancePlanRequest,
    ) -> gpdb_20160503_models.CreateDBInstancePlanResponse:
        """
        @summary Creates a plan for an AnalyticDB for PostgreSQL instance.
        
        @description    The plan management feature is supported only for pay-as-you-go instances.
        When you change the compute node specifications or change the number of compute nodes, transient connections may occur. We recommend that you perform these operations during off-peak hours.
        Before you call this operation, make sure that you are familiar with the billing of AnalyticDB for PostgreSQL. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        
        @param request: CreateDBInstancePlanRequest
        @return: CreateDBInstancePlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dbinstance_plan_with_options(request, runtime)

    async def create_dbinstance_plan_async(
        self,
        request: gpdb_20160503_models.CreateDBInstancePlanRequest,
    ) -> gpdb_20160503_models.CreateDBInstancePlanResponse:
        """
        @summary Creates a plan for an AnalyticDB for PostgreSQL instance.
        
        @description    The plan management feature is supported only for pay-as-you-go instances.
        When you change the compute node specifications or change the number of compute nodes, transient connections may occur. We recommend that you perform these operations during off-peak hours.
        Before you call this operation, make sure that you are familiar with the billing of AnalyticDB for PostgreSQL. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        
        @param request: CreateDBInstancePlanRequest
        @return: CreateDBInstancePlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dbinstance_plan_with_options_async(request, runtime)

    def create_dbresource_group_with_options(
        self,
        request: gpdb_20160503_models.CreateDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateDBResourceGroupResponse:
        """
        @summary Creates a resource group.
        
        @param request: CreateDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_config):
            query['ResourceGroupConfig'] = request.resource_group_config
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateDBResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dbresource_group_with_options_async(
        self,
        request: gpdb_20160503_models.CreateDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateDBResourceGroupResponse:
        """
        @summary Creates a resource group.
        
        @param request: CreateDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_config):
            query['ResourceGroupConfig'] = request.resource_group_config
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateDBResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dbresource_group(
        self,
        request: gpdb_20160503_models.CreateDBResourceGroupRequest,
    ) -> gpdb_20160503_models.CreateDBResourceGroupResponse:
        """
        @summary Creates a resource group.
        
        @param request: CreateDBResourceGroupRequest
        @return: CreateDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dbresource_group_with_options(request, runtime)

    async def create_dbresource_group_async(
        self,
        request: gpdb_20160503_models.CreateDBResourceGroupRequest,
    ) -> gpdb_20160503_models.CreateDBResourceGroupResponse:
        """
        @summary Creates a resource group.
        
        @param request: CreateDBResourceGroupRequest
        @return: CreateDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dbresource_group_with_options_async(request, runtime)

    def create_document_collection_with_options(
        self,
        tmp_req: gpdb_20160503_models.CreateDocumentCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateDocumentCollectionResponse:
        """
        @summary Creates a document collection.
        
        @param tmp_req: CreateDocumentCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDocumentCollectionResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.CreateDocumentCollectionShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.entity_types):
            request.entity_types_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.entity_types, 'EntityTypes', 'json')
        if not UtilClient.is_unset(tmp_req.relationship_types):
            request.relationship_types_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.relationship_types, 'RelationshipTypes', 'json')
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dimension):
            query['Dimension'] = request.dimension
        if not UtilClient.is_unset(request.embedding_model):
            query['EmbeddingModel'] = request.embedding_model
        if not UtilClient.is_unset(request.enable_graph):
            query['EnableGraph'] = request.enable_graph
        if not UtilClient.is_unset(request.entity_types_shrink):
            query['EntityTypes'] = request.entity_types_shrink
        if not UtilClient.is_unset(request.external_storage):
            query['ExternalStorage'] = request.external_storage
        if not UtilClient.is_unset(request.full_text_retrieval_fields):
            query['FullTextRetrievalFields'] = request.full_text_retrieval_fields
        if not UtilClient.is_unset(request.hnsw_ef_construction):
            query['HnswEfConstruction'] = request.hnsw_ef_construction
        if not UtilClient.is_unset(request.hnsw_m):
            query['HnswM'] = request.hnsw_m
        if not UtilClient.is_unset(request.llmmodel):
            query['LLMModel'] = request.llmmodel
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.metadata):
            query['Metadata'] = request.metadata
        if not UtilClient.is_unset(request.metadata_indices):
            query['MetadataIndices'] = request.metadata_indices
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parser):
            query['Parser'] = request.parser
        if not UtilClient.is_unset(request.pq_enable):
            query['PqEnable'] = request.pq_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.relationship_types_shrink):
            query['RelationshipTypes'] = request.relationship_types_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDocumentCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateDocumentCollectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_document_collection_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.CreateDocumentCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateDocumentCollectionResponse:
        """
        @summary Creates a document collection.
        
        @param tmp_req: CreateDocumentCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDocumentCollectionResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.CreateDocumentCollectionShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.entity_types):
            request.entity_types_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.entity_types, 'EntityTypes', 'json')
        if not UtilClient.is_unset(tmp_req.relationship_types):
            request.relationship_types_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.relationship_types, 'RelationshipTypes', 'json')
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dimension):
            query['Dimension'] = request.dimension
        if not UtilClient.is_unset(request.embedding_model):
            query['EmbeddingModel'] = request.embedding_model
        if not UtilClient.is_unset(request.enable_graph):
            query['EnableGraph'] = request.enable_graph
        if not UtilClient.is_unset(request.entity_types_shrink):
            query['EntityTypes'] = request.entity_types_shrink
        if not UtilClient.is_unset(request.external_storage):
            query['ExternalStorage'] = request.external_storage
        if not UtilClient.is_unset(request.full_text_retrieval_fields):
            query['FullTextRetrievalFields'] = request.full_text_retrieval_fields
        if not UtilClient.is_unset(request.hnsw_ef_construction):
            query['HnswEfConstruction'] = request.hnsw_ef_construction
        if not UtilClient.is_unset(request.hnsw_m):
            query['HnswM'] = request.hnsw_m
        if not UtilClient.is_unset(request.llmmodel):
            query['LLMModel'] = request.llmmodel
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.metadata):
            query['Metadata'] = request.metadata
        if not UtilClient.is_unset(request.metadata_indices):
            query['MetadataIndices'] = request.metadata_indices
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.parser):
            query['Parser'] = request.parser
        if not UtilClient.is_unset(request.pq_enable):
            query['PqEnable'] = request.pq_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.relationship_types_shrink):
            query['RelationshipTypes'] = request.relationship_types_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDocumentCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateDocumentCollectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_document_collection(
        self,
        request: gpdb_20160503_models.CreateDocumentCollectionRequest,
    ) -> gpdb_20160503_models.CreateDocumentCollectionResponse:
        """
        @summary Creates a document collection.
        
        @param request: CreateDocumentCollectionRequest
        @return: CreateDocumentCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_document_collection_with_options(request, runtime)

    async def create_document_collection_async(
        self,
        request: gpdb_20160503_models.CreateDocumentCollectionRequest,
    ) -> gpdb_20160503_models.CreateDocumentCollectionResponse:
        """
        @summary Creates a document collection.
        
        @param request: CreateDocumentCollectionRequest
        @return: CreateDocumentCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_document_collection_with_options_async(request, runtime)

    def create_extensions_with_options(
        self,
        request: gpdb_20160503_models.CreateExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateExtensionsResponse:
        """
        @summary Install extensions.
        
        @param request: CreateExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dbnames):
            query['DBNames'] = request.dbnames
        if not UtilClient.is_unset(request.extensions):
            query['Extensions'] = request.extensions
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExtensions',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateExtensionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_extensions_with_options_async(
        self,
        request: gpdb_20160503_models.CreateExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateExtensionsResponse:
        """
        @summary Install extensions.
        
        @param request: CreateExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dbnames):
            query['DBNames'] = request.dbnames
        if not UtilClient.is_unset(request.extensions):
            query['Extensions'] = request.extensions
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExtensions',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateExtensionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_extensions(
        self,
        request: gpdb_20160503_models.CreateExtensionsRequest,
    ) -> gpdb_20160503_models.CreateExtensionsResponse:
        """
        @summary Install extensions.
        
        @param request: CreateExtensionsRequest
        @return: CreateExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_extensions_with_options(request, runtime)

    async def create_extensions_async(
        self,
        request: gpdb_20160503_models.CreateExtensionsRequest,
    ) -> gpdb_20160503_models.CreateExtensionsResponse:
        """
        @summary Install extensions.
        
        @param request: CreateExtensionsRequest
        @return: CreateExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_extensions_with_options_async(request, runtime)

    def create_external_data_service_with_options(
        self,
        request: gpdb_20160503_models.CreateExternalDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateExternalDataServiceResponse:
        """
        @summary Create External Data Service
        
        @param request: CreateExternalDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateExternalDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_description):
            query['ServiceDescription'] = request.service_description
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_spec):
            query['ServiceSpec'] = request.service_spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExternalDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateExternalDataServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_external_data_service_with_options_async(
        self,
        request: gpdb_20160503_models.CreateExternalDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateExternalDataServiceResponse:
        """
        @summary Create External Data Service
        
        @param request: CreateExternalDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateExternalDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_description):
            query['ServiceDescription'] = request.service_description
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_spec):
            query['ServiceSpec'] = request.service_spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExternalDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateExternalDataServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_external_data_service(
        self,
        request: gpdb_20160503_models.CreateExternalDataServiceRequest,
    ) -> gpdb_20160503_models.CreateExternalDataServiceResponse:
        """
        @summary Create External Data Service
        
        @param request: CreateExternalDataServiceRequest
        @return: CreateExternalDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_external_data_service_with_options(request, runtime)

    async def create_external_data_service_async(
        self,
        request: gpdb_20160503_models.CreateExternalDataServiceRequest,
    ) -> gpdb_20160503_models.CreateExternalDataServiceResponse:
        """
        @summary Create External Data Service
        
        @param request: CreateExternalDataServiceRequest
        @return: CreateExternalDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_external_data_service_with_options_async(request, runtime)

    def create_hadoop_data_source_with_options(
        self,
        request: gpdb_20160503_models.CreateHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateHadoopDataSourceResponse:
        """
        @summary Create Hadoop data source configuration
        
        @param request: CreateHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.emr_instance_id):
            query['EmrInstanceId'] = request.emr_instance_id
        if not UtilClient.is_unset(request.hdfsconf):
            query['HDFSConf'] = request.hdfsconf
        if not UtilClient.is_unset(request.hadoop_core_conf):
            query['HadoopCoreConf'] = request.hadoop_core_conf
        if not UtilClient.is_unset(request.hadoop_create_type):
            query['HadoopCreateType'] = request.hadoop_create_type
        if not UtilClient.is_unset(request.hadoop_hosts_address):
            query['HadoopHostsAddress'] = request.hadoop_hosts_address
        if not UtilClient.is_unset(request.hive_conf):
            query['HiveConf'] = request.hive_conf
        if not UtilClient.is_unset(request.map_reduce_conf):
            query['MapReduceConf'] = request.map_reduce_conf
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.yarn_conf):
            query['YarnConf'] = request.yarn_conf
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateHadoopDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_hadoop_data_source_with_options_async(
        self,
        request: gpdb_20160503_models.CreateHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateHadoopDataSourceResponse:
        """
        @summary Create Hadoop data source configuration
        
        @param request: CreateHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.emr_instance_id):
            query['EmrInstanceId'] = request.emr_instance_id
        if not UtilClient.is_unset(request.hdfsconf):
            query['HDFSConf'] = request.hdfsconf
        if not UtilClient.is_unset(request.hadoop_core_conf):
            query['HadoopCoreConf'] = request.hadoop_core_conf
        if not UtilClient.is_unset(request.hadoop_create_type):
            query['HadoopCreateType'] = request.hadoop_create_type
        if not UtilClient.is_unset(request.hadoop_hosts_address):
            query['HadoopHostsAddress'] = request.hadoop_hosts_address
        if not UtilClient.is_unset(request.hive_conf):
            query['HiveConf'] = request.hive_conf
        if not UtilClient.is_unset(request.map_reduce_conf):
            query['MapReduceConf'] = request.map_reduce_conf
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.yarn_conf):
            query['YarnConf'] = request.yarn_conf
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateHadoopDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_hadoop_data_source(
        self,
        request: gpdb_20160503_models.CreateHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.CreateHadoopDataSourceResponse:
        """
        @summary Create Hadoop data source configuration
        
        @param request: CreateHadoopDataSourceRequest
        @return: CreateHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_hadoop_data_source_with_options(request, runtime)

    async def create_hadoop_data_source_async(
        self,
        request: gpdb_20160503_models.CreateHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.CreateHadoopDataSourceResponse:
        """
        @summary Create Hadoop data source configuration
        
        @param request: CreateHadoopDataSourceRequest
        @return: CreateHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_hadoop_data_source_with_options_async(request, runtime)

    def create_index_with_options(
        self,
        request: gpdb_20160503_models.CreateIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateIndexResponse:
        """
        @summary 创建索引
        
        @param request: CreateIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.index_config):
            query['IndexConfig'] = request.index_config
        if not UtilClient.is_unset(request.index_field):
            query['IndexField'] = request.index_field
        if not UtilClient.is_unset(request.index_name):
            query['IndexName'] = request.index_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateIndexResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_index_with_options_async(
        self,
        request: gpdb_20160503_models.CreateIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateIndexResponse:
        """
        @summary 创建索引
        
        @param request: CreateIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.index_config):
            query['IndexConfig'] = request.index_config
        if not UtilClient.is_unset(request.index_field):
            query['IndexField'] = request.index_field
        if not UtilClient.is_unset(request.index_name):
            query['IndexName'] = request.index_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateIndexResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_index(
        self,
        request: gpdb_20160503_models.CreateIndexRequest,
    ) -> gpdb_20160503_models.CreateIndexResponse:
        """
        @summary 创建索引
        
        @param request: CreateIndexRequest
        @return: CreateIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_index_with_options(request, runtime)

    async def create_index_async(
        self,
        request: gpdb_20160503_models.CreateIndexRequest,
    ) -> gpdb_20160503_models.CreateIndexResponse:
        """
        @summary 创建索引
        
        @param request: CreateIndexRequest
        @return: CreateIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_index_with_options_async(request, runtime)

    def create_jdbcdata_source_with_options(
        self,
        request: gpdb_20160503_models.CreateJDBCDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateJDBCDataSourceResponse:
        """
        @summary Creates a JDBC data source.
        
        @param request: CreateJDBCDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateJDBCDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.jdbcconnection_string):
            query['JDBCConnectionString'] = request.jdbcconnection_string
        if not UtilClient.is_unset(request.jdbcpassword):
            query['JDBCPassword'] = request.jdbcpassword
        if not UtilClient.is_unset(request.jdbcuser_name):
            query['JDBCUserName'] = request.jdbcuser_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateJDBCDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateJDBCDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_jdbcdata_source_with_options_async(
        self,
        request: gpdb_20160503_models.CreateJDBCDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateJDBCDataSourceResponse:
        """
        @summary Creates a JDBC data source.
        
        @param request: CreateJDBCDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateJDBCDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.jdbcconnection_string):
            query['JDBCConnectionString'] = request.jdbcconnection_string
        if not UtilClient.is_unset(request.jdbcpassword):
            query['JDBCPassword'] = request.jdbcpassword
        if not UtilClient.is_unset(request.jdbcuser_name):
            query['JDBCUserName'] = request.jdbcuser_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateJDBCDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateJDBCDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_jdbcdata_source(
        self,
        request: gpdb_20160503_models.CreateJDBCDataSourceRequest,
    ) -> gpdb_20160503_models.CreateJDBCDataSourceResponse:
        """
        @summary Creates a JDBC data source.
        
        @param request: CreateJDBCDataSourceRequest
        @return: CreateJDBCDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_jdbcdata_source_with_options(request, runtime)

    async def create_jdbcdata_source_async(
        self,
        request: gpdb_20160503_models.CreateJDBCDataSourceRequest,
    ) -> gpdb_20160503_models.CreateJDBCDataSourceResponse:
        """
        @summary Creates a JDBC data source.
        
        @param request: CreateJDBCDataSourceRequest
        @return: CreateJDBCDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_jdbcdata_source_with_options_async(request, runtime)

    def create_namespace_with_options(
        self,
        request: gpdb_20160503_models.CreateNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateNamespaceResponse:
        """
        @summary Creates a vector namespace.
        
        @param request: CreateNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNamespace',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateNamespaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_namespace_with_options_async(
        self,
        request: gpdb_20160503_models.CreateNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateNamespaceResponse:
        """
        @summary Creates a vector namespace.
        
        @param request: CreateNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNamespace',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateNamespaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_namespace(
        self,
        request: gpdb_20160503_models.CreateNamespaceRequest,
    ) -> gpdb_20160503_models.CreateNamespaceResponse:
        """
        @summary Creates a vector namespace.
        
        @param request: CreateNamespaceRequest
        @return: CreateNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_namespace_with_options(request, runtime)

    async def create_namespace_async(
        self,
        request: gpdb_20160503_models.CreateNamespaceRequest,
    ) -> gpdb_20160503_models.CreateNamespaceResponse:
        """
        @summary Creates a vector namespace.
        
        @param request: CreateNamespaceRequest
        @return: CreateNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_namespace_with_options_async(request, runtime)

    def create_remote_adbdata_source_with_options(
        self,
        request: gpdb_20160503_models.CreateRemoteADBDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateRemoteADBDataSourceResponse:
        """
        @summary Create Homogeneous Data Source
        
        @param request: CreateRemoteADBDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRemoteADBDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.local_dbinstance_id):
            query['LocalDBInstanceId'] = request.local_dbinstance_id
        if not UtilClient.is_unset(request.local_database):
            query['LocalDatabase'] = request.local_database
        if not UtilClient.is_unset(request.manager_user_name):
            query['ManagerUserName'] = request.manager_user_name
        if not UtilClient.is_unset(request.manager_user_password):
            query['ManagerUserPassword'] = request.manager_user_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.remote_dbinstance_id):
            query['RemoteDBInstanceId'] = request.remote_dbinstance_id
        if not UtilClient.is_unset(request.remote_database):
            query['RemoteDatabase'] = request.remote_database
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        if not UtilClient.is_unset(request.user_password):
            query['UserPassword'] = request.user_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRemoteADBDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateRemoteADBDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_remote_adbdata_source_with_options_async(
        self,
        request: gpdb_20160503_models.CreateRemoteADBDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateRemoteADBDataSourceResponse:
        """
        @summary Create Homogeneous Data Source
        
        @param request: CreateRemoteADBDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRemoteADBDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.local_dbinstance_id):
            query['LocalDBInstanceId'] = request.local_dbinstance_id
        if not UtilClient.is_unset(request.local_database):
            query['LocalDatabase'] = request.local_database
        if not UtilClient.is_unset(request.manager_user_name):
            query['ManagerUserName'] = request.manager_user_name
        if not UtilClient.is_unset(request.manager_user_password):
            query['ManagerUserPassword'] = request.manager_user_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.remote_dbinstance_id):
            query['RemoteDBInstanceId'] = request.remote_dbinstance_id
        if not UtilClient.is_unset(request.remote_database):
            query['RemoteDatabase'] = request.remote_database
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        if not UtilClient.is_unset(request.user_password):
            query['UserPassword'] = request.user_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRemoteADBDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateRemoteADBDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_remote_adbdata_source(
        self,
        request: gpdb_20160503_models.CreateRemoteADBDataSourceRequest,
    ) -> gpdb_20160503_models.CreateRemoteADBDataSourceResponse:
        """
        @summary Create Homogeneous Data Source
        
        @param request: CreateRemoteADBDataSourceRequest
        @return: CreateRemoteADBDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_remote_adbdata_source_with_options(request, runtime)

    async def create_remote_adbdata_source_async(
        self,
        request: gpdb_20160503_models.CreateRemoteADBDataSourceRequest,
    ) -> gpdb_20160503_models.CreateRemoteADBDataSourceResponse:
        """
        @summary Create Homogeneous Data Source
        
        @param request: CreateRemoteADBDataSourceRequest
        @return: CreateRemoteADBDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_remote_adbdata_source_with_options_async(request, runtime)

    def create_sample_data_with_options(
        self,
        request: gpdb_20160503_models.CreateSampleDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateSampleDataResponse:
        """
        @summary Creates a sample dataset for an AnalyticDB for PostgreSQL instance.
        
        @description    You can call this operation to create a sample dataset for an AnalyticDB for PostgreSQL instance. Then, you can execute query statements on the sample dataset to experience or test your instance. For more information about query statements, see [Dataset information and query examples](https://help.aliyun.com/document_detail/452277.html).
        This operation is supported only for AnalyticDB for PostgreSQL V6.3.8.8 to 6.3.8.x, V6.3.10.3, and later.
        Versions from V6.3.9.0 to V6.3.10.2 are not supported.
        
        @param request: CreateSampleDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSampleDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSampleData',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateSampleDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_sample_data_with_options_async(
        self,
        request: gpdb_20160503_models.CreateSampleDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateSampleDataResponse:
        """
        @summary Creates a sample dataset for an AnalyticDB for PostgreSQL instance.
        
        @description    You can call this operation to create a sample dataset for an AnalyticDB for PostgreSQL instance. Then, you can execute query statements on the sample dataset to experience or test your instance. For more information about query statements, see [Dataset information and query examples](https://help.aliyun.com/document_detail/452277.html).
        This operation is supported only for AnalyticDB for PostgreSQL V6.3.8.8 to 6.3.8.x, V6.3.10.3, and later.
        Versions from V6.3.9.0 to V6.3.10.2 are not supported.
        
        @param request: CreateSampleDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSampleDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSampleData',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateSampleDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_sample_data(
        self,
        request: gpdb_20160503_models.CreateSampleDataRequest,
    ) -> gpdb_20160503_models.CreateSampleDataResponse:
        """
        @summary Creates a sample dataset for an AnalyticDB for PostgreSQL instance.
        
        @description    You can call this operation to create a sample dataset for an AnalyticDB for PostgreSQL instance. Then, you can execute query statements on the sample dataset to experience or test your instance. For more information about query statements, see [Dataset information and query examples](https://help.aliyun.com/document_detail/452277.html).
        This operation is supported only for AnalyticDB for PostgreSQL V6.3.8.8 to 6.3.8.x, V6.3.10.3, and later.
        Versions from V6.3.9.0 to V6.3.10.2 are not supported.
        
        @param request: CreateSampleDataRequest
        @return: CreateSampleDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_sample_data_with_options(request, runtime)

    async def create_sample_data_async(
        self,
        request: gpdb_20160503_models.CreateSampleDataRequest,
    ) -> gpdb_20160503_models.CreateSampleDataResponse:
        """
        @summary Creates a sample dataset for an AnalyticDB for PostgreSQL instance.
        
        @description    You can call this operation to create a sample dataset for an AnalyticDB for PostgreSQL instance. Then, you can execute query statements on the sample dataset to experience or test your instance. For more information about query statements, see [Dataset information and query examples](https://help.aliyun.com/document_detail/452277.html).
        This operation is supported only for AnalyticDB for PostgreSQL V6.3.8.8 to 6.3.8.x, V6.3.10.3, and later.
        Versions from V6.3.9.0 to V6.3.10.2 are not supported.
        
        @param request: CreateSampleDataRequest
        @return: CreateSampleDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_sample_data_with_options_async(request, runtime)

    def create_secret_with_options(
        self,
        request: gpdb_20160503_models.CreateSecretRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateSecretResponse:
        """
        @summary Creates an access credential for an AnalyticDB for PostgreSQL instance by using the name and password of a database account.
        
        @param request: CreateSecretRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecretResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_name):
            query['SecretName'] = request.secret_name
        if not UtilClient.is_unset(request.test_connection):
            query['TestConnection'] = request.test_connection
        if not UtilClient.is_unset(request.username):
            query['Username'] = request.username
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecret',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateSecretResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_secret_with_options_async(
        self,
        request: gpdb_20160503_models.CreateSecretRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateSecretResponse:
        """
        @summary Creates an access credential for an AnalyticDB for PostgreSQL instance by using the name and password of a database account.
        
        @param request: CreateSecretRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecretResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_name):
            query['SecretName'] = request.secret_name
        if not UtilClient.is_unset(request.test_connection):
            query['TestConnection'] = request.test_connection
        if not UtilClient.is_unset(request.username):
            query['Username'] = request.username
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecret',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateSecretResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_secret(
        self,
        request: gpdb_20160503_models.CreateSecretRequest,
    ) -> gpdb_20160503_models.CreateSecretResponse:
        """
        @summary Creates an access credential for an AnalyticDB for PostgreSQL instance by using the name and password of a database account.
        
        @param request: CreateSecretRequest
        @return: CreateSecretResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_secret_with_options(request, runtime)

    async def create_secret_async(
        self,
        request: gpdb_20160503_models.CreateSecretRequest,
    ) -> gpdb_20160503_models.CreateSecretResponse:
        """
        @summary Creates an access credential for an AnalyticDB for PostgreSQL instance by using the name and password of a database account.
        
        @param request: CreateSecretRequest
        @return: CreateSecretResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_secret_with_options_async(request, runtime)

    def create_service_linked_role_with_options(
        self,
        request: gpdb_20160503_models.CreateServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role.
        
        @param request: CreateServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceLinkedRole',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateServiceLinkedRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_service_linked_role_with_options_async(
        self,
        request: gpdb_20160503_models.CreateServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role.
        
        @param request: CreateServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceLinkedRole',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateServiceLinkedRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_service_linked_role(
        self,
        request: gpdb_20160503_models.CreateServiceLinkedRoleRequest,
    ) -> gpdb_20160503_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role.
        
        @param request: CreateServiceLinkedRoleRequest
        @return: CreateServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_service_linked_role_with_options(request, runtime)

    async def create_service_linked_role_async(
        self,
        request: gpdb_20160503_models.CreateServiceLinkedRoleRequest,
    ) -> gpdb_20160503_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role.
        
        @param request: CreateServiceLinkedRoleRequest
        @return: CreateServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_service_linked_role_with_options_async(request, runtime)

    def create_streaming_data_service_with_options(
        self,
        request: gpdb_20160503_models.CreateStreamingDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateStreamingDataServiceResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStreamingDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_description):
            query['ServiceDescription'] = request.service_description
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_spec):
            query['ServiceSpec'] = request.service_spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStreamingDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateStreamingDataServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_streaming_data_service_with_options_async(
        self,
        request: gpdb_20160503_models.CreateStreamingDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateStreamingDataServiceResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStreamingDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_description):
            query['ServiceDescription'] = request.service_description
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_spec):
            query['ServiceSpec'] = request.service_spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStreamingDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateStreamingDataServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_streaming_data_service(
        self,
        request: gpdb_20160503_models.CreateStreamingDataServiceRequest,
    ) -> gpdb_20160503_models.CreateStreamingDataServiceResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingDataServiceRequest
        @return: CreateStreamingDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_streaming_data_service_with_options(request, runtime)

    async def create_streaming_data_service_async(
        self,
        request: gpdb_20160503_models.CreateStreamingDataServiceRequest,
    ) -> gpdb_20160503_models.CreateStreamingDataServiceResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingDataServiceRequest
        @return: CreateStreamingDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_streaming_data_service_with_options_async(request, runtime)

    def create_streaming_data_source_with_options(
        self,
        request: gpdb_20160503_models.CreateStreamingDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateStreamingDataSourceResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStreamingDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_config):
            query['DataSourceConfig'] = request.data_source_config
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStreamingDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateStreamingDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_streaming_data_source_with_options_async(
        self,
        request: gpdb_20160503_models.CreateStreamingDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateStreamingDataSourceResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStreamingDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_config):
            query['DataSourceConfig'] = request.data_source_config
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStreamingDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateStreamingDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_streaming_data_source(
        self,
        request: gpdb_20160503_models.CreateStreamingDataSourceRequest,
    ) -> gpdb_20160503_models.CreateStreamingDataSourceResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingDataSourceRequest
        @return: CreateStreamingDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_streaming_data_source_with_options(request, runtime)

    async def create_streaming_data_source_async(
        self,
        request: gpdb_20160503_models.CreateStreamingDataSourceRequest,
    ) -> gpdb_20160503_models.CreateStreamingDataSourceResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingDataSourceRequest
        @return: CreateStreamingDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_streaming_data_source_with_options_async(request, runtime)

    def create_streaming_job_with_options(
        self,
        tmp_req: gpdb_20160503_models.CreateStreamingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateStreamingJobResponse:
        """
        @summary Create External Data Source Configuration
        
        @param tmp_req: CreateStreamingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStreamingJobResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.CreateStreamingJobShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dest_columns):
            request.dest_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dest_columns, 'DestColumns', 'json')
        if not UtilClient.is_unset(tmp_req.match_columns):
            request.match_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.match_columns, 'MatchColumns', 'json')
        if not UtilClient.is_unset(tmp_req.src_columns):
            request.src_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_columns, 'SrcColumns', 'json')
        if not UtilClient.is_unset(tmp_req.update_columns):
            request.update_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.update_columns, 'UpdateColumns', 'json')
        query = {}
        if not UtilClient.is_unset(request.account):
            query['Account'] = request.account
        if not UtilClient.is_unset(request.consistency):
            query['Consistency'] = request.consistency
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.dest_columns_shrink):
            query['DestColumns'] = request.dest_columns_shrink
        if not UtilClient.is_unset(request.dest_database):
            query['DestDatabase'] = request.dest_database
        if not UtilClient.is_unset(request.dest_schema):
            query['DestSchema'] = request.dest_schema
        if not UtilClient.is_unset(request.dest_table):
            query['DestTable'] = request.dest_table
        if not UtilClient.is_unset(request.error_limit_count):
            query['ErrorLimitCount'] = request.error_limit_count
        if not UtilClient.is_unset(request.fallback_offset):
            query['FallbackOffset'] = request.fallback_offset
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.job_config):
            query['JobConfig'] = request.job_config
        if not UtilClient.is_unset(request.job_description):
            query['JobDescription'] = request.job_description
        if not UtilClient.is_unset(request.job_name):
            query['JobName'] = request.job_name
        if not UtilClient.is_unset(request.match_columns_shrink):
            query['MatchColumns'] = request.match_columns_shrink
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.src_columns_shrink):
            query['SrcColumns'] = request.src_columns_shrink
        if not UtilClient.is_unset(request.try_run):
            query['TryRun'] = request.try_run
        if not UtilClient.is_unset(request.update_columns_shrink):
            query['UpdateColumns'] = request.update_columns_shrink
        if not UtilClient.is_unset(request.write_mode):
            query['WriteMode'] = request.write_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStreamingJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateStreamingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_streaming_job_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.CreateStreamingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateStreamingJobResponse:
        """
        @summary Create External Data Source Configuration
        
        @param tmp_req: CreateStreamingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStreamingJobResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.CreateStreamingJobShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dest_columns):
            request.dest_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dest_columns, 'DestColumns', 'json')
        if not UtilClient.is_unset(tmp_req.match_columns):
            request.match_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.match_columns, 'MatchColumns', 'json')
        if not UtilClient.is_unset(tmp_req.src_columns):
            request.src_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_columns, 'SrcColumns', 'json')
        if not UtilClient.is_unset(tmp_req.update_columns):
            request.update_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.update_columns, 'UpdateColumns', 'json')
        query = {}
        if not UtilClient.is_unset(request.account):
            query['Account'] = request.account
        if not UtilClient.is_unset(request.consistency):
            query['Consistency'] = request.consistency
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.dest_columns_shrink):
            query['DestColumns'] = request.dest_columns_shrink
        if not UtilClient.is_unset(request.dest_database):
            query['DestDatabase'] = request.dest_database
        if not UtilClient.is_unset(request.dest_schema):
            query['DestSchema'] = request.dest_schema
        if not UtilClient.is_unset(request.dest_table):
            query['DestTable'] = request.dest_table
        if not UtilClient.is_unset(request.error_limit_count):
            query['ErrorLimitCount'] = request.error_limit_count
        if not UtilClient.is_unset(request.fallback_offset):
            query['FallbackOffset'] = request.fallback_offset
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.job_config):
            query['JobConfig'] = request.job_config
        if not UtilClient.is_unset(request.job_description):
            query['JobDescription'] = request.job_description
        if not UtilClient.is_unset(request.job_name):
            query['JobName'] = request.job_name
        if not UtilClient.is_unset(request.match_columns_shrink):
            query['MatchColumns'] = request.match_columns_shrink
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.src_columns_shrink):
            query['SrcColumns'] = request.src_columns_shrink
        if not UtilClient.is_unset(request.try_run):
            query['TryRun'] = request.try_run
        if not UtilClient.is_unset(request.update_columns_shrink):
            query['UpdateColumns'] = request.update_columns_shrink
        if not UtilClient.is_unset(request.write_mode):
            query['WriteMode'] = request.write_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStreamingJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateStreamingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_streaming_job(
        self,
        request: gpdb_20160503_models.CreateStreamingJobRequest,
    ) -> gpdb_20160503_models.CreateStreamingJobResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingJobRequest
        @return: CreateStreamingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_streaming_job_with_options(request, runtime)

    async def create_streaming_job_async(
        self,
        request: gpdb_20160503_models.CreateStreamingJobRequest,
    ) -> gpdb_20160503_models.CreateStreamingJobResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: CreateStreamingJobRequest
        @return: CreateStreamingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_streaming_job_with_options_async(request, runtime)

    def create_supabase_project_with_options(
        self,
        request: gpdb_20160503_models.CreateSupabaseProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateSupabaseProjectResponse:
        """
        @summary 创建supabase project
        
        @param request: CreateSupabaseProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSupabaseProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.disk_performance_level):
            query['DiskPerformanceLevel'] = request.disk_performance_level
        if not UtilClient.is_unset(request.project_name):
            query['ProjectName'] = request.project_name
        if not UtilClient.is_unset(request.project_spec):
            query['ProjectSpec'] = request.project_spec
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        if not UtilClient.is_unset(request.storage_size):
            query['StorageSize'] = request.storage_size
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSupabaseProject',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateSupabaseProjectResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_supabase_project_with_options_async(
        self,
        request: gpdb_20160503_models.CreateSupabaseProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateSupabaseProjectResponse:
        """
        @summary 创建supabase project
        
        @param request: CreateSupabaseProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSupabaseProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.disk_performance_level):
            query['DiskPerformanceLevel'] = request.disk_performance_level
        if not UtilClient.is_unset(request.project_name):
            query['ProjectName'] = request.project_name
        if not UtilClient.is_unset(request.project_spec):
            query['ProjectSpec'] = request.project_spec
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        if not UtilClient.is_unset(request.storage_size):
            query['StorageSize'] = request.storage_size
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSupabaseProject',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateSupabaseProjectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_supabase_project(
        self,
        request: gpdb_20160503_models.CreateSupabaseProjectRequest,
    ) -> gpdb_20160503_models.CreateSupabaseProjectResponse:
        """
        @summary 创建supabase project
        
        @param request: CreateSupabaseProjectRequest
        @return: CreateSupabaseProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_supabase_project_with_options(request, runtime)

    async def create_supabase_project_async(
        self,
        request: gpdb_20160503_models.CreateSupabaseProjectRequest,
    ) -> gpdb_20160503_models.CreateSupabaseProjectResponse:
        """
        @summary 创建supabase project
        
        @param request: CreateSupabaseProjectRequest
        @return: CreateSupabaseProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_supabase_project_with_options_async(request, runtime)

    def create_vector_index_with_options(
        self,
        request: gpdb_20160503_models.CreateVectorIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateVectorIndexResponse:
        """
        @summary Create Vector Index
        
        @param request: CreateVectorIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVectorIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dimension):
            query['Dimension'] = request.dimension
        if not UtilClient.is_unset(request.external_storage):
            query['ExternalStorage'] = request.external_storage
        if not UtilClient.is_unset(request.hnsw_ef_construction):
            query['HnswEfConstruction'] = request.hnsw_ef_construction
        if not UtilClient.is_unset(request.hnsw_m):
            query['HnswM'] = request.hnsw_m
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pq_enable):
            query['PqEnable'] = request.pq_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVectorIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateVectorIndexResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vector_index_with_options_async(
        self,
        request: gpdb_20160503_models.CreateVectorIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.CreateVectorIndexResponse:
        """
        @summary Create Vector Index
        
        @param request: CreateVectorIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVectorIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dimension):
            query['Dimension'] = request.dimension
        if not UtilClient.is_unset(request.external_storage):
            query['ExternalStorage'] = request.external_storage
        if not UtilClient.is_unset(request.hnsw_ef_construction):
            query['HnswEfConstruction'] = request.hnsw_ef_construction
        if not UtilClient.is_unset(request.hnsw_m):
            query['HnswM'] = request.hnsw_m
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pq_enable):
            query['PqEnable'] = request.pq_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVectorIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.CreateVectorIndexResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vector_index(
        self,
        request: gpdb_20160503_models.CreateVectorIndexRequest,
    ) -> gpdb_20160503_models.CreateVectorIndexResponse:
        """
        @summary Create Vector Index
        
        @param request: CreateVectorIndexRequest
        @return: CreateVectorIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vector_index_with_options(request, runtime)

    async def create_vector_index_async(
        self,
        request: gpdb_20160503_models.CreateVectorIndexRequest,
    ) -> gpdb_20160503_models.CreateVectorIndexResponse:
        """
        @summary Create Vector Index
        
        @param request: CreateVectorIndexRequest
        @return: CreateVectorIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vector_index_with_options_async(request, runtime)

    def delete_account_with_options(
        self,
        request: gpdb_20160503_models.DeleteAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteAccountResponse:
        """
        @summary 删除数据库账号
        
        @param request: DeleteAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAccount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteAccountResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_account_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteAccountResponse:
        """
        @summary 删除数据库账号
        
        @param request: DeleteAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAccount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteAccountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_account(
        self,
        request: gpdb_20160503_models.DeleteAccountRequest,
    ) -> gpdb_20160503_models.DeleteAccountResponse:
        """
        @summary 删除数据库账号
        
        @param request: DeleteAccountRequest
        @return: DeleteAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_account_with_options(request, runtime)

    async def delete_account_async(
        self,
        request: gpdb_20160503_models.DeleteAccountRequest,
    ) -> gpdb_20160503_models.DeleteAccountResponse:
        """
        @summary 删除数据库账号
        
        @param request: DeleteAccountRequest
        @return: DeleteAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_account_with_options_async(request, runtime)

    def delete_backup_with_options(
        self,
        request: gpdb_20160503_models.DeleteBackupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteBackupResponse:
        """
        @summary 删除备份
        
        @param request: DeleteBackupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteBackupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_backup_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteBackupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteBackupResponse:
        """
        @summary 删除备份
        
        @param request: DeleteBackupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteBackupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_backup(
        self,
        request: gpdb_20160503_models.DeleteBackupRequest,
    ) -> gpdb_20160503_models.DeleteBackupResponse:
        """
        @summary 删除备份
        
        @param request: DeleteBackupRequest
        @return: DeleteBackupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_backup_with_options(request, runtime)

    async def delete_backup_async(
        self,
        request: gpdb_20160503_models.DeleteBackupRequest,
    ) -> gpdb_20160503_models.DeleteBackupResponse:
        """
        @summary 删除备份
        
        @param request: DeleteBackupRequest
        @return: DeleteBackupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_backup_with_options_async(request, runtime)

    def delete_collection_with_options(
        self,
        request: gpdb_20160503_models.DeleteCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteCollectionResponse:
        """
        @summary Deletes a vector collection.
        
        @param request: DeleteCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteCollectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_collection_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteCollectionResponse:
        """
        @summary Deletes a vector collection.
        
        @param request: DeleteCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteCollectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_collection(
        self,
        request: gpdb_20160503_models.DeleteCollectionRequest,
    ) -> gpdb_20160503_models.DeleteCollectionResponse:
        """
        @summary Deletes a vector collection.
        
        @param request: DeleteCollectionRequest
        @return: DeleteCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_collection_with_options(request, runtime)

    async def delete_collection_async(
        self,
        request: gpdb_20160503_models.DeleteCollectionRequest,
    ) -> gpdb_20160503_models.DeleteCollectionResponse:
        """
        @summary Deletes a vector collection.
        
        @param request: DeleteCollectionRequest
        @return: DeleteCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_collection_with_options_async(request, runtime)

    def delete_collection_data_with_options(
        self,
        request: gpdb_20160503_models.DeleteCollectionDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteCollectionDataResponse:
        """
        @summary Deletes vector data.
        
        @param request: DeleteCollectionDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCollectionDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.collection_data):
            query['CollectionData'] = request.collection_data
        if not UtilClient.is_unset(request.collection_data_filter):
            query['CollectionDataFilter'] = request.collection_data_filter
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCollectionData',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteCollectionDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_collection_data_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteCollectionDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteCollectionDataResponse:
        """
        @summary Deletes vector data.
        
        @param request: DeleteCollectionDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCollectionDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.collection_data):
            query['CollectionData'] = request.collection_data
        if not UtilClient.is_unset(request.collection_data_filter):
            query['CollectionDataFilter'] = request.collection_data_filter
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCollectionData',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteCollectionDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_collection_data(
        self,
        request: gpdb_20160503_models.DeleteCollectionDataRequest,
    ) -> gpdb_20160503_models.DeleteCollectionDataResponse:
        """
        @summary Deletes vector data.
        
        @param request: DeleteCollectionDataRequest
        @return: DeleteCollectionDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_collection_data_with_options(request, runtime)

    async def delete_collection_data_async(
        self,
        request: gpdb_20160503_models.DeleteCollectionDataRequest,
    ) -> gpdb_20160503_models.DeleteCollectionDataResponse:
        """
        @summary Deletes vector data.
        
        @param request: DeleteCollectionDataRequest
        @return: DeleteCollectionDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_collection_data_with_options_async(request, runtime)

    def delete_dbinstance_with_options(
        self,
        request: gpdb_20160503_models.DeleteDBInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDBInstanceResponse:
        """
        @summary Releases a pay-as-you-go AnalyticDB for PostgreSQL instance.
        
        @description    Subscription instances cannot be manually released. They are automatically released when they expire.
        You can call this operation to release pay-as-you-go instances only when they are in the **Running** state.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteDBInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBInstance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDBInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dbinstance_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteDBInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDBInstanceResponse:
        """
        @summary Releases a pay-as-you-go AnalyticDB for PostgreSQL instance.
        
        @description    Subscription instances cannot be manually released. They are automatically released when they expire.
        You can call this operation to release pay-as-you-go instances only when they are in the **Running** state.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteDBInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBInstance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDBInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dbinstance(
        self,
        request: gpdb_20160503_models.DeleteDBInstanceRequest,
    ) -> gpdb_20160503_models.DeleteDBInstanceResponse:
        """
        @summary Releases a pay-as-you-go AnalyticDB for PostgreSQL instance.
        
        @description    Subscription instances cannot be manually released. They are automatically released when they expire.
        You can call this operation to release pay-as-you-go instances only when they are in the **Running** state.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteDBInstanceRequest
        @return: DeleteDBInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dbinstance_with_options(request, runtime)

    async def delete_dbinstance_async(
        self,
        request: gpdb_20160503_models.DeleteDBInstanceRequest,
    ) -> gpdb_20160503_models.DeleteDBInstanceResponse:
        """
        @summary Releases a pay-as-you-go AnalyticDB for PostgreSQL instance.
        
        @description    Subscription instances cannot be manually released. They are automatically released when they expire.
        You can call this operation to release pay-as-you-go instances only when they are in the **Running** state.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteDBInstanceRequest
        @return: DeleteDBInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dbinstance_with_options_async(request, runtime)

    def delete_dbinstance_plan_with_options(
        self,
        request: gpdb_20160503_models.DeleteDBInstancePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDBInstancePlanResponse:
        """
        @summary Deletes a plan from an AnalyticDB for PostgreSQL instance.
        
        @description If you no longer need a plan, you can call this operation to delete the plan. The plan management feature is supported only for AnalyticDB for PostgreSQL instances in Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteDBInstancePlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBInstancePlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.plan_id):
            query['PlanId'] = request.plan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBInstancePlan',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDBInstancePlanResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dbinstance_plan_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteDBInstancePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDBInstancePlanResponse:
        """
        @summary Deletes a plan from an AnalyticDB for PostgreSQL instance.
        
        @description If you no longer need a plan, you can call this operation to delete the plan. The plan management feature is supported only for AnalyticDB for PostgreSQL instances in Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteDBInstancePlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBInstancePlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.plan_id):
            query['PlanId'] = request.plan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBInstancePlan',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDBInstancePlanResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dbinstance_plan(
        self,
        request: gpdb_20160503_models.DeleteDBInstancePlanRequest,
    ) -> gpdb_20160503_models.DeleteDBInstancePlanResponse:
        """
        @summary Deletes a plan from an AnalyticDB for PostgreSQL instance.
        
        @description If you no longer need a plan, you can call this operation to delete the plan. The plan management feature is supported only for AnalyticDB for PostgreSQL instances in Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteDBInstancePlanRequest
        @return: DeleteDBInstancePlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dbinstance_plan_with_options(request, runtime)

    async def delete_dbinstance_plan_async(
        self,
        request: gpdb_20160503_models.DeleteDBInstancePlanRequest,
    ) -> gpdb_20160503_models.DeleteDBInstancePlanResponse:
        """
        @summary Deletes a plan from an AnalyticDB for PostgreSQL instance.
        
        @description If you no longer need a plan, you can call this operation to delete the plan. The plan management feature is supported only for AnalyticDB for PostgreSQL instances in Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteDBInstancePlanRequest
        @return: DeleteDBInstancePlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dbinstance_plan_with_options_async(request, runtime)

    def delete_dbresource_group_with_options(
        self,
        request: gpdb_20160503_models.DeleteDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDBResourceGroupResponse:
        """
        @summary Deletes a resource group.
        
        @param request: DeleteDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDBResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dbresource_group_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDBResourceGroupResponse:
        """
        @summary Deletes a resource group.
        
        @param request: DeleteDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDBResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dbresource_group(
        self,
        request: gpdb_20160503_models.DeleteDBResourceGroupRequest,
    ) -> gpdb_20160503_models.DeleteDBResourceGroupResponse:
        """
        @summary Deletes a resource group.
        
        @param request: DeleteDBResourceGroupRequest
        @return: DeleteDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dbresource_group_with_options(request, runtime)

    async def delete_dbresource_group_async(
        self,
        request: gpdb_20160503_models.DeleteDBResourceGroupRequest,
    ) -> gpdb_20160503_models.DeleteDBResourceGroupResponse:
        """
        @summary Deletes a resource group.
        
        @param request: DeleteDBResourceGroupRequest
        @return: DeleteDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dbresource_group_with_options_async(request, runtime)

    def delete_document_with_options(
        self,
        request: gpdb_20160503_models.DeleteDocumentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDocumentResponse:
        """
        @summary Delete Document
        
        @param request: DeleteDocumentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDocumentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDocument',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDocumentResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_document_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteDocumentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDocumentResponse:
        """
        @summary Delete Document
        
        @param request: DeleteDocumentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDocumentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDocument',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDocumentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_document(
        self,
        request: gpdb_20160503_models.DeleteDocumentRequest,
    ) -> gpdb_20160503_models.DeleteDocumentResponse:
        """
        @summary Delete Document
        
        @param request: DeleteDocumentRequest
        @return: DeleteDocumentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_document_with_options(request, runtime)

    async def delete_document_async(
        self,
        request: gpdb_20160503_models.DeleteDocumentRequest,
    ) -> gpdb_20160503_models.DeleteDocumentResponse:
        """
        @summary Delete Document
        
        @param request: DeleteDocumentRequest
        @return: DeleteDocumentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_document_with_options_async(request, runtime)

    def delete_document_collection_with_options(
        self,
        request: gpdb_20160503_models.DeleteDocumentCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDocumentCollectionResponse:
        """
        @summary Delete Knowledge Base
        
        @param request: DeleteDocumentCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDocumentCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDocumentCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDocumentCollectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_document_collection_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteDocumentCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteDocumentCollectionResponse:
        """
        @summary Delete Knowledge Base
        
        @param request: DeleteDocumentCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDocumentCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDocumentCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteDocumentCollectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_document_collection(
        self,
        request: gpdb_20160503_models.DeleteDocumentCollectionRequest,
    ) -> gpdb_20160503_models.DeleteDocumentCollectionResponse:
        """
        @summary Delete Knowledge Base
        
        @param request: DeleteDocumentCollectionRequest
        @return: DeleteDocumentCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_document_collection_with_options(request, runtime)

    async def delete_document_collection_async(
        self,
        request: gpdb_20160503_models.DeleteDocumentCollectionRequest,
    ) -> gpdb_20160503_models.DeleteDocumentCollectionResponse:
        """
        @summary Delete Knowledge Base
        
        @param request: DeleteDocumentCollectionRequest
        @return: DeleteDocumentCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_document_collection_with_options_async(request, runtime)

    def delete_extension_with_options(
        self,
        request: gpdb_20160503_models.DeleteExtensionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteExtensionResponse:
        """
        @summary Uninstall an extension.
        
        @param request: DeleteExtensionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteExtensionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dbnames):
            query['DBNames'] = request.dbnames
        if not UtilClient.is_unset(request.extension):
            query['Extension'] = request.extension
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteExtension',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteExtensionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_extension_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteExtensionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteExtensionResponse:
        """
        @summary Uninstall an extension.
        
        @param request: DeleteExtensionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteExtensionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dbnames):
            query['DBNames'] = request.dbnames
        if not UtilClient.is_unset(request.extension):
            query['Extension'] = request.extension
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteExtension',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteExtensionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_extension(
        self,
        request: gpdb_20160503_models.DeleteExtensionRequest,
    ) -> gpdb_20160503_models.DeleteExtensionResponse:
        """
        @summary Uninstall an extension.
        
        @param request: DeleteExtensionRequest
        @return: DeleteExtensionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_extension_with_options(request, runtime)

    async def delete_extension_async(
        self,
        request: gpdb_20160503_models.DeleteExtensionRequest,
    ) -> gpdb_20160503_models.DeleteExtensionResponse:
        """
        @summary Uninstall an extension.
        
        @param request: DeleteExtensionRequest
        @return: DeleteExtensionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_extension_with_options_async(request, runtime)

    def delete_external_data_service_with_options(
        self,
        request: gpdb_20160503_models.DeleteExternalDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteExternalDataServiceResponse:
        """
        @summary Delete External Data Service
        
        @param request: DeleteExternalDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteExternalDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteExternalDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteExternalDataServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_external_data_service_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteExternalDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteExternalDataServiceResponse:
        """
        @summary Delete External Data Service
        
        @param request: DeleteExternalDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteExternalDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteExternalDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteExternalDataServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_external_data_service(
        self,
        request: gpdb_20160503_models.DeleteExternalDataServiceRequest,
    ) -> gpdb_20160503_models.DeleteExternalDataServiceResponse:
        """
        @summary Delete External Data Service
        
        @param request: DeleteExternalDataServiceRequest
        @return: DeleteExternalDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_external_data_service_with_options(request, runtime)

    async def delete_external_data_service_async(
        self,
        request: gpdb_20160503_models.DeleteExternalDataServiceRequest,
    ) -> gpdb_20160503_models.DeleteExternalDataServiceResponse:
        """
        @summary Delete External Data Service
        
        @param request: DeleteExternalDataServiceRequest
        @return: DeleteExternalDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_external_data_service_with_options_async(request, runtime)

    def delete_hadoop_data_source_with_options(
        self,
        request: gpdb_20160503_models.DeleteHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteHadoopDataSourceResponse:
        """
        @summary 删除hadoop数据源
        
        @param request: DeleteHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteHadoopDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_hadoop_data_source_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteHadoopDataSourceResponse:
        """
        @summary 删除hadoop数据源
        
        @param request: DeleteHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteHadoopDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_hadoop_data_source(
        self,
        request: gpdb_20160503_models.DeleteHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.DeleteHadoopDataSourceResponse:
        """
        @summary 删除hadoop数据源
        
        @param request: DeleteHadoopDataSourceRequest
        @return: DeleteHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_hadoop_data_source_with_options(request, runtime)

    async def delete_hadoop_data_source_async(
        self,
        request: gpdb_20160503_models.DeleteHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.DeleteHadoopDataSourceResponse:
        """
        @summary 删除hadoop数据源
        
        @param request: DeleteHadoopDataSourceRequest
        @return: DeleteHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_hadoop_data_source_with_options_async(request, runtime)

    def delete_index_with_options(
        self,
        request: gpdb_20160503_models.DeleteIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteIndexResponse:
        """
        @summary 删除索引
        
        @param request: DeleteIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.index_name):
            query['IndexName'] = request.index_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteIndexResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_index_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteIndexResponse:
        """
        @summary 删除索引
        
        @param request: DeleteIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.index_name):
            query['IndexName'] = request.index_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteIndexResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_index(
        self,
        request: gpdb_20160503_models.DeleteIndexRequest,
    ) -> gpdb_20160503_models.DeleteIndexResponse:
        """
        @summary 删除索引
        
        @param request: DeleteIndexRequest
        @return: DeleteIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_index_with_options(request, runtime)

    async def delete_index_async(
        self,
        request: gpdb_20160503_models.DeleteIndexRequest,
    ) -> gpdb_20160503_models.DeleteIndexResponse:
        """
        @summary 删除索引
        
        @param request: DeleteIndexRequest
        @return: DeleteIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_index_with_options_async(request, runtime)

    def delete_jdbcdata_source_with_options(
        self,
        request: gpdb_20160503_models.DeleteJDBCDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteJDBCDataSourceResponse:
        """
        @summary Delete JDBC data source
        
        @param request: DeleteJDBCDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteJDBCDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteJDBCDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteJDBCDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_jdbcdata_source_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteJDBCDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteJDBCDataSourceResponse:
        """
        @summary Delete JDBC data source
        
        @param request: DeleteJDBCDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteJDBCDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteJDBCDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteJDBCDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_jdbcdata_source(
        self,
        request: gpdb_20160503_models.DeleteJDBCDataSourceRequest,
    ) -> gpdb_20160503_models.DeleteJDBCDataSourceResponse:
        """
        @summary Delete JDBC data source
        
        @param request: DeleteJDBCDataSourceRequest
        @return: DeleteJDBCDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_jdbcdata_source_with_options(request, runtime)

    async def delete_jdbcdata_source_async(
        self,
        request: gpdb_20160503_models.DeleteJDBCDataSourceRequest,
    ) -> gpdb_20160503_models.DeleteJDBCDataSourceResponse:
        """
        @summary Delete JDBC data source
        
        @param request: DeleteJDBCDataSourceRequest
        @return: DeleteJDBCDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_jdbcdata_source_with_options_async(request, runtime)

    def delete_namespace_with_options(
        self,
        request: gpdb_20160503_models.DeleteNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteNamespaceResponse:
        """
        @summary Deletes a namespace.
        
        @param request: DeleteNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNamespace',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteNamespaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_namespace_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteNamespaceResponse:
        """
        @summary Deletes a namespace.
        
        @param request: DeleteNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNamespace',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteNamespaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_namespace(
        self,
        request: gpdb_20160503_models.DeleteNamespaceRequest,
    ) -> gpdb_20160503_models.DeleteNamespaceResponse:
        """
        @summary Deletes a namespace.
        
        @param request: DeleteNamespaceRequest
        @return: DeleteNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_namespace_with_options(request, runtime)

    async def delete_namespace_async(
        self,
        request: gpdb_20160503_models.DeleteNamespaceRequest,
    ) -> gpdb_20160503_models.DeleteNamespaceResponse:
        """
        @summary Deletes a namespace.
        
        @param request: DeleteNamespaceRequest
        @return: DeleteNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_namespace_with_options_async(request, runtime)

    def delete_remote_adbdata_source_with_options(
        self,
        request: gpdb_20160503_models.DeleteRemoteADBDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteRemoteADBDataSourceResponse:
        """
        @summary Deletes a remote AnalyticDB data source.
        
        @param request: DeleteRemoteADBDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRemoteADBDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.local_dbinstance_id):
            query['LocalDBInstanceId'] = request.local_dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRemoteADBDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteRemoteADBDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_remote_adbdata_source_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteRemoteADBDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteRemoteADBDataSourceResponse:
        """
        @summary Deletes a remote AnalyticDB data source.
        
        @param request: DeleteRemoteADBDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRemoteADBDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.local_dbinstance_id):
            query['LocalDBInstanceId'] = request.local_dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRemoteADBDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteRemoteADBDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_remote_adbdata_source(
        self,
        request: gpdb_20160503_models.DeleteRemoteADBDataSourceRequest,
    ) -> gpdb_20160503_models.DeleteRemoteADBDataSourceResponse:
        """
        @summary Deletes a remote AnalyticDB data source.
        
        @param request: DeleteRemoteADBDataSourceRequest
        @return: DeleteRemoteADBDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_remote_adbdata_source_with_options(request, runtime)

    async def delete_remote_adbdata_source_async(
        self,
        request: gpdb_20160503_models.DeleteRemoteADBDataSourceRequest,
    ) -> gpdb_20160503_models.DeleteRemoteADBDataSourceResponse:
        """
        @summary Deletes a remote AnalyticDB data source.
        
        @param request: DeleteRemoteADBDataSourceRequest
        @return: DeleteRemoteADBDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_remote_adbdata_source_with_options_async(request, runtime)

    def delete_secret_with_options(
        self,
        request: gpdb_20160503_models.DeleteSecretRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteSecretResponse:
        """
        @summary Deletes the access credentials of an AnalyticDB for PostgreSQL instance.
        
        @param request: DeleteSecretRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecretResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.secret_name):
            query['SecretName'] = request.secret_name
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecret',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteSecretResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_secret_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteSecretRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteSecretResponse:
        """
        @summary Deletes the access credentials of an AnalyticDB for PostgreSQL instance.
        
        @param request: DeleteSecretRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecretResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.secret_name):
            query['SecretName'] = request.secret_name
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecret',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteSecretResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_secret(
        self,
        request: gpdb_20160503_models.DeleteSecretRequest,
    ) -> gpdb_20160503_models.DeleteSecretResponse:
        """
        @summary Deletes the access credentials of an AnalyticDB for PostgreSQL instance.
        
        @param request: DeleteSecretRequest
        @return: DeleteSecretResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_secret_with_options(request, runtime)

    async def delete_secret_async(
        self,
        request: gpdb_20160503_models.DeleteSecretRequest,
    ) -> gpdb_20160503_models.DeleteSecretResponse:
        """
        @summary Deletes the access credentials of an AnalyticDB for PostgreSQL instance.
        
        @param request: DeleteSecretRequest
        @return: DeleteSecretResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_secret_with_options_async(request, runtime)

    def delete_streaming_data_service_with_options(
        self,
        request: gpdb_20160503_models.DeleteStreamingDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteStreamingDataServiceResponse:
        """
        @summary Deletes a real-time data service.
        
        @param request: DeleteStreamingDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStreamingDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStreamingDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteStreamingDataServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_streaming_data_service_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteStreamingDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteStreamingDataServiceResponse:
        """
        @summary Deletes a real-time data service.
        
        @param request: DeleteStreamingDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStreamingDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStreamingDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteStreamingDataServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_streaming_data_service(
        self,
        request: gpdb_20160503_models.DeleteStreamingDataServiceRequest,
    ) -> gpdb_20160503_models.DeleteStreamingDataServiceResponse:
        """
        @summary Deletes a real-time data service.
        
        @param request: DeleteStreamingDataServiceRequest
        @return: DeleteStreamingDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_streaming_data_service_with_options(request, runtime)

    async def delete_streaming_data_service_async(
        self,
        request: gpdb_20160503_models.DeleteStreamingDataServiceRequest,
    ) -> gpdb_20160503_models.DeleteStreamingDataServiceResponse:
        """
        @summary Deletes a real-time data service.
        
        @param request: DeleteStreamingDataServiceRequest
        @return: DeleteStreamingDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_streaming_data_service_with_options_async(request, runtime)

    def delete_streaming_data_source_with_options(
        self,
        request: gpdb_20160503_models.DeleteStreamingDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteStreamingDataSourceResponse:
        """
        @summary Deletes a real-time data source.
        
        @param request: DeleteStreamingDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStreamingDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStreamingDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteStreamingDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_streaming_data_source_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteStreamingDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteStreamingDataSourceResponse:
        """
        @summary Deletes a real-time data source.
        
        @param request: DeleteStreamingDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStreamingDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStreamingDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteStreamingDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_streaming_data_source(
        self,
        request: gpdb_20160503_models.DeleteStreamingDataSourceRequest,
    ) -> gpdb_20160503_models.DeleteStreamingDataSourceResponse:
        """
        @summary Deletes a real-time data source.
        
        @param request: DeleteStreamingDataSourceRequest
        @return: DeleteStreamingDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_streaming_data_source_with_options(request, runtime)

    async def delete_streaming_data_source_async(
        self,
        request: gpdb_20160503_models.DeleteStreamingDataSourceRequest,
    ) -> gpdb_20160503_models.DeleteStreamingDataSourceResponse:
        """
        @summary Deletes a real-time data source.
        
        @param request: DeleteStreamingDataSourceRequest
        @return: DeleteStreamingDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_streaming_data_source_with_options_async(request, runtime)

    def delete_streaming_job_with_options(
        self,
        request: gpdb_20160503_models.DeleteStreamingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteStreamingJobResponse:
        """
        @summary Deletes a real-time data service job.
        
        @param request: DeleteStreamingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStreamingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStreamingJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteStreamingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_streaming_job_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteStreamingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteStreamingJobResponse:
        """
        @summary Deletes a real-time data service job.
        
        @param request: DeleteStreamingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStreamingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStreamingJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteStreamingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_streaming_job(
        self,
        request: gpdb_20160503_models.DeleteStreamingJobRequest,
    ) -> gpdb_20160503_models.DeleteStreamingJobResponse:
        """
        @summary Deletes a real-time data service job.
        
        @param request: DeleteStreamingJobRequest
        @return: DeleteStreamingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_streaming_job_with_options(request, runtime)

    async def delete_streaming_job_async(
        self,
        request: gpdb_20160503_models.DeleteStreamingJobRequest,
    ) -> gpdb_20160503_models.DeleteStreamingJobResponse:
        """
        @summary Deletes a real-time data service job.
        
        @param request: DeleteStreamingJobRequest
        @return: DeleteStreamingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_streaming_job_with_options_async(request, runtime)

    def delete_supabase_project_with_options(
        self,
        request: gpdb_20160503_models.DeleteSupabaseProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteSupabaseProjectResponse:
        """
        @summary 删除Supabase实例
        
        @param request: DeleteSupabaseProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSupabaseProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSupabaseProject',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteSupabaseProjectResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_supabase_project_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteSupabaseProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteSupabaseProjectResponse:
        """
        @summary 删除Supabase实例
        
        @param request: DeleteSupabaseProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSupabaseProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSupabaseProject',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteSupabaseProjectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_supabase_project(
        self,
        request: gpdb_20160503_models.DeleteSupabaseProjectRequest,
    ) -> gpdb_20160503_models.DeleteSupabaseProjectResponse:
        """
        @summary 删除Supabase实例
        
        @param request: DeleteSupabaseProjectRequest
        @return: DeleteSupabaseProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_supabase_project_with_options(request, runtime)

    async def delete_supabase_project_async(
        self,
        request: gpdb_20160503_models.DeleteSupabaseProjectRequest,
    ) -> gpdb_20160503_models.DeleteSupabaseProjectResponse:
        """
        @summary 删除Supabase实例
        
        @param request: DeleteSupabaseProjectRequest
        @return: DeleteSupabaseProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_supabase_project_with_options_async(request, runtime)

    def delete_vector_index_with_options(
        self,
        request: gpdb_20160503_models.DeleteVectorIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteVectorIndexResponse:
        """
        @summary Deletes a vector index.
        
        @param request: DeleteVectorIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVectorIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVectorIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteVectorIndexResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vector_index_with_options_async(
        self,
        request: gpdb_20160503_models.DeleteVectorIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DeleteVectorIndexResponse:
        """
        @summary Deletes a vector index.
        
        @param request: DeleteVectorIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVectorIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVectorIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DeleteVectorIndexResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vector_index(
        self,
        request: gpdb_20160503_models.DeleteVectorIndexRequest,
    ) -> gpdb_20160503_models.DeleteVectorIndexResponse:
        """
        @summary Deletes a vector index.
        
        @param request: DeleteVectorIndexRequest
        @return: DeleteVectorIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vector_index_with_options(request, runtime)

    async def delete_vector_index_async(
        self,
        request: gpdb_20160503_models.DeleteVectorIndexRequest,
    ) -> gpdb_20160503_models.DeleteVectorIndexResponse:
        """
        @summary Deletes a vector index.
        
        @param request: DeleteVectorIndexRequest
        @return: DeleteVectorIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vector_index_with_options_async(request, runtime)

    def describe_accounts_with_options(
        self,
        request: gpdb_20160503_models.DescribeAccountsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeAccountsResponse:
        """
        @summary Queries the information about database accounts for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is called to query the information of the privileged account in an AnalyticDB for PostgreSQL instance, such as its state, description, and the instance.
        ## Limit
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAccountsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_type):
            query['AccountType'] = request.account_type
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccounts',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeAccountsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_accounts_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeAccountsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeAccountsResponse:
        """
        @summary Queries the information about database accounts for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is called to query the information of the privileged account in an AnalyticDB for PostgreSQL instance, such as its state, description, and the instance.
        ## Limit
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAccountsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_type):
            query['AccountType'] = request.account_type
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccounts',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeAccountsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_accounts(
        self,
        request: gpdb_20160503_models.DescribeAccountsRequest,
    ) -> gpdb_20160503_models.DescribeAccountsResponse:
        """
        @summary Queries the information about database accounts for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is called to query the information of the privileged account in an AnalyticDB for PostgreSQL instance, such as its state, description, and the instance.
        ## Limit
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAccountsRequest
        @return: DescribeAccountsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_accounts_with_options(request, runtime)

    async def describe_accounts_async(
        self,
        request: gpdb_20160503_models.DescribeAccountsRequest,
    ) -> gpdb_20160503_models.DescribeAccountsResponse:
        """
        @summary Queries the information about database accounts for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is called to query the information of the privileged account in an AnalyticDB for PostgreSQL instance, such as its state, description, and the instance.
        ## Limit
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAccountsRequest
        @return: DescribeAccountsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_accounts_with_options_async(request, runtime)

    def describe_active_sqlrecords_with_options(
        self,
        request: gpdb_20160503_models.DescribeActiveSQLRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeActiveSQLRecordsResponse:
        """
        @summary Queries active SQL records.
        
        @param request: DescribeActiveSQLRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActiveSQLRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_duration):
            query['MaxDuration'] = request.max_duration
        if not UtilClient.is_unset(request.min_duration):
            query['MinDuration'] = request.min_duration
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActiveSQLRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeActiveSQLRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_active_sqlrecords_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeActiveSQLRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeActiveSQLRecordsResponse:
        """
        @summary Queries active SQL records.
        
        @param request: DescribeActiveSQLRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActiveSQLRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_duration):
            query['MaxDuration'] = request.max_duration
        if not UtilClient.is_unset(request.min_duration):
            query['MinDuration'] = request.min_duration
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActiveSQLRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeActiveSQLRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_active_sqlrecords(
        self,
        request: gpdb_20160503_models.DescribeActiveSQLRecordsRequest,
    ) -> gpdb_20160503_models.DescribeActiveSQLRecordsResponse:
        """
        @summary Queries active SQL records.
        
        @param request: DescribeActiveSQLRecordsRequest
        @return: DescribeActiveSQLRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_active_sqlrecords_with_options(request, runtime)

    async def describe_active_sqlrecords_async(
        self,
        request: gpdb_20160503_models.DescribeActiveSQLRecordsRequest,
    ) -> gpdb_20160503_models.DescribeActiveSQLRecordsResponse:
        """
        @summary Queries active SQL records.
        
        @param request: DescribeActiveSQLRecordsRequest
        @return: DescribeActiveSQLRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_active_sqlrecords_with_options_async(request, runtime)

    def describe_available_resources_with_options(
        self,
        request: gpdb_20160503_models.DescribeAvailableResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeAvailableResourcesResponse:
        """
        @summary Queries the information about available resources of AnalyticDB for PostgreSQL.
        
        @description When you create an AnalyticDB for PostgreSQL instance, you can call this operation to query the available resources within a zone.
        
        @param request: DescribeAvailableResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAvailableResources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeAvailableResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_available_resources_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeAvailableResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeAvailableResourcesResponse:
        """
        @summary Queries the information about available resources of AnalyticDB for PostgreSQL.
        
        @description When you create an AnalyticDB for PostgreSQL instance, you can call this operation to query the available resources within a zone.
        
        @param request: DescribeAvailableResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAvailableResources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeAvailableResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_available_resources(
        self,
        request: gpdb_20160503_models.DescribeAvailableResourcesRequest,
    ) -> gpdb_20160503_models.DescribeAvailableResourcesResponse:
        """
        @summary Queries the information about available resources of AnalyticDB for PostgreSQL.
        
        @description When you create an AnalyticDB for PostgreSQL instance, you can call this operation to query the available resources within a zone.
        
        @param request: DescribeAvailableResourcesRequest
        @return: DescribeAvailableResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_available_resources_with_options(request, runtime)

    async def describe_available_resources_async(
        self,
        request: gpdb_20160503_models.DescribeAvailableResourcesRequest,
    ) -> gpdb_20160503_models.DescribeAvailableResourcesResponse:
        """
        @summary Queries the information about available resources of AnalyticDB for PostgreSQL.
        
        @description When you create an AnalyticDB for PostgreSQL instance, you can call this operation to query the available resources within a zone.
        
        @param request: DescribeAvailableResourcesRequest
        @return: DescribeAvailableResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_available_resources_with_options_async(request, runtime)

    def describe_backup_job_with_options(
        self,
        request: gpdb_20160503_models.DescribeBackupJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeBackupJobResponse:
        """
        @summary 获取备份任务详情
        
        @param request: DescribeBackupJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_job_id):
            query['BackupJobId'] = request.backup_job_id
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeBackupJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_job_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeBackupJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeBackupJobResponse:
        """
        @summary 获取备份任务详情
        
        @param request: DescribeBackupJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_job_id):
            query['BackupJobId'] = request.backup_job_id
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeBackupJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_job(
        self,
        request: gpdb_20160503_models.DescribeBackupJobRequest,
    ) -> gpdb_20160503_models.DescribeBackupJobResponse:
        """
        @summary 获取备份任务详情
        
        @param request: DescribeBackupJobRequest
        @return: DescribeBackupJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_job_with_options(request, runtime)

    async def describe_backup_job_async(
        self,
        request: gpdb_20160503_models.DescribeBackupJobRequest,
    ) -> gpdb_20160503_models.DescribeBackupJobResponse:
        """
        @summary 获取备份任务详情
        
        @param request: DescribeBackupJobRequest
        @return: DescribeBackupJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_job_with_options_async(request, runtime)

    def describe_backup_policy_with_options(
        self,
        request: gpdb_20160503_models.DescribeBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the backup policy of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the backup settings of an AnalyticDB for PostgreSQL instance in elastic storage mode. Periodically backing data can prevent data loss. For more information about how to modify backup policies, see [ModifyBackupPolicy](https://help.aliyun.com/document_detail/210095.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicy',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_policy_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the backup policy of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the backup settings of an AnalyticDB for PostgreSQL instance in elastic storage mode. Periodically backing data can prevent data loss. For more information about how to modify backup policies, see [ModifyBackupPolicy](https://help.aliyun.com/document_detail/210095.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicy',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_policy(
        self,
        request: gpdb_20160503_models.DescribeBackupPolicyRequest,
    ) -> gpdb_20160503_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the backup policy of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the backup settings of an AnalyticDB for PostgreSQL instance in elastic storage mode. Periodically backing data can prevent data loss. For more information about how to modify backup policies, see [ModifyBackupPolicy](https://help.aliyun.com/document_detail/210095.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeBackupPolicyRequest
        @return: DescribeBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_policy_with_options(request, runtime)

    async def describe_backup_policy_async(
        self,
        request: gpdb_20160503_models.DescribeBackupPolicyRequest,
    ) -> gpdb_20160503_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the backup policy of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the backup settings of an AnalyticDB for PostgreSQL instance in elastic storage mode. Periodically backing data can prevent data loss. For more information about how to modify backup policies, see [ModifyBackupPolicy](https://help.aliyun.com/document_detail/210095.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeBackupPolicyRequest
        @return: DescribeBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_policy_with_options_async(request, runtime)

    def describe_collection_with_options(
        self,
        request: gpdb_20160503_models.DescribeCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeCollectionResponse:
        """
        @summary Queries the information about a vector collection.
        
        @param request: DescribeCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeCollectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_collection_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeCollectionResponse:
        """
        @summary Queries the information about a vector collection.
        
        @param request: DescribeCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeCollectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_collection(
        self,
        request: gpdb_20160503_models.DescribeCollectionRequest,
    ) -> gpdb_20160503_models.DescribeCollectionResponse:
        """
        @summary Queries the information about a vector collection.
        
        @param request: DescribeCollectionRequest
        @return: DescribeCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_collection_with_options(request, runtime)

    async def describe_collection_async(
        self,
        request: gpdb_20160503_models.DescribeCollectionRequest,
    ) -> gpdb_20160503_models.DescribeCollectionResponse:
        """
        @summary Queries the information about a vector collection.
        
        @param request: DescribeCollectionRequest
        @return: DescribeCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_collection_with_options_async(request, runtime)

    def describe_create_index_job_with_options(
        self,
        request: gpdb_20160503_models.DescribeCreateIndexJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeCreateIndexJobResponse:
        """
        @summary 获取创建索引任务
        
        @param request: DescribeCreateIndexJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCreateIndexJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCreateIndexJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeCreateIndexJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_create_index_job_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeCreateIndexJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeCreateIndexJobResponse:
        """
        @summary 获取创建索引任务
        
        @param request: DescribeCreateIndexJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCreateIndexJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCreateIndexJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeCreateIndexJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_create_index_job(
        self,
        request: gpdb_20160503_models.DescribeCreateIndexJobRequest,
    ) -> gpdb_20160503_models.DescribeCreateIndexJobResponse:
        """
        @summary 获取创建索引任务
        
        @param request: DescribeCreateIndexJobRequest
        @return: DescribeCreateIndexJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_create_index_job_with_options(request, runtime)

    async def describe_create_index_job_async(
        self,
        request: gpdb_20160503_models.DescribeCreateIndexJobRequest,
    ) -> gpdb_20160503_models.DescribeCreateIndexJobResponse:
        """
        @summary 获取创建索引任务
        
        @param request: DescribeCreateIndexJobRequest
        @return: DescribeCreateIndexJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_create_index_job_with_options_async(request, runtime)

    def describe_dbcluster_node_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBClusterNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBClusterNodeResponse:
        """
        @summary Queries a list of nodes in an AnalyticDB for PostgreSQL instance.
        
        @description ##
        You can call this operation to query the information about coordinator and compute nodes in an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBClusterNodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterNodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterNode',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBClusterNodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_node_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBClusterNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBClusterNodeResponse:
        """
        @summary Queries a list of nodes in an AnalyticDB for PostgreSQL instance.
        
        @description ##
        You can call this operation to query the information about coordinator and compute nodes in an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBClusterNodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterNodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterNode',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBClusterNodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_node(
        self,
        request: gpdb_20160503_models.DescribeDBClusterNodeRequest,
    ) -> gpdb_20160503_models.DescribeDBClusterNodeResponse:
        """
        @summary Queries a list of nodes in an AnalyticDB for PostgreSQL instance.
        
        @description ##
        You can call this operation to query the information about coordinator and compute nodes in an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBClusterNodeRequest
        @return: DescribeDBClusterNodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_node_with_options(request, runtime)

    async def describe_dbcluster_node_async(
        self,
        request: gpdb_20160503_models.DescribeDBClusterNodeRequest,
    ) -> gpdb_20160503_models.DescribeDBClusterNodeResponse:
        """
        @summary Queries a list of nodes in an AnalyticDB for PostgreSQL instance.
        
        @description ##
        You can call this operation to query the information about coordinator and compute nodes in an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBClusterNodeRequest
        @return: DescribeDBClusterNodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_node_with_options_async(request, runtime)

    def describe_dbcluster_performance_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBClusterPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBClusterPerformanceResponse:
        """
        @summary Queries the information about performance metrics of an AnalyticDB for PostgreSQL instance within a time range.
        
        @description You can query monitoring information only within the last 30 days.
        
        @param request: DescribeDBClusterPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.nodes):
            query['Nodes'] = request.nodes
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterPerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBClusterPerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbcluster_performance_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBClusterPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBClusterPerformanceResponse:
        """
        @summary Queries the information about performance metrics of an AnalyticDB for PostgreSQL instance within a time range.
        
        @description You can query monitoring information only within the last 30 days.
        
        @param request: DescribeDBClusterPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBClusterPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.node_type):
            query['NodeType'] = request.node_type
        if not UtilClient.is_unset(request.nodes):
            query['Nodes'] = request.nodes
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBClusterPerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBClusterPerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbcluster_performance(
        self,
        request: gpdb_20160503_models.DescribeDBClusterPerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDBClusterPerformanceResponse:
        """
        @summary Queries the information about performance metrics of an AnalyticDB for PostgreSQL instance within a time range.
        
        @description You can query monitoring information only within the last 30 days.
        
        @param request: DescribeDBClusterPerformanceRequest
        @return: DescribeDBClusterPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbcluster_performance_with_options(request, runtime)

    async def describe_dbcluster_performance_async(
        self,
        request: gpdb_20160503_models.DescribeDBClusterPerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDBClusterPerformanceResponse:
        """
        @summary Queries the information about performance metrics of an AnalyticDB for PostgreSQL instance within a time range.
        
        @description You can query monitoring information only within the last 30 days.
        
        @param request: DescribeDBClusterPerformanceRequest
        @return: DescribeDBClusterPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbcluster_performance_with_options_async(request, runtime)

    def describe_dbinstance_attribute_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceAttributeResponse:
        """
        @summary Query detailed information about the instance.
        
        @description ## Usage Instructions
        This interface is generally used to view information such as the specifications, network type, and instance status of AnalyticDB for PostgreSQL instances.
        ## QPS Limitation
        The default single-user QPS limit for this interface is 1000 times/second. If the limit is exceeded, API calls will be throttled, which may affect your business. Please use it reasonably.
        <props="china">The QPS in this document is only a default reference value. For accurate information, please refer to the [API Rate Quota List](https://quotas.console.aliyun.com/flow-control-products/gpdb/quotas).
        
        @param request: DescribeDBInstanceAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceAttribute',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_attribute_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceAttributeResponse:
        """
        @summary Query detailed information about the instance.
        
        @description ## Usage Instructions
        This interface is generally used to view information such as the specifications, network type, and instance status of AnalyticDB for PostgreSQL instances.
        ## QPS Limitation
        The default single-user QPS limit for this interface is 1000 times/second. If the limit is exceeded, API calls will be throttled, which may affect your business. Please use it reasonably.
        <props="china">The QPS in this document is only a default reference value. For accurate information, please refer to the [API Rate Quota List](https://quotas.console.aliyun.com/flow-control-products/gpdb/quotas).
        
        @param request: DescribeDBInstanceAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceAttribute',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_attribute(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceAttributeRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceAttributeResponse:
        """
        @summary Query detailed information about the instance.
        
        @description ## Usage Instructions
        This interface is generally used to view information such as the specifications, network type, and instance status of AnalyticDB for PostgreSQL instances.
        ## QPS Limitation
        The default single-user QPS limit for this interface is 1000 times/second. If the limit is exceeded, API calls will be throttled, which may affect your business. Please use it reasonably.
        <props="china">The QPS in this document is only a default reference value. For accurate information, please refer to the [API Rate Quota List](https://quotas.console.aliyun.com/flow-control-products/gpdb/quotas).
        
        @param request: DescribeDBInstanceAttributeRequest
        @return: DescribeDBInstanceAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_attribute_with_options(request, runtime)

    async def describe_dbinstance_attribute_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceAttributeRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceAttributeResponse:
        """
        @summary Query detailed information about the instance.
        
        @description ## Usage Instructions
        This interface is generally used to view information such as the specifications, network type, and instance status of AnalyticDB for PostgreSQL instances.
        ## QPS Limitation
        The default single-user QPS limit for this interface is 1000 times/second. If the limit is exceeded, API calls will be throttled, which may affect your business. Please use it reasonably.
        <props="china">The QPS in this document is only a default reference value. For accurate information, please refer to the [API Rate Quota List](https://quotas.console.aliyun.com/flow-control-products/gpdb/quotas).
        
        @param request: DescribeDBInstanceAttributeRequest
        @return: DescribeDBInstanceAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_attribute_with_options_async(request, runtime)

    def describe_dbinstance_data_bloat_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDataBloatRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceDataBloatResponse:
        """
        @summary Queries the information about data bloat for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of data bloat on an AnalyticDB for PostgreSQL instance in elastic storage mode. The minor version of the instance must be V6.3.10.1 or later. For more information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceDataBloatRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceDataBloatResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceDataBloat',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceDataBloatResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_data_bloat_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDataBloatRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceDataBloatResponse:
        """
        @summary Queries the information about data bloat for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of data bloat on an AnalyticDB for PostgreSQL instance in elastic storage mode. The minor version of the instance must be V6.3.10.1 or later. For more information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceDataBloatRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceDataBloatResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceDataBloat',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceDataBloatResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_data_bloat(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDataBloatRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceDataBloatResponse:
        """
        @summary Queries the information about data bloat for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of data bloat on an AnalyticDB for PostgreSQL instance in elastic storage mode. The minor version of the instance must be V6.3.10.1 or later. For more information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceDataBloatRequest
        @return: DescribeDBInstanceDataBloatResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_data_bloat_with_options(request, runtime)

    async def describe_dbinstance_data_bloat_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDataBloatRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceDataBloatResponse:
        """
        @summary Queries the information about data bloat for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of data bloat on an AnalyticDB for PostgreSQL instance in elastic storage mode. The minor version of the instance must be V6.3.10.1 or later. For more information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceDataBloatRequest
        @return: DescribeDBInstanceDataBloatResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_data_bloat_with_options_async(request, runtime)

    def describe_dbinstance_data_skew_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDataSkewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceDataSkewResponse:
        """
        @summary Queries the information about data skew for an AnalyticDB for PostgreSQL instance.
        
        @description To prevent data skew from affecting your database service, you can call this operation to query the details about data skew on an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceDataSkewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceDataSkewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceDataSkew',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceDataSkewResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_data_skew_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDataSkewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceDataSkewResponse:
        """
        @summary Queries the information about data skew for an AnalyticDB for PostgreSQL instance.
        
        @description To prevent data skew from affecting your database service, you can call this operation to query the details about data skew on an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceDataSkewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceDataSkewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceDataSkew',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceDataSkewResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_data_skew(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDataSkewRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceDataSkewResponse:
        """
        @summary Queries the information about data skew for an AnalyticDB for PostgreSQL instance.
        
        @description To prevent data skew from affecting your database service, you can call this operation to query the details about data skew on an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceDataSkewRequest
        @return: DescribeDBInstanceDataSkewResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_data_skew_with_options(request, runtime)

    async def describe_dbinstance_data_skew_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDataSkewRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceDataSkewResponse:
        """
        @summary Queries the information about data skew for an AnalyticDB for PostgreSQL instance.
        
        @description To prevent data skew from affecting your database service, you can call this operation to query the details about data skew on an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceDataSkewRequest
        @return: DescribeDBInstanceDataSkewResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_data_skew_with_options_async(request, runtime)

    def describe_dbinstance_diagnosis_summary_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryResponse:
        """
        @summary Queries the information about nodes in an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the distribution and states of coordinator and compute nodes in an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceDiagnosisSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceDiagnosisSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.role_preferd):
            query['RolePreferd'] = request.role_preferd
        if not UtilClient.is_unset(request.start_status):
            query['StartStatus'] = request.start_status
        if not UtilClient.is_unset(request.sync_mode):
            query['SyncMode'] = request.sync_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceDiagnosisSummary',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_diagnosis_summary_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryResponse:
        """
        @summary Queries the information about nodes in an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the distribution and states of coordinator and compute nodes in an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceDiagnosisSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceDiagnosisSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.role_preferd):
            query['RolePreferd'] = request.role_preferd
        if not UtilClient.is_unset(request.start_status):
            query['StartStatus'] = request.start_status
        if not UtilClient.is_unset(request.sync_mode):
            query['SyncMode'] = request.sync_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceDiagnosisSummary',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_diagnosis_summary(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryResponse:
        """
        @summary Queries the information about nodes in an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the distribution and states of coordinator and compute nodes in an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceDiagnosisSummaryRequest
        @return: DescribeDBInstanceDiagnosisSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_diagnosis_summary_with_options(request, runtime)

    async def describe_dbinstance_diagnosis_summary_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceDiagnosisSummaryResponse:
        """
        @summary Queries the information about nodes in an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the distribution and states of coordinator and compute nodes in an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceDiagnosisSummaryRequest
        @return: DescribeDBInstanceDiagnosisSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_diagnosis_summary_with_options_async(request, runtime)

    def describe_dbinstance_error_log_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceErrorLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceErrorLogResponse:
        """
        @summary Queries the error logs of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the error logs of an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceErrorLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceErrorLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.host):
            query['Host'] = request.host
        if not UtilClient.is_unset(request.keywords):
            query['Keywords'] = request.keywords
        if not UtilClient.is_unset(request.log_level):
            query['LogLevel'] = request.log_level
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceErrorLog',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceErrorLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_error_log_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceErrorLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceErrorLogResponse:
        """
        @summary Queries the error logs of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the error logs of an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceErrorLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceErrorLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.host):
            query['Host'] = request.host
        if not UtilClient.is_unset(request.keywords):
            query['Keywords'] = request.keywords
        if not UtilClient.is_unset(request.log_level):
            query['LogLevel'] = request.log_level
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceErrorLog',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceErrorLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_error_log(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceErrorLogRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceErrorLogResponse:
        """
        @summary Queries the error logs of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the error logs of an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceErrorLogRequest
        @return: DescribeDBInstanceErrorLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_error_log_with_options(request, runtime)

    async def describe_dbinstance_error_log_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceErrorLogRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceErrorLogResponse:
        """
        @summary Queries the error logs of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the error logs of an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceErrorLogRequest
        @return: DescribeDBInstanceErrorLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_error_log_with_options_async(request, runtime)

    def describe_dbinstance_iparray_list_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceIPArrayListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceIPArrayListResponse:
        """
        @summary Queries the whitelists of IP addresses that are allowed to access an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the whitelists of IP addresses that are allowed to access an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceIPArrayListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceIPArrayListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_iparray_name):
            query['DBInstanceIPArrayName'] = request.dbinstance_iparray_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceIPArrayList',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceIPArrayListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_iparray_list_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceIPArrayListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceIPArrayListResponse:
        """
        @summary Queries the whitelists of IP addresses that are allowed to access an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the whitelists of IP addresses that are allowed to access an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceIPArrayListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceIPArrayListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_iparray_name):
            query['DBInstanceIPArrayName'] = request.dbinstance_iparray_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceIPArrayList',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceIPArrayListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_iparray_list(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceIPArrayListRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceIPArrayListResponse:
        """
        @summary Queries the whitelists of IP addresses that are allowed to access an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the whitelists of IP addresses that are allowed to access an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceIPArrayListRequest
        @return: DescribeDBInstanceIPArrayListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_iparray_list_with_options(request, runtime)

    async def describe_dbinstance_iparray_list_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceIPArrayListRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceIPArrayListResponse:
        """
        @summary Queries the whitelists of IP addresses that are allowed to access an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the whitelists of IP addresses that are allowed to access an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstanceIPArrayListRequest
        @return: DescribeDBInstanceIPArrayListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_iparray_list_with_options_async(request, runtime)

    def describe_dbinstance_index_usage_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceIndexUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceIndexUsageResponse:
        """
        @summary Queries the index usage of an AnalyticDB for PostgreSQL instance.
        
        @description Appropriate indexes can accelerate database queries. You can call this operation to query the index usage of an AnalyticDB for PostgreSQL instance.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDBInstanceIndexUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceIndexUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceIndexUsage',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceIndexUsageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_index_usage_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceIndexUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceIndexUsageResponse:
        """
        @summary Queries the index usage of an AnalyticDB for PostgreSQL instance.
        
        @description Appropriate indexes can accelerate database queries. You can call this operation to query the index usage of an AnalyticDB for PostgreSQL instance.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDBInstanceIndexUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceIndexUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceIndexUsage',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceIndexUsageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_index_usage(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceIndexUsageRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceIndexUsageResponse:
        """
        @summary Queries the index usage of an AnalyticDB for PostgreSQL instance.
        
        @description Appropriate indexes can accelerate database queries. You can call this operation to query the index usage of an AnalyticDB for PostgreSQL instance.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDBInstanceIndexUsageRequest
        @return: DescribeDBInstanceIndexUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_index_usage_with_options(request, runtime)

    async def describe_dbinstance_index_usage_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceIndexUsageRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceIndexUsageResponse:
        """
        @summary Queries the index usage of an AnalyticDB for PostgreSQL instance.
        
        @description Appropriate indexes can accelerate database queries. You can call this operation to query the index usage of an AnalyticDB for PostgreSQL instance.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDBInstanceIndexUsageRequest
        @return: DescribeDBInstanceIndexUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_index_usage_with_options_async(request, runtime)

    def describe_dbinstance_net_info_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceNetInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceNetInfoResponse:
        """
        @summary Queries the connection information of an instance.
        
        @param request: DescribeDBInstanceNetInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceNetInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string):
            query['ConnectionString'] = request.connection_string
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceNetInfo',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceNetInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_net_info_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceNetInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceNetInfoResponse:
        """
        @summary Queries the connection information of an instance.
        
        @param request: DescribeDBInstanceNetInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceNetInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string):
            query['ConnectionString'] = request.connection_string
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceNetInfo',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceNetInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_net_info(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceNetInfoRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceNetInfoResponse:
        """
        @summary Queries the connection information of an instance.
        
        @param request: DescribeDBInstanceNetInfoRequest
        @return: DescribeDBInstanceNetInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_net_info_with_options(request, runtime)

    async def describe_dbinstance_net_info_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceNetInfoRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceNetInfoResponse:
        """
        @summary Queries the connection information of an instance.
        
        @param request: DescribeDBInstanceNetInfoRequest
        @return: DescribeDBInstanceNetInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_net_info_with_options_async(request, runtime)

    def describe_dbinstance_performance_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstancePerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstancePerformanceResponse:
        """
        @summary Queries the information about performance metrics of an AnalyticDB for PostgreSQL instance within a time range.
        
        @param request: DescribeDBInstancePerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstancePerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstancePerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstancePerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_performance_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstancePerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstancePerformanceResponse:
        """
        @summary Queries the information about performance metrics of an AnalyticDB for PostgreSQL instance within a time range.
        
        @param request: DescribeDBInstancePerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstancePerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstancePerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstancePerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_performance(
        self,
        request: gpdb_20160503_models.DescribeDBInstancePerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDBInstancePerformanceResponse:
        """
        @summary Queries the information about performance metrics of an AnalyticDB for PostgreSQL instance within a time range.
        
        @param request: DescribeDBInstancePerformanceRequest
        @return: DescribeDBInstancePerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_performance_with_options(request, runtime)

    async def describe_dbinstance_performance_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstancePerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDBInstancePerformanceResponse:
        """
        @summary Queries the information about performance metrics of an AnalyticDB for PostgreSQL instance within a time range.
        
        @param request: DescribeDBInstancePerformanceRequest
        @return: DescribeDBInstancePerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_performance_with_options_async(request, runtime)

    def describe_dbinstance_plans_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstancePlansRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstancePlansResponse:
        """
        @summary Queries the information about plans for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of plans for an AnalyticDB for PostgreSQL instance in Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstancePlansRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstancePlansResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.plan_create_date):
            query['PlanCreateDate'] = request.plan_create_date
        if not UtilClient.is_unset(request.plan_desc):
            query['PlanDesc'] = request.plan_desc
        if not UtilClient.is_unset(request.plan_id):
            query['PlanId'] = request.plan_id
        if not UtilClient.is_unset(request.plan_schedule_type):
            query['PlanScheduleType'] = request.plan_schedule_type
        if not UtilClient.is_unset(request.plan_type):
            query['PlanType'] = request.plan_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstancePlans',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstancePlansResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_plans_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstancePlansRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstancePlansResponse:
        """
        @summary Queries the information about plans for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of plans for an AnalyticDB for PostgreSQL instance in Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstancePlansRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstancePlansResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.plan_create_date):
            query['PlanCreateDate'] = request.plan_create_date
        if not UtilClient.is_unset(request.plan_desc):
            query['PlanDesc'] = request.plan_desc
        if not UtilClient.is_unset(request.plan_id):
            query['PlanId'] = request.plan_id
        if not UtilClient.is_unset(request.plan_schedule_type):
            query['PlanScheduleType'] = request.plan_schedule_type
        if not UtilClient.is_unset(request.plan_type):
            query['PlanType'] = request.plan_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstancePlans',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstancePlansResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_plans(
        self,
        request: gpdb_20160503_models.DescribeDBInstancePlansRequest,
    ) -> gpdb_20160503_models.DescribeDBInstancePlansResponse:
        """
        @summary Queries the information about plans for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of plans for an AnalyticDB for PostgreSQL instance in Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstancePlansRequest
        @return: DescribeDBInstancePlansResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_plans_with_options(request, runtime)

    async def describe_dbinstance_plans_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstancePlansRequest,
    ) -> gpdb_20160503_models.DescribeDBInstancePlansResponse:
        """
        @summary Queries the information about plans for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of plans for an AnalyticDB for PostgreSQL instance in Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstancePlansRequest
        @return: DescribeDBInstancePlansResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_plans_with_options_async(request, runtime)

    def describe_dbinstance_sslwith_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceSSLRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceSSLResponse:
        """
        @summary Queries the SSL information about an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceSSLRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceSSLResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceSSL',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceSSLResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_sslwith_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceSSLRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceSSLResponse:
        """
        @summary Queries the SSL information about an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceSSLRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceSSLResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceSSL',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceSSLResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_ssl(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceSSLRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceSSLResponse:
        """
        @summary Queries the SSL information about an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceSSLRequest
        @return: DescribeDBInstanceSSLResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_sslwith_options(request, runtime)

    async def describe_dbinstance_ssl_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceSSLRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceSSLResponse:
        """
        @summary Queries the SSL information about an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceSSLRequest
        @return: DescribeDBInstanceSSLResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_sslwith_options_async(request, runtime)

    def describe_dbinstance_support_max_performance_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceResponse:
        """
        @summary Queries the maximum performance of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceSupportMaxPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceSupportMaxPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceSupportMaxPerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstance_support_max_performance_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceResponse:
        """
        @summary Queries the maximum performance of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceSupportMaxPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstanceSupportMaxPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstanceSupportMaxPerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstance_support_max_performance(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceResponse:
        """
        @summary Queries the maximum performance of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceSupportMaxPerformanceRequest
        @return: DescribeDBInstanceSupportMaxPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstance_support_max_performance_with_options(request, runtime)

    async def describe_dbinstance_support_max_performance_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDBInstanceSupportMaxPerformanceResponse:
        """
        @summary Queries the maximum performance of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBInstanceSupportMaxPerformanceRequest
        @return: DescribeDBInstanceSupportMaxPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstance_support_max_performance_with_options_async(request, runtime)

    def describe_dbinstances_with_options(
        self,
        tmp_req: gpdb_20160503_models.DescribeDBInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstancesResponse:
        """
        @summary Queries a list of AnalyticDB for PostgreSQL instances.
        
        @description ##
        You can call this operation to query the instance types, network types, and states of AnalyticDB for PostgreSQL instances within a region.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param tmp_req: DescribeDBInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstancesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.DescribeDBInstancesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dbinstance_categories):
            request.dbinstance_categories_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dbinstance_categories, 'DBInstanceCategories', 'simple')
        if not UtilClient.is_unset(tmp_req.dbinstance_modes):
            request.dbinstance_modes_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dbinstance_modes, 'DBInstanceModes', 'simple')
        if not UtilClient.is_unset(tmp_req.dbinstance_statuses):
            request.dbinstance_statuses_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dbinstance_statuses, 'DBInstanceStatuses', 'simple')
        if not UtilClient.is_unset(tmp_req.instance_deploy_types):
            request.instance_deploy_types_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_deploy_types, 'InstanceDeployTypes', 'simple')
        query = {}
        if not UtilClient.is_unset(request.dbinstance_categories_shrink):
            query['DBInstanceCategories'] = request.dbinstance_categories_shrink
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_ids):
            query['DBInstanceIds'] = request.dbinstance_ids
        if not UtilClient.is_unset(request.dbinstance_modes_shrink):
            query['DBInstanceModes'] = request.dbinstance_modes_shrink
        if not UtilClient.is_unset(request.dbinstance_statuses_shrink):
            query['DBInstanceStatuses'] = request.dbinstance_statuses_shrink
        if not UtilClient.is_unset(request.instance_deploy_types_shrink):
            query['InstanceDeployTypes'] = request.instance_deploy_types_shrink
        if not UtilClient.is_unset(request.instance_network_type):
            query['InstanceNetworkType'] = request.instance_network_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstances',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbinstances_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.DescribeDBInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBInstancesResponse:
        """
        @summary Queries a list of AnalyticDB for PostgreSQL instances.
        
        @description ##
        You can call this operation to query the instance types, network types, and states of AnalyticDB for PostgreSQL instances within a region.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param tmp_req: DescribeDBInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBInstancesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.DescribeDBInstancesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dbinstance_categories):
            request.dbinstance_categories_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dbinstance_categories, 'DBInstanceCategories', 'simple')
        if not UtilClient.is_unset(tmp_req.dbinstance_modes):
            request.dbinstance_modes_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dbinstance_modes, 'DBInstanceModes', 'simple')
        if not UtilClient.is_unset(tmp_req.dbinstance_statuses):
            request.dbinstance_statuses_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dbinstance_statuses, 'DBInstanceStatuses', 'simple')
        if not UtilClient.is_unset(tmp_req.instance_deploy_types):
            request.instance_deploy_types_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_deploy_types, 'InstanceDeployTypes', 'simple')
        query = {}
        if not UtilClient.is_unset(request.dbinstance_categories_shrink):
            query['DBInstanceCategories'] = request.dbinstance_categories_shrink
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_ids):
            query['DBInstanceIds'] = request.dbinstance_ids
        if not UtilClient.is_unset(request.dbinstance_modes_shrink):
            query['DBInstanceModes'] = request.dbinstance_modes_shrink
        if not UtilClient.is_unset(request.dbinstance_statuses_shrink):
            query['DBInstanceStatuses'] = request.dbinstance_statuses_shrink
        if not UtilClient.is_unset(request.instance_deploy_types_shrink):
            query['InstanceDeployTypes'] = request.instance_deploy_types_shrink
        if not UtilClient.is_unset(request.instance_network_type):
            query['InstanceNetworkType'] = request.instance_network_type
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBInstances',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbinstances(
        self,
        request: gpdb_20160503_models.DescribeDBInstancesRequest,
    ) -> gpdb_20160503_models.DescribeDBInstancesResponse:
        """
        @summary Queries a list of AnalyticDB for PostgreSQL instances.
        
        @description ##
        You can call this operation to query the instance types, network types, and states of AnalyticDB for PostgreSQL instances within a region.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstancesRequest
        @return: DescribeDBInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbinstances_with_options(request, runtime)

    async def describe_dbinstances_async(
        self,
        request: gpdb_20160503_models.DescribeDBInstancesRequest,
    ) -> gpdb_20160503_models.DescribeDBInstancesResponse:
        """
        @summary Queries a list of AnalyticDB for PostgreSQL instances.
        
        @description ##
        You can call this operation to query the instance types, network types, and states of AnalyticDB for PostgreSQL instances within a region.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDBInstancesRequest
        @return: DescribeDBInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbinstances_with_options_async(request, runtime)

    def describe_dbresource_group_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBResourceGroupResponse:
        """
        @summary Queries the information about resource groups.
        
        @param request: DescribeDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbresource_group_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBResourceGroupResponse:
        """
        @summary Queries the information about resource groups.
        
        @param request: DescribeDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_name):
            query['ResourceGroupName'] = request.resource_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbresource_group(
        self,
        request: gpdb_20160503_models.DescribeDBResourceGroupRequest,
    ) -> gpdb_20160503_models.DescribeDBResourceGroupResponse:
        """
        @summary Queries the information about resource groups.
        
        @param request: DescribeDBResourceGroupRequest
        @return: DescribeDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbresource_group_with_options(request, runtime)

    async def describe_dbresource_group_async(
        self,
        request: gpdb_20160503_models.DescribeDBResourceGroupRequest,
    ) -> gpdb_20160503_models.DescribeDBResourceGroupResponse:
        """
        @summary Queries the information about resource groups.
        
        @param request: DescribeDBResourceGroupRequest
        @return: DescribeDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbresource_group_with_options_async(request, runtime)

    def describe_dbresource_management_mode_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBResourceManagementModeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBResourceManagementModeResponse:
        """
        @summary Queries the resource management mode of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBResourceManagementModeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBResourceManagementModeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBResourceManagementMode',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBResourceManagementModeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbresource_management_mode_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBResourceManagementModeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBResourceManagementModeResponse:
        """
        @summary Queries the resource management mode of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBResourceManagementModeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBResourceManagementModeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBResourceManagementMode',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBResourceManagementModeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbresource_management_mode(
        self,
        request: gpdb_20160503_models.DescribeDBResourceManagementModeRequest,
    ) -> gpdb_20160503_models.DescribeDBResourceManagementModeResponse:
        """
        @summary Queries the resource management mode of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBResourceManagementModeRequest
        @return: DescribeDBResourceManagementModeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbresource_management_mode_with_options(request, runtime)

    async def describe_dbresource_management_mode_async(
        self,
        request: gpdb_20160503_models.DescribeDBResourceManagementModeRequest,
    ) -> gpdb_20160503_models.DescribeDBResourceManagementModeResponse:
        """
        @summary Queries the resource management mode of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeDBResourceManagementModeRequest
        @return: DescribeDBResourceManagementModeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbresource_management_mode_with_options_async(request, runtime)

    def describe_dbversion_infos_with_options(
        self,
        request: gpdb_20160503_models.DescribeDBVersionInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBVersionInfosResponse:
        """
        @summary Queries the information about minor versions of AnalyticDB for PostgreSQL instances.
        
        @param request: DescribeDBVersionInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBVersionInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_mode):
            query['DBInstanceMode'] = request.dbinstance_mode
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBVersionInfos',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBVersionInfosResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dbversion_infos_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDBVersionInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDBVersionInfosResponse:
        """
        @summary Queries the information about minor versions of AnalyticDB for PostgreSQL instances.
        
        @param request: DescribeDBVersionInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDBVersionInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_mode):
            query['DBInstanceMode'] = request.dbinstance_mode
        if not UtilClient.is_unset(request.dbversion):
            query['DBVersion'] = request.dbversion
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDBVersionInfos',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDBVersionInfosResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dbversion_infos(
        self,
        request: gpdb_20160503_models.DescribeDBVersionInfosRequest,
    ) -> gpdb_20160503_models.DescribeDBVersionInfosResponse:
        """
        @summary Queries the information about minor versions of AnalyticDB for PostgreSQL instances.
        
        @param request: DescribeDBVersionInfosRequest
        @return: DescribeDBVersionInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dbversion_infos_with_options(request, runtime)

    async def describe_dbversion_infos_async(
        self,
        request: gpdb_20160503_models.DescribeDBVersionInfosRequest,
    ) -> gpdb_20160503_models.DescribeDBVersionInfosResponse:
        """
        @summary Queries the information about minor versions of AnalyticDB for PostgreSQL instances.
        
        @param request: DescribeDBVersionInfosRequest
        @return: DescribeDBVersionInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dbversion_infos_with_options_async(request, runtime)

    def describe_data_backups_with_options(
        self,
        request: gpdb_20160503_models.DescribeDataBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDataBackupsResponse:
        """
        @summary Queries a list of backup sets of full backup or point-in-time backup for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query a list of backup sets and backup details only for instances in elastic storage mode.
        
        @param request: DescribeDataBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.backup_status):
            query['BackupStatus'] = request.backup_status
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataBackups',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDataBackupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_data_backups_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDataBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDataBackupsResponse:
        """
        @summary Queries a list of backup sets of full backup or point-in-time backup for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query a list of backup sets and backup details only for instances in elastic storage mode.
        
        @param request: DescribeDataBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_id):
            query['BackupId'] = request.backup_id
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.backup_status):
            query['BackupStatus'] = request.backup_status
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataBackups',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDataBackupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_data_backups(
        self,
        request: gpdb_20160503_models.DescribeDataBackupsRequest,
    ) -> gpdb_20160503_models.DescribeDataBackupsResponse:
        """
        @summary Queries a list of backup sets of full backup or point-in-time backup for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query a list of backup sets and backup details only for instances in elastic storage mode.
        
        @param request: DescribeDataBackupsRequest
        @return: DescribeDataBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_data_backups_with_options(request, runtime)

    async def describe_data_backups_async(
        self,
        request: gpdb_20160503_models.DescribeDataBackupsRequest,
    ) -> gpdb_20160503_models.DescribeDataBackupsResponse:
        """
        @summary Queries a list of backup sets of full backup or point-in-time backup for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query a list of backup sets and backup details only for instances in elastic storage mode.
        
        @param request: DescribeDataBackupsRequest
        @return: DescribeDataBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_data_backups_with_options_async(request, runtime)

    def describe_data_re_distribute_info_with_options(
        self,
        request: gpdb_20160503_models.DescribeDataReDistributeInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDataReDistributeInfoResponse:
        """
        @summary Queries the data redistribution information about an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        
        @param request: DescribeDataReDistributeInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataReDistributeInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataReDistributeInfo',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDataReDistributeInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_data_re_distribute_info_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDataReDistributeInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDataReDistributeInfoResponse:
        """
        @summary Queries the data redistribution information about an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        
        @param request: DescribeDataReDistributeInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataReDistributeInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataReDistributeInfo',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDataReDistributeInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_data_re_distribute_info(
        self,
        request: gpdb_20160503_models.DescribeDataReDistributeInfoRequest,
    ) -> gpdb_20160503_models.DescribeDataReDistributeInfoResponse:
        """
        @summary Queries the data redistribution information about an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        
        @param request: DescribeDataReDistributeInfoRequest
        @return: DescribeDataReDistributeInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_data_re_distribute_info_with_options(request, runtime)

    async def describe_data_re_distribute_info_async(
        self,
        request: gpdb_20160503_models.DescribeDataReDistributeInfoRequest,
    ) -> gpdb_20160503_models.DescribeDataReDistributeInfoResponse:
        """
        @summary Queries the data redistribution information about an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        
        @param request: DescribeDataReDistributeInfoRequest
        @return: DescribeDataReDistributeInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_data_re_distribute_info_with_options_async(request, runtime)

    def describe_data_share_instances_with_options(
        self,
        request: gpdb_20160503_models.DescribeDataShareInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDataShareInstancesResponse:
        """
        @summary Queries the state of data sharing for AnalyticDB for PostgreSQL instances.
        
        @description Data sharing is supported only for instances in Serverless mode.
        
        @param request: DescribeDataShareInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataShareInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.search_value):
            query['SearchValue'] = request.search_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataShareInstances',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDataShareInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_data_share_instances_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDataShareInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDataShareInstancesResponse:
        """
        @summary Queries the state of data sharing for AnalyticDB for PostgreSQL instances.
        
        @description Data sharing is supported only for instances in Serverless mode.
        
        @param request: DescribeDataShareInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataShareInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.search_value):
            query['SearchValue'] = request.search_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataShareInstances',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDataShareInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_data_share_instances(
        self,
        request: gpdb_20160503_models.DescribeDataShareInstancesRequest,
    ) -> gpdb_20160503_models.DescribeDataShareInstancesResponse:
        """
        @summary Queries the state of data sharing for AnalyticDB for PostgreSQL instances.
        
        @description Data sharing is supported only for instances in Serverless mode.
        
        @param request: DescribeDataShareInstancesRequest
        @return: DescribeDataShareInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_data_share_instances_with_options(request, runtime)

    async def describe_data_share_instances_async(
        self,
        request: gpdb_20160503_models.DescribeDataShareInstancesRequest,
    ) -> gpdb_20160503_models.DescribeDataShareInstancesResponse:
        """
        @summary Queries the state of data sharing for AnalyticDB for PostgreSQL instances.
        
        @description Data sharing is supported only for instances in Serverless mode.
        
        @param request: DescribeDataShareInstancesRequest
        @return: DescribeDataShareInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_data_share_instances_with_options_async(request, runtime)

    def describe_data_share_performance_with_options(
        self,
        request: gpdb_20160503_models.DescribeDataSharePerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDataSharePerformanceResponse:
        """
        @summary Queries the information about data sharing performance metrics.
        
        @description You can call this operation to query the details of data sharing performance metrics for an AnalyticDB for PostgreSQL instance in Serverless mode, such as the number of shared topics and the amount of data shared.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDataSharePerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataSharePerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataSharePerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDataSharePerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_data_share_performance_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDataSharePerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDataSharePerformanceResponse:
        """
        @summary Queries the information about data sharing performance metrics.
        
        @description You can call this operation to query the details of data sharing performance metrics for an AnalyticDB for PostgreSQL instance in Serverless mode, such as the number of shared topics and the amount of data shared.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDataSharePerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataSharePerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataSharePerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDataSharePerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_data_share_performance(
        self,
        request: gpdb_20160503_models.DescribeDataSharePerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDataSharePerformanceResponse:
        """
        @summary Queries the information about data sharing performance metrics.
        
        @description You can call this operation to query the details of data sharing performance metrics for an AnalyticDB for PostgreSQL instance in Serverless mode, such as the number of shared topics and the amount of data shared.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDataSharePerformanceRequest
        @return: DescribeDataSharePerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_data_share_performance_with_options(request, runtime)

    async def describe_data_share_performance_async(
        self,
        request: gpdb_20160503_models.DescribeDataSharePerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDataSharePerformanceResponse:
        """
        @summary Queries the information about data sharing performance metrics.
        
        @description You can call this operation to query the details of data sharing performance metrics for an AnalyticDB for PostgreSQL instance in Serverless mode, such as the number of shared topics and the amount of data shared.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDataSharePerformanceRequest
        @return: DescribeDataSharePerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_data_share_performance_with_options_async(request, runtime)

    def describe_diagnosis_dimensions_with_options(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisDimensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDiagnosisDimensionsResponse:
        """
        @summary Queries all databases and database accounts for an AnalyticDB for PostgreSQL instance.
        
        @description To facilitate management, you can call this operation to query all databases and database accounts on an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisDimensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiagnosisDimensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosisDimensions',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDiagnosisDimensionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_diagnosis_dimensions_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisDimensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDiagnosisDimensionsResponse:
        """
        @summary Queries all databases and database accounts for an AnalyticDB for PostgreSQL instance.
        
        @description To facilitate management, you can call this operation to query all databases and database accounts on an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisDimensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiagnosisDimensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosisDimensions',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDiagnosisDimensionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_diagnosis_dimensions(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisDimensionsRequest,
    ) -> gpdb_20160503_models.DescribeDiagnosisDimensionsResponse:
        """
        @summary Queries all databases and database accounts for an AnalyticDB for PostgreSQL instance.
        
        @description To facilitate management, you can call this operation to query all databases and database accounts on an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisDimensionsRequest
        @return: DescribeDiagnosisDimensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_diagnosis_dimensions_with_options(request, runtime)

    async def describe_diagnosis_dimensions_async(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisDimensionsRequest,
    ) -> gpdb_20160503_models.DescribeDiagnosisDimensionsResponse:
        """
        @summary Queries all databases and database accounts for an AnalyticDB for PostgreSQL instance.
        
        @description To facilitate management, you can call this operation to query all databases and database accounts on an AnalyticDB for PostgreSQL instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisDimensionsRequest
        @return: DescribeDiagnosisDimensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_diagnosis_dimensions_with_options_async(request, runtime)

    def describe_diagnosis_monitor_performance_with_options(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceResponse:
        """
        @summary Queries the details of query execution on an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of query execution on an AnalyticDB for PostgreSQL instance in elastic storage mode within a specified time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisMonitorPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiagnosisMonitorPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.query_condition):
            query['QueryCondition'] = request.query_condition
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosisMonitorPerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_diagnosis_monitor_performance_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceResponse:
        """
        @summary Queries the details of query execution on an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of query execution on an AnalyticDB for PostgreSQL instance in elastic storage mode within a specified time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisMonitorPerformanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiagnosisMonitorPerformanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.query_condition):
            query['QueryCondition'] = request.query_condition
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosisMonitorPerformance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_diagnosis_monitor_performance(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceResponse:
        """
        @summary Queries the details of query execution on an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of query execution on an AnalyticDB for PostgreSQL instance in elastic storage mode within a specified time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisMonitorPerformanceRequest
        @return: DescribeDiagnosisMonitorPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_diagnosis_monitor_performance_with_options(request, runtime)

    async def describe_diagnosis_monitor_performance_async(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceRequest,
    ) -> gpdb_20160503_models.DescribeDiagnosisMonitorPerformanceResponse:
        """
        @summary Queries the details of query execution on an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of query execution on an AnalyticDB for PostgreSQL instance in elastic storage mode within a specified time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisMonitorPerformanceRequest
        @return: DescribeDiagnosisMonitorPerformanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_diagnosis_monitor_performance_with_options_async(request, runtime)

    def describe_diagnosis_records_with_options(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDiagnosisRecordsResponse:
        """
        @summary Queries the information about SQL queries for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of SQL queries on an AnalyticDB for PostgreSQL instance within a specified time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiagnosisRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_condition):
            query['QueryCondition'] = request.query_condition
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosisRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDiagnosisRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_diagnosis_records_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDiagnosisRecordsResponse:
        """
        @summary Queries the information about SQL queries for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of SQL queries on an AnalyticDB for PostgreSQL instance within a specified time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiagnosisRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_condition):
            query['QueryCondition'] = request.query_condition
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosisRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDiagnosisRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_diagnosis_records(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisRecordsRequest,
    ) -> gpdb_20160503_models.DescribeDiagnosisRecordsResponse:
        """
        @summary Queries the information about SQL queries for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of SQL queries on an AnalyticDB for PostgreSQL instance within a specified time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisRecordsRequest
        @return: DescribeDiagnosisRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_diagnosis_records_with_options(request, runtime)

    async def describe_diagnosis_records_async(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisRecordsRequest,
    ) -> gpdb_20160503_models.DescribeDiagnosisRecordsResponse:
        """
        @summary Queries the information about SQL queries for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of SQL queries on an AnalyticDB for PostgreSQL instance within a specified time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDiagnosisRecordsRequest
        @return: DescribeDiagnosisRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_diagnosis_records_with_options_async(request, runtime)

    def describe_diagnosis_sqlinfo_with_options(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisSQLInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDiagnosisSQLInfoResponse:
        """
        @summary Queries the information about a query for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the information about a query for an AnalyticDB for PostgreSQL instance, including the SQL statement, execution plan text, and execution plan tree.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDiagnosisSQLInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiagnosisSQLInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.query_id):
            query['QueryID'] = request.query_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosisSQLInfo',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDiagnosisSQLInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_diagnosis_sqlinfo_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisSQLInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDiagnosisSQLInfoResponse:
        """
        @summary Queries the information about a query for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the information about a query for an AnalyticDB for PostgreSQL instance, including the SQL statement, execution plan text, and execution plan tree.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDiagnosisSQLInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiagnosisSQLInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.query_id):
            query['QueryID'] = request.query_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosisSQLInfo',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDiagnosisSQLInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_diagnosis_sqlinfo(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisSQLInfoRequest,
    ) -> gpdb_20160503_models.DescribeDiagnosisSQLInfoResponse:
        """
        @summary Queries the information about a query for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the information about a query for an AnalyticDB for PostgreSQL instance, including the SQL statement, execution plan text, and execution plan tree.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDiagnosisSQLInfoRequest
        @return: DescribeDiagnosisSQLInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_diagnosis_sqlinfo_with_options(request, runtime)

    async def describe_diagnosis_sqlinfo_async(
        self,
        request: gpdb_20160503_models.DescribeDiagnosisSQLInfoRequest,
    ) -> gpdb_20160503_models.DescribeDiagnosisSQLInfoResponse:
        """
        @summary Queries the information about a query for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the information about a query for an AnalyticDB for PostgreSQL instance, including the SQL statement, execution plan text, and execution plan tree.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDiagnosisSQLInfoRequest
        @return: DescribeDiagnosisSQLInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_diagnosis_sqlinfo_with_options_async(request, runtime)

    def describe_document_with_options(
        self,
        request: gpdb_20160503_models.DescribeDocumentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDocumentResponse:
        """
        @summary Get Document Details
        
        @param request: DescribeDocumentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDocumentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDocument',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDocumentResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_document_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDocumentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDocumentResponse:
        """
        @summary Get Document Details
        
        @param request: DescribeDocumentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDocumentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDocument',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDocumentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_document(
        self,
        request: gpdb_20160503_models.DescribeDocumentRequest,
    ) -> gpdb_20160503_models.DescribeDocumentResponse:
        """
        @summary Get Document Details
        
        @param request: DescribeDocumentRequest
        @return: DescribeDocumentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_document_with_options(request, runtime)

    async def describe_document_async(
        self,
        request: gpdb_20160503_models.DescribeDocumentRequest,
    ) -> gpdb_20160503_models.DescribeDocumentResponse:
        """
        @summary Get Document Details
        
        @param request: DescribeDocumentRequest
        @return: DescribeDocumentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_document_with_options_async(request, runtime)

    def describe_download_records_with_options(
        self,
        request: gpdb_20160503_models.DescribeDownloadRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDownloadRecordsResponse:
        """
        @summary Queries the download records of query diagnostic information for an AnalyticDB for PostgreSQL instance.
        
        @description You must call the [DownloadDiagnosisRecords](https://help.aliyun.com/document_detail/447700.html) operation to download the query diagnostic information before you can call this operation to query the download records and download URLs.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDownloadRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDownloadRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.download_task_type):
            query['DownloadTaskType'] = request.download_task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDownloadRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDownloadRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_download_records_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDownloadRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDownloadRecordsResponse:
        """
        @summary Queries the download records of query diagnostic information for an AnalyticDB for PostgreSQL instance.
        
        @description You must call the [DownloadDiagnosisRecords](https://help.aliyun.com/document_detail/447700.html) operation to download the query diagnostic information before you can call this operation to query the download records and download URLs.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDownloadRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDownloadRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.download_task_type):
            query['DownloadTaskType'] = request.download_task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDownloadRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDownloadRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_download_records(
        self,
        request: gpdb_20160503_models.DescribeDownloadRecordsRequest,
    ) -> gpdb_20160503_models.DescribeDownloadRecordsResponse:
        """
        @summary Queries the download records of query diagnostic information for an AnalyticDB for PostgreSQL instance.
        
        @description You must call the [DownloadDiagnosisRecords](https://help.aliyun.com/document_detail/447700.html) operation to download the query diagnostic information before you can call this operation to query the download records and download URLs.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDownloadRecordsRequest
        @return: DescribeDownloadRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_download_records_with_options(request, runtime)

    async def describe_download_records_async(
        self,
        request: gpdb_20160503_models.DescribeDownloadRecordsRequest,
    ) -> gpdb_20160503_models.DescribeDownloadRecordsResponse:
        """
        @summary Queries the download records of query diagnostic information for an AnalyticDB for PostgreSQL instance.
        
        @description You must call the [DownloadDiagnosisRecords](https://help.aliyun.com/document_detail/447700.html) operation to download the query diagnostic information before you can call this operation to query the download records and download URLs.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For information about how to view and update the minor version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        
        @param request: DescribeDownloadRecordsRequest
        @return: DescribeDownloadRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_download_records_with_options_async(request, runtime)

    def describe_download_sqllogs_with_options(
        self,
        request: gpdb_20160503_models.DescribeDownloadSQLLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDownloadSQLLogsResponse:
        """
        @summary Get download records
        
        @param request: DescribeDownloadSQLLogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDownloadSQLLogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDownloadSQLLogs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDownloadSQLLogsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_download_sqllogs_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeDownloadSQLLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeDownloadSQLLogsResponse:
        """
        @summary Get download records
        
        @param request: DescribeDownloadSQLLogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDownloadSQLLogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDownloadSQLLogs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeDownloadSQLLogsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_download_sqllogs(
        self,
        request: gpdb_20160503_models.DescribeDownloadSQLLogsRequest,
    ) -> gpdb_20160503_models.DescribeDownloadSQLLogsResponse:
        """
        @summary Get download records
        
        @param request: DescribeDownloadSQLLogsRequest
        @return: DescribeDownloadSQLLogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_download_sqllogs_with_options(request, runtime)

    async def describe_download_sqllogs_async(
        self,
        request: gpdb_20160503_models.DescribeDownloadSQLLogsRequest,
    ) -> gpdb_20160503_models.DescribeDownloadSQLLogsResponse:
        """
        @summary Get download records
        
        @param request: DescribeDownloadSQLLogsRequest
        @return: DescribeDownloadSQLLogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_download_sqllogs_with_options_async(request, runtime)

    def describe_external_data_service_with_options(
        self,
        request: gpdb_20160503_models.DescribeExternalDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeExternalDataServiceResponse:
        """
        @summary Queries the information about an external data service.
        
        @param request: DescribeExternalDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeExternalDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExternalDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeExternalDataServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_external_data_service_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeExternalDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeExternalDataServiceResponse:
        """
        @summary Queries the information about an external data service.
        
        @param request: DescribeExternalDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeExternalDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExternalDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeExternalDataServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_external_data_service(
        self,
        request: gpdb_20160503_models.DescribeExternalDataServiceRequest,
    ) -> gpdb_20160503_models.DescribeExternalDataServiceResponse:
        """
        @summary Queries the information about an external data service.
        
        @param request: DescribeExternalDataServiceRequest
        @return: DescribeExternalDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_external_data_service_with_options(request, runtime)

    async def describe_external_data_service_async(
        self,
        request: gpdb_20160503_models.DescribeExternalDataServiceRequest,
    ) -> gpdb_20160503_models.DescribeExternalDataServiceResponse:
        """
        @summary Queries the information about an external data service.
        
        @param request: DescribeExternalDataServiceRequest
        @return: DescribeExternalDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_external_data_service_with_options_async(request, runtime)

    def describe_hadoop_clusters_in_same_net_with_options(
        self,
        request: gpdb_20160503_models.DescribeHadoopClustersInSameNetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeHadoopClustersInSameNetResponse:
        """
        @summary Queries E-MapReduce (EMR) Hadoop clusters in a specific virtual private cloud (VPC).
        
        @param request: DescribeHadoopClustersInSameNetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHadoopClustersInSameNetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHadoopClustersInSameNet',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeHadoopClustersInSameNetResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_hadoop_clusters_in_same_net_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeHadoopClustersInSameNetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeHadoopClustersInSameNetResponse:
        """
        @summary Queries E-MapReduce (EMR) Hadoop clusters in a specific virtual private cloud (VPC).
        
        @param request: DescribeHadoopClustersInSameNetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHadoopClustersInSameNetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHadoopClustersInSameNet',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeHadoopClustersInSameNetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_hadoop_clusters_in_same_net(
        self,
        request: gpdb_20160503_models.DescribeHadoopClustersInSameNetRequest,
    ) -> gpdb_20160503_models.DescribeHadoopClustersInSameNetResponse:
        """
        @summary Queries E-MapReduce (EMR) Hadoop clusters in a specific virtual private cloud (VPC).
        
        @param request: DescribeHadoopClustersInSameNetRequest
        @return: DescribeHadoopClustersInSameNetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_hadoop_clusters_in_same_net_with_options(request, runtime)

    async def describe_hadoop_clusters_in_same_net_async(
        self,
        request: gpdb_20160503_models.DescribeHadoopClustersInSameNetRequest,
    ) -> gpdb_20160503_models.DescribeHadoopClustersInSameNetResponse:
        """
        @summary Queries E-MapReduce (EMR) Hadoop clusters in a specific virtual private cloud (VPC).
        
        @param request: DescribeHadoopClustersInSameNetRequest
        @return: DescribeHadoopClustersInSameNetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_hadoop_clusters_in_same_net_with_options_async(request, runtime)

    def describe_hadoop_configs_with_options(
        self,
        request: gpdb_20160503_models.DescribeHadoopConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeHadoopConfigsResponse:
        """
        @summary Queries the configuration information about a Hadoop cluster.
        
        @param request: DescribeHadoopConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHadoopConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_name):
            query['ConfigName'] = request.config_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.emr_instance_id):
            query['EmrInstanceId'] = request.emr_instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHadoopConfigs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeHadoopConfigsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_hadoop_configs_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeHadoopConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeHadoopConfigsResponse:
        """
        @summary Queries the configuration information about a Hadoop cluster.
        
        @param request: DescribeHadoopConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHadoopConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_name):
            query['ConfigName'] = request.config_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.emr_instance_id):
            query['EmrInstanceId'] = request.emr_instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHadoopConfigs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeHadoopConfigsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_hadoop_configs(
        self,
        request: gpdb_20160503_models.DescribeHadoopConfigsRequest,
    ) -> gpdb_20160503_models.DescribeHadoopConfigsResponse:
        """
        @summary Queries the configuration information about a Hadoop cluster.
        
        @param request: DescribeHadoopConfigsRequest
        @return: DescribeHadoopConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_hadoop_configs_with_options(request, runtime)

    async def describe_hadoop_configs_async(
        self,
        request: gpdb_20160503_models.DescribeHadoopConfigsRequest,
    ) -> gpdb_20160503_models.DescribeHadoopConfigsResponse:
        """
        @summary Queries the configuration information about a Hadoop cluster.
        
        @param request: DescribeHadoopConfigsRequest
        @return: DescribeHadoopConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_hadoop_configs_with_options_async(request, runtime)

    def describe_hadoop_data_source_with_options(
        self,
        request: gpdb_20160503_models.DescribeHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeHadoopDataSourceResponse:
        """
        @summary Obtains the configurations of a Hadoop data source.
        
        @param request: DescribeHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeHadoopDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_hadoop_data_source_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeHadoopDataSourceResponse:
        """
        @summary Obtains the configurations of a Hadoop data source.
        
        @param request: DescribeHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeHadoopDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_hadoop_data_source(
        self,
        request: gpdb_20160503_models.DescribeHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.DescribeHadoopDataSourceResponse:
        """
        @summary Obtains the configurations of a Hadoop data source.
        
        @param request: DescribeHadoopDataSourceRequest
        @return: DescribeHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_hadoop_data_source_with_options(request, runtime)

    async def describe_hadoop_data_source_async(
        self,
        request: gpdb_20160503_models.DescribeHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.DescribeHadoopDataSourceResponse:
        """
        @summary Obtains the configurations of a Hadoop data source.
        
        @param request: DescribeHadoopDataSourceRequest
        @return: DescribeHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_hadoop_data_source_with_options_async(request, runtime)

    def describe_health_status_with_options(
        self,
        request: gpdb_20160503_models.DescribeHealthStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeHealthStatusResponse:
        """
        @summary Queries the health status of an AnalyticDB for PostgreSQL instance and its nodes.
        
        @description This operation is called to query the health status of an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode and its coordinator and compute nodes.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeHealthStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHealthStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHealthStatus',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeHealthStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_health_status_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeHealthStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeHealthStatusResponse:
        """
        @summary Queries the health status of an AnalyticDB for PostgreSQL instance and its nodes.
        
        @description This operation is called to query the health status of an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode and its coordinator and compute nodes.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeHealthStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHealthStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.key):
            query['Key'] = request.key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHealthStatus',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeHealthStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_health_status(
        self,
        request: gpdb_20160503_models.DescribeHealthStatusRequest,
    ) -> gpdb_20160503_models.DescribeHealthStatusResponse:
        """
        @summary Queries the health status of an AnalyticDB for PostgreSQL instance and its nodes.
        
        @description This operation is called to query the health status of an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode and its coordinator and compute nodes.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeHealthStatusRequest
        @return: DescribeHealthStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_health_status_with_options(request, runtime)

    async def describe_health_status_async(
        self,
        request: gpdb_20160503_models.DescribeHealthStatusRequest,
    ) -> gpdb_20160503_models.DescribeHealthStatusResponse:
        """
        @summary Queries the health status of an AnalyticDB for PostgreSQL instance and its nodes.
        
        @description This operation is called to query the health status of an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode and its coordinator and compute nodes.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeHealthStatusRequest
        @return: DescribeHealthStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_health_status_with_options_async(request, runtime)

    def describe_imvinfos_with_options(
        self,
        request: gpdb_20160503_models.DescribeIMVInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeIMVInfosResponse:
        """
        @summary Queries the information about real-time materialized views of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeIMVInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeIMVInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.mvname):
            query['MVName'] = request.mvname
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIMVInfos',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeIMVInfosResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_imvinfos_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeIMVInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeIMVInfosResponse:
        """
        @summary Queries the information about real-time materialized views of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeIMVInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeIMVInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.mvname):
            query['MVName'] = request.mvname
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIMVInfos',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeIMVInfosResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_imvinfos(
        self,
        request: gpdb_20160503_models.DescribeIMVInfosRequest,
    ) -> gpdb_20160503_models.DescribeIMVInfosResponse:
        """
        @summary Queries the information about real-time materialized views of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeIMVInfosRequest
        @return: DescribeIMVInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_imvinfos_with_options(request, runtime)

    async def describe_imvinfos_async(
        self,
        request: gpdb_20160503_models.DescribeIMVInfosRequest,
    ) -> gpdb_20160503_models.DescribeIMVInfosResponse:
        """
        @summary Queries the information about real-time materialized views of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeIMVInfosRequest
        @return: DescribeIMVInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_imvinfos_with_options_async(request, runtime)

    def describe_index_with_options(
        self,
        request: gpdb_20160503_models.DescribeIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeIndexResponse:
        """
        @summary 获取索引详情
        
        @param request: DescribeIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.index_name):
            query['IndexName'] = request.index_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeIndexResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_index_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeIndexResponse:
        """
        @summary 获取索引详情
        
        @param request: DescribeIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.index_name):
            query['IndexName'] = request.index_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIndex',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeIndexResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_index(
        self,
        request: gpdb_20160503_models.DescribeIndexRequest,
    ) -> gpdb_20160503_models.DescribeIndexResponse:
        """
        @summary 获取索引详情
        
        @param request: DescribeIndexRequest
        @return: DescribeIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_index_with_options(request, runtime)

    async def describe_index_async(
        self,
        request: gpdb_20160503_models.DescribeIndexRequest,
    ) -> gpdb_20160503_models.DescribeIndexResponse:
        """
        @summary 获取索引详情
        
        @param request: DescribeIndexRequest
        @return: DescribeIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_index_with_options_async(request, runtime)

    def describe_jdbcdata_source_with_options(
        self,
        request: gpdb_20160503_models.DescribeJDBCDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeJDBCDataSourceResponse:
        """
        @summary Queries the configurations of a Java Database Connectivity (JDBC) data source.
        
        @param request: DescribeJDBCDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeJDBCDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeJDBCDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeJDBCDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_jdbcdata_source_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeJDBCDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeJDBCDataSourceResponse:
        """
        @summary Queries the configurations of a Java Database Connectivity (JDBC) data source.
        
        @param request: DescribeJDBCDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeJDBCDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeJDBCDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeJDBCDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_jdbcdata_source(
        self,
        request: gpdb_20160503_models.DescribeJDBCDataSourceRequest,
    ) -> gpdb_20160503_models.DescribeJDBCDataSourceResponse:
        """
        @summary Queries the configurations of a Java Database Connectivity (JDBC) data source.
        
        @param request: DescribeJDBCDataSourceRequest
        @return: DescribeJDBCDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_jdbcdata_source_with_options(request, runtime)

    async def describe_jdbcdata_source_async(
        self,
        request: gpdb_20160503_models.DescribeJDBCDataSourceRequest,
    ) -> gpdb_20160503_models.DescribeJDBCDataSourceResponse:
        """
        @summary Queries the configurations of a Java Database Connectivity (JDBC) data source.
        
        @param request: DescribeJDBCDataSourceRequest
        @return: DescribeJDBCDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_jdbcdata_source_with_options_async(request, runtime)

    def describe_log_backups_with_options(
        self,
        request: gpdb_20160503_models.DescribeLogBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeLogBackupsResponse:
        """
        @summary Queries a list of log backups.
        
        @param request: DescribeLogBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLogBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogBackups',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeLogBackupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_log_backups_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeLogBackupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeLogBackupsResponse:
        """
        @summary Queries a list of log backups.
        
        @param request: DescribeLogBackupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLogBackupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogBackups',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeLogBackupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_log_backups(
        self,
        request: gpdb_20160503_models.DescribeLogBackupsRequest,
    ) -> gpdb_20160503_models.DescribeLogBackupsResponse:
        """
        @summary Queries a list of log backups.
        
        @param request: DescribeLogBackupsRequest
        @return: DescribeLogBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_log_backups_with_options(request, runtime)

    async def describe_log_backups_async(
        self,
        request: gpdb_20160503_models.DescribeLogBackupsRequest,
    ) -> gpdb_20160503_models.DescribeLogBackupsResponse:
        """
        @summary Queries a list of log backups.
        
        @param request: DescribeLogBackupsRequest
        @return: DescribeLogBackupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_log_backups_with_options_async(request, runtime)

    def describe_modify_parameter_log_with_options(
        self,
        request: gpdb_20160503_models.DescribeModifyParameterLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeModifyParameterLogResponse:
        """
        @summary Queries the parameter modification logs of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeModifyParameterLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeModifyParameterLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeModifyParameterLog',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeModifyParameterLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_modify_parameter_log_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeModifyParameterLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeModifyParameterLogResponse:
        """
        @summary Queries the parameter modification logs of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeModifyParameterLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeModifyParameterLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeModifyParameterLog',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeModifyParameterLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_modify_parameter_log(
        self,
        request: gpdb_20160503_models.DescribeModifyParameterLogRequest,
    ) -> gpdb_20160503_models.DescribeModifyParameterLogResponse:
        """
        @summary Queries the parameter modification logs of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeModifyParameterLogRequest
        @return: DescribeModifyParameterLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_modify_parameter_log_with_options(request, runtime)

    async def describe_modify_parameter_log_async(
        self,
        request: gpdb_20160503_models.DescribeModifyParameterLogRequest,
    ) -> gpdb_20160503_models.DescribeModifyParameterLogResponse:
        """
        @summary Queries the parameter modification logs of an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeModifyParameterLogRequest
        @return: DescribeModifyParameterLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_modify_parameter_log_with_options_async(request, runtime)

    def describe_namespace_with_options(
        self,
        request: gpdb_20160503_models.DescribeNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeNamespaceResponse:
        """
        @summary Queries the information about a namespace.
        
        @param request: DescribeNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNamespace',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeNamespaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_namespace_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeNamespaceResponse:
        """
        @summary Queries the information about a namespace.
        
        @param request: DescribeNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNamespace',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeNamespaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_namespace(
        self,
        request: gpdb_20160503_models.DescribeNamespaceRequest,
    ) -> gpdb_20160503_models.DescribeNamespaceResponse:
        """
        @summary Queries the information about a namespace.
        
        @param request: DescribeNamespaceRequest
        @return: DescribeNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_namespace_with_options(request, runtime)

    async def describe_namespace_async(
        self,
        request: gpdb_20160503_models.DescribeNamespaceRequest,
    ) -> gpdb_20160503_models.DescribeNamespaceResponse:
        """
        @summary Queries the information about a namespace.
        
        @param request: DescribeNamespaceRequest
        @return: DescribeNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_namespace_with_options_async(request, runtime)

    def describe_parameters_with_options(
        self,
        request: gpdb_20160503_models.DescribeParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeParametersResponse:
        """
        @summary Queries the information about configuration parameters for an AnalyticDB for PostgreSQL instance.
        
        @description This operation can be called to query the details of parameters in an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeParametersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeParameters',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeParametersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_parameters_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeParametersResponse:
        """
        @summary Queries the information about configuration parameters for an AnalyticDB for PostgreSQL instance.
        
        @description This operation can be called to query the details of parameters in an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeParametersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeParameters',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeParametersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_parameters(
        self,
        request: gpdb_20160503_models.DescribeParametersRequest,
    ) -> gpdb_20160503_models.DescribeParametersResponse:
        """
        @summary Queries the information about configuration parameters for an AnalyticDB for PostgreSQL instance.
        
        @description This operation can be called to query the details of parameters in an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeParametersRequest
        @return: DescribeParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_parameters_with_options(request, runtime)

    async def describe_parameters_async(
        self,
        request: gpdb_20160503_models.DescribeParametersRequest,
    ) -> gpdb_20160503_models.DescribeParametersResponse:
        """
        @summary Queries the information about configuration parameters for an AnalyticDB for PostgreSQL instance.
        
        @description This operation can be called to query the details of parameters in an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeParametersRequest
        @return: DescribeParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_parameters_with_options_async(request, runtime)

    def describe_rds_vswitchs_with_options(
        self,
        request: gpdb_20160503_models.DescribeRdsVSwitchsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeRdsVSwitchsResponse:
        """
        @summary Queries a list of vSwitches.
        
        @description When you create AnalyticDB for PostgreSQL instances, you can call this operation to query the details of vSwitches within a specified region or zone.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRdsVSwitchsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRdsVSwitchsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRdsVSwitchs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeRdsVSwitchsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_rds_vswitchs_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeRdsVSwitchsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeRdsVSwitchsResponse:
        """
        @summary Queries a list of vSwitches.
        
        @description When you create AnalyticDB for PostgreSQL instances, you can call this operation to query the details of vSwitches within a specified region or zone.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRdsVSwitchsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRdsVSwitchsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRdsVSwitchs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeRdsVSwitchsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_rds_vswitchs(
        self,
        request: gpdb_20160503_models.DescribeRdsVSwitchsRequest,
    ) -> gpdb_20160503_models.DescribeRdsVSwitchsResponse:
        """
        @summary Queries a list of vSwitches.
        
        @description When you create AnalyticDB for PostgreSQL instances, you can call this operation to query the details of vSwitches within a specified region or zone.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRdsVSwitchsRequest
        @return: DescribeRdsVSwitchsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_rds_vswitchs_with_options(request, runtime)

    async def describe_rds_vswitchs_async(
        self,
        request: gpdb_20160503_models.DescribeRdsVSwitchsRequest,
    ) -> gpdb_20160503_models.DescribeRdsVSwitchsResponse:
        """
        @summary Queries a list of vSwitches.
        
        @description When you create AnalyticDB for PostgreSQL instances, you can call this operation to query the details of vSwitches within a specified region or zone.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRdsVSwitchsRequest
        @return: DescribeRdsVSwitchsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_rds_vswitchs_with_options_async(request, runtime)

    def describe_rds_vpcs_with_options(
        self,
        request: gpdb_20160503_models.DescribeRdsVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeRdsVpcsResponse:
        """
        @summary Queries a list of VPCs.
        
        @description When you create an AnalyticDB for PostgreSQL instance, you can call this operation to query the available VPCs within a specified region or zone.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRdsVpcsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRdsVpcsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRdsVpcs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeRdsVpcsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_rds_vpcs_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeRdsVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeRdsVpcsResponse:
        """
        @summary Queries a list of VPCs.
        
        @description When you create an AnalyticDB for PostgreSQL instance, you can call this operation to query the available VPCs within a specified region or zone.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRdsVpcsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRdsVpcsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_token):
            query['SecurityToken'] = request.security_token
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRdsVpcs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeRdsVpcsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_rds_vpcs(
        self,
        request: gpdb_20160503_models.DescribeRdsVpcsRequest,
    ) -> gpdb_20160503_models.DescribeRdsVpcsResponse:
        """
        @summary Queries a list of VPCs.
        
        @description When you create an AnalyticDB for PostgreSQL instance, you can call this operation to query the available VPCs within a specified region or zone.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRdsVpcsRequest
        @return: DescribeRdsVpcsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_rds_vpcs_with_options(request, runtime)

    async def describe_rds_vpcs_async(
        self,
        request: gpdb_20160503_models.DescribeRdsVpcsRequest,
    ) -> gpdb_20160503_models.DescribeRdsVpcsResponse:
        """
        @summary Queries a list of VPCs.
        
        @description When you create an AnalyticDB for PostgreSQL instance, you can call this operation to query the available VPCs within a specified region or zone.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRdsVpcsRequest
        @return: DescribeRdsVpcsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_rds_vpcs_with_options_async(request, runtime)

    def describe_regions_with_options(
        self,
        request: gpdb_20160503_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeRegionsResponse:
        """
        @summary Queries a list of regions and zones where AnalyticDB for PostgreSQL is available.
        
        @description Before you create an AnalyticDB for PostgreSQL instance, you must call this operation to query available regions and zones.
        ## Limit
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeRegionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_regions_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeRegionsResponse:
        """
        @summary Queries a list of regions and zones where AnalyticDB for PostgreSQL is available.
        
        @description Before you create an AnalyticDB for PostgreSQL instance, you must call this operation to query available regions and zones.
        ## Limit
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeRegionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_regions(
        self,
        request: gpdb_20160503_models.DescribeRegionsRequest,
    ) -> gpdb_20160503_models.DescribeRegionsResponse:
        """
        @summary Queries a list of regions and zones where AnalyticDB for PostgreSQL is available.
        
        @description Before you create an AnalyticDB for PostgreSQL instance, you must call this operation to query available regions and zones.
        ## Limit
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRegionsRequest
        @return: DescribeRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_regions_with_options(request, runtime)

    async def describe_regions_async(
        self,
        request: gpdb_20160503_models.DescribeRegionsRequest,
    ) -> gpdb_20160503_models.DescribeRegionsResponse:
        """
        @summary Queries a list of regions and zones where AnalyticDB for PostgreSQL is available.
        
        @description Before you create an AnalyticDB for PostgreSQL instance, you must call this operation to query available regions and zones.
        ## Limit
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRegionsRequest
        @return: DescribeRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_regions_with_options_async(request, runtime)

    def describe_roles_with_options(
        self,
        request: gpdb_20160503_models.DescribeRolesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeRolesResponse:
        """
        @summary Queries a list of roles.
        
        @param request: DescribeRolesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRolesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRoles',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeRolesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_roles_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeRolesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeRolesResponse:
        """
        @summary Queries a list of roles.
        
        @param request: DescribeRolesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRolesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRoles',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeRolesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_roles(
        self,
        request: gpdb_20160503_models.DescribeRolesRequest,
    ) -> gpdb_20160503_models.DescribeRolesResponse:
        """
        @summary Queries a list of roles.
        
        @param request: DescribeRolesRequest
        @return: DescribeRolesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_roles_with_options(request, runtime)

    async def describe_roles_async(
        self,
        request: gpdb_20160503_models.DescribeRolesRequest,
    ) -> gpdb_20160503_models.DescribeRolesResponse:
        """
        @summary Queries a list of roles.
        
        @param request: DescribeRolesRequest
        @return: DescribeRolesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_roles_with_options_async(request, runtime)

    def describe_sqllog_count_with_options(
        self,
        request: gpdb_20160503_models.DescribeSQLLogCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSQLLogCountResponse:
        """
        @summary Queries the number of audit logs for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is not available for instances in reserved storage mode.
        
        @param request: DescribeSQLLogCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSQLLogCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.execute_cost):
            query['ExecuteCost'] = request.execute_cost
        if not UtilClient.is_unset(request.execute_state):
            query['ExecuteState'] = request.execute_state
        if not UtilClient.is_unset(request.max_execute_cost):
            query['MaxExecuteCost'] = request.max_execute_cost
        if not UtilClient.is_unset(request.min_execute_cost):
            query['MinExecuteCost'] = request.min_execute_cost
        if not UtilClient.is_unset(request.operation_class):
            query['OperationClass'] = request.operation_class
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.query_keywords):
            query['QueryKeywords'] = request.query_keywords
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIP'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSQLLogCount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSQLLogCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sqllog_count_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeSQLLogCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSQLLogCountResponse:
        """
        @summary Queries the number of audit logs for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is not available for instances in reserved storage mode.
        
        @param request: DescribeSQLLogCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSQLLogCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.execute_cost):
            query['ExecuteCost'] = request.execute_cost
        if not UtilClient.is_unset(request.execute_state):
            query['ExecuteState'] = request.execute_state
        if not UtilClient.is_unset(request.max_execute_cost):
            query['MaxExecuteCost'] = request.max_execute_cost
        if not UtilClient.is_unset(request.min_execute_cost):
            query['MinExecuteCost'] = request.min_execute_cost
        if not UtilClient.is_unset(request.operation_class):
            query['OperationClass'] = request.operation_class
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.query_keywords):
            query['QueryKeywords'] = request.query_keywords
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIP'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSQLLogCount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSQLLogCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sqllog_count(
        self,
        request: gpdb_20160503_models.DescribeSQLLogCountRequest,
    ) -> gpdb_20160503_models.DescribeSQLLogCountResponse:
        """
        @summary Queries the number of audit logs for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is not available for instances in reserved storage mode.
        
        @param request: DescribeSQLLogCountRequest
        @return: DescribeSQLLogCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sqllog_count_with_options(request, runtime)

    async def describe_sqllog_count_async(
        self,
        request: gpdb_20160503_models.DescribeSQLLogCountRequest,
    ) -> gpdb_20160503_models.DescribeSQLLogCountResponse:
        """
        @summary Queries the number of audit logs for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is not available for instances in reserved storage mode.
        
        @param request: DescribeSQLLogCountRequest
        @return: DescribeSQLLogCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sqllog_count_with_options_async(request, runtime)

    def describe_sqllogs_with_options(
        self,
        request: gpdb_20160503_models.DescribeSQLLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSQLLogsResponse:
        """
        @summary Queries the SQL execution logs of an AnalyticDB for PostgreSQL instance.
        
        @description > This operation is no longer used. To query SQL execution logs, call the [DescribeSQLLogsV2](https://help.aliyun.com/document_detail/453722.html) operation.
        
        @param request: DescribeSQLLogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSQLLogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.execute_cost):
            query['ExecuteCost'] = request.execute_cost
        if not UtilClient.is_unset(request.execute_state):
            query['ExecuteState'] = request.execute_state
        if not UtilClient.is_unset(request.max_execute_cost):
            query['MaxExecuteCost'] = request.max_execute_cost
        if not UtilClient.is_unset(request.min_execute_cost):
            query['MinExecuteCost'] = request.min_execute_cost
        if not UtilClient.is_unset(request.operation_class):
            query['OperationClass'] = request.operation_class
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_keywords):
            query['QueryKeywords'] = request.query_keywords
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIP'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSQLLogs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSQLLogsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sqllogs_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeSQLLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSQLLogsResponse:
        """
        @summary Queries the SQL execution logs of an AnalyticDB for PostgreSQL instance.
        
        @description > This operation is no longer used. To query SQL execution logs, call the [DescribeSQLLogsV2](https://help.aliyun.com/document_detail/453722.html) operation.
        
        @param request: DescribeSQLLogsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSQLLogsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.execute_cost):
            query['ExecuteCost'] = request.execute_cost
        if not UtilClient.is_unset(request.execute_state):
            query['ExecuteState'] = request.execute_state
        if not UtilClient.is_unset(request.max_execute_cost):
            query['MaxExecuteCost'] = request.max_execute_cost
        if not UtilClient.is_unset(request.min_execute_cost):
            query['MinExecuteCost'] = request.min_execute_cost
        if not UtilClient.is_unset(request.operation_class):
            query['OperationClass'] = request.operation_class
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_keywords):
            query['QueryKeywords'] = request.query_keywords
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIP'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSQLLogs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSQLLogsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sqllogs(
        self,
        request: gpdb_20160503_models.DescribeSQLLogsRequest,
    ) -> gpdb_20160503_models.DescribeSQLLogsResponse:
        """
        @summary Queries the SQL execution logs of an AnalyticDB for PostgreSQL instance.
        
        @description > This operation is no longer used. To query SQL execution logs, call the [DescribeSQLLogsV2](https://help.aliyun.com/document_detail/453722.html) operation.
        
        @param request: DescribeSQLLogsRequest
        @return: DescribeSQLLogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sqllogs_with_options(request, runtime)

    async def describe_sqllogs_async(
        self,
        request: gpdb_20160503_models.DescribeSQLLogsRequest,
    ) -> gpdb_20160503_models.DescribeSQLLogsResponse:
        """
        @summary Queries the SQL execution logs of an AnalyticDB for PostgreSQL instance.
        
        @description > This operation is no longer used. To query SQL execution logs, call the [DescribeSQLLogsV2](https://help.aliyun.com/document_detail/453722.html) operation.
        
        @param request: DescribeSQLLogsRequest
        @return: DescribeSQLLogsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sqllogs_with_options_async(request, runtime)

    def describe_sqllogs_v2with_options(
        self,
        request: gpdb_20160503_models.DescribeSQLLogsV2Request,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSQLLogsV2Response:
        """
        @summary Queries SQL logs within a specific time range.
        
        @description You can call this operation to query SQL logs of an AnalyticDB for PostgreSQL instance within a specific time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeSQLLogsV2Request
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSQLLogsV2Response
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.execute_cost):
            query['ExecuteCost'] = request.execute_cost
        if not UtilClient.is_unset(request.execute_state):
            query['ExecuteState'] = request.execute_state
        if not UtilClient.is_unset(request.max_execute_cost):
            query['MaxExecuteCost'] = request.max_execute_cost
        if not UtilClient.is_unset(request.min_execute_cost):
            query['MinExecuteCost'] = request.min_execute_cost
        if not UtilClient.is_unset(request.operation_class):
            query['OperationClass'] = request.operation_class
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_keywords):
            query['QueryKeywords'] = request.query_keywords
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIP'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSQLLogsV2',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSQLLogsV2Response(),
            self.call_api(params, req, runtime)
        )

    async def describe_sqllogs_v2with_options_async(
        self,
        request: gpdb_20160503_models.DescribeSQLLogsV2Request,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSQLLogsV2Response:
        """
        @summary Queries SQL logs within a specific time range.
        
        @description You can call this operation to query SQL logs of an AnalyticDB for PostgreSQL instance within a specific time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeSQLLogsV2Request
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSQLLogsV2Response
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.execute_cost):
            query['ExecuteCost'] = request.execute_cost
        if not UtilClient.is_unset(request.execute_state):
            query['ExecuteState'] = request.execute_state
        if not UtilClient.is_unset(request.max_execute_cost):
            query['MaxExecuteCost'] = request.max_execute_cost
        if not UtilClient.is_unset(request.min_execute_cost):
            query['MinExecuteCost'] = request.min_execute_cost
        if not UtilClient.is_unset(request.operation_class):
            query['OperationClass'] = request.operation_class
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_keywords):
            query['QueryKeywords'] = request.query_keywords
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIP'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSQLLogsV2',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSQLLogsV2Response(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sqllogs_v2(
        self,
        request: gpdb_20160503_models.DescribeSQLLogsV2Request,
    ) -> gpdb_20160503_models.DescribeSQLLogsV2Response:
        """
        @summary Queries SQL logs within a specific time range.
        
        @description You can call this operation to query SQL logs of an AnalyticDB for PostgreSQL instance within a specific time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeSQLLogsV2Request
        @return: DescribeSQLLogsV2Response
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sqllogs_v2with_options(request, runtime)

    async def describe_sqllogs_v2_async(
        self,
        request: gpdb_20160503_models.DescribeSQLLogsV2Request,
    ) -> gpdb_20160503_models.DescribeSQLLogsV2Response:
        """
        @summary Queries SQL logs within a specific time range.
        
        @description You can call this operation to query SQL logs of an AnalyticDB for PostgreSQL instance within a specific time range.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeSQLLogsV2Request
        @return: DescribeSQLLogsV2Response
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sqllogs_v2with_options_async(request, runtime)

    def describe_sample_data_with_options(
        self,
        request: gpdb_20160503_models.DescribeSampleDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSampleDataResponse:
        """
        @summary Queries whether a sample dataset is loaded to an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeSampleDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSampleDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSampleData',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSampleDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sample_data_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeSampleDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSampleDataResponse:
        """
        @summary Queries whether a sample dataset is loaded to an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeSampleDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSampleDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSampleData',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSampleDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sample_data(
        self,
        request: gpdb_20160503_models.DescribeSampleDataRequest,
    ) -> gpdb_20160503_models.DescribeSampleDataResponse:
        """
        @summary Queries whether a sample dataset is loaded to an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeSampleDataRequest
        @return: DescribeSampleDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sample_data_with_options(request, runtime)

    async def describe_sample_data_async(
        self,
        request: gpdb_20160503_models.DescribeSampleDataRequest,
    ) -> gpdb_20160503_models.DescribeSampleDataResponse:
        """
        @summary Queries whether a sample dataset is loaded to an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeSampleDataRequest
        @return: DescribeSampleDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sample_data_with_options_async(request, runtime)

    def describe_streaming_data_service_with_options(
        self,
        request: gpdb_20160503_models.DescribeStreamingDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeStreamingDataServiceResponse:
        """
        @summary Queries a real-time data service.
        
        @param request: DescribeStreamingDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStreamingDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStreamingDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeStreamingDataServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_streaming_data_service_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeStreamingDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeStreamingDataServiceResponse:
        """
        @summary Queries a real-time data service.
        
        @param request: DescribeStreamingDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStreamingDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStreamingDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeStreamingDataServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_streaming_data_service(
        self,
        request: gpdb_20160503_models.DescribeStreamingDataServiceRequest,
    ) -> gpdb_20160503_models.DescribeStreamingDataServiceResponse:
        """
        @summary Queries a real-time data service.
        
        @param request: DescribeStreamingDataServiceRequest
        @return: DescribeStreamingDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_streaming_data_service_with_options(request, runtime)

    async def describe_streaming_data_service_async(
        self,
        request: gpdb_20160503_models.DescribeStreamingDataServiceRequest,
    ) -> gpdb_20160503_models.DescribeStreamingDataServiceResponse:
        """
        @summary Queries a real-time data service.
        
        @param request: DescribeStreamingDataServiceRequest
        @return: DescribeStreamingDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_streaming_data_service_with_options_async(request, runtime)

    def describe_streaming_data_source_with_options(
        self,
        request: gpdb_20160503_models.DescribeStreamingDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeStreamingDataSourceResponse:
        """
        @summary Get external data source configuration information
        
        @param request: DescribeStreamingDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStreamingDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStreamingDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeStreamingDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_streaming_data_source_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeStreamingDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeStreamingDataSourceResponse:
        """
        @summary Get external data source configuration information
        
        @param request: DescribeStreamingDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStreamingDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStreamingDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeStreamingDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_streaming_data_source(
        self,
        request: gpdb_20160503_models.DescribeStreamingDataSourceRequest,
    ) -> gpdb_20160503_models.DescribeStreamingDataSourceResponse:
        """
        @summary Get external data source configuration information
        
        @param request: DescribeStreamingDataSourceRequest
        @return: DescribeStreamingDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_streaming_data_source_with_options(request, runtime)

    async def describe_streaming_data_source_async(
        self,
        request: gpdb_20160503_models.DescribeStreamingDataSourceRequest,
    ) -> gpdb_20160503_models.DescribeStreamingDataSourceResponse:
        """
        @summary Get external data source configuration information
        
        @param request: DescribeStreamingDataSourceRequest
        @return: DescribeStreamingDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_streaming_data_source_with_options_async(request, runtime)

    def describe_streaming_job_with_options(
        self,
        request: gpdb_20160503_models.DescribeStreamingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeStreamingJobResponse:
        """
        @summary Delete External Data Source Configuration
        
        @param request: DescribeStreamingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStreamingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStreamingJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeStreamingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_streaming_job_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeStreamingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeStreamingJobResponse:
        """
        @summary Delete External Data Source Configuration
        
        @param request: DescribeStreamingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStreamingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStreamingJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeStreamingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_streaming_job(
        self,
        request: gpdb_20160503_models.DescribeStreamingJobRequest,
    ) -> gpdb_20160503_models.DescribeStreamingJobResponse:
        """
        @summary Delete External Data Source Configuration
        
        @param request: DescribeStreamingJobRequest
        @return: DescribeStreamingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_streaming_job_with_options(request, runtime)

    async def describe_streaming_job_async(
        self,
        request: gpdb_20160503_models.DescribeStreamingJobRequest,
    ) -> gpdb_20160503_models.DescribeStreamingJobResponse:
        """
        @summary Delete External Data Source Configuration
        
        @param request: DescribeStreamingJobRequest
        @return: DescribeStreamingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_streaming_job_with_options_async(request, runtime)

    def describe_support_features_with_options(
        self,
        request: gpdb_20160503_models.DescribeSupportFeaturesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSupportFeaturesResponse:
        """
        @summary Queries the features that are supported by an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeSupportFeaturesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSupportFeaturesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSupportFeatures',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSupportFeaturesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_support_features_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeSupportFeaturesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeSupportFeaturesResponse:
        """
        @summary Queries the features that are supported by an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeSupportFeaturesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSupportFeaturesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSupportFeatures',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeSupportFeaturesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_support_features(
        self,
        request: gpdb_20160503_models.DescribeSupportFeaturesRequest,
    ) -> gpdb_20160503_models.DescribeSupportFeaturesResponse:
        """
        @summary Queries the features that are supported by an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeSupportFeaturesRequest
        @return: DescribeSupportFeaturesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_support_features_with_options(request, runtime)

    async def describe_support_features_async(
        self,
        request: gpdb_20160503_models.DescribeSupportFeaturesRequest,
    ) -> gpdb_20160503_models.DescribeSupportFeaturesResponse:
        """
        @summary Queries the features that are supported by an AnalyticDB for PostgreSQL instance.
        
        @param request: DescribeSupportFeaturesRequest
        @return: DescribeSupportFeaturesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_support_features_with_options_async(request, runtime)

    def describe_table_with_options(
        self,
        request: gpdb_20160503_models.DescribeTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeTableResponse:
        """
        @summary Queries the information about a table.
        
        @param request: DescribeTableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.schema):
            query['Schema'] = request.schema
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.table):
            query['Table'] = request.table
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTable',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_table_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeTableResponse:
        """
        @summary Queries the information about a table.
        
        @param request: DescribeTableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.schema):
            query['Schema'] = request.schema
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.table):
            query['Table'] = request.table
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTable',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_table(
        self,
        request: gpdb_20160503_models.DescribeTableRequest,
    ) -> gpdb_20160503_models.DescribeTableResponse:
        """
        @summary Queries the information about a table.
        
        @param request: DescribeTableRequest
        @return: DescribeTableResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_table_with_options(request, runtime)

    async def describe_table_async(
        self,
        request: gpdb_20160503_models.DescribeTableRequest,
    ) -> gpdb_20160503_models.DescribeTableResponse:
        """
        @summary Queries the information about a table.
        
        @param request: DescribeTableRequest
        @return: DescribeTableResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_table_with_options_async(request, runtime)

    def describe_tags_with_options(
        self,
        request: gpdb_20160503_models.DescribeTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeTagsResponse:
        """
        @summary Queries a list of tags for AnalyticDB for PostgreSQL instances.
        
        @param request: DescribeTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTags',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeTagsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_tags_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeTagsResponse:
        """
        @summary Queries a list of tags for AnalyticDB for PostgreSQL instances.
        
        @param request: DescribeTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTags',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeTagsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_tags(
        self,
        request: gpdb_20160503_models.DescribeTagsRequest,
    ) -> gpdb_20160503_models.DescribeTagsResponse:
        """
        @summary Queries a list of tags for AnalyticDB for PostgreSQL instances.
        
        @param request: DescribeTagsRequest
        @return: DescribeTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_tags_with_options(request, runtime)

    async def describe_tags_async(
        self,
        request: gpdb_20160503_models.DescribeTagsRequest,
    ) -> gpdb_20160503_models.DescribeTagsResponse:
        """
        @summary Queries a list of tags for AnalyticDB for PostgreSQL instances.
        
        @param request: DescribeTagsRequest
        @return: DescribeTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_tags_with_options_async(request, runtime)

    def describe_user_encryption_key_list_with_options(
        self,
        request: gpdb_20160503_models.DescribeUserEncryptionKeyListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeUserEncryptionKeyListResponse:
        """
        @summary Queries a list of Key Management Service (KMS) keys.
        
        @param request: DescribeUserEncryptionKeyListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserEncryptionKeyListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserEncryptionKeyList',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeUserEncryptionKeyListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_encryption_key_list_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeUserEncryptionKeyListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeUserEncryptionKeyListResponse:
        """
        @summary Queries a list of Key Management Service (KMS) keys.
        
        @param request: DescribeUserEncryptionKeyListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserEncryptionKeyListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserEncryptionKeyList',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeUserEncryptionKeyListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_encryption_key_list(
        self,
        request: gpdb_20160503_models.DescribeUserEncryptionKeyListRequest,
    ) -> gpdb_20160503_models.DescribeUserEncryptionKeyListResponse:
        """
        @summary Queries a list of Key Management Service (KMS) keys.
        
        @param request: DescribeUserEncryptionKeyListRequest
        @return: DescribeUserEncryptionKeyListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_encryption_key_list_with_options(request, runtime)

    async def describe_user_encryption_key_list_async(
        self,
        request: gpdb_20160503_models.DescribeUserEncryptionKeyListRequest,
    ) -> gpdb_20160503_models.DescribeUserEncryptionKeyListResponse:
        """
        @summary Queries a list of Key Management Service (KMS) keys.
        
        @param request: DescribeUserEncryptionKeyListRequest
        @return: DescribeUserEncryptionKeyListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_encryption_key_list_with_options_async(request, runtime)

    def describe_waiting_sqlinfo_with_options(
        self,
        request: gpdb_20160503_models.DescribeWaitingSQLInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeWaitingSQLInfoResponse:
        """
        @summary Queries the information about a lock-waiting query for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of a lock-waiting query only for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeWaitingSQLInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeWaitingSQLInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.pid):
            query['PID'] = request.pid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWaitingSQLInfo',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeWaitingSQLInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_waiting_sqlinfo_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeWaitingSQLInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeWaitingSQLInfoResponse:
        """
        @summary Queries the information about a lock-waiting query for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of a lock-waiting query only for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeWaitingSQLInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeWaitingSQLInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.pid):
            query['PID'] = request.pid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWaitingSQLInfo',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeWaitingSQLInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_waiting_sqlinfo(
        self,
        request: gpdb_20160503_models.DescribeWaitingSQLInfoRequest,
    ) -> gpdb_20160503_models.DescribeWaitingSQLInfoResponse:
        """
        @summary Queries the information about a lock-waiting query for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of a lock-waiting query only for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeWaitingSQLInfoRequest
        @return: DescribeWaitingSQLInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_waiting_sqlinfo_with_options(request, runtime)

    async def describe_waiting_sqlinfo_async(
        self,
        request: gpdb_20160503_models.DescribeWaitingSQLInfoRequest,
    ) -> gpdb_20160503_models.DescribeWaitingSQLInfoResponse:
        """
        @summary Queries the information about a lock-waiting query for an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the details of a lock-waiting query only for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeWaitingSQLInfoRequest
        @return: DescribeWaitingSQLInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_waiting_sqlinfo_with_options_async(request, runtime)

    def describe_waiting_sqlrecords_with_options(
        self,
        request: gpdb_20160503_models.DescribeWaitingSQLRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeWaitingSQLRecordsResponse:
        """
        @summary Queries the lock diagnostic records of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the lock diagnostics records only for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeWaitingSQLRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeWaitingSQLRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_condition):
            query['QueryCondition'] = request.query_condition
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWaitingSQLRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeWaitingSQLRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_waiting_sqlrecords_with_options_async(
        self,
        request: gpdb_20160503_models.DescribeWaitingSQLRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DescribeWaitingSQLRecordsResponse:
        """
        @summary Queries the lock diagnostic records of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the lock diagnostics records only for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeWaitingSQLRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeWaitingSQLRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_condition):
            query['QueryCondition'] = request.query_condition
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWaitingSQLRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DescribeWaitingSQLRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_waiting_sqlrecords(
        self,
        request: gpdb_20160503_models.DescribeWaitingSQLRecordsRequest,
    ) -> gpdb_20160503_models.DescribeWaitingSQLRecordsResponse:
        """
        @summary Queries the lock diagnostic records of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the lock diagnostics records only for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeWaitingSQLRecordsRequest
        @return: DescribeWaitingSQLRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_waiting_sqlrecords_with_options(request, runtime)

    async def describe_waiting_sqlrecords_async(
        self,
        request: gpdb_20160503_models.DescribeWaitingSQLRecordsRequest,
    ) -> gpdb_20160503_models.DescribeWaitingSQLRecordsResponse:
        """
        @summary Queries the lock diagnostic records of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to query the lock diagnostics records only for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeWaitingSQLRecordsRequest
        @return: DescribeWaitingSQLRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_waiting_sqlrecords_with_options_async(request, runtime)

    def disable_dbresource_group_with_options(
        self,
        request: gpdb_20160503_models.DisableDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DisableDBResourceGroupResponse:
        """
        @summary Disables resource group management for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode. After you disable resource group management, the resource management method of the instance switches from resource group management to resource queue management.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL V6.0 instances in elastic storage mode whose minor version is V6.6.1.0 or later.
        You can call this operation to disable resource group management only for AnalyticDB for PostgreSQL instances that are in the **Running** state.
        **Note: When the resource management method is switched, your AnalyticDB for PostgreSQL instance restarts and becomes unavailable for approximately 5 minutes. To prevent your business from being affected, call this operation during off-peak hours.
        
        @param request: DisableDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisableDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DisableDBResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def disable_dbresource_group_with_options_async(
        self,
        request: gpdb_20160503_models.DisableDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DisableDBResourceGroupResponse:
        """
        @summary Disables resource group management for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode. After you disable resource group management, the resource management method of the instance switches from resource group management to resource queue management.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL V6.0 instances in elastic storage mode whose minor version is V6.6.1.0 or later.
        You can call this operation to disable resource group management only for AnalyticDB for PostgreSQL instances that are in the **Running** state.
        **Note: When the resource management method is switched, your AnalyticDB for PostgreSQL instance restarts and becomes unavailable for approximately 5 minutes. To prevent your business from being affected, call this operation during off-peak hours.
        
        @param request: DisableDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DisableDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DisableDBResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def disable_dbresource_group(
        self,
        request: gpdb_20160503_models.DisableDBResourceGroupRequest,
    ) -> gpdb_20160503_models.DisableDBResourceGroupResponse:
        """
        @summary Disables resource group management for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode. After you disable resource group management, the resource management method of the instance switches from resource group management to resource queue management.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL V6.0 instances in elastic storage mode whose minor version is V6.6.1.0 or later.
        You can call this operation to disable resource group management only for AnalyticDB for PostgreSQL instances that are in the **Running** state.
        **Note: When the resource management method is switched, your AnalyticDB for PostgreSQL instance restarts and becomes unavailable for approximately 5 minutes. To prevent your business from being affected, call this operation during off-peak hours.
        
        @param request: DisableDBResourceGroupRequest
        @return: DisableDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.disable_dbresource_group_with_options(request, runtime)

    async def disable_dbresource_group_async(
        self,
        request: gpdb_20160503_models.DisableDBResourceGroupRequest,
    ) -> gpdb_20160503_models.DisableDBResourceGroupResponse:
        """
        @summary Disables resource group management for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode. After you disable resource group management, the resource management method of the instance switches from resource group management to resource queue management.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL V6.0 instances in elastic storage mode whose minor version is V6.6.1.0 or later.
        You can call this operation to disable resource group management only for AnalyticDB for PostgreSQL instances that are in the **Running** state.
        **Note: When the resource management method is switched, your AnalyticDB for PostgreSQL instance restarts and becomes unavailable for approximately 5 minutes. To prevent your business from being affected, call this operation during off-peak hours.
        
        @param request: DisableDBResourceGroupRequest
        @return: DisableDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.disable_dbresource_group_with_options_async(request, runtime)

    def download_diagnosis_records_with_options(
        self,
        request: gpdb_20160503_models.DownloadDiagnosisRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DownloadDiagnosisRecordsResponse:
        """
        @summary Downloads the query diagnostic information of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to download the query diagnostic information of an AnalyticDB for PostgreSQL instance. After the download is complete, you can call the [DescribeDownloadRecords](https://help.aliyun.com/document_detail/447712.html) operation to query download records and download URLs.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For more information about how to view and update the minor engine version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DownloadDiagnosisRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DownloadDiagnosisRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.query_condition):
            query['QueryCondition'] = request.query_condition
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DownloadDiagnosisRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DownloadDiagnosisRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def download_diagnosis_records_with_options_async(
        self,
        request: gpdb_20160503_models.DownloadDiagnosisRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DownloadDiagnosisRecordsResponse:
        """
        @summary Downloads the query diagnostic information of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to download the query diagnostic information of an AnalyticDB for PostgreSQL instance. After the download is complete, you can call the [DescribeDownloadRecords](https://help.aliyun.com/document_detail/447712.html) operation to query download records and download URLs.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For more information about how to view and update the minor engine version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DownloadDiagnosisRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DownloadDiagnosisRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.query_condition):
            query['QueryCondition'] = request.query_condition
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DownloadDiagnosisRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DownloadDiagnosisRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def download_diagnosis_records(
        self,
        request: gpdb_20160503_models.DownloadDiagnosisRecordsRequest,
    ) -> gpdb_20160503_models.DownloadDiagnosisRecordsResponse:
        """
        @summary Downloads the query diagnostic information of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to download the query diagnostic information of an AnalyticDB for PostgreSQL instance. After the download is complete, you can call the [DescribeDownloadRecords](https://help.aliyun.com/document_detail/447712.html) operation to query download records and download URLs.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For more information about how to view and update the minor engine version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DownloadDiagnosisRecordsRequest
        @return: DownloadDiagnosisRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.download_diagnosis_records_with_options(request, runtime)

    async def download_diagnosis_records_async(
        self,
        request: gpdb_20160503_models.DownloadDiagnosisRecordsRequest,
    ) -> gpdb_20160503_models.DownloadDiagnosisRecordsResponse:
        """
        @summary Downloads the query diagnostic information of an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to download the query diagnostic information of an AnalyticDB for PostgreSQL instance. After the download is complete, you can call the [DescribeDownloadRecords](https://help.aliyun.com/document_detail/447712.html) operation to query download records and download URLs.
        This operation is available only for instances of V6.3.10.1 or later in elastic storage mode. For more information about how to view and update the minor engine version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DownloadDiagnosisRecordsRequest
        @return: DownloadDiagnosisRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.download_diagnosis_records_with_options_async(request, runtime)

    def download_sqllogs_records_with_options(
        self,
        request: gpdb_20160503_models.DownloadSQLLogsRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DownloadSQLLogsRecordsResponse:
        """
        @summary Download the slow query logs of an AnalyticDB for PostgreSQL instance.
        
        @param request: DownloadSQLLogsRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DownloadSQLLogsRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.execute_cost):
            query['ExecuteCost'] = request.execute_cost
        if not UtilClient.is_unset(request.execute_state):
            query['ExecuteState'] = request.execute_state
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.max_execute_cost):
            query['MaxExecuteCost'] = request.max_execute_cost
        if not UtilClient.is_unset(request.min_execute_cost):
            query['MinExecuteCost'] = request.min_execute_cost
        if not UtilClient.is_unset(request.operation_class):
            query['OperationClass'] = request.operation_class
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_keywords):
            query['QueryKeywords'] = request.query_keywords
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIP'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DownloadSQLLogsRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DownloadSQLLogsRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def download_sqllogs_records_with_options_async(
        self,
        request: gpdb_20160503_models.DownloadSQLLogsRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.DownloadSQLLogsRecordsResponse:
        """
        @summary Download the slow query logs of an AnalyticDB for PostgreSQL instance.
        
        @param request: DownloadSQLLogsRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DownloadSQLLogsRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.execute_cost):
            query['ExecuteCost'] = request.execute_cost
        if not UtilClient.is_unset(request.execute_state):
            query['ExecuteState'] = request.execute_state
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.max_execute_cost):
            query['MaxExecuteCost'] = request.max_execute_cost
        if not UtilClient.is_unset(request.min_execute_cost):
            query['MinExecuteCost'] = request.min_execute_cost
        if not UtilClient.is_unset(request.operation_class):
            query['OperationClass'] = request.operation_class
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_keywords):
            query['QueryKeywords'] = request.query_keywords
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIP'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DownloadSQLLogsRecords',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.DownloadSQLLogsRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def download_sqllogs_records(
        self,
        request: gpdb_20160503_models.DownloadSQLLogsRecordsRequest,
    ) -> gpdb_20160503_models.DownloadSQLLogsRecordsResponse:
        """
        @summary Download the slow query logs of an AnalyticDB for PostgreSQL instance.
        
        @param request: DownloadSQLLogsRecordsRequest
        @return: DownloadSQLLogsRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.download_sqllogs_records_with_options(request, runtime)

    async def download_sqllogs_records_async(
        self,
        request: gpdb_20160503_models.DownloadSQLLogsRecordsRequest,
    ) -> gpdb_20160503_models.DownloadSQLLogsRecordsResponse:
        """
        @summary Download the slow query logs of an AnalyticDB for PostgreSQL instance.
        
        @param request: DownloadSQLLogsRecordsRequest
        @return: DownloadSQLLogsRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.download_sqllogs_records_with_options_async(request, runtime)

    def enable_dbresource_group_with_options(
        self,
        request: gpdb_20160503_models.EnableDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.EnableDBResourceGroupResponse:
        """
        @summary Enables resource group management for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode. After resource group management is enabled, the resource management mode of the instance is changed from resource queue to resource group.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL V6.0 instances in elastic storage mode whose minor version is V6.6.1.0 or later.
        You can call this operation to enable resource group management only for AnalyticDB for PostgreSQL instances that are in the **Running** state.
        **Note: When the resource management mode is changed, your AnalyticDB for PostgreSQL instance is restarted and remains unavailable within 5 minutes. To prevent your business from being affected, call this operation during off-peak hours.
        
        @param request: EnableDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.EnableDBResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_dbresource_group_with_options_async(
        self,
        request: gpdb_20160503_models.EnableDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.EnableDBResourceGroupResponse:
        """
        @summary Enables resource group management for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode. After resource group management is enabled, the resource management mode of the instance is changed from resource queue to resource group.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL V6.0 instances in elastic storage mode whose minor version is V6.6.1.0 or later.
        You can call this operation to enable resource group management only for AnalyticDB for PostgreSQL instances that are in the **Running** state.
        **Note: When the resource management mode is changed, your AnalyticDB for PostgreSQL instance is restarted and remains unavailable within 5 minutes. To prevent your business from being affected, call this operation during off-peak hours.
        
        @param request: EnableDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableDBResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.EnableDBResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_dbresource_group(
        self,
        request: gpdb_20160503_models.EnableDBResourceGroupRequest,
    ) -> gpdb_20160503_models.EnableDBResourceGroupResponse:
        """
        @summary Enables resource group management for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode. After resource group management is enabled, the resource management mode of the instance is changed from resource queue to resource group.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL V6.0 instances in elastic storage mode whose minor version is V6.6.1.0 or later.
        You can call this operation to enable resource group management only for AnalyticDB for PostgreSQL instances that are in the **Running** state.
        **Note: When the resource management mode is changed, your AnalyticDB for PostgreSQL instance is restarted and remains unavailable within 5 minutes. To prevent your business from being affected, call this operation during off-peak hours.
        
        @param request: EnableDBResourceGroupRequest
        @return: EnableDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.enable_dbresource_group_with_options(request, runtime)

    async def enable_dbresource_group_async(
        self,
        request: gpdb_20160503_models.EnableDBResourceGroupRequest,
    ) -> gpdb_20160503_models.EnableDBResourceGroupResponse:
        """
        @summary Enables resource group management for an AnalyticDB for PostgreSQL V6.0 instance in elastic storage mode. After resource group management is enabled, the resource management mode of the instance is changed from resource queue to resource group.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL V6.0 instances in elastic storage mode whose minor version is V6.6.1.0 or later.
        You can call this operation to enable resource group management only for AnalyticDB for PostgreSQL instances that are in the **Running** state.
        **Note: When the resource management mode is changed, your AnalyticDB for PostgreSQL instance is restarted and remains unavailable within 5 minutes. To prevent your business from being affected, call this operation during off-peak hours.
        
        @param request: EnableDBResourceGroupRequest
        @return: EnableDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.enable_dbresource_group_with_options_async(request, runtime)

    def execute_statement_with_options(
        self,
        tmp_req: gpdb_20160503_models.ExecuteStatementRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ExecuteStatementResponse:
        """
        @summary Executes SQL statements.
        
        @param tmp_req: ExecuteStatementRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExecuteStatementResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.ExecuteStatementShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.parameters):
            request.parameters_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.parameters, 'Parameters', 'json')
        if not UtilClient.is_unset(tmp_req.rag_workspace_collection):
            request.rag_workspace_collection_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.rag_workspace_collection, 'RagWorkspaceCollection', 'json')
        if not UtilClient.is_unset(tmp_req.sqls):
            request.sqls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sqls, 'Sqls', 'json')
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.rag_workspace_collection_shrink):
            query['RagWorkspaceCollection'] = request.rag_workspace_collection_shrink
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.run_type):
            query['RunType'] = request.run_type
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.statement_name):
            query['StatementName'] = request.statement_name
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        body = {}
        if not UtilClient.is_unset(request.parameters_shrink):
            body['Parameters'] = request.parameters_shrink
        if not UtilClient.is_unset(request.sql):
            body['Sql'] = request.sql
        if not UtilClient.is_unset(request.sqls_shrink):
            body['Sqls'] = request.sqls_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExecuteStatement',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ExecuteStatementResponse(),
            self.call_api(params, req, runtime)
        )

    async def execute_statement_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.ExecuteStatementRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ExecuteStatementResponse:
        """
        @summary Executes SQL statements.
        
        @param tmp_req: ExecuteStatementRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExecuteStatementResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.ExecuteStatementShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.parameters):
            request.parameters_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.parameters, 'Parameters', 'json')
        if not UtilClient.is_unset(tmp_req.rag_workspace_collection):
            request.rag_workspace_collection_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.rag_workspace_collection, 'RagWorkspaceCollection', 'json')
        if not UtilClient.is_unset(tmp_req.sqls):
            request.sqls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sqls, 'Sqls', 'json')
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.rag_workspace_collection_shrink):
            query['RagWorkspaceCollection'] = request.rag_workspace_collection_shrink
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.run_type):
            query['RunType'] = request.run_type
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.statement_name):
            query['StatementName'] = request.statement_name
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        body = {}
        if not UtilClient.is_unset(request.parameters_shrink):
            body['Parameters'] = request.parameters_shrink
        if not UtilClient.is_unset(request.sql):
            body['Sql'] = request.sql
        if not UtilClient.is_unset(request.sqls_shrink):
            body['Sqls'] = request.sqls_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExecuteStatement',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ExecuteStatementResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def execute_statement(
        self,
        request: gpdb_20160503_models.ExecuteStatementRequest,
    ) -> gpdb_20160503_models.ExecuteStatementResponse:
        """
        @summary Executes SQL statements.
        
        @param request: ExecuteStatementRequest
        @return: ExecuteStatementResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.execute_statement_with_options(request, runtime)

    async def execute_statement_async(
        self,
        request: gpdb_20160503_models.ExecuteStatementRequest,
    ) -> gpdb_20160503_models.ExecuteStatementResponse:
        """
        @summary Executes SQL statements.
        
        @param request: ExecuteStatementRequest
        @return: ExecuteStatementResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.execute_statement_with_options_async(request, runtime)

    def get_account_with_options(
        self,
        request: gpdb_20160503_models.GetAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetAccountResponse:
        """
        @summary 获取特定的账号信息
        
        @param request: GetAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAccount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetAccountResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_account_with_options_async(
        self,
        request: gpdb_20160503_models.GetAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetAccountResponse:
        """
        @summary 获取特定的账号信息
        
        @param request: GetAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAccount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetAccountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_account(
        self,
        request: gpdb_20160503_models.GetAccountRequest,
    ) -> gpdb_20160503_models.GetAccountResponse:
        """
        @summary 获取特定的账号信息
        
        @param request: GetAccountRequest
        @return: GetAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_account_with_options(request, runtime)

    async def get_account_async(
        self,
        request: gpdb_20160503_models.GetAccountRequest,
    ) -> gpdb_20160503_models.GetAccountResponse:
        """
        @summary 获取特定的账号信息
        
        @param request: GetAccountRequest
        @return: GetAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_account_with_options_async(request, runtime)

    def get_secret_value_with_options(
        self,
        request: gpdb_20160503_models.GetSecretValueRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetSecretValueResponse:
        """
        @summary Queries the information about an access credential.
        
        @param request: GetSecretValueRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSecretValueResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.secret_name):
            query['SecretName'] = request.secret_name
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSecretValue',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetSecretValueResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_secret_value_with_options_async(
        self,
        request: gpdb_20160503_models.GetSecretValueRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetSecretValueResponse:
        """
        @summary Queries the information about an access credential.
        
        @param request: GetSecretValueRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSecretValueResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.secret_name):
            query['SecretName'] = request.secret_name
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSecretValue',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetSecretValueResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_secret_value(
        self,
        request: gpdb_20160503_models.GetSecretValueRequest,
    ) -> gpdb_20160503_models.GetSecretValueResponse:
        """
        @summary Queries the information about an access credential.
        
        @param request: GetSecretValueRequest
        @return: GetSecretValueResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_secret_value_with_options(request, runtime)

    async def get_secret_value_async(
        self,
        request: gpdb_20160503_models.GetSecretValueRequest,
    ) -> gpdb_20160503_models.GetSecretValueResponse:
        """
        @summary Queries the information about an access credential.
        
        @param request: GetSecretValueRequest
        @return: GetSecretValueResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_secret_value_with_options_async(request, runtime)

    def get_statement_result_with_options(
        self,
        request: gpdb_20160503_models.GetStatementResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetStatementResultResponse:
        """
        @summary Get Asynchronous SQL Execution Result
        
        @param request: GetStatementResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetStatementResultResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetStatementResult',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetStatementResultResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_statement_result_with_options_async(
        self,
        request: gpdb_20160503_models.GetStatementResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetStatementResultResponse:
        """
        @summary Get Asynchronous SQL Execution Result
        
        @param request: GetStatementResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetStatementResultResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetStatementResult',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetStatementResultResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_statement_result(
        self,
        request: gpdb_20160503_models.GetStatementResultRequest,
    ) -> gpdb_20160503_models.GetStatementResultResponse:
        """
        @summary Get Asynchronous SQL Execution Result
        
        @param request: GetStatementResultRequest
        @return: GetStatementResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_statement_result_with_options(request, runtime)

    async def get_statement_result_async(
        self,
        request: gpdb_20160503_models.GetStatementResultRequest,
    ) -> gpdb_20160503_models.GetStatementResultResponse:
        """
        @summary Get Asynchronous SQL Execution Result
        
        @param request: GetStatementResultRequest
        @return: GetStatementResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_statement_result_with_options_async(request, runtime)

    def get_supabase_project_with_options(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetSupabaseProjectResponse:
        """
        @summary 查询Supabase实例详情
        
        @param request: GetSupabaseProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSupabaseProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSupabaseProject',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetSupabaseProjectResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_supabase_project_with_options_async(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetSupabaseProjectResponse:
        """
        @summary 查询Supabase实例详情
        
        @param request: GetSupabaseProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSupabaseProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSupabaseProject',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetSupabaseProjectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_supabase_project(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectRequest,
    ) -> gpdb_20160503_models.GetSupabaseProjectResponse:
        """
        @summary 查询Supabase实例详情
        
        @param request: GetSupabaseProjectRequest
        @return: GetSupabaseProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_supabase_project_with_options(request, runtime)

    async def get_supabase_project_async(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectRequest,
    ) -> gpdb_20160503_models.GetSupabaseProjectResponse:
        """
        @summary 查询Supabase实例详情
        
        @param request: GetSupabaseProjectRequest
        @return: GetSupabaseProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_supabase_project_with_options_async(request, runtime)

    def get_supabase_project_api_keys_with_options(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectApiKeysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetSupabaseProjectApiKeysResponse:
        """
        @summary 查询Supabase实例 API Keys
        
        @param request: GetSupabaseProjectApiKeysRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSupabaseProjectApiKeysResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSupabaseProjectApiKeys',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetSupabaseProjectApiKeysResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_supabase_project_api_keys_with_options_async(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectApiKeysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetSupabaseProjectApiKeysResponse:
        """
        @summary 查询Supabase实例 API Keys
        
        @param request: GetSupabaseProjectApiKeysRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSupabaseProjectApiKeysResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSupabaseProjectApiKeys',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetSupabaseProjectApiKeysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_supabase_project_api_keys(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectApiKeysRequest,
    ) -> gpdb_20160503_models.GetSupabaseProjectApiKeysResponse:
        """
        @summary 查询Supabase实例 API Keys
        
        @param request: GetSupabaseProjectApiKeysRequest
        @return: GetSupabaseProjectApiKeysResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_supabase_project_api_keys_with_options(request, runtime)

    async def get_supabase_project_api_keys_async(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectApiKeysRequest,
    ) -> gpdb_20160503_models.GetSupabaseProjectApiKeysResponse:
        """
        @summary 查询Supabase实例 API Keys
        
        @param request: GetSupabaseProjectApiKeysRequest
        @return: GetSupabaseProjectApiKeysResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_supabase_project_api_keys_with_options_async(request, runtime)

    def get_supabase_project_dashboard_account_with_options(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectDashboardAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetSupabaseProjectDashboardAccountResponse:
        """
        @summary 查询Supabase项目dashboard账号信息
        
        @param request: GetSupabaseProjectDashboardAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSupabaseProjectDashboardAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSupabaseProjectDashboardAccount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetSupabaseProjectDashboardAccountResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_supabase_project_dashboard_account_with_options_async(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectDashboardAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetSupabaseProjectDashboardAccountResponse:
        """
        @summary 查询Supabase项目dashboard账号信息
        
        @param request: GetSupabaseProjectDashboardAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSupabaseProjectDashboardAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSupabaseProjectDashboardAccount',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetSupabaseProjectDashboardAccountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_supabase_project_dashboard_account(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectDashboardAccountRequest,
    ) -> gpdb_20160503_models.GetSupabaseProjectDashboardAccountResponse:
        """
        @summary 查询Supabase项目dashboard账号信息
        
        @param request: GetSupabaseProjectDashboardAccountRequest
        @return: GetSupabaseProjectDashboardAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_supabase_project_dashboard_account_with_options(request, runtime)

    async def get_supabase_project_dashboard_account_async(
        self,
        request: gpdb_20160503_models.GetSupabaseProjectDashboardAccountRequest,
    ) -> gpdb_20160503_models.GetSupabaseProjectDashboardAccountResponse:
        """
        @summary 查询Supabase项目dashboard账号信息
        
        @param request: GetSupabaseProjectDashboardAccountRequest
        @return: GetSupabaseProjectDashboardAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_supabase_project_dashboard_account_with_options_async(request, runtime)

    def get_upload_document_job_with_options(
        self,
        request: gpdb_20160503_models.GetUploadDocumentJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetUploadDocumentJobResponse:
        """
        @summary Queries the progress and result of an asynchronous document upload job based on the job ID.
        
        @description This operation is related to the UploadDocumentAsync operation. You can call the UploadDocumentAsync operation to create an upload job and obtain the job ID, and then call the GetUploadDocumentJob operation to query the execution information of the job.
        >  Suggestions:
        Determine whether the document upload job times out based on the document complexity and the number of tokens after chunking. In most cases, a job that lasts more than 2 hours is considered timeout.
        
        @param request: GetUploadDocumentJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetUploadDocumentJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        body = {}
        if not UtilClient.is_unset(request.collection):
            body['Collection'] = request.collection
        if not UtilClient.is_unset(request.job_id):
            body['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            body['NamespacePassword'] = request.namespace_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetUploadDocumentJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetUploadDocumentJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_upload_document_job_with_options_async(
        self,
        request: gpdb_20160503_models.GetUploadDocumentJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetUploadDocumentJobResponse:
        """
        @summary Queries the progress and result of an asynchronous document upload job based on the job ID.
        
        @description This operation is related to the UploadDocumentAsync operation. You can call the UploadDocumentAsync operation to create an upload job and obtain the job ID, and then call the GetUploadDocumentJob operation to query the execution information of the job.
        >  Suggestions:
        Determine whether the document upload job times out based on the document complexity and the number of tokens after chunking. In most cases, a job that lasts more than 2 hours is considered timeout.
        
        @param request: GetUploadDocumentJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetUploadDocumentJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        body = {}
        if not UtilClient.is_unset(request.collection):
            body['Collection'] = request.collection
        if not UtilClient.is_unset(request.job_id):
            body['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            body['NamespacePassword'] = request.namespace_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetUploadDocumentJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetUploadDocumentJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_upload_document_job(
        self,
        request: gpdb_20160503_models.GetUploadDocumentJobRequest,
    ) -> gpdb_20160503_models.GetUploadDocumentJobResponse:
        """
        @summary Queries the progress and result of an asynchronous document upload job based on the job ID.
        
        @description This operation is related to the UploadDocumentAsync operation. You can call the UploadDocumentAsync operation to create an upload job and obtain the job ID, and then call the GetUploadDocumentJob operation to query the execution information of the job.
        >  Suggestions:
        Determine whether the document upload job times out based on the document complexity and the number of tokens after chunking. In most cases, a job that lasts more than 2 hours is considered timeout.
        
        @param request: GetUploadDocumentJobRequest
        @return: GetUploadDocumentJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_upload_document_job_with_options(request, runtime)

    async def get_upload_document_job_async(
        self,
        request: gpdb_20160503_models.GetUploadDocumentJobRequest,
    ) -> gpdb_20160503_models.GetUploadDocumentJobResponse:
        """
        @summary Queries the progress and result of an asynchronous document upload job based on the job ID.
        
        @description This operation is related to the UploadDocumentAsync operation. You can call the UploadDocumentAsync operation to create an upload job and obtain the job ID, and then call the GetUploadDocumentJob operation to query the execution information of the job.
        >  Suggestions:
        Determine whether the document upload job times out based on the document complexity and the number of tokens after chunking. In most cases, a job that lasts more than 2 hours is considered timeout.
        
        @param request: GetUploadDocumentJobRequest
        @return: GetUploadDocumentJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_upload_document_job_with_options_async(request, runtime)

    def get_upsert_collection_data_job_with_options(
        self,
        request: gpdb_20160503_models.GetUpsertCollectionDataJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetUpsertCollectionDataJobResponse:
        """
        @summary Queries the progress and result of an asynchronous vector data upload job by using a job ID.
        
        @description This operation is related to the `UpsertCollectionDataAsync` operation. You can call the `UpsertCollectionDataAsync` operation to create an upload job and obtain a job ID, and then call the GetUpsertCollectionDataJob operation to query the execution information of the job.
        >  We recommend that you evaluate the amount of time required for the upload job based on 1,000 data entries every second, and then query the job progress every 5 seconds. The timeout period can be set to 30 minutes after the evaluated amount of time.
        
        @param request: GetUpsertCollectionDataJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetUpsertCollectionDataJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        body = {}
        if not UtilClient.is_unset(request.collection):
            body['Collection'] = request.collection
        if not UtilClient.is_unset(request.job_id):
            body['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            body['NamespacePassword'] = request.namespace_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetUpsertCollectionDataJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetUpsertCollectionDataJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_upsert_collection_data_job_with_options_async(
        self,
        request: gpdb_20160503_models.GetUpsertCollectionDataJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GetUpsertCollectionDataJobResponse:
        """
        @summary Queries the progress and result of an asynchronous vector data upload job by using a job ID.
        
        @description This operation is related to the `UpsertCollectionDataAsync` operation. You can call the `UpsertCollectionDataAsync` operation to create an upload job and obtain a job ID, and then call the GetUpsertCollectionDataJob operation to query the execution information of the job.
        >  We recommend that you evaluate the amount of time required for the upload job based on 1,000 data entries every second, and then query the job progress every 5 seconds. The timeout period can be set to 30 minutes after the evaluated amount of time.
        
        @param request: GetUpsertCollectionDataJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetUpsertCollectionDataJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        body = {}
        if not UtilClient.is_unset(request.collection):
            body['Collection'] = request.collection
        if not UtilClient.is_unset(request.job_id):
            body['JobId'] = request.job_id
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            body['NamespacePassword'] = request.namespace_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetUpsertCollectionDataJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GetUpsertCollectionDataJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_upsert_collection_data_job(
        self,
        request: gpdb_20160503_models.GetUpsertCollectionDataJobRequest,
    ) -> gpdb_20160503_models.GetUpsertCollectionDataJobResponse:
        """
        @summary Queries the progress and result of an asynchronous vector data upload job by using a job ID.
        
        @description This operation is related to the `UpsertCollectionDataAsync` operation. You can call the `UpsertCollectionDataAsync` operation to create an upload job and obtain a job ID, and then call the GetUpsertCollectionDataJob operation to query the execution information of the job.
        >  We recommend that you evaluate the amount of time required for the upload job based on 1,000 data entries every second, and then query the job progress every 5 seconds. The timeout period can be set to 30 minutes after the evaluated amount of time.
        
        @param request: GetUpsertCollectionDataJobRequest
        @return: GetUpsertCollectionDataJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_upsert_collection_data_job_with_options(request, runtime)

    async def get_upsert_collection_data_job_async(
        self,
        request: gpdb_20160503_models.GetUpsertCollectionDataJobRequest,
    ) -> gpdb_20160503_models.GetUpsertCollectionDataJobResponse:
        """
        @summary Queries the progress and result of an asynchronous vector data upload job by using a job ID.
        
        @description This operation is related to the `UpsertCollectionDataAsync` operation. You can call the `UpsertCollectionDataAsync` operation to create an upload job and obtain a job ID, and then call the GetUpsertCollectionDataJob operation to query the execution information of the job.
        >  We recommend that you evaluate the amount of time required for the upload job based on 1,000 data entries every second, and then query the job progress every 5 seconds. The timeout period can be set to 30 minutes after the evaluated amount of time.
        
        @param request: GetUpsertCollectionDataJobRequest
        @return: GetUpsertCollectionDataJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_upsert_collection_data_job_with_options_async(request, runtime)

    def grant_collection_with_options(
        self,
        request: gpdb_20160503_models.GrantCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GrantCollectionResponse:
        """
        @summary Grants vector collection permissions to a namespace.
        
        @param request: GrantCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GrantCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.grant_to_namespace):
            query['GrantToNamespace'] = request.grant_to_namespace
        if not UtilClient.is_unset(request.grant_type):
            query['GrantType'] = request.grant_type
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GrantCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GrantCollectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def grant_collection_with_options_async(
        self,
        request: gpdb_20160503_models.GrantCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.GrantCollectionResponse:
        """
        @summary Grants vector collection permissions to a namespace.
        
        @param request: GrantCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GrantCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.grant_to_namespace):
            query['GrantToNamespace'] = request.grant_to_namespace
        if not UtilClient.is_unset(request.grant_type):
            query['GrantType'] = request.grant_type
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GrantCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.GrantCollectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def grant_collection(
        self,
        request: gpdb_20160503_models.GrantCollectionRequest,
    ) -> gpdb_20160503_models.GrantCollectionResponse:
        """
        @summary Grants vector collection permissions to a namespace.
        
        @param request: GrantCollectionRequest
        @return: GrantCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.grant_collection_with_options(request, runtime)

    async def grant_collection_async(
        self,
        request: gpdb_20160503_models.GrantCollectionRequest,
    ) -> gpdb_20160503_models.GrantCollectionResponse:
        """
        @summary Grants vector collection permissions to a namespace.
        
        @param request: GrantCollectionRequest
        @return: GrantCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.grant_collection_with_options_async(request, runtime)

    def handle_active_sqlrecord_with_options(
        self,
        request: gpdb_20160503_models.HandleActiveSQLRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.HandleActiveSQLRecordResponse:
        """
        @summary Processes active queries.
        
        @param request: HandleActiveSQLRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: HandleActiveSQLRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.operate_type):
            query['OperateType'] = request.operate_type
        if not UtilClient.is_unset(request.pids):
            query['Pids'] = request.pids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='HandleActiveSQLRecord',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.HandleActiveSQLRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def handle_active_sqlrecord_with_options_async(
        self,
        request: gpdb_20160503_models.HandleActiveSQLRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.HandleActiveSQLRecordResponse:
        """
        @summary Processes active queries.
        
        @param request: HandleActiveSQLRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: HandleActiveSQLRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.operate_type):
            query['OperateType'] = request.operate_type
        if not UtilClient.is_unset(request.pids):
            query['Pids'] = request.pids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='HandleActiveSQLRecord',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.HandleActiveSQLRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def handle_active_sqlrecord(
        self,
        request: gpdb_20160503_models.HandleActiveSQLRecordRequest,
    ) -> gpdb_20160503_models.HandleActiveSQLRecordResponse:
        """
        @summary Processes active queries.
        
        @param request: HandleActiveSQLRecordRequest
        @return: HandleActiveSQLRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.handle_active_sqlrecord_with_options(request, runtime)

    async def handle_active_sqlrecord_async(
        self,
        request: gpdb_20160503_models.HandleActiveSQLRecordRequest,
    ) -> gpdb_20160503_models.HandleActiveSQLRecordResponse:
        """
        @summary Processes active queries.
        
        @param request: HandleActiveSQLRecordRequest
        @return: HandleActiveSQLRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.handle_active_sqlrecord_with_options_async(request, runtime)

    def init_vector_database_with_options(
        self,
        request: gpdb_20160503_models.InitVectorDatabaseRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.InitVectorDatabaseResponse:
        """
        @summary Initializes vector databases.
        
        @param request: InitVectorDatabaseRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: InitVectorDatabaseResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='InitVectorDatabase',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.InitVectorDatabaseResponse(),
            self.call_api(params, req, runtime)
        )

    async def init_vector_database_with_options_async(
        self,
        request: gpdb_20160503_models.InitVectorDatabaseRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.InitVectorDatabaseResponse:
        """
        @summary Initializes vector databases.
        
        @param request: InitVectorDatabaseRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: InitVectorDatabaseResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='InitVectorDatabase',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.InitVectorDatabaseResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def init_vector_database(
        self,
        request: gpdb_20160503_models.InitVectorDatabaseRequest,
    ) -> gpdb_20160503_models.InitVectorDatabaseResponse:
        """
        @summary Initializes vector databases.
        
        @param request: InitVectorDatabaseRequest
        @return: InitVectorDatabaseResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.init_vector_database_with_options(request, runtime)

    async def init_vector_database_async(
        self,
        request: gpdb_20160503_models.InitVectorDatabaseRequest,
    ) -> gpdb_20160503_models.InitVectorDatabaseResponse:
        """
        @summary Initializes vector databases.
        
        @param request: InitVectorDatabaseRequest
        @return: InitVectorDatabaseResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.init_vector_database_with_options_async(request, runtime)

    def list_backup_jobs_with_options(
        self,
        request: gpdb_20160503_models.ListBackupJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListBackupJobsResponse:
        """
        @summary 获取备份任务列表
        
        @param request: ListBackupJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListBackupJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListBackupJobs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListBackupJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_backup_jobs_with_options_async(
        self,
        request: gpdb_20160503_models.ListBackupJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListBackupJobsResponse:
        """
        @summary 获取备份任务列表
        
        @param request: ListBackupJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListBackupJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_mode):
            query['BackupMode'] = request.backup_mode
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListBackupJobs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListBackupJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_backup_jobs(
        self,
        request: gpdb_20160503_models.ListBackupJobsRequest,
    ) -> gpdb_20160503_models.ListBackupJobsResponse:
        """
        @summary 获取备份任务列表
        
        @param request: ListBackupJobsRequest
        @return: ListBackupJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_backup_jobs_with_options(request, runtime)

    async def list_backup_jobs_async(
        self,
        request: gpdb_20160503_models.ListBackupJobsRequest,
    ) -> gpdb_20160503_models.ListBackupJobsResponse:
        """
        @summary 获取备份任务列表
        
        @param request: ListBackupJobsRequest
        @return: ListBackupJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_backup_jobs_with_options_async(request, runtime)

    def list_collections_with_options(
        self,
        request: gpdb_20160503_models.ListCollectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListCollectionsResponse:
        """
        @summary Queries a list of vector collections.
        
        @param request: ListCollectionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCollectionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCollections',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListCollectionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_collections_with_options_async(
        self,
        request: gpdb_20160503_models.ListCollectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListCollectionsResponse:
        """
        @summary Queries a list of vector collections.
        
        @param request: ListCollectionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCollectionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCollections',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListCollectionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_collections(
        self,
        request: gpdb_20160503_models.ListCollectionsRequest,
    ) -> gpdb_20160503_models.ListCollectionsResponse:
        """
        @summary Queries a list of vector collections.
        
        @param request: ListCollectionsRequest
        @return: ListCollectionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_collections_with_options(request, runtime)

    async def list_collections_async(
        self,
        request: gpdb_20160503_models.ListCollectionsRequest,
    ) -> gpdb_20160503_models.ListCollectionsResponse:
        """
        @summary Queries a list of vector collections.
        
        @param request: ListCollectionsRequest
        @return: ListCollectionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_collections_with_options_async(request, runtime)

    def list_databases_with_options(
        self,
        request: gpdb_20160503_models.ListDatabasesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListDatabasesResponse:
        """
        @summary Queries a list of databases.
        
        @param request: ListDatabasesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDatabasesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDatabases',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListDatabasesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_databases_with_options_async(
        self,
        request: gpdb_20160503_models.ListDatabasesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListDatabasesResponse:
        """
        @summary Queries a list of databases.
        
        @param request: ListDatabasesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDatabasesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDatabases',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListDatabasesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_databases(
        self,
        request: gpdb_20160503_models.ListDatabasesRequest,
    ) -> gpdb_20160503_models.ListDatabasesResponse:
        """
        @summary Queries a list of databases.
        
        @param request: ListDatabasesRequest
        @return: ListDatabasesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_databases_with_options(request, runtime)

    async def list_databases_async(
        self,
        request: gpdb_20160503_models.ListDatabasesRequest,
    ) -> gpdb_20160503_models.ListDatabasesResponse:
        """
        @summary Queries a list of databases.
        
        @param request: ListDatabasesRequest
        @return: ListDatabasesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_databases_with_options_async(request, runtime)

    def list_document_collections_with_options(
        self,
        request: gpdb_20160503_models.ListDocumentCollectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListDocumentCollectionsResponse:
        """
        @summary Queries a list of document collections.
        
        @param request: ListDocumentCollectionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDocumentCollectionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDocumentCollections',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListDocumentCollectionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_document_collections_with_options_async(
        self,
        request: gpdb_20160503_models.ListDocumentCollectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListDocumentCollectionsResponse:
        """
        @summary Queries a list of document collections.
        
        @param request: ListDocumentCollectionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDocumentCollectionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDocumentCollections',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListDocumentCollectionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_document_collections(
        self,
        request: gpdb_20160503_models.ListDocumentCollectionsRequest,
    ) -> gpdb_20160503_models.ListDocumentCollectionsResponse:
        """
        @summary Queries a list of document collections.
        
        @param request: ListDocumentCollectionsRequest
        @return: ListDocumentCollectionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_document_collections_with_options(request, runtime)

    async def list_document_collections_async(
        self,
        request: gpdb_20160503_models.ListDocumentCollectionsRequest,
    ) -> gpdb_20160503_models.ListDocumentCollectionsResponse:
        """
        @summary Queries a list of document collections.
        
        @param request: ListDocumentCollectionsRequest
        @return: ListDocumentCollectionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_document_collections_with_options_async(request, runtime)

    def list_documents_with_options(
        self,
        request: gpdb_20160503_models.ListDocumentsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListDocumentsResponse:
        """
        @summary Queries a list of documents in a collection.
        
        @param request: ListDocumentsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDocumentsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDocuments',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListDocumentsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_documents_with_options_async(
        self,
        request: gpdb_20160503_models.ListDocumentsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListDocumentsResponse:
        """
        @summary Queries a list of documents in a collection.
        
        @param request: ListDocumentsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDocumentsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDocuments',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListDocumentsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_documents(
        self,
        request: gpdb_20160503_models.ListDocumentsRequest,
    ) -> gpdb_20160503_models.ListDocumentsResponse:
        """
        @summary Queries a list of documents in a collection.
        
        @param request: ListDocumentsRequest
        @return: ListDocumentsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_documents_with_options(request, runtime)

    async def list_documents_async(
        self,
        request: gpdb_20160503_models.ListDocumentsRequest,
    ) -> gpdb_20160503_models.ListDocumentsResponse:
        """
        @summary Queries a list of documents in a collection.
        
        @param request: ListDocumentsRequest
        @return: ListDocumentsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_documents_with_options_async(request, runtime)

    def list_external_data_services_with_options(
        self,
        request: gpdb_20160503_models.ListExternalDataServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListExternalDataServicesResponse:
        """
        @summary Queries a list of external data services.
        
        @param request: ListExternalDataServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListExternalDataServicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListExternalDataServices',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListExternalDataServicesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_external_data_services_with_options_async(
        self,
        request: gpdb_20160503_models.ListExternalDataServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListExternalDataServicesResponse:
        """
        @summary Queries a list of external data services.
        
        @param request: ListExternalDataServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListExternalDataServicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListExternalDataServices',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListExternalDataServicesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_external_data_services(
        self,
        request: gpdb_20160503_models.ListExternalDataServicesRequest,
    ) -> gpdb_20160503_models.ListExternalDataServicesResponse:
        """
        @summary Queries a list of external data services.
        
        @param request: ListExternalDataServicesRequest
        @return: ListExternalDataServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_external_data_services_with_options(request, runtime)

    async def list_external_data_services_async(
        self,
        request: gpdb_20160503_models.ListExternalDataServicesRequest,
    ) -> gpdb_20160503_models.ListExternalDataServicesResponse:
        """
        @summary Queries a list of external data services.
        
        @param request: ListExternalDataServicesRequest
        @return: ListExternalDataServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_external_data_services_with_options_async(request, runtime)

    def list_external_data_sources_with_options(
        self,
        request: gpdb_20160503_models.ListExternalDataSourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListExternalDataSourcesResponse:
        """
        @summary 获取实例外表配置列表
        
        @param request: ListExternalDataSourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListExternalDataSourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListExternalDataSources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListExternalDataSourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_external_data_sources_with_options_async(
        self,
        request: gpdb_20160503_models.ListExternalDataSourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListExternalDataSourcesResponse:
        """
        @summary 获取实例外表配置列表
        
        @param request: ListExternalDataSourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListExternalDataSourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListExternalDataSources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListExternalDataSourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_external_data_sources(
        self,
        request: gpdb_20160503_models.ListExternalDataSourcesRequest,
    ) -> gpdb_20160503_models.ListExternalDataSourcesResponse:
        """
        @summary 获取实例外表配置列表
        
        @param request: ListExternalDataSourcesRequest
        @return: ListExternalDataSourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_external_data_sources_with_options(request, runtime)

    async def list_external_data_sources_async(
        self,
        request: gpdb_20160503_models.ListExternalDataSourcesRequest,
    ) -> gpdb_20160503_models.ListExternalDataSourcesResponse:
        """
        @summary 获取实例外表配置列表
        
        @param request: ListExternalDataSourcesRequest
        @return: ListExternalDataSourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_external_data_sources_with_options_async(request, runtime)

    def list_indices_with_options(
        self,
        request: gpdb_20160503_models.ListIndicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListIndicesResponse:
        """
        @summary 获取索引列表
        
        @param request: ListIndicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListIndicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListIndices',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListIndicesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_indices_with_options_async(
        self,
        request: gpdb_20160503_models.ListIndicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListIndicesResponse:
        """
        @summary 获取索引列表
        
        @param request: ListIndicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListIndicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListIndices',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListIndicesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_indices(
        self,
        request: gpdb_20160503_models.ListIndicesRequest,
    ) -> gpdb_20160503_models.ListIndicesResponse:
        """
        @summary 获取索引列表
        
        @param request: ListIndicesRequest
        @return: ListIndicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_indices_with_options(request, runtime)

    async def list_indices_async(
        self,
        request: gpdb_20160503_models.ListIndicesRequest,
    ) -> gpdb_20160503_models.ListIndicesResponse:
        """
        @summary 获取索引列表
        
        @param request: ListIndicesRequest
        @return: ListIndicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_indices_with_options_async(request, runtime)

    def list_instance_extensions_with_options(
        self,
        request: gpdb_20160503_models.ListInstanceExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListInstanceExtensionsResponse:
        """
        @summary Queries a list of extensions.
        
        @param request: ListInstanceExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListInstanceExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.extension):
            query['Extension'] = request.extension
        if not UtilClient.is_unset(request.install_status):
            query['InstallStatus'] = request.install_status
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListInstanceExtensions',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListInstanceExtensionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_instance_extensions_with_options_async(
        self,
        request: gpdb_20160503_models.ListInstanceExtensionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListInstanceExtensionsResponse:
        """
        @summary Queries a list of extensions.
        
        @param request: ListInstanceExtensionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListInstanceExtensionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.extension):
            query['Extension'] = request.extension
        if not UtilClient.is_unset(request.install_status):
            query['InstallStatus'] = request.install_status
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListInstanceExtensions',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListInstanceExtensionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_instance_extensions(
        self,
        request: gpdb_20160503_models.ListInstanceExtensionsRequest,
    ) -> gpdb_20160503_models.ListInstanceExtensionsResponse:
        """
        @summary Queries a list of extensions.
        
        @param request: ListInstanceExtensionsRequest
        @return: ListInstanceExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_instance_extensions_with_options(request, runtime)

    async def list_instance_extensions_async(
        self,
        request: gpdb_20160503_models.ListInstanceExtensionsRequest,
    ) -> gpdb_20160503_models.ListInstanceExtensionsResponse:
        """
        @summary Queries a list of extensions.
        
        @param request: ListInstanceExtensionsRequest
        @return: ListInstanceExtensionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_instance_extensions_with_options_async(request, runtime)

    def list_namespaces_with_options(
        self,
        request: gpdb_20160503_models.ListNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListNamespacesResponse:
        """
        @summary Queries a list of namespaces.
        
        @param request: ListNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNamespacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNamespaces',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListNamespacesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_namespaces_with_options_async(
        self,
        request: gpdb_20160503_models.ListNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListNamespacesResponse:
        """
        @summary Queries a list of namespaces.
        
        @param request: ListNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNamespacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.manager_account):
            query['ManagerAccount'] = request.manager_account
        if not UtilClient.is_unset(request.manager_account_password):
            query['ManagerAccountPassword'] = request.manager_account_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNamespaces',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListNamespacesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_namespaces(
        self,
        request: gpdb_20160503_models.ListNamespacesRequest,
    ) -> gpdb_20160503_models.ListNamespacesResponse:
        """
        @summary Queries a list of namespaces.
        
        @param request: ListNamespacesRequest
        @return: ListNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_namespaces_with_options(request, runtime)

    async def list_namespaces_async(
        self,
        request: gpdb_20160503_models.ListNamespacesRequest,
    ) -> gpdb_20160503_models.ListNamespacesResponse:
        """
        @summary Queries a list of namespaces.
        
        @param request: ListNamespacesRequest
        @return: ListNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_namespaces_with_options_async(request, runtime)

    def list_remote_adbdata_sources_with_options(
        self,
        request: gpdb_20160503_models.ListRemoteADBDataSourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListRemoteADBDataSourcesResponse:
        """
        @summary Get Homogeneous Data Source
        
        @param request: ListRemoteADBDataSourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRemoteADBDataSourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRemoteADBDataSources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListRemoteADBDataSourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_remote_adbdata_sources_with_options_async(
        self,
        request: gpdb_20160503_models.ListRemoteADBDataSourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListRemoteADBDataSourcesResponse:
        """
        @summary Get Homogeneous Data Source
        
        @param request: ListRemoteADBDataSourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRemoteADBDataSourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRemoteADBDataSources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListRemoteADBDataSourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_remote_adbdata_sources(
        self,
        request: gpdb_20160503_models.ListRemoteADBDataSourcesRequest,
    ) -> gpdb_20160503_models.ListRemoteADBDataSourcesResponse:
        """
        @summary Get Homogeneous Data Source
        
        @param request: ListRemoteADBDataSourcesRequest
        @return: ListRemoteADBDataSourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_remote_adbdata_sources_with_options(request, runtime)

    async def list_remote_adbdata_sources_async(
        self,
        request: gpdb_20160503_models.ListRemoteADBDataSourcesRequest,
    ) -> gpdb_20160503_models.ListRemoteADBDataSourcesResponse:
        """
        @summary Get Homogeneous Data Source
        
        @param request: ListRemoteADBDataSourcesRequest
        @return: ListRemoteADBDataSourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_remote_adbdata_sources_with_options_async(request, runtime)

    def list_schemas_with_options(
        self,
        request: gpdb_20160503_models.ListSchemasRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListSchemasResponse:
        """
        @summary Queries a list of schemas.
        
        @param request: ListSchemasRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSchemasResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.schema_pattern):
            query['SchemaPattern'] = request.schema_pattern
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSchemas',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListSchemasResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_schemas_with_options_async(
        self,
        request: gpdb_20160503_models.ListSchemasRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListSchemasResponse:
        """
        @summary Queries a list of schemas.
        
        @param request: ListSchemasRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSchemasResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.schema_pattern):
            query['SchemaPattern'] = request.schema_pattern
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSchemas',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListSchemasResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_schemas(
        self,
        request: gpdb_20160503_models.ListSchemasRequest,
    ) -> gpdb_20160503_models.ListSchemasResponse:
        """
        @summary Queries a list of schemas.
        
        @param request: ListSchemasRequest
        @return: ListSchemasResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_schemas_with_options(request, runtime)

    async def list_schemas_async(
        self,
        request: gpdb_20160503_models.ListSchemasRequest,
    ) -> gpdb_20160503_models.ListSchemasResponse:
        """
        @summary Queries a list of schemas.
        
        @param request: ListSchemasRequest
        @return: ListSchemasResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_schemas_with_options_async(request, runtime)

    def list_secrets_with_options(
        self,
        request: gpdb_20160503_models.ListSecretsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListSecretsResponse:
        """
        @summary Queries a list of access credentials.
        
        @param request: ListSecretsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSecretsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSecrets',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListSecretsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_secrets_with_options_async(
        self,
        request: gpdb_20160503_models.ListSecretsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListSecretsResponse:
        """
        @summary Queries a list of access credentials.
        
        @param request: ListSecretsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSecretsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSecrets',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListSecretsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_secrets(
        self,
        request: gpdb_20160503_models.ListSecretsRequest,
    ) -> gpdb_20160503_models.ListSecretsResponse:
        """
        @summary Queries a list of access credentials.
        
        @param request: ListSecretsRequest
        @return: ListSecretsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_secrets_with_options(request, runtime)

    async def list_secrets_async(
        self,
        request: gpdb_20160503_models.ListSecretsRequest,
    ) -> gpdb_20160503_models.ListSecretsResponse:
        """
        @summary Queries a list of access credentials.
        
        @param request: ListSecretsRequest
        @return: ListSecretsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_secrets_with_options_async(request, runtime)

    def list_streaming_data_services_with_options(
        self,
        request: gpdb_20160503_models.ListStreamingDataServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListStreamingDataServicesResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: ListStreamingDataServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListStreamingDataServicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListStreamingDataServices',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListStreamingDataServicesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_streaming_data_services_with_options_async(
        self,
        request: gpdb_20160503_models.ListStreamingDataServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListStreamingDataServicesResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: ListStreamingDataServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListStreamingDataServicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListStreamingDataServices',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListStreamingDataServicesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_streaming_data_services(
        self,
        request: gpdb_20160503_models.ListStreamingDataServicesRequest,
    ) -> gpdb_20160503_models.ListStreamingDataServicesResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: ListStreamingDataServicesRequest
        @return: ListStreamingDataServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_streaming_data_services_with_options(request, runtime)

    async def list_streaming_data_services_async(
        self,
        request: gpdb_20160503_models.ListStreamingDataServicesRequest,
    ) -> gpdb_20160503_models.ListStreamingDataServicesResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: ListStreamingDataServicesRequest
        @return: ListStreamingDataServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_streaming_data_services_with_options_async(request, runtime)

    def list_streaming_data_sources_with_options(
        self,
        request: gpdb_20160503_models.ListStreamingDataSourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListStreamingDataSourcesResponse:
        """
        @summary Queries real-time service data sources.
        
        @param request: ListStreamingDataSourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListStreamingDataSourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListStreamingDataSources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListStreamingDataSourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_streaming_data_sources_with_options_async(
        self,
        request: gpdb_20160503_models.ListStreamingDataSourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListStreamingDataSourcesResponse:
        """
        @summary Queries real-time service data sources.
        
        @param request: ListStreamingDataSourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListStreamingDataSourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListStreamingDataSources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListStreamingDataSourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_streaming_data_sources(
        self,
        request: gpdb_20160503_models.ListStreamingDataSourcesRequest,
    ) -> gpdb_20160503_models.ListStreamingDataSourcesResponse:
        """
        @summary Queries real-time service data sources.
        
        @param request: ListStreamingDataSourcesRequest
        @return: ListStreamingDataSourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_streaming_data_sources_with_options(request, runtime)

    async def list_streaming_data_sources_async(
        self,
        request: gpdb_20160503_models.ListStreamingDataSourcesRequest,
    ) -> gpdb_20160503_models.ListStreamingDataSourcesResponse:
        """
        @summary Queries real-time service data sources.
        
        @param request: ListStreamingDataSourcesRequest
        @return: ListStreamingDataSourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_streaming_data_sources_with_options_async(request, runtime)

    def list_streaming_jobs_with_options(
        self,
        request: gpdb_20160503_models.ListStreamingJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListStreamingJobsResponse:
        """
        @summary Queries real-time data synchronization jobs.
        
        @param request: ListStreamingJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListStreamingJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListStreamingJobs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListStreamingJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_streaming_jobs_with_options_async(
        self,
        request: gpdb_20160503_models.ListStreamingJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListStreamingJobsResponse:
        """
        @summary Queries real-time data synchronization jobs.
        
        @param request: ListStreamingJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListStreamingJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListStreamingJobs',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListStreamingJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_streaming_jobs(
        self,
        request: gpdb_20160503_models.ListStreamingJobsRequest,
    ) -> gpdb_20160503_models.ListStreamingJobsResponse:
        """
        @summary Queries real-time data synchronization jobs.
        
        @param request: ListStreamingJobsRequest
        @return: ListStreamingJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_streaming_jobs_with_options(request, runtime)

    async def list_streaming_jobs_async(
        self,
        request: gpdb_20160503_models.ListStreamingJobsRequest,
    ) -> gpdb_20160503_models.ListStreamingJobsResponse:
        """
        @summary Queries real-time data synchronization jobs.
        
        @param request: ListStreamingJobsRequest
        @return: ListStreamingJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_streaming_jobs_with_options_async(request, runtime)

    def list_supabase_projects_with_options(
        self,
        request: gpdb_20160503_models.ListSupabaseProjectsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListSupabaseProjectsResponse:
        """
        @summary 查询Supabase实例列表
        
        @param request: ListSupabaseProjectsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSupabaseProjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSupabaseProjects',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListSupabaseProjectsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_supabase_projects_with_options_async(
        self,
        request: gpdb_20160503_models.ListSupabaseProjectsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListSupabaseProjectsResponse:
        """
        @summary 查询Supabase实例列表
        
        @param request: ListSupabaseProjectsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSupabaseProjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSupabaseProjects',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListSupabaseProjectsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_supabase_projects(
        self,
        request: gpdb_20160503_models.ListSupabaseProjectsRequest,
    ) -> gpdb_20160503_models.ListSupabaseProjectsResponse:
        """
        @summary 查询Supabase实例列表
        
        @param request: ListSupabaseProjectsRequest
        @return: ListSupabaseProjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_supabase_projects_with_options(request, runtime)

    async def list_supabase_projects_async(
        self,
        request: gpdb_20160503_models.ListSupabaseProjectsRequest,
    ) -> gpdb_20160503_models.ListSupabaseProjectsResponse:
        """
        @summary 查询Supabase实例列表
        
        @param request: ListSupabaseProjectsRequest
        @return: ListSupabaseProjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_supabase_projects_with_options_async(request, runtime)

    def list_tables_with_options(
        self,
        request: gpdb_20160503_models.ListTablesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListTablesResponse:
        """
        @summary Queries a list of tables in a database.
        
        @param request: ListTablesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTablesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.schema):
            query['Schema'] = request.schema
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.table_pattern):
            query['TablePattern'] = request.table_pattern
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTables',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListTablesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_tables_with_options_async(
        self,
        request: gpdb_20160503_models.ListTablesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListTablesResponse:
        """
        @summary Queries a list of tables in a database.
        
        @param request: ListTablesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTablesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.schema):
            query['Schema'] = request.schema
        if not UtilClient.is_unset(request.secret_arn):
            query['SecretArn'] = request.secret_arn
        if not UtilClient.is_unset(request.table_pattern):
            query['TablePattern'] = request.table_pattern
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTables',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListTablesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_tables(
        self,
        request: gpdb_20160503_models.ListTablesRequest,
    ) -> gpdb_20160503_models.ListTablesResponse:
        """
        @summary Queries a list of tables in a database.
        
        @param request: ListTablesRequest
        @return: ListTablesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_tables_with_options(request, runtime)

    async def list_tables_async(
        self,
        request: gpdb_20160503_models.ListTablesRequest,
    ) -> gpdb_20160503_models.ListTablesResponse:
        """
        @summary Queries a list of tables in a database.
        
        @param request: ListTablesRequest
        @return: ListTablesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_tables_with_options_async(request, runtime)

    def list_tag_resources_with_options(
        self,
        request: gpdb_20160503_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListTagResourcesResponse:
        """
        @summary Queries a list of tags that are added to AnalyticDB for PostgreSQL instances.
        
        @param request: ListTagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListTagResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_tag_resources_with_options_async(
        self,
        request: gpdb_20160503_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ListTagResourcesResponse:
        """
        @summary Queries a list of tags that are added to AnalyticDB for PostgreSQL instances.
        
        @param request: ListTagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ListTagResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_tag_resources(
        self,
        request: gpdb_20160503_models.ListTagResourcesRequest,
    ) -> gpdb_20160503_models.ListTagResourcesResponse:
        """
        @summary Queries a list of tags that are added to AnalyticDB for PostgreSQL instances.
        
        @param request: ListTagResourcesRequest
        @return: ListTagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_tag_resources_with_options(request, runtime)

    async def list_tag_resources_async(
        self,
        request: gpdb_20160503_models.ListTagResourcesRequest,
    ) -> gpdb_20160503_models.ListTagResourcesResponse:
        """
        @summary Queries a list of tags that are added to AnalyticDB for PostgreSQL instances.
        
        @param request: ListTagResourcesRequest
        @return: ListTagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_tag_resources_with_options_async(request, runtime)

    def modify_account_description_with_options(
        self,
        request: gpdb_20160503_models.ModifyAccountDescriptionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyAccountDescriptionResponse:
        """
        @summary Modifies the description of a database account for an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyAccountDescriptionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyAccountDescriptionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_description):
            query['AccountDescription'] = request.account_description
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyAccountDescription',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyAccountDescriptionResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_account_description_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyAccountDescriptionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyAccountDescriptionResponse:
        """
        @summary Modifies the description of a database account for an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyAccountDescriptionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyAccountDescriptionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_description):
            query['AccountDescription'] = request.account_description
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyAccountDescription',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyAccountDescriptionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_account_description(
        self,
        request: gpdb_20160503_models.ModifyAccountDescriptionRequest,
    ) -> gpdb_20160503_models.ModifyAccountDescriptionResponse:
        """
        @summary Modifies the description of a database account for an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyAccountDescriptionRequest
        @return: ModifyAccountDescriptionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_account_description_with_options(request, runtime)

    async def modify_account_description_async(
        self,
        request: gpdb_20160503_models.ModifyAccountDescriptionRequest,
    ) -> gpdb_20160503_models.ModifyAccountDescriptionResponse:
        """
        @summary Modifies the description of a database account for an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyAccountDescriptionRequest
        @return: ModifyAccountDescriptionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_account_description_with_options_async(request, runtime)

    def modify_backup_policy_with_options(
        self,
        request: gpdb_20160503_models.ModifyBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyBackupPolicyResponse:
        """
        @summary Configures the backup policy of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_retention_period):
            query['BackupRetentionPeriod'] = request.backup_retention_period
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.enable_recovery_point):
            query['EnableRecoveryPoint'] = request.enable_recovery_point
        if not UtilClient.is_unset(request.preferred_backup_period):
            query['PreferredBackupPeriod'] = request.preferred_backup_period
        if not UtilClient.is_unset(request.preferred_backup_time):
            query['PreferredBackupTime'] = request.preferred_backup_time
        if not UtilClient.is_unset(request.recovery_point_period):
            query['RecoveryPointPeriod'] = request.recovery_point_period
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyBackupPolicy',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_backup_policy_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyBackupPolicyResponse:
        """
        @summary Configures the backup policy of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_retention_period):
            query['BackupRetentionPeriod'] = request.backup_retention_period
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.enable_recovery_point):
            query['EnableRecoveryPoint'] = request.enable_recovery_point
        if not UtilClient.is_unset(request.preferred_backup_period):
            query['PreferredBackupPeriod'] = request.preferred_backup_period
        if not UtilClient.is_unset(request.preferred_backup_time):
            query['PreferredBackupTime'] = request.preferred_backup_time
        if not UtilClient.is_unset(request.recovery_point_period):
            query['RecoveryPointPeriod'] = request.recovery_point_period
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyBackupPolicy',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_backup_policy(
        self,
        request: gpdb_20160503_models.ModifyBackupPolicyRequest,
    ) -> gpdb_20160503_models.ModifyBackupPolicyResponse:
        """
        @summary Configures the backup policy of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyBackupPolicyRequest
        @return: ModifyBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_backup_policy_with_options(request, runtime)

    async def modify_backup_policy_async(
        self,
        request: gpdb_20160503_models.ModifyBackupPolicyRequest,
    ) -> gpdb_20160503_models.ModifyBackupPolicyResponse:
        """
        @summary Configures the backup policy of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyBackupPolicyRequest
        @return: ModifyBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_backup_policy_with_options_async(request, runtime)

    def modify_collection_with_options(
        self,
        request: gpdb_20160503_models.ModifyCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyCollectionResponse:
        """
        @summary 更新Collection
        
        @param request: ModifyCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.metadata):
            query['Metadata'] = request.metadata
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyCollectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_collection_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyCollectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyCollectionResponse:
        """
        @summary 更新Collection
        
        @param request: ModifyCollectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyCollectionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.metadata):
            query['Metadata'] = request.metadata
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyCollection',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyCollectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_collection(
        self,
        request: gpdb_20160503_models.ModifyCollectionRequest,
    ) -> gpdb_20160503_models.ModifyCollectionResponse:
        """
        @summary 更新Collection
        
        @param request: ModifyCollectionRequest
        @return: ModifyCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_collection_with_options(request, runtime)

    async def modify_collection_async(
        self,
        request: gpdb_20160503_models.ModifyCollectionRequest,
    ) -> gpdb_20160503_models.ModifyCollectionResponse:
        """
        @summary 更新Collection
        
        @param request: ModifyCollectionRequest
        @return: ModifyCollectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_collection_with_options_async(request, runtime)

    def modify_dbinstance_config_with_options(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceConfigResponse:
        """
        @summary Changes the threshold of computing resources and the wait period of idle resources for an AnalyticDB for PostgreSQL instance in Serverless automatic scheduling mode.
        
        @param request: ModifyDBInstanceConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.idle_time):
            query['IdleTime'] = request.idle_time
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.serverless_resource):
            query['ServerlessResource'] = request.serverless_resource
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceConfig',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbinstance_config_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceConfigResponse:
        """
        @summary Changes the threshold of computing resources and the wait period of idle resources for an AnalyticDB for PostgreSQL instance in Serverless automatic scheduling mode.
        
        @param request: ModifyDBInstanceConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.idle_time):
            query['IdleTime'] = request.idle_time
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.serverless_resource):
            query['ServerlessResource'] = request.serverless_resource
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceConfig',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbinstance_config(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceConfigRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceConfigResponse:
        """
        @summary Changes the threshold of computing resources and the wait period of idle resources for an AnalyticDB for PostgreSQL instance in Serverless automatic scheduling mode.
        
        @param request: ModifyDBInstanceConfigRequest
        @return: ModifyDBInstanceConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbinstance_config_with_options(request, runtime)

    async def modify_dbinstance_config_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceConfigRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceConfigResponse:
        """
        @summary Changes the threshold of computing resources and the wait period of idle resources for an AnalyticDB for PostgreSQL instance in Serverless automatic scheduling mode.
        
        @param request: ModifyDBInstanceConfigRequest
        @return: ModifyDBInstanceConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbinstance_config_with_options_async(request, runtime)

    def modify_dbinstance_connection_string_with_options(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceConnectionStringRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceConnectionStringResponse:
        """
        @summary Changes the endpoint of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyDBInstanceConnectionStringRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceConnectionStringResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.connection_string_prefix):
            query['ConnectionStringPrefix'] = request.connection_string_prefix
        if not UtilClient.is_unset(request.current_connection_string):
            query['CurrentConnectionString'] = request.current_connection_string
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceConnectionString',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceConnectionStringResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbinstance_connection_string_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceConnectionStringRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceConnectionStringResponse:
        """
        @summary Changes the endpoint of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyDBInstanceConnectionStringRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceConnectionStringResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.connection_string_prefix):
            query['ConnectionStringPrefix'] = request.connection_string_prefix
        if not UtilClient.is_unset(request.current_connection_string):
            query['CurrentConnectionString'] = request.current_connection_string
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceConnectionString',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceConnectionStringResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbinstance_connection_string(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceConnectionStringRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceConnectionStringResponse:
        """
        @summary Changes the endpoint of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyDBInstanceConnectionStringRequest
        @return: ModifyDBInstanceConnectionStringResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbinstance_connection_string_with_options(request, runtime)

    async def modify_dbinstance_connection_string_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceConnectionStringRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceConnectionStringResponse:
        """
        @summary Changes the endpoint of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyDBInstanceConnectionStringRequest
        @return: ModifyDBInstanceConnectionStringResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbinstance_connection_string_with_options_async(request, runtime)

    def modify_dbinstance_deployment_mode_with_options(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceDeploymentModeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceDeploymentModeResponse:
        """
        @summary 修改实例部署模式
        
        @param request: ModifyDBInstanceDeploymentModeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceDeploymentModeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.deploy_mode):
            query['DeployMode'] = request.deploy_mode
        if not UtilClient.is_unset(request.standby_vswitch_id):
            query['StandbyVSwitchId'] = request.standby_vswitch_id
        if not UtilClient.is_unset(request.standby_zone_id):
            query['StandbyZoneId'] = request.standby_zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceDeploymentMode',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceDeploymentModeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbinstance_deployment_mode_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceDeploymentModeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceDeploymentModeResponse:
        """
        @summary 修改实例部署模式
        
        @param request: ModifyDBInstanceDeploymentModeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceDeploymentModeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.deploy_mode):
            query['DeployMode'] = request.deploy_mode
        if not UtilClient.is_unset(request.standby_vswitch_id):
            query['StandbyVSwitchId'] = request.standby_vswitch_id
        if not UtilClient.is_unset(request.standby_zone_id):
            query['StandbyZoneId'] = request.standby_zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceDeploymentMode',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceDeploymentModeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbinstance_deployment_mode(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceDeploymentModeRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceDeploymentModeResponse:
        """
        @summary 修改实例部署模式
        
        @param request: ModifyDBInstanceDeploymentModeRequest
        @return: ModifyDBInstanceDeploymentModeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbinstance_deployment_mode_with_options(request, runtime)

    async def modify_dbinstance_deployment_mode_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceDeploymentModeRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceDeploymentModeResponse:
        """
        @summary 修改实例部署模式
        
        @param request: ModifyDBInstanceDeploymentModeRequest
        @return: ModifyDBInstanceDeploymentModeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbinstance_deployment_mode_with_options_async(request, runtime)

    def modify_dbinstance_description_with_options(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceDescriptionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceDescriptionResponse:
        """
        @summary Changes the description of an AnalyticDB for PostgreSQL instance.
        
        @description To make it easy to identify AnalyticDB for PostgreSQL instances, you can call this operation to modify the description of instances.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceDescriptionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceDescriptionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceDescription',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceDescriptionResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbinstance_description_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceDescriptionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceDescriptionResponse:
        """
        @summary Changes the description of an AnalyticDB for PostgreSQL instance.
        
        @description To make it easy to identify AnalyticDB for PostgreSQL instances, you can call this operation to modify the description of instances.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceDescriptionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceDescriptionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceDescription',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceDescriptionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbinstance_description(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceDescriptionRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceDescriptionResponse:
        """
        @summary Changes the description of an AnalyticDB for PostgreSQL instance.
        
        @description To make it easy to identify AnalyticDB for PostgreSQL instances, you can call this operation to modify the description of instances.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceDescriptionRequest
        @return: ModifyDBInstanceDescriptionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbinstance_description_with_options(request, runtime)

    async def modify_dbinstance_description_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceDescriptionRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceDescriptionResponse:
        """
        @summary Changes the description of an AnalyticDB for PostgreSQL instance.
        
        @description To make it easy to identify AnalyticDB for PostgreSQL instances, you can call this operation to modify the description of instances.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceDescriptionRequest
        @return: ModifyDBInstanceDescriptionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbinstance_description_with_options_async(request, runtime)

    def modify_dbinstance_maintain_time_with_options(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceMaintainTimeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceMaintainTimeResponse:
        """
        @summary Modifies the maintenance window of an AnalyticDB for PostgreSQL instance.
        
        @description The system maintains AnalyticDB for PostgreSQL instances during the maintenance window that you specify. We recommend that you set the maintenance window to off-peak hours to minimize the impact on your business.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceMaintainTimeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceMaintainTimeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceMaintainTime',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceMaintainTimeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbinstance_maintain_time_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceMaintainTimeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceMaintainTimeResponse:
        """
        @summary Modifies the maintenance window of an AnalyticDB for PostgreSQL instance.
        
        @description The system maintains AnalyticDB for PostgreSQL instances during the maintenance window that you specify. We recommend that you set the maintenance window to off-peak hours to minimize the impact on your business.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceMaintainTimeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceMaintainTimeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceMaintainTime',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceMaintainTimeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbinstance_maintain_time(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceMaintainTimeRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceMaintainTimeResponse:
        """
        @summary Modifies the maintenance window of an AnalyticDB for PostgreSQL instance.
        
        @description The system maintains AnalyticDB for PostgreSQL instances during the maintenance window that you specify. We recommend that you set the maintenance window to off-peak hours to minimize the impact on your business.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceMaintainTimeRequest
        @return: ModifyDBInstanceMaintainTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbinstance_maintain_time_with_options(request, runtime)

    async def modify_dbinstance_maintain_time_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceMaintainTimeRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceMaintainTimeResponse:
        """
        @summary Modifies the maintenance window of an AnalyticDB for PostgreSQL instance.
        
        @description The system maintains AnalyticDB for PostgreSQL instances during the maintenance window that you specify. We recommend that you set the maintenance window to off-peak hours to minimize the impact on your business.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceMaintainTimeRequest
        @return: ModifyDBInstanceMaintainTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbinstance_maintain_time_with_options_async(request, runtime)

    def modify_dbinstance_network_type_with_options(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceNetworkTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceNetworkTypeResponse:
        """
        @summary Changes the network type of an AnalyticDB for PostgreSQL instance.
        
        @description ##
        This operation is available only for AnalyticDB for PostgreSQL instances in reserved storage mode.
        ## QPS limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceNetworkTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceNetworkTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.instance_network_type):
            query['InstanceNetworkType'] = request.instance_network_type
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.vpcid):
            query['VPCId'] = request.vpcid
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceNetworkType',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceNetworkTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbinstance_network_type_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceNetworkTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceNetworkTypeResponse:
        """
        @summary Changes the network type of an AnalyticDB for PostgreSQL instance.
        
        @description ##
        This operation is available only for AnalyticDB for PostgreSQL instances in reserved storage mode.
        ## QPS limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceNetworkTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceNetworkTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.instance_network_type):
            query['InstanceNetworkType'] = request.instance_network_type
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.vpcid):
            query['VPCId'] = request.vpcid
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceNetworkType',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceNetworkTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbinstance_network_type(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceNetworkTypeRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceNetworkTypeResponse:
        """
        @summary Changes the network type of an AnalyticDB for PostgreSQL instance.
        
        @description ##
        This operation is available only for AnalyticDB for PostgreSQL instances in reserved storage mode.
        ## QPS limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceNetworkTypeRequest
        @return: ModifyDBInstanceNetworkTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbinstance_network_type_with_options(request, runtime)

    async def modify_dbinstance_network_type_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceNetworkTypeRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceNetworkTypeResponse:
        """
        @summary Changes the network type of an AnalyticDB for PostgreSQL instance.
        
        @description ##
        This operation is available only for AnalyticDB for PostgreSQL instances in reserved storage mode.
        ## QPS limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyDBInstanceNetworkTypeRequest
        @return: ModifyDBInstanceNetworkTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbinstance_network_type_with_options_async(request, runtime)

    def modify_dbinstance_pay_type_with_options(
        self,
        request: gpdb_20160503_models.ModifyDBInstancePayTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstancePayTypeResponse:
        """
        @summary 包年包月/按量付费转换改造
        
        @param request: ModifyDBInstancePayTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstancePayTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstancePayType',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstancePayTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbinstance_pay_type_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstancePayTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstancePayTypeResponse:
        """
        @summary 包年包月/按量付费转换改造
        
        @param request: ModifyDBInstancePayTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstancePayTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.used_time):
            query['UsedTime'] = request.used_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstancePayType',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstancePayTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbinstance_pay_type(
        self,
        request: gpdb_20160503_models.ModifyDBInstancePayTypeRequest,
    ) -> gpdb_20160503_models.ModifyDBInstancePayTypeResponse:
        """
        @summary 包年包月/按量付费转换改造
        
        @param request: ModifyDBInstancePayTypeRequest
        @return: ModifyDBInstancePayTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbinstance_pay_type_with_options(request, runtime)

    async def modify_dbinstance_pay_type_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstancePayTypeRequest,
    ) -> gpdb_20160503_models.ModifyDBInstancePayTypeResponse:
        """
        @summary 包年包月/按量付费转换改造
        
        @param request: ModifyDBInstancePayTypeRequest
        @return: ModifyDBInstancePayTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbinstance_pay_type_with_options_async(request, runtime)

    def modify_dbinstance_resource_group_with_options(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceResourceGroupResponse:
        """
        @summary Moves an AnalyticDB for PostgreSQL instance to a resource group.
        
        @description Resource Management allows you to build an organizational structure for resources based on your business requirements. You can use resource directories, folders, accounts, and resource groups to hierarchically organize and manage resources. For more information, see [What is Resource Management?](https://help.aliyun.com/document_detail/94475.html)
        
        @param request: ModifyDBInstanceResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.new_resource_group_id):
            query['NewResourceGroupId'] = request.new_resource_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbinstance_resource_group_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceResourceGroupResponse:
        """
        @summary Moves an AnalyticDB for PostgreSQL instance to a resource group.
        
        @description Resource Management allows you to build an organizational structure for resources based on your business requirements. You can use resource directories, folders, accounts, and resource groups to hierarchically organize and manage resources. For more information, see [What is Resource Management?](https://help.aliyun.com/document_detail/94475.html)
        
        @param request: ModifyDBInstanceResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.new_resource_group_id):
            query['NewResourceGroupId'] = request.new_resource_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbinstance_resource_group(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceResourceGroupRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceResourceGroupResponse:
        """
        @summary Moves an AnalyticDB for PostgreSQL instance to a resource group.
        
        @description Resource Management allows you to build an organizational structure for resources based on your business requirements. You can use resource directories, folders, accounts, and resource groups to hierarchically organize and manage resources. For more information, see [What is Resource Management?](https://help.aliyun.com/document_detail/94475.html)
        
        @param request: ModifyDBInstanceResourceGroupRequest
        @return: ModifyDBInstanceResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbinstance_resource_group_with_options(request, runtime)

    async def modify_dbinstance_resource_group_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceResourceGroupRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceResourceGroupResponse:
        """
        @summary Moves an AnalyticDB for PostgreSQL instance to a resource group.
        
        @description Resource Management allows you to build an organizational structure for resources based on your business requirements. You can use resource directories, folders, accounts, and resource groups to hierarchically organize and manage resources. For more information, see [What is Resource Management?](https://help.aliyun.com/document_detail/94475.html)
        
        @param request: ModifyDBInstanceResourceGroupRequest
        @return: ModifyDBInstanceResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbinstance_resource_group_with_options_async(request, runtime)

    def modify_dbinstance_sslwith_options(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceSSLRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceSSLResponse:
        """
        @summary Enables, disables, or updates SSL encryption for an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyDBInstanceSSLRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceSSLResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string):
            query['ConnectionString'] = request.connection_string
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.sslenabled):
            query['SSLEnabled'] = request.sslenabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceSSL',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceSSLResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbinstance_sslwith_options_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceSSLRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBInstanceSSLResponse:
        """
        @summary Enables, disables, or updates SSL encryption for an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyDBInstanceSSLRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBInstanceSSLResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connection_string):
            query['ConnectionString'] = request.connection_string
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.sslenabled):
            query['SSLEnabled'] = request.sslenabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBInstanceSSL',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBInstanceSSLResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbinstance_ssl(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceSSLRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceSSLResponse:
        """
        @summary Enables, disables, or updates SSL encryption for an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyDBInstanceSSLRequest
        @return: ModifyDBInstanceSSLResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbinstance_sslwith_options(request, runtime)

    async def modify_dbinstance_ssl_async(
        self,
        request: gpdb_20160503_models.ModifyDBInstanceSSLRequest,
    ) -> gpdb_20160503_models.ModifyDBInstanceSSLResponse:
        """
        @summary Enables, disables, or updates SSL encryption for an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyDBInstanceSSLRequest
        @return: ModifyDBInstanceSSLResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbinstance_sslwith_options_async(request, runtime)

    def modify_dbresource_group_with_options(
        self,
        tmp_req: gpdb_20160503_models.ModifyDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBResourceGroupResponse:
        """
        @summary Modifies the configurations of a resource group.
        
        @param tmp_req: ModifyDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBResourceGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.ModifyDBResourceGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.resource_group_items):
            request.resource_group_items_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.resource_group_items, 'ResourceGroupItems', 'json')
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_items_shrink):
            query['ResourceGroupItems'] = request.resource_group_items_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_dbresource_group_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.ModifyDBResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyDBResourceGroupResponse:
        """
        @summary Modifies the configurations of a resource group.
        
        @param tmp_req: ModifyDBResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyDBResourceGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.ModifyDBResourceGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.resource_group_items):
            request.resource_group_items_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.resource_group_items, 'ResourceGroupItems', 'json')
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_items_shrink):
            query['ResourceGroupItems'] = request.resource_group_items_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyDBResourceGroup',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyDBResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_dbresource_group(
        self,
        request: gpdb_20160503_models.ModifyDBResourceGroupRequest,
    ) -> gpdb_20160503_models.ModifyDBResourceGroupResponse:
        """
        @summary Modifies the configurations of a resource group.
        
        @param request: ModifyDBResourceGroupRequest
        @return: ModifyDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_dbresource_group_with_options(request, runtime)

    async def modify_dbresource_group_async(
        self,
        request: gpdb_20160503_models.ModifyDBResourceGroupRequest,
    ) -> gpdb_20160503_models.ModifyDBResourceGroupResponse:
        """
        @summary Modifies the configurations of a resource group.
        
        @param request: ModifyDBResourceGroupRequest
        @return: ModifyDBResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_dbresource_group_with_options_async(request, runtime)

    def modify_external_data_service_with_options(
        self,
        request: gpdb_20160503_models.ModifyExternalDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyExternalDataServiceResponse:
        """
        @summary Modify External Data Service
        
        @param request: ModifyExternalDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyExternalDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_description):
            query['ServiceDescription'] = request.service_description
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        if not UtilClient.is_unset(request.service_spec):
            query['ServiceSpec'] = request.service_spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyExternalDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyExternalDataServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_external_data_service_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyExternalDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyExternalDataServiceResponse:
        """
        @summary Modify External Data Service
        
        @param request: ModifyExternalDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyExternalDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_description):
            query['ServiceDescription'] = request.service_description
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        if not UtilClient.is_unset(request.service_spec):
            query['ServiceSpec'] = request.service_spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyExternalDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyExternalDataServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_external_data_service(
        self,
        request: gpdb_20160503_models.ModifyExternalDataServiceRequest,
    ) -> gpdb_20160503_models.ModifyExternalDataServiceResponse:
        """
        @summary Modify External Data Service
        
        @param request: ModifyExternalDataServiceRequest
        @return: ModifyExternalDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_external_data_service_with_options(request, runtime)

    async def modify_external_data_service_async(
        self,
        request: gpdb_20160503_models.ModifyExternalDataServiceRequest,
    ) -> gpdb_20160503_models.ModifyExternalDataServiceResponse:
        """
        @summary Modify External Data Service
        
        @param request: ModifyExternalDataServiceRequest
        @return: ModifyExternalDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_external_data_service_with_options_async(request, runtime)

    def modify_hadoop_data_source_with_options(
        self,
        request: gpdb_20160503_models.ModifyHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyHadoopDataSourceResponse:
        """
        @summary Modifies the configurations of a Hadoop data source.
        
        @param request: ModifyHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.emr_instance_id):
            query['EmrInstanceId'] = request.emr_instance_id
        if not UtilClient.is_unset(request.hdfsconf):
            query['HDFSConf'] = request.hdfsconf
        if not UtilClient.is_unset(request.hadoop_core_conf):
            query['HadoopCoreConf'] = request.hadoop_core_conf
        if not UtilClient.is_unset(request.hadoop_create_type):
            query['HadoopCreateType'] = request.hadoop_create_type
        if not UtilClient.is_unset(request.hadoop_hosts_address):
            query['HadoopHostsAddress'] = request.hadoop_hosts_address
        if not UtilClient.is_unset(request.hive_conf):
            query['HiveConf'] = request.hive_conf
        if not UtilClient.is_unset(request.map_reduce_conf):
            query['MapReduceConf'] = request.map_reduce_conf
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.yarn_conf):
            query['YarnConf'] = request.yarn_conf
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyHadoopDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_hadoop_data_source_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyHadoopDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyHadoopDataSourceResponse:
        """
        @summary Modifies the configurations of a Hadoop data source.
        
        @param request: ModifyHadoopDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyHadoopDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.emr_instance_id):
            query['EmrInstanceId'] = request.emr_instance_id
        if not UtilClient.is_unset(request.hdfsconf):
            query['HDFSConf'] = request.hdfsconf
        if not UtilClient.is_unset(request.hadoop_core_conf):
            query['HadoopCoreConf'] = request.hadoop_core_conf
        if not UtilClient.is_unset(request.hadoop_create_type):
            query['HadoopCreateType'] = request.hadoop_create_type
        if not UtilClient.is_unset(request.hadoop_hosts_address):
            query['HadoopHostsAddress'] = request.hadoop_hosts_address
        if not UtilClient.is_unset(request.hive_conf):
            query['HiveConf'] = request.hive_conf
        if not UtilClient.is_unset(request.map_reduce_conf):
            query['MapReduceConf'] = request.map_reduce_conf
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.yarn_conf):
            query['YarnConf'] = request.yarn_conf
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyHadoopDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyHadoopDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_hadoop_data_source(
        self,
        request: gpdb_20160503_models.ModifyHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.ModifyHadoopDataSourceResponse:
        """
        @summary Modifies the configurations of a Hadoop data source.
        
        @param request: ModifyHadoopDataSourceRequest
        @return: ModifyHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_hadoop_data_source_with_options(request, runtime)

    async def modify_hadoop_data_source_async(
        self,
        request: gpdb_20160503_models.ModifyHadoopDataSourceRequest,
    ) -> gpdb_20160503_models.ModifyHadoopDataSourceResponse:
        """
        @summary Modifies the configurations of a Hadoop data source.
        
        @param request: ModifyHadoopDataSourceRequest
        @return: ModifyHadoopDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_hadoop_data_source_with_options_async(request, runtime)

    def modify_jdbcdata_source_with_options(
        self,
        request: gpdb_20160503_models.ModifyJDBCDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyJDBCDataSourceResponse:
        """
        @summary Modifies the configurations of a Java Database Connectivity (JDBC) data source.
        
        @param request: ModifyJDBCDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyJDBCDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.jdbcconnection_string):
            query['JDBCConnectionString'] = request.jdbcconnection_string
        if not UtilClient.is_unset(request.jdbcpassword):
            query['JDBCPassword'] = request.jdbcpassword
        if not UtilClient.is_unset(request.jdbcuser_name):
            query['JDBCUserName'] = request.jdbcuser_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyJDBCDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyJDBCDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_jdbcdata_source_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyJDBCDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyJDBCDataSourceResponse:
        """
        @summary Modifies the configurations of a Java Database Connectivity (JDBC) data source.
        
        @param request: ModifyJDBCDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyJDBCDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.data_source_type):
            query['DataSourceType'] = request.data_source_type
        if not UtilClient.is_unset(request.jdbcconnection_string):
            query['JDBCConnectionString'] = request.jdbcconnection_string
        if not UtilClient.is_unset(request.jdbcpassword):
            query['JDBCPassword'] = request.jdbcpassword
        if not UtilClient.is_unset(request.jdbcuser_name):
            query['JDBCUserName'] = request.jdbcuser_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyJDBCDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyJDBCDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_jdbcdata_source(
        self,
        request: gpdb_20160503_models.ModifyJDBCDataSourceRequest,
    ) -> gpdb_20160503_models.ModifyJDBCDataSourceResponse:
        """
        @summary Modifies the configurations of a Java Database Connectivity (JDBC) data source.
        
        @param request: ModifyJDBCDataSourceRequest
        @return: ModifyJDBCDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_jdbcdata_source_with_options(request, runtime)

    async def modify_jdbcdata_source_async(
        self,
        request: gpdb_20160503_models.ModifyJDBCDataSourceRequest,
    ) -> gpdb_20160503_models.ModifyJDBCDataSourceResponse:
        """
        @summary Modifies the configurations of a Java Database Connectivity (JDBC) data source.
        
        @param request: ModifyJDBCDataSourceRequest
        @return: ModifyJDBCDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_jdbcdata_source_with_options_async(request, runtime)

    def modify_master_spec_with_options(
        self,
        request: gpdb_20160503_models.ModifyMasterSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyMasterSpecResponse:
        """
        @summary Changes the specifications of coordinator node resources for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is not available for instances in reserved storage mode.
        Before you call this operation, make sure that you are familiar with the billing of AnalyticDB for PostgreSQL. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        
        @param request: ModifyMasterSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyMasterSpecResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.master_aispec):
            query['MasterAISpec'] = request.master_aispec
        if not UtilClient.is_unset(request.master_cu):
            query['MasterCU'] = request.master_cu
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyMasterSpec',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyMasterSpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_master_spec_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyMasterSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyMasterSpecResponse:
        """
        @summary Changes the specifications of coordinator node resources for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is not available for instances in reserved storage mode.
        Before you call this operation, make sure that you are familiar with the billing of AnalyticDB for PostgreSQL. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        
        @param request: ModifyMasterSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyMasterSpecResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_description):
            query['DBInstanceDescription'] = request.dbinstance_description
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.master_aispec):
            query['MasterAISpec'] = request.master_aispec
        if not UtilClient.is_unset(request.master_cu):
            query['MasterCU'] = request.master_cu
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyMasterSpec',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyMasterSpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_master_spec(
        self,
        request: gpdb_20160503_models.ModifyMasterSpecRequest,
    ) -> gpdb_20160503_models.ModifyMasterSpecResponse:
        """
        @summary Changes the specifications of coordinator node resources for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is not available for instances in reserved storage mode.
        Before you call this operation, make sure that you are familiar with the billing of AnalyticDB for PostgreSQL. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        
        @param request: ModifyMasterSpecRequest
        @return: ModifyMasterSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_master_spec_with_options(request, runtime)

    async def modify_master_spec_async(
        self,
        request: gpdb_20160503_models.ModifyMasterSpecRequest,
    ) -> gpdb_20160503_models.ModifyMasterSpecResponse:
        """
        @summary Changes the specifications of coordinator node resources for an AnalyticDB for PostgreSQL instance.
        
        @description This operation is not available for instances in reserved storage mode.
        Before you call this operation, make sure that you are familiar with the billing of AnalyticDB for PostgreSQL. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        
        @param request: ModifyMasterSpecRequest
        @return: ModifyMasterSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_master_spec_with_options_async(request, runtime)

    def modify_parameters_with_options(
        self,
        request: gpdb_20160503_models.ModifyParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyParametersResponse:
        """
        @summary Modifies the configuration parameters of an AnalyticDB for PostgreSQL instance.
        
        @description This operation can be called to modify parameters of an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyParametersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.force_restart_instance):
            query['ForceRestartInstance'] = request.force_restart_instance
        if not UtilClient.is_unset(request.parameters):
            query['Parameters'] = request.parameters
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyParameters',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyParametersResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_parameters_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyParametersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyParametersResponse:
        """
        @summary Modifies the configuration parameters of an AnalyticDB for PostgreSQL instance.
        
        @description This operation can be called to modify parameters of an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyParametersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyParametersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.force_restart_instance):
            query['ForceRestartInstance'] = request.force_restart_instance
        if not UtilClient.is_unset(request.parameters):
            query['Parameters'] = request.parameters
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyParameters',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyParametersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_parameters(
        self,
        request: gpdb_20160503_models.ModifyParametersRequest,
    ) -> gpdb_20160503_models.ModifyParametersResponse:
        """
        @summary Modifies the configuration parameters of an AnalyticDB for PostgreSQL instance.
        
        @description This operation can be called to modify parameters of an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyParametersRequest
        @return: ModifyParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_parameters_with_options(request, runtime)

    async def modify_parameters_async(
        self,
        request: gpdb_20160503_models.ModifyParametersRequest,
    ) -> gpdb_20160503_models.ModifyParametersResponse:
        """
        @summary Modifies the configuration parameters of an AnalyticDB for PostgreSQL instance.
        
        @description This operation can be called to modify parameters of an AnalyticDB for PostgreSQL instance in elastic storage mode or Serverless mode.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered and may affect your business. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifyParametersRequest
        @return: ModifyParametersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_parameters_with_options_async(request, runtime)

    def modify_remote_adbdata_source_with_options(
        self,
        request: gpdb_20160503_models.ModifyRemoteADBDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyRemoteADBDataSourceResponse:
        """
        @summary Modify Homogeneous Data Source
        
        @param request: ModifyRemoteADBDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyRemoteADBDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.local_dbinstance_id):
            query['LocalDBInstanceId'] = request.local_dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        if not UtilClient.is_unset(request.user_password):
            query['UserPassword'] = request.user_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyRemoteADBDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyRemoteADBDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_remote_adbdata_source_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyRemoteADBDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyRemoteADBDataSourceResponse:
        """
        @summary Modify Homogeneous Data Source
        
        @param request: ModifyRemoteADBDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyRemoteADBDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.data_source_name):
            query['DataSourceName'] = request.data_source_name
        if not UtilClient.is_unset(request.local_dbinstance_id):
            query['LocalDBInstanceId'] = request.local_dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        if not UtilClient.is_unset(request.user_password):
            query['UserPassword'] = request.user_password
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyRemoteADBDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyRemoteADBDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_remote_adbdata_source(
        self,
        request: gpdb_20160503_models.ModifyRemoteADBDataSourceRequest,
    ) -> gpdb_20160503_models.ModifyRemoteADBDataSourceResponse:
        """
        @summary Modify Homogeneous Data Source
        
        @param request: ModifyRemoteADBDataSourceRequest
        @return: ModifyRemoteADBDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_remote_adbdata_source_with_options(request, runtime)

    async def modify_remote_adbdata_source_async(
        self,
        request: gpdb_20160503_models.ModifyRemoteADBDataSourceRequest,
    ) -> gpdb_20160503_models.ModifyRemoteADBDataSourceResponse:
        """
        @summary Modify Homogeneous Data Source
        
        @param request: ModifyRemoteADBDataSourceRequest
        @return: ModifyRemoteADBDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_remote_adbdata_source_with_options_async(request, runtime)

    def modify_sqlcollector_policy_with_options(
        self,
        request: gpdb_20160503_models.ModifySQLCollectorPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifySQLCollectorPolicyResponse:
        """
        @summary Enables or disables the SQL Explorer feature for an AnalyticDB for PostgreSQL instance.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL instances in reserved storage mode.
        You can call this operation only for AnalyticDB for PostgreSQL instances in Serverless automatic scheduling mode.
        
        @param request: ModifySQLCollectorPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifySQLCollectorPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.sqlcollector_status):
            query['SQLCollectorStatus'] = request.sqlcollector_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifySQLCollectorPolicy',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifySQLCollectorPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_sqlcollector_policy_with_options_async(
        self,
        request: gpdb_20160503_models.ModifySQLCollectorPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifySQLCollectorPolicyResponse:
        """
        @summary Enables or disables the SQL Explorer feature for an AnalyticDB for PostgreSQL instance.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL instances in reserved storage mode.
        You can call this operation only for AnalyticDB for PostgreSQL instances in Serverless automatic scheduling mode.
        
        @param request: ModifySQLCollectorPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifySQLCollectorPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.sqlcollector_status):
            query['SQLCollectorStatus'] = request.sqlcollector_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifySQLCollectorPolicy',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifySQLCollectorPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_sqlcollector_policy(
        self,
        request: gpdb_20160503_models.ModifySQLCollectorPolicyRequest,
    ) -> gpdb_20160503_models.ModifySQLCollectorPolicyResponse:
        """
        @summary Enables or disables the SQL Explorer feature for an AnalyticDB for PostgreSQL instance.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL instances in reserved storage mode.
        You can call this operation only for AnalyticDB for PostgreSQL instances in Serverless automatic scheduling mode.
        
        @param request: ModifySQLCollectorPolicyRequest
        @return: ModifySQLCollectorPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_sqlcollector_policy_with_options(request, runtime)

    async def modify_sqlcollector_policy_async(
        self,
        request: gpdb_20160503_models.ModifySQLCollectorPolicyRequest,
    ) -> gpdb_20160503_models.ModifySQLCollectorPolicyResponse:
        """
        @summary Enables or disables the SQL Explorer feature for an AnalyticDB for PostgreSQL instance.
        
        @description    You can call this operation only for AnalyticDB for PostgreSQL instances in reserved storage mode.
        You can call this operation only for AnalyticDB for PostgreSQL instances in Serverless automatic scheduling mode.
        
        @param request: ModifySQLCollectorPolicyRequest
        @return: ModifySQLCollectorPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_sqlcollector_policy_with_options_async(request, runtime)

    def modify_security_ips_with_options(
        self,
        request: gpdb_20160503_models.ModifySecurityIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifySecurityIpsResponse:
        """
        @summary Modifies the IP address whitelist of an AnalyticDB for PostgreSQL instance.
        
        @description To ensure the security and stability of AnalyticDB for PostgreSQL instances, the system denies all external IP addresses to access AnalyticDB for PostgreSQL instances by default. Before you can use an AnalyticDB for PostgreSQL instance, you must add the IP address or CIDR block of your client to the IP address whitelist of the instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifySecurityIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifySecurityIpsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_iparray_attribute):
            query['DBInstanceIPArrayAttribute'] = request.dbinstance_iparray_attribute
        if not UtilClient.is_unset(request.dbinstance_iparray_name):
            query['DBInstanceIPArrayName'] = request.dbinstance_iparray_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.modify_mode):
            query['ModifyMode'] = request.modify_mode
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifySecurityIps',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifySecurityIpsResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_security_ips_with_options_async(
        self,
        request: gpdb_20160503_models.ModifySecurityIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifySecurityIpsResponse:
        """
        @summary Modifies the IP address whitelist of an AnalyticDB for PostgreSQL instance.
        
        @description To ensure the security and stability of AnalyticDB for PostgreSQL instances, the system denies all external IP addresses to access AnalyticDB for PostgreSQL instances by default. Before you can use an AnalyticDB for PostgreSQL instance, you must add the IP address or CIDR block of your client to the IP address whitelist of the instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifySecurityIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifySecurityIpsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_iparray_attribute):
            query['DBInstanceIPArrayAttribute'] = request.dbinstance_iparray_attribute
        if not UtilClient.is_unset(request.dbinstance_iparray_name):
            query['DBInstanceIPArrayName'] = request.dbinstance_iparray_name
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.modify_mode):
            query['ModifyMode'] = request.modify_mode
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifySecurityIps',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifySecurityIpsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_security_ips(
        self,
        request: gpdb_20160503_models.ModifySecurityIpsRequest,
    ) -> gpdb_20160503_models.ModifySecurityIpsResponse:
        """
        @summary Modifies the IP address whitelist of an AnalyticDB for PostgreSQL instance.
        
        @description To ensure the security and stability of AnalyticDB for PostgreSQL instances, the system denies all external IP addresses to access AnalyticDB for PostgreSQL instances by default. Before you can use an AnalyticDB for PostgreSQL instance, you must add the IP address or CIDR block of your client to the IP address whitelist of the instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifySecurityIpsRequest
        @return: ModifySecurityIpsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_security_ips_with_options(request, runtime)

    async def modify_security_ips_async(
        self,
        request: gpdb_20160503_models.ModifySecurityIpsRequest,
    ) -> gpdb_20160503_models.ModifySecurityIpsResponse:
        """
        @summary Modifies the IP address whitelist of an AnalyticDB for PostgreSQL instance.
        
        @description To ensure the security and stability of AnalyticDB for PostgreSQL instances, the system denies all external IP addresses to access AnalyticDB for PostgreSQL instances by default. Before you can use an AnalyticDB for PostgreSQL instance, you must add the IP address or CIDR block of your client to the IP address whitelist of the instance.
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ModifySecurityIpsRequest
        @return: ModifySecurityIpsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_security_ips_with_options_async(request, runtime)

    def modify_streaming_data_service_with_options(
        self,
        request: gpdb_20160503_models.ModifyStreamingDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyStreamingDataServiceResponse:
        """
        @summary Modifies a real-time data service.
        
        @param request: ModifyStreamingDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyStreamingDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_description):
            query['ServiceDescription'] = request.service_description
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        if not UtilClient.is_unset(request.service_spec):
            query['ServiceSpec'] = request.service_spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyStreamingDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyStreamingDataServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_streaming_data_service_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyStreamingDataServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyStreamingDataServiceResponse:
        """
        @summary Modifies a real-time data service.
        
        @param request: ModifyStreamingDataServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyStreamingDataServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.service_description):
            query['ServiceDescription'] = request.service_description
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        if not UtilClient.is_unset(request.service_spec):
            query['ServiceSpec'] = request.service_spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyStreamingDataService',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyStreamingDataServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_streaming_data_service(
        self,
        request: gpdb_20160503_models.ModifyStreamingDataServiceRequest,
    ) -> gpdb_20160503_models.ModifyStreamingDataServiceResponse:
        """
        @summary Modifies a real-time data service.
        
        @param request: ModifyStreamingDataServiceRequest
        @return: ModifyStreamingDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_streaming_data_service_with_options(request, runtime)

    async def modify_streaming_data_service_async(
        self,
        request: gpdb_20160503_models.ModifyStreamingDataServiceRequest,
    ) -> gpdb_20160503_models.ModifyStreamingDataServiceResponse:
        """
        @summary Modifies a real-time data service.
        
        @param request: ModifyStreamingDataServiceRequest
        @return: ModifyStreamingDataServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_streaming_data_service_with_options_async(request, runtime)

    def modify_streaming_data_source_with_options(
        self,
        request: gpdb_20160503_models.ModifyStreamingDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyStreamingDataSourceResponse:
        """
        @summary Modifies a real-time service data source.
        
        @param request: ModifyStreamingDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyStreamingDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_config):
            query['DataSourceConfig'] = request.data_source_config
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyStreamingDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyStreamingDataSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_streaming_data_source_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyStreamingDataSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyStreamingDataSourceResponse:
        """
        @summary Modifies a real-time service data source.
        
        @param request: ModifyStreamingDataSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyStreamingDataSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.data_source_config):
            query['DataSourceConfig'] = request.data_source_config
        if not UtilClient.is_unset(request.data_source_description):
            query['DataSourceDescription'] = request.data_source_description
        if not UtilClient.is_unset(request.data_source_id):
            query['DataSourceId'] = request.data_source_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyStreamingDataSource',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyStreamingDataSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_streaming_data_source(
        self,
        request: gpdb_20160503_models.ModifyStreamingDataSourceRequest,
    ) -> gpdb_20160503_models.ModifyStreamingDataSourceResponse:
        """
        @summary Modifies a real-time service data source.
        
        @param request: ModifyStreamingDataSourceRequest
        @return: ModifyStreamingDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_streaming_data_source_with_options(request, runtime)

    async def modify_streaming_data_source_async(
        self,
        request: gpdb_20160503_models.ModifyStreamingDataSourceRequest,
    ) -> gpdb_20160503_models.ModifyStreamingDataSourceResponse:
        """
        @summary Modifies a real-time service data source.
        
        @param request: ModifyStreamingDataSourceRequest
        @return: ModifyStreamingDataSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_streaming_data_source_with_options_async(request, runtime)

    def modify_streaming_job_with_options(
        self,
        tmp_req: gpdb_20160503_models.ModifyStreamingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyStreamingJobResponse:
        """
        @summary Create External Data Source Configuration
        
        @param tmp_req: ModifyStreamingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyStreamingJobResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.ModifyStreamingJobShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dest_columns):
            request.dest_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dest_columns, 'DestColumns', 'json')
        if not UtilClient.is_unset(tmp_req.match_columns):
            request.match_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.match_columns, 'MatchColumns', 'json')
        if not UtilClient.is_unset(tmp_req.src_columns):
            request.src_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_columns, 'SrcColumns', 'json')
        if not UtilClient.is_unset(tmp_req.update_columns):
            request.update_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.update_columns, 'UpdateColumns', 'json')
        query = {}
        if not UtilClient.is_unset(request.account):
            query['Account'] = request.account
        if not UtilClient.is_unset(request.consistency):
            query['Consistency'] = request.consistency
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dest_columns_shrink):
            query['DestColumns'] = request.dest_columns_shrink
        if not UtilClient.is_unset(request.dest_database):
            query['DestDatabase'] = request.dest_database
        if not UtilClient.is_unset(request.dest_schema):
            query['DestSchema'] = request.dest_schema
        if not UtilClient.is_unset(request.dest_table):
            query['DestTable'] = request.dest_table
        if not UtilClient.is_unset(request.error_limit_count):
            query['ErrorLimitCount'] = request.error_limit_count
        if not UtilClient.is_unset(request.fallback_offset):
            query['FallbackOffset'] = request.fallback_offset
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.job_config):
            query['JobConfig'] = request.job_config
        if not UtilClient.is_unset(request.job_description):
            query['JobDescription'] = request.job_description
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.match_columns_shrink):
            query['MatchColumns'] = request.match_columns_shrink
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.src_columns_shrink):
            query['SrcColumns'] = request.src_columns_shrink
        if not UtilClient.is_unset(request.try_run):
            query['TryRun'] = request.try_run
        if not UtilClient.is_unset(request.update_columns_shrink):
            query['UpdateColumns'] = request.update_columns_shrink
        if not UtilClient.is_unset(request.write_mode):
            query['WriteMode'] = request.write_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyStreamingJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyStreamingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_streaming_job_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.ModifyStreamingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyStreamingJobResponse:
        """
        @summary Create External Data Source Configuration
        
        @param tmp_req: ModifyStreamingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyStreamingJobResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.ModifyStreamingJobShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dest_columns):
            request.dest_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dest_columns, 'DestColumns', 'json')
        if not UtilClient.is_unset(tmp_req.match_columns):
            request.match_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.match_columns, 'MatchColumns', 'json')
        if not UtilClient.is_unset(tmp_req.src_columns):
            request.src_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_columns, 'SrcColumns', 'json')
        if not UtilClient.is_unset(tmp_req.update_columns):
            request.update_columns_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.update_columns, 'UpdateColumns', 'json')
        query = {}
        if not UtilClient.is_unset(request.account):
            query['Account'] = request.account
        if not UtilClient.is_unset(request.consistency):
            query['Consistency'] = request.consistency
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.dest_columns_shrink):
            query['DestColumns'] = request.dest_columns_shrink
        if not UtilClient.is_unset(request.dest_database):
            query['DestDatabase'] = request.dest_database
        if not UtilClient.is_unset(request.dest_schema):
            query['DestSchema'] = request.dest_schema
        if not UtilClient.is_unset(request.dest_table):
            query['DestTable'] = request.dest_table
        if not UtilClient.is_unset(request.error_limit_count):
            query['ErrorLimitCount'] = request.error_limit_count
        if not UtilClient.is_unset(request.fallback_offset):
            query['FallbackOffset'] = request.fallback_offset
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.job_config):
            query['JobConfig'] = request.job_config
        if not UtilClient.is_unset(request.job_description):
            query['JobDescription'] = request.job_description
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.match_columns_shrink):
            query['MatchColumns'] = request.match_columns_shrink
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.src_columns_shrink):
            query['SrcColumns'] = request.src_columns_shrink
        if not UtilClient.is_unset(request.try_run):
            query['TryRun'] = request.try_run
        if not UtilClient.is_unset(request.update_columns_shrink):
            query['UpdateColumns'] = request.update_columns_shrink
        if not UtilClient.is_unset(request.write_mode):
            query['WriteMode'] = request.write_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyStreamingJob',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyStreamingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_streaming_job(
        self,
        request: gpdb_20160503_models.ModifyStreamingJobRequest,
    ) -> gpdb_20160503_models.ModifyStreamingJobResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: ModifyStreamingJobRequest
        @return: ModifyStreamingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_streaming_job_with_options(request, runtime)

    async def modify_streaming_job_async(
        self,
        request: gpdb_20160503_models.ModifyStreamingJobRequest,
    ) -> gpdb_20160503_models.ModifyStreamingJobResponse:
        """
        @summary Create External Data Source Configuration
        
        @param request: ModifyStreamingJobRequest
        @return: ModifyStreamingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_streaming_job_with_options_async(request, runtime)

    def modify_supabase_project_security_ips_with_options(
        self,
        request: gpdb_20160503_models.ModifySupabaseProjectSecurityIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifySupabaseProjectSecurityIpsResponse:
        """
        @summary 修改supabase项目白名单
        
        @param request: ModifySupabaseProjectSecurityIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifySupabaseProjectSecurityIpsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifySupabaseProjectSecurityIps',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifySupabaseProjectSecurityIpsResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_supabase_project_security_ips_with_options_async(
        self,
        request: gpdb_20160503_models.ModifySupabaseProjectSecurityIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifySupabaseProjectSecurityIpsResponse:
        """
        @summary 修改supabase项目白名单
        
        @param request: ModifySupabaseProjectSecurityIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifySupabaseProjectSecurityIpsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.security_iplist):
            query['SecurityIPList'] = request.security_iplist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifySupabaseProjectSecurityIps',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifySupabaseProjectSecurityIpsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_supabase_project_security_ips(
        self,
        request: gpdb_20160503_models.ModifySupabaseProjectSecurityIpsRequest,
    ) -> gpdb_20160503_models.ModifySupabaseProjectSecurityIpsResponse:
        """
        @summary 修改supabase项目白名单
        
        @param request: ModifySupabaseProjectSecurityIpsRequest
        @return: ModifySupabaseProjectSecurityIpsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_supabase_project_security_ips_with_options(request, runtime)

    async def modify_supabase_project_security_ips_async(
        self,
        request: gpdb_20160503_models.ModifySupabaseProjectSecurityIpsRequest,
    ) -> gpdb_20160503_models.ModifySupabaseProjectSecurityIpsResponse:
        """
        @summary 修改supabase项目白名单
        
        @param request: ModifySupabaseProjectSecurityIpsRequest
        @return: ModifySupabaseProjectSecurityIpsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_supabase_project_security_ips_with_options_async(request, runtime)

    def modify_vector_configuration_with_options(
        self,
        request: gpdb_20160503_models.ModifyVectorConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyVectorConfigurationResponse:
        """
        @summary Modifies the vector engine optimization configuration of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyVectorConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyVectorConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.vector_configuration_status):
            query['VectorConfigurationStatus'] = request.vector_configuration_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyVectorConfiguration',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyVectorConfigurationResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_vector_configuration_with_options_async(
        self,
        request: gpdb_20160503_models.ModifyVectorConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.ModifyVectorConfigurationResponse:
        """
        @summary Modifies the vector engine optimization configuration of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyVectorConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyVectorConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.vector_configuration_status):
            query['VectorConfigurationStatus'] = request.vector_configuration_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyVectorConfiguration',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.ModifyVectorConfigurationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_vector_configuration(
        self,
        request: gpdb_20160503_models.ModifyVectorConfigurationRequest,
    ) -> gpdb_20160503_models.ModifyVectorConfigurationResponse:
        """
        @summary Modifies the vector engine optimization configuration of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyVectorConfigurationRequest
        @return: ModifyVectorConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_vector_configuration_with_options(request, runtime)

    async def modify_vector_configuration_async(
        self,
        request: gpdb_20160503_models.ModifyVectorConfigurationRequest,
    ) -> gpdb_20160503_models.ModifyVectorConfigurationResponse:
        """
        @summary Modifies the vector engine optimization configuration of an AnalyticDB for PostgreSQL instance.
        
        @param request: ModifyVectorConfigurationRequest
        @return: ModifyVectorConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_vector_configuration_with_options_async(request, runtime)

    def pause_data_redistribute_with_options(
        self,
        request: gpdb_20160503_models.PauseDataRedistributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.PauseDataRedistributeResponse:
        """
        @summary Pauses data redistribution.
        
        @param request: PauseDataRedistributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PauseDataRedistributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PauseDataRedistribute',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.PauseDataRedistributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def pause_data_redistribute_with_options_async(
        self,
        request: gpdb_20160503_models.PauseDataRedistributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.PauseDataRedistributeResponse:
        """
        @summary Pauses data redistribution.
        
        @param request: PauseDataRedistributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PauseDataRedistributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PauseDataRedistribute',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.PauseDataRedistributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def pause_data_redistribute(
        self,
        request: gpdb_20160503_models.PauseDataRedistributeRequest,
    ) -> gpdb_20160503_models.PauseDataRedistributeResponse:
        """
        @summary Pauses data redistribution.
        
        @param request: PauseDataRedistributeRequest
        @return: PauseDataRedistributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.pause_data_redistribute_with_options(request, runtime)

    async def pause_data_redistribute_async(
        self,
        request: gpdb_20160503_models.PauseDataRedistributeRequest,
    ) -> gpdb_20160503_models.PauseDataRedistributeResponse:
        """
        @summary Pauses data redistribution.
        
        @param request: PauseDataRedistributeRequest
        @return: PauseDataRedistributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.pause_data_redistribute_with_options_async(request, runtime)

    def pause_instance_with_options(
        self,
        request: gpdb_20160503_models.PauseInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.PauseInstanceResponse:
        """
        @summary Pauses an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to pause an AnalyticDB for PostgreSQL instance that is in the *Running** state.
        This operation is available only for AnalyticDB for PostgreSQL instances in Serverless mode that run V1.0.2.1 or later. For more information about how to view and update the minor engine version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        >  Before you call this operation, make sure that you are familiar with the billing methods and pricing of AnalyticDB for PostgreSQL instances. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: PauseInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PauseInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PauseInstance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.PauseInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def pause_instance_with_options_async(
        self,
        request: gpdb_20160503_models.PauseInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.PauseInstanceResponse:
        """
        @summary Pauses an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to pause an AnalyticDB for PostgreSQL instance that is in the *Running** state.
        This operation is available only for AnalyticDB for PostgreSQL instances in Serverless mode that run V1.0.2.1 or later. For more information about how to view and update the minor engine version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        >  Before you call this operation, make sure that you are familiar with the billing methods and pricing of AnalyticDB for PostgreSQL instances. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: PauseInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PauseInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PauseInstance',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.PauseInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def pause_instance(
        self,
        request: gpdb_20160503_models.PauseInstanceRequest,
    ) -> gpdb_20160503_models.PauseInstanceResponse:
        """
        @summary Pauses an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to pause an AnalyticDB for PostgreSQL instance that is in the *Running** state.
        This operation is available only for AnalyticDB for PostgreSQL instances in Serverless mode that run V1.0.2.1 or later. For more information about how to view and update the minor engine version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        >  Before you call this operation, make sure that you are familiar with the billing methods and pricing of AnalyticDB for PostgreSQL instances. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: PauseInstanceRequest
        @return: PauseInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.pause_instance_with_options(request, runtime)

    async def pause_instance_async(
        self,
        request: gpdb_20160503_models.PauseInstanceRequest,
    ) -> gpdb_20160503_models.PauseInstanceResponse:
        """
        @summary Pauses an AnalyticDB for PostgreSQL instance.
        
        @description You can call this operation to pause an AnalyticDB for PostgreSQL instance that is in the *Running** state.
        This operation is available only for AnalyticDB for PostgreSQL instances in Serverless mode that run V1.0.2.1 or later. For more information about how to view and update the minor engine version of an instance, see [View the minor engine version](https://help.aliyun.com/document_detail/277424.html) and [Update the minor engine version](https://help.aliyun.com/document_detail/139271.html).
        >  Before you call this operation, make sure that you are familiar with the billing methods and pricing of AnalyticDB for PostgreSQL instances. For more information, see [Billing methods](https://help.aliyun.com/document_detail/35406.html) and [AnalyticDB for PostgreSQL pricing](https://www.alibabacloud.com/zh/product/hybriddb-postgresql/pricing).
        ## Limits
        You can call this operation up to 1,000 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: PauseInstanceRequest
        @return: PauseInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.pause_instance_with_options_async(request, runtime)

    def query_collection_data_with_options(
        self,
        tmp_req: gpdb_20160503_models.QueryCollectionDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.QueryCollectionDataResponse:
        """
        @summary Query Vector Data
        
        @param tmp_req: QueryCollectionDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryCollectionDataResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.QueryCollectionDataShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.hybrid_search_args):
            request.hybrid_search_args_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.hybrid_search_args, 'HybridSearchArgs', 'json')
        if not UtilClient.is_unset(tmp_req.relational_table_filter):
            request.relational_table_filter_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.relational_table_filter, 'RelationalTableFilter', 'json')
        if not UtilClient.is_unset(tmp_req.sparse_vector):
            request.sparse_vector_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sparse_vector, 'SparseVector', 'json')
        if not UtilClient.is_unset(tmp_req.vector):
            request.vector_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.vector, 'Vector', 'json')
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.hybrid_search):
            query['HybridSearch'] = request.hybrid_search
        if not UtilClient.is_unset(request.hybrid_search_args_shrink):
            query['HybridSearchArgs'] = request.hybrid_search_args_shrink
        if not UtilClient.is_unset(request.include_metadata_fields):
            query['IncludeMetadataFields'] = request.include_metadata_fields
        if not UtilClient.is_unset(request.include_values):
            query['IncludeValues'] = request.include_values
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.offset):
            query['Offset'] = request.offset
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.relational_table_filter_shrink):
            query['RelationalTableFilter'] = request.relational_table_filter_shrink
        if not UtilClient.is_unset(request.sparse_vector_shrink):
            query['SparseVector'] = request.sparse_vector_shrink
        if not UtilClient.is_unset(request.top_k):
            query['TopK'] = request.top_k
        if not UtilClient.is_unset(request.vector_shrink):
            query['Vector'] = request.vector_shrink
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        body = {}
        if not UtilClient.is_unset(request.filter):
            body['Filter'] = request.filter
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='QueryCollectionData',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.QueryCollectionDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_collection_data_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.QueryCollectionDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.QueryCollectionDataResponse:
        """
        @summary Query Vector Data
        
        @param tmp_req: QueryCollectionDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryCollectionDataResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.QueryCollectionDataShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.hybrid_search_args):
            request.hybrid_search_args_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.hybrid_search_args, 'HybridSearchArgs', 'json')
        if not UtilClient.is_unset(tmp_req.relational_table_filter):
            request.relational_table_filter_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.relational_table_filter, 'RelationalTableFilter', 'json')
        if not UtilClient.is_unset(tmp_req.sparse_vector):
            request.sparse_vector_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sparse_vector, 'SparseVector', 'json')
        if not UtilClient.is_unset(tmp_req.vector):
            request.vector_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.vector, 'Vector', 'json')
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.hybrid_search):
            query['HybridSearch'] = request.hybrid_search
        if not UtilClient.is_unset(request.hybrid_search_args_shrink):
            query['HybridSearchArgs'] = request.hybrid_search_args_shrink
        if not UtilClient.is_unset(request.include_metadata_fields):
            query['IncludeMetadataFields'] = request.include_metadata_fields
        if not UtilClient.is_unset(request.include_values):
            query['IncludeValues'] = request.include_values
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.offset):
            query['Offset'] = request.offset
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.relational_table_filter_shrink):
            query['RelationalTableFilter'] = request.relational_table_filter_shrink
        if not UtilClient.is_unset(request.sparse_vector_shrink):
            query['SparseVector'] = request.sparse_vector_shrink
        if not UtilClient.is_unset(request.top_k):
            query['TopK'] = request.top_k
        if not UtilClient.is_unset(request.vector_shrink):
            query['Vector'] = request.vector_shrink
        if not UtilClient.is_unset(request.workspace_id):
            query['WorkspaceId'] = request.workspace_id
        body = {}
        if not UtilClient.is_unset(request.filter):
            body['Filter'] = request.filter
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='QueryCollectionData',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.QueryCollectionDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_collection_data(
        self,
        request: gpdb_20160503_models.QueryCollectionDataRequest,
    ) -> gpdb_20160503_models.QueryCollectionDataResponse:
        """
        @summary Query Vector Data
        
        @param request: QueryCollectionDataRequest
        @return: QueryCollectionDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_collection_data_with_options(request, runtime)

    async def query_collection_data_async(
        self,
        request: gpdb_20160503_models.QueryCollectionDataRequest,
    ) -> gpdb_20160503_models.QueryCollectionDataResponse:
        """
        @summary Query Vector Data
        
        @param request: QueryCollectionDataRequest
        @return: QueryCollectionDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_collection_data_with_options_async(request, runtime)

    def query_content_with_options(
        self,
        tmp_req: gpdb_20160503_models.QueryContentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.QueryContentResponse:
        """
        @summary Query
        
        @param tmp_req: QueryContentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryContentResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.QueryContentShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.graph_search_args):
            request.graph_search_args_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.graph_search_args, 'GraphSearchArgs', 'json')
        if not UtilClient.is_unset(tmp_req.hybrid_search_args):
            request.hybrid_search_args_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.hybrid_search_args, 'HybridSearchArgs', 'json')
        if not UtilClient.is_unset(tmp_req.recall_window):
            request.recall_window_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.recall_window, 'RecallWindow', 'json')
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.file_url):
            query['FileUrl'] = request.file_url
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.graph_enhance):
            query['GraphEnhance'] = request.graph_enhance
        if not UtilClient.is_unset(request.graph_search_args_shrink):
            query['GraphSearchArgs'] = request.graph_search_args_shrink
        if not UtilClient.is_unset(request.hybrid_search):
            query['HybridSearch'] = request.hybrid_search
        if not UtilClient.is_unset(request.hybrid_search_args_shrink):
            query['HybridSearchArgs'] = request.hybrid_search_args_shrink
        if not UtilClient.is_unset(request.include_file_url):
            query['IncludeFileUrl'] = request.include_file_url
        if not UtilClient.is_unset(request.include_metadata_fields):
            query['IncludeMetadataFields'] = request.include_metadata_fields
        if not UtilClient.is_unset(request.include_vector):
            query['IncludeVector'] = request.include_vector
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_password):
            query['NamespacePassword'] = request.namespace_password
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.recall_window_shrink):
            query['RecallWindow'] = request.recall_window_shrink
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.rerank_factor):
            query['RerankFactor'] = request.rerank_factor
        if not UtilClient.is_unset(request.top_k):
            query['TopK'] = request.top_k
        if not UtilClient.is_unset(request.url_expiration):
            query['UrlExpiration'] = request.url_expiration
        if not UtilClient.is_unset(request.use_full_text_retrieval):
            query['UseFullTextRetrieval'] = request.use_full_text_retrieval
        body = {}
        if not UtilClient.is_unset(request.content):
            body['Content'] = request.content
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='QueryContent',
            version='2016-05-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            gpdb_20160503_models.QueryContentResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_content_with_options_async(
        self,
        tmp_req: gpdb_20160503_models.QueryContentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> gpdb_20160503_models.QueryContentResponse:
        """
        @summary Query
        
        @param tmp_req: QueryContentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryContentResponse
        """
        UtilClient.validate_model(tmp_req)
        request = gpdb_20160503_models.QueryContentShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.graph_search_args):
            request.graph_search_args_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.graph_search_args, 'GraphSearchArgs', 'json')
        if not UtilClient.is_unset(tmp_req.hybrid_search_args):
            request.hybrid_search_args_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.hybrid_search_args, 'HybridSearchArgs', 'json')
        if not UtilClient.is_unset(tmp_req.recall_window):
            request.recall_window_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.recall_window, 'RecallWindow', 'json')
        query = {}
        if not UtilClient.is_unset(request.collection):
            query['Collection'] = request.collection
        if not UtilClient.is_unset(request.dbinstance_id):
            query['DBInstanceId'] = request.dbinstance_id
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.file_url):
            query['FileUrl'] = request.file_url
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.graph_enhance):
            query['GraphEnhance'] = request.graph_enhance
        if not UtilClient.is_unset(request.graph_search_args_shrink):
            query['GraphSearchArgs'] = request.graph_search_args_shrink
        if not UtilClient.is_unset(request.hybrid_search):
            query['HybridSearch'] = request.hybrid_search
        if not UtilClient.is_unset(request.hybrid_search_args_shrink):
            query['HybridSearchArgs'] = request.hybrid_search_args_shrink
        if not UtilClient.is_unset(request.include_file_url):
            query['IncludeFileUrl'] = request.include_file_url
        if not UtilClient.is_unset(request.include_metadata_fields):
            query['IncludeMetadataFields'] = request.include_metadata_fields
        if not UtilClient.is_unset(request.include_vector):
            query['IncludeVector'] = request.include_vector
        if not UtilClient.is_unset(request.metrics):
            query['Metrics'] = request.metrics
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(reques