# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any, BinaryIO


class ColumnMetadata(TeaModel):
    def __init__(
        self,
        column_default: str = None,
        comment: str = None,
        data_type: str = None,
        is_case_sensitive: bool = None,
        is_currency: bool = None,
        is_primary_key: bool = None,
        is_signed: bool = None,
        max_length: int = None,
        name: str = None,
        nullable: bool = None,
        precision: int = None,
        scale: int = None,
        schema_name: str = None,
        table_name: str = None,
        udt_name: str = None,
    ):
        self.column_default = column_default
        self.comment = comment
        self.data_type = data_type
        self.is_case_sensitive = is_case_sensitive
        self.is_currency = is_currency
        self.is_primary_key = is_primary_key
        self.is_signed = is_signed
        self.max_length = max_length
        self.name = name
        self.nullable = nullable
        self.precision = precision
        self.scale = scale
        self.schema_name = schema_name
        self.table_name = table_name
        self.udt_name = udt_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_default is not None:
            result['ColumnDefault'] = self.column_default
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.is_case_sensitive is not None:
            result['IsCaseSensitive'] = self.is_case_sensitive
        if self.is_currency is not None:
            result['IsCurrency'] = self.is_currency
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.is_signed is not None:
            result['IsSigned'] = self.is_signed
        if self.max_length is not None:
            result['MaxLength'] = self.max_length
        if self.name is not None:
            result['Name'] = self.name
        if self.nullable is not None:
            result['Nullable'] = self.nullable
        if self.precision is not None:
            result['Precision'] = self.precision
        if self.scale is not None:
            result['Scale'] = self.scale
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.udt_name is not None:
            result['UdtName'] = self.udt_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnDefault') is not None:
            self.column_default = m.get('ColumnDefault')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('IsCaseSensitive') is not None:
            self.is_case_sensitive = m.get('IsCaseSensitive')
        if m.get('IsCurrency') is not None:
            self.is_currency = m.get('IsCurrency')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('IsSigned') is not None:
            self.is_signed = m.get('IsSigned')
        if m.get('MaxLength') is not None:
            self.max_length = m.get('MaxLength')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Nullable') is not None:
            self.nullable = m.get('Nullable')
        if m.get('Precision') is not None:
            self.precision = m.get('Precision')
        if m.get('Scale') is not None:
            self.scale = m.get('Scale')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('UdtName') is not None:
            self.udt_name = m.get('UdtName')
        return self


class Field(TeaModel):
    def __init__(
        self,
        blob_value: str = None,
        boolean_value: bool = None,
        double_value: float = None,
        is_null: bool = None,
        long_value: int = None,
        string_value: str = None,
    ):
        self.blob_value = blob_value
        self.boolean_value = boolean_value
        self.double_value = double_value
        self.is_null = is_null
        self.long_value = long_value
        self.string_value = string_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.blob_value is not None:
            result['BlobValue'] = self.blob_value
        if self.boolean_value is not None:
            result['BooleanValue'] = self.boolean_value
        if self.double_value is not None:
            result['DoubleValue'] = self.double_value
        if self.is_null is not None:
            result['IsNull'] = self.is_null
        if self.long_value is not None:
            result['LongValue'] = self.long_value
        if self.string_value is not None:
            result['StringValue'] = self.string_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlobValue') is not None:
            self.blob_value = m.get('BlobValue')
        if m.get('BooleanValue') is not None:
            self.boolean_value = m.get('BooleanValue')
        if m.get('DoubleValue') is not None:
            self.double_value = m.get('DoubleValue')
        if m.get('IsNull') is not None:
            self.is_null = m.get('IsNull')
        if m.get('LongValue') is not None:
            self.long_value = m.get('LongValue')
        if m.get('StringValue') is not None:
            self.string_value = m.get('StringValue')
        return self


class StatementData(TeaModel):
    def __init__(
        self,
        created_at: str = None,
        database: str = None,
        id: str = None,
        parameters: List[str] = None,
        secret_arn: str = None,
        sql: str = None,
        sqls: List[str] = None,
        status: str = None,
        updated_at: str = None,
    ):
        self.created_at = created_at
        self.database = database
        self.id = id
        self.parameters = parameters
        self.secret_arn = secret_arn
        self.sql = sql
        self.sqls = sqls
        self.status = status
        self.updated_at = updated_at

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_at is not None:
            result['CreatedAt'] = self.created_at
        if self.database is not None:
            result['Database'] = self.database
        if self.id is not None:
            result['Id'] = self.id
        if self.parameters is not None:
            result['Parameters'] = self.parameters
        if self.secret_arn is not None:
            result['SecretArn'] = self.secret_arn
        if self.sql is not None:
            result['Sql'] = self.sql
        if self.sqls is not None:
            result['Sqls'] = self.sqls
        if self.status is not None:
            result['Status'] = self.status
        if self.updated_at is not None:
            result['UpdatedAt'] = self.updated_at
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreatedAt') is not None:
            self.created_at = m.get('CreatedAt')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Parameters') is not None:
            self.parameters = m.get('Parameters')
        if m.get('SecretArn') is not None:
            self.secret_arn = m.get('SecretArn')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        if m.get('Sqls') is not None:
            self.sqls = m.get('Sqls')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdatedAt') is not None:
            self.updated_at = m.get('UpdatedAt')
        return self


class AllocateInstancePublicConnectionRequest(TeaModel):
    def __init__(
        self,
        address_type: str = None,
        connection_string_prefix: str = None,
        dbinstance_id: str = None,
        owner_id: int = None,
        port: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # The network type of the endpoint. Valid values:
        # 
        # *   **primary**: primary endpoint
        # *   **cluster**: instance endpoint. This value is supported only for an instance that contains multiple coordinator nodes.
        # 
        # >  The default value is primary.
        self.address_type = address_type
        # The prefix of the endpoint.
        # 
        # Specify a prefix for the endpoint. Example: `gp-bp12ga6v69h86****`. In this example, the endpoint is `gp-bp12ga6v69h86****.gpdb.rds.aliyuncs.com`.
        # 
        # This parameter is required.
        self.connection_string_prefix = connection_string_prefix
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The port number. Example: 5432.
        # 
        # This parameter is required.
        self.port = port
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address_type is not None:
            result['AddressType'] = self.address_type
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port is not None:
            result['Port'] = self.port
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddressType') is not None:
            self.address_type = m.get('AddressType')
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AllocateInstancePublicConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllocateInstancePublicConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AllocateInstancePublicConnectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllocateInstancePublicConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindDBResourceGroupWithRoleRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        resource_group_name: str = None,
        role_list: List[str] = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The name of the resource group.
        # 
        # This parameter is required.
        self.resource_group_name = resource_group_name
        # The roles.
        # 
        # This parameter is required.
        self.role_list = role_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        if self.role_list is not None:
            result['RoleList'] = self.role_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        if m.get('RoleList') is not None:
            self.role_list = m.get('RoleList')
        return self


class BindDBResourceGroupWithRoleShrinkRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        resource_group_name: str = None,
        role_list_shrink: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The name of the resource group.
        # 
        # This parameter is required.
        self.resource_group_name = resource_group_name
        # The roles.
        # 
        # This parameter is required.
        self.role_list_shrink = role_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        if self.role_list_shrink is not None:
            result['RoleList'] = self.role_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        if m.get('RoleList') is not None:
            self.role_list_shrink = m.get('RoleList')
        return self


class BindDBResourceGroupWithRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindDBResourceGroupWithRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BindDBResourceGroupWithRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindDBResourceGroupWithRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCreateIndexJobRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        job_id: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.collection = collection
        self.dbinstance_id = dbinstance_id
        # This parameter is required.
        self.job_id = job_id
        # This parameter is required.
        self.namespace = namespace
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # This parameter is required.
        self.region_id = region_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CancelCreateIndexJobResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        self.message = message
        self.request_id = request_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CancelCreateIndexJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelCreateIndexJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelCreateIndexJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelUploadDocumentJobRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        job_id: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The name of the document collection.
        # 
        # >  You can call the [CreateDocumentCollection](https://help.aliyun.com/document_detail/2618448.html) operation to create a document collection and call the [ListDocumentCollections](https://help.aliyun.com/document_detail/2618452.html) operation to query a list of document collections.
        # 
        # This parameter is required.
        self.collection = collection
        # The ID of the instance for which vector engine optimization is enabled.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The ID of the document upload job. You can call the `UploadDocumentAsync` operation to query the job ID.
        # 
        # This parameter is required.
        self.job_id = job_id
        # The name of the namespace. Default value: public.
        # 
        # >  You can call the CreateNamespace operation to create a namespace and call the ListNamespaces operation to query a list of namespaces.
        self.namespace = namespace
        # The password of the namespace.
        # 
        # >  The value of this parameter is specified when you call the CreateNamespace operation.
        # 
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CancelUploadDocumentJobResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The status of the operation. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CancelUploadDocumentJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelUploadDocumentJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelUploadDocumentJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelUpsertCollectionDataJobRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        job_id: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # The name of the collection.
        # 
        # >  You can call the [ListCollections](https://help.aliyun.com/document_detail/2401503.html) operation to query a list of collections.
        # 
        # This parameter is required.
        self.collection = collection
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The ID of the vector data upload job. You can call the `UpsertCollectionDataAsync` operation to query the job ID.
        # 
        # This parameter is required.
        self.job_id = job_id
        # The name of the namespace. Default value: public.
        # 
        # >  You can call the CreateNamespace operation to create a namespace and call the ListNamespaces operation to query a list of namespaces.
        self.namespace = namespace
        # The password of the namespace.
        # 
        # >  The value of this parameter is specified when you call the CreateNamespace operation.
        # 
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the workspace that consists of multiple AnalyticDB for PostgreSQL instances. You must specify one of the WorkspaceId and DBInstanceId parameters. If you specify both parameters, the WorkspaceId parameter takes effect.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CancelUpsertCollectionDataJobResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The status of the operation. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CancelUpsertCollectionDataJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelUpsertCollectionDataJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelUpsertCollectionDataJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckHadoopDataSourceRequest(TeaModel):
    def __init__(
        self,
        check_dir: str = None,
        dbinstance_id: str = None,
        data_source_id: str = None,
        region_id: str = None,
    ):
        # The Hadoop path that you want to check.
        # 
        # This parameter is required.
        self.check_dir = check_dir
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The data source ID.
        # 
        # This parameter is required.
        self.data_source_id = data_source_id
        # The region ID.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_dir is not None:
            result['CheckDir'] = self.check_dir
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckDir') is not None:
            self.check_dir = m.get('CheckDir')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CheckHadoopDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The returned message. If the service failed, an error message is returned. Otherwise, a pair of double quotation marks ("") is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The status of the service. Valid values:
        # 
        # *   Running
        # *   Failed
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CheckHadoopDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckHadoopDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckHadoopDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckHadoopNetConnectionRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_id: str = None,
        emr_instance_id: str = None,
        region_id: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # 1. Either DataSourceId or EmrInstanceId must be specified as input, otherwise an error will occur.
        # 2. If both of the above parameters are specified, EmrInstanceId will be used preferentially.
        # 3. If the data source specified by DataSourceId is a self-built Hadoop cluster, an error will occur directly.
        self.data_source_id = data_source_id
        # EMR instance ID.
        self.emr_instance_id = emr_instance_id
        # Region ID.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.emr_instance_id is not None:
            result['EmrInstanceId'] = self.emr_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('EmrInstanceId') is not None:
            self.emr_instance_id = m.get('EmrInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CheckHadoopNetConnectionResponseBody(TeaModel):
    def __init__(
        self,
        connection_message: str = None,
        connection_status: str = None,
        request_id: str = None,
    ):
        # Return message: Returns error information if the connection fails, otherwise returns an empty string ("").
        self.connection_message = connection_message
        # Connection status:
        # 
        # - Network connected: Success
        # 
        # - Network not connected: Failed
        self.connection_status = connection_status
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_message is not None:
            result['ConnectionMessage'] = self.connection_message
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionMessage') is not None:
            self.connection_message = m.get('ConnectionMessage')
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckHadoopNetConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckHadoopNetConnectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckHadoopNetConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckJDBCSourceNetConnectionRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_id: str = None,
        jdbc_connection_string: str = None,
        region_id: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Either DataSourceId or JdbcConnectionString must be specified as input, otherwise an error will occur. If both parameters are specified, JdbcConnectionString will be used preferentially.
        self.data_source_id = data_source_id
        # JDBC connection string.
        self.jdbc_connection_string = jdbc_connection_string
        # The ID of the region where the instance is located.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.jdbc_connection_string is not None:
            result['JdbcConnectionString'] = self.jdbc_connection_string
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('JdbcConnectionString') is not None:
            self.jdbc_connection_string = m.get('JdbcConnectionString')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CheckJDBCSourceNetConnectionResponseBody(TeaModel):
    def __init__(
        self,
        connection_message: str = None,
        connection_status: str = None,
        request_id: str = None,
    ):
        # Return message: Error message returned when the connection fails, otherwise returns an empty string ("").
        self.connection_message = connection_message
        # Service status:
        # 
        # - Network connected: Success
        # 
        # - Network not connected: Failed
        self.connection_status = connection_status
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_message is not None:
            result['ConnectionMessage'] = self.connection_message
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionMessage') is not None:
            self.connection_message = m.get('ConnectionMessage')
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckJDBCSourceNetConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckJDBCSourceNetConnectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckJDBCSourceNetConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckServiceLinkedRoleRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        # The ID of the region. You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CheckServiceLinkedRoleResponseBody(TeaModel):
    def __init__(
        self,
        has_service_linked_role: str = None,
        region_id: str = None,
        request_id: str = None,
    ):
        # Indicates whether an SLR is created.
        self.has_service_linked_role = has_service_linked_role
        # The ID of the region.
        self.region_id = region_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_service_linked_role is not None:
            result['HasServiceLinkedRole'] = self.has_service_linked_role
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HasServiceLinkedRole') is not None:
            self.has_service_linked_role = m.get('HasServiceLinkedRole')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckServiceLinkedRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckServiceLinkedRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneDBInstanceRequest(TeaModel):
    def __init__(
        self,
        backup_id: str = None,
        dbinstance_id: str = None,
        src_db_instance_name: str = None,
    ):
        # This parameter is required.
        self.backup_id = backup_id
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # This parameter is required.
        self.src_db_instance_name = src_db_instance_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.src_db_instance_name is not None:
            result['SrcDbInstanceName'] = self.src_db_instance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('SrcDbInstanceName') is not None:
            self.src_db_instance_name = m.get('SrcDbInstanceName')
        return self


class CloneDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloneDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CloneDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloneDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAccountRequest(TeaModel):
    def __init__(
        self,
        account_description: str = None,
        account_name: str = None,
        account_password: str = None,
        account_type: str = None,
        dbinstance_id: str = None,
        database_name: str = None,
        owner_id: int = None,
    ):
        # The description of the initial account.
        self.account_description = account_description
        # The name of the initial account.
        # 
        # *   The name can contain lowercase letters, digits, and underscores (_).
        # *   The name must start with a lowercase letter and end with a lowercase letter or a digit.
        # *   The name cannot start with gp.
        # *   The name must be 2 to 16 characters in length.
        # 
        # This parameter is required.
        self.account_name = account_name
        # The password of the initial account.
        # *   The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters.
        # *   Special characters include `! @ # $ % ^ & * ( ) _ + - =`
        # *   The password must be 8 to 32 characters in length.
        # 
        # This parameter is required.
        self.account_password = account_password
        # The type of the initial account. Default value: Super, which specifies a privileged account. To create a standard account, set the value to Normal.
        self.account_type = account_type
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database_name = database_name
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_description is not None:
            result['AccountDescription'] = self.account_description
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountDescription') is not None:
            self.account_description = m.get('AccountDescription')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class CreateAccountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAccountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class CreateBackupResponseBody(TeaModel):
    def __init__(
        self,
        backup_job_id: int = None,
        request_id: str = None,
    ):
        self.backup_job_id = backup_job_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBackupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBackupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCollectionRequestSparseVectorIndexConfig(TeaModel):
    def __init__(
        self,
        hnsw_ef_construction: int = None,
        hnsw_m: int = None,
    ):
        self.hnsw_ef_construction = hnsw_ef_construction
        self.hnsw_m = hnsw_m

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hnsw_ef_construction is not None:
            result['HnswEfConstruction'] = self.hnsw_ef_construction
        if self.hnsw_m is not None:
            result['HnswM'] = self.hnsw_m
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HnswEfConstruction') is not None:
            self.hnsw_ef_construction = m.get('HnswEfConstruction')
        if m.get('HnswM') is not None:
            self.hnsw_m = m.get('HnswM')
        return self


class CreateCollectionRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        dimension: int = None,
        external_storage: int = None,
        full_text_retrieval_fields: str = None,
        hnsw_ef_construction: str = None,
        hnsw_m: int = None,
        manager_account: str = None,
        manager_account_password: str = None,
        metadata: str = None,
        metadata_indices: str = None,
        metrics: str = None,
        namespace: str = None,
        owner_id: int = None,
        parser: str = None,
        pq_enable: int = None,
        region_id: str = None,
        sparse_vector_index_config: CreateCollectionRequestSparseVectorIndexConfig = None,
        support_sparse: bool = None,
        workspace_id: str = None,
    ):
        # The name of the collection that you want to create.
        # 
        # >  The name must comply with the naming conventions of PostgreSQL objects.
        # 
        # This parameter is required.
        self.collection = collection
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        self.dbinstance_id = dbinstance_id
        # The number of vector dimensions.
        # 
        # >  If you specify this parameter, an index is created. When you call the [UpsertCollectionData](https://help.aliyun.com/document_detail/2401493.html) operation, make sure that the length of the Rows.Vector parameter is the same as the value of this parameter. If you do not specify this parameter, you can call the [CreateVectorIndex](https://help.aliyun.com/document_detail/2401499.html) operation to create an index.
        self.dimension = dimension
        # Specifies whether to use the memory mapping technology to create HNSW indexes. Valid values: 0 and 1. Default value: 0. We recommend that you set the value to 1 in scenarios that require upload speed but not data deletion.
        # 
        # > 
        # 
        # *   0: uses segmented paging storage to create indexes. This method uses the shared buffer of PostgreSQL for caching and supports the delete and update operations.
        # 
        # *   1: uses the memory mapping technology to create indexes. This method does not support the delete or update operation.
        self.external_storage = external_storage
        # The fields used for full-text search. Separate multiple fields with commas (,). These fields must be keys defined in Metadata.
        self.full_text_retrieval_fields = full_text_retrieval_fields
        self.hnsw_ef_construction = hnsw_ef_construction
        # The maximum number of neighbors for the Hierarchical Navigable Small World (HNSW) algorithm. Valid values: 1 to 1000. In most cases, this parameter is automatically configured based on the value of the Dimension parameter. You do not need to configure this parameter.
        # 
        # >  We recommend that you configure this parameter based on the value of the Dimension parameter.
        # 
        # *If you set Dimension to a value less than or equal to 384, set the value of HnswM to 16.
        # 
        # *If you set Dimension to a value greater than 384 and less than or equal to 768, set the value of HnswM to 32.
        # 
        # *If you set Dimension to a value greater than 768 and less than or equal to 1024, set the value of HnswM to 64.
        # 
        # *If you set Dimension to a value greater than 1024, set the value of HnswM to 128.
        self.hnsw_m = hnsw_m
        # Name of the management account with rds_superuser permissions.
        # 
        # > You can create an account through the console -> Account Management, or by using the [CreateAccount](https://help.aliyun.com/document_detail/2361789.html) API.
        # 
        # This parameter is required.
        self.manager_account = manager_account
        # The password of the manager account.
        # 
        # This parameter is required.
        self.manager_account_password = manager_account_password
        # The metadata of the vector data, which is a JSON string in the MAP format. The key specifies the field name, and the value specifies the data type.
        # 
        # >  Supported data types:
        # 
        # *   For information about the supported data types, see [Data types](https://www.alibabacloud.com/help/zh/analyticdb/analyticdb-for-postgresql/developer-reference/data-types-1/).
        # 
        # *   The money data type is not supported.
        # 
        # **\
        # 
        # **Warning** Reserved fields such as id, vector, to_tsvector, and source cannot be used.
        # 
        # This parameter is required.
        self.metadata = metadata
        # The scalar index fields. Separate multiple fields with commas (,). These fields must be keys defined in Metadata.
        self.metadata_indices = metadata_indices
        # The method that is used to create vector indexes. Valid values:
        # 
        # *   l2: Euclidean distance.
        # *   ip: inner product distance.
        # *   cosine: cosine similarity.
        self.metrics = metrics
        # The name of the namespace.
        # 
        # >  You can call the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) operation to create a namespace and call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        self.namespace = namespace
        self.owner_id = owner_id
        # The analyzer that is used for full-text search.
        self.parser = parser
        # Specifies whether to enable the product quantization (PQ) feature for index acceleration. We recommend that you enable this feature for more than 500,000 rows of data. Valid values:
        # 
        # *   0: no.
        # *   1 (default): yes.
        self.pq_enable = pq_enable
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.sparse_vector_index_config = sparse_vector_index_config
        self.support_sparse = support_sparse
        # The ID of the workspace that consists of multiple AnalyticDB for PostgreSQL instances. You must specify one of the WorkspaceId and DBInstanceId parameters. If you specify both parameters, the WorkspaceId parameter takes effect.
        self.workspace_id = workspace_id

    def validate(self):
        if self.sparse_vector_index_config:
            self.sparse_vector_index_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.external_storage is not None:
            result['ExternalStorage'] = self.external_storage
        if self.full_text_retrieval_fields is not None:
            result['FullTextRetrievalFields'] = self.full_text_retrieval_fields
        if self.hnsw_ef_construction is not None:
            result['HnswEfConstruction'] = self.hnsw_ef_construction
        if self.hnsw_m is not None:
            result['HnswM'] = self.hnsw_m
        if self.manager_account is not None:
            result['ManagerAccount'] = self.manager_account
        if self.manager_account_password is not None:
            result['ManagerAccountPassword'] = self.manager_account_password
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.metadata_indices is not None:
            result['MetadataIndices'] = self.metadata_indices
        if self.metrics is not None:
            result['Metrics'] = self.metrics
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parser is not None:
            result['Parser'] = self.parser
        if self.pq_enable is not None:
            result['PqEnable'] = self.pq_enable
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.sparse_vector_index_config is not None:
            result['SparseVectorIndexConfig'] = self.sparse_vector_index_config.to_map()
        if self.support_sparse is not None:
            result['SupportSparse'] = self.support_sparse
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('ExternalStorage') is not None:
            self.external_storage = m.get('ExternalStorage')
        if m.get('FullTextRetrievalFields') is not None:
            self.full_text_retrieval_fields = m.get('FullTextRetrievalFields')
        if m.get('HnswEfConstruction') is not None:
            self.hnsw_ef_construction = m.get('HnswEfConstruction')
        if m.get('HnswM') is not None:
            self.hnsw_m = m.get('HnswM')
        if m.get('ManagerAccount') is not None:
            self.manager_account = m.get('ManagerAccount')
        if m.get('ManagerAccountPassword') is not None:
            self.manager_account_password = m.get('ManagerAccountPassword')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('MetadataIndices') is not None:
            self.metadata_indices = m.get('MetadataIndices')
        if m.get('Metrics') is not None:
            self.metrics = m.get('Metrics')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Parser') is not None:
            self.parser = m.get('Parser')
        if m.get('PqEnable') is not None:
            self.pq_enable = m.get('PqEnable')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SparseVectorIndexConfig') is not None:
            temp_model = CreateCollectionRequestSparseVectorIndexConfig()
            self.sparse_vector_index_config = temp_model.from_map(m['SparseVectorIndexConfig'])
        if m.get('SupportSparse') is not None:
            self.support_sparse = m.get('SupportSparse')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreateCollectionShrinkRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        dimension: int = None,
        external_storage: int = None,
        full_text_retrieval_fields: str = None,
        hnsw_ef_construction: str = None,
        hnsw_m: int = None,
        manager_account: str = None,
        manager_account_password: str = None,
        metadata: str = None,
        metadata_indices: str = None,
        metrics: str = None,
        namespace: str = None,
        owner_id: int = None,
        parser: str = None,
        pq_enable: int = None,
        region_id: str = None,
        sparse_vector_index_config_shrink: str = None,
        support_sparse: bool = None,
        workspace_id: str = None,
    ):
        # The name of the collection that you want to create.
        # 
        # >  The name must comply with the naming conventions of PostgreSQL objects.
        # 
        # This parameter is required.
        self.collection = collection
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        self.dbinstance_id = dbinstance_id
        # The number of vector dimensions.
        # 
        # >  If you specify this parameter, an index is created. When you call the [UpsertCollectionData](https://help.aliyun.com/document_detail/2401493.html) operation, make sure that the length of the Rows.Vector parameter is the same as the value of this parameter. If you do not specify this parameter, you can call the [CreateVectorIndex](https://help.aliyun.com/document_detail/2401499.html) operation to create an index.
        self.dimension = dimension
        # Specifies whether to use the memory mapping technology to create HNSW indexes. Valid values: 0 and 1. Default value: 0. We recommend that you set the value to 1 in scenarios that require upload speed but not data deletion.
        # 
        # > 
        # 
        # *   0: uses segmented paging storage to create indexes. This method uses the shared buffer of PostgreSQL for caching and supports the delete and update operations.
        # 
        # *   1: uses the memory mapping technology to create indexes. This method does not support the delete or update operation.
        self.external_storage = external_storage
        # The fields used for full-text search. Separate multiple fields with commas (,). These fields must be keys defined in Metadata.
        self.full_text_retrieval_fields = full_text_retrieval_fields
        self.hnsw_ef_construction = hnsw_ef_construction
        # The maximum number of neighbors for the Hierarchical Navigable Small World (HNSW) algorithm. Valid values: 1 to 1000. In most cases, this parameter is automatically configured based on the value of the Dimension parameter. You do not need to configure this parameter.
        # 
        # >  We recommend that you configure this parameter based on the value of the Dimension parameter.
        # 
        # *If you set Dimension to a value less than or equal to 384, set the value of HnswM to 16.
        # 
        # *If you set Dimension to a value greater than 384 and less than or equal to 768, set the value of HnswM to 32.
        # 
        # *If you set Dimension to a value greater than 768 and less than or equal to 1024, set the value of HnswM to 64.
        # 
        # *If you set Dimension to a value greater than 1024, set the value of HnswM to 128.
        self.hnsw_m = hnsw_m
        # Name of the management account with rds_superuser permissions.
        # 
        # > You can create an account through the console -> Account Management, or by using the [CreateAccount](https://help.aliyun.com/document_detail/2361789.html) API.
        # 
        # This parameter is required.
        self.manager_account = manager_account
        # The password of the manager account.
        # 
        # This parameter is required.
        self.manager_account_password = manager_account_password
        # The metadata of the vector data, which is a JSON string in the MAP format. The key specifies the field name, and the value specifies the data type.
        # 
        # >  Supported data types:
        # 
        # *   For information about the supported data types, see [Data types](https://www.alibabacloud.com/help/zh/analyticdb/analyticdb-for-postgresql/developer-reference/data-types-1/).
        # 
        # *   The money data type is not supported.
        # 
        # **\
        # 
        # **Warning** Reserved fields such as id, vector, to_tsvector, and source cannot be used.
        # 
        # This parameter is required.
        self.metadata = metadata
        # The scalar index fields. Separate multiple fields with commas (,). These fields must be keys defined in Metadata.
        self.metadata_indices = metadata_indices
        # The method that is used to create vector indexes. Valid values:
        # 
        # *   l2: Euclidean distance.
        # *   ip: inner product distance.
        # *   cosine: cosine similarity.
        self.metrics = metrics
        # The name of the namespace.
        # 
        # >  You can call the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) operation to create a namespace and call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        self.namespace = namespace
        self.owner_id = owner_id
        # The analyzer that is used for full-text search.
        self.parser = parser
        # Specifies whether to enable the product quantization (PQ) feature for index acceleration. We recommend that you enable this feature for more than 500,000 rows of data. Valid values:
        # 
        # *   0: no.
        # *   1 (default): yes.
        self.pq_enable = pq_enable
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.sparse_vector_index_config_shrink = sparse_vector_index_config_shrink
        self.support_sparse = support_sparse
        # The ID of the workspace that consists of multiple AnalyticDB for PostgreSQL instances. You must specify one of the WorkspaceId and DBInstanceId parameters. If you specify both parameters, the WorkspaceId parameter takes effect.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.external_storage is not None:
            result['ExternalStorage'] = self.external_storage
        if self.full_text_retrieval_fields is not None:
            result['FullTextRetrievalFields'] = self.full_text_retrieval_fields
        if self.hnsw_ef_construction is not None:
            result['HnswEfConstruction'] = self.hnsw_ef_construction
        if self.hnsw_m is not None:
            result['HnswM'] = self.hnsw_m
        if self.manager_account is not None:
            result['ManagerAccount'] = self.manager_account
        if self.manager_account_password is not None:
            result['ManagerAccountPassword'] = self.manager_account_password
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.metadata_indices is not None:
            result['MetadataIndices'] = self.metadata_indices
        if self.metrics is not None:
            result['Metrics'] = self.metrics
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parser is not None:
            result['Parser'] = self.parser
        if self.pq_enable is not None:
            result['PqEnable'] = self.pq_enable
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.sparse_vector_index_config_shrink is not None:
            result['SparseVectorIndexConfig'] = self.sparse_vector_index_config_shrink
        if self.support_sparse is not None:
            result['SupportSparse'] = self.support_sparse
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('ExternalStorage') is not None:
            self.external_storage = m.get('ExternalStorage')
        if m.get('FullTextRetrievalFields') is not None:
            self.full_text_retrieval_fields = m.get('FullTextRetrievalFields')
        if m.get('HnswEfConstruction') is not None:
            self.hnsw_ef_construction = m.get('HnswEfConstruction')
        if m.get('HnswM') is not None:
            self.hnsw_m = m.get('HnswM')
        if m.get('ManagerAccount') is not None:
            self.manager_account = m.get('ManagerAccount')
        if m.get('ManagerAccountPassword') is not None:
            self.manager_account_password = m.get('ManagerAccountPassword')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('MetadataIndices') is not None:
            self.metadata_indices = m.get('MetadataIndices')
        if m.get('Metrics') is not None:
            self.metrics = m.get('Metrics')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Parser') is not None:
            self.parser = m.get('Parser')
        if m.get('PqEnable') is not None:
            self.pq_enable = m.get('PqEnable')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SparseVectorIndexConfig') is not None:
            self.sparse_vector_index_config_shrink = m.get('SparseVectorIndexConfig')
        if m.get('SupportSparse') is not None:
            self.support_sparse = m.get('SupportSparse')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreateCollectionResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The status of the operation. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateCollectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCollectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCollectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBInstanceRequestAINodeSpecInfos(TeaModel):
    def __init__(
        self,
        ainode_num: str = None,
        ainode_spec: str = None,
    ):
        self.ainode_num = ainode_num
        self.ainode_spec = ainode_spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ainode_num is not None:
            result['AINodeNum'] = self.ainode_num
        if self.ainode_spec is not None:
            result['AINodeSpec'] = self.ainode_spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AINodeNum') is not None:
            self.ainode_num = m.get('AINodeNum')
        if m.get('AINodeSpec') is not None:
            self.ainode_spec = m.get('AINodeSpec')
        return self


class CreateDBInstanceRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # Tag key. The restrictions are as follows:
        # 
        # - It cannot be an empty string.
        # - It supports up to 128 characters.
        # - It cannot start with `aliyun` or `acs:`, and it cannot contain `http://` or `https://`.
        self.key = key
        # Tag value. The restrictions are as follows:
        # 
        # - It can be an empty string.
        # - It supports up to 128 characters.
        # - It cannot start with `acs:`, and it cannot contain `http://` or `https://`.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDBInstanceRequest(TeaModel):
    def __init__(
        self,
        ainode_spec_infos: List[CreateDBInstanceRequestAINodeSpecInfos] = None,
        backup_id: str = None,
        cache_storage_size: str = None,
        client_token: str = None,
        create_sample_data: bool = None,
        dbinstance_category: str = None,
        dbinstance_class: str = None,
        dbinstance_description: str = None,
        dbinstance_group_count: str = None,
        dbinstance_mode: str = None,
        deploy_mode: str = None,
        enable_ssl: bool = None,
        encryption_key: str = None,
        encryption_type: str = None,
        engine: str = None,
        engine_version: str = None,
        idle_time: int = None,
        instance_network_type: str = None,
        instance_spec: str = None,
        master_aispec: str = None,
        master_cu: int = None,
        master_node_num: str = None,
        owner_id: int = None,
        pay_type: str = None,
        period: str = None,
        private_ip_address: str = None,
        prod_type: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        security_iplist: str = None,
        seg_disk_performance_level: str = None,
        seg_node_num: str = None,
        seg_storage_type: str = None,
        serverless_mode: str = None,
        serverless_resource: int = None,
        src_db_instance_name: str = None,
        standby_vswitch_id: str = None,
        standby_zone_id: str = None,
        storage_size: int = None,
        storage_type: str = None,
        tag: List[CreateDBInstanceRequestTag] = None,
        used_time: str = None,
        vpcid: str = None,
        v_switch_id: str = None,
        vector_configuration_status: str = None,
        zone_id: str = None,
    ):
        self.ainode_spec_infos = ainode_spec_infos
        # Backup set ID.
        # 
        # > You can call the [DescribeDataBackups](https://help.aliyun.com/document_detail/210093.html) interface to view the backup set IDs of all backup sets under the target instance.
        self.backup_id = backup_id
        self.cache_storage_size = cache_storage_size
        # Idempotence check. For more information, see [How to Ensure Idempotence](https://help.aliyun.com/document_detail/327176.html).
        self.client_token = client_token
        # Whether to load sample datasets after the instance is created. The values are as follows:
        # 
        # - **true**: Load sample datasets.
        # - **false**: Do not load sample datasets.
        # 
        # > If this parameter is not specified, it defaults to not loading sample datasets.
        self.create_sample_data = create_sample_data
        # Instance series. The value description is as follows:
        # 
        # - **HighAvailability**: High availability version.
        # - **Basic**: Basic version.
        # 
        # > This parameter is required when creating an instance in the storage elastic mode.
        self.dbinstance_category = dbinstance_category
        # Instance type. For more details, see the supplementary description of the DBInstanceClass parameter.
        # 
        # > This parameter is required when creating a reserved storage mode instance.
        self.dbinstance_class = dbinstance_class
        # Instance description.
        self.dbinstance_description = dbinstance_description
        # Number of compute groups. The values are: 2, 4, 8, 12, 16, 24, 32, 64, 96, 128.
        # 
        # > This parameter is required when creating a reserved storage mode instance.
        self.dbinstance_group_count = dbinstance_group_count
        # Instance resource type. The value description is as follows:
        # 
        # - **StorageElastic**: Storage elastic mode.
        # - **Serverless**: Serverless mode.
        # - **Classic**: Storage reserved mode.
        # 
        # > This parameter is required.
        # 
        # This parameter is required.
        self.dbinstance_mode = dbinstance_mode
        # Deployment mode. The values are as follows:
        # - multiple: Multi-zone deployment.
        # - single: Single-zone deployment.
        # 
        # > 
        # > - If this parameter is not specified, the default value is single-zone deployment.
        # > - Currently, only single-zone deployment is supported.
        self.deploy_mode = deploy_mode
        # Specifies whether to enable SSL encryption. Valid values:
        # 
        # *   **true**\
        # *   **false** (default)
        self.enable_ssl = enable_ssl
        # Key ID.
        # 
        # > If the value of the **EncryptionType** parameter is **CloudDisk**, you need to specify the encryption key ID within the same region through this parameter; otherwise, it should be empty.
        self.encryption_key = encryption_key
        # Encryption type. The value description is as follows:
        # 
        # - **NULL**: No encryption (default).
        # - **CloudDisk**: Enable cloud disk encryption and specify the key through the **EncryptionKey** parameter.
        # 
        # > Once cloud disk encryption is enabled, it cannot be disabled.
        self.encryption_type = encryption_type
        # Database engine, with the value **gpdb**.
        # 
        # This parameter is required.
        self.engine = engine
        # Engine version. The values are as follows:
        # - **6.0**: Version 6.0.
        # - **7.0**: Version 7.0.
        # 
        # This parameter is required.
        self.engine_version = engine_version
        # The idle release wait time. When the duration without business traffic reaches the specified time, the instance will enter the idle state. The unit is seconds, with a minimum value of 60, and the default value is 600.
        # 
        # > This parameter is required only for Serverless auto-scheduling mode instances.
        self.idle_time = idle_time
        # Instance network type, with the value **VPC**.
        # 
        # > - Only VPC networks are supported in public cloud.
        # > - If not specified, it defaults to VPC type.
        self.instance_network_type = instance_network_type
        # Compute node specifications.
        # 
        # For high-availability versions of the elastic storage mode, the values are as follows:
        # - **2C16G**\
        # - **4C32G**\
        # - **16C128G**\
        # 
        # For basic versions of the elastic storage mode, the values are as follows:
        # - **2C8G**\
        # - **4C16G**\
        # - **8C32G**\
        # - **16C64G**\
        # 
        # For Serverless mode, the values are as follows:
        # - **4C16G**\
        # - **8C32G**\
        # 
        # > This parameter is required when creating an elastic storage mode instance or a Serverless mode instance.
        self.instance_spec = instance_spec
        # This parameter must be specified if you want to change coordinator nodes to AI coordinator nodes.
        # 
        # >-  You cannot specify the MasterAISpec and MasterCU parameters at the same time.
        # >- You can change coordinator nodes to AI coordinator nodes only in specific regions and zones.
        # >- Only AnalyticDB for PostgreSQL V7.0 instances of Basic Edition support AI coordinator nodes.
        # >- You can view the valid values of this parameter on the configuration change page of coordinator nodes.
        self.master_aispec = master_aispec
        # Master resources, with the following values: 
        # - 2 CU 
        # - 4 CU 
        # - 8 CU 
        # - 16 CU 
        # - 32 CU 
        # > Master resources above 8 CU will incur charges.
        self.master_cu = master_cu
        # This parameter is deprecated and should not be passed.
        self.master_node_num = master_node_num
        self.owner_id = owner_id
        # The billing method of the instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go.
        # *   **Prepaid**: subscription.
        # 
        # > 
        # 
        # *   If you do not specify this parameter, Postpaid is used.
        # 
        # *   You can obtain more cost savings if you create a subscription instance for one year or longer. We recommend that you select the billing method that best suits your needs.
        self.pay_type = pay_type
        # Unit of the duration for which resources are purchased. The values are as follows:
        # - **Month**: Month
        # - **Year**: Year
        # 
        # > This parameter is required when creating a subscription-billed instance.
        self.period = period
        # This parameter is deprecated and should not be passed.
        self.private_ip_address = private_ip_address
        # Product type. The values are as follows:
        # - **standard**: Standard Edition.
        # - **cost-effective**: Cost-Effective Edition.
        # 
        # > If this parameter is not specified, the default value is Standard Edition.
        self.prod_type = prod_type
        # Region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) interface to view available region IDs.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the enterprise resource group where the instance is located.
        self.resource_group_id = resource_group_id
        # The IP address whitelist of the instance.
        # 
        # A value of 127.0.0.1 denies access from any external IP address. You can call the [ModifySecurityIps](https://help.aliyun.com/document_detail/86928.html) operation to modify the IP address whitelist after you create an instance.
        self.security_iplist = security_iplist
        # The performance level of ESSDs. Valid values:
        # 
        # *   **pl0**\
        # *   **pl1**\
        # *   **pl2**\
        # 
        # > 
        # 
        # *   This parameter takes effect only when SegStorageType is set to cloud_essd.
        # 
        # *   If you do not specify this parameter, pl1 is used.
        self.seg_disk_performance_level = seg_disk_performance_level
        # The number of compute nodes. The value description is as follows:
        # 
        # - For the high-availability version of the storage elastic mode, the value range is 4 to 512, and the value must be a multiple of 4.
        # - For the basic version of the storage elastic mode, the value range is 2 to 512, and the value must be a multiple of 2.
        # - For the Serverless mode, the value range is 2 to 512, and the value must be a multiple of 2.
        # 
        # > This parameter is required when creating instances in the storage elastic mode or Serverless mode.
        self.seg_node_num = seg_node_num
        # Disk storage type, currently only ESSD cloud disks are supported, with the value **cloud_essd**.
        # 
        # > This parameter is required when creating an elastic storage mode instance.
        self.seg_storage_type = seg_storage_type
        # The mode of the Serverless instance. The values are as follows:
        # 
        # - **Manual**: Manual scheduling (default).
        # - **Auto**: Auto scheduling.
        # 
        # > This parameter is required only for Serverless mode instances.
        self.serverless_mode = serverless_mode
        # The threshold for computing resources. The value range is 8 to 32, with a step of 8, and the unit is ACU. The default value is 32.
        # 
        # > This parameter is required only for Serverless auto-scheduling mode instances.
        self.serverless_resource = serverless_resource
        # ID of the source instance to be cloned.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) interface to view details of all AnalyticDB for PostgreSQL instances in the target region, including the instance ID.
        self.src_db_instance_name = src_db_instance_name
        # VSwitch ID of the standby zone.
        # 
        # > 
        # > - This parameter is required for multi-zone deployment.
        # > - The VSwitch ID of the standby zone must be in the same zone as the StandbyZoneId.
        self.standby_vswitch_id = standby_vswitch_id
        # ID of the standby zone.
        # 
        # > 
        # > - This parameter is required for multi-zone deployment.
        # > - You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) interface to view available zone IDs.
        # > - The ID of the standby zone must be different from the ID of the primary zone.
        self.standby_zone_id = standby_zone_id
        # The size of the storage space, in GB, with a value range of <props="china">50~8000<props="intl">50~6000.
        # 
        # > This parameter is required when creating an instance in the storage elastic mode.
        self.storage_size = storage_size
        # This parameter is deprecated and should not be passed.
        self.storage_type = storage_type
        # The Nth tag. The value of N ranges from 1 to 20.
        self.tag = tag
        # Duration for which resources are purchased. The values are as follows:
        # - When **Period** is **Month**, the value ranges from 1 to 9.
        # - When **Period** is **Year**, the value ranges from 1 to 3.
        # 
        # > This parameter is required when creating a subscription-billed instance.
        self.used_time = used_time
        # VPC ID.
        # 
        # > - **VPCId** is required.
        # > - The region of the **VPC** must be consistent with **RegionId**.
        self.vpcid = vpcid
        # vSwitch ID.
        # 
        # > - **vSwitchId** is required.
        # > - The availability zone of the **vSwitch** must be consistent with **ZoneId**.
        self.v_switch_id = v_switch_id
        # Whether to enable vector engine optimization. The value description is as follows:
        # - **enabled**: Enable vector engine optimization.
        # - **disabled** (default): Do not enable vector engine optimization.
        # 
        # > - For mainstream analysis scenarios, data warehouse scenarios, and real-time data warehouse scenarios, it is recommended to **not enable** vector engine optimization.
        # > - For users using the vector analysis engine for AIGC, vector retrieval, and other scenarios, it is recommended to **enable** vector engine optimization.
        self.vector_configuration_status = vector_configuration_status
        # Zone ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) interface to view available zone IDs.
        # 
        # This parameter is required.
        self.zone_id = zone_id

    def validate(self):
        if self.ainode_spec_infos:
            for k in self.ainode_spec_infos:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AINodeSpecInfos'] = []
        if self.ainode_spec_infos is not None:
            for k in self.ainode_spec_infos:
                result['AINodeSpecInfos'].append(k.to_map() if k else None)
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.cache_storage_size is not None:
            result['CacheStorageSize'] = self.cache_storage_size
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.create_sample_data is not None:
            result['CreateSampleData'] = self.create_sample_data
        if self.dbinstance_category is not None:
            result['DBInstanceCategory'] = self.dbinstance_category
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_group_count is not None:
            result['DBInstanceGroupCount'] = self.dbinstance_group_count
        if self.dbinstance_mode is not None:
            result['DBInstanceMode'] = self.dbinstance_mode
        if self.deploy_mode is not None:
            result['DeployMode'] = self.deploy_mode
        if self.enable_ssl is not None:
            result['EnableSSL'] = self.enable_ssl
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        if self.encryption_type is not None:
            result['EncryptionType'] = self.encryption_type
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.idle_time is not None:
            result['IdleTime'] = self.idle_time
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.master_aispec is not None:
            result['MasterAISpec'] = self.master_aispec
        if self.master_cu is not None:
            result['MasterCU'] = self.master_cu
        if self.master_node_num is not None:
            result['MasterNodeNum'] = self.master_node_num
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.prod_type is not None:
            result['ProdType'] = self.prod_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.seg_disk_performance_level is not None:
            result['SegDiskPerformanceLevel'] = self.seg_disk_performance_level
        if self.seg_node_num is not None:
            result['SegNodeNum'] = self.seg_node_num
        if self.seg_storage_type is not None:
            result['SegStorageType'] = self.seg_storage_type
        if self.serverless_mode is not None:
            result['ServerlessMode'] = self.serverless_mode
        if self.serverless_resource is not None:
            result['ServerlessResource'] = self.serverless_resource
        if self.src_db_instance_name is not None:
            result['SrcDbInstanceName'] = self.src_db_instance_name
        if self.standby_vswitch_id is not None:
            result['StandbyVSwitchId'] = self.standby_vswitch_id
        if self.standby_zone_id is not None:
            result['StandbyZoneId'] = self.standby_zone_id
        if self.storage_size is not None:
            result['StorageSize'] = self.storage_size
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vector_configuration_status is not None:
            result['VectorConfigurationStatus'] = self.vector_configuration_status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ainode_spec_infos = []
        if m.get('AINodeSpecInfos') is not None:
            for k in m.get('AINodeSpecInfos'):
                temp_model = CreateDBInstanceRequestAINodeSpecInfos()
                self.ainode_spec_infos.append(temp_model.from_map(k))
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('CacheStorageSize') is not None:
            self.cache_storage_size = m.get('CacheStorageSize')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CreateSampleData') is not None:
            self.create_sample_data = m.get('CreateSampleData')
        if m.get('DBInstanceCategory') is not None:
            self.dbinstance_category = m.get('DBInstanceCategory')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceGroupCount') is not None:
            self.dbinstance_group_count = m.get('DBInstanceGroupCount')
        if m.get('DBInstanceMode') is not None:
            self.dbinstance_mode = m.get('DBInstanceMode')
        if m.get('DeployMode') is not None:
            self.deploy_mode = m.get('DeployMode')
        if m.get('EnableSSL') is not None:
            self.enable_ssl = m.get('EnableSSL')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        if m.get('EncryptionType') is not None:
            self.encryption_type = m.get('EncryptionType')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('IdleTime') is not None:
            self.idle_time = m.get('IdleTime')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('MasterAISpec') is not None:
            self.master_aispec = m.get('MasterAISpec')
        if m.get('MasterCU') is not None:
            self.master_cu = m.get('MasterCU')
        if m.get('MasterNodeNum') is not None:
            self.master_node_num = m.get('MasterNodeNum')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('ProdType') is not None:
            self.prod_type = m.get('ProdType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('SegDiskPerformanceLevel') is not None:
            self.seg_disk_performance_level = m.get('SegDiskPerformanceLevel')
        if m.get('SegNodeNum') is not None:
            self.seg_node_num = m.get('SegNodeNum')
        if m.get('SegStorageType') is not None:
            self.seg_storage_type = m.get('SegStorageType')
        if m.get('ServerlessMode') is not None:
            self.serverless_mode = m.get('ServerlessMode')
        if m.get('ServerlessResource') is not None:
            self.serverless_resource = m.get('ServerlessResource')
        if m.get('SrcDbInstanceName') is not None:
            self.src_db_instance_name = m.get('SrcDbInstanceName')
        if m.get('StandbyVSwitchId') is not None:
            self.standby_vswitch_id = m.get('StandbyVSwitchId')
        if m.get('StandbyZoneId') is not None:
            self.standby_zone_id = m.get('StandbyZoneId')
        if m.get('StorageSize') is not None:
            self.storage_size = m.get('StorageSize')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDBInstanceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VectorConfigurationStatus') is not None:
            self.vector_configuration_status = m.get('VectorConfigurationStatus')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        connection_string: str = None,
        dbinstance_id: str = None,
        order_id: str = None,
        port: str = None,
        request_id: str = None,
    ):
        # This parameter is deprecated and will not return a value.
        # 
        # You can use the [DescribeDBInstanceAttribute](https://help.aliyun.com/document_detail/86910.html) interface to view the connection address of the instance.
        self.connection_string = connection_string
        # Instance ID.
        self.dbinstance_id = dbinstance_id
        # Order ID.
        self.order_id = order_id
        # This parameter is deprecated and will not return a value.
        # 
        # You can use the [DescribeDBInstanceAttribute](https://help.aliyun.com/document_detail/86910.html) interface to view the port number of the instance.
        self.port = port
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.port is not None:
            result['Port'] = self.port
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBInstancePlanRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        plan_config: str = None,
        plan_desc: str = None,
        plan_end_date: str = None,
        plan_name: str = None,
        plan_schedule_type: str = None,
        plan_start_date: str = None,
        plan_type: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances within a region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The execution information of the plan. Specify the parameter in the JSON format. The parameter value varies based on the values of **PlanType** and **PlanScheduleType**. The following section describes the PlanConfig parameter.
        # 
        # This parameter is required.
        self.plan_config = plan_config
        # The description of the plan.
        self.plan_desc = plan_desc
        # The end time of the plan. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC. The end time must be later than the start time.
        # 
        # > 
        # 
        # *   This parameter must be specified only when **PlanScheduleType** is set to **Regular**.
        # 
        # *   If you do not specify this parameter, the plan stops until the plan is deleted.
        self.plan_end_date = plan_end_date
        # The name of the plan.
        # 
        # This parameter is required.
        self.plan_name = plan_name
        # The execution mode of the plan. Valid values:
        # 
        # *   **Postpone**: The plan is executed later.
        # *   **Regular**: The plan is executed periodically.
        # 
        # This parameter is required.
        self.plan_schedule_type = plan_schedule_type
        # The start time of the plan. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time must be in UTC.
        # 
        # > 
        # 
        # *   This parameter must be specified only when **PlanScheduleType** is set to **Regular**.
        # 
        # *   If you do not specify this parameter, the current time is used.
        self.plan_start_date = plan_start_date
        # The type of the plan. Valid values:
        # 
        # *   **PauseResume**: pauses and resumes an instance.
        # *   **Resize**: changes the number of compute nodes.
        # *   **ModifySpec**: changes compute node specifications.
        # 
        # > - You can specify the value to ModifySpec only for instances in elastic storage mode.
        # >- You can specify the value to ModifySpec only for instances in elastic storage mode.
        # 
        # This parameter is required.
        self.plan_type = plan_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.plan_config is not None:
            result['PlanConfig'] = self.plan_config
        if self.plan_desc is not None:
            result['PlanDesc'] = self.plan_desc
        if self.plan_end_date is not None:
            result['PlanEndDate'] = self.plan_end_date
        if self.plan_name is not None:
            result['PlanName'] = self.plan_name
        if self.plan_schedule_type is not None:
            result['PlanScheduleType'] = self.plan_schedule_type
        if self.plan_start_date is not None:
            result['PlanStartDate'] = self.plan_start_date
        if self.plan_type is not None:
            result['PlanType'] = self.plan_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlanConfig') is not None:
            self.plan_config = m.get('PlanConfig')
        if m.get('PlanDesc') is not None:
            self.plan_desc = m.get('PlanDesc')
        if m.get('PlanEndDate') is not None:
            self.plan_end_date = m.get('PlanEndDate')
        if m.get('PlanName') is not None:
            self.plan_name = m.get('PlanName')
        if m.get('PlanScheduleType') is not None:
            self.plan_schedule_type = m.get('PlanScheduleType')
        if m.get('PlanStartDate') is not None:
            self.plan_start_date = m.get('PlanStartDate')
        if m.get('PlanType') is not None:
            self.plan_type = m.get('PlanType')
        return self


class CreateDBInstancePlanResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        error_message: str = None,
        plan_id: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The error message.
        # 
        # This parameter is returned only if the request fails.
        self.error_message = error_message
        # The plan ID.
        self.plan_id = plan_id
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        # 
        # If the request was successful, **success** is returned. If the request failed, this parameter is not returned.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateDBInstancePlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDBInstancePlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDBInstancePlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBResourceGroupRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        resource_group_config: str = None,
        resource_group_name: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The configurations of the resource group.
        # 
        # > 
        # 
        # *   CpuRateLimit: the percentage of CPU resources that are available for the resource group. Unit: %.
        # 
        # *   MemoryLimit: the percentage of memory resources that are available for the resource group. Unit: %.
        # 
        # *   MemorySharedQuota: the percentage of memory resources shared among transactions that are submitted to the resource group. Unit: %. Default value: 80.
        # 
        # *   MemorySpillRatio: the memory spill ratio for memory-intensive transactions. When the memory that is used by memory-intensive transactions reaches this value, data is spilled to disks. Unit: %. Default value: 0.
        # 
        # *   Concurrency: the maximum number of concurrent transactions or parallel queries that are allowed for a resource group. Default value: 20.
        # 
        # This parameter is required.
        self.resource_group_config = resource_group_config
        # The name of the resource group.
        # 
        # This parameter is required.
        self.resource_group_name = resource_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_config is not None:
            result['ResourceGroupConfig'] = self.resource_group_config
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupConfig') is not None:
            self.resource_group_config = m.get('ResourceGroupConfig')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        return self


class CreateDBResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDBResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDBResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDBResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDocumentCollectionRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        dimension: int = None,
        embedding_model: str = None,
        enable_graph: bool = None,
        entity_types: List[str] = None,
        external_storage: int = None,
        full_text_retrieval_fields: str = None,
        hnsw_ef_construction: str = None,
        hnsw_m: int = None,
        llmmodel: str = None,
        language: str = None,
        manager_account: str = None,
        manager_account_password: str = None,
        metadata: str = None,
        metadata_indices: str = None,
        metrics: str = None,
        namespace: str = None,
        owner_id: int = None,
        parser: str = None,
        pq_enable: int = None,
        region_id: str = None,
        relationship_types: List[str] = None,
    ):
        # The name of the document collection that you want to create.
        # 
        # > The name must comply with PostgreSQL object naming restrictions.
        # 
        # This parameter is required.
        self.collection = collection
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) API to view details of all AnalyticDB for PostgreSQL instances in the target region, including the instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.dimension = dimension
        # The vectorization algorithm.
        # 
        # >  Supported algorithms:
        # 
        # *   text-embedding-v1: the algorithm that produces 1536-dimensional vectors.
        # 
        # *   text-embedding-v2: the algorithm that produces 1536-dimensional vectors.
        # 
        # *   text2vec: the algorithm that produces 1024-dimensional vectors.
        # 
        # *   m3e-base: the algorithm that produces 768-dimensional vectors.
        # 
        # *   m3e-small: the algorithm that produces 512-dimensional vectors.
        # 
        # *   clip-vit-b-32: the image vectorization algorithm that uses the Contrastive Language-Image Pre-Training (CLIP) ViT-B/32 model and produces 512-dimensional vectors.
        # 
        # *   clip-vit-b-16: the image vectorization algorithm that uses the CLIP ViT-B/16 model and produces 512-dimensional vectors.
        # 
        # *   clip-vit-l-14: the image vectorization algorithm that uses the CLIP ViT-L/14 model and produces 768-dimensional vectors.
        # 
        # *   clip-vit-l-14-336px: the image vectorization algorithm that uses the CLIP ViT-L/14@336px model and produces 768-dimensional vectors.
        # 
        # *   clip-rn50: the image vectorization algorithm that uses the CLIP RN50 model and produces 1024-dimensional vectors.
        # 
        # *   clip-rn101: the image vectorization algorithm that uses the CLIP RN101 model and produces 512-dimensional vectors.
        # 
        # *   clip-rn50x4: the image vectorization algorithm that uses the CLIP RN50x4 model and produces 640-dimensional vectors.
        # 
        # *   clip-rn50x16: the image vectorization algorithm that uses the CLIP RN50x16 model and produces 768-dimensional vectors.
        # 
        # *   clip-rn50x64: the image vectorization algorithm that uses the CLIP RN50x64 model and produces 1024-dimensional vectors.
        self.embedding_model = embedding_model
        self.enable_graph = enable_graph
        self.entity_types = entity_types
        # Specifies whether to use the memory mapping technology to create HNSW indexes. Valid values: 0 and 1. Default value: 0. We recommend that you set the value to 1 in scenarios that require upload speed but not data deletion.
        # 
        # > 
        # 
        # *   0: uses segmented paging storage to create indexes. This method uses the shared buffer of PostgreSQL for caching and supports the delete and update operations.
        # 
        # *   1: uses the memory mapping technology to create indexes. This method does not support the delete or update operation.
        self.external_storage = external_storage
        # The fields used for full-text search. Separate multiple fields with commas (,). These fields must be keys defined in Metadata.
        self.full_text_retrieval_fields = full_text_retrieval_fields
        self.hnsw_ef_construction = hnsw_ef_construction
        # The maximum number of neighbors for the Hierarchical Navigable Small World (HNSW) algorithm. Valid values: 1 to 1000. In most cases, this parameter is automatically configured based on the value of the Dimension parameter. You do not need to configure this parameter.
        # 
        # >  We recommend that you configure this parameter based on the value of the Dimension parameter.
        # 
        # *   If you set Dimension to a value less than or equal to 384, set the value of HnswM to 16.
        # 
        # *   If you set Dimension to a value greater than 384 and less than or equal to 768, set the value of HnswM to 32.
        # 
        # *   If you set Dimension to a value greater than 768 and less than or equal to 1024, set the value of HnswM to 64.
        # 
        # *   If you set Dimension to a value greater than 1024, set the value of HnswM to 128.
        self.hnsw_m = hnsw_m
        self.llmmodel = llmmodel
        self.language = language
        # The name of the manager account that has the rds_superuser permission.
        # 
        # > You can create an account through the console -> Account Management, or by using the [CreateAccount](https://help.aliyun.com/document_detail/2361789.html) API.
        # 
        # This parameter is required.
        self.manager_account = manager_account
        # The password of the management account.
        # 
        # This parameter is required.
        self.manager_account_password = manager_account_password
        # The metadata of the vector data, which is a JSON string in the MAP format. The key specifies the field name, and the value specifies the data type.
        # 
        # > Supported data types:
        # > - For information about data types, see: [Data Types](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/data-types-1/).
        # > - The money type is not supported.
        # 
        # >Warning: The fields id, vector, doc_name, content, loader_metadata, source, and to_tsvector are reserved and should not be used.
        self.metadata = metadata
        self.metadata_indices = metadata_indices
        # The method that is used to create vector indexes.
        # 
        # Valid values:
        # 
        # *   **l2**: Euclidean distance.
        # *   **ip**: inner product distance.
        # *   **cosine** (default): cosine similarity.
        self.metrics = metrics
        # The name of the namespace. Default value: public.
        # 
        # >  You can call the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) operation to create a namespace and call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        self.namespace = namespace
        self.owner_id = owner_id
        # The analyzer that is used for full-text search. Default value: zh_cn.
        self.parser = parser
        # Specifies whether to enable the product quantization (PQ) feature for index acceleration. We recommend that you enable this feature for more than 500,000 rows of data. Valid values:
        # 
        # *   0: no.
        # *   1 (default): yes.
        self.pq_enable = pq_enable
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.relationship_types = relationship_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.embedding_model is not None:
            result['EmbeddingModel'] = self.embedding_model
        if self.enable_graph is not None:
            result['EnableGraph'] = self.enable_graph
        if self.entity_types is not None:
            result['EntityTypes'] = self.entity_types
        if self.external_storage is not None:
            result['ExternalStorage'] = self.external_storage
        if self.full_text_retrieval_fields is not None:
            result['FullTextRetrievalFields'] = self.full_text_retrieval_fields
        if self.hnsw_ef_construction is not None:
            result['HnswEfConstruction'] = self.hnsw_ef_construction
        if self.hnsw_m is not None:
            result['HnswM'] = self.hnsw_m
        if self.llmmodel is not None:
            result['LLMModel'] = self.llmmodel
        if self.language is not None:
            result['Language'] = self.language
        if self.manager_account is not None:
            result['ManagerAccount'] = self.manager_account
        if self.manager_account_password is not None:
            result['ManagerAccountPassword'] = self.manager_account_password
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.metadata_indices is not None:
            result['MetadataIndices'] = self.metadata_indices
        if self.metrics is not None:
            result['Metrics'] = self.metrics
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parser is not None:
            result['Parser'] = self.parser
        if self.pq_enable is not None:
            result['PqEnable'] = self.pq_enable
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.relationship_types is not None:
            result['RelationshipTypes'] = self.relationship_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('EmbeddingModel') is not None:
            self.embedding_model = m.get('EmbeddingModel')
        if m.get('EnableGraph') is not None:
            self.enable_graph = m.get('EnableGraph')
        if m.get('EntityTypes') is not None:
            self.entity_types = m.get('EntityTypes')
        if m.get('ExternalStorage') is not None:
            self.external_storage = m.get('ExternalStorage')
        if m.get('FullTextRetrievalFields') is not None:
            self.full_text_retrieval_fields = m.get('FullTextRetrievalFields')
        if m.get('HnswEfConstruction') is not None:
            self.hnsw_ef_construction = m.get('HnswEfConstruction')
        if m.get('HnswM') is not None:
            self.hnsw_m = m.get('HnswM')
        if m.get('LLMModel') is not None:
            self.llmmodel = m.get('LLMModel')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('ManagerAccount') is not None:
            self.manager_account = m.get('ManagerAccount')
        if m.get('ManagerAccountPassword') is not None:
            self.manager_account_password = m.get('ManagerAccountPassword')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('MetadataIndices') is not None:
            self.metadata_indices = m.get('MetadataIndices')
        if m.get('Metrics') is not None:
            self.metrics = m.get('Metrics')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Parser') is not None:
            self.parser = m.get('Parser')
        if m.get('PqEnable') is not None:
            self.pq_enable = m.get('PqEnable')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RelationshipTypes') is not None:
            self.relationship_types = m.get('RelationshipTypes')
        return self


class CreateDocumentCollectionShrinkRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        dimension: int = None,
        embedding_model: str = None,
        enable_graph: bool = None,
        entity_types_shrink: str = None,
        external_storage: int = None,
        full_text_retrieval_fields: str = None,
        hnsw_ef_construction: str = None,
        hnsw_m: int = None,
        llmmodel: str = None,
        language: str = None,
        manager_account: str = None,
        manager_account_password: str = None,
        metadata: str = None,
        metadata_indices: str = None,
        metrics: str = None,
        namespace: str = None,
        owner_id: int = None,
        parser: str = None,
        pq_enable: int = None,
        region_id: str = None,
        relationship_types_shrink: str = None,
    ):
        # The name of the document collection that you want to create.
        # 
        # > The name must comply with PostgreSQL object naming restrictions.
        # 
        # This parameter is required.
        self.collection = collection
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) API to view details of all AnalyticDB for PostgreSQL instances in the target region, including the instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.dimension = dimension
        # The vectorization algorithm.
        # 
        # >  Supported algorithms:
        # 
        # *   text-embedding-v1: the algorithm that produces 1536-dimensional vectors.
        # 
        # *   text-embedding-v2: the algorithm that produces 1536-dimensional vectors.
        # 
        # *   text2vec: the algorithm that produces 1024-dimensional vectors.
        # 
        # *   m3e-base: the algorithm that produces 768-dimensional vectors.
        # 
        # *   m3e-small: the algorithm that produces 512-dimensional vectors.
        # 
        # *   clip-vit-b-32: the image vectorization algorithm that uses the Contrastive Language-Image Pre-Training (CLIP) ViT-B/32 model and produces 512-dimensional vectors.
        # 
        # *   clip-vit-b-16: the image vectorization algorithm that uses the CLIP ViT-B/16 model and produces 512-dimensional vectors.
        # 
        # *   clip-vit-l-14: the image vectorization algorithm that uses the CLIP ViT-L/14 model and produces 768-dimensional vectors.
        # 
        # *   clip-vit-l-14-336px: the image vectorization algorithm that uses the CLIP ViT-L/14@336px model and produces 768-dimensional vectors.
        # 
        # *   clip-rn50: the image vectorization algorithm that uses the CLIP RN50 model and produces 1024-dimensional vectors.
        # 
        # *   clip-rn101: the image vectorization algorithm that uses the CLIP RN101 model and produces 512-dimensional vectors.
        # 
        # *   clip-rn50x4: the image vectorization algorithm that uses the CLIP RN50x4 model and produces 640-dimensional vectors.
        # 
        # *   clip-rn50x16: the image vectorization algorithm that uses the CLIP RN50x16 model and produces 768-dimensional vectors.
        # 
        # *   clip-rn50x64: the image vectorization algorithm that uses the CLIP RN50x64 model and produces 1024-dimensional vectors.
        self.embedding_model = embedding_model
        self.enable_graph = enable_graph
        self.entity_types_shrink = entity_types_shrink
        # Specifies whether to use the memory mapping technology to create HNSW indexes. Valid values: 0 and 1. Default value: 0. We recommend that you set the value to 1 in scenarios that require upload speed but not data deletion.
        # 
        # > 
        # 
        # *   0: uses segmented paging storage to create indexes. This method uses the shared buffer of PostgreSQL for caching and supports the delete and update operations.
        # 
        # *   1: uses the memory mapping technology to create indexes. This method does not support the delete or update operation.
        self.external_storage = external_storage
        # The fields used for full-text search. Separate multiple fields with commas (,). These fields must be keys defined in Metadata.
        self.full_text_retrieval_fields = full_text_retrieval_fields
        self.hnsw_ef_construction = hnsw_ef_construction
        # The maximum number of neighbors for the Hierarchical Navigable Small World (HNSW) algorithm. Valid values: 1 to 1000. In most cases, this parameter is automatically configured based on the value of the Dimension parameter. You do not need to configure this parameter.
        # 
        # >  We recommend that you configure this parameter based on the value of the Dimension parameter.
        # 
        # *   If you set Dimension to a value less than or equal to 384, set the value of HnswM to 16.
        # 
        # *   If you set Dimension to a value greater than 384 and less than or equal to 768, set the value of HnswM to 32.
        # 
        # *   If you set Dimension to a value greater than 768 and less than or equal to 1024, set the value of HnswM to 64.
        # 
        # *   If you set Dimension to a value greater than 1024, set the value of HnswM to 128.
        self.hnsw_m = hnsw_m
        self.llmmodel = llmmodel
        self.language = language
        # The name of the manager account that has the rds_superuser permission.
        # 
        # > You can create an account through the console -> Account Management, or by using the [CreateAccount](https://help.aliyun.com/document_detail/2361789.html) API.
        # 
        # This parameter is required.
        self.manager_account = manager_account
        # The password of the management account.
        # 
        # This parameter is required.
        self.manager_account_password = manager_account_password
        # The metadata of the vector data, which is a JSON string in the MAP format. The key specifies the field name, and the value specifies the data type.
        # 
        # > Supported data types:
        # > - For information about data types, see: [Data Types](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/data-types-1/).
        # > - The money type is not supported.
        # 
        # >Warning: The fields id, vector, doc_name, content, loader_metadata, source, and to_tsvector are reserved and should not be used.
        self.metadata = metadata
        self.metadata_indices = metadata_indices
        # The method that is used to create vector indexes.
        # 
        # Valid values:
        # 
        # *   **l2**: Euclidean distance.
        # *   **ip**: inner product distance.
        # *   **cosine** (default): cosine similarity.
        self.metrics = metrics
        # The name of the namespace. Default value: public.
        # 
        # >  You can call the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) operation to create a namespace and call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        self.namespace = namespace
        self.owner_id = owner_id
        # The analyzer that is used for full-text search. Default value: zh_cn.
        self.parser = parser
        # Specifies whether to enable the product quantization (PQ) feature for index acceleration. We recommend that you enable this feature for more than 500,000 rows of data. Valid values:
        # 
        # *   0: no.
        # *   1 (default): yes.
        self.pq_enable = pq_enable
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.relationship_types_shrink = relationship_types_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.embedding_model is not None:
            result['EmbeddingModel'] = self.embedding_model
        if self.enable_graph is not None:
            result['EnableGraph'] = self.enable_graph
        if self.entity_types_shrink is not None:
            result['EntityTypes'] = self.entity_types_shrink
        if self.external_storage is not None:
            result['ExternalStorage'] = self.external_storage
        if self.full_text_retrieval_fields is not None:
            result['FullTextRetrievalFields'] = self.full_text_retrieval_fields
        if self.hnsw_ef_construction is not None:
            result['HnswEfConstruction'] = self.hnsw_ef_construction
        if self.hnsw_m is not None:
            result['HnswM'] = self.hnsw_m
        if self.llmmodel is not None:
            result['LLMModel'] = self.llmmodel
        if self.language is not None:
            result['Language'] = self.language
        if self.manager_account is not None:
            result['ManagerAccount'] = self.manager_account
        if self.manager_account_password is not None:
            result['ManagerAccountPassword'] = self.manager_account_password
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.metadata_indices is not None:
            result['MetadataIndices'] = self.metadata_indices
        if self.metrics is not None:
            result['Metrics'] = self.metrics
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parser is not None:
            result['Parser'] = self.parser
        if self.pq_enable is not None:
            result['PqEnable'] = self.pq_enable
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.relationship_types_shrink is not None:
            result['RelationshipTypes'] = self.relationship_types_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('EmbeddingModel') is not None:
            self.embedding_model = m.get('EmbeddingModel')
        if m.get('EnableGraph') is not None:
            self.enable_graph = m.get('EnableGraph')
        if m.get('EntityTypes') is not None:
            self.entity_types_shrink = m.get('EntityTypes')
        if m.get('ExternalStorage') is not None:
            self.external_storage = m.get('ExternalStorage')
        if m.get('FullTextRetrievalFields') is not None:
            self.full_text_retrieval_fields = m.get('FullTextRetrievalFields')
        if m.get('HnswEfConstruction') is not None:
            self.hnsw_ef_construction = m.get('HnswEfConstruction')
        if m.get('HnswM') is not None:
            self.hnsw_m = m.get('HnswM')
        if m.get('LLMModel') is not None:
            self.llmmodel = m.get('LLMModel')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('ManagerAccount') is not None:
            self.manager_account = m.get('ManagerAccount')
        if m.get('ManagerAccountPassword') is not None:
            self.manager_account_password = m.get('ManagerAccountPassword')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('MetadataIndices') is not None:
            self.metadata_indices = m.get('MetadataIndices')
        if m.get('Metrics') is not None:
            self.metrics = m.get('Metrics')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Parser') is not None:
            self.parser = m.get('Parser')
        if m.get('PqEnable') is not None:
            self.pq_enable = m.get('PqEnable')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RelationshipTypes') is not None:
            self.relationship_types_shrink = m.get('RelationshipTypes')
        return self


class CreateDocumentCollectionResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The status of the operation. Valid values:
        # - **success**\
        # - **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateDocumentCollectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDocumentCollectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDocumentCollectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateExtensionsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        dbnames: str = None,
        extensions: str = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.dbnames = dbnames
        # The name of the extension that you want to install. Separate multiple extension names with commas (,).
        # 
        # This parameter is required.
        self.extensions = extensions
        # The region ID.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbnames is not None:
            result['DBNames'] = self.dbnames
        if self.extensions is not None:
            result['Extensions'] = self.extensions
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBNames') is not None:
            self.dbnames = m.get('DBNames')
        if m.get('Extensions') is not None:
            self.extensions = m.get('Extensions')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateExtensionsResponseBody(TeaModel):
    def __init__(
        self,
        extensions: str = None,
        request_id: str = None,
    ):
        # The name of the extension that you want to install. Multiple extension names are separated with commas (,).
        self.extensions = extensions
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extensions is not None:
            result['Extensions'] = self.extensions
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extensions') is not None:
            self.extensions = m.get('Extensions')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateExtensionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateExtensionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateExtensionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateExternalDataServiceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        region_id: str = None,
        service_description: str = None,
        service_name: str = None,
        service_spec: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Region ID, you can view available region IDs through the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) interface.
        self.region_id = region_id
        # Service description.
        self.service_description = service_description
        # Service name.
        # 
        # This parameter is required.
        self.service_name = service_name
        # Service specification (in CU), value:
        # 
        # - 8
        # 
        # This parameter is required.
        self.service_spec = service_spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.service_description is not None:
            result['ServiceDescription'] = self.service_description
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_spec is not None:
            result['ServiceSpec'] = self.service_spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServiceDescription') is not None:
            self.service_description = m.get('ServiceDescription')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceSpec') is not None:
            self.service_spec = m.get('ServiceSpec')
        return self


class CreateExternalDataServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        service_id: int = None,
    ):
        # Request ID.
        self.request_id = request_id
        # Service ID.
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class CreateExternalDataServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateExternalDataServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateExternalDataServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHadoopDataSourceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_description: str = None,
        data_source_name: str = None,
        data_source_type: str = None,
        emr_instance_id: str = None,
        hdfsconf: str = None,
        hadoop_core_conf: str = None,
        hadoop_create_type: str = None,
        hadoop_hosts_address: str = None,
        hive_conf: str = None,
        map_reduce_conf: str = None,
        region_id: str = None,
        yarn_conf: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Service description.
        self.data_source_description = data_source_description
        # Service name.
        self.data_source_name = data_source_name
        # Type of Hadoop external table to be enabled, with values:
        # 
        # - HDFS 
        # 
        # - Hive
        self.data_source_type = data_source_type
        # When HadoopCreateType=Emr, this field should contain the EMR instance ID.
        self.emr_instance_id = emr_instance_id
        # Content string of the Hadoop hdfs-site.xml file. This field is required when enabling an HDFS external table.
        self.hdfsconf = hdfsconf
        # Content string of the Hadoop core-site.xml file.
        self.hadoop_core_conf = hadoop_core_conf
        # External service type:
        # 
        # - emr
        # 
        # - hadoop: Self-built Hadoop
        self.hadoop_create_type = hadoop_create_type
        # Address and hostname of the Hadoop cluster\\"s source node in the /etc/hosts file.
        self.hadoop_hosts_address = hadoop_hosts_address
        # Content string of the Hadoop hive-site.xml file. This field is required when enabling a HIVE external table.
        self.hive_conf = hive_conf
        # Content string of the Hadoop mapred-site.xml file. This field is required when enabling an HDFS external table.
        self.map_reduce_conf = map_reduce_conf
        # Region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) interface to view available region IDs.
        self.region_id = region_id
        # Content string of the Hadoop yarn-site.xml file. This field is required when enabling an HDFS external table.
        self.yarn_conf = yarn_conf

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_description is not None:
            result['DataSourceDescription'] = self.data_source_description
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.emr_instance_id is not None:
            result['EmrInstanceId'] = self.emr_instance_id
        if self.hdfsconf is not None:
            result['HDFSConf'] = self.hdfsconf
        if self.hadoop_core_conf is not None:
            result['HadoopCoreConf'] = self.hadoop_core_conf
        if self.hadoop_create_type is not None:
            result['HadoopCreateType'] = self.hadoop_create_type
        if self.hadoop_hosts_address is not None:
            result['HadoopHostsAddress'] = self.hadoop_hosts_address
        if self.hive_conf is not None:
            result['HiveConf'] = self.hive_conf
        if self.map_reduce_conf is not None:
            result['MapReduceConf'] = self.map_reduce_conf
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.yarn_conf is not None:
            result['YarnConf'] = self.yarn_conf
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceDescription') is not None:
            self.data_source_description = m.get('DataSourceDescription')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('EmrInstanceId') is not None:
            self.emr_instance_id = m.get('EmrInstanceId')
        if m.get('HDFSConf') is not None:
            self.hdfsconf = m.get('HDFSConf')
        if m.get('HadoopCoreConf') is not None:
            self.hadoop_core_conf = m.get('HadoopCoreConf')
        if m.get('HadoopCreateType') is not None:
            self.hadoop_create_type = m.get('HadoopCreateType')
        if m.get('HadoopHostsAddress') is not None:
            self.hadoop_hosts_address = m.get('HadoopHostsAddress')
        if m.get('HiveConf') is not None:
            self.hive_conf = m.get('HiveConf')
        if m.get('MapReduceConf') is not None:
            self.map_reduce_conf = m.get('MapReduceConf')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('YarnConf') is not None:
            self.yarn_conf = m.get('YarnConf')
        return self


class CreateHadoopDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        data_source_id: int = None,
        request_id: str = None,
    ):
        # Data source ID.
        self.data_source_id = data_source_id
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateHadoopDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHadoopDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHadoopDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIndexRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        index_config: str = None,
        index_field: str = None,
        index_name: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.collection = collection
        self.dbinstance_id = dbinstance_id
        self.index_config = index_config
        self.index_field = index_field
        self.index_name = index_name
        # This parameter is required.
        self.namespace = namespace
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # This parameter is required.
        self.region_id = region_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.index_config is not None:
            result['IndexConfig'] = self.index_config
        if self.index_field is not None:
            result['IndexField'] = self.index_field
        if self.index_name is not None:
            result['IndexName'] = self.index_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('IndexConfig') is not None:
            self.index_config = m.get('IndexConfig')
        if m.get('IndexField') is not None:
            self.index_field = m.get('IndexField')
        if m.get('IndexName') is not None:
            self.index_name = m.get('IndexName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreateIndexResponseBody(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        self.job_id = job_id
        self.message = message
        self.request_id = request_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateIndexResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateIndexResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateIndexResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJDBCDataSourceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_description: str = None,
        data_source_name: str = None,
        data_source_type: str = None,
        jdbcconnection_string: str = None,
        jdbcpassword: str = None,
        jdbcuser_name: str = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Data source description.
        self.data_source_description = data_source_description
        # The name of data soruce
        self.data_source_name = data_source_name
        # The type of the data source.
        self.data_source_type = data_source_type
        # The JDBC connection string.
        self.jdbcconnection_string = jdbcconnection_string
        # The password of the database account.
        self.jdbcpassword = jdbcpassword
        # The name of the database account.
        self.jdbcuser_name = jdbcuser_name
        # The region ID of the instance.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_description is not None:
            result['DataSourceDescription'] = self.data_source_description
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.jdbcconnection_string is not None:
            result['JDBCConnectionString'] = self.jdbcconnection_string
        if self.jdbcpassword is not None:
            result['JDBCPassword'] = self.jdbcpassword
        if self.jdbcuser_name is not None:
            result['JDBCUserName'] = self.jdbcuser_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceDescription') is not None:
            self.data_source_description = m.get('DataSourceDescription')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('JDBCConnectionString') is not None:
            self.jdbcconnection_string = m.get('JDBCConnectionString')
        if m.get('JDBCPassword') is not None:
            self.jdbcpassword = m.get('JDBCPassword')
        if m.get('JDBCUserName') is not None:
            self.jdbcuser_name = m.get('JDBCUserName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateJDBCDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        data_source_id: str = None,
        request_id: str = None,
    ):
        # Data source ID.
        self.data_source_id = data_source_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateJDBCDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateJDBCDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateJDBCDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNamespaceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        manager_account: str = None,
        manager_account_password: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The name of the manager account that has the rds_superuser permission.
        # 
        # >  You can create an account on the Account Management page of the AnalyticDB for PostgreSQL console or by calling the [CreateAccount](https://help.aliyun.com/document_detail/2361789.html) operation.
        # 
        # This parameter is required.
        self.manager_account = manager_account
        # The password of the manager account.
        # 
        # This parameter is required.
        self.manager_account_password = manager_account_password
        # The name of the namespace. After the namespace is created, the system automatically creates an account that has the same name.
        # 
        # >  The name must comply with the naming conventions of PostgreSQL objects.
        self.namespace = namespace
        # The password of the namespace.
        # 
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the workspace that consists of multiple AnalyticDB for PostgreSQL instances. You must specify one of the WorkspaceId and DBInstanceId parameters. If you specify both parameters, the WorkspaceId parameter takes effect.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.manager_account is not None:
            result['ManagerAccount'] = self.manager_account
        if self.manager_account_password is not None:
            result['ManagerAccountPassword'] = self.manager_account_password
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ManagerAccount') is not None:
            self.manager_account = m.get('ManagerAccount')
        if m.get('ManagerAccountPassword') is not None:
            self.manager_account_password = m.get('ManagerAccountPassword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreateNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRemoteADBDataSourceRequest(TeaModel):
    def __init__(
        self,
        data_source_name: str = None,
        local_dbinstance_id: str = None,
        local_database: str = None,
        manager_user_name: str = None,
        manager_user_password: str = None,
        owner_id: int = None,
        remote_dbinstance_id: str = None,
        remote_database: str = None,
        user_name: str = None,
        user_password: str = None,
    ):
        # Customer-specified DataSourceName.
        self.data_source_name = data_source_name
        # Instance ID of the data being used (required).
        # 
        # This parameter is required.
        self.local_dbinstance_id = local_dbinstance_id
        # Database name of the data being used (required)
        # 
        # This parameter is required.
        self.local_database = local_database
        # Management account of the data-using instance.
        # 
        # This parameter is required.
        self.manager_user_name = manager_user_name
        # Password of the management account of the data-using instance.
        # 
        # This parameter is required.
        self.manager_user_password = manager_user_password
        self.owner_id = owner_id
        # Instance ID providing the data (required).
        # 
        # This parameter is required.
        self.remote_dbinstance_id = remote_dbinstance_id
        # Database name providing the data (required).
        # 
        # This parameter is required.
        self.remote_database = remote_database
        # Account name of the data-providing instance used for user mapping (required).
        # 
        # This parameter is required.
        self.user_name = user_name
        # Password of the data-providing instance account used for user mapping.
        # 
        # This parameter is required.
        self.user_password = user_password

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.local_dbinstance_id is not None:
            result['LocalDBInstanceId'] = self.local_dbinstance_id
        if self.local_database is not None:
            result['LocalDatabase'] = self.local_database
        if self.manager_user_name is not None:
            result['ManagerUserName'] = self.manager_user_name
        if self.manager_user_password is not None:
            result['ManagerUserPassword'] = self.manager_user_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.remote_dbinstance_id is not None:
            result['RemoteDBInstanceId'] = self.remote_dbinstance_id
        if self.remote_database is not None:
            result['RemoteDatabase'] = self.remote_database
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.user_password is not None:
            result['UserPassword'] = self.user_password
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('LocalDBInstanceId') is not None:
            self.local_dbinstance_id = m.get('LocalDBInstanceId')
        if m.get('LocalDatabase') is not None:
            self.local_database = m.get('LocalDatabase')
        if m.get('ManagerUserName') is not None:
            self.manager_user_name = m.get('ManagerUserName')
        if m.get('ManagerUserPassword') is not None:
            self.manager_user_password = m.get('ManagerUserPassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RemoteDBInstanceId') is not None:
            self.remote_dbinstance_id = m.get('RemoteDBInstanceId')
        if m.get('RemoteDatabase') is not None:
            self.remote_database = m.get('RemoteDatabase')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('UserPassword') is not None:
            self.user_password = m.get('UserPassword')
        return self


class CreateRemoteADBDataSourceResponseBodyDataSourceItem(TeaModel):
    def __init__(
        self,
        data_source_name: str = None,
        description: str = None,
        id: int = None,
        local_database: str = None,
        local_instance_name: str = None,
        manager_user_name: str = None,
        region_id: str = None,
        remote_database: str = None,
        remote_instance_name: str = None,
        status: str = None,
        user_name: str = None,
    ):
        # Data source name.
        self.data_source_name = data_source_name
        # Description information.
        self.description = description
        # ID
        self.id = id
        # Local database name
        self.local_database = local_database
        # Local instance name
        self.local_instance_name = local_instance_name
        # Management account user name
        self.manager_user_name = manager_user_name
        # Region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) API to view available region IDs.
        self.region_id = region_id
        # Remote database name
        self.remote_database = remote_database
        # Remote instance name
        self.remote_instance_name = remote_instance_name
        # Synchronization status
        self.status = status
        # User name
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.local_database is not None:
            result['LocalDatabase'] = self.local_database
        if self.local_instance_name is not None:
            result['LocalInstanceName'] = self.local_instance_name
        if self.manager_user_name is not None:
            result['ManagerUserName'] = self.manager_user_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remote_database is not None:
            result['RemoteDatabase'] = self.remote_database
        if self.remote_instance_name is not None:
            result['RemoteInstanceName'] = self.remote_instance_name
        if self.status is not None:
            result['Status'] = self.status
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LocalDatabase') is not None:
            self.local_database = m.get('LocalDatabase')
        if m.get('LocalInstanceName') is not None:
            self.local_instance_name = m.get('LocalInstanceName')
        if m.get('ManagerUserName') is not None:
            self.manager_user_name = m.get('ManagerUserName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemoteDatabase') is not None:
            self.remote_database = m.get('RemoteDatabase')
        if m.get('RemoteInstanceName') is not None:
            self.remote_instance_name = m.get('RemoteInstanceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateRemoteADBDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        data_source_item: CreateRemoteADBDataSourceResponseBodyDataSourceItem = None,
        request_id: str = None,
        task_id: int = None,
    ):
        # Returns the successfully added data sharing service data.
        self.data_source_item = data_source_item
        # Request ID.
        self.request_id = request_id
        # Workflow task ID.
        self.task_id = task_id

    def validate(self):
        if self.data_source_item:
            self.data_source_item.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_item is not None:
            result['DataSourceItem'] = self.data_source_item.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceItem') is not None:
            temp_model = CreateRemoteADBDataSourceResponseBodyDataSourceItem()
            self.data_source_item = temp_model.from_map(m['DataSourceItem'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateRemoteADBDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRemoteADBDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRemoteADBDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSampleDataRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/2361776.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class CreateSampleDataResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        error_message: str = None,
        request_id: str = None,
        status: bool = None,
    ):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id
        # The error message returned if an error occurs. This message does not affect the execution of the operation.
        self.error_message = error_message
        # The ID of the request.
        self.request_id = request_id
        # The execution state of the operation. Valid values:
        # 
        # *   **false**: The operation fails.
        # *   **true**: The operation is successful.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateSampleDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSampleDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSampleDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSecretRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        description: str = None,
        owner_id: int = None,
        password: str = None,
        region_id: str = None,
        secret_name: str = None,
        test_connection: bool = None,
        username: str = None,
        workspace_id: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The description of the access credential.
        self.description = description
        self.owner_id = owner_id
        # The password of the database account that is used to access the instance.
        # 
        # This parameter is required.
        self.password = password
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The name of the access credential. The name must be 1 to 16 characters in length and can contain letters, digits, and underscores (_). If you leave this parameter empty, the value of the Username parameter is used.
        self.secret_name = secret_name
        # Specifies whether to check the connectivity to the instance by using the name and password of the database account.
        self.test_connection = test_connection
        # The name of the database account that is used to access the instance.
        # 
        # This parameter is required.
        self.username = username
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.secret_name is not None:
            result['SecretName'] = self.secret_name
        if self.test_connection is not None:
            result['TestConnection'] = self.test_connection
        if self.username is not None:
            result['Username'] = self.username
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecretName') is not None:
            self.secret_name = m.get('SecretName')
        if m.get('TestConnection') is not None:
            self.test_connection = m.get('TestConnection')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreateSecretResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        secret_arn: str = None,
        secret_name: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The Alibaba Cloud Resource Name (ARN) of the access credential for the created Data API account. Format: `acs:gpdb:{{region}}:{{accountId}}:secret/{{secretName}}-{{32 digits random string}`.
        self.secret_arn = secret_arn
        # The name of the access credential.
        self.secret_name = secret_name
        # The status of the operation. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.secret_arn is not None:
            result['SecretArn'] = self.secret_arn
        if self.secret_name is not None:
            result['SecretName'] = self.secret_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecretArn') is not None:
            self.secret_arn = m.get('SecretArn')
        if m.get('SecretName') is not None:
            self.secret_name = m.get('SecretName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateSecretResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSecretResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceLinkedRoleRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        # The ID of the region.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateServiceLinkedRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateServiceLinkedRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateServiceLinkedRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStreamingDataServiceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        region_id: str = None,
        service_description: str = None,
        service_name: str = None,
        service_spec: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent list of regions.
        self.region_id = region_id
        # The description of the service.
        self.service_description = service_description
        # The name of the service.
        # 
        # This parameter is required.
        self.service_name = service_name
        # The specifications of the service.
        # 
        # This parameter is required.
        self.service_spec = service_spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.service_description is not None:
            result['ServiceDescription'] = self.service_description
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_spec is not None:
            result['ServiceSpec'] = self.service_spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServiceDescription') is not None:
            self.service_description = m.get('ServiceDescription')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceSpec') is not None:
            self.service_spec = m.get('ServiceSpec')
        return self


class CreateStreamingDataServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        service_id: int = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The real-time data service ID.
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class CreateStreamingDataServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateStreamingDataServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStreamingDataServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStreamingDataSourceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_config: str = None,
        data_source_description: str = None,
        data_source_name: str = None,
        data_source_type: str = None,
        region_id: str = None,
        service_id: int = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Data source configuration information.
        # 
        # This parameter is required.
        self.data_source_config = data_source_config
        # Data source description.
        self.data_source_description = data_source_description
        # Data source name.
        # 
        # This parameter is required.
        self.data_source_name = data_source_name
        # Data source type. Values:
        #  -  kafka
        # 
        # This parameter is required.
        self.data_source_type = data_source_type
        # Region ID.
        # 
        # > You can view available region IDs through the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) interface.
        self.region_id = region_id
        # Real-time data service ID.
        # 
        # This parameter is required.
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_config is not None:
            result['DataSourceConfig'] = self.data_source_config
        if self.data_source_description is not None:
            result['DataSourceDescription'] = self.data_source_description
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceConfig') is not None:
            self.data_source_config = m.get('DataSourceConfig')
        if m.get('DataSourceDescription') is not None:
            self.data_source_description = m.get('DataSourceDescription')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class CreateStreamingDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        data_source_id: int = None,
        request_id: str = None,
    ):
        # Data source ID.
        self.data_source_id = data_source_id
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateStreamingDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateStreamingDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStreamingDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStreamingJobRequest(TeaModel):
    def __init__(
        self,
        account: str = None,
        consistency: str = None,
        dbinstance_id: str = None,
        data_source_id: str = None,
        dest_columns: List[str] = None,
        dest_database: str = None,
        dest_schema: str = None,
        dest_table: str = None,
        error_limit_count: int = None,
        fallback_offset: str = None,
        group_name: str = None,
        job_config: str = None,
        job_description: str = None,
        job_name: str = None,
        match_columns: List[str] = None,
        mode: str = None,
        password: str = None,
        region_id: str = None,
        src_columns: List[str] = None,
        try_run: bool = None,
        update_columns: List[str] = None,
        write_mode: str = None,
    ):
        # Target database account.
        self.account = account
        # Delivery guarantee.
        self.consistency = consistency
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Data source ID.
        # 
        # This parameter is required.
        self.data_source_id = data_source_id
        # Target data table mapping field list.
        self.dest_columns = dest_columns
        # Target database name.
        self.dest_database = dest_database
        # Target namespace.
        self.dest_schema = dest_schema
        # Target table name.
        self.dest_table = dest_table
        # When data in Kafka does not match the ADBPG target table, it will cause a write failure. This value is the number of error rows allowed; exceeding this will cause the task to fail.
        self.error_limit_count = error_limit_count
        # FallbackOffset, fallback offset
        # 
        # - The FallbackOffset parameter defines the behavior when the consumer does not request a specific offset or the requested offset exceeds the current Kafka cluster\\"s recorded offset information. You can choose to start consuming from the earliest (newest) or latest (oldest) offset.
        self.fallback_offset = fallback_offset
        # Kafka group name
        self.group_name = group_name
        # Job configuration file, required for professional mode.
        self.job_config = job_config
        # Job description.
        self.job_description = job_description
        # Job name.
        # 
        # This parameter is required.
        self.job_name = job_name
        # Match columns, usually all primary key columns of the target table. If all column values in this configuration are the same, the two rows of data are considered duplicates.
        self.match_columns = match_columns
        # Configuration mode
        # 1. Basic mode requires specifying some configuration fields
        # 1. Professional mode supports submitting a YAML file
        self.mode = mode
        # Target database password.
        self.password = password
        # Region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) API to view available region IDs.
        self.region_id = region_id
        # Source data field list.
        self.src_columns = src_columns
        # Whether to test the real-time task, values:
        # 
        # - true
        # 
        # - false
        # 
        # Default value: false.
        self.try_run = try_run
        # Update columns, usually all non-primary key columns of the target table. When data is determined to be duplicate through MatchColumns, updating the UpdateColumns column values will result in new data overwriting old data.
        self.update_columns = update_columns
        # Write mode.
        self.write_mode = write_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.consistency is not None:
            result['Consistency'] = self.consistency
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.dest_columns is not None:
            result['DestColumns'] = self.dest_columns
        if self.dest_database is not None:
            result['DestDatabase'] = self.dest_database
        if self.dest_schema is not None:
            result['DestSchema'] = self.dest_schema
        if self.dest_table is not None:
            result['DestTable'] = self.dest_table
        if self.error_limit_count is not None:
            result['ErrorLimitCount'] = self.error_limit_count
        if self.fallback_offset is not None:
            result['FallbackOffset'] = self.fallback_offset
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.job_config is not None:
            result['JobConfig'] = self.job_config
        if self.job_description is not None:
            result['JobDescription'] = self.job_description
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.match_columns is not None:
            result['MatchColumns'] = self.match_columns
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.password is not None:
            result['Password'] = self.password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.src_columns is not None:
            result['SrcColumns'] = self.src_columns
        if self.try_run is not None:
            result['TryRun'] = self.try_run
        if self.update_columns is not None:
            result['UpdateColumns'] = self.update_columns
        if self.write_mode is not None:
            result['WriteMode'] = self.write_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('Consistency') is not None:
            self.consistency = m.get('Consistency')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DestColumns') is not None:
            self.dest_columns = m.get('DestColumns')
        if m.get('DestDatabase') is not None:
            self.dest_database = m.get('DestDatabase')
        if m.get('DestSchema') is not None:
            self.dest_schema = m.get('DestSchema')
        if m.get('DestTable') is not None:
            self.dest_table = m.get('DestTable')
        if m.get('ErrorLimitCount') is not None:
            self.error_limit_count = m.get('ErrorLimitCount')
        if m.get('FallbackOffset') is not None:
            self.fallback_offset = m.get('FallbackOffset')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('JobConfig') is not None:
            self.job_config = m.get('JobConfig')
        if m.get('JobDescription') is not None:
            self.job_description = m.get('JobDescription')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('MatchColumns') is not None:
            self.match_columns = m.get('MatchColumns')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SrcColumns') is not None:
            self.src_columns = m.get('SrcColumns')
        if m.get('TryRun') is not None:
            self.try_run = m.get('TryRun')
        if m.get('UpdateColumns') is not None:
            self.update_columns = m.get('UpdateColumns')
        if m.get('WriteMode') is not None:
            self.write_mode = m.get('WriteMode')
        return self


class CreateStreamingJobShrinkRequest(TeaModel):
    def __init__(
        self,
        account: str = None,
        consistency: str = None,
        dbinstance_id: str = None,
        data_source_id: str = None,
        dest_columns_shrink: str = None,
        dest_database: str = None,
        dest_schema: str = None,
        dest_table: str = None,
        error_limit_count: int = None,
        fallback_offset: str = None,
        group_name: str = None,
        job_config: str = None,
        job_description: str = None,
        job_name: str = None,
        match_columns_shrink: str = None,
        mode: str = None,
        password: str = None,
        region_id: str = None,
        src_columns_shrink: str = None,
        try_run: bool = None,
        update_columns_shrink: str = None,
        write_mode: str = None,
    ):
        # Target database account.
        self.account = account
        # Delivery guarantee.
        self.consistency = consistency
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Data source ID.
        # 
        # This parameter is required.
        self.data_source_id = data_source_id
        # Target data table mapping field list.
        self.dest_columns_shrink = dest_columns_shrink
        # Target database name.
        self.dest_database = dest_database
        # Target namespace.
        self.dest_schema = dest_schema
        # Target table name.
        self.dest_table = dest_table
        # When data in Kafka does not match the ADBPG target table, it will cause a write failure. This value is the number of error rows allowed; exceeding this will cause the task to fail.
        self.error_limit_count = error_limit_count
        # FallbackOffset, fallback offset
        # 
        # - The FallbackOffset parameter defines the behavior when the consumer does not request a specific offset or the requested offset exceeds the current Kafka cluster\\"s recorded offset information. You can choose to start consuming from the earliest (newest) or latest (oldest) offset.
        self.fallback_offset = fallback_offset
        # Kafka group name
        self.group_name = group_name
        # Job configuration file, required for professional mode.
        self.job_config = job_config
        # Job description.
        self.job_description = job_description
        # Job name.
        # 
        # This parameter is required.
        self.job_name = job_name
        # Match columns, usually all primary key columns of the target table. If all column values in this configuration are the same, the two rows of data are considered duplicates.
        self.match_columns_shrink = match_columns_shrink
        # Configuration mode
        # 1. Basic mode requires specifying some configuration fields
        # 1. Professional mode supports submitting a YAML file
        self.mode = mode
        # Target database password.
        self.password = password
        # Region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) API to view available region IDs.
        self.region_id = region_id
        # Source data field list.
        self.src_columns_shrink = src_columns_shrink
        # Whether to test the real-time task, values:
        # 
        # - true
        # 
        # - false
        # 
        # Default value: false.
        self.try_run = try_run
        # Update columns, usually all non-primary key columns of the target table. When data is determined to be duplicate through MatchColumns, updating the UpdateColumns column values will result in new data overwriting old data.
        self.update_columns_shrink = update_columns_shrink
        # Write mode.
        self.write_mode = write_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.consistency is not None:
            result['Consistency'] = self.consistency
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.dest_columns_shrink is not None:
            result['DestColumns'] = self.dest_columns_shrink
        if self.dest_database is not None:
            result['DestDatabase'] = self.dest_database
        if self.dest_schema is not None:
            result['DestSchema'] = self.dest_schema
        if self.dest_table is not None:
            result['DestTable'] = self.dest_table
        if self.error_limit_count is not None:
            result['ErrorLimitCount'] = self.error_limit_count
        if self.fallback_offset is not None:
            result['FallbackOffset'] = self.fallback_offset
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.job_config is not None:
            result['JobConfig'] = self.job_config
        if self.job_description is not None:
            result['JobDescription'] = self.job_description
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.match_columns_shrink is not None:
            result['MatchColumns'] = self.match_columns_shrink
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.password is not None:
            result['Password'] = self.password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.src_columns_shrink is not None:
            result['SrcColumns'] = self.src_columns_shrink
        if self.try_run is not None:
            result['TryRun'] = self.try_run
        if self.update_columns_shrink is not None:
            result['UpdateColumns'] = self.update_columns_shrink
        if self.write_mode is not None:
            result['WriteMode'] = self.write_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('Consistency') is not None:
            self.consistency = m.get('Consistency')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DestColumns') is not None:
            self.dest_columns_shrink = m.get('DestColumns')
        if m.get('DestDatabase') is not None:
            self.dest_database = m.get('DestDatabase')
        if m.get('DestSchema') is not None:
            self.dest_schema = m.get('DestSchema')
        if m.get('DestTable') is not None:
            self.dest_table = m.get('DestTable')
        if m.get('ErrorLimitCount') is not None:
            self.error_limit_count = m.get('ErrorLimitCount')
        if m.get('FallbackOffset') is not None:
            self.fallback_offset = m.get('FallbackOffset')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('JobConfig') is not None:
            self.job_config = m.get('JobConfig')
        if m.get('JobDescription') is not None:
            self.job_description = m.get('JobDescription')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('MatchColumns') is not None:
            self.match_columns_shrink = m.get('MatchColumns')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SrcColumns') is not None:
            self.src_columns_shrink = m.get('SrcColumns')
        if m.get('TryRun') is not None:
            self.try_run = m.get('TryRun')
        if m.get('UpdateColumns') is not None:
            self.update_columns_shrink = m.get('UpdateColumns')
        if m.get('WriteMode') is not None:
            self.write_mode = m.get('WriteMode')
        return self


class CreateStreamingJobResponseBody(TeaModel):
    def __init__(
        self,
        job_id: int = None,
        request_id: str = None,
    ):
        # Job ID.
        self.job_id = job_id
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateStreamingJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateStreamingJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStreamingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSupabaseProjectRequest(TeaModel):
    def __init__(
        self,
        account_password: str = None,
        client_token: str = None,
        disk_performance_level: str = None,
        project_name: str = None,
        project_spec: str = None,
        region_id: str = None,
        security_iplist: str = None,
        storage_size: int = None,
        v_switch_id: str = None,
        vpc_id: str = None,
        zone_id: str = None,
    ):
        # This parameter is required.
        self.account_password = account_password
        self.client_token = client_token
        self.disk_performance_level = disk_performance_level
        # This parameter is required.
        self.project_name = project_name
        # This parameter is required.
        self.project_spec = project_spec
        self.region_id = region_id
        # This parameter is required.
        self.security_iplist = security_iplist
        self.storage_size = storage_size
        # This parameter is required.
        self.v_switch_id = v_switch_id
        # This parameter is required.
        self.vpc_id = vpc_id
        # This parameter is required.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.disk_performance_level is not None:
            result['DiskPerformanceLevel'] = self.disk_performance_level
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_spec is not None:
            result['ProjectSpec'] = self.project_spec
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.storage_size is not None:
            result['StorageSize'] = self.storage_size
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DiskPerformanceLevel') is not None:
            self.disk_performance_level = m.get('DiskPerformanceLevel')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectSpec') is not None:
            self.project_spec = m.get('ProjectSpec')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('StorageSize') is not None:
            self.storage_size = m.get('StorageSize')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateSupabaseProjectResponseBody(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        request_id: str = None,
    ):
        self.project_id = project_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSupabaseProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSupabaseProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSupabaseProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVectorIndexRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        dimension: int = None,
        external_storage: int = None,
        hnsw_ef_construction: int = None,
        hnsw_m: int = None,
        manager_account: str = None,
        manager_account_password: str = None,
        metrics: str = None,
        namespace: str = None,
        owner_id: int = None,
        pq_enable: int = None,
        region_id: str = None,
        type: str = None,
    ):
        # Collection name.
        # > You can use the [ListCollections](https://help.aliyun.com/document_detail/2401503.html) API to view the list.
        # 
        # This parameter is required.
        self.collection = collection
        # Instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) API to view details of all AnalyticDB PostgreSQL instances in the target region, including the instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Vector dimension.
        # > This value must be consistent with the length of the vector data (Rows. Vector) uploaded via the [UpsertCollectionData](https://help.aliyun.com/document_detail/2401493.html) API.
        self.dimension = dimension
        # Whether to use mmap to build the HNSW index, default is 0. If the data does not need to be deleted and there are performance requirements for uploading data, it is recommended to set this to 1.
        # 
        # > 
        # > - When set to 0, the segment-page storage mode is used to build the index, which can use the shared_buffer in PostgreSQL for caching and supports deletion and update operations.
        # > - When set to 1, the index is built using mmap, which does not support deletion and update operations.
        self.external_storage = external_storage
        self.hnsw_ef_construction = hnsw_ef_construction
        # The maximum number of neighbors in the HNSW algorithm, ranging from 1 to 1000. The API will automatically set this value based on the vector dimension, and it generally does not need to be manually set.
        # 
        # > It is suggested to set this based on the vector dimension as follows:
        # > - Less than or equal to 384: 16
        # > - Greater than 384 and less than or equal to 768: 32
        # > - Greater than 768 and less than or equal to 1024: 64
        # > - Greater than 1024: 128
        self.hnsw_m = hnsw_m
        # Name of the management account with rds_superuser permissions.
        # 
        # > You can create an account through the console -> Account Management, or by using the [CreateAccount](https://help.aliyun.com/document_detail/2361789.html) API.
        # 
        # This parameter is required.
        self.manager_account = manager_account
        # Management account password.
        # 
        # This parameter is required.
        self.manager_account_password = manager_account_password
        # Method used for building the vector index. Value description:
        # - l2: Euclidean distance.
        # - ip: Inner product (dot product) distance.
        # - cosine: Cosine similarity.
        self.metrics = metrics
        # Namespace, default is public.
        # 
        # > You can use the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) API to view the list.
        self.namespace = namespace
        self.owner_id = owner_id
        # Whether to enable PQ (Product Quantization) algorithm acceleration for the index. It is recommended to enable this when the data volume exceeds 500,000. Value description:
        # - 0: Disabled.
        # - 1: Enabled (default).
        self.pq_enable = pq_enable
        # Region ID where the instance is located.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.external_storage is not None:
            result['ExternalStorage'] = self.external_storage
        if self.hnsw_ef_construction is not None:
            result['HnswEfConstruction'] = self.hnsw_ef_construction
        if self.hnsw_m is not None:
            result['HnswM'] = self.hnsw_m
        if self.manager_account is not None:
            result['ManagerAccount'] = self.manager_account
        if self.manager_account_password is not None:
            result['ManagerAccountPassword'] = self.manager_account_password
        if self.metrics is not None:
            result['Metrics'] = self.metrics
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pq_enable is not None:
            result['PqEnable'] = self.pq_enable
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('ExternalStorage') is not None:
            self.external_storage = m.get('ExternalStorage')
        if m.get('HnswEfConstruction') is not None:
            self.hnsw_ef_construction = m.get('HnswEfConstruction')
        if m.get('HnswM') is not None:
            self.hnsw_m = m.get('HnswM')
        if m.get('ManagerAccount') is not None:
            self.manager_account = m.get('ManagerAccount')
        if m.get('ManagerAccountPassword') is not None:
            self.manager_account_password = m.get('ManagerAccountPassword')
        if m.get('Metrics') is not None:
            self.metrics = m.get('Metrics')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PqEnable') is not None:
            self.pq_enable = m.get('PqEnable')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateVectorIndexResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # Detailed information returned by the API.
        self.message = message
        # Request ID.
        self.request_id = request_id
        # API execution status. Value description:
        # - **success**: Execution succeeded.
        # - **fail**: Execution failed.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateVectorIndexResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVectorIndexResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVectorIndexResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAccountRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        dbinstance_id: str = None,
    ):
        # The name of the database account. The privileged account cannot be deleted.
        # 
        # This parameter is required.
        self.account_name = account_name
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DeleteAccountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAccountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupRequest(TeaModel):
    def __init__(
        self,
        backup_id: str = None,
        dbinstance_id: str = None,
    ):
        # This parameter is required.
        self.backup_id = backup_id
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DeleteBackupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBackupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCollectionRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # The name of the collection.
        # 
        # This parameter is required.
        self.collection = collection
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The name of the namespace.
        # 
        # >  You can call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        self.namespace = namespace
        # The password of the namespace.
        # 
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the workspace that consists of multiple AnalyticDB for PostgreSQL instances. You must specify one of the WorkspaceId and DBInstanceId parameters. If you specify both parameters, the WorkspaceId parameter takes effect.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteCollectionResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteCollectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCollectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCollectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCollectionDataRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        collection_data: str = None,
        collection_data_filter: str = None,
        dbinstance_id: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # The name of the collection.
        # 
        # This parameter is required.
        self.collection = collection
        # The data that you want to delete.
        self.collection_data = collection_data
        # The filter conditions for the data to be deleted.
        self.collection_data_filter = collection_data_filter
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances within a region.
        self.dbinstance_id = dbinstance_id
        # The name of the namespace. Default value: public.
        # 
        # >  You can call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        self.namespace = namespace
        # The password of the namespace.
        # 
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the workspace that consists of multiple AnalyticDB for PostgreSQL instances. You must specify one of the WorkspaceId and DBInstanceId parameters. If you specify both parameters, the WorkspaceId parameter takes effect.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.collection_data is not None:
            result['CollectionData'] = self.collection_data
        if self.collection_data_filter is not None:
            result['CollectionDataFilter'] = self.collection_data_filter
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('CollectionData') is not None:
            self.collection_data = m.get('CollectionData')
        if m.get('CollectionDataFilter') is not None:
            self.collection_data_filter = m.get('CollectionDataFilter')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteCollectionDataResponseBody(TeaModel):
    def __init__(
        self,
        applied_rows: int = None,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The number of rows that are affected by the request.
        self.applied_rows = applied_rows
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applied_rows is not None:
            result['AppliedRows'] = self.applied_rows
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppliedRows') is not None:
            self.applied_rows = m.get('AppliedRows')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteCollectionDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCollectionDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCollectionDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBInstanceRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        dbinstance_id: str = None,
        owner_id: int = None,
        resource_group_id: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. For more information, see [How to ensure idempotence](https://help.aliyun.com/document_detail/327176.html).
        self.client_token = client_token
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # This parameter is no longer used.
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DeleteDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBInstancePlanRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        plan_id: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The ID of the plan.
        # 
        # >  You can call the [DescribeDBInstancePlans](https://help.aliyun.com/document_detail/449398.html) operation to query the details of plans, including plan IDs.
        # 
        # This parameter is required.
        self.plan_id = plan_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        return self


class DeleteDBInstancePlanResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        error_message: str = None,
        plan_id: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id
        # The error message returned.
        # 
        # This parameter is returned only when the operation fails.
        self.error_message = error_message
        # The ID of the plan.
        self.plan_id = plan_id
        # The ID of the request.
        self.request_id = request_id
        # The state of the operation.
        # 
        # If the operation is successful, **success** is returned. If the operation fails, this parameter is not returned.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteDBInstancePlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDBInstancePlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDBInstancePlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBResourceGroupRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        resource_group_name: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The name of the resource group.
        # 
        # This parameter is required.
        self.resource_group_name = resource_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        return self


class DeleteDBResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDBResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDBResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDBResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDocumentRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        file_name: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # Document collection name.
        # 
        # 
        # > Created by the [CreateDocumentCollection](https://help.aliyun.com/document_detail/2618448.html) API. You can use the [ListDocumentCollections](https://help.aliyun.com/document_detail/2618452.html) API to view the list of created document collections.
        # 
        # This parameter is required.
        self.collection = collection
        # Instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) API to view details of all AnalyticDB PostgreSQL instances in the target region, including the instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # File name.
        # 
        # > The name of an uploaded file. You can query the list of files using the [ListDocuments](https://help.aliyun.com/document_detail/2618453.html) API.
        # 
        # This parameter is required.
        self.file_name = file_name
        # Namespace, default is public.
        # 
        # > You can create a namespace using the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) API and view the list of namespaces using the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) API.
        self.namespace = namespace
        # Password for the namespace.
        # 
        # > This value is specified in the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) API.
        # 
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # Region ID where the instance is located.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDocumentResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # Detailed information returned by the API.
        self.message = message
        # Request ID.
        self.request_id = request_id
        # Creation status, value description: - **success**: Success - **fail**: Fail
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteDocumentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDocumentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDocumentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDocumentCollectionRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # The name of the document collection to be deleted.
        # 
        # This parameter is required.
        self.collection = collection
        # Instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) API to view details of all AnalyticDB PostgreSQL instances in the target region, including the instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Namespace, default is public.
        # 
        # > You can create a namespace using the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) API and view the list of namespaces using the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) API.
        self.namespace = namespace
        # Password for the namespace.
        # 
        # > This value is specified by the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) API.
        # 
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # The ID of the region where the instance is located.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDocumentCollectionResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # Return message.
        self.message = message
        # Request ID.
        self.request_id = request_id
        # Status, with the following possible values:
        # - **success**: Success.
        # - **fail**: Failure.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteDocumentCollectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDocumentCollectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDocumentCollectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExtensionRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        dbnames: str = None,
        extension: str = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.dbnames = dbnames
        # The name of the extension.
        # 
        # This parameter is required.
        self.extension = extension
        # The region ID of the instance.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbnames is not None:
            result['DBNames'] = self.dbnames
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBNames') is not None:
            self.dbnames = m.get('DBNames')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteExtensionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteExtensionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteExtensionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteExtensionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExternalDataServiceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        region_id: str = None,
        service_id: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) API to view available region IDs.
        self.region_id = region_id
        # Service ID.
        # 
        # This parameter is required.
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class DeleteExternalDataServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteExternalDataServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteExternalDataServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteExternalDataServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHadoopDataSourceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_id: str = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The service ID.
        # 
        # This parameter is required.
        self.data_source_id = data_source_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteHadoopDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHadoopDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHadoopDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHadoopDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIndexRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        index_name: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.collection = collection
        self.dbinstance_id = dbinstance_id
        # This parameter is required.
        self.index_name = index_name
        # This parameter is required.
        self.namespace = namespace
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # This parameter is required.
        self.region_id = region_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.index_name is not None:
            result['IndexName'] = self.index_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('IndexName') is not None:
            self.index_name = m.get('IndexName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteIndexResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        self.message = message
        self.request_id = request_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteIndexResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteIndexResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIndexResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteJDBCDataSourceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_id: str = None,
        region_id: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Data source ID.
        # 
        # This parameter is required.
        self.data_source_id = data_source_id
        # Region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) interface to view available region IDs.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteJDBCDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteJDBCDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteJDBCDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteJDBCDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNamespaceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        manager_account: str = None,
        manager_account_password: str = None,
        namespace: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The name of the manager account that has the rds_superuser permission.
        # 
        # >  You can create an account on the Account Management page of the AnalyticDB for PostgreSQL console or by calling the [CreateAccount](https://help.aliyun.com/document_detail/2361789.html) operation.
        # 
        # This parameter is required.
        self.manager_account = manager_account
        # The password of the manager account.
        # 
        # This parameter is required.
        self.manager_account_password = manager_account_password
        # The name of the namespace.
        # 
        # >  You can call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        # 
        # This parameter is required.
        self.namespace = namespace
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the workspace that consists of multiple AnalyticDB for PostgreSQL instances. You must specify one of the WorkspaceId and DBInstanceId parameters. If you specify both parameters, the WorkspaceId parameter takes effect.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.manager_account is not None:
            result['ManagerAccount'] = self.manager_account
        if self.manager_account_password is not None:
            result['ManagerAccountPassword'] = self.manager_account_password
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ManagerAccount') is not None:
            self.manager_account = m.get('ManagerAccount')
        if m.get('ManagerAccountPassword') is not None:
            self.manager_account_password = m.get('ManagerAccountPassword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRemoteADBDataSourceRequest(TeaModel):
    def __init__(
        self,
        data_source_id: str = None,
        local_dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The service ID.
        # 
        # This parameter is required.
        self.data_source_id = data_source_id
        # The ID of the instance that uses the data provided by another instance.
        # 
        # This parameter is required.
        self.local_dbinstance_id = local_dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.local_dbinstance_id is not None:
            result['LocalDBInstanceId'] = self.local_dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('LocalDBInstanceId') is not None:
            self.local_dbinstance_id = m.get('LocalDBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteRemoteADBDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_id: int = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The job ID.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteRemoteADBDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRemoteADBDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRemoteADBDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecretRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        secret_arn: str = None,
        secret_name: str = None,
        workspace_id: str = None,
    ):
        # The instance ID. You can call the DescribeDBInstances operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # >
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The Alibaba Cloud Resource Name (ARN) of the access credential for the created Data API account. Format: `acs:gpdb:{{region}}:{{accountId}}:secret/{{secretName}}-{{32 digits random string}`.
        # 
        # >  You must specify one of the SecretArn and SecretName parameters.
        self.secret_arn = secret_arn
        # The name of the access credential.
        # 
        # >  You must specify one of the SecretArn and SecretName parameters.
        self.secret_name = secret_name
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.secret_arn is not None:
            result['SecretArn'] = self.secret_arn
        if self.secret_name is not None:
            result['SecretName'] = self.secret_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecretArn') is not None:
            self.secret_arn = m.get('SecretArn')
        if m.get('SecretName') is not None:
            self.secret_name = m.get('SecretName')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteSecretResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        secret_arn: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The ARN of the access credential for the created Data API account. Format: `acs:gpdb:{{region}}:{{accountId}}:secret/{{secretName}}-{{32 digits random string}`.
        self.secret_arn = secret_arn
        # The status of the operation. Valid values:
        # 
        # *   **fail**\
        # *   **success**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.secret_arn is not None:
            result['SecretArn'] = self.secret_arn
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecretArn') is not None:
            self.secret_arn = m.get('SecretArn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteSecretResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSecretResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStreamingDataServiceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        region_id: str = None,
        service_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id
        # The service ID.
        # 
        # This parameter is required.
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class DeleteStreamingDataServiceResponseBody(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        request_id: str = None,
        status: bool = None,
    ):
        # The error message returned if the operation fails.
        # 
        # This parameter is returned only when the return value of **Status** is **false**.
        self.error_message = error_message
        # The request ID.
        self.request_id = request_id
        # The status of the operation. Valid values:
        # 
        # *   **false**: The operation fails.
        # *   **true**: The operation is successful.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteStreamingDataServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStreamingDataServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStreamingDataServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStreamingDataSourceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_id: int = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The data source ID.
        # 
        # This parameter is required.
        self.data_source_id = data_source_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteStreamingDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStreamingDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStreamingDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStreamingDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStreamingJobRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        job_id: int = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The job ID.
        # 
        # This parameter is required.
        self.job_id = job_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteStreamingJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStreamingJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStreamingJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStreamingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSupabaseProjectRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        region_id: str = None,
    ):
        # This parameter is required.
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteSupabaseProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSupabaseProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSupabaseProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSupabaseProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVectorIndexRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        manager_account: str = None,
        manager_account_password: str = None,
        namespace: str = None,
        owner_id: int = None,
        region_id: str = None,
        type: str = None,
    ):
        # The name of the collection.
        # 
        # >  You can call the [ListCollections](https://help.aliyun.com/document_detail/2401503.html) operation to query a list of collections.
        # 
        # This parameter is required.
        self.collection = collection
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the manager account that has the rds_superuser permission.
        # 
        # >  You can create an account on the **Account Management** page of the AnalyticDB for PostgreSQL console or by calling the [CreateAccount](https://help.aliyun.com/document_detail/2361789.html) operation.
        # 
        # This parameter is required.
        self.manager_account = manager_account
        # The password of the manager account.
        # 
        # This parameter is required.
        self.manager_account_password = manager_account_password
        # The name of the namespace. Default value: public.
        # 
        # >  You can call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        self.namespace = namespace
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.manager_account is not None:
            result['ManagerAccount'] = self.manager_account
        if self.manager_account_password is not None:
            result['ManagerAccountPassword'] = self.manager_account_password
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ManagerAccount') is not None:
            self.manager_account = m.get('ManagerAccount')
        if m.get('ManagerAccountPassword') is not None:
            self.manager_account_password = m.get('ManagerAccountPassword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteVectorIndexResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteVectorIndexResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVectorIndexResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVectorIndexResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccountsRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        account_type: str = None,
        dbinstance_id: str = None,
    ):
        # The name of the database account.
        self.account_name = account_name
        # The type of the database account that you want to query. Valid values: Super, Normal, and All. Default value: Super. If you set this parameter to Super, the information about the privileged account is returned. If you set this parameter to Normal, the information about all standard accounts is returned. If you set this parameter to All, the information about all database accounts is returned.
        self.account_type = account_type
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeAccountsResponseBodyAccountsDBInstanceAccount(TeaModel):
    def __init__(
        self,
        account_description: str = None,
        account_name: str = None,
        account_status: str = None,
        account_type: str = None,
        dbinstance_id: str = None,
    ):
        # The description of the account.
        self.account_description = account_description
        # The name of the account.
        self.account_name = account_name
        # The state of the account.
        # 
        # *   **0**: The account is being created.
        # *   **1**: The account is in use.
        # *   **3**: The account is being deleted.
        self.account_status = account_status
        # The type of the database account. Valid values: Super and Normal. Super indicates a privileged account and Normal indicates a standard account.
        self.account_type = account_type
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_description is not None:
            result['AccountDescription'] = self.account_description
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_status is not None:
            result['AccountStatus'] = self.account_status
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountDescription') is not None:
            self.account_description = m.get('AccountDescription')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountStatus') is not None:
            self.account_status = m.get('AccountStatus')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeAccountsResponseBodyAccounts(TeaModel):
    def __init__(
        self,
        dbinstance_account: List[DescribeAccountsResponseBodyAccountsDBInstanceAccount] = None,
    ):
        self.dbinstance_account = dbinstance_account

    def validate(self):
        if self.dbinstance_account:
            for k in self.dbinstance_account:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceAccount'] = []
        if self.dbinstance_account is not None:
            for k in self.dbinstance_account:
                result['DBInstanceAccount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_account = []
        if m.get('DBInstanceAccount') is not None:
            for k in m.get('DBInstanceAccount'):
                temp_model = DescribeAccountsResponseBodyAccountsDBInstanceAccount()
                self.dbinstance_account.append(temp_model.from_map(k))
        return self


class DescribeAccountsResponseBody(TeaModel):
    def __init__(
        self,
        accounts: DescribeAccountsResponseBodyAccounts = None,
        request_id: str = None,
    ):
        # The queried database accounts.
        self.accounts = accounts
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.accounts:
            self.accounts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accounts is not None:
            result['Accounts'] = self.accounts.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Accounts') is not None:
            temp_model = DescribeAccountsResponseBodyAccounts()
            self.accounts = temp_model.from_map(m['Accounts'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAccountsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccountsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccountsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeActiveSQLRecordsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        keyword: str = None,
        max_duration: str = None,
        min_duration: str = None,
        order: str = None,
        start_time: str = None,
        user: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database = database
        # The end of the time range to query. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The end time must be later than the start time.
        self.end_time = end_time
        # The keyword used to filter queries.
        self.keyword = keyword
        # The maxmum amount of time consumed by traces. Unit: milliseconds.
        self.max_duration = max_duration
        # The minimum amount of time consumed by traces. Unit: milliseconds.
        self.min_duration = min_duration
        # The field used to sort lock diagnostics records and the sorting order.
        # 
        # Default value: `{"Field":"StartTime","Type":"Desc"}`, which indicates that lock diagnostics records are sorted by the start time in descending order. No other values are supported.
        self.order = order
        # The beginning of the time range to query. Specify the time in the yyyy-MM-ddTHH:mmZ format. The time must be in UTC.
        self.start_time = start_time
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.max_duration is not None:
            result['MaxDuration'] = self.max_duration
        if self.min_duration is not None:
            result['MinDuration'] = self.min_duration
        if self.order is not None:
            result['Order'] = self.order
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('MaxDuration') is not None:
            self.max_duration = m.get('MaxDuration')
        if m.get('MinDuration') is not None:
            self.min_duration = m.get('MinDuration')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeActiveSQLRecordsResponseBodyQueries(TeaModel):
    def __init__(
        self,
        client_addr: str = None,
        database: str = None,
        pid: str = None,
        query: str = None,
        query_duration: str = None,
        query_start: str = None,
        session_id: str = None,
        sql_truncated: str = None,
        sql_truncated_threshold: str = None,
        state: str = None,
        user: str = None,
    ):
        # The IP address of the client.
        self.client_addr = client_addr
        # The name of the database.
        self.database = database
        # The progress ID.
        self.pid = pid
        # The SQL statement of the query.
        self.query = query
        # The execution duration of the query. Unit: seconds.
        self.query_duration = query_duration
        # The start time of the query.
        self.query_start = query_start
        # The session ID.
        self.session_id = session_id
        # Indicates whether the SQL statement is truncated. Valid values:
        # 
        # *   true
        # *   false
        self.sql_truncated = sql_truncated
        # The threshold that is used to truncate the SQL statement.
        self.sql_truncated_threshold = sql_truncated_threshold
        # The status of the asynchronous request. Valid values:
        # 
        # *   **running**\
        # *   **block**\
        self.state = state
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_addr is not None:
            result['ClientAddr'] = self.client_addr
        if self.database is not None:
            result['Database'] = self.database
        if self.pid is not None:
            result['PID'] = self.pid
        if self.query is not None:
            result['Query'] = self.query
        if self.query_duration is not None:
            result['QueryDuration'] = self.query_duration
        if self.query_start is not None:
            result['QueryStart'] = self.query_start
        if self.session_id is not None:
            result['SessionID'] = self.session_id
        if self.sql_truncated is not None:
            result['SqlTruncated'] = self.sql_truncated
        if self.sql_truncated_threshold is not None:
            result['SqlTruncatedThreshold'] = self.sql_truncated_threshold
        if self.state is not None:
            result['State'] = self.state
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientAddr') is not None:
            self.client_addr = m.get('ClientAddr')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('PID') is not None:
            self.pid = m.get('PID')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('QueryDuration') is not None:
            self.query_duration = m.get('QueryDuration')
        if m.get('QueryStart') is not None:
            self.query_start = m.get('QueryStart')
        if m.get('SessionID') is not None:
            self.session_id = m.get('SessionID')
        if m.get('SqlTruncated') is not None:
            self.sql_truncated = m.get('SqlTruncated')
        if m.get('SqlTruncatedThreshold') is not None:
            self.sql_truncated_threshold = m.get('SqlTruncatedThreshold')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeActiveSQLRecordsResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        queries: List[DescribeActiveSQLRecordsResponseBodyQueries] = None,
        request_id: str = None,
    ):
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The queried SQL records.
        self.queries = queries
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.queries:
            for k in self.queries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        result['Queries'] = []
        if self.queries is not None:
            for k in self.queries:
                result['Queries'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        self.queries = []
        if m.get('Queries') is not None:
            for k in m.get('Queries'):
                temp_model = DescribeActiveSQLRecordsResponseBodyQueries()
                self.queries.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeActiveSQLRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeActiveSQLRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeActiveSQLRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableResourcesRequest(TeaModel):
    def __init__(
        self,
        charge_type: str = None,
        region: str = None,
        zone_id: str = None,
    ):
        # The billing method. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go.
        # *   **Prepaid**: subscription.
        self.charge_type = charge_type
        # The region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region = region
        # The zone ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent zone list.
        # 
        # This parameter is required.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.region is not None:
            result['Region'] = self.region
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAvailableResourcesResponseBodyResourcesSupportedEnginesSupportedInstanceClassesNodeCount(TeaModel):
    def __init__(
        self,
        max_count: str = None,
        min_count: str = None,
        step: str = None,
    ):
        # The maximum number of compute nodes.
        self.max_count = max_count
        # The minimum number of compute nodes.
        self.min_count = min_count
        # The step size for adding compute nodes.
        # 
        # For example, if the value of this parameter is 4, compute nodes must be added by multiples of 4.
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_count is not None:
            result['MaxCount'] = self.max_count
        if self.min_count is not None:
            result['MinCount'] = self.min_count
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxCount') is not None:
            self.max_count = m.get('MaxCount')
        if m.get('MinCount') is not None:
            self.min_count = m.get('MinCount')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeAvailableResourcesResponseBodyResourcesSupportedEnginesSupportedInstanceClassesStorageSize(TeaModel):
    def __init__(
        self,
        max_count: str = None,
        min_count: str = None,
        step: str = None,
    ):
        # The maximum storage capacity of each compute node.
        self.max_count = max_count
        # The minimum storage capacity of each compute node.
        self.min_count = min_count
        # The step size for adding storage capacity for compute nodes.
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_count is not None:
            result['MaxCount'] = self.max_count
        if self.min_count is not None:
            result['MinCount'] = self.min_count
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxCount') is not None:
            self.max_count = m.get('MaxCount')
        if m.get('MinCount') is not None:
            self.min_count = m.get('MinCount')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeAvailableResourcesResponseBodyResourcesSupportedEnginesSupportedInstanceClasses(TeaModel):
    def __init__(
        self,
        category: str = None,
        description: str = None,
        display_class: str = None,
        instance_class: str = None,
        node_count: DescribeAvailableResourcesResponseBodyResourcesSupportedEnginesSupportedInstanceClassesNodeCount = None,
        storage_size: DescribeAvailableResourcesResponseBodyResourcesSupportedEnginesSupportedInstanceClassesStorageSize = None,
        storage_type: str = None,
    ):
        # The instance edition. Valid values:
        # 
        # *   **HighAvailability**: High-availability Edition
        # *   **Basic**: Basic Edition
        self.category = category
        # The description of compute node specifications.
        self.description = description
        # The specifications of each compute node.
        self.display_class = display_class
        # The specifications of each compute node.
        self.instance_class = instance_class
        # Details about the compute nodes.
        self.node_count = node_count
        # Details about the storage capacity of compute nodes.
        self.storage_size = storage_size
        # The storage type. Valid values:
        # 
        # *   **cloud_essd**: enhanced SSD (ESSD)
        # *   **cloud_efficiency**: ultra disk
        # *   **oss**: Object Storage Service (OSS)
        self.storage_type = storage_type

    def validate(self):
        if self.node_count:
            self.node_count.validate()
        if self.storage_size:
            self.storage_size.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        if self.display_class is not None:
            result['DisplayClass'] = self.display_class
        if self.instance_class is not None:
            result['InstanceClass'] = self.instance_class
        if self.node_count is not None:
            result['NodeCount'] = self.node_count.to_map()
        if self.storage_size is not None:
            result['StorageSize'] = self.storage_size.to_map()
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayClass') is not None:
            self.display_class = m.get('DisplayClass')
        if m.get('InstanceClass') is not None:
            self.instance_class = m.get('InstanceClass')
        if m.get('NodeCount') is not None:
            temp_model = DescribeAvailableResourcesResponseBodyResourcesSupportedEnginesSupportedInstanceClassesNodeCount()
            self.node_count = temp_model.from_map(m['NodeCount'])
        if m.get('StorageSize') is not None:
            temp_model = DescribeAvailableResourcesResponseBodyResourcesSupportedEnginesSupportedInstanceClassesStorageSize()
            self.storage_size = temp_model.from_map(m['StorageSize'])
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class DescribeAvailableResourcesResponseBodyResourcesSupportedEngines(TeaModel):
    def __init__(
        self,
        mode: str = None,
        supported_engine_version: str = None,
        supported_instance_classes: List[DescribeAvailableResourcesResponseBodyResourcesSupportedEnginesSupportedInstanceClasses] = None,
    ):
        # The instance resource type. Valid values:
        # 
        # *   **ecs**: elastic storage mode
        # *   **serverless**: Serverless mode
        self.mode = mode
        # The available engine version.
        self.supported_engine_version = supported_engine_version
        # The available specifications.
        self.supported_instance_classes = supported_instance_classes

    def validate(self):
        if self.supported_instance_classes:
            for k in self.supported_instance_classes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.supported_engine_version is not None:
            result['SupportedEngineVersion'] = self.supported_engine_version
        result['SupportedInstanceClasses'] = []
        if self.supported_instance_classes is not None:
            for k in self.supported_instance_classes:
                result['SupportedInstanceClasses'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('SupportedEngineVersion') is not None:
            self.supported_engine_version = m.get('SupportedEngineVersion')
        self.supported_instance_classes = []
        if m.get('SupportedInstanceClasses') is not None:
            for k in m.get('SupportedInstanceClasses'):
                temp_model = DescribeAvailableResourcesResponseBodyResourcesSupportedEnginesSupportedInstanceClasses()
                self.supported_instance_classes.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourcesResponseBodyResources(TeaModel):
    def __init__(
        self,
        supported_engines: List[DescribeAvailableResourcesResponseBodyResourcesSupportedEngines] = None,
        zone_id: str = None,
    ):
        # The available engine version and specifications.
        self.supported_engines = supported_engines
        # The ID of the zone.
        self.zone_id = zone_id

    def validate(self):
        if self.supported_engines:
            for k in self.supported_engines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SupportedEngines'] = []
        if self.supported_engines is not None:
            for k in self.supported_engines:
                result['SupportedEngines'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.supported_engines = []
        if m.get('SupportedEngines') is not None:
            for k in m.get('SupportedEngines'):
                temp_model = DescribeAvailableResourcesResponseBodyResourcesSupportedEngines()
                self.supported_engines.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAvailableResourcesResponseBody(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        request_id: str = None,
        resources: List[DescribeAvailableResourcesResponseBodyResources] = None,
    ):
        # The region ID.
        self.region_id = region_id
        # The request ID.
        self.request_id = request_id
        # The zone ID.
        self.resources = resources

    def validate(self):
        if self.resources:
            for k in self.resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Resources'] = []
        if self.resources is not None:
            for k in self.resources:
                result['Resources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.resources = []
        if m.get('Resources') is not None:
            for k in m.get('Resources'):
                temp_model = DescribeAvailableResourcesResponseBodyResources()
                self.resources.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAvailableResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupJobRequest(TeaModel):
    def __init__(
        self,
        backup_job_id: int = None,
        dbinstance_id: str = None,
    ):
        # This parameter is required.
        self.backup_job_id = backup_job_id
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeBackupJobResponseBody(TeaModel):
    def __init__(
        self,
        backup_id: str = None,
        backup_job_id: str = None,
        backup_mode: str = None,
        backup_status: str = None,
        process: str = None,
        request_id: str = None,
        start_time: str = None,
    ):
        self.backup_id = backup_id
        self.backup_job_id = backup_job_id
        self.backup_mode = backup_mode
        self.backup_status = backup_status
        self.process = process
        self.request_id = request_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.process is not None:
            result['Process'] = self.process
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeBackupJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        backup_retention_period: int = None,
        enable_recovery_point: bool = None,
        preferred_backup_period: str = None,
        preferred_backup_time: str = None,
        recovery_point_period: str = None,
        request_id: str = None,
    ):
        # The number of days for which data backup files are retained.
        self.backup_retention_period = backup_retention_period
        # Indicates whether automatic point-in-time backup is enabled. Valid values:
        # 
        # *   **true**: Automatic point-in-time backup is enabled.
        # *   **false**: Automatic point-in-time backup is disabled.
        self.enable_recovery_point = enable_recovery_point
        # The cycle based on which backups are performed. If more than one day of the week is specified, the days of the week are separated by commas (,). Valid values:
        # 
        # *   **Monday**\
        # *   **Tuesday**\
        # *   **Wednesday**\
        # *   **Thursday**\
        # *   **Friday**\
        # *   **Saturday**\
        # *   **Sunday**\
        self.preferred_backup_period = preferred_backup_period
        # The backup time. The time is in the HH:mmZ-HH:mmZ format. The time is displayed in UTC.
        self.preferred_backup_time = preferred_backup_time
        # The frequency of the point-in-time backup. Valid values:
        # 
        # *   **1**: per hour
        # *   **2**: per 2 hours
        # *   **4**: per 4 hours
        # *   **8**: per 8 hours
        self.recovery_point_period = recovery_point_period
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_retention_period is not None:
            result['BackupRetentionPeriod'] = self.backup_retention_period
        if self.enable_recovery_point is not None:
            result['EnableRecoveryPoint'] = self.enable_recovery_point
        if self.preferred_backup_period is not None:
            result['PreferredBackupPeriod'] = self.preferred_backup_period
        if self.preferred_backup_time is not None:
            result['PreferredBackupTime'] = self.preferred_backup_time
        if self.recovery_point_period is not None:
            result['RecoveryPointPeriod'] = self.recovery_point_period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupRetentionPeriod') is not None:
            self.backup_retention_period = m.get('BackupRetentionPeriod')
        if m.get('EnableRecoveryPoint') is not None:
            self.enable_recovery_point = m.get('EnableRecoveryPoint')
        if m.get('PreferredBackupPeriod') is not None:
            self.preferred_backup_period = m.get('PreferredBackupPeriod')
        if m.get('PreferredBackupTime') is not None:
            self.preferred_backup_time = m.get('PreferredBackupTime')
        if m.get('RecoveryPointPeriod') is not None:
            self.recovery_point_period = m.get('RecoveryPointPeriod')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCollectionRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # The name of the collection.
        # 
        # >  You can call the [ListCollections](https://help.aliyun.com/document_detail/2401503.html) operation to query a list of collections.
        # 
        # This parameter is required.
        self.collection = collection
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The name of the namespace.
        # 
        # >  You can call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        self.namespace = namespace
        # The password of the namespace.
        # 
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the workspace that consists of multiple AnalyticDB for PostgreSQL instances. You must specify one of the WorkspaceId and DBInstanceId parameters. If you specify both parameters, the WorkspaceId parameter takes effect.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DescribeCollectionResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        dimension: int = None,
        full_text_retrieval_fields: str = None,
        message: str = None,
        metadata: Dict[str, str] = None,
        metrics: str = None,
        namespace: str = None,
        parser: str = None,
        region_id: str = None,
        request_id: str = None,
        sparse_vector_metrics: str = None,
        status: str = None,
        support_sparse: bool = None,
    ):
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The number of vector dimensions.
        self.dimension = dimension
        # The fields that are used for full-text search. Multiple fields are separated by commas (,).
        self.full_text_retrieval_fields = full_text_retrieval_fields
        # The returned message.
        self.message = message
        # The metadata of vector data, which is a JSON string in the MAP format. The key specifies the field name, and the value specifies the data type.
        # 
        # **\
        # 
        # **Warning** Reserved fields such as id, vector, and to_tsvector cannot be used.
        self.metadata = metadata
        # The distance metrics.
        self.metrics = metrics
        # The name of the namespace.
        self.namespace = namespace
        # The analyzer that is used for full-text search.
        self.parser = parser
        # The region ID of the instance.
        self.region_id = region_id
        # The request ID.
        self.request_id = request_id
        self.sparse_vector_metrics = sparse_vector_metrics
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status
        self.support_sparse = support_sparse

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.full_text_retrieval_fields is not None:
            result['FullTextRetrievalFields'] = self.full_text_retrieval_fields
        if self.message is not None:
            result['Message'] = self.message
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.metrics is not None:
            result['Metrics'] = self.metrics
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.parser is not None:
            result['Parser'] = self.parser
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sparse_vector_metrics is not None:
            result['SparseVectorMetrics'] = self.sparse_vector_metrics
        if self.status is not None:
            result['Status'] = self.status
        if self.support_sparse is not None:
            result['SupportSparse'] = self.support_sparse
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('FullTextRetrievalFields') is not None:
            self.full_text_retrieval_fields = m.get('FullTextRetrievalFields')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('Metrics') is not None:
            self.metrics = m.get('Metrics')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Parser') is not None:
            self.parser = m.get('Parser')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SparseVectorMetrics') is not None:
            self.sparse_vector_metrics = m.get('SparseVectorMetrics')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SupportSparse') is not None:
            self.support_sparse = m.get('SupportSparse')
        return self


class DescribeCollectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCollectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCollectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCreateIndexJobRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        job_id: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.collection = collection
        self.dbinstance_id = dbinstance_id
        # This parameter is required.
        self.job_id = job_id
        # This parameter is required.
        self.namespace = namespace
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # This parameter is required.
        self.region_id = region_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DescribeCreateIndexJobResponseBodyJob(TeaModel):
    def __init__(
        self,
        completed: bool = None,
        create_time: str = None,
        error: str = None,
        id: str = None,
        progress: int = None,
        status: str = None,
        update_time: str = None,
    ):
        self.completed = completed
        self.create_time = create_time
        self.error = error
        # Job ID。
        self.id = id
        self.progress = progress
        self.status = status
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.completed is not None:
            result['Completed'] = self.completed
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error is not None:
            result['Error'] = self.error
        if self.id is not None:
            result['Id'] = self.id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Completed') is not None:
            self.completed = m.get('Completed')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Error') is not None:
            self.error = m.get('Error')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeCreateIndexJobResponseBody(TeaModel):
    def __init__(
        self,
        job: DescribeCreateIndexJobResponseBodyJob = None,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        self.job = job
        self.message = message
        self.request_id = request_id
        self.status = status

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job is not None:
            result['Job'] = self.job.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Job') is not None:
            temp_model = DescribeCreateIndexJobResponseBodyJob()
            self.job = temp_model.from_map(m['Job'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCreateIndexJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCreateIndexJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCreateIndexJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBClusterNodeRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        node_type: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The node type. Valid values:
        # 
        # *   **master**: coordinator node.
        # *   **segment**: compute node.
        # 
        # > If you do not specify this parameter, the information about all nodes is returned.
        self.node_type = node_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class DescribeDBClusterNodeResponseBodyNodes(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The name of the node.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeDBClusterNodeResponseBody(TeaModel):
    def __init__(
        self,
        dbcluster_id: str = None,
        nodes: List[DescribeDBClusterNodeResponseBodyNodes] = None,
        request_id: str = None,
    ):
        # The instance ID.
        self.dbcluster_id = dbcluster_id
        # The name of the node.
        self.nodes = nodes
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbcluster_id is not None:
            result['DBClusterId'] = self.dbcluster_id
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBClusterId') is not None:
            self.dbcluster_id = m.get('DBClusterId')
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = DescribeDBClusterNodeResponseBodyNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBClusterNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBClusterNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBClusterNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBClusterPerformanceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        end_time: str = None,
        key: str = None,
        node_type: str = None,
        nodes: str = None,
        resource_group_name: str = None,
        start_time: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the `YYYY-MM-DDTHH:mmZ` format.
        # 
        # > The end time must be later than the start time. The maximum time range that can be specified is seven days.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The performance metric that you want to query. Separate multiple values with commas (,). For more information, see [Performance parameters](https://help.aliyun.com/document_detail/86943.html).
        # 
        # This parameter is required.
        self.key = key
        # The node type. Valid values:
        # 
        # *   **master**: coordinator node.
        # *   **segment**: compute node.
        # 
        # > If you do not specify this parameter, the performance metrics of all nodes are returned.
        self.node_type = node_type
        # The nodes for which you want to query performance metrics. Separate multiple values with commas (,). Example: `master-10******1,master-10******2`. You can call the [DescribeDBClusterNode](https://help.aliyun.com/document_detail/390136.html) operation to query the names of nodes.
        # 
        # You can also filter the nodes based on their metric values. Valid values:
        # 
        # *   **top10**: the 10 nodes that have the highest metric values.
        # *   **top20**: the 20 nodes that have the highest metric values.
        # *   **bottom10**: the 10 nodes that have the lowest metric values.
        # *   **bottom20**: the 20 nodes that have the lowest metric values.
        self.nodes = nodes
        # The name of the resource group.
        self.resource_group_name = resource_group_name
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the `YYYY-MM-DDTHH:mmZ` format.
        # 
        # > You can query monitoring information only within the last 30 days.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.key is not None:
            result['Key'] = self.key
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.nodes is not None:
            result['Nodes'] = self.nodes
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Nodes') is not None:
            self.nodes = m.get('Nodes')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDBClusterPerformanceResponseBodyPerformanceKeysSeriesValues(TeaModel):
    def __init__(
        self,
        point: List[str] = None,
    ):
        # The value of the performance metric and the time when the metric value was collected.
        self.point = point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.point is not None:
            result['Point'] = self.point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Point') is not None:
            self.point = m.get('Point')
        return self


class DescribeDBClusterPerformanceResponseBodyPerformanceKeysSeries(TeaModel):
    def __init__(
        self,
        name: str = None,
        role: str = None,
        values: List[DescribeDBClusterPerformanceResponseBodyPerformanceKeysSeriesValues] = None,
    ):
        # The name of the compute node or compute group.
        self.name = name
        # The role of the node. Valid values:
        # 
        # *   **master**: primary coordinator node
        # *   **standby**: standby coordinator node
        # *   **segment**: compute node
        self.role = role
        # The value of the performance metric collected at a point in time.
        self.values = values

    def validate(self):
        if self.values:
            for k in self.values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.role is not None:
            result['Role'] = self.role
        result['Values'] = []
        if self.values is not None:
            for k in self.values:
                result['Values'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        self.values = []
        if m.get('Values') is not None:
            for k in m.get('Values'):
                temp_model = DescribeDBClusterPerformanceResponseBodyPerformanceKeysSeriesValues()
                self.values.append(temp_model.from_map(k))
        return self


class DescribeDBClusterPerformanceResponseBodyPerformanceKeys(TeaModel):
    def __init__(
        self,
        name: str = None,
        series: List[DescribeDBClusterPerformanceResponseBodyPerformanceKeysSeries] = None,
        unit: str = None,
    ):
        # The name of the performance metric. For more information, see [Performance parameters](https://help.aliyun.com/document_detail/86943.html).
        self.name = name
        # Details of the performance metric of a node.
        self.series = series
        # The unit of the performance metric.
        self.unit = unit

    def validate(self):
        if self.series:
            for k in self.series:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['Series'] = []
        if self.series is not None:
            for k in self.series:
                result['Series'].append(k.to_map() if k else None)
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.series = []
        if m.get('Series') is not None:
            for k in m.get('Series'):
                temp_model = DescribeDBClusterPerformanceResponseBodyPerformanceKeysSeries()
                self.series.append(temp_model.from_map(k))
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class DescribeDBClusterPerformanceResponseBody(TeaModel):
    def __init__(
        self,
        dbcluster_id: str = None,
        end_time: str = None,
        performance_keys: List[DescribeDBClusterPerformanceResponseBodyPerformanceKeys] = None,
        request_id: str = None,
        start_time: str = None,
    ):
        # The instance ID.
        self.dbcluster_id = dbcluster_id
        # The end time of the query. The time follows the ISO 8601 standard in the `YYYY-MM-DDTHH:mmZ` format. The time is displayed in UTC.
        self.end_time = end_time
        # The name of the performance metric. For more information, see [Performance parameters](https://help.aliyun.com/document_detail/86943.html).
        self.performance_keys = performance_keys
        # The request ID.
        self.request_id = request_id
        # The start time of the query. The time follows the ISO 8601 standard in the `YYYY-MM-DDTHH:mmZ` format. The time is displayed in UTC.
        self.start_time = start_time

    def validate(self):
        if self.performance_keys:
            for k in self.performance_keys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbcluster_id is not None:
            result['DBClusterId'] = self.dbcluster_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        result['PerformanceKeys'] = []
        if self.performance_keys is not None:
            for k in self.performance_keys:
                result['PerformanceKeys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBClusterId') is not None:
            self.dbcluster_id = m.get('DBClusterId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        self.performance_keys = []
        if m.get('PerformanceKeys') is not None:
            for k in m.get('PerformanceKeys'):
                temp_model = DescribeDBClusterPerformanceResponseBodyPerformanceKeys()
                self.performance_keys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDBClusterPerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBClusterPerformanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBClusterPerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceAttributeRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        resource_group_id: str = None,
    ):
        # Instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) interface to view the instance IDs of all AnalyticDB for PostgreSQL instances in the target region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # This parameter is deprecated and should not be passed.
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeTagsTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # Tag key.
        self.key = key
        # Tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute(TeaModel):
    def __init__(
        self,
        availability_value: str = None,
        cache_storage_size: str = None,
        connection_mode: str = None,
        connection_string: str = None,
        core_version: str = None,
        cpu_cores: int = None,
        cpu_cores_per_node: int = None,
        creation_time: str = None,
        dbinstance_category: str = None,
        dbinstance_class: str = None,
        dbinstance_class_type: str = None,
        dbinstance_cpu_cores: int = None,
        dbinstance_description: str = None,
        dbinstance_disk_mbps: int = None,
        dbinstance_group_count: str = None,
        dbinstance_id: str = None,
        dbinstance_memory: int = None,
        dbinstance_mode: str = None,
        dbinstance_net_type: str = None,
        dbinstance_status: str = None,
        dbinstance_storage: int = None,
        deploy_mode: str = None,
        encryption_key: str = None,
        encryption_type: str = None,
        engine: str = None,
        engine_version: str = None,
        expire_time: str = None,
        graph_engine_status: str = None,
        host_type: str = None,
        idle_time: int = None,
        instance_network_type: str = None,
        instance_spec: str = None,
        lock_mode: str = None,
        lock_reason: str = None,
        maintain_end_time: str = None,
        maintain_start_time: str = None,
        master_aispec: str = None,
        master_cu: int = None,
        master_node_num: int = None,
        max_connections: int = None,
        memory_per_node: int = None,
        memory_size: int = None,
        memory_unit: str = None,
        minor_version: str = None,
        pay_type: str = None,
        port: str = None,
        prod_type: str = None,
        read_delay_time: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        running_time: str = None,
        security_iplist: str = None,
        seg_disk_performance_level: str = None,
        seg_node_num: int = None,
        segment_aispec: str = None,
        segment_counts: int = None,
        serverless_mode: str = None,
        serverless_resource: int = None,
        standby_zone_id: str = None,
        start_time: str = None,
        storage_per_node: int = None,
        storage_size: int = None,
        storage_type: str = None,
        storage_unit: str = None,
        support_restore: bool = None,
        tags: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeTags = None,
        v_switch_id: str = None,
        vector_configuration_status: str = None,
        vpc_id: str = None,
        zone_id: str = None,
    ):
        # Queries the current instance availability status, in percentage (%).
        # 
        # > This parameter is only applicable to instances in the storage reserved mode.
        self.availability_value = availability_value
        self.cache_storage_size = cache_storage_size
        # Access mode, with the following values:
        # 
        # - **Performance**: Standard access mode.
        # - **Safty**: High-security access mode.
        # - **LVS**: LVS link mode.
        self.connection_mode = connection_mode
        # Instance connection address.
        self.connection_string = connection_string
        # Minor version number of the kernel.
        self.core_version = core_version
        # Number of CPU cores for the compute node, unit: Core.
        self.cpu_cores = cpu_cores
        # Number of CPU cores per node.
        # 
        # > This parameter is only applicable to instances in the storage reserved mode.
        self.cpu_cores_per_node = cpu_cores_per_node
        # Instance creation time.
        self.creation_time = creation_time
        # Instance series, with the following values:
        # 
        # - **Basic**: Basic Edition.
        # - **HighAvailability**: High Availability Edition.
        self.dbinstance_category = dbinstance_category
        # Instance specification.
        # 
        # > This parameter is only applicable to reserved storage mode instances.
        self.dbinstance_class = dbinstance_class
        # Instance family, with the following values:
        # 
        # - **s**: Shared type.
        # - **x**: General type.
        # - **d**: Dedicated package.
        # - **h**: Dedicated physical machine.
        self.dbinstance_class_type = dbinstance_class_type
        # Number of CPU cores.
        self.dbinstance_cpu_cores = dbinstance_cpu_cores
        # Instance description.
        self.dbinstance_description = dbinstance_description
        # Maximum BPS (disk throughput) of the compute group, in Mbps.
        # 
        # > This parameter is only applicable to reserved storage mode instances.
        self.dbinstance_disk_mbps = dbinstance_disk_mbps
        # Number of compute groups.
        # 
        # > This parameter is only applicable to reserved storage mode instances.
        self.dbinstance_group_count = dbinstance_group_count
        # Instance ID.
        self.dbinstance_id = dbinstance_id
        # Memory of the compute node.
        # 
        # > The unit for storage-reserved mode is MB; for Serverless and storage-elastic modes, it is GB.
        self.dbinstance_memory = dbinstance_memory
        # Instance resource type, with the following values:
        # 
        # - **Serverless**: Serverless mode.
        # - **StorageElastic**: Storage elastic mode.
        # - **Classic**: Storage reserved mode.
        self.dbinstance_mode = dbinstance_mode
        # This parameter is deprecated and will not return any value.
        self.dbinstance_net_type = dbinstance_net_type
        # Instance status. For more details, see the supplementary explanation of the DBInstanceStatus parameter.
        self.dbinstance_status = dbinstance_status
        # Maximum storage space of a single replica, in GB.
        self.dbinstance_storage = dbinstance_storage
        # The deployment mode.
        self.deploy_mode = deploy_mode
        # Encryption key.
        # 
        # > This parameter is returned only for instances with disk encryption enabled.
        self.encryption_key = encryption_key
        # Encryption type, with the following value:
        # 
        # - **CloudDisk**: Cloud disk encryption.
        # 
        # > This parameter is returned only for instances with cloud disk encryption.
        self.encryption_type = encryption_type
        # Database engine.
        self.engine = engine
        # Database version.
        self.engine_version = engine_version
        # Instance expiration time (in UTC).
        # 
        # > The expiration time for pay-as-you-go instances is `2999-09-08T16:00:00Z`.
        self.expire_time = expire_time
        self.graph_engine_status = graph_engine_status
        # Compute group machine type, with the following values:
        # - **0**: SSD
        # - **1**: HDD
        # 
        # > This parameter applies only to storage-reserved mode instances.
        self.host_type = host_type
        # Idle release waiting time. Unit: seconds.
        # 
        # > This parameter is returned only for instances in the Serverless automatic scheduling mode.
        self.idle_time = idle_time
        # Instance network type, with the following values:
        # 
        # - **Classic**: Classic network.
        # - **VPC**: VPC network.
        self.instance_network_type = instance_network_type
        self.instance_spec = instance_spec
        # Lock mode, with the following values:
        # 
        # - **Unlock**: Normal.
        # - **ManualLock**: Manually triggered lock.
        # - **LockByExpiration**: Automatically locked when the instance expires.
        # - **LockByRestoration**: Automatically locked before the instance rolls back.
        # - **LockByDiskQuota**: Automatically locked when the instance space is full.
        self.lock_mode = lock_mode
        # This parameter is deprecated and will not return any value.
        self.lock_reason = lock_reason
        # Maintenance end time.
        self.maintain_end_time = maintain_end_time
        # Maintenance start time.
        self.maintain_start_time = maintain_start_time
        # The specifications of AI coordinator node resources of the instance. If the coordinator nodes of the instance are not AI nodes, null is returned.
        self.master_aispec = master_aispec
        # Master resources.
        self.master_cu = master_cu
        # Number of Master nodes.
        self.master_node_num = master_node_num
        # Maximum number of concurrent connections for the instance.
        # 
        # > This parameter is only applicable to reserved storage mode instances.
        self.max_connections = max_connections
        # Memory size per replica, see the **MemoryUnit** parameter for the unit.
        # 
        # > This parameter is only applicable to instances in the storage reserved mode.
        self.memory_per_node = memory_per_node
        # Memory size of the compute node.
        # 
        # > The unit is MB for the storage reserved mode; GB for Serverless and storage elastic modes.
        self.memory_size = memory_size
        # Memory unit.
        # 
        # > This parameter is only applicable to reserved storage mode instances.
        self.memory_unit = memory_unit
        # Minor version of the kernel.
        self.minor_version = minor_version
        # Billing type, with the following values:
        # 
        # - **Postpaid**: Pay-as-you-go.
        # - **Prepaid**: Subscription.
        self.pay_type = pay_type
        # Instance port number.
        self.port = port
        # The service type.
        self.prod_type = prod_type
        # This parameter has been deprecated and will not return a value.
        self.read_delay_time = read_delay_time
        # Region ID.
        self.region_id = region_id
        # ID of the resource group where the instance is located.
        self.resource_group_id = resource_group_id
        # Instance running time.
        self.running_time = running_time
        # This parameter is deprecated and will not return any value.
        self.security_iplist = security_iplist
        # Performance Level (PL), currently only **PL1** is supported.
        self.seg_disk_performance_level = seg_disk_performance_level
        # Number of Segment nodes.
        # 
        # > This parameter applies only to instances in the storage elastic mode and Serverless manual scheduling mode.
        self.seg_node_num = seg_node_num
        # The specifications of AI compute node resources of the instance. If the compute nodes of the instance are not AI nodes, null is returned.
        self.segment_aispec = segment_aispec
        # Number of compute groups.
        # 
        # > This parameter applies only to storage-reserved mode instances.
        self.segment_counts = segment_counts
        # The mode of the Serverless instance, with the following values:
        # 
        # - **Manual**: Manual scheduling.
        # - **Auto**: Automatic scheduling.
        # 
        # > This parameter is returned only for Serverless mode instances.
        self.serverless_mode = serverless_mode
        # Compute resource threshold. Unit: ACU.
        # 
        # > This parameter is returned only for instances in the Serverless automatic scheduling mode.
        self.serverless_resource = serverless_resource
        # The secondary zone ID.
        self.standby_zone_id = standby_zone_id
        # The time when the instance started running.
        self.start_time = start_time
        # Storage size per replica, see the **StorageUnit** parameter for units.
        # 
        # > This parameter applies only to storage-reserved mode instances.
        self.storage_per_node = storage_per_node
        # Storage space size, unit: GB.
        self.storage_size = storage_size
        # Storage type, with the following values:
        # 
        # - **cloud_essd**: ESSD cloud disk.
        # - **cloud_efficiency**: Efficient cloud disk.
        # 
        # > This parameter is only applicable to instances in the storage elastic mode.
        self.storage_type = storage_type
        # Storage unit, with the following values:
        # 
        # - **GB SSD**\
        # - **TB SSD**\
        # - **GB HDD**\
        # 
        # > This parameter is only applicable to instances in the storage reserved mode.
        self.storage_unit = storage_unit
        # Indicates whether backup recovery is supported, with the following values:
        # 
        # - **true**: Backup recovery is supported.
        # - **false**: Backup recovery is not supported.
        self.support_restore = support_restore
        # Tag key-value pairs.
        self.tags = tags
        # vSwitch ID.
        self.v_switch_id = v_switch_id
        # Indicates whether vector engine optimization is enabled. The values are as follows:
        # - **enabled**: Indicates that vector engine optimization is enabled.
        # - **disabled**: Indicates that vector engine optimization is disabled.
        self.vector_configuration_status = vector_configuration_status
        # VPC ID.
        self.vpc_id = vpc_id
        # Zone ID.
        self.zone_id = zone_id

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.availability_value is not None:
            result['AvailabilityValue'] = self.availability_value
        if self.cache_storage_size is not None:
            result['CacheStorageSize'] = self.cache_storage_size
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.core_version is not None:
            result['CoreVersion'] = self.core_version
        if self.cpu_cores is not None:
            result['CpuCores'] = self.cpu_cores
        if self.cpu_cores_per_node is not None:
            result['CpuCoresPerNode'] = self.cpu_cores_per_node
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.dbinstance_category is not None:
            result['DBInstanceCategory'] = self.dbinstance_category
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_class_type is not None:
            result['DBInstanceClassType'] = self.dbinstance_class_type
        if self.dbinstance_cpu_cores is not None:
            result['DBInstanceCpuCores'] = self.dbinstance_cpu_cores
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_disk_mbps is not None:
            result['DBInstanceDiskMBPS'] = self.dbinstance_disk_mbps
        if self.dbinstance_group_count is not None:
            result['DBInstanceGroupCount'] = self.dbinstance_group_count
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_memory is not None:
            result['DBInstanceMemory'] = self.dbinstance_memory
        if self.dbinstance_mode is not None:
            result['DBInstanceMode'] = self.dbinstance_mode
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.deploy_mode is not None:
            result['DeployMode'] = self.deploy_mode
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        if self.encryption_type is not None:
            result['EncryptionType'] = self.encryption_type
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.graph_engine_status is not None:
            result['GraphEngineStatus'] = self.graph_engine_status
        if self.host_type is not None:
            result['HostType'] = self.host_type
        if self.idle_time is not None:
            result['IdleTime'] = self.idle_time
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.maintain_end_time is not None:
            result['MaintainEndTime'] = self.maintain_end_time
        if self.maintain_start_time is not None:
            result['MaintainStartTime'] = self.maintain_start_time
        if self.master_aispec is not None:
            result['MasterAISpec'] = self.master_aispec
        if self.master_cu is not None:
            result['MasterCU'] = self.master_cu
        if self.master_node_num is not None:
            result['MasterNodeNum'] = self.master_node_num
        if self.max_connections is not None:
            result['MaxConnections'] = self.max_connections
        if self.memory_per_node is not None:
            result['MemoryPerNode'] = self.memory_per_node
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.memory_unit is not None:
            result['MemoryUnit'] = self.memory_unit
        if self.minor_version is not None:
            result['MinorVersion'] = self.minor_version
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.port is not None:
            result['Port'] = self.port
        if self.prod_type is not None:
            result['ProdType'] = self.prod_type
        if self.read_delay_time is not None:
            result['ReadDelayTime'] = self.read_delay_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.seg_disk_performance_level is not None:
            result['SegDiskPerformanceLevel'] = self.seg_disk_performance_level
        if self.seg_node_num is not None:
            result['SegNodeNum'] = self.seg_node_num
        if self.segment_aispec is not None:
            result['SegmentAISpec'] = self.segment_aispec
        if self.segment_counts is not None:
            result['SegmentCounts'] = self.segment_counts
        if self.serverless_mode is not None:
            result['ServerlessMode'] = self.serverless_mode
        if self.serverless_resource is not None:
            result['ServerlessResource'] = self.serverless_resource
        if self.standby_zone_id is not None:
            result['StandbyZoneId'] = self.standby_zone_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.storage_per_node is not None:
            result['StoragePerNode'] = self.storage_per_node
        if self.storage_size is not None:
            result['StorageSize'] = self.storage_size
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        if self.storage_unit is not None:
            result['StorageUnit'] = self.storage_unit
        if self.support_restore is not None:
            result['SupportRestore'] = self.support_restore
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vector_configuration_status is not None:
            result['VectorConfigurationStatus'] = self.vector_configuration_status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailabilityValue') is not None:
            self.availability_value = m.get('AvailabilityValue')
        if m.get('CacheStorageSize') is not None:
            self.cache_storage_size = m.get('CacheStorageSize')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('CoreVersion') is not None:
            self.core_version = m.get('CoreVersion')
        if m.get('CpuCores') is not None:
            self.cpu_cores = m.get('CpuCores')
        if m.get('CpuCoresPerNode') is not None:
            self.cpu_cores_per_node = m.get('CpuCoresPerNode')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DBInstanceCategory') is not None:
            self.dbinstance_category = m.get('DBInstanceCategory')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceClassType') is not None:
            self.dbinstance_class_type = m.get('DBInstanceClassType')
        if m.get('DBInstanceCpuCores') is not None:
            self.dbinstance_cpu_cores = m.get('DBInstanceCpuCores')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceDiskMBPS') is not None:
            self.dbinstance_disk_mbps = m.get('DBInstanceDiskMBPS')
        if m.get('DBInstanceGroupCount') is not None:
            self.dbinstance_group_count = m.get('DBInstanceGroupCount')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceMemory') is not None:
            self.dbinstance_memory = m.get('DBInstanceMemory')
        if m.get('DBInstanceMode') is not None:
            self.dbinstance_mode = m.get('DBInstanceMode')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DeployMode') is not None:
            self.deploy_mode = m.get('DeployMode')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        if m.get('EncryptionType') is not None:
            self.encryption_type = m.get('EncryptionType')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('GraphEngineStatus') is not None:
            self.graph_engine_status = m.get('GraphEngineStatus')
        if m.get('HostType') is not None:
            self.host_type = m.get('HostType')
        if m.get('IdleTime') is not None:
            self.idle_time = m.get('IdleTime')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('MaintainEndTime') is not None:
            self.maintain_end_time = m.get('MaintainEndTime')
        if m.get('MaintainStartTime') is not None:
            self.maintain_start_time = m.get('MaintainStartTime')
        if m.get('MasterAISpec') is not None:
            self.master_aispec = m.get('MasterAISpec')
        if m.get('MasterCU') is not None:
            self.master_cu = m.get('MasterCU')
        if m.get('MasterNodeNum') is not None:
            self.master_node_num = m.get('MasterNodeNum')
        if m.get('MaxConnections') is not None:
            self.max_connections = m.get('MaxConnections')
        if m.get('MemoryPerNode') is not None:
            self.memory_per_node = m.get('MemoryPerNode')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        if m.get('MemoryUnit') is not None:
            self.memory_unit = m.get('MemoryUnit')
        if m.get('MinorVersion') is not None:
            self.minor_version = m.get('MinorVersion')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProdType') is not None:
            self.prod_type = m.get('ProdType')
        if m.get('ReadDelayTime') is not None:
            self.read_delay_time = m.get('ReadDelayTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('SegDiskPerformanceLevel') is not None:
            self.seg_disk_performance_level = m.get('SegDiskPerformanceLevel')
        if m.get('SegNodeNum') is not None:
            self.seg_node_num = m.get('SegNodeNum')
        if m.get('SegmentAISpec') is not None:
            self.segment_aispec = m.get('SegmentAISpec')
        if m.get('SegmentCounts') is not None:
            self.segment_counts = m.get('SegmentCounts')
        if m.get('ServerlessMode') is not None:
            self.serverless_mode = m.get('ServerlessMode')
        if m.get('ServerlessResource') is not None:
            self.serverless_resource = m.get('ServerlessResource')
        if m.get('StandbyZoneId') is not None:
            self.standby_zone_id = m.get('StandbyZoneId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StoragePerNode') is not None:
            self.storage_per_node = m.get('StoragePerNode')
        if m.get('StorageSize') is not None:
            self.storage_size = m.get('StorageSize')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        if m.get('StorageUnit') is not None:
            self.storage_unit = m.get('StorageUnit')
        if m.get('SupportRestore') is not None:
            self.support_restore = m.get('SupportRestore')
        if m.get('Tags') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VectorConfigurationStatus') is not None:
            self.vector_configuration_status = m.get('VectorConfigurationStatus')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDBInstanceAttributeResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance_attribute: List[DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute] = None,
    ):
        self.dbinstance_attribute = dbinstance_attribute

    def validate(self):
        if self.dbinstance_attribute:
            for k in self.dbinstance_attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceAttribute'] = []
        if self.dbinstance_attribute is not None:
            for k in self.dbinstance_attribute:
                result['DBInstanceAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_attribute = []
        if m.get('DBInstanceAttribute') is not None:
            for k in m.get('DBInstanceAttribute'):
                temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute()
                self.dbinstance_attribute.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceAttributeResponseBody(TeaModel):
    def __init__(
        self,
        items: DescribeDBInstanceAttributeResponseBodyItems = None,
        request_id: str = None,
    ):
        # The queried instance.
        self.items = items
        # Request ID.
        self.request_id = request_id

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceDataBloatRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database = database
        # The sorting order.
        self.order_by = order_by
        # The number of the page to return. The value must be an integer that is greater than 0. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDBInstanceDataBloatResponseBodyItems(TeaModel):
    def __init__(
        self,
        bloat_ceoff: str = None,
        bloat_size: str = None,
        database_name: str = None,
        expect_table_size: str = None,
        real_table_size: str = None,
        schema_name: str = None,
        sequence: int = None,
        storage_type: str = None,
        suggested_action: str = None,
        table_name: str = None,
        time_last_updated: str = None,
        time_last_vacuumed: str = None,
    ):
        # The coefficient of data bloat. It is calculated by using the following formula:
        # 
        # Bloat coefficient = Number of dead rows/Number of active rows.
        self.bloat_ceoff = bloat_ceoff
        # The bloat size of the table. It indicates the amount of space that can be released.
        self.bloat_size = bloat_size
        # The name of the database.
        self.database_name = database_name
        # The expected size of the table.
        # 
        # It indicates the size of the table that has no data bloat.
        self.expect_table_size = expect_table_size
        # The actual size of the table.
        self.real_table_size = real_table_size
        # The name of the schema.
        self.schema_name = schema_name
        # The sequence number.
        self.sequence = sequence
        # The storage type of the table. Valid values:
        # 
        # *   **Heap Table**\
        # *   **Append-Only Heap Table**\
        # *   **Append-Only Columnar Table**\
        self.storage_type = storage_type
        # This parameter is not returned.
        self.suggested_action = suggested_action
        # The name of the table.
        self.table_name = table_name
        # The time when the table was last deleted, inserted, or updated.
        self.time_last_updated = time_last_updated
        # The time when the table was last vacuumed. The time is displayed in UTC.
        self.time_last_vacuumed = time_last_vacuumed

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bloat_ceoff is not None:
            result['BloatCeoff'] = self.bloat_ceoff
        if self.bloat_size is not None:
            result['BloatSize'] = self.bloat_size
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.expect_table_size is not None:
            result['ExpectTableSize'] = self.expect_table_size
        if self.real_table_size is not None:
            result['RealTableSize'] = self.real_table_size
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        if self.suggested_action is not None:
            result['SuggestedAction'] = self.suggested_action
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.time_last_updated is not None:
            result['TimeLastUpdated'] = self.time_last_updated
        if self.time_last_vacuumed is not None:
            result['TimeLastVacuumed'] = self.time_last_vacuumed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BloatCeoff') is not None:
            self.bloat_ceoff = m.get('BloatCeoff')
        if m.get('BloatSize') is not None:
            self.bloat_size = m.get('BloatSize')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('ExpectTableSize') is not None:
            self.expect_table_size = m.get('ExpectTableSize')
        if m.get('RealTableSize') is not None:
            self.real_table_size = m.get('RealTableSize')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        if m.get('SuggestedAction') is not None:
            self.suggested_action = m.get('SuggestedAction')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TimeLastUpdated') is not None:
            self.time_last_updated = m.get('TimeLastUpdated')
        if m.get('TimeLastVacuumed') is not None:
            self.time_last_vacuumed = m.get('TimeLastVacuumed')
        return self


class DescribeDBInstanceDataBloatResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeDBInstanceDataBloatResponseBodyItems] = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The queried data bloat.
        self.items = items
        # The page number of the returned page.
        self.page_number = page_number
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeDBInstanceDataBloatResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDBInstanceDataBloatResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceDataBloatResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceDataBloatResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceDataSkewRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database = database
        # order by condition
        self.order_by = order_by
        # The number of the page to return. The value must be an integer that is greater than 0. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDBInstanceDataSkewResponseBodyItems(TeaModel):
    def __init__(
        self,
        database_name: str = None,
        distribute_key: str = None,
        owner: str = None,
        schema_name: str = None,
        sequence: int = None,
        table_name: str = None,
        table_size: str = None,
        table_skew: str = None,
        time_last_updated: str = None,
    ):
        # The name of the database.
        self.database_name = database_name
        # The distribution key of the table.
        self.distribute_key = distribute_key
        # The owner of the table.
        self.owner = owner
        # The name of the schema.
        self.schema_name = schema_name
        # The sequence number of the data skew case. All data skew cases are sorted by severity in descending order.
        self.sequence = sequence
        # The name of the table.
        self.table_name = table_name
        # The total number of rows in the table.
        self.table_size = table_size
        # The skew ratio of the table. Valid values: 0 to 100. Unit: %. A greater value indicates that the table is more severely skewed. A smaller value indicates less impact on query performance. A value of 0 indicates no data skew.
        self.table_skew = table_skew
        # The time when the table was last deleted, inserted, or updated.
        self.time_last_updated = time_last_updated

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.distribute_key is not None:
            result['DistributeKey'] = self.distribute_key
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.table_size is not None:
            result['TableSize'] = self.table_size
        if self.table_skew is not None:
            result['TableSkew'] = self.table_skew
        if self.time_last_updated is not None:
            result['TimeLastUpdated'] = self.time_last_updated
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('DistributeKey') is not None:
            self.distribute_key = m.get('DistributeKey')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TableSize') is not None:
            self.table_size = m.get('TableSize')
        if m.get('TableSkew') is not None:
            self.table_skew = m.get('TableSkew')
        if m.get('TimeLastUpdated') is not None:
            self.time_last_updated = m.get('TimeLastUpdated')
        return self


class DescribeDBInstanceDataSkewResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeDBInstanceDataSkewResponseBodyItems] = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # Details about data skew.
        self.items = items
        # The page number of the returned page.
        self.page_number = page_number
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeDBInstanceDataSkewResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDBInstanceDataSkewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceDataSkewResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceDataSkewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceDiagnosisSummaryRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        role_preferd: str = None,
        start_status: str = None,
        sync_mode: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The page number. Pages start from page 1. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **20**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **20**.
        self.page_size = page_size
        # The role state of the node. It specifies whether a primary/secondary switchover occurs. Valid values:
        # 
        # *   **normal**: The node role is normal. No primary/secondary switchover occurs.
        # *   **reverse**: The node role is reversed. A primary/secondary switchover occurs.
        self.role_preferd = role_preferd
        # The running state of the node. Valid values:
        # 
        # *   **UP**: The node is running.
        # *   **DOWN**: The node is faulty.
        # 
        # If you do not specify this parameter, the information about nodes in all running states is returned.
        self.start_status = start_status
        # The data synchronization state of the node. Valid values:
        # 
        # *   **synced**: The node data is synchronized.
        # *   **notSyncing**: The node data is not synchronized.
        # 
        # If you do not specify this parameter, the information about nodes in all synchronization states is returned.
        self.sync_mode = sync_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.role_preferd is not None:
            result['RolePreferd'] = self.role_preferd
        if self.start_status is not None:
            result['StartStatus'] = self.start_status
        if self.sync_mode is not None:
            result['SyncMode'] = self.sync_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RolePreferd') is not None:
            self.role_preferd = m.get('RolePreferd')
        if m.get('StartStatus') is not None:
            self.start_status = m.get('StartStatus')
        if m.get('SyncMode') is not None:
            self.sync_mode = m.get('SyncMode')
        return self


class DescribeDBInstanceDiagnosisSummaryResponseBodyItems(TeaModel):
    def __init__(
        self,
        hostname: str = None,
        node_address: str = None,
        node_cid: str = None,
        node_id: str = None,
        node_name: str = None,
        node_port: str = None,
        node_preferred_role: str = None,
        node_replication_mode: str = None,
        node_role: str = None,
        node_status: str = None,
        node_type: str = None,
    ):
        # The name of the node.
        self.hostname = hostname
        # The IP address of the node.
        self.node_address = node_address
        # The node group ID.
        self.node_cid = node_cid
        # The node ID.
        self.node_id = node_id
        # The name of the host where the node resides.
        self.node_name = node_name
        # The port number of the node.
        self.node_port = node_port
        # The initial role of the node. Valid values:
        # 
        # *   **primary**: primary node.
        # *   **mirror**: secondary node.
        # 
        # If the value of this parameter is the same as that of **NodeRole**, no primary/secondary switchover occurs. If the value of this parameter is different from that of **NodeRole**, a primary/secondary switchover occurs.
        self.node_preferred_role = node_preferred_role
        # The data synchronization state of the node. Valid values:
        # 
        # *   **Synced**: The node data is synchronized.
        # *   **Not Syncing**: The node data is not synchronized.
        # *   **No sync required**: Data synchronization is not required. This value may be returned only for the coordinator node.
        self.node_replication_mode = node_replication_mode
        # The current role of the node. Valid values:
        # 
        # *   **primary**: primary node.
        # *   **mirror**: secondary node.
        self.node_role = node_role
        # The running state of the node. Valid values:
        # 
        # *   **UP**: The node is running.
        # *   **DOWN**: The node is faulty.
        self.node_status = node_status
        # The type of the node. Valid values:
        # 
        # *   **master**: primary coordinator node.
        # *   **slave**: standby coordinator node.
        # *   **segment**: compute node.
        self.node_type = node_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.node_address is not None:
            result['NodeAddress'] = self.node_address
        if self.node_cid is not None:
            result['NodeCID'] = self.node_cid
        if self.node_id is not None:
            result['NodeID'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_port is not None:
            result['NodePort'] = self.node_port
        if self.node_preferred_role is not None:
            result['NodePreferredRole'] = self.node_preferred_role
        if self.node_replication_mode is not None:
            result['NodeReplicationMode'] = self.node_replication_mode
        if self.node_role is not None:
            result['NodeRole'] = self.node_role
        if self.node_status is not None:
            result['NodeStatus'] = self.node_status
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('NodeAddress') is not None:
            self.node_address = m.get('NodeAddress')
        if m.get('NodeCID') is not None:
            self.node_cid = m.get('NodeCID')
        if m.get('NodeID') is not None:
            self.node_id = m.get('NodeID')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodePort') is not None:
            self.node_port = m.get('NodePort')
        if m.get('NodePreferredRole') is not None:
            self.node_preferred_role = m.get('NodePreferredRole')
        if m.get('NodeReplicationMode') is not None:
            self.node_replication_mode = m.get('NodeReplicationMode')
        if m.get('NodeRole') is not None:
            self.node_role = m.get('NodeRole')
        if m.get('NodeStatus') is not None:
            self.node_status = m.get('NodeStatus')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class DescribeDBInstanceDiagnosisSummaryResponseBodyMasterStatusInfo(TeaModel):
    def __init__(
        self,
        exception_node_num: int = None,
        normal_node_num: int = None,
        not_preferred_node_num: int = None,
        not_syncing_node_num: int = None,
        preferred_node_num: int = None,
        synced_node_num: int = None,
    ):
        # The number of abnormal nodes.
        self.exception_node_num = exception_node_num
        # The number of normal nodes.
        self.normal_node_num = normal_node_num
        # The number of nodes whose roles are reversed.
        self.not_preferred_node_num = not_preferred_node_num
        # The number of unsynchronized nodes.
        self.not_syncing_node_num = not_syncing_node_num
        # The number of nodes whose roles are normal.
        self.preferred_node_num = preferred_node_num
        # The number of synchronized nodes.
        self.synced_node_num = synced_node_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exception_node_num is not None:
            result['ExceptionNodeNum'] = self.exception_node_num
        if self.normal_node_num is not None:
            result['NormalNodeNum'] = self.normal_node_num
        if self.not_preferred_node_num is not None:
            result['NotPreferredNodeNum'] = self.not_preferred_node_num
        if self.not_syncing_node_num is not None:
            result['NotSyncingNodeNum'] = self.not_syncing_node_num
        if self.preferred_node_num is not None:
            result['PreferredNodeNum'] = self.preferred_node_num
        if self.synced_node_num is not None:
            result['SyncedNodeNum'] = self.synced_node_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExceptionNodeNum') is not None:
            self.exception_node_num = m.get('ExceptionNodeNum')
        if m.get('NormalNodeNum') is not None:
            self.normal_node_num = m.get('NormalNodeNum')
        if m.get('NotPreferredNodeNum') is not None:
            self.not_preferred_node_num = m.get('NotPreferredNodeNum')
        if m.get('NotSyncingNodeNum') is not None:
            self.not_syncing_node_num = m.get('NotSyncingNodeNum')
        if m.get('PreferredNodeNum') is not None:
            self.preferred_node_num = m.get('PreferredNodeNum')
        if m.get('SyncedNodeNum') is not None:
            self.synced_node_num = m.get('SyncedNodeNum')
        return self


class DescribeDBInstanceDiagnosisSummaryResponseBodySegmentStatusInfo(TeaModel):
    def __init__(
        self,
        exception_node_num: int = None,
        normal_node_num: int = None,
        not_preferred_node_num: int = None,
        not_syncing_node_num: int = None,
        preferred_node_num: int = None,
        synced_node_num: int = None,
    ):
        # The number of abnormal nodes.
        self.exception_node_num = exception_node_num
        # The number of normal nodes.
        self.normal_node_num = normal_node_num
        # The number of nodes whose roles are reversed.
        self.not_preferred_node_num = not_preferred_node_num
        # The number of unsynchronized nodes.
        self.not_syncing_node_num = not_syncing_node_num
        # The number of nodes whose roles are normal.
        self.preferred_node_num = preferred_node_num
        # The number of synchronized nodes.
        self.synced_node_num = synced_node_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exception_node_num is not None:
            result['ExceptionNodeNum'] = self.exception_node_num
        if self.normal_node_num is not None:
            result['NormalNodeNum'] = self.normal_node_num
        if self.not_preferred_node_num is not None:
            result['NotPreferredNodeNum'] = self.not_preferred_node_num
        if self.not_syncing_node_num is not None:
            result['NotSyncingNodeNum'] = self.not_syncing_node_num
        if self.preferred_node_num is not None:
            result['PreferredNodeNum'] = self.preferred_node_num
        if self.synced_node_num is not None:
            result['SyncedNodeNum'] = self.synced_node_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExceptionNodeNum') is not None:
            self.exception_node_num = m.get('ExceptionNodeNum')
        if m.get('NormalNodeNum') is not None:
            self.normal_node_num = m.get('NormalNodeNum')
        if m.get('NotPreferredNodeNum') is not None:
            self.not_preferred_node_num = m.get('NotPreferredNodeNum')
        if m.get('NotSyncingNodeNum') is not None:
            self.not_syncing_node_num = m.get('NotSyncingNodeNum')
        if m.get('PreferredNodeNum') is not None:
            self.preferred_node_num = m.get('PreferredNodeNum')
        if m.get('SyncedNodeNum') is not None:
            self.synced_node_num = m.get('SyncedNodeNum')
        return self


class DescribeDBInstanceDiagnosisSummaryResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeDBInstanceDiagnosisSummaryResponseBodyItems] = None,
        master_status_info: DescribeDBInstanceDiagnosisSummaryResponseBodyMasterStatusInfo = None,
        page_number: str = None,
        request_id: str = None,
        segment_status_info: DescribeDBInstanceDiagnosisSummaryResponseBodySegmentStatusInfo = None,
        total_count: str = None,
    ):
        # The group ID.
        self.items = items
        # The state information about the coordinator node.
        self.master_status_info = master_status_info
        # The page number.
        self.page_number = page_number
        # The request ID.
        self.request_id = request_id
        # The state information about compute nodes.
        self.segment_status_info = segment_status_info
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()
        if self.master_status_info:
            self.master_status_info.validate()
        if self.segment_status_info:
            self.segment_status_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.master_status_info is not None:
            result['MasterStatusInfo'] = self.master_status_info.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.segment_status_info is not None:
            result['SegmentStatusInfo'] = self.segment_status_info.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeDBInstanceDiagnosisSummaryResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MasterStatusInfo') is not None:
            temp_model = DescribeDBInstanceDiagnosisSummaryResponseBodyMasterStatusInfo()
            self.master_status_info = temp_model.from_map(m['MasterStatusInfo'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SegmentStatusInfo') is not None:
            temp_model = DescribeDBInstanceDiagnosisSummaryResponseBodySegmentStatusInfo()
            self.segment_status_info = temp_model.from_map(m['SegmentStatusInfo'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDBInstanceDiagnosisSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceDiagnosisSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceDiagnosisSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceErrorLogRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        host: str = None,
        keywords: str = None,
        log_level: str = None,
        page_number: int = None,
        page_size: int = None,
        start_time: str = None,
        user: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database = database
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC. The end time must be later than the start time.
        self.end_time = end_time
        # This parameter is not supported in Alibaba Cloud public cloud.
        self.host = host
        # One or more keywords that are used to query error logs.
        self.keywords = keywords
        # The level of the logs to query. Valid values:
        # 
        # *   **ALL**: queries all error logs.
        # *   **PANIC**: queries only abnormal logs.
        # *   **FATAL**: queries only critical logs.
        # *   **ERROR**: queries only error logs.
        self.log_level = log_level
        # The page number. Pages start from page 1. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **20**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **20**.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.start_time = start_time
        # The username.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.host is not None:
            result['Host'] = self.host
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.log_level is not None:
            result['LogLevel'] = self.log_level
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('LogLevel') is not None:
            self.log_level = m.get('LogLevel')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeDBInstanceErrorLogResponseBodyItems(TeaModel):
    def __init__(
        self,
        database: str = None,
        host: str = None,
        log_context: str = None,
        log_level: str = None,
        time: int = None,
        user: str = None,
    ):
        # The name of the database.
        self.database = database
        # This parameter is not supported.
        self.host = host
        # The content of the error log.
        self.log_context = log_context
        # The level of the queried log.
        self.log_level = log_level
        # The time when the log was generated. The time is displayed in UTC.
        self.time = time
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.host is not None:
            result['Host'] = self.host
        if self.log_context is not None:
            result['LogContext'] = self.log_context
        if self.log_level is not None:
            result['LogLevel'] = self.log_level
        if self.time is not None:
            result['Time'] = self.time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('LogContext') is not None:
            self.log_context = m.get('LogContext')
        if m.get('LogLevel') is not None:
            self.log_level = m.get('LogLevel')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeDBInstanceErrorLogResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeDBInstanceErrorLogResponseBodyItems] = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The content of the error log.
        self.items = items
        # The page number.
        self.page_number = page_number
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeDBInstanceErrorLogResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDBInstanceErrorLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceErrorLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceErrorLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceIPArrayListRequest(TeaModel):
    def __init__(
        self,
        dbinstance_iparray_name: str = None,
        dbinstance_id: str = None,
        resource_group_id: str = None,
    ):
        # The name of the IP address whitelist. If you do not specify this parameter, the default whitelist is queried.
        # 
        # >  Each instance supports up to 50 IP address whitelists.
        self.dbinstance_iparray_name = dbinstance_iparray_name
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The ID of the resource group to which the instance belongs. For information about how to obtain the ID of a resource group, see [View basic information of a resource group](https://help.aliyun.com/document_detail/151181.html).
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_iparray_name is not None:
            result['DBInstanceIPArrayName'] = self.dbinstance_iparray_name
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceIPArrayName') is not None:
            self.dbinstance_iparray_name = m.get('DBInstanceIPArrayName')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray(TeaModel):
    def __init__(
        self,
        dbinstance_iparray_attribute: str = None,
        dbinstance_iparray_name: str = None,
        security_iplist: str = None,
    ):
        # The attribute of the IP address whitelist. By default, this parameter is empty. A whitelist with the `hidden` attribute is not displayed in the console.
        self.dbinstance_iparray_attribute = dbinstance_iparray_attribute
        # The name of the IP address whitelist.
        self.dbinstance_iparray_name = dbinstance_iparray_name
        # The IP addresses listed in the whitelist. Up to 1,000 IP addresses are contained in a whitelist and separated by commas (,). The IP addresses must use one of the following formats:
        # 
        # *   0.0.0.0/0
        # *   10.23.12.24. This is a standard IP address.
        # *   10.23.12.24/24. This is a CIDR block. The value `/24` indicates that the prefix of the CIDR block is 24-bit long. You can replace 24 with a value in the range of `1 to 32`.
        self.security_iplist = security_iplist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_iparray_attribute is not None:
            result['DBInstanceIPArrayAttribute'] = self.dbinstance_iparray_attribute
        if self.dbinstance_iparray_name is not None:
            result['DBInstanceIPArrayName'] = self.dbinstance_iparray_name
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceIPArrayAttribute') is not None:
            self.dbinstance_iparray_attribute = m.get('DBInstanceIPArrayAttribute')
        if m.get('DBInstanceIPArrayName') is not None:
            self.dbinstance_iparray_name = m.get('DBInstanceIPArrayName')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        return self


class DescribeDBInstanceIPArrayListResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance_iparray: List[DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray] = None,
    ):
        self.dbinstance_iparray = dbinstance_iparray

    def validate(self):
        if self.dbinstance_iparray:
            for k in self.dbinstance_iparray:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceIPArray'] = []
        if self.dbinstance_iparray is not None:
            for k in self.dbinstance_iparray:
                result['DBInstanceIPArray'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_iparray = []
        if m.get('DBInstanceIPArray') is not None:
            for k in m.get('DBInstanceIPArray'):
                temp_model = DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray()
                self.dbinstance_iparray.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceIPArrayListResponseBody(TeaModel):
    def __init__(
        self,
        items: DescribeDBInstanceIPArrayListResponseBodyItems = None,
        request_id: str = None,
    ):
        # The queried IP address whitelists.
        self.items = items
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeDBInstanceIPArrayListResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceIPArrayListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceIPArrayListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceIPArrayListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceIndexUsageRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database = database
        # order by search condition
        self.order_by = order_by
        # The page number. Pages start from page 1. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDBInstanceIndexUsageResponseBodyItems(TeaModel):
    def __init__(
        self,
        database_name: str = None,
        index_def: str = None,
        index_name: str = None,
        index_scan_times: int = None,
        index_size: str = None,
        is_partition_table: bool = None,
        parent_table_name: str = None,
        schema_name: str = None,
        table_name: str = None,
        time_last_updated: str = None,
    ):
        # The name of the database.
        self.database_name = database_name
        # The definition of the index.
        self.index_def = index_def
        # The name of the index.
        self.index_name = index_name
        # The number of index scans.
        self.index_scan_times = index_scan_times
        # The size of the index. Unit: bytes.
        self.index_size = index_size
        # Indicates whether the table is a partitioned table. Valid values:
        # 
        # *   **true**: The table is a partitioned table.
        # *   **false**: The table is not a partitioned table.
        self.is_partition_table = is_partition_table
        # The name of the parent table.
        self.parent_table_name = parent_table_name
        # The name of the schema.
        self.schema_name = schema_name
        # The name of the table.
        self.table_name = table_name
        # The time when the table was last deleted, inserted, or updated.
        self.time_last_updated = time_last_updated

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.index_def is not None:
            result['IndexDef'] = self.index_def
        if self.index_name is not None:
            result['IndexName'] = self.index_name
        if self.index_scan_times is not None:
            result['IndexScanTimes'] = self.index_scan_times
        if self.index_size is not None:
            result['IndexSize'] = self.index_size
        if self.is_partition_table is not None:
            result['IsPartitionTable'] = self.is_partition_table
        if self.parent_table_name is not None:
            result['ParentTableName'] = self.parent_table_name
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.time_last_updated is not None:
            result['TimeLastUpdated'] = self.time_last_updated
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('IndexDef') is not None:
            self.index_def = m.get('IndexDef')
        if m.get('IndexName') is not None:
            self.index_name = m.get('IndexName')
        if m.get('IndexScanTimes') is not None:
            self.index_scan_times = m.get('IndexScanTimes')
        if m.get('IndexSize') is not None:
            self.index_size = m.get('IndexSize')
        if m.get('IsPartitionTable') is not None:
            self.is_partition_table = m.get('IsPartitionTable')
        if m.get('ParentTableName') is not None:
            self.parent_table_name = m.get('ParentTableName')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TimeLastUpdated') is not None:
            self.time_last_updated = m.get('TimeLastUpdated')
        return self


class DescribeDBInstanceIndexUsageResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeDBInstanceIndexUsageResponseBodyItems] = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The queried index usage.
        self.items = items
        # The page number.
        self.page_number = page_number
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeDBInstanceIndexUsageResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDBInstanceIndexUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceIndexUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceIndexUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceNetInfoRequest(TeaModel):
    def __init__(
        self,
        connection_string: str = None,
        dbinstance_id: str = None,
    ):
        # The endpoint that is used to connect to the instance.
        # 
        # >  If you do not specify this parameter, the information about all endpoints of the instance is returned.
        self.connection_string = connection_string
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo(TeaModel):
    def __init__(
        self,
        address_type: str = None,
        connection_string: str = None,
        ipaddress: str = None,
        iptype: str = None,
        port: str = None,
        vpcid: str = None,
        v_switch_id: str = None,
        vpc_instance_id: str = None,
    ):
        # The type of the endpoint.
        self.address_type = address_type
        # The endpoint that is used to connect to the instance.
        self.connection_string = connection_string
        # The IP address.
        self.ipaddress = ipaddress
        # The type of the IP address.
        # 
        # *   Valid values for instances in the classic network: Inner and Public.
        # *   Valid values for instances in a virtual private cloud (VPC): Private and Public.
        self.iptype = iptype
        # The port number.
        self.port = port
        # The VPC ID of the instance.
        self.vpcid = vpcid
        # The vSwitch ID. Multiple IDs are separated by commas (,).
        self.v_switch_id = v_switch_id
        # The ID of the instance that is deployed in a VPC.
        self.vpc_instance_id = vpc_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address_type is not None:
            result['AddressType'] = self.address_type
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.ipaddress is not None:
            result['IPAddress'] = self.ipaddress
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.port is not None:
            result['Port'] = self.port
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddressType') is not None:
            self.address_type = m.get('AddressType')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('IPAddress') is not None:
            self.ipaddress = m.get('IPAddress')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos(TeaModel):
    def __init__(
        self,
        dbinstance_net_info: List[DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo] = None,
    ):
        self.dbinstance_net_info = dbinstance_net_info

    def validate(self):
        if self.dbinstance_net_info:
            for k in self.dbinstance_net_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceNetInfo'] = []
        if self.dbinstance_net_info is not None:
            for k in self.dbinstance_net_info:
                result['DBInstanceNetInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_net_info = []
        if m.get('DBInstanceNetInfo') is not None:
            for k in m.get('DBInstanceNetInfo'):
                temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo()
                self.dbinstance_net_info.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_net_infos: DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos = None,
        instance_network_type: str = None,
        request_id: str = None,
    ):
        # The connection information of the instance.
        self.dbinstance_net_infos = dbinstance_net_infos
        # The network type of the instance. Valid values:
        # 
        # *   Classic: classic network.
        # *   VPC: VPC.
        self.instance_network_type = instance_network_type
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.dbinstance_net_infos:
            self.dbinstance_net_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_net_infos is not None:
            result['DBInstanceNetInfos'] = self.dbinstance_net_infos.to_map()
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceNetInfos') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos()
            self.dbinstance_net_infos = temp_model.from_map(m['DBInstanceNetInfos'])
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceNetInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceNetInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancePerformanceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        end_time: str = None,
        key: str = None,
        resource_group_id: str = None,
        start_time: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances within a region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC. The end time must be later than the start time.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The performance metric. Separate multiple values with commas (,). For more information, see [Performance parameters](https://help.aliyun.com/document_detail/86943.html).
        # 
        # This parameter is required.
        self.key = key
        # This parameter is no longer used.
        self.resource_group_id = resource_group_id
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.key is not None:
            result['Key'] = self.key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDBInstancePerformanceResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        end_time: str = None,
        engine: str = None,
        performance_keys: List[str] = None,
        request_id: str = None,
        start_time: str = None,
    ):
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The end time of the query.
        self.end_time = end_time
        # The database engine of the instance.
        self.engine = engine
        # The queried performance metrics.
        self.performance_keys = performance_keys
        # The request ID.
        self.request_id = request_id
        # The start time of the query.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.performance_keys is not None:
            result['PerformanceKeys'] = self.performance_keys
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('PerformanceKeys') is not None:
            self.performance_keys = m.get('PerformanceKeys')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDBInstancePerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstancePerformanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancePerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancePlansRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        plan_create_date: str = None,
        plan_desc: str = None,
        plan_id: str = None,
        plan_schedule_type: str = None,
        plan_type: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The time that is used to filter plans. If you specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format, the plans that are created before this time are returned. The time must be in UTC. If you do not specify this parameter, all plans are returned.
        self.plan_create_date = plan_create_date
        # The description of the plan.
        self.plan_desc = plan_desc
        # The plan ID.
        # 
        # > You can call the [DescribeDBInstancePlans](https://help.aliyun.com/document_detail/449398.html) operation to query the information about plans, including plan IDs.
        self.plan_id = plan_id
        # The execution mode of the plan. Valid values:
        # 
        # *   **Postpone**: The plan is executed later.
        # *   **Regular**: The plan is executed periodically.
        self.plan_schedule_type = plan_schedule_type
        # The type of the plan. Valid values:
        # 
        # *   **PauseResume**: pauses and resumes an instance.
        # *   **Resize**: scales an instance.
        # *   **ModifySpec**: changes compute node specifications.
        self.plan_type = plan_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.plan_create_date is not None:
            result['PlanCreateDate'] = self.plan_create_date
        if self.plan_desc is not None:
            result['PlanDesc'] = self.plan_desc
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        if self.plan_schedule_type is not None:
            result['PlanScheduleType'] = self.plan_schedule_type
        if self.plan_type is not None:
            result['PlanType'] = self.plan_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlanCreateDate') is not None:
            self.plan_create_date = m.get('PlanCreateDate')
        if m.get('PlanDesc') is not None:
            self.plan_desc = m.get('PlanDesc')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        if m.get('PlanScheduleType') is not None:
            self.plan_schedule_type = m.get('PlanScheduleType')
        if m.get('PlanType') is not None:
            self.plan_type = m.get('PlanType')
        return self


class DescribeDBInstancePlansResponseBodyItemsPlanList(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        plan_config: str = None,
        plan_desc: str = None,
        plan_end_date: str = None,
        plan_id: str = None,
        plan_name: str = None,
        plan_schedule_type: str = None,
        plan_start_date: str = None,
        plan_status: str = None,
        plan_type: str = None,
    ):
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The execution information of the plan.
        self.plan_config = plan_config
        # The description of the plan.
        self.plan_desc = plan_desc
        # The end time of the plan. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        # 
        # > 
        # 
        # *   This parameter is returned only for the plans that are periodically executed.
        # 
        # *   If you did not specify the end time when you created the plan, this parameter is not returned.
        self.plan_end_date = plan_end_date
        # The plan ID.
        self.plan_id = plan_id
        # The name of the plan.
        self.plan_name = plan_name
        # The execution mode of the plan. Valid values:
        # 
        # *   **Postpone**: The plan is executed later.
        # *   **Regular**: The plan is executed periodically.
        self.plan_schedule_type = plan_schedule_type
        # The start time of the plan. The time follows the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm:ss*Z format. The time is displayed in UTC.
        # 
        # > 
        # 
        # *   This parameter is returned only for the plans that are periodically executed.
        # 
        # *   If you did not specify the start time when you created the plan, the current time is returned.
        self.plan_start_date = plan_start_date
        # The status of the plan. Valid values:
        # 
        # *   **active**\
        # *   **cancel**\
        # *   **deleted**\
        # *   **finished**\
        self.plan_status = plan_status
        # The type of the plan. Valid values:
        # 
        # *   **PauseResume**: pauses and resumes an instance.
        # *   **Resize**: scales an instance.
        self.plan_type = plan_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.plan_config is not None:
            result['PlanConfig'] = self.plan_config
        if self.plan_desc is not None:
            result['PlanDesc'] = self.plan_desc
        if self.plan_end_date is not None:
            result['PlanEndDate'] = self.plan_end_date
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        if self.plan_name is not None:
            result['PlanName'] = self.plan_name
        if self.plan_schedule_type is not None:
            result['PlanScheduleType'] = self.plan_schedule_type
        if self.plan_start_date is not None:
            result['PlanStartDate'] = self.plan_start_date
        if self.plan_status is not None:
            result['PlanStatus'] = self.plan_status
        if self.plan_type is not None:
            result['PlanType'] = self.plan_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('PlanConfig') is not None:
            self.plan_config = m.get('PlanConfig')
        if m.get('PlanDesc') is not None:
            self.plan_desc = m.get('PlanDesc')
        if m.get('PlanEndDate') is not None:
            self.plan_end_date = m.get('PlanEndDate')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        if m.get('PlanName') is not None:
            self.plan_name = m.get('PlanName')
        if m.get('PlanScheduleType') is not None:
            self.plan_schedule_type = m.get('PlanScheduleType')
        if m.get('PlanStartDate') is not None:
            self.plan_start_date = m.get('PlanStartDate')
        if m.get('PlanStatus') is not None:
            self.plan_status = m.get('PlanStatus')
        if m.get('PlanType') is not None:
            self.plan_type = m.get('PlanType')
        return self


class DescribeDBInstancePlansResponseBodyItems(TeaModel):
    def __init__(
        self,
        plan_list: List[DescribeDBInstancePlansResponseBodyItemsPlanList] = None,
    ):
        self.plan_list = plan_list

    def validate(self):
        if self.plan_list:
            for k in self.plan_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PlanList'] = []
        if self.plan_list is not None:
            for k in self.plan_list:
                result['PlanList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.plan_list = []
        if m.get('PlanList') is not None:
            for k in m.get('PlanList'):
                temp_model = DescribeDBInstancePlansResponseBodyItemsPlanList()
                self.plan_list.append(temp_model.from_map(k))
        return self


class DescribeDBInstancePlansResponseBody(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        items: DescribeDBInstancePlansResponseBodyItems = None,
        page_number: int = None,
        page_record_count: int = None,
        request_id: str = None,
        status: str = None,
        total_record_count: int = None,
    ):
        # The error message.
        # 
        # This parameter is returned only if the request fails.
        self.error_message = error_message
        # The queried plans.
        self.items = items
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_record_count = page_record_count
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        # 
        # If the request was successful, **success** is returned. If the request failed, this parameter is not returned.
        self.status = status
        # The total number of entries returned.
        self.total_record_count = total_record_count

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Items') is not None:
            temp_model = DescribeDBInstancePlansResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeDBInstancePlansResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstancePlansResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancePlansResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceSSLRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        # The ID of the instance.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstanceSSLResponseBody(TeaModel):
    def __init__(
        self,
        cert_common_name: str = None,
        dbinstance_id: str = None,
        dbinstance_name: str = None,
        request_id: str = None,
        sslenabled: bool = None,
        sslexpired_time: str = None,
    ):
        # The name of the SSL certificate.
        self.cert_common_name = cert_common_name
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id
        # The name of the instance.
        self.dbinstance_name = dbinstance_name
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether SSL encryption is enabled.
        self.sslenabled = sslenabled
        # The expiration time of the SSL certificate.
        self.sslexpired_time = sslexpired_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_common_name is not None:
            result['CertCommonName'] = self.cert_common_name
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sslenabled is not None:
            result['SSLEnabled'] = self.sslenabled
        if self.sslexpired_time is not None:
            result['SSLExpiredTime'] = self.sslexpired_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertCommonName') is not None:
            self.cert_common_name = m.get('CertCommonName')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SSLEnabled') is not None:
            self.sslenabled = m.get('SSLEnabled')
        if m.get('SSLExpiredTime') is not None:
            self.sslexpired_time = m.get('SSLExpiredTime')
        return self


class DescribeDBInstanceSSLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceSSLResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceSSLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceSupportMaxPerformanceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeDBInstanceSupportMaxPerformanceResponseBodyPerformancesPerformance(TeaModel):
    def __init__(
        self,
        bottleneck: str = None,
        key: str = None,
        unit: str = None,
        value: str = None,
    ):
        # The performance bottleneck type.
        self.bottleneck = bottleneck
        # The name of the performance metric.
        self.key = key
        # The unit of the performance metric.
        self.unit = unit
        # The value of the performance metric.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bottleneck is not None:
            result['Bottleneck'] = self.bottleneck
        if self.key is not None:
            result['Key'] = self.key
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bottleneck') is not None:
            self.bottleneck = m.get('Bottleneck')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDBInstanceSupportMaxPerformanceResponseBodyPerformances(TeaModel):
    def __init__(
        self,
        performance: List[DescribeDBInstanceSupportMaxPerformanceResponseBodyPerformancesPerformance] = None,
    ):
        self.performance = performance

    def validate(self):
        if self.performance:
            for k in self.performance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Performance'] = []
        if self.performance is not None:
            for k in self.performance:
                result['Performance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.performance = []
        if m.get('Performance') is not None:
            for k in m.get('Performance'):
                temp_model = DescribeDBInstanceSupportMaxPerformanceResponseBodyPerformancesPerformance()
                self.performance.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceSupportMaxPerformanceResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        performances: DescribeDBInstanceSupportMaxPerformanceResponseBodyPerformances = None,
        request_id: str = None,
    ):
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The queried performance metric.
        self.performances = performances
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.performances:
            self.performances.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.performances is not None:
            result['Performances'] = self.performances.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Performances') is not None:
            temp_model = DescribeDBInstanceSupportMaxPerformanceResponseBodyPerformances()
            self.performances = temp_model.from_map(m['Performances'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceSupportMaxPerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstanceSupportMaxPerformanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceSupportMaxPerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancesRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of tag N.
        self.key = key
        # The value of tag N.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDBInstancesRequest(TeaModel):
    def __init__(
        self,
        dbinstance_categories: List[str] = None,
        dbinstance_description: str = None,
        dbinstance_ids: str = None,
        dbinstance_modes: List[str] = None,
        dbinstance_statuses: List[str] = None,
        instance_deploy_types: List[str] = None,
        instance_network_type: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        tag: List[DescribeDBInstancesRequestTag] = None,
        vpc_id: str = None,
    ):
        # The edition of the instance. Separate multiple values with commas (,).
        self.dbinstance_categories = dbinstance_categories
        # The description of the instance.
        self.dbinstance_description = dbinstance_description
        # The instance ID. Separate multiple values with commas (,).
        self.dbinstance_ids = dbinstance_ids
        # The resource type of the instance. Separate multiple values with commas (,).
        self.dbinstance_modes = dbinstance_modes
        # The state of the instance.
        self.dbinstance_statuses = dbinstance_statuses
        # This parameter is no longer used.
        self.instance_deploy_types = instance_deploy_types
        # The network type of the instance. Valid values:
        # 
        # *   **VPC**: virtual private cloud (VPC).
        # *   **Classic**: classic network.
        # 
        # > If you do not specify this parameter, instances of all network types are returned.
        self.instance_network_type = instance_network_type
        self.owner_id = owner_id
        # The page number. Pages start from page 1. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size
        # The region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id
        # The tags.
        self.tag = tag
        # The VPC ID. You can use this parameter to filter instances that reside in the specified VPC.
        self.vpc_id = vpc_id

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_categories is not None:
            result['DBInstanceCategories'] = self.dbinstance_categories
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_ids is not None:
            result['DBInstanceIds'] = self.dbinstance_ids
        if self.dbinstance_modes is not None:
            result['DBInstanceModes'] = self.dbinstance_modes
        if self.dbinstance_statuses is not None:
            result['DBInstanceStatuses'] = self.dbinstance_statuses
        if self.instance_deploy_types is not None:
            result['InstanceDeployTypes'] = self.instance_deploy_types
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceCategories') is not None:
            self.dbinstance_categories = m.get('DBInstanceCategories')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceIds') is not None:
            self.dbinstance_ids = m.get('DBInstanceIds')
        if m.get('DBInstanceModes') is not None:
            self.dbinstance_modes = m.get('DBInstanceModes')
        if m.get('DBInstanceStatuses') is not None:
            self.dbinstance_statuses = m.get('DBInstanceStatuses')
        if m.get('InstanceDeployTypes') is not None:
            self.instance_deploy_types = m.get('InstanceDeployTypes')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDBInstancesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeDBInstancesShrinkRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of tag N.
        self.key = key
        # The value of tag N.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDBInstancesShrinkRequest(TeaModel):
    def __init__(
        self,
        dbinstance_categories_shrink: str = None,
        dbinstance_description: str = None,
        dbinstance_ids: str = None,
        dbinstance_modes_shrink: str = None,
        dbinstance_statuses_shrink: str = None,
        instance_deploy_types_shrink: str = None,
        instance_network_type: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        tag: List[DescribeDBInstancesShrinkRequestTag] = None,
        vpc_id: str = None,
    ):
        # The edition of the instance. Separate multiple values with commas (,).
        self.dbinstance_categories_shrink = dbinstance_categories_shrink
        # The description of the instance.
        self.dbinstance_description = dbinstance_description
        # The instance ID. Separate multiple values with commas (,).
        self.dbinstance_ids = dbinstance_ids
        # The resource type of the instance. Separate multiple values with commas (,).
        self.dbinstance_modes_shrink = dbinstance_modes_shrink
        # The state of the instance.
        self.dbinstance_statuses_shrink = dbinstance_statuses_shrink
        # This parameter is no longer used.
        self.instance_deploy_types_shrink = instance_deploy_types_shrink
        # The network type of the instance. Valid values:
        # 
        # *   **VPC**: virtual private cloud (VPC).
        # *   **Classic**: classic network.
        # 
        # > If you do not specify this parameter, instances of all network types are returned.
        self.instance_network_type = instance_network_type
        self.owner_id = owner_id
        # The page number. Pages start from page 1. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size
        # The region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id
        # The tags.
        self.tag = tag
        # The VPC ID. You can use this parameter to filter instances that reside in the specified VPC.
        self.vpc_id = vpc_id

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_categories_shrink is not None:
            result['DBInstanceCategories'] = self.dbinstance_categories_shrink
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_ids is not None:
            result['DBInstanceIds'] = self.dbinstance_ids
        if self.dbinstance_modes_shrink is not None:
            result['DBInstanceModes'] = self.dbinstance_modes_shrink
        if self.dbinstance_statuses_shrink is not None:
            result['DBInstanceStatuses'] = self.dbinstance_statuses_shrink
        if self.instance_deploy_types_shrink is not None:
            result['InstanceDeployTypes'] = self.instance_deploy_types_shrink
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceCategories') is not None:
            self.dbinstance_categories_shrink = m.get('DBInstanceCategories')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceIds') is not None:
            self.dbinstance_ids = m.get('DBInstanceIds')
        if m.get('DBInstanceModes') is not None:
            self.dbinstance_modes_shrink = m.get('DBInstanceModes')
        if m.get('DBInstanceStatuses') is not None:
            self.dbinstance_statuses_shrink = m.get('DBInstanceStatuses')
        if m.get('InstanceDeployTypes') is not None:
            self.instance_deploy_types_shrink = m.get('InstanceDeployTypes')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDBInstancesShrinkRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeDBInstancesResponseBodyItemsDBInstanceTagsTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of tag N.
        self.key = key
        # The value of tag N.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDBInstancesResponseBodyItemsDBInstanceTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeDBInstancesResponseBodyItemsDBInstanceTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDBInstancesResponseBodyItemsDBInstanceTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDBInstancesResponseBodyItemsDBInstance(TeaModel):
    def __init__(
        self,
        connection_mode: str = None,
        create_time: str = None,
        dbinstance_category: str = None,
        dbinstance_description: str = None,
        dbinstance_id: str = None,
        dbinstance_mode: str = None,
        dbinstance_net_type: str = None,
        dbinstance_status: str = None,
        engine: str = None,
        engine_version: str = None,
        expire_time: str = None,
        instance_deploy_type: str = None,
        instance_network_type: str = None,
        lock_mode: str = None,
        lock_reason: str = None,
        master_node_num: int = None,
        pay_type: str = None,
        prod_type: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        seg_node_num: str = None,
        serverless_mode: str = None,
        storage_size: str = None,
        storage_type: str = None,
        tags: DescribeDBInstancesResponseBodyItemsDBInstanceTags = None,
        v_switch_id: str = None,
        vpc_id: str = None,
        zone_id: str = None,
    ):
        # An invalid parameter. It is no longer returned when you call this operation.
        # 
        # You can call the [DescribeDBInstanceAttribute](https://help.aliyun.com/document_detail/86910.html) operation to query the access mode of an instance.
        self.connection_mode = connection_mode
        # The time when the instance was created. The time is displayed in UTC.
        self.create_time = create_time
        # The edition of the instance. Valid values:
        # 
        # *   **Basic**: Basic Edition.
        # *   **HighAvailability**: High-availability Edition.
        # *   **Finance**: Enterprise Edition.
        self.dbinstance_category = dbinstance_category
        # The description of the instance.
        self.dbinstance_description = dbinstance_description
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The resource type of the instance. Valid values:
        # 
        # *   **Serverless**: Serverless mode.
        # *   **StorageElastic**: elastic storage mode.
        # *   **Classic**: reserved storage mode.
        self.dbinstance_mode = dbinstance_mode
        # The type of the network interface card (NIC) that is used by the instance. Valid values:
        # 
        # *   **0**: Internet.
        # *   **1**: internal network.
        # *   **2**: VPC.
        self.dbinstance_net_type = dbinstance_net_type
        # The status of the instance. For more information, see [Instance statuses](https://help.aliyun.com/document_detail/86944.html).
        self.dbinstance_status = dbinstance_status
        # The database engine of the instance.
        self.engine = engine
        # The database engine version of the instance.
        self.engine_version = engine_version
        # The expiration time of the instance. The time is displayed in UTC.
        # 
        # >  The expiration time of a pay-as-you-go instance is `2999-09-08T16:00:00Z`.
        self.expire_time = expire_time
        # The resource type of the instance. Valid values:
        # 
        # *   **cluster**: Serverless mode or elastic storage mode.
        # *   **replicaSet**: reserved storage mode.
        self.instance_deploy_type = instance_deploy_type
        # The network type of the instance. Valid values:
        # 
        # *   **Classic**: classic network.
        # *   **VPC**: VPC.
        self.instance_network_type = instance_network_type
        # The lock mode of the instance. Valid values:
        # 
        # *   **Unlock**: The instance is not locked.
        # *   **ManualLock**: The instance is manually locked.
        # *   **LockByExpiration**: The instance is automatically locked due to instance expiration.
        # *   **LockByRestoration**: The instance is automatically locked due to instance restoration.
        # *   **LockByDiskQuota**: The instance is automatically locked due to exhausted storage.
        # *   **LockReadInstanceByDiskQuota**: The instance is a read-only instance and is automatically locked when the disk space is full.
        self.lock_mode = lock_mode
        # The reason why the instance is locked. Valid values:
        # 
        # *   **0**: The instance is not locked.
        # *   **1**: The instance is manually locked.
        # *   **2**: The instance is automatically locked due to instance expiration.
        # *   **3**: The instance is automatically locked due to instance restoration.
        # *   **4**: The instance is automatically locked due to exhausted storage.
        # 
        # >  If the instance is in reserved storage mode and is not locked, null is returned.
        self.lock_reason = lock_reason
        # The number of coordinator nodes.
        self.master_node_num = master_node_num
        # The billing method of the instance. Valid values:
        # 
        # *   **Postpaid**: pay-as-you-go.
        # *   **Prepaid**: subscription.
        self.pay_type = pay_type
        # product type
        self.prod_type = prod_type
        # The region ID.
        self.region_id = region_id
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id
        # The number of compute nodes.
        self.seg_node_num = seg_node_num
        # The type of the Serverless mode. Valid values:
        # 
        # *   **Manual**: manual scheduling.
        # *   **Auto**: automatic scheduling.
        # 
        # >  This parameter is returned only for instances in Serverless mode.
        self.serverless_mode = serverless_mode
        # The storage capacity of the instance. Unit: GB.
        self.storage_size = storage_size
        # The storage type of the instance. Valid values:
        # 
        # *   **cloud_essd**: enhanced SSD (ESSD).
        # *   **cloud_efficiency**: ultra disk.
        self.storage_type = storage_type
        # The tags that are added to the instance.
        self.tags = tags
        # The vSwitch ID.
        self.v_switch_id = v_switch_id
        # The VPC ID of the instance.
        self.vpc_id = vpc_id
        # The zone ID.
        self.zone_id = zone_id

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dbinstance_category is not None:
            result['DBInstanceCategory'] = self.dbinstance_category
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_mode is not None:
            result['DBInstanceMode'] = self.dbinstance_mode
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.instance_deploy_type is not None:
            result['InstanceDeployType'] = self.instance_deploy_type
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.master_node_num is not None:
            result['MasterNodeNum'] = self.master_node_num
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.prod_type is not None:
            result['ProdType'] = self.prod_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.seg_node_num is not None:
            result['SegNodeNum'] = self.seg_node_num
        if self.serverless_mode is not None:
            result['ServerlessMode'] = self.serverless_mode
        if self.storage_size is not None:
            result['StorageSize'] = self.storage_size
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DBInstanceCategory') is not None:
            self.dbinstance_category = m.get('DBInstanceCategory')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceMode') is not None:
            self.dbinstance_mode = m.get('DBInstanceMode')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('InstanceDeployType') is not None:
            self.instance_deploy_type = m.get('InstanceDeployType')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('MasterNodeNum') is not None:
            self.master_node_num = m.get('MasterNodeNum')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ProdType') is not None:
            self.prod_type = m.get('ProdType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SegNodeNum') is not None:
            self.seg_node_num = m.get('SegNodeNum')
        if m.get('ServerlessMode') is not None:
            self.serverless_mode = m.get('ServerlessMode')
        if m.get('StorageSize') is not None:
            self.storage_size = m.get('StorageSize')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        if m.get('Tags') is not None:
            temp_model = DescribeDBInstancesResponseBodyItemsDBInstanceTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDBInstancesResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance: List[DescribeDBInstancesResponseBodyItemsDBInstance] = None,
    ):
        self.dbinstance = dbinstance

    def validate(self):
        if self.dbinstance:
            for k in self.dbinstance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstance'] = []
        if self.dbinstance is not None:
            for k in self.dbinstance:
                result['DBInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance = []
        if m.get('DBInstance') is not None:
            for k in m.get('DBInstance'):
                temp_model = DescribeDBInstancesResponseBodyItemsDBInstance()
                self.dbinstance.append(temp_model.from_map(k))
        return self


class DescribeDBInstancesResponseBody(TeaModel):
    def __init__(
        self,
        items: DescribeDBInstancesResponseBodyItems = None,
        page_number: int = None,
        page_record_count: int = None,
        request_id: str = None,
        total_record_count: int = None,
    ):
        # The queried instances.
        self.items = items
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_record_count = page_record_count
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_record_count = total_record_count

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeDBInstancesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeDBInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBResourceGroupRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
        resource_group_name: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id
        # The name of the resource group.
        # 
        # >  If you specify this parameter, the information about the specified resource group is returned. If you do not specify this parameter, the information about all resource groups is returned.
        self.resource_group_name = resource_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        return self


class DescribeDBResourceGroupResponseBodyResourceGroupItemsResourceGroupItemRoleList(TeaModel):
    def __init__(
        self,
        role: List[str] = None,
    ):
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class DescribeDBResourceGroupResponseBodyResourceGroupItemsResourceGroupItem(TeaModel):
    def __init__(
        self,
        resource_group_config: str = None,
        resource_group_name: str = None,
        role_list: DescribeDBResourceGroupResponseBodyResourceGroupItemsResourceGroupItemRoleList = None,
    ):
        # The configurations of the resource group.
        # 
        # > 
        # 
        # *   CpuRateLimit: the percentage of CPU resources that are available for the resource group. Unit: %.
        # 
        # *   MemoryLimit: the percentage of memory resources that are available for the resource group. Unit: %.
        # 
        # *   MemorySharedQuota: the percentage of memory resources shared among transactions that are submitted to the resource group. Unit: %. Default value: 80.
        # 
        # *   MemorySpillRatio: the memory spill ratio for memory-intensive transactions. When the memory that is used by memory-intensive transactions reaches this value, data is spilled to disks. Unit: %. Default value: 0.
        # 
        # *   Concurrency: the maximum number of concurrent transactions or parallel queries that are allowed for a resource group. Default value: 20.
        self.resource_group_config = resource_group_config
        # The name of the resource group.
        self.resource_group_name = resource_group_name
        # The roles.
        self.role_list = role_list

    def validate(self):
        if self.role_list:
            self.role_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_group_config is not None:
            result['ResourceGroupConfig'] = self.resource_group_config
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        if self.role_list is not None:
            result['RoleList'] = self.role_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceGroupConfig') is not None:
            self.resource_group_config = m.get('ResourceGroupConfig')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        if m.get('RoleList') is not None:
            temp_model = DescribeDBResourceGroupResponseBodyResourceGroupItemsResourceGroupItemRoleList()
            self.role_list = temp_model.from_map(m['RoleList'])
        return self


class DescribeDBResourceGroupResponseBodyResourceGroupItems(TeaModel):
    def __init__(
        self,
        resource_group_item: List[DescribeDBResourceGroupResponseBodyResourceGroupItemsResourceGroupItem] = None,
    ):
        self.resource_group_item = resource_group_item

    def validate(self):
        if self.resource_group_item:
            for k in self.resource_group_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResourceGroupItem'] = []
        if self.resource_group_item is not None:
            for k in self.resource_group_item:
                result['ResourceGroupItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource_group_item = []
        if m.get('ResourceGroupItem') is not None:
            for k in m.get('ResourceGroupItem'):
                temp_model = DescribeDBResourceGroupResponseBodyResourceGroupItemsResourceGroupItem()
                self.resource_group_item.append(temp_model.from_map(k))
        return self


class DescribeDBResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_group_items: DescribeDBResourceGroupResponseBodyResourceGroupItems = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The queried resource group information.
        self.resource_group_items = resource_group_items

    def validate(self):
        if self.resource_group_items:
            self.resource_group_items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_items is not None:
            result['ResourceGroupItems'] = self.resource_group_items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupItems') is not None:
            temp_model = DescribeDBResourceGroupResponseBodyResourceGroupItems()
            self.resource_group_items = temp_model.from_map(m['ResourceGroupItems'])
        return self


class DescribeDBResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBResourceManagementModeRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeDBResourceManagementModeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_management_mode: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The resource management mode. Valid values:
        # 
        # *   resourceGroup: resource group management.
        # *   resourceQueue: resource queue management.
        self.resource_management_mode = resource_management_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_management_mode is not None:
            result['ResourceManagementMode'] = self.resource_management_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceManagementMode') is not None:
            self.resource_management_mode = m.get('ResourceManagementMode')
        return self


class DescribeDBResourceManagementModeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBResourceManagementModeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBResourceManagementModeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBVersionInfosRequest(TeaModel):
    def __init__(
        self,
        dbinstance_mode: str = None,
        dbversion: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
    ):
        # The resource type of the instance. Valid values:
        # 
        # *   **StorageElastic**: elastic storage mode.
        # *   **Serverless**: Serverless mode.
        self.dbinstance_mode = dbinstance_mode
        # The minor version number that does not include the prefix.
        self.dbversion = dbversion
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the resource group to which the instance belongs. For information about how to obtain the ID of a resource group, see [View basic information of a resource group](https://help.aliyun.com/document_detail/151181.html).
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_mode is not None:
            result['DBInstanceMode'] = self.dbinstance_mode
        if self.dbversion is not None:
            result['DBVersion'] = self.dbversion
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceMode') is not None:
            self.dbinstance_mode = m.get('DBInstanceMode')
        if m.get('DBVersion') is not None:
            self.dbversion = m.get('DBVersion')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeDBVersionInfosResponseBodyVersionDetails(TeaModel):
    def __init__(
        self,
        serverless: Any = None,
        storage_elastic: Any = None,
    ):
        # The queried minor version information about the instance in Serverless mode.
        self.serverless = serverless
        # The queried minor version information about the instance in elastic storage mode.
        self.storage_elastic = storage_elastic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.serverless is not None:
            result['Serverless'] = self.serverless
        if self.storage_elastic is not None:
            result['StorageElastic'] = self.storage_elastic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Serverless') is not None:
            self.serverless = m.get('Serverless')
        if m.get('StorageElastic') is not None:
            self.storage_elastic = m.get('StorageElastic')
        return self


class DescribeDBVersionInfosResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        version_details: DescribeDBVersionInfosResponseBodyVersionDetails = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The queried minor versions.
        self.version_details = version_details

    def validate(self):
        if self.version_details:
            self.version_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.version_details is not None:
            result['VersionDetails'] = self.version_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VersionDetails') is not None:
            temp_model = DescribeDBVersionInfosResponseBodyVersionDetails()
            self.version_details = temp_model.from_map(m['VersionDetails'])
        return self


class DescribeDBVersionInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDBVersionInfosResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDBVersionInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataBackupsRequest(TeaModel):
    def __init__(
        self,
        backup_id: str = None,
        backup_mode: str = None,
        backup_status: str = None,
        dbinstance_id: str = None,
        data_type: str = None,
        end_time: str = None,
        page_number: int = None,
        page_size: int = None,
        start_time: str = None,
    ):
        # The ID of the backup set. If you specify BackupId, the details of the backup set are returned.
        # 
        # > You can call the [DescribeDataBackups](https://help.aliyun.com/document_detail/210093.html) operation to query the information about all backup sets of an instance, including backup set IDs.
        self.backup_id = backup_id
        # The backup mode. Valid values:
        # 
        # *   Automated
        # *   Manual
        # 
        # If you do not specify this parameter, all backup sets are returned.
        self.backup_mode = backup_mode
        # The state of the backup set. Valid values:
        # 
        # *   Success
        # *   Failed
        # 
        # If you do not specify this parameter, all backup sets are returned.
        self.backup_status = backup_status
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The backup type. Valid values:
        # 
        # *   **DATA**: full backup.
        # *   **RESTOREPOI**: point-in-time recovery backup.
        # 
        # If you do not specify this parameter, the backup sets of full backup are returned.
        self.data_type = data_type
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the yyyy-MM-ddTHH:mmZ format. The time must be in UTC.
        self.end_time = end_time
        # The page number. Pages start from page 1. Default value: 1
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   30
        # *   50
        # *   100
        # 
        # Default value: 30.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the yyyy-MM-ddTHH:mmZ format. The time must be in UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDataBackupsResponseBodyItems(TeaModel):
    def __init__(
        self,
        backup_end_time: str = None,
        backup_end_time_local: str = None,
        backup_method: str = None,
        backup_mode: str = None,
        backup_set_id: str = None,
        backup_size: int = None,
        backup_start_time: str = None,
        backup_start_time_local: str = None,
        backup_status: str = None,
        bakset_name: str = None,
        consistent_time: int = None,
        dbinstance_id: str = None,
        data_type: str = None,
    ):
        # The UTC time when the backup ended. The time is in the yyyy-MM-ddTHH:mmZ format. The time is displayed in UTC.
        self.backup_end_time = backup_end_time
        # The local time when the backup ended. The time is in the yyyy-MM-dd HH:mm:ss format. The time is your local time.
        self.backup_end_time_local = backup_end_time_local
        # The method that is used to generate the backup set. Valid values:
        # 
        # *   **Logical**: logical backup
        # *   **Physical**: physical backup
        # *   **Snapshot**: snapshot backup
        self.backup_method = backup_method
        # The backup mode.
        # 
        # Valid values for full backup:
        # 
        # *   Automated: automatic backup
        # *   Manual: manual backup
        # 
        # Valid values for point-in-time backup:
        # 
        # *   Automated: point-in-time backup after full backup
        # *   Manual: manual point-in-time backup
        # *   Period: point-in-time backup that is triggered by a backup policy
        self.backup_mode = backup_mode
        # The ID of the backup set.
        self.backup_set_id = backup_set_id
        # The size of the backup file. Unit: bytes.
        self.backup_size = backup_size
        # The UTC time when the backup started. The time is in the yyyy-MM-ddTHH:mmZ format. The time is displayed in UTC.
        self.backup_start_time = backup_start_time
        # The local time when the backup started. The time is in the yyyy-MM-dd HH:mm:ss format. The time is your local time.
        self.backup_start_time_local = backup_start_time_local
        # The status of the backup set. Valid values:
        # 
        # *   Success
        # *   Failure
        self.backup_status = backup_status
        # The name of a point-in-time backup set or the full backup set.
        self.bakset_name = bakset_name
        # *   For full backup, this parameter indicates the point in time at which the data in the data backup file is consistent.
        # *   For point-in-time backup, this parameter indicates that the returned point in time is a timestamp.
        self.consistent_time = consistent_time
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id
        # The type of the backup. Valid values:
        # 
        # *   DATA: full backup
        # *   RESTOREPOI: point-in-time backup
        self.data_type = data_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_end_time is not None:
            result['BackupEndTime'] = self.backup_end_time
        if self.backup_end_time_local is not None:
            result['BackupEndTimeLocal'] = self.backup_end_time_local
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.backup_size is not None:
            result['BackupSize'] = self.backup_size
        if self.backup_start_time is not None:
            result['BackupStartTime'] = self.backup_start_time
        if self.backup_start_time_local is not None:
            result['BackupStartTimeLocal'] = self.backup_start_time_local
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.bakset_name is not None:
            result['BaksetName'] = self.bakset_name
        if self.consistent_time is not None:
            result['ConsistentTime'] = self.consistent_time
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_type is not None:
            result['DataType'] = self.data_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupEndTime') is not None:
            self.backup_end_time = m.get('BackupEndTime')
        if m.get('BackupEndTimeLocal') is not None:
            self.backup_end_time_local = m.get('BackupEndTimeLocal')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('BackupSize') is not None:
            self.backup_size = m.get('BackupSize')
        if m.get('BackupStartTime') is not None:
            self.backup_start_time = m.get('BackupStartTime')
        if m.get('BackupStartTimeLocal') is not None:
            self.backup_start_time_local = m.get('BackupStartTimeLocal')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('BaksetName') is not None:
            self.bakset_name = m.get('BaksetName')
        if m.get('ConsistentTime') is not None:
            self.consistent_time = m.get('ConsistentTime')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        return self


class DescribeDataBackupsResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeDataBackupsResponseBodyItems] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_backup_size: int = None,
        total_count: int = None,
    ):
        # The instance ID.
        self.items = items
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total backup set size. Unit: Byte.
        self.total_backup_size = total_backup_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_backup_size is not None:
            result['TotalBackupSize'] = self.total_backup_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeDataBackupsResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalBackupSize') is not None:
            self.total_backup_size = m.get('TotalBackupSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDataBackupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDataBackupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDataBackupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataReDistributeInfoRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances within a region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeDataReDistributeInfoResponseBodyDataReDistributeInfo(TeaModel):
    def __init__(
        self,
        message: str = None,
        progress: int = None,
        remain_time: str = None,
        start_time: str = None,
        status: str = None,
        type: str = None,
    ):
        # The execution information. If an error occurs, the error message is returned.
        self.message = message
        # The progress of data redistribution. Unit: %.
        self.progress = progress
        # The estimated remaining time for data redistribution.
        self.remain_time = remain_time
        # This parameter is not supported.
        self.start_time = start_time
        # The status of data redistribution.
        self.status = status
        # The execution type. The value **immediate** is returned, indicating immediate execution.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.remain_time is not None:
            result['RemainTime'] = self.remain_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RemainTime') is not None:
            self.remain_time = m.get('RemainTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDataReDistributeInfoResponseBody(TeaModel):
    def __init__(
        self,
        data_re_distribute_info: DescribeDataReDistributeInfoResponseBodyDataReDistributeInfo = None,
        request_id: str = None,
    ):
        # The data redistribution information.
        self.data_re_distribute_info = data_re_distribute_info
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data_re_distribute_info:
            self.data_re_distribute_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_re_distribute_info is not None:
            result['DataReDistributeInfo'] = self.data_re_distribute_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataReDistributeInfo') is not None:
            temp_model = DescribeDataReDistributeInfoResponseBodyDataReDistributeInfo()
            self.data_re_distribute_info = temp_model.from_map(m['DataReDistributeInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDataReDistributeInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDataReDistributeInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDataReDistributeInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataShareInstancesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        search_value: str = None,
    ):
        self.owner_id = owner_id
        # The page number. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: 30.
        self.page_size = page_size
        # The region ID of the instance.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the resource group to which the instance belongs. For information about how to obtain the ID of a resource group, see [View basic information of a resource group](https://help.aliyun.com/document_detail/151181.html).
        self.resource_group_id = resource_group_id
        # The keyword used to filter instances, which can be an instance ID or instance description.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs and instance descriptions.
        self.search_value = search_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.search_value is not None:
            result['SearchValue'] = self.search_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SearchValue') is not None:
            self.search_value = m.get('SearchValue')
        return self


class DescribeDataShareInstancesResponseBodyItemsDBInstance(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        dbinstance_mode: str = None,
        data_share_status: str = None,
        description: str = None,
        region_id: str = None,
        zone_id: str = None,
    ):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id
        # The resource type of the instance. Valid values:
        # 
        # *   **Serverless**: Serverless mode
        # *   **StorageElasic**: elastic storage mode
        # *   **Classic**: reserved storage mode
        self.dbinstance_mode = dbinstance_mode
        # The state of data sharing. Valid values:
        # 
        # *   **opening**: Data sharing is being enabled.
        # *   **opened**: Data sharing is enabled.
        # *   **closing**: Data sharing is being disabled.
        # *   **closed**: Data sharing is disabled.
        self.data_share_status = data_share_status
        # The description of the instance.
        self.description = description
        # The region ID of the instance.
        self.region_id = region_id
        # The zone ID of the instance.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_mode is not None:
            result['DBInstanceMode'] = self.dbinstance_mode
        if self.data_share_status is not None:
            result['DataShareStatus'] = self.data_share_status
        if self.description is not None:
            result['Description'] = self.description
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceMode') is not None:
            self.dbinstance_mode = m.get('DBInstanceMode')
        if m.get('DataShareStatus') is not None:
            self.data_share_status = m.get('DataShareStatus')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDataShareInstancesResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance: List[DescribeDataShareInstancesResponseBodyItemsDBInstance] = None,
    ):
        self.dbinstance = dbinstance

    def validate(self):
        if self.dbinstance:
            for k in self.dbinstance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstance'] = []
        if self.dbinstance is not None:
            for k in self.dbinstance:
                result['DBInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance = []
        if m.get('DBInstance') is not None:
            for k in m.get('DBInstance'):
                temp_model = DescribeDataShareInstancesResponseBodyItemsDBInstance()
                self.dbinstance.append(temp_model.from_map(k))
        return self


class DescribeDataShareInstancesResponseBody(TeaModel):
    def __init__(
        self,
        items: DescribeDataShareInstancesResponseBodyItems = None,
        page_number: int = None,
        page_record_count: int = None,
        request_id: str = None,
        total_record_count: int = None,
    ):
        # The state of data sharing. Valid values:
        # 
        # *   **opening**\
        # *   **opened**\
        # *   **closing**\
        # *   **closed**\
        self.items = items
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_record_count = page_record_count
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_record_count = total_record_count

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeDataShareInstancesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        return self


class DescribeDataShareInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDataShareInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDataShareInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataSharePerformanceRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        key: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query. Specify the time in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.end_time = end_time
        # The name of the performance metric. Separate multiple values with commas (,). Valid values:
        # 
        # *   **adbpg_datashare_topic_count**: the number of shared topics.
        # *   **adbpg_datashare_data_size_mb**: the amount of data shared.
        # 
        # This parameter is required.
        self.key = key
        # The region ID of the instance.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # This parameter is no longer used.
        self.resource_group_id = resource_group_id
        # The beginning of the time range to query. Specify the time in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.key is not None:
            result['Key'] = self.key
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDataSharePerformanceResponseBodyPerformanceKeysSeriesValues(TeaModel):
    def __init__(
        self,
        point: List[str] = None,
    ):
        # The value of the performance metric at a point in time.
        self.point = point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.point is not None:
            result['Point'] = self.point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Point') is not None:
            self.point = m.get('Point')
        return self


class DescribeDataSharePerformanceResponseBodyPerformanceKeysSeries(TeaModel):
    def __init__(
        self,
        name: str = None,
        values: List[DescribeDataSharePerformanceResponseBodyPerformanceKeysSeriesValues] = None,
    ):
        # The name of the performance metric.
        self.name = name
        # One or more values of the performance metric.
        self.values = values

    def validate(self):
        if self.values:
            for k in self.values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['Values'] = []
        if self.values is not None:
            for k in self.values:
                result['Values'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.values = []
        if m.get('Values') is not None:
            for k in m.get('Values'):
                temp_model = DescribeDataSharePerformanceResponseBodyPerformanceKeysSeriesValues()
                self.values.append(temp_model.from_map(k))
        return self


class DescribeDataSharePerformanceResponseBodyPerformanceKeys(TeaModel):
    def __init__(
        self,
        name: str = None,
        series: List[DescribeDataSharePerformanceResponseBodyPerformanceKeysSeries] = None,
        unit: str = None,
    ):
        # The name of the performance metric.
        self.name = name
        # Details of the performance metric.
        self.series = series
        # The unit of the performance metric.
        self.unit = unit

    def validate(self):
        if self.series:
            for k in self.series:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['Series'] = []
        if self.series is not None:
            for k in self.series:
                result['Series'].append(k.to_map() if k else None)
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.series = []
        if m.get('Series') is not None:
            for k in m.get('Series'):
                temp_model = DescribeDataSharePerformanceResponseBodyPerformanceKeysSeries()
                self.series.append(temp_model.from_map(k))
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class DescribeDataSharePerformanceResponseBody(TeaModel):
    def __init__(
        self,
        dbcluster_id: str = None,
        end_time: str = None,
        performance_keys: List[DescribeDataSharePerformanceResponseBodyPerformanceKeys] = None,
        request_id: str = None,
        start_time: str = None,
    ):
        # The ID of the instance.
        self.dbcluster_id = dbcluster_id
        # The end time of the query.
        self.end_time = end_time
        # Details of data sharing performance metrics.
        self.performance_keys = performance_keys
        # The ID of the request.
        self.request_id = request_id
        # The start time of the query.
        self.start_time = start_time

    def validate(self):
        if self.performance_keys:
            for k in self.performance_keys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbcluster_id is not None:
            result['DBClusterId'] = self.dbcluster_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        result['PerformanceKeys'] = []
        if self.performance_keys is not None:
            for k in self.performance_keys:
                result['PerformanceKeys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBClusterId') is not None:
            self.dbcluster_id = m.get('DBClusterId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        self.performance_keys = []
        if m.get('PerformanceKeys') is not None:
            for k in m.get('PerformanceKeys'):
                temp_model = DescribeDataSharePerformanceResponseBodyPerformanceKeys()
                self.performance_keys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDataSharePerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDataSharePerformanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDataSharePerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnosisDimensionsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDiagnosisDimensionsResponseBody(TeaModel):
    def __init__(
        self,
        databases: List[str] = None,
        request_id: str = None,
        user_names: List[str] = None,
    ):
        # The names of the databases.
        self.databases = databases
        # The request ID.
        self.request_id = request_id
        # The names of the database accounts.
        self.user_names = user_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.databases is not None:
            result['Databases'] = self.databases
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_names is not None:
            result['UserNames'] = self.user_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Databases') is not None:
            self.databases = m.get('Databases')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserNames') is not None:
            self.user_names = m.get('UserNames')
        return self


class DescribeDiagnosisDimensionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDiagnosisDimensionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiagnosisDimensionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnosisMonitorPerformanceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        query_condition: str = None,
        start_time: str = None,
        user: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.database = database
        # The end of the time range to query. Specify the time in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC. The end time must be later than the start time.
        self.end_time = end_time
        # The filter condition on queries. Specify the value in the JSON format. Valid values:
        # 
        # *   `{"Type":"maxCost", "Value":"100"}`: filters the top 100 queries that are the most time-consuming.
        # 
        # *   `{"Type":"status","Value":"finished"}`: filters completed queries.
        # 
        # *   `{"Type":"status","Value":"running"}`: filters running queries.
        # 
        # *   `{"Type":"cost","Min":"30","Max":"50"}`: filters the queries that consume 30 milliseconds or more and less than 50 milliseconds. You can customize a filter condition by setting **Min** and **Max**.
        # 
        #     *   If only **Min** is specified, the queries that consume a period of time that is greater than or equal to the Min value are filtered.
        #     *   If only **Max** is specified, the queries that consume a period of time that is less than the Max value are filtered.
        #     *   If both **Min** and **Max** are specified, the queries that consume a period of time that is greater than or equal to the **Min** value and less than the **Max** value are filtered.
        self.query_condition = query_condition
        # The beginning of the time range to query. Specify the time in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.start_time = start_time
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.query_condition is not None:
            result['QueryCondition'] = self.query_condition
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('QueryCondition') is not None:
            self.query_condition = m.get('QueryCondition')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeDiagnosisMonitorPerformanceResponseBodyPerformances(TeaModel):
    def __init__(
        self,
        cost: int = None,
        database: str = None,
        query_id: str = None,
        start_time: int = None,
        status: str = None,
        user: str = None,
    ):
        # The execution duration of the query. Unit: milliseconds.
        self.cost = cost
        # The name of the database.
        self.database = database
        # The ID of the query. It is a unique identifier of the query.
        self.query_id = query_id
        # The start time of the query. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The execution state of the query. Valid values:
        # 
        # *   **running**: The query is being executed.
        # *   **finished**: The query is complete.
        self.status = status
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.database is not None:
            result['Database'] = self.database
        if self.query_id is not None:
            result['QueryID'] = self.query_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('QueryID') is not None:
            self.query_id = m.get('QueryID')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeDiagnosisMonitorPerformanceResponseBody(TeaModel):
    def __init__(
        self,
        performances: List[DescribeDiagnosisMonitorPerformanceResponseBodyPerformances] = None,
        performances_threshold: int = None,
        performances_truncated: bool = None,
        request_id: str = None,
    ):
        # Details of query execution.
        self.performances = performances
        # The threshold for the number of queries.
        self.performances_threshold = performances_threshold
        # Indicates whether the queries are truncated when the number of queries exceeds the threshold. Valid values:
        # 
        # *   **true**: The queries are truncated.
        # *   **false**: The queries are not truncated.
        self.performances_truncated = performances_truncated
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.performances:
            for k in self.performances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Performances'] = []
        if self.performances is not None:
            for k in self.performances:
                result['Performances'].append(k.to_map() if k else None)
        if self.performances_threshold is not None:
            result['PerformancesThreshold'] = self.performances_threshold
        if self.performances_truncated is not None:
            result['PerformancesTruncated'] = self.performances_truncated
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.performances = []
        if m.get('Performances') is not None:
            for k in m.get('Performances'):
                temp_model = DescribeDiagnosisMonitorPerformanceResponseBodyPerformances()
                self.performances.append(temp_model.from_map(k))
        if m.get('PerformancesThreshold') is not None:
            self.performances_threshold = m.get('PerformancesThreshold')
        if m.get('PerformancesTruncated') is not None:
            self.performances_truncated = m.get('PerformancesTruncated')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDiagnosisMonitorPerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDiagnosisMonitorPerformanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiagnosisMonitorPerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnosisRecordsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        keyword: str = None,
        order: str = None,
        page_number: int = None,
        page_size: int = None,
        query_condition: str = None,
        start_time: str = None,
        user: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.database = database
        # The end of the time range to query. Specify the time in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC. The end time must be later than the start time.
        self.end_time = end_time
        # The keyword of the SQL statement.
        self.keyword = keyword
        # The order of fields in the console. You do not need to specify this parameter.
        self.order = order
        # The page number. Pages start from page 1. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size
        # The filter condition on queries. Specify the value in the JSON format. Valid values:
        # 
        # *   `{"Type":"maxCost", "Value":"100"}`: filters the top 100 queries that are the most time-consuming.
        # 
        # *   `{"Type":"status","Value":"finished"}`: filters completed queries.
        # 
        # *   `{"Type":"status","Value":"running"}`: filters running queries.
        # 
        # *   `{"Type":"cost","Min":"30","Max":"50"}`: filters the queries that consume a period of 30 milliseconds to less than 50 milliseconds. You can customize a filter condition by setting **Min** and **Max**.
        # 
        #     *   If only **Min** is specified, the queries that consume a period of time that is greater than the Min value are filtered.
        #     *   If only **Max** is specified, the queries that consume a period of time that is less than the Max value are filtered.
        #     *   If both **Min** and **Max** are specified, the queries that consume a period of time that is greater than or equal to the **Min** value and less than or equal to the **Max** value are filtered.
        self.query_condition = query_condition
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.start_time = start_time
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.order is not None:
            result['Order'] = self.order
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_condition is not None:
            result['QueryCondition'] = self.query_condition
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryCondition') is not None:
            self.query_condition = m.get('QueryCondition')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeDiagnosisRecordsResponseBodyItems(TeaModel):
    def __init__(
        self,
        database: str = None,
        duration: int = None,
        query_id: str = None,
        sqlstmt: str = None,
        sqltruncated: bool = None,
        sqltruncated_threshold: int = None,
        session_id: str = None,
        start_time: int = None,
        status: str = None,
        user: str = None,
    ):
        # The name of the database.
        self.database = database
        # The execution duration of the query. Unit: seconds.
        self.duration = duration
        # The ID of the query. It is a unique identifier of the query.
        self.query_id = query_id
        # The SQL statement.
        self.sqlstmt = sqlstmt
        # Indicates whether the SQL statement needs to be truncated. Valid values:
        # 
        # *   **true**: The SQL statement needs to be truncated.
        # *   **false**: The SQL statement does not need to be truncated.
        self.sqltruncated = sqltruncated
        # The threshold used to determine whether an SQL statement must be truncated. The value is the number of characters.
        self.sqltruncated_threshold = sqltruncated_threshold
        # The ID of the session that contains the query.
        self.session_id = session_id
        # The start time of the query. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The execution state of the query. Valid values:
        # 
        # *   **running**: The query is being executed.
        # *   **finished**: The query is complete.
        self.status = status
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.query_id is not None:
            result['QueryID'] = self.query_id
        if self.sqlstmt is not None:
            result['SQLStmt'] = self.sqlstmt
        if self.sqltruncated is not None:
            result['SQLTruncated'] = self.sqltruncated
        if self.sqltruncated_threshold is not None:
            result['SQLTruncatedThreshold'] = self.sqltruncated_threshold
        if self.session_id is not None:
            result['SessionID'] = self.session_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('QueryID') is not None:
            self.query_id = m.get('QueryID')
        if m.get('SQLStmt') is not None:
            self.sqlstmt = m.get('SQLStmt')
        if m.get('SQLTruncated') is not None:
            self.sqltruncated = m.get('SQLTruncated')
        if m.get('SQLTruncatedThreshold') is not None:
            self.sqltruncated_threshold = m.get('SQLTruncatedThreshold')
        if m.get('SessionID') is not None:
            self.session_id = m.get('SessionID')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeDiagnosisRecordsResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeDiagnosisRecordsResponseBodyItems] = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The threshold that determines whether the SQL statement must be truncated. The value is the number of characters.
        self.items = items
        # The page number.
        self.page_number = page_number
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeDiagnosisRecordsResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDiagnosisRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDiagnosisRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiagnosisRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnosisSQLInfoRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        query_id: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query details about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.database = database
        # The query ID. It is a unique identifier of the query.
        # 
        # > You can call the [DescribeDiagnosisRecords](https://help.aliyun.com/document_detail/450511.html) operation to obtain query IDs.
        # 
        # This parameter is required.
        self.query_id = query_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.query_id is not None:
            result['QueryID'] = self.query_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('QueryID') is not None:
            self.query_id = m.get('QueryID')
        return self


class DescribeDiagnosisSQLInfoResponseBody(TeaModel):
    def __init__(
        self,
        database: str = None,
        duration: int = None,
        max_output_rows: str = None,
        query_id: str = None,
        query_plan: str = None,
        request_id: str = None,
        sqlstmt: str = None,
        session_id: str = None,
        sorted_metrics: str = None,
        start_time: int = None,
        status: str = None,
        text_plan: str = None,
        user: str = None,
    ):
        # The name of the database.
        self.database = database
        # The execution duration of the query. Unit: seconds.
        self.duration = duration
        # The maximum number of output rows.
        self.max_output_rows = max_output_rows
        # The query ID.
        self.query_id = query_id
        # The information about the operator.
        self.query_plan = query_plan
        # The request ID.
        self.request_id = request_id
        # The SQL statement.
        self.sqlstmt = sqlstmt
        # The ID of the session that contains the query.
        self.session_id = session_id
        # The sequence of metrics.
        self.sorted_metrics = sorted_metrics
        # The start time of the query. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The execution state of the query. Valid values:
        # 
        # *   **running**\
        # *   **finished**\
        self.status = status
        # The information about the execution plan.
        self.text_plan = text_plan
        # The username.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.max_output_rows is not None:
            result['MaxOutputRows'] = self.max_output_rows
        if self.query_id is not None:
            result['QueryID'] = self.query_id
        if self.query_plan is not None:
            result['QueryPlan'] = self.query_plan
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sqlstmt is not None:
            result['SQLStmt'] = self.sqlstmt
        if self.session_id is not None:
            result['SessionID'] = self.session_id
        if self.sorted_metrics is not None:
            result['SortedMetrics'] = self.sorted_metrics
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.text_plan is not None:
            result['TextPlan'] = self.text_plan
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MaxOutputRows') is not None:
            self.max_output_rows = m.get('MaxOutputRows')
        if m.get('QueryID') is not None:
            self.query_id = m.get('QueryID')
        if m.get('QueryPlan') is not None:
            self.query_plan = m.get('QueryPlan')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SQLStmt') is not None:
            self.sqlstmt = m.get('SQLStmt')
        if m.get('SessionID') is not None:
            self.session_id = m.get('SessionID')
        if m.get('SortedMetrics') is not None:
            self.sorted_metrics = m.get('SortedMetrics')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TextPlan') is not None:
            self.text_plan = m.get('TextPlan')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeDiagnosisSQLInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDiagnosisSQLInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiagnosisSQLInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDocumentRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        file_name: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
    ):
        # Document collection name.
        # 
        # > Created by the [CreateDocumentCollection](https://help.aliyun.com/document_detail/2618448.html) API. You can use the [ListDocumentCollections](https://help.aliyun.com/document_detail/2618452.html) API to view the already created document collections.
        # 
        # This parameter is required.
        self.collection = collection
        # Instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) API to view details of all AnalyticDB PostgreSQL instances in the target region, including the instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Document name.
        # 
        # > You can view the list of documents using the [ListDocuments](https://help.aliyun.com/document_detail/2618453.html) API.
        # 
        # This parameter is required.
        self.file_name = file_name
        # Namespace, default is public.
        # 
        # > You can create it via the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) API and view the list through the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) API.
        self.namespace = namespace
        # Password for the namespace.
        # 
        # > This value is specified by the [CreateNamespace](https://help.aliyun.com/document_detail/2401495.html) API.
        # 
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # Region ID where the instance is located.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDocumentResponseBody(TeaModel):
    def __init__(
        self,
        chunk_file_url: str = None,
        docs_count: int = None,
        document_loader: str = None,
        document_loader_result_file_url: str = None,
        file_ext: str = None,
        file_md_5: str = None,
        file_mtime: str = None,
        file_name: str = None,
        file_size: int = None,
        file_url: str = None,
        file_version: int = None,
        message: str = None,
        plain_chunk_file_url: str = None,
        request_id: str = None,
        source: str = None,
        status: str = None,
        text_splitter: str = None,
    ):
        # URL of the split file, valid for 2 hours. The file format is JSONL, with each line formatted as `{"page_content":"*****", "metadata": {"**":"***","**":"***"}`.
        self.chunk_file_url = chunk_file_url
        # Number of documents after splitting.
        self.docs_count = docs_count
        # Name of the document loader.
        self.document_loader = document_loader
        self.document_loader_result_file_url = document_loader_result_file_url
        # File extension.
        self.file_ext = file_ext
        # MD5 value of the file.
        self.file_md_5 = file_md_5
        # The last modified time of the document.
        self.file_mtime = file_mtime
        # File name.
        self.file_name = file_name
        # File size, in bytes.
        self.file_size = file_size
        # Download URL of the document, valid for 2 hours.
        self.file_url = file_url
        # Document version. This value increments by 1 each time the same document is updated and uploaded.
        self.file_version = file_version
        # Detailed information returned by the API.
        self.message = message
        # Download URL for the plain text (without metadata) after splitting, each line is a chunk, valid for 2 hours.
        self.plain_chunk_file_url = plain_chunk_file_url
        # Request ID.
        self.request_id = request_id
        # Source of the document.
        self.source = source
        # API execution status, with values as follows:
        # - **success**: Execution succeeded.
        # - **fail**: Execution failed.
        self.status = status
        # Name of the text splitter.
        self.text_splitter = text_splitter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chunk_file_url is not None:
            result['ChunkFileUrl'] = self.chunk_file_url
        if self.docs_count is not None:
            result['DocsCount'] = self.docs_count
        if self.document_loader is not None:
            result['DocumentLoader'] = self.document_loader
        if self.document_loader_result_file_url is not None:
            result['DocumentLoaderResultFileUrl'] = self.document_loader_result_file_url
        if self.file_ext is not None:
            result['FileExt'] = self.file_ext
        if self.file_md_5 is not None:
            result['FileMd5'] = self.file_md_5
        if self.file_mtime is not None:
            result['FileMtime'] = self.file_mtime
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.message is not None:
            result['Message'] = self.message
        if self.plain_chunk_file_url is not None:
            result['PlainChunkFileUrl'] = self.plain_chunk_file_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.text_splitter is not None:
            result['TextSplitter'] = self.text_splitter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChunkFileUrl') is not None:
            self.chunk_file_url = m.get('ChunkFileUrl')
        if m.get('DocsCount') is not None:
            self.docs_count = m.get('DocsCount')
        if m.get('DocumentLoader') is not None:
            self.document_loader = m.get('DocumentLoader')
        if m.get('DocumentLoaderResultFileUrl') is not None:
            self.document_loader_result_file_url = m.get('DocumentLoaderResultFileUrl')
        if m.get('FileExt') is not None:
            self.file_ext = m.get('FileExt')
        if m.get('FileMd5') is not None:
            self.file_md_5 = m.get('FileMd5')
        if m.get('FileMtime') is not None:
            self.file_mtime = m.get('FileMtime')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PlainChunkFileUrl') is not None:
            self.plain_chunk_file_url = m.get('PlainChunkFileUrl')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TextSplitter') is not None:
            self.text_splitter = m.get('TextSplitter')
        return self


class DescribeDocumentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDocumentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDocumentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDownloadRecordsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        download_task_type: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.download_task_type = download_task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.download_task_type is not None:
            result['DownloadTaskType'] = self.download_task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DownloadTaskType') is not None:
            self.download_task_type = m.get('DownloadTaskType')
        return self


class DescribeDownloadRecordsResponseBodyRecords(TeaModel):
    def __init__(
        self,
        download_id: int = None,
        download_url: str = None,
        exception_msg: str = None,
        file_name: str = None,
        status: str = None,
    ):
        # The ID of the download record.
        self.download_id = download_id
        # The URL that can be used to download the file.
        self.download_url = download_url
        # The error message returned.
        self.exception_msg = exception_msg
        # The name of the file.
        self.file_name = file_name
        # The state of the upload task. After you call the DownloadDiagnosisRecords operation, query diagnostic information is first uploaded to Object Storage Service (OSS). After the upload task is complete, the query diagnostic information can be downloaded. Valid values:
        # 
        # *   **running**: uploading
        # *   **finished**: uploaded
        # *   **failed**: failed
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_id is not None:
            result['DownloadId'] = self.download_id
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.exception_msg is not None:
            result['ExceptionMsg'] = self.exception_msg
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadId') is not None:
            self.download_id = m.get('DownloadId')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('ExceptionMsg') is not None:
            self.exception_msg = m.get('ExceptionMsg')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDownloadRecordsResponseBody(TeaModel):
    def __init__(
        self,
        records: List[DescribeDownloadRecordsResponseBodyRecords] = None,
        request_id: str = None,
    ):
        # The URL that is used to download the file.
        self.records = records
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeDownloadRecordsResponseBodyRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDownloadRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDownloadRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDownloadRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDownloadSQLLogsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        # Instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) API to view details of all AnalyticDB for PostgreSQL instances in the target region, including the instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDownloadSQLLogsResponseBodyRecords(TeaModel):
    def __init__(
        self,
        download_id: int = None,
        download_url: str = None,
        exception_msg: str = None,
        file_name: str = None,
        status: str = None,
    ):
        # Download record ID.
        self.download_id = download_id
        # Download link.
        self.download_url = download_url
        # Error message.
        self.exception_msg = exception_msg
        # File name.
        self.file_name = file_name
        # Task status, with possible values being:
        # - **running**: Downloading.
        # - **finished**: Completed.
        # - **failed**: Download failed.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_id is not None:
            result['DownloadId'] = self.download_id
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.exception_msg is not None:
            result['ExceptionMsg'] = self.exception_msg
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadId') is not None:
            self.download_id = m.get('DownloadId')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('ExceptionMsg') is not None:
            self.exception_msg = m.get('ExceptionMsg')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDownloadSQLLogsResponseBody(TeaModel):
    def __init__(
        self,
        records: List[DescribeDownloadSQLLogsResponseBodyRecords] = None,
        request_id: str = None,
    ):
        # List of download records.
        self.records = records
        # Request ID.
        self.request_id = request_id

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeDownloadSQLLogsResponseBodyRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDownloadSQLLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDownloadSQLLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDownloadSQLLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExternalDataServiceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        region_id: str = None,
        service_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The region ID.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        self.region_id = region_id
        # The service ID.
        # 
        # This parameter is required.
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class DescribeExternalDataServiceResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        modify_time: str = None,
        request_id: str = None,
        service_description: str = None,
        service_id: str = None,
        service_name: str = None,
        service_spec: str = None,
        status: str = None,
    ):
        # The time when the service was created.
        self.create_time = create_time
        # The time when the service was last modified.
        self.modify_time = modify_time
        # The request ID.
        self.request_id = request_id
        # The description of the service.
        self.service_description = service_description
        # The service ID.
        self.service_id = service_id
        # The name of the service.
        self.service_name = service_name
        # The specifications of the service. Unit: compute units (CUs).
        self.service_spec = service_spec
        # The status of the operation.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.service_description is not None:
            result['ServiceDescription'] = self.service_description
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_spec is not None:
            result['ServiceSpec'] = self.service_spec
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ServiceDescription') is not None:
            self.service_description = m.get('ServiceDescription')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceSpec') is not None:
            self.service_spec = m.get('ServiceSpec')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeExternalDataServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExternalDataServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExternalDataServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHadoopClustersInSameNetRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The region ID.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeHadoopClustersInSameNetResponseBody(TeaModel):
    def __init__(
        self,
        clusters: List[str] = None,
        request_id: str = None,
    ):
        self.clusters = clusters
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clusters is not None:
            result['Clusters'] = self.clusters
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Clusters') is not None:
            self.clusters = m.get('Clusters')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeHadoopClustersInSameNetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHadoopClustersInSameNetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHadoopClustersInSameNetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHadoopConfigsRequest(TeaModel):
    def __init__(
        self,
        config_name: str = None,
        dbinstance_id: str = None,
        emr_instance_id: str = None,
        region_id: str = None,
    ):
        # The name of the configuration file. Valid values:
        # 
        # *   hdfs-site
        # *   core-site
        # *   yarn-site
        # *   mapred-site
        # *   hive-site
        # 
        # This parameter is required.
        self.config_name = config_name
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The E-MapReduce (EMR) Hadoop cluster ID.
        # 
        # This parameter is required.
        self.emr_instance_id = emr_instance_id
        # The region ID of the instance.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.emr_instance_id is not None:
            result['EmrInstanceId'] = self.emr_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EmrInstanceId') is not None:
            self.emr_instance_id = m.get('EmrInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeHadoopConfigsResponseBody(TeaModel):
    def __init__(
        self,
        config_name: str = None,
        config_value: str = None,
        request_id: str = None,
    ):
        # The name of the configuration file. Valid values:
        # 
        # *   hdfs-site
        # *   core-site
        # *   yarn-site
        # *   mapred-site
        # *   hive-site
        self.config_name = config_name
        # The configuration value.
        self.config_value = config_value
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeHadoopConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHadoopConfigsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHadoopConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHadoopDataSourceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_id: str = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The data source ID.
        self.data_source_id = data_source_id
        # The region ID of the instance.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/2361846.html) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeHadoopDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        data_source_description: str = None,
        data_source_dir: str = None,
        data_source_id: str = None,
        data_source_name: str = None,
        data_source_status: str = None,
        data_source_type: str = None,
        emr_instance_id: str = None,
        external_data_service_id: str = None,
        hdfsconf: str = None,
        hadoop_core_conf: str = None,
        hadoop_create_type: str = None,
        hadoop_hosts_address: str = None,
        hive_conf: str = None,
        map_reduce_conf: str = None,
        modify_time: str = None,
        request_id: str = None,
        status_message: str = None,
        yarn_conf: str = None,
    ):
        # The time when the service was created.
        self.create_time = create_time
        # The description of the service. The description can be up to 256 characters in length.
        self.data_source_description = data_source_description
        # The service directory in which Hadoop-related configuration files are stored.
        self.data_source_dir = data_source_dir
        # The data source ID.
        self.data_source_id = data_source_id
        # The name of the service.
        self.data_source_name = data_source_name
        # The status of the service. Valid values:
        # 
        # *   Init
        # *   Running
        # *   Exception
        self.data_source_status = data_source_status
        # The type of the data source.
        self.data_source_type = data_source_type
        # The E-MapReduce (EMR) Hadoop cluster ID.
        self.emr_instance_id = emr_instance_id
        # The ID of the external data service.
        self.external_data_service_id = external_data_service_id
        # The content of the Hadoop hdfs-site.xml file.
        self.hdfsconf = hdfsconf
        # The content of the Hadoop core-site.xml file.
        self.hadoop_core_conf = hadoop_core_conf
        # The type of the external service. Valid values:
        # 
        # *   emr
        # *   selfCreate
        self.hadoop_create_type = hadoop_create_type
        # The IP address and hostname of the Hadoop cluster (data source) in the /etc/hosts file.
        self.hadoop_hosts_address = hadoop_hosts_address
        # The content of the Hadoop hive-site.xml file.
        self.hive_conf = hive_conf
        # The content of the Hadoop mapred-site.xml file.
        self.map_reduce_conf = map_reduce_conf
        # The time when the data source was last modified.
        self.modify_time = modify_time
        # The request ID.
        self.request_id = request_id
        # The information about the service status. For example, if the service is in the exception state, the cause of the exception is displayed. If the service is in the running state, this parameter is left empty.
        self.status_message = status_message
        # The content of the Hadoop yarn-site.xml file.
        self.yarn_conf = yarn_conf

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_source_description is not None:
            result['DataSourceDescription'] = self.data_source_description
        if self.data_source_dir is not None:
            result['DataSourceDir'] = self.data_source_dir
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.data_source_status is not None:
            result['DataSourceStatus'] = self.data_source_status
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.emr_instance_id is not None:
            result['EmrInstanceId'] = self.emr_instance_id
        if self.external_data_service_id is not None:
            result['ExternalDataServiceId'] = self.external_data_service_id
        if self.hdfsconf is not None:
            result['HDFSConf'] = self.hdfsconf
        if self.hadoop_core_conf is not None:
            result['HadoopCoreConf'] = self.hadoop_core_conf
        if self.hadoop_create_type is not None:
            result['HadoopCreateType'] = self.hadoop_create_type
        if self.hadoop_hosts_address is not None:
            result['HadoopHostsAddress'] = self.hadoop_hosts_address
        if self.hive_conf is not None:
            result['HiveConf'] = self.hive_conf
        if self.map_reduce_conf is not None:
            result['MapReduceConf'] = self.map_reduce_conf
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_message is not None:
            result['StatusMessage'] = self.status_message
        if self.yarn_conf is not None:
            result['YarnConf'] = self.yarn_conf
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSourceDescription') is not None:
            self.data_source_description = m.get('DataSourceDescription')
        if m.get('DataSourceDir') is not None:
            self.data_source_dir = m.get('DataSourceDir')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('DataSourceStatus') is not None:
            self.data_source_status = m.get('DataSourceStatus')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('EmrInstanceId') is not None:
            self.emr_instance_id = m.get('EmrInstanceId')
        if m.get('ExternalDataServiceId') is not None:
            self.external_data_service_id = m.get('ExternalDataServiceId')
        if m.get('HDFSConf') is not None:
            self.hdfsconf = m.get('HDFSConf')
        if m.get('HadoopCoreConf') is not None:
            self.hadoop_core_conf = m.get('HadoopCoreConf')
        if m.get('HadoopCreateType') is not None:
            self.hadoop_create_type = m.get('HadoopCreateType')
        if m.get('HadoopHostsAddress') is not None:
            self.hadoop_hosts_address = m.get('HadoopHostsAddress')
        if m.get('HiveConf') is not None:
            self.hive_conf = m.get('HiveConf')
        if m.get('MapReduceConf') is not None:
            self.map_reduce_conf = m.get('MapReduceConf')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusMessage') is not None:
            self.status_message = m.get('StatusMessage')
        if m.get('YarnConf') is not None:
            self.yarn_conf = m.get('YarnConf')
        return self


class DescribeHadoopDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHadoopDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHadoopDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHealthStatusRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        key: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The performance metric that you want to query. Separate multiple values with commas (,). For more information, see [Performance parameters](https://help.aliyun.com/document_detail/86943.html).
        # 
        # This parameter is required.
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class DescribeHealthStatusResponseBodyStatusAdbgpSegmentDiskUsagePercentMax(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The status corresponding to the maximum storage usage among all compute nodes. Valid values:
        # 
        # *   **critical**: The compute node storage usage is greater than or equal to 90%. In this case, the instance is locked.
        # *   **warning**: The compute node storage usage is greater than or equal to 80% and less than 90%.
        # *   **healthy**: The compute node storage usage is less than 80%.
        self.status = status
        # The metric value of maximum compute node storage usage.
        # 
        # Unit: %.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgConnectionStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The connection health status of the instance. Valid values:
        # 
        # *   **critical**: The instance connection usage is greater than 95%. In this case, this metric is marked in red in the console.
        # *   **warning**: The instance connection usage is greater than 90% and less than or equal to 95%. In this case, this metric is marked in yellow in the console.
        # *   **healthy**: The instance connection usage is less than or equal to 90%. In this case, this metric is marked in green in the console.
        # 
        # >  The instance connection usage is the maximum connection usage among all the coordinator and compute nodes.
        self.status = status
        # The metric value of instance connection usage.
        # 
        # Unit: %.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgDiskStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The storage status of the instance. Valid values:
        # 
        # *   **critical**: The instance storage usage is greater than or equal to 90%. In this case, this metric is marked in red in the console and the instance is locked.
        # *   **warning**: The instance storage usage is greater than or equal to 70% and less than 90%. In this case, this metric is marked in yellow in the console.
        # *   **healthy**: The instance storage usage is less than 70%. In this case, this metric is marked in green in the console.
        # 
        # >  The instance storage usage is the average storage usage of all compute nodes.
        self.status = status
        # The metric value of instance storage usage.
        # 
        # Unit: %.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgDiskUsagePercent(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The status corresponding to the storage usage of the instance. Valid values:
        # 
        # *   **critical**: The instance storage usage is greater than or equal to 90%. In this case, the instance is locked.
        # *   **warning**: The instance storage usage is greater than or equal to 70% and less than 90%.
        # *   **healthy**: The instance storage usage is less than 70%.
        # 
        # >  The instance storage usage is the average storage usage of all compute nodes.
        self.status = status
        # The metric value of instance storage usage.
        # 
        # Unit: %.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgInstanceColdDataGb(TeaModel):
    def __init__(
        self,
        value: float = None,
    ):
        # The total amount of cold data storage. Unit: GB.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgInstanceHotDataGb(TeaModel):
    def __init__(
        self,
        value: float = None,
    ):
        # The total amount of hot data storage. Unit: GB.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgInstanceTotalDataGb(TeaModel):
    def __init__(
        self,
        value: float = None,
    ):
        # The total amount of data storage of the instance. Unit: GB.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgMasterDiskUsagePercentMax(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The status corresponding to the maximum storage usage of the coordinator node. Valid values:
        # 
        # *   **critical**: The coordinator node storage usage is greater than or equal to 90%. In this case, the instance is locked.
        # *   **warning**: The coordinator node storage usage is greater than or equal to 70% and less than 90%.
        # *   **healthy**: The coordinator node storage usage is less than 70%.
        self.status = status
        # The metric value of maximum coordinator node storage usage.
        # 
        # Unit: %.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgMasterStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The availability status of the coordinator node. Valid values:
        # 
        # *   **critical**: Both the primary and standby coordinator nodes are unavailable. In this case, this metric is marked in red in the console.
        # *   **warning**: The primary or standby coordinator node is unavailable. In this case, this metric is marked in yellow in the console.
        # *   **healthy**: Both the primary and standby coordinator nodes are available. In this case, this metric is marked in green in the console.
        self.status = status
        # The metric value of coordinator node availability status. Valid values:
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgSegmentStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The availability status of compute nodes. Valid values:
        # 
        # *   **critical**: All the primary and secondary compute nodes are unavailable. In this case, this metric is marked in red in the console.
        # *   **warning**: Fifty percent or more than fifty percent of compute nodes are unavailable. In this case, this metric is marked in yellow in the console.
        # *   **healthy**: All compute nodes are available. In this case, this metric is marked in green in the console.
        self.status = status
        # The metric value of compute node availability status.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusAdbpgStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The health status of the instance. Valid values:
        # 
        # *   **critical**: The coordinator node or a compute node is unavailable. In this case, this metric is marked in red in the console.
        # *   **healthy**: All nodes are available. In this case, this metric is marked in green in the console.
        self.status = status
        # The metric value of instance health status. Valid values:
        # 
        # *   **1**: healthy
        # *   **0**: critical
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusNodeMasterConnectionStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The connection health status of the coordinator node. Valid values:
        # 
        # *   **critical**: The coordinator node connection usage is greater than 95%. In this case, this metric is marked in red in the console.
        # *   **warning**: The coordinator node connection usage is greater than or equal to 90% and less than 95%. In this case, this metric is marked in yellow in the console.
        # *   **healthy**: The coordinator node connection usage is less than 90%. In this case, this metric is marked in green in the console.
        # 
        # >  The coordinator node connection usage is the maximum connection usage of the coordinator node.
        self.status = status
        # The metric value of coordinator node connection usage.
        # 
        # Unit: %.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusNodeMasterStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The health status of the coordinator node. Valid values:
        # 
        # *   **critical**: The primary or standby coordinator node is unavailable. In this case, this metric is marked in red in the console.
        # *   **healthy**: Both the primary and standby coordinator nodes are available. In this case, this metric is marked in green in the console.
        self.status = status
        # The metric value of coordinator node health status. Valid values:
        # 
        # *   **1**: healthy
        # *   **0**: critical
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusNodeSegmentConnectionStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The connection health status of compute nodes. Valid values:
        # 
        # *   **critical**: The compute node connection usage is greater than or equal to 95%. In this case, this metric is marked in red in the console.
        # *   **warning**: The compute node connection usage is greater than or equal to 90% and less than 95%. In this case, this metric is marked in yellow in the console.
        # *   **healthy**: The compute node connection usage is less than 90%. In this case, this metric is marked in green in the console.
        # 
        # >  The compute node connection usage is the maximum connection usage among all compute nodes.
        self.status = status
        # The metric value of maximum compute node connection usage.
        # 
        # Unit: %.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatusNodeSegmentDiskStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        value: float = None,
    ):
        # The storage status of compute nodes. Valid values:
        # 
        # *   **critical**: The compute node storage usage is greater than or equal to 90%. In this case, this metric is marked in red in the console and the instance is locked.
        # *   **warning**: The compute node storage usage is greater than or equal to 80% and less than 90%. In this case, this metric is marked in yellow in the console.
        # *   **healthy**: The compute node storage usage is less than 80%. In this case, this metric is marked in green in the console.
        # 
        # >  The compute node storage usage is the maximum storage usage among all compute nodes.
        self.status = status
        # The metric value of maximum compute node storage usage.
        # 
        # Unit: %.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHealthStatusResponseBodyStatus(TeaModel):
    def __init__(
        self,
        adbgp_segment_disk_usage_percent_max: DescribeHealthStatusResponseBodyStatusAdbgpSegmentDiskUsagePercentMax = None,
        adbpg_connection_status: DescribeHealthStatusResponseBodyStatusAdbpgConnectionStatus = None,
        adbpg_disk_status: DescribeHealthStatusResponseBodyStatusAdbpgDiskStatus = None,
        adbpg_disk_usage_percent: DescribeHealthStatusResponseBodyStatusAdbpgDiskUsagePercent = None,
        adbpg_instance_cold_data_gb: DescribeHealthStatusResponseBodyStatusAdbpgInstanceColdDataGb = None,
        adbpg_instance_hot_data_gb: DescribeHealthStatusResponseBodyStatusAdbpgInstanceHotDataGb = None,
        adbpg_instance_total_data_gb: DescribeHealthStatusResponseBodyStatusAdbpgInstanceTotalDataGb = None,
        adbpg_master_disk_usage_percent_max: DescribeHealthStatusResponseBodyStatusAdbpgMasterDiskUsagePercentMax = None,
        adbpg_master_status: DescribeHealthStatusResponseBodyStatusAdbpgMasterStatus = None,
        adbpg_segment_status: DescribeHealthStatusResponseBodyStatusAdbpgSegmentStatus = None,
        adbpg_status: DescribeHealthStatusResponseBodyStatusAdbpgStatus = None,
        node_master_connection_status: DescribeHealthStatusResponseBodyStatusNodeMasterConnectionStatus = None,
        node_master_status: DescribeHealthStatusResponseBodyStatusNodeMasterStatus = None,
        node_segment_connection_status: DescribeHealthStatusResponseBodyStatusNodeSegmentConnectionStatus = None,
        node_segment_disk_status: DescribeHealthStatusResponseBodyStatusNodeSegmentDiskStatus = None,
    ):
        # The information of maximum compute node storage usage.
        # 
        # >  This parameter value is returned only for instances in elastic storage mode.
        self.adbgp_segment_disk_usage_percent_max = adbgp_segment_disk_usage_percent_max
        # The information of instance connection health status.
        self.adbpg_connection_status = adbpg_connection_status
        # The information of instance storage status.
        # 
        # >  This parameter value is returned only for instances in elastic storage mode.
        self.adbpg_disk_status = adbpg_disk_status
        # The information of instance storage usage.
        # 
        # >  This parameter value is returned only for instances in elastic storage mode.
        self.adbpg_disk_usage_percent = adbpg_disk_usage_percent
        # The total amount of cold data storage.
        self.adbpg_instance_cold_data_gb = adbpg_instance_cold_data_gb
        # The total amount of hot data storage.
        self.adbpg_instance_hot_data_gb = adbpg_instance_hot_data_gb
        # The total amount of data storage of the instance.
        self.adbpg_instance_total_data_gb = adbpg_instance_total_data_gb
        # The information of maximum coordinator node storage usage.
        # 
        # >  This parameter value is returned only for instances in elastic storage mode.
        self.adbpg_master_disk_usage_percent_max = adbpg_master_disk_usage_percent_max
        # The information of coordinator node availability status.
        self.adbpg_master_status = adbpg_master_status
        # The information of compute node availability status.
        self.adbpg_segment_status = adbpg_segment_status
        # The information of instance health status.
        self.adbpg_status = adbpg_status
        # The information of coordinator node connection health status.
        self.node_master_connection_status = node_master_connection_status
        # The information of coordinator node health status.
        self.node_master_status = node_master_status
        # The information of compute node connection health status.
        self.node_segment_connection_status = node_segment_connection_status
        # The information of compute node storage status.
        # 
        # >  This parameter value is returned only for instances in elastic storage mode.
        self.node_segment_disk_status = node_segment_disk_status

    def validate(self):
        if self.adbgp_segment_disk_usage_percent_max:
            self.adbgp_segment_disk_usage_percent_max.validate()
        if self.adbpg_connection_status:
            self.adbpg_connection_status.validate()
        if self.adbpg_disk_status:
            self.adbpg_disk_status.validate()
        if self.adbpg_disk_usage_percent:
            self.adbpg_disk_usage_percent.validate()
        if self.adbpg_instance_cold_data_gb:
            self.adbpg_instance_cold_data_gb.validate()
        if self.adbpg_instance_hot_data_gb:
            self.adbpg_instance_hot_data_gb.validate()
        if self.adbpg_instance_total_data_gb:
            self.adbpg_instance_total_data_gb.validate()
        if self.adbpg_master_disk_usage_percent_max:
            self.adbpg_master_disk_usage_percent_max.validate()
        if self.adbpg_master_status:
            self.adbpg_master_status.validate()
        if self.adbpg_segment_status:
            self.adbpg_segment_status.validate()
        if self.adbpg_status:
            self.adbpg_status.validate()
        if self.node_master_connection_status:
            self.node_master_connection_status.validate()
        if self.node_master_status:
            self.node_master_status.validate()
        if self.node_segment_connection_status:
            self.node_segment_connection_status.validate()
        if self.node_segment_disk_status:
            self.node_segment_disk_status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adbgp_segment_disk_usage_percent_max is not None:
            result['adbgp_segment_disk_usage_percent_max'] = self.adbgp_segment_disk_usage_percent_max.to_map()
        if self.adbpg_connection_status is not None:
            result['adbpg_connection_status'] = self.adbpg_connection_status.to_map()
        if self.adbpg_disk_status is not None:
            result['adbpg_disk_status'] = self.adbpg_disk_status.to_map()
        if self.adbpg_disk_usage_percent is not None:
            result['adbpg_disk_usage_percent'] = self.adbpg_disk_usage_percent.to_map()
        if self.adbpg_instance_cold_data_gb is not None:
            result['adbpg_instance_cold_data_gb'] = self.adbpg_instance_cold_data_gb.to_map()
        if self.adbpg_instance_hot_data_gb is not None:
            result['adbpg_instance_hot_data_gb'] = self.adbpg_instance_hot_data_gb.to_map()
        if self.adbpg_instance_total_data_gb is not None:
            result['adbpg_instance_total_data_gb'] = self.adbpg_instance_total_data_gb.to_map()
        if self.adbpg_master_disk_usage_percent_max is not None:
            result['adbpg_master_disk_usage_percent_max'] = self.adbpg_master_disk_usage_percent_max.to_map()
        if self.adbpg_master_status is not None:
            result['adbpg_master_status'] = self.adbpg_master_status.to_map()
        if self.adbpg_segment_status is not None:
            result['adbpg_segment_status'] = self.adbpg_segment_status.to_map()
        if self.adbpg_status is not None:
            result['adbpg_status'] = self.adbpg_status.to_map()
        if self.node_master_connection_status is not None:
            result['node_master_connection_status'] = self.node_master_connection_status.to_map()
        if self.node_master_status is not None:
            result['node_master_status'] = self.node_master_status.to_map()
        if self.node_segment_connection_status is not None:
            result['node_segment_connection_status'] = self.node_segment_connection_status.to_map()
        if self.node_segment_disk_status is not None:
            result['node_segment_disk_status'] = self.node_segment_disk_status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adbgp_segment_disk_usage_percent_max') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbgpSegmentDiskUsagePercentMax()
            self.adbgp_segment_disk_usage_percent_max = temp_model.from_map(m['adbgp_segment_disk_usage_percent_max'])
        if m.get('adbpg_connection_status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgConnectionStatus()
            self.adbpg_connection_status = temp_model.from_map(m['adbpg_connection_status'])
        if m.get('adbpg_disk_status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgDiskStatus()
            self.adbpg_disk_status = temp_model.from_map(m['adbpg_disk_status'])
        if m.get('adbpg_disk_usage_percent') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgDiskUsagePercent()
            self.adbpg_disk_usage_percent = temp_model.from_map(m['adbpg_disk_usage_percent'])
        if m.get('adbpg_instance_cold_data_gb') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgInstanceColdDataGb()
            self.adbpg_instance_cold_data_gb = temp_model.from_map(m['adbpg_instance_cold_data_gb'])
        if m.get('adbpg_instance_hot_data_gb') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgInstanceHotDataGb()
            self.adbpg_instance_hot_data_gb = temp_model.from_map(m['adbpg_instance_hot_data_gb'])
        if m.get('adbpg_instance_total_data_gb') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgInstanceTotalDataGb()
            self.adbpg_instance_total_data_gb = temp_model.from_map(m['adbpg_instance_total_data_gb'])
        if m.get('adbpg_master_disk_usage_percent_max') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgMasterDiskUsagePercentMax()
            self.adbpg_master_disk_usage_percent_max = temp_model.from_map(m['adbpg_master_disk_usage_percent_max'])
        if m.get('adbpg_master_status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgMasterStatus()
            self.adbpg_master_status = temp_model.from_map(m['adbpg_master_status'])
        if m.get('adbpg_segment_status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgSegmentStatus()
            self.adbpg_segment_status = temp_model.from_map(m['adbpg_segment_status'])
        if m.get('adbpg_status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusAdbpgStatus()
            self.adbpg_status = temp_model.from_map(m['adbpg_status'])
        if m.get('node_master_connection_status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusNodeMasterConnectionStatus()
            self.node_master_connection_status = temp_model.from_map(m['node_master_connection_status'])
        if m.get('node_master_status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusNodeMasterStatus()
            self.node_master_status = temp_model.from_map(m['node_master_status'])
        if m.get('node_segment_connection_status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusNodeSegmentConnectionStatus()
            self.node_segment_connection_status = temp_model.from_map(m['node_segment_connection_status'])
        if m.get('node_segment_disk_status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatusNodeSegmentDiskStatus()
            self.node_segment_disk_status = temp_model.from_map(m['node_segment_disk_status'])
        return self


class DescribeHealthStatusResponseBody(TeaModel):
    def __init__(
        self,
        dbcluster_id: str = None,
        request_id: str = None,
        status: DescribeHealthStatusResponseBodyStatus = None,
    ):
        # The ID of instance.
        self.dbcluster_id = dbcluster_id
        # The ID of the request.
        self.request_id = request_id
        # The queried performance metrics. Each performance metric consists of the parameter name, status, and metric value. The metric information is returned only for the performance parameters specified by **Key**. For example, if you set **Key** to **adbpg_status**, only the metric information of **adbpg_status** is returned.
        # 
        # For more information about performance parameters, see [Performance parameters](https://help.aliyun.com/document_detail/86943.html).
        self.status = status

    def validate(self):
        if self.status:
            self.status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbcluster_id is not None:
            result['DBClusterId'] = self.dbcluster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBClusterId') is not None:
            self.dbcluster_id = m.get('DBClusterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            temp_model = DescribeHealthStatusResponseBodyStatus()
            self.status = temp_model.from_map(m['Status'])
        return self


class DescribeHealthStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHealthStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHealthStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIMVInfosRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        mvname: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.database = database
        # The name of MV
        self.mvname = mvname

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.mvname is not None:
            result['MVName'] = self.mvname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('MVName') is not None:
            self.mvname = m.get('MVName')
        return self


class DescribeIMVInfosResponseBodyImvInfos(TeaModel):
    def __init__(
        self,
        base: str = None,
        detail_info: str = None,
        mv: str = None,
    ):
        # The name of the table based on which the materialized view is created.
        self.base = base
        # The dependency between the materialized view and the base table and all metric values, which can be used to build a lineage graph.
        self.detail_info = detail_info
        # The name of the materialized view.
        self.mv = mv

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base is not None:
            result['Base'] = self.base
        if self.detail_info is not None:
            result['DetailInfo'] = self.detail_info
        if self.mv is not None:
            result['MV'] = self.mv
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Base') is not None:
            self.base = m.get('Base')
        if m.get('DetailInfo') is not None:
            self.detail_info = m.get('DetailInfo')
        if m.get('MV') is not None:
            self.mv = m.get('MV')
        return self


class DescribeIMVInfosResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        imv_infos: List[DescribeIMVInfosResponseBodyImvInfos] = None,
        request_id: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The queried materialized views.
        self.imv_infos = imv_infos
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.imv_infos:
            for k in self.imv_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        result['ImvInfos'] = []
        if self.imv_infos is not None:
            for k in self.imv_infos:
                result['ImvInfos'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        self.imv_infos = []
        if m.get('ImvInfos') is not None:
            for k in m.get('ImvInfos'):
                temp_model = DescribeIMVInfosResponseBodyImvInfos()
                self.imv_infos.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeIMVInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeIMVInfosResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeIMVInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIndexRequest(TeaModel):
    def __init__(
        self,
        collection: str = None,
        dbinstance_id: str = None,
        index_name: str = None,
        namespace: str = None,
        namespace_password: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # This parameter is required.
        self.collection = collection
        self.dbinstance_id = dbinstance_id
        # This parameter is required.
        self.index_name = index_name
        # This parameter is required.
        self.namespace = namespace
        # This parameter is required.
        self.namespace_password = namespace_password
        self.owner_id = owner_id
        # This parameter is required.
        self.region_id = region_id
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.index_name is not None:
            result['IndexName'] = self.index_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_password is not None:
            result['NamespacePassword'] = self.namespace_password
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('IndexName') is not None:
            self.index_name = m.get('IndexName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespacePassword') is not None:
            self.namespace_password = m.get('NamespacePassword')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DescribeIndexResponseBody(TeaModel):
    def __init__(
        self,
        collection: str = None,
        index_def: str = None,
        index_name: str = None,
        message: str = None,
        namespace: str = None,
        request_id: str = None,
        status: str = None,
    ):
        self.collection = collection
        self.index_def = index_def
        self.index_name = index_name
        self.message = message
        self.namespace = namespace
        self.request_id = request_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.index_def is not None:
            result['IndexDef'] = self.index_def
        if self.index_name is not None:
            result['IndexName'] = self.index_name
        if self.message is not None:
            result['Message'] = self.message
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('IndexDef') is not None:
            self.index_def = m.get('IndexDef')
        if m.get('IndexName') is not None:
            self.index_name = m.get('IndexName')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeIndexResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeIndexResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeIndexResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeJDBCDataSourceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_id: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The data source ID.
        # 
        # This parameter is required.
        self.data_source_id = data_source_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        return self


class DescribeJDBCDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        data_source_description: str = None,
        data_source_id: str = None,
        data_source_name: str = None,
        data_source_status: str = None,
        data_source_type: str = None,
        external_data_service_id: str = None,
        jdbcconnection_string: str = None,
        jdbcpassword: str = None,
        jdbcuser_name: str = None,
        modify_time: str = None,
        request_id: str = None,
        status_message: str = None,
    ):
        # The time when the service was created.
        self.create_time = create_time
        # The description of the service. The description can be up to 256 characters in length.
        self.data_source_description = data_source_description
        # The data source ID.
        self.data_source_id = data_source_id
        # The name of data soruce
        self.data_source_name = data_source_name
        # The status of the service. Valid values:
        # 
        # *   Init
        # *   Running
        # *   Exception
        self.data_source_status = data_source_status
        # The type of the data source.
        self.data_source_type = data_source_type
        # The id of the external data service
        self.external_data_service_id = external_data_service_id
        # The JDBC connection string.
        self.jdbcconnection_string = jdbcconnection_string
        # The password of the database account.
        self.jdbcpassword = jdbcpassword
        # The name of the database account.
        self.jdbcuser_name = jdbcuser_name
        # The time when the data source was last modified.
        self.modify_time = modify_time
        # The request ID.
        self.request_id = request_id
        # The message of the status
        self.status_message = status_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_source_description is not None:
            result['DataSourceDescription'] = self.data_source_description
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.data_source_status is not None:
            result['DataSourceStatus'] = self.data_source_status
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.external_data_service_id is not None:
            result['ExternalDataServiceId'] = self.external_data_service_id
        if self.jdbcconnection_string is not None:
            result['JDBCConnectionString'] = self.jdbcconnection_string
        if self.jdbcpassword is not None:
            result['JDBCPassword'] = self.jdbcpassword
        if self.jdbcuser_name is not None:
            result['JDBCUserName'] = self.jdbcuser_name
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_message is not None:
            result['StatusMessage'] = self.status_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSourceDescription') is not None:
            self.data_source_description = m.get('DataSourceDescription')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('DataSourceStatus') is not None:
            self.data_source_status = m.get('DataSourceStatus')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('ExternalDataServiceId') is not None:
            self.external_data_service_id = m.get('ExternalDataServiceId')
        if m.get('JDBCConnectionString') is not None:
            self.jdbcconnection_string = m.get('JDBCConnectionString')
        if m.get('JDBCPassword') is not None:
            self.jdbcpassword = m.get('JDBCPassword')
        if m.get('JDBCUserName') is not None:
            self.jdbcuser_name = m.get('JDBCUserName')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusMessage') is not None:
            self.status_message = m.get('StatusMessage')
        return self


class DescribeJDBCDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeJDBCDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeJDBCDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogBackupsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        end_time: str = None,
        page_number: int = None,
        page_size: int = None,
        start_time: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The end of the time range to query. The end time must be later than the start time. Specify the time in the yyyy-MM-ddTHH:mmZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The number of the page to return. The value must be an integer that is greater than 0. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the yyyy-MM-ddTHH:mmZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLogBackupsResponseBodyItems(TeaModel):
    def __init__(
        self,
        backup_id: str = None,
        dbinstance_id: str = None,
        log_file_name: str = None,
        log_file_size: int = None,
        log_time: str = None,
        segment_name: str = None,
    ):
        # The ID of the backup set.
        self.backup_id = backup_id
        # The ID of the coordinator node.
        self.dbinstance_id = dbinstance_id
        # The name of the log backup set that is stored in Object Storage Service (OSS).
        self.log_file_name = log_file_name
        # The size of the log backup set. Unit: bytes.
        self.log_file_size = log_file_size
        # The timestamp of the log.
        self.log_time = log_time
        # The name of the compute node.
        self.segment_name = segment_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.log_file_name is not None:
            result['LogFileName'] = self.log_file_name
        if self.log_file_size is not None:
            result['LogFileSize'] = self.log_file_size
        if self.log_time is not None:
            result['LogTime'] = self.log_time
        if self.segment_name is not None:
            result['SegmentName'] = self.segment_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('LogFileName') is not None:
            self.log_file_name = m.get('LogFileName')
        if m.get('LogFileSize') is not None:
            self.log_file_size = m.get('LogFileSize')
        if m.get('LogTime') is not None:
            self.log_time = m.get('LogTime')
        if m.get('SegmentName') is not None:
            self.segment_name = m.get('SegmentName')
        return self


class DescribeLogBackupsResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeLogBackupsResponseBodyItems] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        total_log_size: int = None,
    ):
        # Details of the backup sets.
        self.items = items
        # The page number of the returned page.
        self.page_number = page_number
        # The number of backup sets on the current page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries.
        self.total_count = total_count
        # The total size of logs in the time range. Unit: bytes.
        self.total_log_size = total_log_size

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_log_size is not None:
            result['TotalLogSize'] = self.total_log_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeLogBackupsResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalLogSize') is not None:
            self.total_log_size = m.get('TotalLogSize')
        return self


class DescribeLogBackupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLogBackupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLogBackupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeModifyParameterLogRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        end_time: str = None,
        start_time: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/196830.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-ddTHH:mmZ* format. The time must be in UTC. The end time must be later than the start time.
        self.end_time = end_time
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-ddTHH:mmZ* format. The time must be in UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeModifyParameterLogResponseBodyChangelogs(TeaModel):
    def __init__(
        self,
        effect_time: str = None,
        parameter_name: str = None,
        parameter_valid: str = None,
        parameter_value_after: str = None,
        parameter_value_before: str = None,
    ):
        # The effective time.
        self.effect_time = effect_time
        # The name of the parameter.
        self.parameter_name = parameter_name
        # Indicates whether the modification takes effect.
        self.parameter_valid = parameter_valid
        # The original value of the parameter.
        self.parameter_value_after = parameter_value_after
        # The new value of the parameter.
        self.parameter_value_before = parameter_value_before

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect_time is not None:
            result['EffectTime'] = self.effect_time
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_valid is not None:
            result['ParameterValid'] = self.parameter_valid
        if self.parameter_value_after is not None:
            result['ParameterValueAfter'] = self.parameter_value_after
        if self.parameter_value_before is not None:
            result['ParameterValueBefore'] = self.parameter_value_before
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectTime') is not None:
            self.effect_time = m.get('EffectTime')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterValid') is not None:
            self.parameter_valid = m.get('ParameterValid')
        if m.get('ParameterValueAfter') is not None:
            self.parameter_value_after = m.get('ParameterValueAfter')
        if m.get('ParameterValueBefore') is not None:
            self.parameter_value_before = m.get('ParameterValueBefore')
        return self


class DescribeModifyParameterLogResponseBody(TeaModel):
    def __init__(
        self,
        changelogs: List[DescribeModifyParameterLogResponseBodyChangelogs] = None,
        request_id: str = None,
    ):
        # The queried parameter modification logs.
        self.changelogs = changelogs
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.changelogs:
            for k in self.changelogs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Changelogs'] = []
        if self.changelogs is not None:
            for k in self.changelogs:
                result['Changelogs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.changelogs = []
        if m.get('Changelogs') is not None:
            for k in m.get('Changelogs'):
                temp_model = DescribeModifyParameterLogResponseBodyChangelogs()
                self.changelogs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeModifyParameterLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeModifyParameterLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeModifyParameterLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNamespaceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        manager_account: str = None,
        manager_account_password: str = None,
        namespace: str = None,
        owner_id: int = None,
        region_id: str = None,
        workspace_id: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The name of the manager account that has the rds_superuser permission.
        # 
        # >  You can create an account on the Account Management page of the AnalyticDB for PostgreSQL console or by calling the [CreateAccount](https://help.aliyun.com/document_detail/2361789.html) operation.
        # 
        # This parameter is required.
        self.manager_account = manager_account
        # The password of the manager account.
        # 
        # This parameter is required.
        self.manager_account_password = manager_account_password
        # The name of the namespace. Default value: public.
        # 
        # >  You can call the [ListNamespaces](https://help.aliyun.com/document_detail/2401502.html) operation to query a list of namespaces.
        # 
        # This parameter is required.
        self.namespace = namespace
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the workspace that consists of multiple AnalyticDB for PostgreSQL instances. You must specify one of the WorkspaceId and DBInstanceId parameters. If you specify both parameters, the WorkspaceId parameter takes effect.
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.manager_account is not None:
            result['ManagerAccount'] = self.manager_account
        if self.manager_account_password is not None:
            result['ManagerAccountPassword'] = self.manager_account_password
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ManagerAccount') is not None:
            self.manager_account = m.get('ManagerAccount')
        if m.get('ManagerAccountPassword') is not None:
            self.manager_account_password = m.get('ManagerAccountPassword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DescribeNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        message: str = None,
        namespace: str = None,
        namespace_info: Dict[str, str] = None,
        region_id: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The returned message.
        self.message = message
        # The name of the namespace.
        self.namespace = namespace
        # The queried namespace.
        self.namespace_info = namespace_info
        # The region ID of the instance.
        self.region_id = region_id
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.message is not None:
            result['Message'] = self.message
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_info is not None:
            result['NamespaceInfo'] = self.namespace_info
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespaceInfo') is not None:
            self.namespace_info = m.get('NamespaceInfo')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeParametersRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeParametersResponseBodyParameters(TeaModel):
    def __init__(
        self,
        current_value: str = None,
        force_restart_instance: str = None,
        is_changeable_config: str = None,
        optional_range: str = None,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_value: str = None,
    ):
        # The current value of the configuration parameter.
        self.current_value = current_value
        # Indicates whether a restart is required for parameter modifications to take effect. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.force_restart_instance = force_restart_instance
        # Indicates whether the configuration parameter can be modified. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_changeable_config = is_changeable_config
        # The valid values of the configuration parameter.
        self.optional_range = optional_range
        # The description of the configuration parameter.
        self.parameter_description = parameter_description
        # The name of the configuration parameter.
        self.parameter_name = parameter_name
        # The default value of the configuration parameter.
        self.parameter_value = parameter_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_value is not None:
            result['CurrentValue'] = self.current_value
        if self.force_restart_instance is not None:
            result['ForceRestartInstance'] = self.force_restart_instance
        if self.is_changeable_config is not None:
            result['IsChangeableConfig'] = self.is_changeable_config
        if self.optional_range is not None:
            result['OptionalRange'] = self.optional_range
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_value is not None:
            result['ParameterValue'] = self.parameter_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentValue') is not None:
            self.current_value = m.get('CurrentValue')
        if m.get('ForceRestartInstance') is not None:
            self.force_restart_instance = m.get('ForceRestartInstance')
        if m.get('IsChangeableConfig') is not None:
            self.is_changeable_config = m.get('IsChangeableConfig')
        if m.get('OptionalRange') is not None:
            self.optional_range = m.get('OptionalRange')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterValue') is not None:
            self.parameter_value = m.get('ParameterValue')
        return self


class DescribeParametersResponseBody(TeaModel):
    def __init__(
        self,
        parameters: List[DescribeParametersResponseBodyParameters] = None,
        request_id: str = None,
    ):
        # The queried configuration parameters.
        self.parameters = parameters
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.parameters:
            for k in self.parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Parameters'] = []
        if self.parameters is not None:
            for k in self.parameters:
                result['Parameters'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parameters = []
        if m.get('Parameters') is not None:
            for k in m.get('Parameters'):
                temp_model = DescribeParametersResponseBodyParameters()
                self.parameters.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeParametersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeParametersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeParametersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsVSwitchsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        security_token: str = None,
        vpc_id: str = None,
        zone_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The ID of the region.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list and zone list.
        self.region_id = region_id
        # This parameter is no longer used.
        self.resource_group_id = resource_group_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.security_token = security_token
        # The virtual private cloud (VPC) ID of the instance.
        # 
        # > 
        # 
        # *   You can call the [DescribeRdsVpcs](https://help.aliyun.com/document_detail/208327.html) operation to query the available VPC IDs.
        # 
        # *   This parameter must be specified.
        self.vpc_id = vpc_id
        # The ID of the zone.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list and zone list.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeRdsVSwitchsResponseBodyVSwitchesVSwitch(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        bid: str = None,
        cidr_block: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        is_default: bool = None,
        iz_no: str = None,
        region_no: str = None,
        status: str = None,
        v_switch_id: str = None,
        v_switch_name: str = None,
    ):
        # An invalid parameter. It is no longer returned when you call this operation.
        self.ali_uid = ali_uid
        # An invalid parameter. It is no longer returned when you call this operation.
        self.bid = bid
        # The CIDR block of the vSwitch.
        self.cidr_block = cidr_block
        # An invalid parameter. It is no longer returned when you call this operation.
        self.gmt_create = gmt_create
        # An invalid parameter. It is no longer returned when you call this operation.
        self.gmt_modified = gmt_modified
        # Indicates whether the vSwitch is the default vSwitch. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_default = is_default
        # The ID of the zone.
        self.iz_no = iz_no
        # An invalid parameter. It is no longer returned when you call this operation.
        self.region_no = region_no
        # The state of the vSwitch. If **Available** is returned, the vSwitch is available.
        self.status = status
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id
        # The name of the vSwitch.
        self.v_switch_name = v_switch_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.iz_no is not None:
            result['IzNo'] = self.iz_no
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.status is not None:
            result['Status'] = self.status
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('IzNo') is not None:
            self.iz_no = m.get('IzNo')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        return self


class DescribeRdsVSwitchsResponseBodyVSwitches(TeaModel):
    def __init__(
        self,
        v_switch: List[DescribeRdsVSwitchsResponseBodyVSwitchesVSwitch] = None,
    ):
        # Details of the vSwitch.
        self.v_switch = v_switch

    def validate(self):
        if self.v_switch:
            for k in self.v_switch:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VSwitch'] = []
        if self.v_switch is not None:
            for k in self.v_switch:
                result['VSwitch'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.v_switch = []
        if m.get('VSwitch') is not None:
            for k in m.get('VSwitch'):
                temp_model = DescribeRdsVSwitchsResponseBodyVSwitchesVSwitch()
                self.v_switch.append(temp_model.from_map(k))
        return self


class DescribeRdsVSwitchsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        v_switches: DescribeRdsVSwitchsResponseBodyVSwitches = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # Details of the vSwitches.
        self.v_switches = v_switches

    def validate(self):
        if self.v_switches:
            self.v_switches.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.v_switches is not None:
            result['VSwitches'] = self.v_switches.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VSwitches') is not None:
            temp_model = DescribeRdsVSwitchsResponseBodyVSwitches()
            self.v_switches = temp_model.from_map(m['VSwitches'])
        return self


class DescribeRdsVSwitchsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRdsVSwitchsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRdsVSwitchsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsVpcsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        security_token: str = None,
        zone_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The ID of the region.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        self.region_id = region_id
        # This parameter is no longer used.
        self.resource_group_id = resource_group_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.security_token = security_token
        # The ID of the zone.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeRdsVpcsResponseBodyVpcsVpcVSwitchs(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        is_default: bool = None,
        iz_no: str = None,
        status: str = None,
        v_switch_id: str = None,
        v_switch_name: str = None,
    ):
        # The CIDR block of the vSwitch.
        self.cidr_block = cidr_block
        # An invalid parameter. It is no longer returned when you call this operation.
        self.gmt_create = gmt_create
        # An invalid parameter. It is no longer returned when you call this operation.
        self.gmt_modified = gmt_modified
        # Indicates whether the vSwitch is the default vSwitch. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_default = is_default
        # The ID of the zone to which the vSwitch belongs.
        self.iz_no = iz_no
        # The state of the vSwitch. If **Available** is returned, the vSwitch is available.
        self.status = status
        # The vSwitch ID.
        self.v_switch_id = v_switch_id
        # The name of the vSwitch.
        self.v_switch_name = v_switch_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.iz_no is not None:
            result['IzNo'] = self.iz_no
        if self.status is not None:
            result['Status'] = self.status
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('IzNo') is not None:
            self.iz_no = m.get('IzNo')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        return self


class DescribeRdsVpcsResponseBodyVpcsVpc(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        bid: str = None,
        cidr_block: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        is_default: bool = None,
        region_no: str = None,
        status: str = None,
        v_switchs: List[DescribeRdsVpcsResponseBodyVpcsVpcVSwitchs] = None,
        vpc_id: str = None,
        vpc_name: str = None,
    ):
        # An invalid parameter. It is no longer returned when you call this operation.
        self.ali_uid = ali_uid
        # An invalid parameter. It is no longer returned when you call this operation.
        self.bid = bid
        # The CIDR block of the VPC.
        self.cidr_block = cidr_block
        # An invalid parameter. It is no longer returned when you call this operation.
        self.gmt_create = gmt_create
        # An invalid parameter. It is no longer returned when you call this operation.
        self.gmt_modified = gmt_modified
        # Indicates whether the VPC is the default VPC. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_default = is_default
        # The region ID of the instance.
        self.region_no = region_no
        # The state of the VPC. If **Available** is returned, the VPC is available.
        self.status = status
        # The queried vSwitches.
        self.v_switchs = v_switchs
        # The VPC ID.
        self.vpc_id = vpc_id
        # The name of the VPC.
        self.vpc_name = vpc_name

    def validate(self):
        if self.v_switchs:
            for k in self.v_switchs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.bid is not None:
            result['Bid'] = self.bid
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.status is not None:
            result['Status'] = self.status
        result['VSwitchs'] = []
        if self.v_switchs is not None:
            for k in self.v_switchs:
                result['VSwitchs'].append(k.to_map() if k else None)
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('Bid') is not None:
            self.bid = m.get('Bid')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.v_switchs = []
        if m.get('VSwitchs') is not None:
            for k in m.get('VSwitchs'):
                temp_model = DescribeRdsVpcsResponseBodyVpcsVpcVSwitchs()
                self.v_switchs.append(temp_model.from_map(k))
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class DescribeRdsVpcsResponseBodyVpcs(TeaModel):
    def __init__(
        self,
        vpc: List[DescribeRdsVpcsResponseBodyVpcsVpc] = None,
    ):
        # The queried VPC.
        self.vpc = vpc

    def validate(self):
        if self.vpc:
            for k in self.vpc:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Vpc'] = []
        if self.vpc is not None:
            for k in self.vpc:
                result['Vpc'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.vpc = []
        if m.get('Vpc') is not None:
            for k in m.get('Vpc'):
                temp_model = DescribeRdsVpcsResponseBodyVpcsVpc()
                self.vpc.append(temp_model.from_map(k))
        return self


class DescribeRdsVpcsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vpcs: DescribeRdsVpcsResponseBodyVpcs = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The queried VPCs.
        self.vpcs = vpcs

    def validate(self):
        if self.vpcs:
            self.vpcs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vpcs is not None:
            result['Vpcs'] = self.vpcs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Vpcs') is not None:
            temp_model = DescribeRdsVpcsResponseBodyVpcs()
            self.vpcs = temp_model.from_map(m['Vpcs'])
        return self


class DescribeRdsVpcsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRdsVpcsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRdsVpcsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionsRequest(TeaModel):
    def __init__(
        self,
        region: str = None,
    ):
        # The ID of the region.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeRegionsResponseBodyRegionsRegionZonesZone(TeaModel):
    def __init__(
        self,
        vpc_enabled: bool = None,
        zone_id: str = None,
    ):
        # Indicates whether Virtual Private Cloud (VPC) is available.
        # 
        # *   **true**: VPC is available.
        # *   **false**: VPC is unavailable.
        self.vpc_enabled = vpc_enabled
        # The ID of the zone.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_enabled is not None:
            result['VpcEnabled'] = self.vpc_enabled
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcEnabled') is not None:
            self.vpc_enabled = m.get('VpcEnabled')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeRegionsResponseBodyRegionsRegionZones(TeaModel):
    def __init__(
        self,
        zone: List[DescribeRegionsResponseBodyRegionsRegionZonesZone] = None,
    ):
        self.zone = zone

    def validate(self):
        if self.zone:
            for k in self.zone:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Zone'] = []
        if self.zone is not None:
            for k in self.zone:
                result['Zone'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.zone = []
        if m.get('Zone') is not None:
            for k in m.get('Zone'):
                temp_model = DescribeRegionsResponseBodyRegionsRegionZonesZone()
                self.zone.append(temp_model.from_map(k))
        return self


class DescribeRegionsResponseBodyRegionsRegion(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        zones: DescribeRegionsResponseBodyRegionsRegionZones = None,
    ):
        # The ID of the region.
        self.region_id = region_id
        # Details of the zones.
        self.zones = zones

    def validate(self):
        if self.zones:
            self.zones.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zones is not None:
            result['Zones'] = self.zones.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Zones') is not None:
            temp_model = DescribeRegionsResponseBodyRegionsRegionZones()
            self.zones = temp_model.from_map(m['Zones'])
        return self


class DescribeRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        region: List[DescribeRegionsResponseBodyRegionsRegion] = None,
    ):
        self.region = region

    def validate(self):
        if self.region:
            for k in self.region:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Region'] = []
        if self.region is not None:
            for k in self.region:
                result['Region'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.region = []
        if m.get('Region') is not None:
            for k in m.get('Region'):
                temp_model = DescribeRegionsResponseBodyRegionsRegion()
                self.region.append(temp_model.from_map(k))
        return self


class DescribeRegionsResponseBody(TeaModel):
    def __init__(
        self,
        regions: DescribeRegionsResponseBodyRegions = None,
        request_id: str = None,
    ):
        # Details of the regions.
        self.regions = regions
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.regions:
            self.regions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Regions') is not None:
            temp_model = DescribeRegionsResponseBodyRegions()
            self.regions = temp_model.from_map(m['Regions'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRolesRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeRolesResponseBodyRoleList(TeaModel):
    def __init__(
        self,
        role: List[str] = None,
    ):
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class DescribeRolesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        role_list: DescribeRolesResponseBodyRoleList = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The roles.
        self.role_list = role_list

    def validate(self):
        if self.role_list:
            self.role_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.role_list is not None:
            result['RoleList'] = self.role_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RoleList') is not None:
            temp_model = DescribeRolesResponseBodyRoleList()
            self.role_list = temp_model.from_map(m['RoleList'])
        return self


class DescribeRolesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRolesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRolesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSQLLogCountRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        execute_cost: str = None,
        execute_state: str = None,
        max_execute_cost: str = None,
        min_execute_cost: str = None,
        operation_class: str = None,
        operation_type: str = None,
        query_keywords: str = None,
        source_ip: str = None,
        start_time: str = None,
        user: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database = database
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        # 
        # > The end time must be later than the start time. The maximum time range that can be specified is seven days.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The execution duration of the SQL statement. Unit: seconds.
        self.execute_cost = execute_cost
        # The execution status of the query. Valid values:
        # 
        # *   1: successful.
        # *   0: failed.
        # *   0,1 or 1,0: all.
        self.execute_state = execute_state
        # The maximum amount of time consumed by a slow query. Unit: seconds. Minimum value: 0.
        self.max_execute_cost = max_execute_cost
        # The minimum amount of time consumed by a slow query. Unit: seconds. Minimum value: 0.
        self.min_execute_cost = min_execute_cost
        # The type of the query language. Valid values:
        # 
        # *   **DQL**\
        # *   **DML**\
        # *   **DDL**\
        # *   **DCL**\
        # *   **TCL**\
        self.operation_class = operation_class
        # The type of the SQL statement.
        # 
        # > 
        # 
        # *   If you specify **OperationClass**, the value of **OperationType** must be of the corresponding query language. For example, if you set **OperationClass** to **DQL**, the value of **OperationType** must be a **DQL** statement such as **SELECT**.
        # 
        # *   If you leave **OperationClass** empty, the value of **OperationType** can be an SQL statement of any query language.
        # 
        # *   If you leave **OperationClass** and **OperationType** empty, all types of SQL statements are returned.
        self.operation_type = operation_type
        # The keywords that are used to query audit logs.
        self.query_keywords = query_keywords
        # The source IP address.
        self.source_ip = source_ip
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The name of the database account that is used to connect to the database.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.execute_cost is not None:
            result['ExecuteCost'] = self.execute_cost
        if self.execute_state is not None:
            result['ExecuteState'] = self.execute_state
        if self.max_execute_cost is not None:
            result['MaxExecuteCost'] = self.max_execute_cost
        if self.min_execute_cost is not None:
            result['MinExecuteCost'] = self.min_execute_cost
        if self.operation_class is not None:
            result['OperationClass'] = self.operation_class
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.query_keywords is not None:
            result['QueryKeywords'] = self.query_keywords
        if self.source_ip is not None:
            result['SourceIP'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExecuteCost') is not None:
            self.execute_cost = m.get('ExecuteCost')
        if m.get('ExecuteState') is not None:
            self.execute_state = m.get('ExecuteState')
        if m.get('MaxExecuteCost') is not None:
            self.max_execute_cost = m.get('MaxExecuteCost')
        if m.get('MinExecuteCost') is not None:
            self.min_execute_cost = m.get('MinExecuteCost')
        if m.get('OperationClass') is not None:
            self.operation_class = m.get('OperationClass')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('QueryKeywords') is not None:
            self.query_keywords = m.get('QueryKeywords')
        if m.get('SourceIP') is not None:
            self.source_ip = m.get('SourceIP')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeSQLLogCountResponseBodyItemsSeriesValues(TeaModel):
    def __init__(
        self,
        point: List[str] = None,
    ):
        # The time when the audit logs were generated and the number of the audit logs.
        self.point = point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.point is not None:
            result['Point'] = self.point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Point') is not None:
            self.point = m.get('Point')
        return self


class DescribeSQLLogCountResponseBodyItemsSeries(TeaModel):
    def __init__(
        self,
        values: List[DescribeSQLLogCountResponseBodyItemsSeriesValues] = None,
    ):
        # Details of the audit logs.
        self.values = values

    def validate(self):
        if self.values:
            for k in self.values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Values'] = []
        if self.values is not None:
            for k in self.values:
                result['Values'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.values = []
        if m.get('Values') is not None:
            for k in m.get('Values'):
                temp_model = DescribeSQLLogCountResponseBodyItemsSeriesValues()
                self.values.append(temp_model.from_map(k))
        return self


class DescribeSQLLogCountResponseBodyItems(TeaModel):
    def __init__(
        self,
        name: str = None,
        series: List[DescribeSQLLogCountResponseBodyItemsSeries] = None,
    ):
        # The name of the table.
        self.name = name
        # Details of the audit logs.
        self.series = series

    def validate(self):
        if self.series:
            for k in self.series:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['Series'] = []
        if self.series is not None:
            for k in self.series:
                result['Series'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.series = []
        if m.get('Series') is not None:
            for k in m.get('Series'):
                temp_model = DescribeSQLLogCountResponseBodyItemsSeries()
                self.series.append(temp_model.from_map(k))
        return self


class DescribeSQLLogCountResponseBody(TeaModel):
    def __init__(
        self,
        dbcluster_id: str = None,
        end_time: str = None,
        items: List[DescribeSQLLogCountResponseBodyItems] = None,
        request_id: str = None,
        start_time: str = None,
    ):
        # The instance ID.
        self.dbcluster_id = dbcluster_id
        # The end time of the query.
        self.end_time = end_time
        # The name of the instance.
        self.items = items
        # The request ID.
        self.request_id = request_id
        # The start time of the query.
        self.start_time = start_time

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbcluster_id is not None:
            result['DBClusterId'] = self.dbcluster_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBClusterId') is not None:
            self.dbcluster_id = m.get('DBClusterId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeSQLLogCountResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeSQLLogCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSQLLogCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSQLLogCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSQLLogsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        execute_cost: str = None,
        execute_state: str = None,
        max_execute_cost: str = None,
        min_execute_cost: str = None,
        operation_class: str = None,
        operation_type: str = None,
        page_number: int = None,
        page_size: int = None,
        query_keywords: str = None,
        source_ip: str = None,
        start_time: str = None,
        user: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances within a region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database = database
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-ddTHH:mmZ* format. The time must be in UTC.
        # 
        # > The end time must be later than the start time. The maximum time range that can be specified is seven days.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The execution duration of the SQL statement. Unit: seconds.
        self.execute_cost = execute_cost
        # The execution status of the SQL statement. Valid values:
        # 
        # *   **1**: successful.
        # *   **0**: failed.
        self.execute_state = execute_state
        # The maximum amount of time consumed by a slow query. Unit: seconds. Minimum value: 0.
        self.max_execute_cost = max_execute_cost
        # The minimum amount of time consumed by a slow query. Unit: seconds. Minimum value: 0.
        self.min_execute_cost = min_execute_cost
        # The type of the query language. Valid values:
        # 
        # *   **DQL**\
        # *   **DML**\
        # *   **DDL**\
        # *   **DCL**\
        # *   **TCL**\
        self.operation_class = operation_class
        # The type of the SQL statement.
        # 
        # > 
        # 
        # *   If **OperationClass** is specified, the value of **OperationType** must belong to the corresponding query language. For example, if **OperationClass** is set to **DQL**, the value of **OperationType** must be a **DQL** statement such as **SELECT**.
        # 
        # *   If **OperationClass** is not specified, the value of **OperationType** can be an SQL statement of any query language.
        # *   If **OperationClass** and **OperationType** are not specified, all types of SQL statements are returned.
        self.operation_type = operation_type
        # The page number. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size
        # The keywords of the SQL statement.
        self.query_keywords = query_keywords
        # The source IP address.
        self.source_ip = source_ip
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-ddTHH:mmZ* format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.execute_cost is not None:
            result['ExecuteCost'] = self.execute_cost
        if self.execute_state is not None:
            result['ExecuteState'] = self.execute_state
        if self.max_execute_cost is not None:
            result['MaxExecuteCost'] = self.max_execute_cost
        if self.min_execute_cost is not None:
            result['MinExecuteCost'] = self.min_execute_cost
        if self.operation_class is not None:
            result['OperationClass'] = self.operation_class
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_keywords is not None:
            result['QueryKeywords'] = self.query_keywords
        if self.source_ip is not None:
            result['SourceIP'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExecuteCost') is not None:
            self.execute_cost = m.get('ExecuteCost')
        if m.get('ExecuteState') is not None:
            self.execute_state = m.get('ExecuteState')
        if m.get('MaxExecuteCost') is not None:
            self.max_execute_cost = m.get('MaxExecuteCost')
        if m.get('MinExecuteCost') is not None:
            self.min_execute_cost = m.get('MinExecuteCost')
        if m.get('OperationClass') is not None:
            self.operation_class = m.get('OperationClass')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryKeywords') is not None:
            self.query_keywords = m.get('QueryKeywords')
        if m.get('SourceIP') is not None:
            self.source_ip = m.get('SourceIP')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeSQLLogsResponseBodyItems(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        dbname: str = None,
        dbrole: str = None,
        execute_cost: float = None,
        execute_state: str = None,
        operation_class: str = None,
        operation_execute_time: str = None,
        operation_type: str = None,
        return_row_counts: int = None,
        sqlplan: str = None,
        sqltext: str = None,
        scan_row_counts: int = None,
        source_ip: str = None,
        source_port: int = None,
    ):
        # The database account that executes the SQL statement.
        self.account_name = account_name
        # The name of the database.
        self.dbname = dbname
        # The role of the database.
        self.dbrole = dbrole
        # The execution duration of the SQL statement.
        self.execute_cost = execute_cost
        # The execution status of the SQL statement. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.execute_state = execute_state
        # The type of the query language.
        self.operation_class = operation_class
        # The time when the SQL statement was executed.
        self.operation_execute_time = operation_execute_time
        # The type of the SQL statement.
        self.operation_type = operation_type
        # The total number of entries returned.
        self.return_row_counts = return_row_counts
        # The SQL execution plan.
        self.sqlplan = sqlplan
        # The SQL statement.
        self.sqltext = sqltext
        # The number of entries scanned.
        self.scan_row_counts = scan_row_counts
        # The source IP address.
        self.source_ip = source_ip
        # The number of the source port.
        self.source_port = source_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.dbrole is not None:
            result['DBRole'] = self.dbrole
        if self.execute_cost is not None:
            result['ExecuteCost'] = self.execute_cost
        if self.execute_state is not None:
            result['ExecuteState'] = self.execute_state
        if self.operation_class is not None:
            result['OperationClass'] = self.operation_class
        if self.operation_execute_time is not None:
            result['OperationExecuteTime'] = self.operation_execute_time
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.return_row_counts is not None:
            result['ReturnRowCounts'] = self.return_row_counts
        if self.sqlplan is not None:
            result['SQLPlan'] = self.sqlplan
        if self.sqltext is not None:
            result['SQLText'] = self.sqltext
        if self.scan_row_counts is not None:
            result['ScanRowCounts'] = self.scan_row_counts
        if self.source_ip is not None:
            result['SourceIP'] = self.source_ip
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('DBRole') is not None:
            self.dbrole = m.get('DBRole')
        if m.get('ExecuteCost') is not None:
            self.execute_cost = m.get('ExecuteCost')
        if m.get('ExecuteState') is not None:
            self.execute_state = m.get('ExecuteState')
        if m.get('OperationClass') is not None:
            self.operation_class = m.get('OperationClass')
        if m.get('OperationExecuteTime') is not None:
            self.operation_execute_time = m.get('OperationExecuteTime')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('ReturnRowCounts') is not None:
            self.return_row_counts = m.get('ReturnRowCounts')
        if m.get('SQLPlan') is not None:
            self.sqlplan = m.get('SQLPlan')
        if m.get('SQLText') is not None:
            self.sqltext = m.get('SQLText')
        if m.get('ScanRowCounts') is not None:
            self.scan_row_counts = m.get('ScanRowCounts')
        if m.get('SourceIP') is not None:
            self.source_ip = m.get('SourceIP')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        return self


class DescribeSQLLogsResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeSQLLogsResponseBodyItems] = None,
        page_number: int = None,
        page_record_count: int = None,
        request_id: str = None,
    ):
        # The queried SQL execution logs.
        self.items = items
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_record_count = page_record_count
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeSQLLogsResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSQLLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSQLLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSQLLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSQLLogsV2Request(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        execute_cost: str = None,
        execute_state: str = None,
        max_execute_cost: str = None,
        min_execute_cost: str = None,
        operation_class: str = None,
        operation_type: str = None,
        page_number: str = None,
        page_size: str = None,
        query_keywords: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        source_ip: str = None,
        start_time: str = None,
        user: str = None,
    ):
        # The ID of instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database = database
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-ddTHH:mmZ* format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time. The interval cannot be more than 24 hours.
        self.end_time = end_time
        # The execution duration of the SQL statement. Unit: seconds.
        self.execute_cost = execute_cost
        # The execution status of the SQL statement. Valid values:
        # 
        # *   **1**: successful.
        # *   **0**: failed.
        self.execute_state = execute_state
        # The maximum amount of time consumed by a slow query. Minimum value: 0. Unit: seconds.
        self.max_execute_cost = max_execute_cost
        # The minimum amount of time consumed by a slow query. Minimum value: 0. Unit: seconds.
        self.min_execute_cost = min_execute_cost
        # The type of the query language. Valid values:
        # 
        # *   **DQL**\
        # *   **DML**\
        # *   **DDL**\
        # *   **DCL**\
        # *   **TCL**\
        self.operation_class = operation_class
        # The type of the SQL statement.
        # 
        # > *   If the **OperationClass** parameter is specified, the **OperationType** value must belong to the corresponding query language. For example, if the **OperationClass** value is **DQL**, the **OperationType** value must be a **DQL** SQL statement such as **SELECT**.
        # >*   If the **OperationClass** parameter is not specified, the **OperationType** value can be an SQL statement of all query languages.
        # >*   If neither of the **OperationClass** and **OperationType** parameters is specified, all types of SQL statements are returned.
        self.operation_type = operation_type
        # The number of entries to return on each page.
        self.page_number = page_number
        # The number of the page to return. The maximum value is 200.
        self.page_size = page_size
        # The keywords of the SQL statement.
        self.query_keywords = query_keywords
        # The region ID of the instance.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id
        # The source IP address.
        self.source_ip = source_ip
        # The beginning of the time range. Specify the time in the ISO 8601 standard in the *yyyy-MM-ddTHH:mmZ* format. The time must be in UTC.
        self.start_time = start_time
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.execute_cost is not None:
            result['ExecuteCost'] = self.execute_cost
        if self.execute_state is not None:
            result['ExecuteState'] = self.execute_state
        if self.max_execute_cost is not None:
            result['MaxExecuteCost'] = self.max_execute_cost
        if self.min_execute_cost is not None:
            result['MinExecuteCost'] = self.min_execute_cost
        if self.operation_class is not None:
            result['OperationClass'] = self.operation_class
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_keywords is not None:
            result['QueryKeywords'] = self.query_keywords
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.source_ip is not None:
            result['SourceIP'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExecuteCost') is not None:
            self.execute_cost = m.get('ExecuteCost')
        if m.get('ExecuteState') is not None:
            self.execute_state = m.get('ExecuteState')
        if m.get('MaxExecuteCost') is not None:
            self.max_execute_cost = m.get('MaxExecuteCost')
        if m.get('MinExecuteCost') is not None:
            self.min_execute_cost = m.get('MinExecuteCost')
        if m.get('OperationClass') is not None:
            self.operation_class = m.get('OperationClass')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryKeywords') is not None:
            self.query_keywords = m.get('QueryKeywords')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SourceIP') is not None:
            self.source_ip = m.get('SourceIP')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeSQLLogsV2ResponseBodyItems(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        dbname: str = None,
        dbrole: str = None,
        error_code: str = None,
        error_msg: str = None,
        execute_cost: float = None,
        execute_state: str = None,
        operation_class: str = None,
        operation_execute_time: str = None,
        operation_type: str = None,
        query_id: str = None,
        return_row_counts: int = None,
        sqltext: str = None,
        scan_row_counts: int = None,
        session_id: str = None,
        source_ip: str = None,
        source_port: int = None,
    ):
        # The database account that executes the SQL statement.
        self.account_name = account_name
        # The name of the database.
        self.dbname = dbname
        # The role of the database.
        self.dbrole = dbrole
        # The error code.
        self.error_code = error_code
        # The error message.
        self.error_msg = error_msg
        # The execution duration of the SQL statement.
        self.execute_cost = execute_cost
        # The execution status of the SQL statement. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.execute_state = execute_state
        # The type of the query language.
        self.operation_class = operation_class
        # The time when the SQL statement was executed.
        self.operation_execute_time = operation_execute_time
        # The type of the SQL statement.
        self.operation_type = operation_type
        # The query ID.
        self.query_id = query_id
        # The number of entries returned.
        self.return_row_counts = return_row_counts
        # The SQL statement.
        self.sqltext = sqltext
        # The number of entries scanned.
        self.scan_row_counts = scan_row_counts
        # The ID of the session.
        self.session_id = session_id
        # The source IP address.
        self.source_ip = source_ip
        # The number of the source port.
        self.source_port = source_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.dbrole is not None:
            result['DBRole'] = self.dbrole
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.execute_cost is not None:
            result['ExecuteCost'] = self.execute_cost
        if self.execute_state is not None:
            result['ExecuteState'] = self.execute_state
        if self.operation_class is not None:
            result['OperationClass'] = self.operation_class
        if self.operation_execute_time is not None:
            result['OperationExecuteTime'] = self.operation_execute_time
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.query_id is not None:
            result['QueryId'] = self.query_id
        if self.return_row_counts is not None:
            result['ReturnRowCounts'] = self.return_row_counts
        if self.sqltext is not None:
            result['SQLText'] = self.sqltext
        if self.scan_row_counts is not None:
            result['ScanRowCounts'] = self.scan_row_counts
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.source_ip is not None:
            result['SourceIP'] = self.source_ip
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('DBRole') is not None:
            self.dbrole = m.get('DBRole')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('ExecuteCost') is not None:
            self.execute_cost = m.get('ExecuteCost')
        if m.get('ExecuteState') is not None:
            self.execute_state = m.get('ExecuteState')
        if m.get('OperationClass') is not None:
            self.operation_class = m.get('OperationClass')
        if m.get('OperationExecuteTime') is not None:
            self.operation_execute_time = m.get('OperationExecuteTime')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('QueryId') is not None:
            self.query_id = m.get('QueryId')
        if m.get('ReturnRowCounts') is not None:
            self.return_row_counts = m.get('ReturnRowCounts')
        if m.get('SQLText') is not None:
            self.sqltext = m.get('SQLText')
        if m.get('ScanRowCounts') is not None:
            self.scan_row_counts = m.get('ScanRowCounts')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('SourceIP') is not None:
            self.source_ip = m.get('SourceIP')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        return self


class DescribeSQLLogsV2ResponseBody(TeaModel):
    def __init__(
        self,
        access_denied_detail: str = None,
        items: List[DescribeSQLLogsV2ResponseBodyItems] = None,
        page_number: int = None,
        page_record_count: int = None,
        request_id: str = None,
    ):
        # The details about the access denial.
        self.access_denied_detail = access_denied_detail
        # The queried SQL execution logs.
        self.items = items
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_record_count = page_record_count
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_denied_detail is not None:
            result['AccessDeniedDetail'] = self.access_denied_detail
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessDeniedDetail') is not None:
            self.access_denied_detail = m.get('AccessDeniedDetail')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeSQLLogsV2ResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSQLLogsV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSQLLogsV2ResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSQLLogsV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSampleDataRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeSampleDataResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        error_message: str = None,
        has_sample_data: bool = None,
        request_id: str = None,
        sample_data_status: str = None,
    ):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id
        # The error message returned if an error occurs. This message does not affect the execution of the operation.
        self.error_message = error_message
        # Indicates whether a sample dataset is loaded to the instance. Valid values:
        # 
        # *   **true**: A sample dataset is loaded.
        # *   **false**: No sample dataset is loaded.
        self.has_sample_data = has_sample_data
        # The ID of the request.
        self.request_id = request_id
        # The loading status of the sample dataset. Valid values:
        # 
        # *   **loaded**\
        # *   **loading**\
        # *   **unload**\
        self.sample_data_status = sample_data_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.has_sample_data is not None:
            result['HasSampleData'] = self.has_sample_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sample_data_status is not None:
            result['SampleDataStatus'] = self.sample_data_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HasSampleData') is not None:
            self.has_sample_data = m.get('HasSampleData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SampleDataStatus') is not None:
            self.sample_data_status = m.get('SampleDataStatus')
        return self


class DescribeSampleDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSampleDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSampleDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStreamingDataServiceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        region_id: str = None,
        service_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The region ID.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        self.region_id = region_id
        # The service ID.
        # 
        # This parameter is required.
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class DescribeStreamingDataServiceResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        modify_time: str = None,
        request_id: str = None,
        service_description: str = None,
        service_id: str = None,
        service_ip: str = None,
        service_managed: bool = None,
        service_name: str = None,
        service_owner_id: str = None,
        service_port: int = None,
        service_spec: str = None,
        status: str = None,
    ):
        # The time when the service was created.
        self.create_time = create_time
        # The time when the service was last modified.
        self.modify_time = modify_time
        # The request ID.
        self.request_id = request_id
        # The description of the service.
        self.service_description = service_description
        # The service ID.
        self.service_id = service_id
        # The IP address of the service.
        self.service_ip = service_ip
        # The service is managed by other aliyun product or not.
        self.service_managed = service_managed
        # The name of the service.
        self.service_name = service_name
        # The service account uid of the aliyun product
        self.service_owner_id = service_owner_id
        # The port number of the service.
        self.service_port = service_port
        # The specifications of the service.
        self.service_spec = service_spec
        # The status of the service. Valid values:
        # 
        # *   Init
        # *   Running
        # *   Exception
        # *   Paused
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.service_description is not None:
            result['ServiceDescription'] = self.service_description
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_ip is not None:
            result['ServiceIp'] = self.service_ip
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_owner_id is not None:
            result['ServiceOwnerId'] = self.service_owner_id
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.service_spec is not None:
            result['ServiceSpec'] = self.service_spec
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ServiceDescription') is not None:
            self.service_description = m.get('ServiceDescription')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServiceIp') is not None:
            self.service_ip = m.get('ServiceIp')
        if m.get('ServiceManaged') is not None:
            self.service_managed = m.get('ServiceManaged')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceOwnerId') is not None:
            self.service_owner_id = m.get('ServiceOwnerId')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('ServiceSpec') is not None:
            self.service_spec = m.get('ServiceSpec')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeStreamingDataServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeStreamingDataServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeStreamingDataServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStreamingDataSourceRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        data_source_id: int = None,
        region_id: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Data source ID.
        # 
        # This parameter is required.
        self.data_source_id = data_source_id
        # Region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) API to view available region IDs.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeStreamingDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        data_source_config: str = None,
        data_source_description: str = None,
        data_source_id: str = None,
        data_source_name: str = None,
        data_source_type: str = None,
        error_message: str = None,
        request_id: str = None,
        service_id: int = None,
        status: str = None,
    ):
        # Creation time.
        self.create_time = create_time
        # Data source configuration information.
        self.data_source_config = data_source_config
        # Data source description.
        self.data_source_description = data_source_description
        # Data source ID.
        self.data_source_id = data_source_id
        # Data source name.
        self.data_source_name = data_source_name
        # Data source type, values include:
        #  -  kafka
        self.data_source_type = data_source_type
        # Service status message, for example, in case of an exception, it will show the reason for the exception. In normal Running state, this value is empty.
        self.error_message = error_message
        # Request ID.
        self.request_id = request_id
        # External data service ID.
        self.service_id = service_id
        # Service status:
        # 
        # - Initializing init
        # 
        # - Running running
        # 
        # - Exception exception
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_source_config is not None:
            result['DataSourceConfig'] = self.data_source_config
        if self.data_source_description is not None:
            result['DataSourceDescription'] = self.data_source_description
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSourceConfig') is not None:
            self.data_source_config = m.get('DataSourceConfig')
        if m.get('DataSourceDescription') is not None:
            self.data_source_description = m.get('DataSourceDescription')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeStreamingDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeStreamingDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeStreamingDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStreamingJobRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        job_id: int = None,
        region_id: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # Job ID.
        # 
        # This parameter is required.
        self.job_id = job_id
        # Region ID.
        # 
        # > You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) interface to view available region IDs.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeStreamingJobResponseBody(TeaModel):
    def __init__(
        self,
        account: str = None,
        consistency: str = None,
        create_time: str = None,
        data_source_id: str = None,
        data_source_name: str = None,
        dest_columns: List[str] = None,
        dest_database: str = None,
        dest_schema: str = None,
        dest_table: str = None,
        error_limit_count: int = None,
        error_message: str = None,
        fallback_offset: str = None,
        group_name: str = None,
        job_config: str = None,
        job_description: str = None,
        job_id: str = None,
        job_name: str = None,
        match_columns: List[str] = None,
        mode: str = None,
        modify_time: str = None,
        password: str = None,
        request_id: str = None,
        src_columns: List[str] = None,
        status: str = None,
        update_columns: List[str] = None,
        write_mode: str = None,
    ):
        # Target database account.
        self.account = account
        # Delivery guarantee.
        self.consistency = consistency
        # Creation time.
        # 
        # Use the UTC time format: yyyy-MM-ddTHH:mm:ssZ
        self.create_time = create_time
        # Data source ID.
        self.data_source_id = data_source_id
        # Data source name.
        self.data_source_name = data_source_name
        # Target data table mapping field list.
        self.dest_columns = dest_columns
        # Target database name.
        self.dest_database = dest_database
        # Target namespace.
        self.dest_schema = dest_schema
        # Target table name.
        self.dest_table = dest_table
        # When data in Kafka does not match the ADBPG target table, it can cause write failures. This value represents the number of error rows allowed; if exceeded, the task will fail.
        self.error_limit_count = error_limit_count
        # Service status information, such as the reason for an exception. It is empty in the normal Running state.
        self.error_message = error_message
        # Fallback offset, which is the fallback position
        # 
        # - The FallbackOffset parameter defines the behavior when the consumer has not requested a specific offset to consume or the requested offset exceeds the current record\\"s offset information in the Kafka cluster. You can choose to start consuming from the earliest (newest) or latest (oldest) offset.
        self.fallback_offset = fallback_offset
        # Kafka group name
        self.group_name = group_name
        # Job configuration file.
        self.job_config = job_config
        # Job description.
        self.job_description = job_description
        # Job ID.
        self.job_id = job_id
        # Job name.
        self.job_name = job_name
        # Match columns, usually all primary key columns of the target table. If all column values in this configuration are the same, the two rows of data are considered duplicates.
        self.match_columns = match_columns
        # Configuration mode
        # 1. Basic mode requires specifying some configuration fields
        # 1. Professional mode supports submitting YAML files
        self.mode = mode
        # Last modified time.
        # 
        # Use the UTC time format: yyyy-MM-ddTHH:mm:ssZ
        self.modify_time = modify_time
        # Target database password.
        self.password = password
        # Request ID.
        self.request_id = request_id
        # Source field list.
        self.src_columns = src_columns
        # Service status, with possible values:
        # 
        # - Init: Initializing
        # 
        # - Running: Running
        # 
        # - Exception: Exception
        # 
        # - Paused: Paused
        self.status = status
        # Update columns, usually all non-primary key columns of the target table. When data duplication is determined through MatchColumns, updating the UpdateColumns column values will result in new data overwriting old data.
        self.update_columns = update_columns
        # Write mode.
        self.write_mode = write_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.consistency is not None:
            result['Consistency'] = self.consistency
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.data_source_name is not None:
            result['DataSourceName'] = self.data_source_name
        if self.dest_columns is not None:
            result['DestColumns'] = self.dest_columns
        if self.dest_database is not None:
            result['DestDatabase'] = self.dest_database
        if self.dest_schema is not None:
            result['DestSchema'] = self.dest_schema
        if self.dest_table is not None:
            result['DestTable'] = self.dest_table
        if self.error_limit_count is not None:
            result['ErrorLimitCount'] = self.error_limit_count
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.fallback_offset is not None:
            result['FallbackOffset'] = self.fallback_offset
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.job_config is not None:
            result['JobConfig'] = self.job_config
        if self.job_description is not None:
            result['JobDescription'] = self.job_description
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.match_columns is not None:
            result['MatchColumns'] = self.match_columns
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.password is not None:
            result['Password'] = self.password
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.src_columns is not None:
            result['SrcColumns'] = self.src_columns
        if self.status is not None:
            result['Status'] = self.status
        if self.update_columns is not None:
            result['UpdateColumns'] = self.update_columns
        if self.write_mode is not None:
            result['WriteMode'] = self.write_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('Consistency') is not None:
            self.consistency = m.get('Consistency')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DataSourceName') is not None:
            self.data_source_name = m.get('DataSourceName')
        if m.get('DestColumns') is not None:
            self.dest_columns = m.get('DestColumns')
        if m.get('DestDatabase') is not None:
            self.dest_database = m.get('DestDatabase')
        if m.get('DestSchema') is not None:
            self.dest_schema = m.get('DestSchema')
        if m.get('DestTable') is not None:
            self.dest_table = m.get('DestTable')
        if m.get('ErrorLimitCount') is not None:
            self.error_limit_count = m.get('ErrorLimitCount')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FallbackOffset') is not None:
            self.fallback_offset = m.get('FallbackOffset')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('JobConfig') is not None:
            self.job_config = m.get('JobConfig')
        if m.get('JobDescription') is not None:
            self.job_description = m.get('JobDescription')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('MatchColumns') is not None:
            self.match_columns = m.get('MatchColumns')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SrcColumns') is not None:
            self.src_columns = m.get('SrcColumns')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateColumns') is not None:
            self.update_columns = m.get('UpdateColumns')
        if m.get('WriteMode') is not None:
            self.write_mode = m.get('WriteMode')
        return self


class DescribeStreamingJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeStreamingJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeStreamingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSupportFeaturesRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the instance IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeSupportFeaturesResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
        support_feature_list: str = None,
    ):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id
        # The ID of the request.
        self.request_id = request_id
        # The features supported by the instance. Valid values:
        # 
        # *   sample_data: sample dataset. For more information, see [Sample dataset](https://help.aliyun.com/document_detail/452278.html).
        # *   diagnose_and_optimize: diagnostics and optimization. For more information, see [Diagnostics and optimization](https://help.aliyun.com/document_detail/323453.html).
        self.support_feature_list = support_feature_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_feature_list is not None:
            result['SupportFeatureList'] = self.support_feature_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportFeatureList') is not None:
            self.support_feature_list = m.get('SupportFeatureList')
        return self


class DescribeSupportFeaturesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSupportFeaturesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSupportFeaturesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTableRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        owner_id: int = None,
        region_id: str = None,
        schema: str = None,
        secret_arn: str = None,
        table: str = None,
        workspace_id: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.database = database
        self.owner_id = owner_id
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The name of the schema to which the table belongs.
        # 
        # This parameter is required.
        self.schema = schema
        # The Alibaba Cloud Resource Name (ARN) of the access credential for the created Data API account. You can call the CreateSecret operation to create an access credential.
        # 
        # >  To call the DescribeTable operation as a Resource Access Management (RAM) user, the RAM user must have the permissions to call the UseSecret or GetSecretValue operation on the ARN of the access credential.
        # 
        # This parameter is required.
        self.secret_arn = secret_arn
        # The name of the table.
        # 
        # This parameter is required.
        self.table = table
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.secret_arn is not None:
            result['SecretArn'] = self.secret_arn
        if self.table is not None:
            result['Table'] = self.table
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('SecretArn') is not None:
            self.secret_arn = m.get('SecretArn')
        if m.get('Table') is not None:
            self.table = m.get('Table')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DescribeTableResponseBodyColumnList(TeaModel):
    def __init__(
        self,
        column_list: List[ColumnMetadata] = None,
    ):
        self.column_list = column_list

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = ColumnMetadata()
                self.column_list.append(temp_model.from_map(k))
        return self


class DescribeTableResponseBody(TeaModel):
    def __init__(
        self,
        column_list: DescribeTableResponseBodyColumnList = None,
        message: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The columns of the table.
        self.column_list = column_list
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The status of the operation. Valid values:
        # 
        # *   **success**\
        # *   **fail**\
        self.status = status

    def validate(self):
        if self.column_list:
            self.column_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_list is not None:
            result['ColumnList'] = self.column_list.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnList') is not None:
            temp_model = DescribeTableResponseBodyColumnList()
            self.column_list = temp_model.from_map(m['ColumnList'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeTableResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTagsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        resource_type: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The ID of the region.
        # 
        # >  You can call the [DescribeRegions](https://help.aliyun.com/document_detail/86912.html) operation to query the most recent region list.
        # 
        # This parameter is required.
        self.region_id = region_id
        # This parameter is no longer used.
        self.resource_group_id = resource_group_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        # The type of the resource. Set the value to **instance**.
        # 
        # This parameter is required.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class DescribeTagsResponseBodyTags(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tags: List[DescribeTagsResponseBodyTags] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The queried tags.
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeTagsResponseBodyTags()
                self.tags.append(temp_model.from_map(k))
        return self


class DescribeTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeTagsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserEncryptionKeyListRequest(TeaModel):
    def __init__(
        self,
        page_number: str = None,
        page_size: str = None,
        region_id: str = None,
    ):
        # The number of the page to return. Default value: 1.
        self.page_number = page_number
        # The number of KMS keys to return on each page. Default value: 10.
        self.page_size = page_size
        # The ID of the region.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeUserEncryptionKeyListResponseBodyKmsKeys(TeaModel):
    def __init__(
        self,
        key_id: str = None,
    ):
        # The ID of the KMS key.
        self.key_id = key_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_id is not None:
            result['KeyId'] = self.key_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyId') is not None:
            self.key_id = m.get('KeyId')
        return self


class DescribeUserEncryptionKeyListResponseBody(TeaModel):
    def __init__(
        self,
        kms_keys: List[DescribeUserEncryptionKeyListResponseBodyKmsKeys] = None,
        request_id: str = None,
    ):
        # Details about the KMS keys.
        self.kms_keys = kms_keys
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.kms_keys:
            for k in self.kms_keys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KmsKeys'] = []
        if self.kms_keys is not None:
            for k in self.kms_keys:
                result['KmsKeys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.kms_keys = []
        if m.get('KmsKeys') is not None:
            for k in m.get('KmsKeys'):
                temp_model = DescribeUserEncryptionKeyListResponseBodyKmsKeys()
                self.kms_keys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeUserEncryptionKeyListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeUserEncryptionKeyListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeUserEncryptionKeyListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWaitingSQLInfoRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        pid: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the instance IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.database = database
        # The ID of the process that uniquely identifies the query.
        # 
        # >  You can call the [DescribeWaitingSQLRecords](https://help.aliyun.com/document_detail/461735.html) operation to obtain the process IDs of lock-waiting queries.
        # 
        # This parameter is required.
        self.pid = pid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.pid is not None:
            result['PID'] = self.pid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('PID') is not None:
            self.pid = m.get('PID')
        return self


class DescribeWaitingSQLInfoResponseBodyItems(TeaModel):
    def __init__(
        self,
        application: str = None,
        blocked_by_application: str = None,
        blocked_by_pid: str = None,
        blocked_by_sqlstmt: str = None,
        blocked_by_user: str = None,
        grant_locks: str = None,
        not_grant_locks: str = None,
        pid: str = None,
        sqlstmt: str = None,
        user: str = None,
    ):
        # The application that sent the query.
        self.application = application
        # The application that sent the blocking query.
        self.blocked_by_application = blocked_by_application
        # The process ID of the blocking query.
        self.blocked_by_pid = blocked_by_pid
        # The SQL statement of the blocking query.
        self.blocked_by_sqlstmt = blocked_by_sqlstmt
        # The database account that is used to perform the blocking query.
        self.blocked_by_user = blocked_by_user
        # The authorized locks.
        self.grant_locks = grant_locks
        # The unauthorized locks.
        self.not_grant_locks = not_grant_locks
        # The ID of the process that uniquely identifies the query.
        self.pid = pid
        # The SQL statement of the query.
        self.sqlstmt = sqlstmt
        # The database account that is used to perform the query.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application is not None:
            result['Application'] = self.application
        if self.blocked_by_application is not None:
            result['BlockedByApplication'] = self.blocked_by_application
        if self.blocked_by_pid is not None:
            result['BlockedByPID'] = self.blocked_by_pid
        if self.blocked_by_sqlstmt is not None:
            result['BlockedBySQLStmt'] = self.blocked_by_sqlstmt
        if self.blocked_by_user is not None:
            result['BlockedByUser'] = self.blocked_by_user
        if self.grant_locks is not None:
            result['GrantLocks'] = self.grant_locks
        if self.not_grant_locks is not None:
            result['NotGrantLocks'] = self.not_grant_locks
        if self.pid is not None:
            result['PID'] = self.pid
        if self.sqlstmt is not None:
            result['SQLStmt'] = self.sqlstmt
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('BlockedByApplication') is not None:
            self.blocked_by_application = m.get('BlockedByApplication')
        if m.get('BlockedByPID') is not None:
            self.blocked_by_pid = m.get('BlockedByPID')
        if m.get('BlockedBySQLStmt') is not None:
            self.blocked_by_sqlstmt = m.get('BlockedBySQLStmt')
        if m.get('BlockedByUser') is not None:
            self.blocked_by_user = m.get('BlockedByUser')
        if m.get('GrantLocks') is not None:
            self.grant_locks = m.get('GrantLocks')
        if m.get('NotGrantLocks') is not None:
            self.not_grant_locks = m.get('NotGrantLocks')
        if m.get('PID') is not None:
            self.pid = m.get('PID')
        if m.get('SQLStmt') is not None:
            self.sqlstmt = m.get('SQLStmt')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeWaitingSQLInfoResponseBody(TeaModel):
    def __init__(
        self,
        database: str = None,
        items: List[DescribeWaitingSQLInfoResponseBodyItems] = None,
        request_id: str = None,
    ):
        # The name of the database.
        self.database = database
        # The queried lock-waiting query.
        self.items = items
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeWaitingSQLInfoResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeWaitingSQLInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeWaitingSQLInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeWaitingSQLInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWaitingSQLRecordsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        keyword: str = None,
        order: str = None,
        page_number: int = None,
        page_size: int = None,
        query_condition: str = None,
        start_time: str = None,
        user: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the instance IDs of all AnalyticDB for PostgreSQL instances in a specific region.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.database = database
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC. The end time must be later than the start time.
        # 
        # If this parameter is not specified, all lock diagnostics records that are generated after the query start time are returned. If the query start time is not specified either, all lock diagnostics records are returned.
        self.end_time = end_time
        # The keyword used to filter queries.
        self.keyword = keyword
        # The field used to sort lock diagnostics records and the sorting order.
        # 
        # Default value: `{"Field":"StartTime","Type":"Desc"}`, which indicates that lock diagnostics records are sorted by the start time in descending order. No other values are supported.
        self.order = order
        # The number of the page to return. The value must be an integer that is greater than 0. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size
        # The filter condition on queries. Valid values:
        # 
        # *   `{"Type":"maxCost","Value":"10"}`: filters the top 10 longest-waiting queries.
        # *   `{"Type":"status","Value":"LockWaiting"}`: filters lock-waiting queries.
        # *   `{"Type":"status","Value":"ResourceWaiting"}`: filters resource-waiting queries.
        # 
        # This parameter is required.
        self.query_condition = query_condition
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        # 
        # If this parameter is not specified, all lock diagnostics records that are generated before the query end time are returned. If the query end time is not specified either, all lock diagnostics records are returned.
        self.start_time = start_time
        # The name of the database account. If this parameter is not specified, the lock diagnostics records of all database accounts are queried.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.order is not None:
            result['Order'] = self.order
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_condition is not None:
            result['QueryCondition'] = self.query_condition
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryCondition') is not None:
            self.query_condition = m.get('QueryCondition')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeWaitingSQLRecordsResponseBodyItems(TeaModel):
    def __init__(
        self,
        database: str = None,
        pid: str = None,
        sqlstmt: str = None,
        session_id: str = None,
        start_time: int = None,
        status: str = None,
        user: str = None,
        waiting_time: int = None,
    ):
        # The name of the database.
        self.database = database
        # The ID of the process that uniquely identifies the query.
        self.pid = pid
        # The SQL statement of the query.
        self.sqlstmt = sqlstmt
        # The ID of the session that contains the query.
        self.session_id = session_id
        # The start time of the query. This value is in the timestamp format. Unit: milliseconds.
        self.start_time = start_time
        # The waiting state of the query. Valid values:
        # 
        # *   **LockWaiting**\
        # *   **ResourceWaiting**\
        self.status = status
        # The database account that is used to perform the query.
        self.user = user
        # The waiting period of the query. Unit: milliseconds.
        self.waiting_time = waiting_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.pid is not None:
            result['PID'] = self.pid
        if self.sqlstmt is not None:
            result['SQLStmt'] = self.sqlstmt
        if self.session_id is not None:
            result['SessionID'] = self.session_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.user is not None:
            result['User'] = self.user
        if self.waiting_time is not None:
            result['WaitingTime'] = self.waiting_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('PID') is not None:
            self.pid = m.get('PID')
        if m.get('SQLStmt') is not None:
            self.sqlstmt = m.get('SQLStmt')
        if m.get('SessionID') is not None:
            self.session_id = m.get('SessionID')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('WaitingTime') is not None:
            self.waiting_time = m.get('WaitingTime')
        return self


class DescribeWaitingSQLRecordsResponseBody(TeaModel):
    def __init__(
        self,
        items: List[DescribeWaitingSQLRecordsResponseBodyItems] = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The list of lock diagnostics records.
        self.items = items
        # The page number of the returned page.
        self.page_number = page_number
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeWaitingSQLRecordsResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeWaitingSQLRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeWaitingSQLRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeWaitingSQLRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDBResourceGroupRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DisableDBResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableDBResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableDBResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableDBResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadDiagnosisRecordsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        lang: str = None,
        query_condition: str = None,
        resource_group_id: str = None,
        start_time: str = None,
        user: str = None,
    ):
        # The ID of the instance.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the details of all AnalyticDB for PostgreSQL instances in a specific region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.database = database
        # The end of the time range to query. Specify the time in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.end_time = end_time
        # The language of the file that contains the query diagnostic information. Valid values:
        # 
        # *   **zh**: simplified Chinese
        # *   **en**: English
        # *   **ja**: Japanese
        # *   **zh-tw**: traditional Chinese
        self.lang = lang
        # The filter condition on queries. The value is in the JSON format. Valid values:
        # 
        # *   `{"Type":"maxCost", "Value":"100"}`: filters the top 100 queries that are the most time-consuming.
        # *   `{"Type":"status","Value":"finished"}`: filters completed queries.
        # *   `{"Type":"status","Value":"running"}`: filters running queries.
        # *   `{"Type":"cost","Max":"200"}`: filters the queries that consume less than 200 milliseconds.
        # *   `{"Type":"cost","Min":"200","Max":"60000"}`: filters the queries that consume 200 milliseconds or more and less than 1 minute.
        # *   `{"Type":"cost","Min":"60000"}`: filters the queries that consume 1 minute or more.
        # *   `{"Type":"cost","Min":"30","Max":"50"}`: filters the queries that consume 30 milliseconds or more and less than 50 milliseconds. You can customize a filter condition by setting **Min** and **Max**.
        self.query_condition = query_condition
        # The ID of the resource group to which the instance belongs. For more information about how to obtain the ID of a resource group, see [View basic information of a resource group](https://help.aliyun.com/document_detail/151181.html).
        self.resource_group_id = resource_group_id
        # The beginning of the time range to query. Specify the time in the *yyyy-MM-dd*T*HH:mm*Z format. The time must be in UTC.
        self.start_time = start_time
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.query_condition is not None:
            result['QueryCondition'] = self.query_condition
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('QueryCondition') is not None:
            self.query_condition = m.get('QueryCondition')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DownloadDiagnosisRecordsResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        download_id: str = None,
        request_id: str = None,
    ):
        # The ID of the instance.
        self.dbinstance_id = dbinstance_id
        # The ID of the download task.
        self.download_id = download_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.download_id is not None:
            result['DownloadId'] = self.download_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DownloadId') is not None:
            self.download_id = m.get('DownloadId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DownloadDiagnosisRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DownloadDiagnosisRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DownloadDiagnosisRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadSQLLogsRecordsRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        end_time: str = None,
        execute_cost: str = None,
        execute_state: str = None,
        lang: str = None,
        max_execute_cost: str = None,
        min_execute_cost: str = None,
        operation_class: str = None,
        operation_type: str = None,
        page_number: int = None,
        page_size: int = None,
        query_keywords: str = None,
        source_ip: str = None,
        start_time: str = None,
        user: str = None,
    ):
        # The instance ID.
        # 
        # > You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        self.database = database
        # The end of the time range to query. Specify the time in the yyyy-MM-ddTHH:mm:ssZ format. The end time must be later than the start time.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The execution duration of the SQL statement. Unit: seconds.
        self.execute_cost = execute_cost
        # The execution status of the SQL statement.
        # 
        # *   **1**: successful.
        # *   **0**: failed.
        self.execute_state = execute_state
        # The language of the file that contains the query diagnostic information. Valid values:
        # 
        # *   **zh**: simplified Chinese.
        # *   **en**: English.
        # *   **ja**: Japanese.
        # *   **zh-tw**: traditional Chinese.
        self.lang = lang
        # The maximum amount of time consumed by a slow query. Unit: seconds. Minimum value: 0.
        self.max_execute_cost = max_execute_cost
        # The minimum amount of time consumed by a slow query. Unit: seconds. Minimum value: 0.
        self.min_execute_cost = min_execute_cost
        # The type of the query language. Example: DQL, DML, or DDL.
        self.operation_class = operation_class
        # The type of the SQL statement. Example: SELECT.
        self.operation_type = operation_type
        # The page number. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Valid values:
        # 
        # *   **30**\
        # *   **50**\
        # *   **100**\
        # 
        # Default value: **30**.
        self.page_size = page_size
        # The keywords that are used for query.
        self.query_keywords = query_keywords
        # The source IP address.
        self.source_ip = source_ip
        # The beginning of the time range to query. Specify the time in the yyyy-MM-ddTHH:mmZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The name of the database account.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.execute_cost is not None:
            result['ExecuteCost'] = self.execute_cost
        if self.execute_state is not None:
            result['ExecuteState'] = self.execute_state
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.max_execute_cost is not None:
            result['MaxExecuteCost'] = self.max_execute_cost
        if self.min_execute_cost is not None:
            result['MinExecuteCost'] = self.min_execute_cost
        if self.operation_class is not None:
            result['OperationClass'] = self.operation_class
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_keywords is not None:
            result['QueryKeywords'] = self.query_keywords
        if self.source_ip is not None:
            result['SourceIP'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExecuteCost') is not None:
            self.execute_cost = m.get('ExecuteCost')
        if m.get('ExecuteState') is not None:
            self.execute_state = m.get('ExecuteState')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MaxExecuteCost') is not None:
            self.max_execute_cost = m.get('MaxExecuteCost')
        if m.get('MinExecuteCost') is not None:
            self.min_execute_cost = m.get('MinExecuteCost')
        if m.get('OperationClass') is not None:
            self.operation_class = m.get('OperationClass')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryKeywords') is not None:
            self.query_keywords = m.get('QueryKeywords')
        if m.get('SourceIP') is not None:
            self.source_ip = m.get('SourceIP')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DownloadSQLLogsRecordsResponseBody(TeaModel):
    def __init__(
        self,
        download_id: int = None,
        request_id: str = None,
    ):
        # The ID of the download task.
        self.download_id = download_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_id is not None:
            result['DownloadId'] = self.download_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadId') is not None:
            self.download_id = m.get('DownloadId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DownloadSQLLogsRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DownloadSQLLogsRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DownloadSQLLogsRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDBResourceGroupRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        owner_id: int = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        # 
        # This parameter is required.
        self.dbinstance_id = dbinstance_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class EnableDBResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableDBResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableDBResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableDBResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExecuteStatementRequestRagWorkspaceCollection(TeaModel):
    def __init__(
        self,
        collection: str = None,
        namespace: str = None,
    ):
        self.collection = collection
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection is not None:
            result['Collection'] = self.collection
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collection') is not None:
            self.collection = m.get('Collection')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class ExecuteStatementRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        database: str = None,
        owner_id: int = None,
        parameters: List[Any] = None,
        rag_workspace_collection: ExecuteStatementRequestRagWorkspaceCollection = None,
        region_id: str = None,
        run_type: str = None,
        secret_arn: str = None,
        sql: str = None,
        sqls: List[str] = None,
        statement_name: str = None,
        workspace_id: str = None,
    ):
        # The instance ID.
        # 
        # >  You can call the [DescribeDBInstances](https://help.aliyun.com/document_detail/86911.html) operation to query the information about all AnalyticDB for PostgreSQL instances within a region, including instance IDs.
        self.dbinstance_id = dbinstance_id
        # The name of the database.
        # 
        # This parameter is required.
        self.database = database
        self.owner_id = owner_id
        # The configuration parameters.
        self.parameters = parameters
        self.rag_workspace_collection = rag_workspace_collection
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The execution type. Valid values:
        # 
        # *   synchronous
        # *   asynchronous (not supported)
        self.run_type = run_type
        # The Alibaba Cloud Resource Name (ARN) of the access credential for the created Data API account. You can call the CreateSecret operation to create an access credential.
        # 
        # >  To call the ExecuteStatement operation as a Resource Access Management (RAM) user, the RAM user must have the permissions to call the UseSecret or GetSecretValue operation on the ARN of the access credential.
        # 
        # This parameter is required.
        self.secret_arn = secret_arn
        # The SQL statements that you want to execute.
        self.sql = sql
        # The SQL statements.
        self.sqls = sqls
        # The name of the set of SQL statements that you want to execute. This parameter takes effect when the RunType parameter is set to asynchronous.
        self.statement_name = statement_name
        self.workspace_id = workspace_id

    def validate(self):
        if self.rag_workspace_collection:
            self.rag_workspace_collection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.database is not None:
            result['Database'] = self.database
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.parameters is not None:
            result['Parameters'] = self.parameters
        if self.rag_workspace_collection is not None:
            result['RagWorkspaceCollection'] = self.rag_workspace_collection.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.run_type is not None:
            result['RunType'] = self.run_type
        if self.secret_arn is not None:
            result['SecretArn'] = self.secret_arn
        if self.sql is not None:
            result['Sql'] = self.sql
        if self.sqls is not None:
            result['Sqls'] = self.sqls
        if self.statement_name is not None:
            result['StatementName'] = self.statement_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Parameters') is not None:
            self.parameters = m.get('Parameters')
        if m.get('RagWorkspaceCollection') is not None:
            temp_model = ExecuteStatementRequestRagWorkspaceCollection()
            self.rag_workspace_collection = temp_model.from_map(m['RagWorkspaceCollection'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RunType') is not None:
            self.run_type = m.get('RunType')
        if m.get('SecretArn') is not None:
            self.secret_arn = m.get('SecretArn')
        if m.