# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NotificationAlertsConfigArgs', 'NotificationAlertsConfig']

@pulumi.input_type
class NotificationAlertsConfigArgs:
    def __init__(__self__, *,
                 alert_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 silenced: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a NotificationAlertsConfig resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] alert_labels: Labels to add to alerts generated by this configuration.
        :param pulumi.Input[_builtins.str] duration: Duration for which the condition must be true before firing (e.g., '5m', '30s'). Maps to 'for' in Asserts API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_labels: Labels to match for this alert configuration.
        :param pulumi.Input[_builtins.str] name: The name of the alert configuration.
        :param pulumi.Input[_builtins.bool] silenced: Whether this alert configuration is silenced. Defaults to `false`.
        """
        if alert_labels is not None:
            pulumi.set(__self__, "alert_labels", alert_labels)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if match_labels is not None:
            pulumi.set(__self__, "match_labels", match_labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if silenced is not None:
            pulumi.set(__self__, "silenced", silenced)

    @_builtins.property
    @pulumi.getter(name="alertLabels")
    def alert_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to add to alerts generated by this configuration.
        """
        return pulumi.get(self, "alert_labels")

    @alert_labels.setter
    def alert_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alert_labels", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Duration for which the condition must be true before firing (e.g., '5m', '30s'). Maps to 'for' in Asserts API.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="matchLabels")
    def match_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to match for this alert configuration.
        """
        return pulumi.get(self, "match_labels")

    @match_labels.setter
    def match_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the alert configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def silenced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this alert configuration is silenced. Defaults to `false`.
        """
        return pulumi.get(self, "silenced")

    @silenced.setter
    def silenced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "silenced", value)


@pulumi.input_type
class _NotificationAlertsConfigState:
    def __init__(__self__, *,
                 alert_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 silenced: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering NotificationAlertsConfig resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] alert_labels: Labels to add to alerts generated by this configuration.
        :param pulumi.Input[_builtins.str] duration: Duration for which the condition must be true before firing (e.g., '5m', '30s'). Maps to 'for' in Asserts API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_labels: Labels to match for this alert configuration.
        :param pulumi.Input[_builtins.str] name: The name of the alert configuration.
        :param pulumi.Input[_builtins.bool] silenced: Whether this alert configuration is silenced. Defaults to `false`.
        """
        if alert_labels is not None:
            pulumi.set(__self__, "alert_labels", alert_labels)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if match_labels is not None:
            pulumi.set(__self__, "match_labels", match_labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if silenced is not None:
            pulumi.set(__self__, "silenced", silenced)

    @_builtins.property
    @pulumi.getter(name="alertLabels")
    def alert_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to add to alerts generated by this configuration.
        """
        return pulumi.get(self, "alert_labels")

    @alert_labels.setter
    def alert_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alert_labels", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Duration for which the condition must be true before firing (e.g., '5m', '30s'). Maps to 'for' in Asserts API.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="matchLabels")
    def match_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to match for this alert configuration.
        """
        return pulumi.get(self, "match_labels")

    @match_labels.setter
    def match_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the alert configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def silenced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this alert configuration is silenced. Defaults to `false`.
        """
        return pulumi.get(self, "silenced")

    @silenced.setter
    def silenced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "silenced", value)


@pulumi.type_token("grafana:assert/notificationAlertsConfig:NotificationAlertsConfig")
class NotificationAlertsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 silenced: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages Asserts Alert Configurations through Grafana API.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        # Basic alert configuration with silencing
        prometheus_remote_storage_failures = grafana.assert_.NotificationAlertsConfig("prometheus_remote_storage_failures",
            name="PrometheusRemoteStorageFailures",
            match_labels={
                "alertname": "PrometheusRemoteStorageFailures",
                "alertgroup": "prometheus.alerts",
                "asserts_env": "prod",
            },
            silenced=True)
        # High severity alert with specific job and context matching
        error_buildup_notify = grafana.assert_.NotificationAlertsConfig("error_buildup_notify",
            name="ErrorBuildupNotify",
            match_labels={
                "alertname": "ErrorBuildup",
                "job": "acai",
                "asserts_request_type": "inbound",
                "asserts_request_context": "/auth",
            },
            silenced=False)
        # Alert with additional labels and custom duration
        payment_test_alert = grafana.assert_.NotificationAlertsConfig("payment_test_alert",
            name="PaymentTestAlert",
            match_labels={
                "alertname": "PaymentTestAlert",
                "additional_labels": "asserts_severity=~\\"critical\\"",
                "alertgroup": "alex-k8s-integration-test.alerts",
            },
            alert_labels={
                "testing": "onetwothree",
            },
            duration="5m",
            silenced=False)
        # Latency alert for shipping service
        high_shipping_latency = grafana.assert_.NotificationAlertsConfig("high_shipping_latency",
            name="high shipping latency",
            match_labels={
                "alertname": "LatencyP99ErrorBuildup",
                "job": "shipping",
                "asserts_request_type": "inbound",
            },
            silenced=False)
        # CPU throttling alert with warning severity
        cpu_throttling_sustained = grafana.assert_.NotificationAlertsConfig("cpu_throttling_sustained",
            name="CPUThrottlingSustained",
            match_labels={
                "alertname": "CPUThrottlingSustained",
                "additional_labels": "asserts_severity=~\\"warning\\"",
            },
            silenced=True)
        # Ingress error rate alert
        ingress_error = grafana.assert_.NotificationAlertsConfig("ingress_error",
            name="ingress error",
            match_labels={
                "alertname": "ErrorRatioBreach",
                "job": "ingress-nginx-controller-metrics",
                "asserts_request_type": "inbound",
            },
            silenced=False)
        # MySQL Galera cluster alert
        mysql_galera_not_ready = grafana.assert_.NotificationAlertsConfig("mysql_galera_not_ready",
            name="MySQLGaleraNotReady",
            match_labels={
                "alertname": "MySQLGaleraNotReady",
            },
            silenced=False)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:assert/notificationAlertsConfig:NotificationAlertsConfig name "{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] alert_labels: Labels to add to alerts generated by this configuration.
        :param pulumi.Input[_builtins.str] duration: Duration for which the condition must be true before firing (e.g., '5m', '30s'). Maps to 'for' in Asserts API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_labels: Labels to match for this alert configuration.
        :param pulumi.Input[_builtins.str] name: The name of the alert configuration.
        :param pulumi.Input[_builtins.bool] silenced: Whether this alert configuration is silenced. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NotificationAlertsConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Asserts Alert Configurations through Grafana API.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        # Basic alert configuration with silencing
        prometheus_remote_storage_failures = grafana.assert_.NotificationAlertsConfig("prometheus_remote_storage_failures",
            name="PrometheusRemoteStorageFailures",
            match_labels={
                "alertname": "PrometheusRemoteStorageFailures",
                "alertgroup": "prometheus.alerts",
                "asserts_env": "prod",
            },
            silenced=True)
        # High severity alert with specific job and context matching
        error_buildup_notify = grafana.assert_.NotificationAlertsConfig("error_buildup_notify",
            name="ErrorBuildupNotify",
            match_labels={
                "alertname": "ErrorBuildup",
                "job": "acai",
                "asserts_request_type": "inbound",
                "asserts_request_context": "/auth",
            },
            silenced=False)
        # Alert with additional labels and custom duration
        payment_test_alert = grafana.assert_.NotificationAlertsConfig("payment_test_alert",
            name="PaymentTestAlert",
            match_labels={
                "alertname": "PaymentTestAlert",
                "additional_labels": "asserts_severity=~\\"critical\\"",
                "alertgroup": "alex-k8s-integration-test.alerts",
            },
            alert_labels={
                "testing": "onetwothree",
            },
            duration="5m",
            silenced=False)
        # Latency alert for shipping service
        high_shipping_latency = grafana.assert_.NotificationAlertsConfig("high_shipping_latency",
            name="high shipping latency",
            match_labels={
                "alertname": "LatencyP99ErrorBuildup",
                "job": "shipping",
                "asserts_request_type": "inbound",
            },
            silenced=False)
        # CPU throttling alert with warning severity
        cpu_throttling_sustained = grafana.assert_.NotificationAlertsConfig("cpu_throttling_sustained",
            name="CPUThrottlingSustained",
            match_labels={
                "alertname": "CPUThrottlingSustained",
                "additional_labels": "asserts_severity=~\\"warning\\"",
            },
            silenced=True)
        # Ingress error rate alert
        ingress_error = grafana.assert_.NotificationAlertsConfig("ingress_error",
            name="ingress error",
            match_labels={
                "alertname": "ErrorRatioBreach",
                "job": "ingress-nginx-controller-metrics",
                "asserts_request_type": "inbound",
            },
            silenced=False)
        # MySQL Galera cluster alert
        mysql_galera_not_ready = grafana.assert_.NotificationAlertsConfig("mysql_galera_not_ready",
            name="MySQLGaleraNotReady",
            match_labels={
                "alertname": "MySQLGaleraNotReady",
            },
            silenced=False)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:assert/notificationAlertsConfig:NotificationAlertsConfig name "{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param NotificationAlertsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationAlertsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 silenced: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationAlertsConfigArgs.__new__(NotificationAlertsConfigArgs)

            __props__.__dict__["alert_labels"] = alert_labels
            __props__.__dict__["duration"] = duration
            __props__.__dict__["match_labels"] = match_labels
            __props__.__dict__["name"] = name
            __props__.__dict__["silenced"] = silenced
        super(NotificationAlertsConfig, __self__).__init__(
            'grafana:assert/notificationAlertsConfig:NotificationAlertsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            duration: Optional[pulumi.Input[_builtins.str]] = None,
            match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            silenced: Optional[pulumi.Input[_builtins.bool]] = None) -> 'NotificationAlertsConfig':
        """
        Get an existing NotificationAlertsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] alert_labels: Labels to add to alerts generated by this configuration.
        :param pulumi.Input[_builtins.str] duration: Duration for which the condition must be true before firing (e.g., '5m', '30s'). Maps to 'for' in Asserts API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_labels: Labels to match for this alert configuration.
        :param pulumi.Input[_builtins.str] name: The name of the alert configuration.
        :param pulumi.Input[_builtins.bool] silenced: Whether this alert configuration is silenced. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationAlertsConfigState.__new__(_NotificationAlertsConfigState)

        __props__.__dict__["alert_labels"] = alert_labels
        __props__.__dict__["duration"] = duration
        __props__.__dict__["match_labels"] = match_labels
        __props__.__dict__["name"] = name
        __props__.__dict__["silenced"] = silenced
        return NotificationAlertsConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alertLabels")
    def alert_labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels to add to alerts generated by this configuration.
        """
        return pulumi.get(self, "alert_labels")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Duration for which the condition must be true before firing (e.g., '5m', '30s'). Maps to 'for' in Asserts API.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="matchLabels")
    def match_labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels to match for this alert configuration.
        """
        return pulumi.get(self, "match_labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the alert configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def silenced(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this alert configuration is silenced. Defaults to `false`.
        """
        return pulumi.get(self, "silenced")

