# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, created=None, grafana_folder_uid=None, id=None, is_default=None, name=None, updated=None):
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if grafana_folder_uid and not isinstance(grafana_folder_uid, str):
            raise TypeError("Expected argument 'grafana_folder_uid' to be a str")
        pulumi.set(__self__, "grafana_folder_uid", grafana_folder_uid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        pulumi.set(__self__, "updated", updated)

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The date when the project was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="grafanaFolderUid")
    def grafana_folder_uid(self) -> _builtins.str:
        """
        The Grafana folder uid.
        """
        return pulumi.get(self, "grafana_folder_uid")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Numeric identifier of the project.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether this project is the default for running tests when no explicit project identifier is provided.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Human-friendly identifier of the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> _builtins.str:
        """
        The date when the project was last updated.
        """
        return pulumi.get(self, "updated")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            created=self.created,
            grafana_folder_uid=self.grafana_folder_uid,
            id=self.id,
            is_default=self.is_default,
            name=self.name,
            updated=self.updated)


def get_project(id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Retrieves a k6 project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.k6.Project("test", name="Terraform Test Project")
    from_id = grafana.k6.get_project_output(id=test.id)
    ```


    :param _builtins.str id: Numeric identifier of the project.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:k6/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        created=pulumi.get(__ret__, 'created'),
        grafana_folder_uid=pulumi.get(__ret__, 'grafana_folder_uid'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        name=pulumi.get(__ret__, 'name'),
        updated=pulumi.get(__ret__, 'updated'))
def get_project_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Retrieves a k6 project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.k6.Project("test", name="Terraform Test Project")
    from_id = grafana.k6.get_project_output(id=test.id)
    ```


    :param _builtins.str id: Numeric identifier of the project.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:k6/getProject:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        created=pulumi.get(__response__, 'created'),
        grafana_folder_uid=pulumi.get(__response__, 'grafana_folder_uid'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        name=pulumi.get(__response__, 'name'),
        updated=pulumi.get(__response__, 'updated')))
