# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProjectAllowedLoadZonesResult',
    'AwaitableGetProjectAllowedLoadZonesResult',
    'get_project_allowed_load_zones',
    'get_project_allowed_load_zones_output',
]

@pulumi.output_type
class GetProjectAllowedLoadZonesResult:
    """
    A collection of values returned by getProjectAllowedLoadZones.
    """
    def __init__(__self__, allowed_load_zones=None, id=None, project_id=None):
        if allowed_load_zones and not isinstance(allowed_load_zones, list):
            raise TypeError("Expected argument 'allowed_load_zones' to be a list")
        pulumi.set(__self__, "allowed_load_zones", allowed_load_zones)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="allowedLoadZones")
    def allowed_load_zones(self) -> Sequence[_builtins.str]:
        """
        List of allowed private k6 load zone IDs for this project.
        """
        return pulumi.get(self, "allowed_load_zones")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The identifier of the project. This is set to the same as the project_id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The identifier of the project to retrieve private allowed load zones for.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetProjectAllowedLoadZonesResult(GetProjectAllowedLoadZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectAllowedLoadZonesResult(
            allowed_load_zones=self.allowed_load_zones,
            id=self.id,
            project_id=self.project_id)


def get_project_allowed_load_zones(project_id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectAllowedLoadZonesResult:
    """
    Retrieves allowed private load zones for a k6 project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test_project_allowed_load_zones = grafana.k6.Project("test_project_allowed_load_zones", name="Terraform Project Test Allowed Load Zones")
    from_project_id = grafana.k6.get_project_allowed_load_zones_output(project_id=test_project_allowed_load_zones.id)
    ```


    :param _builtins.str project_id: The identifier of the project to retrieve private allowed load zones for.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:k6/getProjectAllowedLoadZones:getProjectAllowedLoadZones', __args__, opts=opts, typ=GetProjectAllowedLoadZonesResult).value

    return AwaitableGetProjectAllowedLoadZonesResult(
        allowed_load_zones=pulumi.get(__ret__, 'allowed_load_zones'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_project_allowed_load_zones_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectAllowedLoadZonesResult]:
    """
    Retrieves allowed private load zones for a k6 project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test_project_allowed_load_zones = grafana.k6.Project("test_project_allowed_load_zones", name="Terraform Project Test Allowed Load Zones")
    from_project_id = grafana.k6.get_project_allowed_load_zones_output(project_id=test_project_allowed_load_zones.id)
    ```


    :param _builtins.str project_id: The identifier of the project to retrieve private allowed load zones for.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:k6/getProjectAllowedLoadZones:getProjectAllowedLoadZones', __args__, opts=opts, typ=GetProjectAllowedLoadZonesResult)
    return __ret__.apply(lambda __response__: GetProjectAllowedLoadZonesResult(
        allowed_load_zones=pulumi.get(__response__, 'allowed_load_zones'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id')))
