# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProjectLimitsResult',
    'AwaitableGetProjectLimitsResult',
    'get_project_limits',
    'get_project_limits_output',
]

@pulumi.output_type
class GetProjectLimitsResult:
    """
    A collection of values returned by getProjectLimits.
    """
    def __init__(__self__, duration_max_per_test=None, id=None, project_id=None, vu_browser_max_per_test=None, vu_max_per_test=None, vuh_max_per_month=None):
        if duration_max_per_test and not isinstance(duration_max_per_test, int):
            raise TypeError("Expected argument 'duration_max_per_test' to be a int")
        pulumi.set(__self__, "duration_max_per_test", duration_max_per_test)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if vu_browser_max_per_test and not isinstance(vu_browser_max_per_test, int):
            raise TypeError("Expected argument 'vu_browser_max_per_test' to be a int")
        pulumi.set(__self__, "vu_browser_max_per_test", vu_browser_max_per_test)
        if vu_max_per_test and not isinstance(vu_max_per_test, int):
            raise TypeError("Expected argument 'vu_max_per_test' to be a int")
        pulumi.set(__self__, "vu_max_per_test", vu_max_per_test)
        if vuh_max_per_month and not isinstance(vuh_max_per_month, int):
            raise TypeError("Expected argument 'vuh_max_per_month' to be a int")
        pulumi.set(__self__, "vuh_max_per_month", vuh_max_per_month)

    @_builtins.property
    @pulumi.getter(name="durationMaxPerTest")
    def duration_max_per_test(self) -> _builtins.int:
        """
        Maximum duration of a test in seconds.
        """
        return pulumi.get(self, "duration_max_per_test")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The identifier of the project limits. This is set to the same as the project_id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The identifier of the project to get limits for.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="vuBrowserMaxPerTest")
    def vu_browser_max_per_test(self) -> _builtins.int:
        """
        Maximum number of concurrent browser virtual users (VUs) used in one test.
        """
        return pulumi.get(self, "vu_browser_max_per_test")

    @_builtins.property
    @pulumi.getter(name="vuMaxPerTest")
    def vu_max_per_test(self) -> _builtins.int:
        """
        Maximum number of concurrent virtual users (VUs) used in one test.
        """
        return pulumi.get(self, "vu_max_per_test")

    @_builtins.property
    @pulumi.getter(name="vuhMaxPerMonth")
    def vuh_max_per_month(self) -> _builtins.int:
        """
        Maximum amount of virtual user hours (VU/h) used per one calendar month.
        """
        return pulumi.get(self, "vuh_max_per_month")


class AwaitableGetProjectLimitsResult(GetProjectLimitsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectLimitsResult(
            duration_max_per_test=self.duration_max_per_test,
            id=self.id,
            project_id=self.project_id,
            vu_browser_max_per_test=self.vu_browser_max_per_test,
            vu_max_per_test=self.vu_max_per_test,
            vuh_max_per_month=self.vuh_max_per_month)


def get_project_limits(project_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectLimitsResult:
    """
    Retrieves a k6 project limits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test_project_limits = grafana.k6.Project("test_project_limits", name="Terraform Project Test Limits")
    from_project_id = grafana.k6.get_project_limits_output(project_id=test_project_limits.id)
    ```


    :param _builtins.str project_id: The identifier of the project to get limits for.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:k6/getProjectLimits:getProjectLimits', __args__, opts=opts, typ=GetProjectLimitsResult).value

    return AwaitableGetProjectLimitsResult(
        duration_max_per_test=pulumi.get(__ret__, 'duration_max_per_test'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        vu_browser_max_per_test=pulumi.get(__ret__, 'vu_browser_max_per_test'),
        vu_max_per_test=pulumi.get(__ret__, 'vu_max_per_test'),
        vuh_max_per_month=pulumi.get(__ret__, 'vuh_max_per_month'))
def get_project_limits_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectLimitsResult]:
    """
    Retrieves a k6 project limits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test_project_limits = grafana.k6.Project("test_project_limits", name="Terraform Project Test Limits")
    from_project_id = grafana.k6.get_project_limits_output(project_id=test_project_limits.id)
    ```


    :param _builtins.str project_id: The identifier of the project to get limits for.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:k6/getProjectLimits:getProjectLimits', __args__, opts=opts, typ=GetProjectLimitsResult)
    return __ret__.apply(lambda __response__: GetProjectLimitsResult(
        duration_max_per_test=pulumi.get(__response__, 'duration_max_per_test'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        vu_browser_max_per_test=pulumi.get(__response__, 'vu_browser_max_per_test'),
        vu_max_per_test=pulumi.get(__response__, 'vu_max_per_test'),
        vuh_max_per_month=pulumi.get(__response__, 'vuh_max_per_month')))
